//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 4 lights, 69 textures and 1752 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.0 (c) 1991-1997 Lutz + Kretzschmar
//

//  Date : 11/30/1997    (30.11.1997)
//


default {
  texture {
    pigment { color rgb <1,1,0> }
    finish { ambient 0.2 diffuse 0.4 phong 0.5 phong_size 20 }
  }
}


/* // Scene Comment

This scene created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}


atmosphere {
  type 1
  //eccentricity .05
  distance     20.0
  color <0,0,0,0.0,0.85>
  scattering   0.3
  samples      20
  jitter       0.1
  aa_threshold 1.0
  aa_level     3.0
}






camera {  //  Camera Camera01
  location  <-14.601, -44.358, 5.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <3.870, -0.553, 4.979>
}





//
// *******  L I G H T S *******
//

light_source {
  <16.2, -.6, 9.08>
  color rgb <.8, .8, .8>
  atmosphere off
}


light_source {   // Spotlight oven_light
  <2.280, 1.480, 2.370>
  color  rgb <1.000, 0, 0>*2
  //spotlight
  //  point_at  <2.280, 0.080, 1.771>
  //  falloff   16.2  // outer radius (in deg)
  //    radius    13.8  // inner radius
  fade_distance  5.0
  fade_power 2.0
  atmospheric_attenuation on
  atmosphere on
}


light_source { // AreaLite Glove
  <-3.418, -24.071, 2.640>
  color  rgb<.6, .6, .6>
  area_light <2.684, -0.013, 0.000>, <-0.001, -0.032, 9.699>, 4, 4
  adaptive 2
  jitter
  fade_distance  3.0
  fade_power 2.0
  atmosphere off
}





/*
light_source {   // Spotlight ligning_light
  <30.722, 20.077, 10.003>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <30.159, 19.278, 9.794>
    falloff   20.20  // outer radius (in deg)
      radius    20.20  // inner radius
  fade_distance  30.0
  fade_power 2.0
 //atmospheric_attenuation on
 atmosphere off
}
*/
/*
light_source {   // Light002
  <-9.208, -17.708, 4.519>
  color rgb <0.7, 0.7, 0.7>
  shadowless
  atmosphere off
}

light_source {   // Light1
  <7.825, -26.082, 4.109>
  color rgb <0.7, 0.7, 0.7>
  shadowless
  atmosphere off
}
*/


/*
light_source {
  //<-10.56, -34.09, 4.52>
//  <-13.56, -34.09, 4.52>
  <-1.418, -24.071, 2.640>
  color rgb <.3, .3, .3>
  //shadowless
  fade_distance  3.0
  fade_power 2

  atmosphere off
}
*/


//  Moray V3.0 (c) 1991-1997 Lutz + Kretzschmar
//

//
// ********  TEXTURES  *******
//

#include "metals.inc"
#include "colors.inc"
#include "woods.inc"
#include "cellar2.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

union {

/*
#declare sky_vect = z
#declare cam_loc = <-14.601, -44.358, 5.000>
#declare lookat = <3.870, -0.553, 4.979>
#declare light_loc = <-2.125708, -21.635324, 4.566959>

#declare flare_scale_factor = .5
#declare flare_amount = .8
#declare spot_fade_amount = .01
#declare flare_brightness = .6
#declare flare_type = "Smallstar"
#include "lnsflare.inc"
*/


#declare Vent_ring = union {
  box { // vent_ring_part
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_par1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_par2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_par3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, 4.0, 10.130247>
}
#declare Vent_ring1 = union {
  box { // vent_ring_par4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_par5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_par6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_par7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, 0.0, 10.130247>
}
#declare Vent_ring2 = union {
  box { // vent_ring_par8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_par9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -4.0, 10.130247>
}
#declare Vent_ring3 = union {
  box { // vent_ring_pa12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -8.0, 10.130247>
}
#declare Vent_ring4 = union {
  box { // vent_ring_pa16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -12.0, 10.130247>
}
#declare Vent_ring5 = union {
  box { // vent_ring_pa20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -16.0, 10.130247>
}
#declare Vent_ring6 = union {
  box { // vent_ring_pa24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa25
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa26
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa27
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -20.0, 10.130247>
}
#declare Vent_ring7 = union {
  box { // vent_ring_pa28
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa29
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa30
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa31
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -24.0, 10.130247>
}
#declare Vent_ring8 = union {
  box { // vent_ring_pa32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  translate  <-5.208654, -28.0, 10.130247>
}
#declare Vent_ring9 = union {
  box { // vent_ring_pa36
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  0.7*x
  }
  box { // vent_ring_pa37
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate -45.0*z
    translate  -0.7*x
  }
  box { // vent_ring_pa38
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  -0.7*z
  }
  box { // vent_ring_pa39
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.05, 0.77>
    rotate <90.0, -45.0, -90.0>
    translate  0.7*z
  }
  texture {
    nonref_silver2
  }
  rotate -90.0*z
  translate  <-7.00106, 4.983929, 10.119331>
}
union { // vent_rings
  object { Vent_ring }
  object { Vent_ring1 }
  object { Vent_ring2 }
  object { Vent_ring3 }
  object { Vent_ring4 }
  object { Vent_ring5 }
  object { Vent_ring6 }
  object { Vent_ring7 }
  object { Vent_ring8 }
  object { Vent_ring9 }
  hollow
}


union { // street_sign
  cylinder { // Poto
    <0,0,1>, <0,0,0>, 1
    texture {
      nonref_silver
    }
    scale <0.1, 0.1, 3.5>
    translate  <15.652997, 3.511986, 6.103259>
  }
  box { // Sign
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture01
    }
    scale <1.393756, 0.058137, 0.714742>
    translate  <17.043842, 3.328867, 8.731499>
  }
  hollow
  translate  <-0.026839, -0.402586, 0.105991>
}


difference { // vent2_CSG
  box { // vent2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.7, 0.7>
    translate  <-8.460148, 4.984528, 10.122868>
  }
  texture {
    nonref_silver
  }
  hollow
}


difference { // Vent_CSG
  box { // Vent
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 16.0, 0.7>
    translate  <-5.204084, -8.858217, 10.131943>
  }
  texture {
    nonref_silver
  }
  hollow
}


box { // Glasss
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Glasss_tex
  }
  hollow
  scale <0.021691, 3.548289, 1.649544>
  translate  <15.380697, -0.527709, 8.093775>
}



// Include contains 'Windowsil'
#include "cellar1.in1"

#declare Windowsil = object {
  Windowsil_Raw
  scale <0.375757, 0.524372, 1.0>
  rotate <90.0, 0.0, 180.0>
  translate  <15.118513, -4.199665, 6.885557>
}
// Include contains 'Windowsil1'
#include "cellar1.in2"

#declare Windowsil1 = object {
  Windowsil1_Raw
  scale <0.375757, 0.524372, 1.0>
  rotate <-90.0, 0.0, 180.0>
  translate  <15.118513, 3.169657, 9.334273>
}
// Include contains 'Windowsil2'
#include "cellar1.in3"

#declare Windowsil2 = object {
  Windowsil2_Raw
  scale <0.375757, 0.524372, 1.0>
  rotate 180.0*z
  translate  <15.118513, 2.646949, 6.359385>
}
// Include contains 'Windowsil3'
#include "cellar1.in4"

#declare Windowsil3 = object {
  Windowsil3_Raw
  scale <0.375757, 0.524372, 1.0>
  rotate <180.0, 0.0, 180.0>
  translate  <15.118513, -3.666944, 9.857984>
}
merge { // Windowsil_merge
  object { Windowsil texture {T_Wood14 rotate y*91 rotate y*0  scale .6} }
  object { Windowsil1 texture {T_Wood14 rotate -y*91 rotate -y*0 scale .6 translate <1, 2, 3> } }
  object { Windowsil2 texture {T_Wood14 rotate x*91 rotate y*3 scale .6 } }
  object { Windowsil3 texture {T_Wood14 rotate -x*91 rotate y*3 scale .6 } }

  hollow
}


prism {
  linear_sweep
  linear_spline
  -0.01,0.0
  46  // control points
  <-0.047133, 0.701548>,
  <-0.580721, 0.202739>,
  <-0.609661, -0.151987>,
  <-1.024341, -0.804322>,
  <-0.718009, -0.384206>,
  <-0.6197, -0.666496>,
  <-0.57485, -1.065626>,
  <-0.5799, -0.673975>,
  <-0.686611, -0.33441>,
  <-0.561938, -0.159245>,
  <-0.545992, 0.171108>,
  <-0.32398, 0.367903>,
  <-0.128599, 0.113368>,
  <-0.1718, -0.16759>,
  <-0.00709, -0.443683>,
  <-0.108668, -0.183256>,
  <-0.06718, 0.135442>,
  <-0.253417, 0.408811>,
  <-0.020419, 0.647099>,
  <0.319291, 0.342905>,
  <0.316723, -0.258693>,
  <0.258756, -0.496921>,
  <0.482321, -1.061557>,
  <0.411875, -1.403348>,
  <0.529587, -1.058331>,
  <0.310958, -0.497317>,
  <0.361438, -0.243324>,
  <0.376254, -0.102363>,
  <0.549358, -0.265067>,
  <0.606062, -0.467855>,
  <0.940317, -0.693085>,
  <0.985691, -1.005079>,
  <0.96563, -0.664803>,
  <0.647271, -0.445493>,
  <0.564799, -0.23019>,
  <0.371236, -0.035362>,
  <0.387212, 0.295504>,
  <0.62754, 0.140037>,
  <0.026714, 0.687936>,
  <0.026714, 0.994878>,
  <0.092054, 1.182055>,
  <0.006296, 1.490046>,
  <-0.067551, 1.490046>,
  <0.018207, 1.182055>,
  <-0.047133, 0.994878>,
  <-0.047133, 0.701548>
  rotate -x*90
  pigment {
    White*4
  }
  hollow
  scale <1.200879, 1.697798, 1.354029>
  rotate <90.0, -0.0, -50.900002>
  translate  <32.004696, 21.632284, 9.898126>
}


box { // Ceiling
  <-1, -1, -1>, <1, 1, 1>
  hollow
  scale <13.982512, 13.441331, 0.05>
  translate  <1.303472, -7.403038, 10.890889>
  texture {
    ceiling_tex
  }
}


#declare Pow_Box_Hnad = union {
  cylinder { // Pow_Box_Handle
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 0.5>
  }
  sphere { // Pow_Box_Knob
    <0,0,0>,1
    pigment {
      Black
    }
    scale 0.06
    translate  0.5*z
  }
  rotate <14.35854, 0.0, -0.0>
  translate  <-1.263535, 0.140251, 3.576271>
}
#declare CSG_Pow_lid = difference {
  superellipsoid { // Pow_Box_Lid
    <0.1, 1.0>
    scale <0.5, 0.5, 0.15>
    rotate -90.0*x
    translate  <-1.844341, 5.423859, 3.405852>
  }
  box { // CSG_Pow_Box
    <-1, -1, -1>, <1, 1, 1>
    pigment { Clear}
    scale <0.561803, 0.09422, 0.542671>
    translate  <-1.849671, 5.225564, 3.409934>
  }
    translate  <0.0, -5.423859, 0.110691>
}


union { // Pow_Box
  cylinder { // Pow_Box_Base
    <0,0,1>, <0,0,0>, 1
    pigment {
      Black
    }
    scale <0.1, 0.1, 0.15>
    rotate 90.0*y
    translate  <-1.351557, 0.203485, 3.510356>
  }

  box { // Pow_Box_Box
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.2, 0.5>
    translate  <-1.842837, 0.22114, 3.516543>
  }
  object { Pow_Box_Hnad }
  object { CSG_Pow_lid }
  pigment { Gray95 }
  hollow
  scale 1.3
  translate  <0.0, 5.230581, 0.479072>
}

  text {
  ttf "c:\windows\fonts\wingding.ttf"
  "N" .05, 0
  rotate x*90
  translate <-2.71, 4.98, 4.65>
  pigment { Orange*.8 }
  no_shadow
}




#declare Grip = union {
  sphere { // Grip_Sphere
    <0,0,0>,1
    scale 0.06
    translate  0.97*z
  }
  sphere { // Grip_Sphere1
    <0,0,0>,1
    scale 0.06
    translate  <-0.12661, 0.0, 0.961702>
  }
  sphere { // Grip_Sphere2
    <0,0,0>,1
    scale 0.06
    translate  <-0.251054, 0.0, 0.936948>
  }
  sphere { // Grip_Sphere3
    <0,0,0>,1
    scale 0.06
    translate  <-0.371203, 0.0, 0.896163>
  }
  sphere { // Grip_Sphere4
    <0,0,0>,1
    scale 0.06
    translate  <-0.485, 0.0, 0.840045>
  }
  sphere { // Grip_Sphere5
    <0,0,0>,1
    scale 0.06
    translate  <-0.590499, 0.0, 0.769553>
  }
  sphere { // Grip_Sphere6
    <0,0,0>,1
    scale 0.06
    translate  <-0.685894, 0.0, 0.685894>
  }
  sphere { // Grip_Sphere7
    <0,0,0>,1
    scale 0.06
    translate  <-0.769553, 0.0, 0.590499>
  }
  sphere { // Grip_Sphere8
    <0,0,0>,1
    scale 0.06
    translate  <-0.840045, 0.0, 0.485>
  }
  sphere { // Grip_Sphere9
    <0,0,0>,1
    scale 0.06
    translate  <-0.896163, 0.0, 0.371203>
  }
  sphere { // Grip_Sphere10
    <0,0,0>,1
    scale 0.06
    translate  <-0.936948, 0.0, 0.251054>
  }
  sphere { // Grip_Sphere11
    <0,0,0>,1
    scale 0.06
    translate  <-0.961702, 0.0, 0.12661>
  }
  sphere { // Grip_Sphere12
    <0,0,0>,1
    scale 0.06
    translate  <-0.97, 0.0, -0.0>
  }
  sphere { // Grip_Sphere13
    <0,0,0>,1
    scale 0.06
    translate  <-0.961702, 0.0, -0.12661>
  }
  sphere { // Grip_Sphere14
    <0,0,0>,1
    scale 0.06
    translate  <-0.936948, 0.0, -0.251054>
  }
  sphere { // Grip_Sphere15
    <0,0,0>,1
    scale 0.06
    translate  <-0.896163, 0.0, -0.371203>
  }
  sphere { // Grip_Sphere16
    <0,0,0>,1
    scale 0.06
    translate  <-0.840045, 0.0, -0.485>
  }
  sphere { // Grip_Sphere17
    <0,0,0>,1
    scale 0.06
    translate  <-0.769553, 0.0, -0.590499>
  }
  sphere { // Grip_Sphere18
    <0,0,0>,1
    scale 0.06
    translate  <-0.685894, 0.0, -0.685894>
  }
  sphere { // Grip_Sphere19
    <0,0,0>,1
    scale 0.06
    translate  <-0.590499, 0.0, -0.769553>
  }
  sphere { // Grip_Sphere20
    <0,0,0>,1
    scale 0.06
    translate  <-0.485, 0.0, -0.840045>
  }
  sphere { // Grip_Sphere21
    <0,0,0>,1
    scale 0.06
    translate  <-0.371203, 0.0, -0.896163>
  }
  sphere { // Grip_Sphere22
    <0,0,0>,1
    scale 0.06
    translate  <-0.251054, 0.0, -0.936948>
  }
  sphere { // Grip_Sphere23
    <0,0,0>,1
    scale 0.06
    translate  <-0.12661, 0.0, -0.961702>
  }
  sphere { // Grip_Sphere24
    <0,0,0>,1
    scale 0.06
    translate  <0.0, 0.0, -0.97>
  }
  sphere { // Grip_Sphere25
    <0,0,0>,1
    scale 0.06
    translate  <0.12661, 0.0, -0.961702>
  }
  sphere { // Grip_Sphere26
    <0,0,0>,1
    scale 0.06
    translate  <0.251054, 0.0, -0.936948>
  }
  sphere { // Grip_Sphere27
    <0,0,0>,1
    scale 0.06
    translate  <0.371203, 0.0, -0.896163>
  }
  sphere { // Grip_Sphere28
    <0,0,0>,1
    scale 0.06
    translate  <0.485, 0.0, -0.840045>
  }
  sphere { // Grip_Sphere29
    <0,0,0>,1
    scale 0.06
    translate  <0.590499, 0.0, -0.769553>
  }
  sphere { // Grip_Sphere30
    <0,0,0>,1
    scale 0.06
    translate  <0.685894, 0.0, -0.685894>
  }
  sphere { // Grip_Sphere31
    <0,0,0>,1
    scale 0.06
    translate  <0.769553, 0.0, -0.590499>
  }
  sphere { // Grip_Sphere32
    <0,0,0>,1
    scale 0.06
    translate  <0.840045, 0.0, -0.485>
  }
  sphere { // Grip_Sphere33
    <0,0,0>,1
    scale 0.06
    translate  <0.896163, 0.0, -0.371203>
  }
  sphere { // Grip_Sphere34
    <0,0,0>,1
    scale 0.06
    translate  <0.936948, 0.0, -0.251054>
  }
  sphere { // Grip_Sphere35
    <0,0,0>,1
    scale 0.06
    translate  <0.961702, 0.0, -0.12661>
  }
  sphere { // Grip_Sphere36
    <0,0,0>,1
    scale 0.06
    translate  <0.97, 0.0, 0.0>
  }
  sphere { // Grip_Sphere37
    <0,0,0>,1
    scale 0.06
    translate  <0.961702, 0.0, 0.12661>
  }
  sphere { // Grip_Sphere38
    <0,0,0>,1
    scale 0.06
    translate  <0.936948, 0.0, 0.251054>
  }
  sphere { // Grip_Sphere39
    <0,0,0>,1
    scale 0.06
    translate  <0.896163, 0.0, 0.371203>
  }
  sphere { // Grip_Sphere40
    <0,0,0>,1
    scale 0.06
    translate  <0.840045, 0.0, 0.485>
  }
  sphere { // Grip_Sphere41
    <0,0,0>,1
    scale 0.06
    translate  <0.769553, 0.0, 0.590499>
  }
  sphere { // Grip_Sphere42
    <0,0,0>,1
    scale 0.06
    translate  <0.685894, 0.0, 0.685894>
  }
  sphere { // Grip_Sphere43
    <0,0,0>,1
    scale 0.06
    translate  <0.590499, 0.0, 0.769553>
  }
  sphere { // Grip_Sphere44
    <0,0,0>,1
    scale 0.06
    translate  <0.485, 0.0, 0.840045>
  }
  sphere { // Grip_Sphere45
    <0,0,0>,1
    scale 0.06
    translate  <0.371203, 0.0, 0.896163>
  }
  sphere { // Grip_Sphere46
    <0,0,0>,1
    scale 0.06
    translate  <0.251054, 0.0, 0.936948>
  }
  sphere { // Grip_Sphere47
    <0,0,0>,1
    scale 0.06
    translate  <0.12661, 0.0, 0.961702>
  }
  sphere { // Grip_Sphere48
    <0,0,0>,1
    scale 0.06
    translate  <-0.0, 0.0, 0.97>
  }
  texture {
    van_tex
  }
}
#declare Van = union {
  cylinder { // Van_Center
    <0,0,1>, <0,0,0>, 1
    pigment {
      Red
    }
    scale 0.2
    rotate -90.0*x
    translate  -0.1*y
  }
  cylinder { // Van_Cyl
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
  }
  cylinder { // Van_Cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate -72.0*y
  }
  cylinder { // Van_Cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate <180.0, -36.0, 180.0>
  }
  cylinder { // Van_Cyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate <180.0, 36.0, 180.0>
  }
  cylinder { // Van_Cyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate 72.0*y
  }
  torus { // Van_Torus
    1.0, 0.06  rotate -x*90
    rotate -90.0*x
  }
  sphere { // Van_Sphere
    <0,0,0>,1
    scale 0.08
    translate  1.0*z
  }
  sphere { // Van_Sphere1
    <0,0,0>,1
    scale 0.08
    rotate -72.0*y
    translate  <-0.951057, 0.0, 0.309017>
  }
  sphere { // Van_Sphere2
    <0,0,0>,1
    scale 0.08
    rotate <180.0, -36.0, 180.0>
    translate  <-0.587785, 0.0, -0.809017>
  }
  sphere { // Van_Sphere3
    <0,0,0>,1
    scale 0.08
    rotate <180.0, 36.0, 180.0>
    translate  <0.587785, 0.0, -0.809017>
  }
  sphere { // Van_Sphere4
    <0,0,0>,1
    scale 0.08
    rotate 72.0*y
    translate  <0.951057, 0.0, 0.309017>
  }
  object { Grip }
  texture {
    van_tex
  }
  scale 0.4
  rotate <0.0, -19.84355, 0.0>
  translate  <-3.0, -0.2, 2.0>
}
#declare W_Pipe = union {
  cylinder { // W_Pipe_Low
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 2.0>
    translate  -2.0*x
  }
  sphere { // W_Pipe_Low_Sp
    <0,0,0>,1
    scale 0.1
    translate  <-2.0, 0.0, 2.0>
  }
  cylinder { // W_Pipe_Horiz
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <-2.0, 0.0, 2.0>
  }
  box { // W_Pipe_Box
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.15, 0.25>
    translate  <-3.0, 0.0, 2.0>
  }
  object { Van texture { van_tex } }
  texture {
    Copper_Metal
  }
}
#declare Grip1 = union {
  sphere { // Grip_Sphere49
    <0,0,0>,1
    scale 0.06
    translate  0.97*z
  }
  sphere { // Grip_Sphere50
    <0,0,0>,1
    scale 0.06
    translate  <-0.12661, 0.0, 0.961702>
  }
  sphere { // Grip_Sphere51
    <0,0,0>,1
    scale 0.06
    translate  <-0.251054, 0.0, 0.936948>
  }
  sphere { // Grip_Sphere52
    <0,0,0>,1
    scale 0.06
    translate  <-0.371203, 0.0, 0.896163>
  }
  sphere { // Grip_Sphere53
    <0,0,0>,1
    scale 0.06
    translate  <-0.485, 0.0, 0.840045>
  }
  sphere { // Grip_Sphere54
    <0,0,0>,1
    scale 0.06
    translate  <-0.590499, 0.0, 0.769553>
  }
  sphere { // Grip_Sphere55
    <0,0,0>,1
    scale 0.06
    translate  <-0.685894, 0.0, 0.685894>
  }
  sphere { // Grip_Sphere56
    <0,0,0>,1
    scale 0.06
    translate  <-0.769553, 0.0, 0.590499>
  }
  sphere { // Grip_Sphere57
    <0,0,0>,1
    scale 0.06
    translate  <-0.840045, 0.0, 0.485>
  }
  sphere { // Grip_Sphere58
    <0,0,0>,1
    scale 0.06
    translate  <-0.896163, 0.0, 0.371203>
  }
  sphere { // Grip_Sphere59
    <0,0,0>,1
    scale 0.06
    translate  <-0.936948, 0.0, 0.251054>
  }
  sphere { // Grip_Sphere60
    <0,0,0>,1
    scale 0.06
    translate  <-0.961702, 0.0, 0.12661>
  }
  sphere { // Grip_Sphere61
    <0,0,0>,1
    scale 0.06
    translate  <-0.97, 0.0, -0.0>
  }
  sphere { // Grip_Sphere62
    <0,0,0>,1
    scale 0.06
    translate  <-0.961702, 0.0, -0.12661>
  }
  sphere { // Grip_Sphere63
    <0,0,0>,1
    scale 0.06
    translate  <-0.936948, 0.0, -0.251054>
  }
  sphere { // Grip_Sphere64
    <0,0,0>,1
    scale 0.06
    translate  <-0.896163, 0.0, -0.371203>
  }
  sphere { // Grip_Sphere65
    <0,0,0>,1
    scale 0.06
    translate  <-0.840045, 0.0, -0.485>
  }
  sphere { // Grip_Sphere66
    <0,0,0>,1
    scale 0.06
    translate  <-0.769553, 0.0, -0.590499>
  }
  sphere { // Grip_Sphere67
    <0,0,0>,1
    scale 0.06
    translate  <-0.685894, 0.0, -0.685894>
  }
  sphere { // Grip_Sphere68
    <0,0,0>,1
    scale 0.06
    translate  <-0.590499, 0.0, -0.769553>
  }
  sphere { // Grip_Sphere69
    <0,0,0>,1
    scale 0.06
    translate  <-0.485, 0.0, -0.840045>
  }
  sphere { // Grip_Sphere70
    <0,0,0>,1
    scale 0.06
    translate  <-0.371203, 0.0, -0.896163>
  }
  sphere { // Grip_Sphere71
    <0,0,0>,1
    scale 0.06
    translate  <-0.251054, 0.0, -0.936948>
  }
  sphere { // Grip_Sphere72
    <0,0,0>,1
    scale 0.06
    translate  <-0.12661, 0.0, -0.961702>
  }
  sphere { // Grip_Sphere73
    <0,0,0>,1
    scale 0.06
    translate  <0.0, 0.0, -0.97>
  }
  sphere { // Grip_Sphere74
    <0,0,0>,1
    scale 0.06
    translate  <0.12661, 0.0, -0.961702>
  }
  sphere { // Grip_Sphere75
    <0,0,0>,1
    scale 0.06
    translate  <0.251054, 0.0, -0.936948>
  }
  sphere { // Grip_Sphere76
    <0,0,0>,1
    scale 0.06
    translate  <0.371203, 0.0, -0.896163>
  }
  sphere { // Grip_Sphere77
    <0,0,0>,1
    scale 0.06
    translate  <0.485, 0.0, -0.840045>
  }
  sphere { // Grip_Sphere78
    <0,0,0>,1
    scale 0.06
    translate  <0.590499, 0.0, -0.769553>
  }
  sphere { // Grip_Sphere79
    <0,0,0>,1
    scale 0.06
    translate  <0.685894, 0.0, -0.685894>
  }
  sphere { // Grip_Sphere80
    <0,0,0>,1
    scale 0.06
    translate  <0.769553, 0.0, -0.590499>
  }
  sphere { // Grip_Sphere81
    <0,0,0>,1
    scale 0.06
    translate  <0.840045, 0.0, -0.485>
  }
  sphere { // Grip_Sphere82
    <0,0,0>,1
    scale 0.06
    translate  <0.896163, 0.0, -0.371203>
  }
  sphere { // Grip_Sphere83
    <0,0,0>,1
    scale 0.06
    translate  <0.936948, 0.0, -0.251054>
  }
  sphere { // Grip_Sphere84
    <0,0,0>,1
    scale 0.06
    translate  <0.961702, 0.0, -0.12661>
  }
  sphere { // Grip_Sphere85
    <0,0,0>,1
    scale 0.06
    translate  <0.97, 0.0, 0.0>
  }
  sphere { // Grip_Sphere86
    <0,0,0>,1
    scale 0.06
    translate  <0.961702, 0.0, 0.12661>
  }
  sphere { // Grip_Sphere87
    <0,0,0>,1
    scale 0.06
    translate  <0.936948, 0.0, 0.251054>
  }
  sphere { // Grip_Sphere88
    <0,0,0>,1
    scale 0.06
    translate  <0.896163, 0.0, 0.371203>
  }
  sphere { // Grip_Sphere89
    <0,0,0>,1
    scale 0.06
    translate  <0.840045, 0.0, 0.485>
  }
  sphere { // Grip_Sphere90
    <0,0,0>,1
    scale 0.06
    translate  <0.769553, 0.0, 0.590499>
  }
  sphere { // Grip_Sphere91
    <0,0,0>,1
    scale 0.06
    translate  <0.685894, 0.0, 0.685894>
  }
  sphere { // Grip_Sphere92
    <0,0,0>,1
    scale 0.06
    translate  <0.590499, 0.0, 0.769553>
  }
  sphere { // Grip_Sphere93
    <0,0,0>,1
    scale 0.06
    translate  <0.485, 0.0, 0.840045>
  }
  sphere { // Grip_Sphere94
    <0,0,0>,1
    scale 0.06
    translate  <0.371203, 0.0, 0.896163>
  }
  sphere { // Grip_Sphere95
    <0,0,0>,1
    scale 0.06
    translate  <0.251054, 0.0, 0.936948>
  }
  sphere { // Grip_Sphere96
    <0,0,0>,1
    scale 0.06
    translate  <0.12661, 0.0, 0.961702>
  }
  sphere { // Grip_Sphere97
    <0,0,0>,1
    scale 0.06
    translate  <-0.0, 0.0, 0.97>
  }
  texture {
    van_tex
  }
}
#declare Van1 = union {
  cylinder { // Van_Center1
    <0,0,1>, <0,0,0>, 1
    pigment {
      Blue
    }
    scale 0.2
    rotate -90.0*x
    translate  -0.1*y
  }
  cylinder { // Van_Cyl5
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
  }
  cylinder { // Van_Cyl6
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate -72.0*y
  }
  cylinder { // Van_Cyl7
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate <180.0, -36.0, 180.0>
  }
  cylinder { // Van_Cyl8
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate <180.0, 36.0, 180.0>
  }
  cylinder { // Van_Cyl9
    <0,0,1>, <0,0,0>, 1
    scale <0.06, 0.06, 1.0>
    rotate 72.0*y
  }
  torus { // Van_Torus1
    1.0, 0.06  rotate -x*90
    rotate -90.0*x
  }
  sphere { // Van_Sphere5
    <0,0,0>,1
    scale 0.08
    translate  1.0*z
  }
  sphere { // Van_Sphere6
    <0,0,0>,1
    scale 0.08
    rotate -72.0*y
    translate  <-0.951057, 0.0, 0.309017>
  }
  sphere { // Van_Sphere7
    <0,0,0>,1
    scale 0.08
    rotate <180.0, -36.0, 180.0>
    translate  <-0.587785, 0.0, -0.809017>
  }
  sphere { // Van_Sphere8
    <0,0,0>,1
    scale 0.08
    rotate <180.0, 36.0, 180.0>
    translate  <0.587785, 0.0, -0.809017>
  }
  sphere { // Van_Sphere9
    <0,0,0>,1
    scale 0.08
    rotate 72.0*y
    translate  <0.951057, 0.0, 0.309017>
  }
  object { Grip1 }
  texture {
    van_tex
  }
  scale 0.4
  rotate <-0.0, 10.138725, -0.0>
  translate  <-4.0, -0.2, 3.0>
}
#declare W_Pipe2 = union {
  cylinder { // W_Pipe2_Low
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 3.0>
    translate  -1.0*x
  }
  sphere { // W_Pipe2_low_sp
    <0,0,0>,1
    scale 0.1
    translate  <-1.0, 0.0, 3.0>
  }
  cylinder { // W_Pipe2_Horiz
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 6.0>
    rotate -90.0*y
    translate  <-1.0, 0.0, 3.0>
  }
  box { // W_Pipe2_Box
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.15, 0.25>
    translate  <-4.0, 0.0, 3.0>
  }
  object { Van1
   texture {van_tex}}
  texture {
    Copper_Metal
  }
  translate  <-0.4, 0.0, -0.4>
}
#declare Rings = union {
  torus { // Ring
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    translate  <-1.397165, 5.485306, 0.263076>
  }
  torus { // Ring1
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    translate  <-1.397165, 5.485306, 1.961111>
  }
  torus { // Ring2
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    translate  <-1.999625, 5.502614, 1.387127>
  }
  torus { // Ring3
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    translate  <-1.999768, 5.501956, 0.263076>
  }
  torus { // Ring4
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate -90.0*y
    translate  <-2.167037, 5.502614, 2.395375>
  }
  torus { // Ring5
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-1.999625, 5.502614, 1.387127>
  }
  torus { // Ring6
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate 90.0*y
    translate  <-3.481679, 5.499736, 2.399492>
  }
  torus { // Ring7
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate 90.0*y
    translate  <-6.124738, 5.499736, 2.395864>
  }
  torus { // Ring8
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate 90.0*y
    translate  <-6.788003, 5.499736, 1.79823>
  }
  torus { // Ring9
    0.11, 0.01  rotate -x*90
    scale <1.0, 1.0, 4.0>
    rotate 90.0*y
    translate  <-4.140898, 5.499736, 1.803032>
  }
  texture {
    van_tex
  }
  translate  <0.0, -5.5, 0.2>
}
union { // W_Pipes
  object { W_Pipe }
  object { W_Pipe2 }
  object { Rings }
  hollow
  translate  <0.0, 5.5, -0.2>
}


#declare Pipe_Bend = union {
  torus { // Pipe_Bend_Part
    0.35, 0.05  rotate -x*90
    translate  0.4*x
  }
  torus { // Pipe_Bend_Par1
    0.35, 0.05  rotate -x*90
    rotate -9.0*y
    translate  <0.395075, 0.0, 0.062574>
  }
  torus { // Pipe_Bend_Par2
    0.35, 0.05  rotate -x*90
    rotate -18.0*y
    translate  <0.380423, 0.0, 0.123607>
  }
  torus { // Pipe_Bend_Par3
    0.35, 0.05  rotate -x*90
    rotate -27.0*y
    translate  <0.356403, 0.0, 0.181596>
  }
  torus { // Pipe_Bend_Par4
    0.35, 0.05  rotate -x*90
    rotate -36.0*y
    translate  <0.323607, 0.0, 0.235114>
  }
  torus { // Pipe_Bend_Par5
    0.35, 0.05  rotate -x*90
    rotate -45.0*y
    translate  <0.282843, 0.0, 0.282843>
  }
  torus { // Pipe_Bend_Par6
    0.35, 0.05  rotate -x*90
    rotate -54.0*y
    translate  <0.235114, 0.0, 0.323607>
  }
  torus { // Pipe_Bend_Par7
    0.35, 0.05  rotate -x*90
    rotate -63.0*y
    translate  <0.181596, 0.0, 0.356403>
  }
  torus { // Pipe_Bend_Par8
    0.35, 0.05  rotate -x*90
    rotate -72.0*y
    translate  <0.123607, 0.0, 0.380423>
  }
  torus { // Pipe_Bend_Par9
    0.35, 0.05  rotate -x*90
    rotate -81.0*y
    translate  <0.062574, 0.0, 0.395075>
  }
  torus { // Pipe_Bend_Pa10
    0.35, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <-0.0, 0.0, 0.4>
  }
  texture {
    //Silver2
    Rusty_Chrome
  }
  translate  <1.791577, 5.199466, 7.289163>
}
#declare Pipe_Bend1 = union {
  torus { // Pipe_Bend_Pa11
    0.35, 0.05  rotate -x*90
    translate  0.4*x
  }
  torus { // Pipe_Bend_Pa12
    0.35, 0.05  rotate -x*90
    rotate -9.0*y
    translate  <0.395075, 0.0, 0.062574>
  }
  torus { // Pipe_Bend_Pa13
    0.35, 0.05  rotate -x*90
    rotate -18.0*y
    translate  <0.380423, 0.0, 0.123607>
  }
  torus { // Pipe_Bend_Pa14
    0.35, 0.05  rotate -x*90
    rotate -27.0*y
    translate  <0.356403, 0.0, 0.181596>
  }
  torus { // Pipe_Bend_Pa15
    0.35, 0.05  rotate -x*90
    rotate -36.0*y
    translate  <0.323607, 0.0, 0.235114>
  }
  torus { // Pipe_Bend_Pa16
    0.35, 0.05  rotate -x*90
    rotate -45.0*y
    translate  <0.282843, 0.0, 0.282843>
  }
  torus { // Pipe_Bend_Pa17
    0.35, 0.05  rotate -x*90
    rotate -54.0*y
    translate  <0.235114, 0.0, 0.323607>
  }
  torus { // Pipe_Bend_Pa18
    0.35, 0.05  rotate -x*90
    rotate -63.0*y
    translate  <0.181596, 0.0, 0.356403>
  }
  torus { // Pipe_Bend_Pa19
    0.35, 0.05  rotate -x*90
    rotate -72.0*y
    translate  <0.123607, 0.0, 0.380423>
  }
  torus { // Pipe_Bend_Pa20
    0.35, 0.05  rotate -x*90
    rotate -81.0*y
    translate  <0.062574, 0.0, 0.395075>
  }
  torus { // Pipe_Bend_Pa21
    0.35, 0.05  rotate -x*90
    rotate -90.0*y
    translate  <-0.0, 0.0, 0.4>
  }
  texture {
    //Silver2
    Rusty_Chrome
  }
  rotate <180.0, 0.0, 180.0>
  translate  <-0.778546, 5.199466, 8.090403>
}
#declare Rings_exhaust = union {
  torus { // Ring_exh
    0.38, 0.02  rotate -x*90
    scale <1.0, 1.0, 3.5>
    translate  <2.191956, 5.193638, 5.873985>
  }
  torus { // Ring_exh1
    0.38, 0.02  rotate -x*90
    scale <1.0, 1.0, 3.5>
    translate  <-1.180795, 5.193638, 9.230327>
  }
  torus { // Ring_exh2
    0.38, 0.02  rotate -x*90
    scale <1.0, 1.0, 3.5>
    rotate -90.0*y
    translate  <0.481027, 5.193638, 7.704691>
  }
  texture {
    Rusty_Iron
  }
}
union { // Pipe_Exhaust
  cylinder { // Pipe_low
    <0,0,1>, <0,0,0>, 1
    texture {
      //Silver2
      Rusty_Chrome_Fire
    }
    scale <0.36, 0.36, 3.0>
    translate  <2.195108, 5.193066, 4.253034>
  }
  object { Pipe_Bend }
  cylinder { // Pipe_Horiz
    <0,0,1>, <0,0,0>, 1
    texture {
      //Silver2
      Rusty_Chrome
    }
    scale <0.36, 0.36, 2.5>
    rotate -90.0*y
    translate  <1.757509, 5.197242, 7.689935>
  }
  object { Pipe_Bend1 }
  cylinder { // Pipe_Top
    <0,0,1>, <0,0,0>, 1
    texture {
      //Silver2
      Rusty_Chrome
    }
    scale <0.36, 0.36, 3.0>
    translate  <-1.173942, 5.200596, 8.117989>
  }
  object { Rings_exhaust }
  hollow
}



/*
plane { // Plane001
  z,0
  texture {
    Floor_Tex
  }
  hollow
  translate  -0.133789*z
}
*/

#declare Brick_Oven_r32 = union {
  box { // Brick_oven239
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.15>
    rotate -90.0*z
    translate  <-0.0, 0.681987, 0.0>
  }
  box { // Brick_oven240
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven241
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven242
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.4, 0.15>
    rotate -90.0*z
    translate  <-0.0, 5.564895, 0.0>
  }
  scale <1.0, 0.55, 1.0>
  rotate -90.0*z
  translate  <0.442431, 0.0, 0.4>
}
#declare Brick_Oven_r33 = union {
  box { // Brick_oven243
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven244
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven245
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  scale <1.0, 0.55, 1.0>
  rotate -90.0*z
  translate  1.021409*x
}
#declare Brick_Oven_r35 = union {
  box { // Brick_oven250
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.4, 0.15>
    rotate -90.0*z
    translate  <-0.0, 0.481499, 0.0>
  }
  box { // Brick_oven251
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven252
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.4, 0.15>
    rotate -90.0*z
    translate  <0.0, 3.698276, 0.0>
  }
  scale <1.0, 0.55, 1.0>
  rotate -90.0*z
  translate  <1.021409, 0.0, 0.78717>
}
#declare Brick_Oven_r34 = union {
  box { // Brick_oven247
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.4, 0.15>
    rotate -90.0*z
    translate  <-0.0, 2.600463, 0.0>
  }
  box { // Brick_oven248
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.4, 0.15>
    rotate -90.0*z
    translate  <0.0, 3.699537, 0.0>
  }
  scale <1.0, 0.55, 1.0>
  rotate -90.0*z
  translate  <0.442431, 0.0, 1.18717>
}
#declare Eck_left = difference {
  box { // Brick_oven246
    <-1, -1, -1>, <1, 1, 1>
    scale <0.165, 0.4, 0.15>
    rotate -180.0*z
    translate  <1.377072, -0.6, 3.490037>
  }
  box { // Brick_oven249
    <-1, -1, -1>, <1, 1, 1>
    scale <0.310261, 0.5, 0.132952>
    rotate <-0.0, 30.072134, 180.0>
    translate  <1.238832, -0.7, 3.564122>
  }
  texture {
    oven_tex
  }
  translate  <0.0, 0.6, -2.3>
}
#declare Eck_right = difference {
  box { // Brick_oven253
    <-1, -1, -1>, <1, 1, 1>
    scale <0.165, 0.4, 0.15>
    rotate -180.0*z
    translate  <1.377072, -0.6, 3.490037>
  }
  box { // Brick_oven254
    <-1, -1, -1>, <1, 1, 1>
    scale <0.310261, 0.5, 0.132952>
    rotate <-0.0, -33.885559, 180.0>
    translate  <1.476527, -0.7, 3.564122>
  }
  texture {
    oven_tex
  }
  translate  <1.597839, 0.6, -2.3>
}
union { // Bricks_Top
  object { Brick_Oven_r32 }
  object { Brick_Oven_r33 }
  box { // Mortar_Front1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      oven_mort
    }
    scale <1.7, 0.3, 0.8>
    translate  <2.126185, 0.0, 0.677749>
  }
  object { Brick_Oven_r35 }
  object { Brick_Oven_r34 }
  object { Eck_left }
  object { Eck_right }
  texture {
    oven_tex
  }
  hollow
  translate  <0.0, -0.6, 2.3>
}


#declare Brick_Oven_r13 = union {
  box { // Brick_oven96
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven97
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven98
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven99
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 10.0*y
  translate  <2.42476, 0.0, 2.050211>
}
#declare Brick_Oven_r14 = union {
  box { // Brick_oven104
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven105
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven106
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven107
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 20.0*y
  translate  <2.53144, -1.05, 2.410058>
}
#declare Brick_Oven_r15 = union {
  box { // Brick_oven112
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven113
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven114
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven115
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 30.0*y
  translate  <2.696699, 0.0, 2.744799>
}
#declare Brick_Oven_r16 = union {
  box { // Brick_oven120
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven121
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven122
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven123
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 40.0*y
  translate  <2.920538, -1.05, 3.054434>
}
#declare Brick_Oven_r17 = union {
  box { // Brick_oven128
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven129
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven130
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven131
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 50.0*y
  translate  <3.186219, 0.0, 3.322227>
}
#declare Brick_Oven_r18 = union {
  box { // Brick_oven136
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven137
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven138
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven139
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 60.0*y
  translate  <3.493743, -1.05, 3.539808>
}
#declare Brick_Oven_r19 = union {
  box { // Brick_oven144
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven145
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven146
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven147
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 70.0*y
  translate  <3.826372, 0.0, 3.690442>
}
#declare Brick_Oven_r20 = union {
  box { // Brick_oven152
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven153
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven154
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven155
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 80.0*y
  translate  <4.192117, -1.05, 3.787023>
}
#declare Brick_Oven_r21 = union {
  box { // Brick_oven160
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven161
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven162
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven163
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  rotate 90.0*y
  translate  <4.566805, 0.0, 3.820425>
}
#declare Brick_Oven_r22 = union {
  box { // Brick_oven168
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven169
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven170
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven171
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -10.0, 0.0>
  translate  <6.705669, 0.0, 2.050211>
}
#declare Brick_Oven_r23 = union {
  box { // Brick_oven176
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven177
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven178
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven179
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -20.0, 0.0>
  translate  <6.59899, -1.05, 2.410058>
}
#declare Brick_Oven_r24 = union {
  box { // Brick_oven184
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven185
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven186
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven187
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -30.0, 0.0>
  translate  <6.433731, 0.0, 2.744799>
}
#declare Brick_Oven_r25 = union {
  box { // Brick_oven192
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven193
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven194
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven195
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -40.0, 0.0>
  translate  <6.209892, -1.05, 3.054434>
}
#declare Brick_Oven_r26 = union {
  box { // Brick_oven200
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven201
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven202
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven203
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -50.0, 0.0>
  translate  <5.94421, 0.0, 3.322227>
}
#declare Brick_Oven_r27 = union {
  box { // Brick_oven208
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven209
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven210
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven211
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -60.0, 0.0>
  translate  <5.636687, -1.05, 3.539808>
}
#declare Brick_Oven_r28 = union {
  box { // Brick_oven216
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven217
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven218
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven219
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -70.0, 0.0>
  translate  <5.304057, 0.0, 3.690442>
}
#declare Brick_Oven_r29 = union {
  box { // Brick_oven224
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven225
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven226
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven227
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  scale -1.0
  rotate <180.0, -80.0, 0.0>
  translate  <4.938312, -1.05, 3.787023>
}
#declare Oven_Arch = union {
  object { Brick_Oven_r13 }
  object { Brick_Oven_r14 }
  object { Brick_Oven_r15 }
  object { Brick_Oven_r16 }
  object { Brick_Oven_r17 }
  object { Brick_Oven_r18 }
  object { Brick_Oven_r19 }
  object { Brick_Oven_r20 }
  object { Brick_Oven_r21 }
  object { Brick_Oven_r22 }
  object { Brick_Oven_r23 }
  object { Brick_Oven_r24 }
  object { Brick_Oven_r25 }
  object { Brick_Oven_r26 }
  object { Brick_Oven_r27 }
  object { Brick_Oven_r28 }
  object { Brick_Oven_r29 }
  translate  <-2.39013, 0.0, 0.313277>
}
#declare Brick_Oven_r1 = union {
  box { // Brick_oven
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
}
#declare Brick_Oven_r2 = union {
  box { // Brick_oven8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  <0.0, -1.05, 0.4>
}
#declare Brick_Oven_r3 = union {
  box { // Brick_oven16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven17
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven18
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven19
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  0.8*z
}
#declare Brick_Oven_r4 = union {
  box { // Brick_oven24
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven25
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven26
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven27
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  <0.0, -1.05, 1.2>
}
#declare Brick_Oven_r5 = union {
  box { // Brick_oven32
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven33
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven34
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven35
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  1.6*z
}
#declare Brick_Oven_r6 = union {
  box { // Brick_oven40
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven41
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven42
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven43
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  <0.0, -1.05, 2.0>
}
#declare Brick_Oven_wL = union {
  object { Brick_Oven_r1 }
  object { Brick_Oven_r2 }
  object { Brick_Oven_r3 }
  object { Brick_Oven_r4 }
  object { Brick_Oven_r5 }
  object { Brick_Oven_r6 }
  box { // Mortar_Left
    <-1, -1, -1>, <1, 1, 1>
    texture {
      oven_mort
    }
    scale <0.32, 9.0, 1.2>
    translate  <0.0, 8.1, 1.1>
  }
}
#declare Brick_Oven_r7 = union {
  box { // Brick_oven48
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven49
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven50
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven51
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
}
#declare Brick_Oven_r8 = union {
  box { // Brick_oven56
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven57
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven58
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven59
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  <0.0, -1.05, 0.4>
}
#declare Brick_Oven_r9 = union {
  box { // Brick_oven64
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven65
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven66
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven67
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  0.8*z
}
#declare Brick_Oven_r10 = union {
  box { // Brick_oven72
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven73
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven74
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven75
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  <0.0, -1.05, 1.2>
}
#declare Brick_Oven_r11 = union {
  box { // Brick_oven80
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven81
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven82
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven83
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  1.6*z
}
#declare Brick_Oven_r12 = union {
  box { // Brick_oven88
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven89
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven90
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven91
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  6.3*y
  }
  translate  <0.0, -1.05, 2.0>
}
#declare Brick_Oven_wR = union {
  object { Brick_Oven_r7 }
  object { Brick_Oven_r8 }
  object { Brick_Oven_r9 }
  object { Brick_Oven_r10 }
  object { Brick_Oven_r11 }
  object { Brick_Oven_r12 }
  box { // Mortar_Right
    <-1, -1, -1>, <1, 1, 1>
    texture {
      oven_mort
    }
    scale <-0.32, -9.0, -1.2>
    rotate -180.0*x
    translate  <0.00017, 8.1, 1.1>
  }
  scale -1.0
  rotate -180.0*x
  translate  4.35017*x
}
#declare Mortar_Arch_CSG = difference {
  cylinder { // Mortar_arch1
    <0,0,1>, <0,0,0>, 1
    scale <2.4, 2.15, 2.15>
    rotate -90.0*x
    translate  <2.15, 0.0, 2.3>
  }
  cylinder { // Mortar_arch2
    <0,0,1>, <0,0,0>, 1
    scale <1.8, 1.6125, 2.4>
    rotate -90.0*x
    translate  <2.15, -0.05, 2.3>
  }
  box { // Mortar_Arch3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.75, 1.125, 1.1>
    translate  <2.15, 1.1125, 1.05>
  }
  texture {
    oven_mort
  }
  scale <1.0, 8.0, 1.0>
  translate  -0.95*y
}
#declare Brick_Oven_r31 = union {
  box { // Brick_oven235
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  0.5*y
  }
  box { // Brick_oven236
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven237
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  box { // Brick_oven238
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.4, 0.15>
    rotate -90.0*z
    translate  <-0.0, 5.792378, 0.0>
  }
  scale <1.0, 0.55, 1.0>
  rotate -90.0*z
  translate  <0.442431, 0.0, 0.4>
}
#declare Brick_Oven_r30 = union {
  box { // Brick_oven232
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
  }
  box { // Brick_oven233
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  2.1*y
  }
  box { // Brick_oven234
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.4, 0.15>
    rotate -90.0*z
    translate  4.2*y
  }
  scale <1.0, 0.55, 1.0>
  rotate -90.0*z
  translate  1.021409*x
}
#declare Bricks_Front = union {
  object { Brick_Oven_r31 }
  object { Brick_Oven_r30 }
  box { // Mortar_Front
    <-1, -1, -1>, <1, 1, 1>
    texture {
      oven_mort
    }
    scale <1.852589, 0.3, 0.3>
    translate  <2.138697, 0.0, 0.202309>
  }
  translate  -0.6*y
}
#declare Slit = union {
  cylinder { // Slit_cyl
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.2>
  }
  sphere { // Slit_sp_top
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
    translate  1.2*z
  }
  sphere { // Slit_sp_bottom
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
  }
  translate  <0.720356, -1.0, 0.75>
}
#declare Slit1 = union {
  cylinder { // Slit_cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.2>
  }
  sphere { // Slit_sp_top1
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
    translate  1.2*z
  }
  sphere { // Slit_sp_botto1
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
  }
  translate  <1.702661, -1.0, 0.75>
}
#declare Slit2 = union {
  cylinder { // Slit_cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.2>
  }
  sphere { // Slit_sp_top2
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
    translate  1.2*z
  }
  sphere { // Slit_sp_botto2
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
  }
  translate  <1.206831, -1.0, 0.75>
}
#declare Door_left = difference {
  box { // Door_L
    <-1, -1, -1>, <1, 1, 1>
      texture { rustmetal_tex scale <2, 1, 4> translate <-1.2, -1, -1.5> }


    scale <0.9, 0.05, 0.8>
    translate  <1.265503, -1.0, 1.348774>
  }
  object { Slit }
  object { Slit1 }
  object { Slit2 }
}
#declare Handle_Left = union {
  cylinder { // Hinge_cyl
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.18>
    rotate 90.0*x
    translate  <1.980072, -1.048746, 1.311129>
  }
  superellipsoid { // SuprQ001
    <0.1, 0.1>
    scale <0.042, 0.04, 0.25>
    translate  <1.980072, -1.255914, 1.174955>
  }
  texture {
    Rusty_Chrome scale .3
  }
}
#declare Door_Left = union {
  object { Door_left }
  object { Handle_Left }
  hollow
}
#declare Slit3 = union {
  cylinder { // Slit_cyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.2>
  }
  sphere { // Slit_sp_top3
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
    translate  1.2*z
  }
  sphere { // Slit_sp_botto3
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
  }
  translate  <0.720356, -1.0, 0.75>
}
#declare Slit4 = union {
  cylinder { // Slit_cyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.2>
  }
  sphere { // Slit_sp_top4
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
    translate  1.2*z
  }
  sphere { // Slit_sp_botto4
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
  }
  translate  <1.702661, -1.0, 0.75>
}
#declare Slit5 = union {
  cylinder { // Slit_cyl5
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 1.2>
  }
  sphere { // Slit_sp_top5
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
    translate  1.2*z
  }
  sphere { // Slit_sp_botto5
    <0,0,0>,1
    scale <0.1, 0.1, 0.08>
  }
  translate  <1.206831, -1.0, 0.75>
}
#declare Door_right = difference {
  box { // Door_L1
    <-1, -1, -1>, <1, 1, 1>
    texture { rustmetal_tex scale <2, 1, 4> translate <-1.8, -1, -1.5> }

    scale <0.9, 0.05, 0.8>
    translate  <1.265503, -1.0, 1.348774>
  }
  object { Slit3 }
  object { Slit4 }
  object { Slit5 }
  scale -1.0
  rotate <-180.0, -0.43958, 0.0>
  translate  4.359462*x
}
#declare Handle_Right = union {
  cylinder { // Hinge_cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.18>
    rotate <90.0, -15.970734, 0.0>
    translate  <2.345625, -1.048746, 1.310314>
  }
  superellipsoid { // SuprQ2
    <0.1, 0.1>
    scale <0.042, 0.04, 0.25>
    rotate -15.970734*y
    translate  <2.383093, -1.255914, 1.179396>
  }
  texture {
    Rusty_Chrome scale .3
  }
}
#declare Door_Right = union {
  object { Door_right }
  object { Handle_Right }
  hollow
}
#declare Hinge_Right_Low = union {
  cylinder { // Hinge_Middle3
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver3
    }
    scale <0.03, 0.03, 0.08>
    translate  -0.05*z
  }
  cylinder { // Hinge_Top3
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
  }
  sphere { // Hinge_Top_Sp3
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  0.1*z
  }
  cylinder { // Hinge_Bottom3
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
    translate  -0.12*z
  }
  sphere { // Hinge_Bottom_3
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  -0.12*z
  }
  texture {
    Rusty_Iron1
  }
  hollow
  translate  <4.04356, -1.05, 0.84959>
}
#declare Hinge_Right_Top = union {
  cylinder { // Hinge_Middle2
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver3
    }
    scale <0.03, 0.03, 0.08>
    translate  -0.05*z
  }
  cylinder { // Hinge_Top2
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
  }
  sphere { // Hinge_Top_Sp2
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  0.1*z
  }
  cylinder { // Hinge_Bottom2
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
    translate  -0.12*z
  }
  sphere { // Hinge_Bottom_2
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  -0.12*z
  }
  texture {
    Rusty_Iron1
  }
  hollow
  translate  <4.027518, -1.1, 1.673085>
}
#declare Hinge_Left_Low = union {
  cylinder { // Hinge_Middle1
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver3
    }
    scale <0.03, 0.03, 0.08>
    translate  -0.05*z
  }
  cylinder { // Hinge_Top1
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
  }
  sphere { // Hinge_Top_Sp1
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  0.1*z
  }
  cylinder { // Hinge_Bottom1
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
    translate  -0.12*z
  }
  sphere { // Hinge_Bottom_1
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  -0.12*z
  }
  texture {
    Rusty_Iron1
  }
  hollow
  translate  <0.34114, -1.1, 0.85214>
}
#declare Hinge_Left_Top = union {
  cylinder { // Hinge_Middle
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver3
    }
    scale <0.03, 0.03, 0.08>
    translate  -0.05*z
  }
  cylinder { // Hinge_Top
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
  }
  sphere { // Hinge_Top_Sp
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  0.1*z
  }
  cylinder { // Hinge_Bottom
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.1>
    translate  -0.12*z
  }
  sphere { // Hinge_Bottom_Sp
    <0,0,0>,1
    scale <0.04, 0.04, 0.03>
    translate  -0.12*z
  }
  texture {
    Rusty_Iron1
  }
  hollow
  translate  <0.340658, -1.1, 1.668598>
}
#declare Hinges = union {
  object { Hinge_Right_Low }
  object { Hinge_Right_Top }
  object { Hinge_Left_Low }
  object { Hinge_Left_Top }
}
union { // Oven
  object { Oven_Arch }
  object { Brick_Oven_wL }
  object { Brick_Oven_wR }
  object { Mortar_Arch_CSG }
  object { Bricks_Front }
  object { Door_Left }
  object { Door_Right }
  object { Hinges }
  box { // Verkleedung
    <-1, -1, -1>, <1, 1, 1>
    texture {
      black
    }
    scale <2.007726, 0.160535, 1.74978>
    translate  <2.227148, 5.401772, 1.781947>
  }
  box { // verkleedung2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      black
    }
    scale <2.234823, 3.367806, 0.051808>
    translate  <2.108535, 2.661325, 0.637577>
  }
  texture {
    oven_tex
  }
  hollow
}




union { // Coal_Heap
  box { // Coal_Brick30
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 33.880619*z
    translate  <10.816782, 1.483165, 0.0>
  }
  box { // Coal_Brick28
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-0.0, 35.0, -30.0>
    translate  <14.126778, 1.233748, 0.283108>
  }
  box { // Coal_Brick27
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -21.37351*z
    translate  <13.4606, 0.485497, 0.0>
  }
  box { // Coal_Brick26
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <0.0, -24.447229, 40.351337>
    translate  <13.293256, 0.086431, 0.230025>
  }
  box { // Coal_Brick25
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-90.0, 0.0, -29.737728>
    translate  <12.993956, 0.934448, 0.513133>
  }
  box { // Coal_Brick24
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -37.47752*z
    translate  <10.467599, 2.430948, 0.0>
  }
  box { // Coal_Brick23
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    translate  <11.914216, 5.174533, 0.406967>
  }
  box { // Coal_Brick22
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    translate  <10.417715, 2.730249, 0.406967>
  }
  box { // Coal_Brick21
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-5.017887, 58.161598, 82.12468>
    translate  <14.158967, 5.140092, 0.368667>
  }
  box { // Coal_Brick20
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -16.507351*z
    translate  <13.7599, 4.625816, 0.0>
  }
  box { // Coal_Brick19
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-90.0, 0.0, -33.767151>
    translate  <11.565032, 2.630482, 0.513133>
  }
  box { // Coal_Brick18
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -90.0*y
    translate  <14.508151, 3.950491, 0.299542>
  }
  box { // Coal_Brick17
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <3.499721, -34.583179, -10.258041>
    translate  <12.918281, 4.575933, 0.247719>
  }
  box { // Coal_Brick16
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -39.471642*y
    translate  <10.733012, 3.428616, 0.283108>
  }
  box { // Coal_Brick15
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-16.975811, -90.0, 0.0>
    translate  <12.163633, 4.077099, 0.300802>
  }
  box { // Coal_Brick14
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 45.471245*z
    translate  <10.068532, 4.326516, 0.0>
  }
  box { // Coal_Brick13
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 50.096077*y
    translate  <14.194356, 3.278966, 0.318496>
  }
  box { // Coal_Brick12
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -46.354931*z
    translate  <13.029344, 1.932115, 0.406967>
  }
  box { // Coal_Brick11
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -41.135326*z
    translate  <12.662466, 3.179199, 0.424662>
  }
  box { // Coal_Brick10
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 6.29564*z
    translate  <12.485635, 3.414041, 0.0>
  }
  box { // Coal_Brick9
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -1.728827*z
    translate  <12.916803, 2.54529, 0.0>
  }
  box { // Coal_Brick8
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-90.0, 0.0, -2.875542>
    translate  <10.8432, 4.999704, 0.106165>
  }
  box { // Coal_Brick7
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -80.501892*z
    translate  <12.574797, 1.524412, 0.0>
  }
  box { // Coal_Brick6
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <34.125168, 0.0, -90.0>
    translate  <11.840044, 1.084098, 0.159248>
  }
  box { // Coal_Brick5
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate <-90.0, 0.0, -76.227592>
    translate  <13.551476, 3.457511, 0.106165>
  }
  box { // Coal_Brick4
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 7.051267*z
    translate  <14.145376, 2.454414, 0.0>
  }
  box { // Coal_Brick3
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 68.355278*z
    translate  <13.536647, 1.578741, 0.0>
  }
  box { // Coal_Brick2
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate -115.765404*z
    translate  <11.473902, 3.392068, 0.0>
  }
  box { // Coal_Brick1
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 46.361496*z
    translate  <11.806543, 4.631246, 0.0>
  }
  box { // Coal_Brick
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 47.583488*z
    translate  <11.725541, 2.479848, 0.0>
  }
  box { // Coal_Brick29
    <-1, -1, -1>, <1, 1, 1>
    texture { Coal_tex }
    scale <0.5, 0.3, 0.2>
    rotate 45.471245*z
    translate  <11.030112, -0.577542, 0.0>
  }

  hollow
}


#declare Shovel_Blade = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.779732, -4.540533, 2.033317>, <-1.561327, -4.540533, 1.893851>, <-1.086508, -4.540533, 1.754386>, <-0.856572, -4.540533, 1.754386>,
      <-3.133178, -3.690402, 1.517321>, <-2.401397, -3.737073, 1.377855>, <-1.693225, -3.690402, 1.238390>, <-1.206601, -3.690402, 1.238390>,
      <-3.833236, -2.886943, 1.104524>, <-3.194796, -2.793602, 0.965059>, <-2.159930, -2.793602, 0.825593>, <-1.439953, -2.816937, 0.825593>,
      <-4.346612, -1.920136, 0.898126>, <-3.614831, -1.896801, 0.758660>, <-2.579965, -1.896801, 0.619195>, <-1.675771, -1.908468, 0.567595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.346612, -1.920136, 0.898126>, <-3.614831, -1.896801, 0.758660>, <-2.579965, -1.896801, 0.619195>, <-1.675771, -1.908468, 0.567595>,
      <-4.859988, -0.953329, 0.691727>, <-4.034866, -1.000000, 0.552262>, <-3.000000, -1.000000, 0.412797>, <-1.911588, -1.000000, 0.309598>,
      <-5.000000, 0.000000, 0.382130>, <-4.034866, 0.000000, 0.242664>, <-3.000000, 0.000000, 0.103199>, <-1.911588, 0.000000, -0.000000>,
      <-5.000000, 1.000000, 0.330530>, <-4.034866, 1.000000, 0.191065>, <-3.000000, 1.000000, 0.051600>, <-1.911588, 1.000000, -0.051600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.000000, 1.000000, 0.330530>, <-4.034866, 1.000000, 0.191065>, <-3.000000, 1.000000, 0.051600>, <-1.911588, 1.000000, -0.051600>,
      <-5.000000, 2.000000, 0.278931>, <-4.034866, 2.000000, 0.139465>, <-3.000000, 2.000000, 0.000000>, <-1.911588, 2.000000, -0.103199>,
      <-5.000000, 3.000000, 0.278931>, <-4.034866, 3.000000, 0.139465>, <-3.000000, 3.000000, 0.000000>, <-2.004929, 3.000000, 0.257998>,
      <-5.000000, 4.000000, 0.278931>, <-4.034866, 4.000000, 0.139465>, <-3.000000, 4.000000, 0.000000>, <-2.004929, 4.000000, 0.257998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.856572, -4.540533, 1.754386>, <-0.626636, -4.540533, 1.754386>, <-0.233353, -4.587203, 1.754386>, <-0.050087, -4.563868, 1.754386>,
      <-1.206601, -3.690402, 1.238390>, <-0.719977, -3.690402, 1.238390>, <0.000000, -3.690402, 1.238390>, <0.509959, -3.713738, 1.238390>,
      <-1.439953, -2.816937, 0.825593>, <-0.719977, -2.840272, 0.825593>, <0.000000, -2.793602, 0.825593>, <0.603300, -2.793602, 0.825593>,
      <-1.675771, -1.908468, 0.567595>, <-0.771576, -1.920136, 0.515996>, <-0.214947, -1.896801, 0.515996>, <0.694177, -1.896801, 0.567595>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.675771, -1.908468, 0.567595>, <-0.771576, -1.920136, 0.515996>, <-0.214947, -1.896801, 0.515996>, <0.694177, -1.896801, 0.567595>,
      <-1.911588, -1.000000, 0.309598>, <-0.823176, -1.000000, 0.206398>, <-0.429893, -1.000000, 0.206398>, <0.785053, -1.000000, 0.309598>,
      <-1.911588, 0.000000, -0.000000>, <-0.823176, 0.000000, -0.103199>, <-0.429893, 0.000000, -0.103199>, <0.785053, 0.000000, -0.000000>,
      <-1.911588, 1.000000, -0.051600>, <-0.823176, 1.000000, -0.154799>, <-0.429893, 1.000000, -0.154799>, <0.785053, 1.000000, -0.051600>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.911588, 1.000000, -0.051600>, <-0.823176, 1.000000, -0.154799>, <-0.429893, 1.000000, -0.154799>, <0.785053, 1.000000, -0.051600>,
      <-1.911588, 2.000000, -0.103199>, <-0.823176, 2.000000, -0.206398>, <-0.429893, 2.000000, -0.206398>, <0.785053, 2.000000, -0.103199>,
      <-2.004929, 3.000000, 0.257998>, <-1.009858, 3.000000, 0.515996>, <-0.243211, 3.000000, 0.515996>, <0.878395, 3.000000, 0.257998>,
      <-2.004929, 4.000000, 0.257998>, <-1.009858, 4.000000, 0.515996>, <-0.243211, 4.000000, 0.515996>, <0.878395, 4.000000, 0.257998>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.050087, -4.563868, 1.754386>, <0.133178, -4.540533, 1.754386>, <0.538265, -4.587203, 1.893851>, <0.919744, -4.540533, 2.033317>,
      <0.509959, -3.713738, 1.238390>, <1.019919, -3.737073, 1.238390>, <1.378335, -3.737073, 1.377855>, <2.179849, -3.783744, 1.517321>,
      <0.603300, -2.793602, 0.825593>, <1.206601, -2.793602, 0.825593>, <2.171734, -2.793602, 0.965059>, <3.019919, -2.793602, 1.104524>,
      <0.694177, -1.896801, 0.567595>, <1.603300, -1.896801, 0.619195>, <2.568434, -1.896801, 0.758660>, <3.509959, -1.896801, 0.898126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.694177, -1.896801, 0.567595>, <1.603300, -1.896801, 0.619195>, <2.568434, -1.896801, 0.758660>, <3.509959, -1.896801, 0.898126>,
      <0.785053, -1.000000, 0.309598>, <2.000000, -1.000000, 0.412797>, <2.965134, -1.000000, 0.552262>, <4.000000, -1.000000, 0.691727>,
      <0.785053, 0.000000, -0.000000>, <2.000000, 0.000000, 0.103199>, <2.965134, 0.000000, 0.242664>, <4.000000, 0.000000, 0.382130>,
      <0.785053, 1.000000, -0.051600>, <2.000000, 1.000000, 0.051600>, <2.965134, 1.000000, 0.191065>, <4.000000, 1.000000, 0.330530>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.785053, 1.000000, -0.051600>, <2.000000, 1.000000, 0.051600>, <2.965134, 1.000000, 0.191065>, <4.000000, 1.000000, 0.330530>,
      <0.785053, 2.000000, -0.103199>, <2.000000, 2.000000, 0.000000>, <2.965134, 2.000000, 0.139465>, <4.000000, 2.000000, 0.278931>,
      <0.878395, 3.000000, 0.257998>, <2.000000, 3.000000, 0.000000>, <2.965134, 3.000000, 0.139465>, <4.000000, 3.000000, 0.278931>,
      <0.878395, 4.000000, 0.257998>, <2.000000, 4.000000, 0.000000>, <2.965134, 4.000000, 0.139465>, <4.000000, 4.000000, 0.278931>
    }
  }
  texture {
    Brushed
  }
  scale <0.8, 1.0, 1.0>
  rotate <-0.0, 31.031914, -0.0>
}
#declare BzPtch001 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.867399, 0.000000, 0.000000>, <0.867399, -0.517249, 0.000000>, <0.477069, -0.940453, 0.000000>, <0.000000, -0.940453, 0.000000>,
      <0.867399, 0.000000, 3.023104>, <0.867399, -0.517249, 3.023104>, <0.477069, -0.940453, 3.023104>, <0.000000, -0.940453, 3.023104>,
      <0.867399, 0.000000, 6.046209>, <0.867399, -0.517249, 6.046209>, <0.477069, -0.940453, 6.046209>, <0.000000, -0.940453, 6.046209>,
      <0.867399, -0.334358, 9.002442>, <0.867399, -0.851607, 9.002442>, <0.477069, -1.274810, 9.002442>, <0.000000, -1.274810, 9.002442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.940453, 0.000000>, <-0.477069, -0.940453, 0.000000>, <-0.867399, -0.517249, 0.000000>, <-0.867399, 0.000000, 0.000000>,
      <0.000000, -0.940453, 3.023104>, <-0.477069, -0.940453, 3.023104>, <-0.867399, -0.517249, 3.023104>, <-0.867399, 0.000000, 3.023104>,
      <0.000000, -0.940453, 6.046209>, <-0.477069, -0.940453, 6.046209>, <-0.867399, -0.517249, 6.046209>, <-0.867399, 0.000000, 6.046209>,
      <0.000000, -1.274810, 9.002442>, <-0.477069, -1.274810, 9.002442>, <-0.867399, -0.851607, 9.002442>, <-0.867399, -0.334358, 9.002442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.867399, 0.000000, 0.000000>, <-0.867399, 0.517249, 0.000000>, <-0.477069, 0.940453, 0.000000>, <0.000000, 0.940453, 0.000000>,
      <-0.867399, 0.000000, 3.023104>, <-0.867399, 0.517249, 3.023104>, <-0.477069, 0.940453, 3.023104>, <0.000000, 0.940453, 3.023104>,
      <-0.867399, 0.000000, 6.046209>, <-0.867399, 0.517249, 6.046209>, <-0.477069, 0.940453, 6.046209>, <0.000000, 0.940453, 6.046209>,
      <-0.867399, -0.334358, 9.002442>, <-0.867399, 0.182891, 9.002442>, <-0.477069, 0.606095, 9.002442>, <0.000000, 0.606095, 9.002442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.940453, 0.000000>, <0.477069, 0.940453, 0.000000>, <0.867399, 0.517249, 0.000000>, <0.867399, 0.000000, 0.000000>,
      <0.000000, 0.940453, 3.023104>, <0.477069, 0.940453, 3.023104>, <0.867399, 0.517249, 3.023104>, <0.867399, 0.000000, 3.023104>,
      <0.000000, 0.940453, 6.046209>, <0.477069, 0.940453, 6.046209>, <0.867399, 0.517249, 6.046209>, <0.867399, 0.000000, 6.046209>,
      <0.000000, 0.606095, 9.002442>, <0.477069, 0.606095, 9.002442>, <0.867399, 0.182891, 9.002442>, <0.867399, -0.334358, 9.002442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.867399, -0.334358, 9.002442>, <0.867399, -0.851607, 9.002442>, <0.477069, -1.274810, 9.002442>, <0.000000, -1.274810, 9.002442>,
      <0.867399, -0.668715, 11.958674>, <0.867399, -1.185964, 11.958674>, <0.477069, -1.609168, 11.958674>, <0.000000, -1.609168, 11.958674>,
      <0.867399, -1.337431, 14.981779>, <0.867399, -1.854680, 14.981779>, <0.477069, -2.277883, 14.981779>, <0.000000, -2.277883, 14.981779>,
      <0.867399, -1.538045, 18.004883>, <0.867399, -1.988423, 18.004883>, <0.477069, -2.411626, 18.004883>, <0.000000, -2.478498, 18.004883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -1.274810, 9.002442>, <-0.477069, -1.274810, 9.002442>, <-0.867399, -0.851607, 9.002442>, <-0.867399, -0.334358, 9.002442>,
      <0.000000, -1.609168, 11.958674>, <-0.477069, -1.609168, 11.958674>, <-0.867399, -1.185964, 11.958674>, <-0.867399, -0.668715, 11.958674>,
      <0.000000, -2.277883, 14.981779>, <-0.477069, -2.277883, 14.981779>, <-0.867399, -1.854680, 14.981779>, <-0.867399, -1.337431, 14.981779>,
      <0.000000, -2.478498, 18.004883>, <-0.477069, -2.411626, 18.004883>, <-0.867399, -1.988423, 18.004883>, <-0.867399, -1.538045, 18.004883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.867399, -0.334358, 9.002442>, <-0.867399, 0.182891, 9.002442>, <-0.477069, 0.606095, 9.002442>, <0.000000, 0.606095, 9.002442>,
      <-0.867399, -0.668715, 11.958674>, <-0.867399, -0.151466, 11.958674>, <-0.477069, 0.271737, 11.958674>, <0.000000, 0.271737, 11.958674>,
      <-0.867399, -1.337431, 14.981779>, <-0.867399, -0.820182, 14.981779>, <-0.477069, -0.396978, 14.981779>, <0.000000, -0.396978, 14.981779>,
      <-0.867399, -1.538045, 18.004883>, <-0.867399, -0.953925, 18.004883>, <-0.477069, -0.530721, 18.004883>, <0.000000, -0.597593, 18.004883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.606095, 9.002442>, <0.477069, 0.606095, 9.002442>, <0.867399, 0.182891, 9.002442>, <0.867399, -0.334358, 9.002442>,
      <0.000000, 0.271737, 11.958674>, <0.477069, 0.271737, 11.958674>, <0.867399, -0.151466, 11.958674>, <0.867399, -0.668715, 11.958674>,
      <0.000000, -0.396978, 14.981779>, <0.477069, -0.396978, 14.981779>, <0.867399, -0.820182, 14.981779>, <0.867399, -1.337431, 14.981779>,
      <0.000000, -0.597593, 18.004883>, <0.477069, -0.530721, 18.004883>, <0.867399, -0.953925, 18.004883>, <0.867399, -1.538045, 18.004883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.867399, -1.538045, 18.004883>, <0.867399, -1.988423, 18.004883>, <0.477069, -2.411626, 18.004883>, <0.000000, -2.478498, 18.004883>,
      <0.867399, -1.604917, 21.027987>, <0.867399, -2.122166, 21.027987>, <0.477069, -2.545370, 21.027987>, <0.000000, -2.545370, 21.027987>,
      <0.867399, -1.337431, 24.051092>, <0.867399, -1.854680, 24.051092>, <0.477069, -2.277883, 24.051092>, <0.000000, -2.277883, 24.051092>,
      <0.867399, -0.936202, 27.074196>, <0.867399, -1.453451, 27.074196>, <0.477069, -1.876654, 27.074196>, <0.000000, -1.876654, 27.074196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.478498, 18.004883>, <-0.477069, -2.411626, 18.004883>, <-0.867399, -1.988423, 18.004883>, <-0.867399, -1.538045, 18.004883>,
      <0.000000, -2.545370, 21.027987>, <-0.477069, -2.545370, 21.027987>, <-0.867399, -2.122166, 21.027987>, <-0.867399, -1.604917, 21.027987>,
      <0.000000, -2.277883, 24.051092>, <-0.477069, -2.277883, 24.051092>, <-0.867399, -1.854680, 24.051092>, <-0.867399, -1.337431, 24.051092>,
      <0.000000, -1.876654, 27.074196>, <-0.477069, -1.876654, 27.074196>, <-0.867399, -1.453451, 27.074196>, <-0.867399, -0.936202, 27.074196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.867399, -1.538045, 18.004883>, <-0.867399, -0.953925, 18.004883>, <-0.477069, -0.530721, 18.004883>, <0.000000, -0.597593, 18.004883>,
      <-0.867399, -1.604917, 21.027987>, <-0.867399, -1.087668, 21.027987>, <-0.477069, -0.664464, 21.027987>, <0.000000, -0.664464, 21.027987>,
      <-0.867399, -1.337431, 24.051092>, <-0.867399, -0.820182, 24.051092>, <-0.477069, -0.396978, 24.051092>, <0.000000, -0.396978, 24.051092>,
      <-0.867399, -0.936202, 27.074196>, <-0.867399, -0.418953, 27.074196>, <-0.477069, 0.004251, 27.074196>, <0.000000, 0.004251, 27.074196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -0.597593, 18.004883>, <0.477069, -0.530721, 18.004883>, <0.867399, -0.953925, 18.004883>, <0.867399, -1.538045, 18.004883>,
      <0.000000, -0.664464, 21.027987>, <0.477069, -0.664464, 21.027987>, <0.867399, -1.087668, 21.027987>, <0.867399, -1.604917, 21.027987>,
      <0.000000, -0.396978, 24.051092>, <0.477069, -0.396978, 24.051092>, <0.867399, -0.820182, 24.051092>, <0.867399, -1.337431, 24.051092>,
      <0.000000, 0.004251, 27.074196>, <0.477069, 0.004251, 27.074196>, <0.867399, -0.418953, 27.074196>, <0.867399, -0.936202, 27.074196>
    }
  }
  texture {
    T_Wood14 scale .5
  }
  scale <0.8, 0.8, 1.0>
  rotate <-90.0, 33.177753, -0.0>
  translate  <-0.50554, 2.496394, -0.395677>
}
union { // Shovel
  object { Shovel_Blade }
  object { BzPtch001 }
  hollow
  scale 0.13
  rotate <81.551689, -4.530652, -118.005463>
  translate  <14.309026, 2.386651, 0.734234>
}


#declare Brick_Row23 = union {
  box { // Brick462
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick463
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick464
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick465
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick466
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick467
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick468
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick469
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick470
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick471
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
}
#declare Brick_Row24 = union {
  box { // Brick483
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick484
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick485
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick486
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick487
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick488
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick489
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick490
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick491
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick492
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db11 = union {
  object { Brick_Row23 }
  object { Brick_Row24 }
  translate  1.6*z
}
#declare Brick_Row25 = union {
  box { // Brick504
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick505
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick506
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick507
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick508
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick509
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick510
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick511
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick512
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick513
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick514
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row26 = union {
  box { // Brick525
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick526
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick527
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick528
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick529
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick530
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick531
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick532
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick533
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick534
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db12 = union {
  object { Brick_Row25 }
  object { Brick_Row26 }
  translate  3.2*z
}
#declare Brick_Row27 = union {
  box { // Brick546
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick547
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick548
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick549
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick550
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick551
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick552
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick553
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick554
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick555
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick556
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row28 = union {
  box { // Brick567
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick568
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick569
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick570
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick571
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick572
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick573
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick574
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick575
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick576
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db13 = union {
  object { Brick_Row27 }
  object { Brick_Row28 }
  translate  4.8*z
}
#declare Brick_Row29 = union {
  box { // Brick588
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick589
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick590
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick591
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick592
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick593
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick594
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick595
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick596
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick597
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick598
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row30 = union {
  box { // Brick609
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick610
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick611
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick612
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick613
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick614
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick615
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick616
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick617
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick618
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick619
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db14 = union {
  object { Brick_Row29 }
  object { Brick_Row30 }
  translate  6.4*z
}
#declare Brick_Row31 = union {
  box { // Brick630
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick631
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick632
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick633
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick634
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick635
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick636
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick637
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick638
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick639
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick640
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row32 = union {
  box { // Brick651
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick652
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick653
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick654
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick655
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick656
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick657
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick658
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick659
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick660
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick661
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db15 = union {
  object { Brick_Row31 }
  object { Brick_Row32 }
  translate  8.0*z
}
#declare Brick_Row33 = union {
  box { // Brick672
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick673
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick674
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.6, 0.3>
    translate  <3.861149, -0.0, 0.0>
  }
  box { // Brick680
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick681
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick682
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row34 = union {
  box { // Brick693
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick694
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick700
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.6, 0.3>
    translate  <15.951993, 0.0, 0.0>
  }
  box { // Brick701
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick702
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick703
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db16 = union {
  object { Brick_Row33 }
  object { Brick_Row34 }
  translate  9.6*z
}
#declare Brick_Row35 = union {
  box { // Brick714
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick715
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick716
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.6, 0.3>
    translate  <3.829234, -0.0, -0.0>
  }
  box { // Brick722
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick723
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick724
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row36 = union {
  box { // Brick735
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick736
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick742
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.6, 0.3>
    translate  <15.965136, 0.0, -0.0>
  }
  box { // Brick743
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick744
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick745
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db17 = union {
  object { Brick_Row35 }
  object { Brick_Row36 }
  translate  11.2*z
}
#declare Brick_Row37 = union {
  box { // Brick756
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick757
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick758
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.6, 0.3>
    translate  <3.829234, -0.0, 0.0>
  }
  box { // Brick764
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick765
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick766
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row38 = union {
  box { // Brick777
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick778
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick784
    <-1, -1, -1>, <1, 1, 1>
    scale <0.45, 0.6, 0.3>
    translate  <15.938851, 0.0, 0.0>
  }
  box { // Brick785
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick786
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick787
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db18 = union {
  object { Brick_Row37 }
  object { Brick_Row38 }
  translate  12.8*z
}
#declare Brick_Row39 = union {
  box { // Brick798
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick799
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick800
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick801
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick802
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick803
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick804
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick805
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick806
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick807
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick808
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row40 = union {
  box { // Brick819
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick820
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick821
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick822
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick823
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick824
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick825
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick826
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick827
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick828
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick829
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db19 = union {
  object { Brick_Row39 }
  object { Brick_Row40 }
  translate  14.4*z
}
#declare Brick_Row41 = union {
  box { // Brick840
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick841
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick842
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick843
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick844
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick845
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick846
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick847
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick848
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick849
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick850
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
}
#declare Brick_Row42 = union {
  box { // Brick861
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick862
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick863
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick864
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick865
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick866
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick867
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick868
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick869
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick870
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick871
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db20 = union {
  object { Brick_Row41 }
  object { Brick_Row42 }
  translate  16.0*z
}
#declare Brick_Row43 = union {
  box { // Brick882
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick883
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick884
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick885
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick886
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick887
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick888
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick889
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick890
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick891
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
}
#declare Brick_Row44 = union {
  box { // Brick903
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick904
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick905
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick906
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick907
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick908
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick909
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick910
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick911
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db21 = union {
  object { Brick_Row43 }
  object { Brick_Row44 }
}
#declare Window_CGS = difference {
  box { // Mortar1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Mortar_Tex
    }
    scale <-14.070001, -0.06, -6.09>
    rotate 90.0*z
    translate  <14.996998, -7.788669, 5.95>
  }
  box { // CSG_Wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Mortar_Tex
    }
    scale <0.256581, 3.691723, 1.743139>
    translate  <15.06873, -0.507563, 8.104323>
  }
  scale <1.666667, 1.666667, 1.428571>
  rotate 90.0*z
  translate  <9.618886, -25.394997, 0.0>
}
#declare Brick_Wall1 = union {
  object { Brick_row_db11 }
  object { Brick_row_db12 }
  object { Brick_row_db13 }
  object { Brick_row_db14 }
  object { Brick_row_db15 }
  object { Brick_row_db16 }
  object { Brick_row_db17 }
  object { Brick_row_db18 }
  object { Brick_row_db19 }
  object { Brick_row_db20 }
  object { Brick_row_db21 }
  object { Window_CGS }
  texture {
    Brick_Tex
  }
  rotate -90.0*z
  translate  <22.8, -0.4, 0.0>
}
#declare Brick_Row3 = union {
  box { // Brick42
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick43
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick44
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick45
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick46
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick47
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick48
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick49
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick50
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick51
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick52
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick53
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick54
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick55
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick56
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick57
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick58
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick59
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick60
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick61
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick62
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row4 = union {
  box { // Brick63
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick64
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick65
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick66
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick67
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick68
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick69
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick70
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick71
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick72
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick73
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick74
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick75
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick76
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick77
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick78
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick79
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick80
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick81
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick82
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick83
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl1 = union {
  object { Brick_Row3 }
  object { Brick_Row4 }
  translate  1.6*z
}
#declare Brick_Row5 = union {
  box { // Brick84
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick85
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick86
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick87
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick88
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick89
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick90
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick91
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick92
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick93
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick94
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick95
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick96
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick97
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick98
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick99
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick100
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick101
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick102
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick103
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick104
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row6 = union {
  box { // Brick105
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick106
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick107
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick108
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick109
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick110
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick111
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick112
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick113
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick114
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick115
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick116
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick117
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick118
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick119
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick120
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick121
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick122
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick123
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick124
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick125
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl2 = union {
  object { Brick_Row5 }
  object { Brick_Row6 }
  translate  3.2*z
}
#declare Brick_Row7 = union {
  box { // Brick126
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick127
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick128
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick129
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick130
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick131
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick132
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick133
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick134
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick135
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick136
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick137
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick138
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick139
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick140
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick141
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick142
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick143
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick144
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick145
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick146
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row8 = union {
  box { // Brick147
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick148
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick149
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick150
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick151
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick152
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick153
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick154
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick155
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick156
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick157
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick158
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick159
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick160
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick161
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick162
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick163
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick164
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick165
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick166
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick167
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl3 = union {
  object { Brick_Row7 }
  object { Brick_Row8 }
  translate  4.8*z
}
#declare Brick_Row9 = union {
  box { // Brick168
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick169
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick170
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick171
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick172
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick173
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick174
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick175
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick176
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick177
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick178
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick179
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick180
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick181
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick182
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick183
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick184
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick185
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick186
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick187
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick188
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row10 = union {
  box { // Brick189
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick190
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick191
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick192
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick193
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick194
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick195
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick196
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick197
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick198
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick199
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick200
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick201
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick202
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick203
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick204
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick205
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick206
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick207
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick208
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick209
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl4 = union {
  object { Brick_Row9 }
  object { Brick_Row10 }
  translate  6.4*z
}
#declare Brick_Row11 = union {
  box { // Brick210
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick211
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick212
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick213
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick214
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick215
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick216
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick217
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick218
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick219
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick220
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick221
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick222
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick223
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick224
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick225
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick226
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick227
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick228
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick229
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick230
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row12 = union {
  box { // Brick231
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick232
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick233
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick234
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick235
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick236
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick237
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick238
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick239
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick240
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick241
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick242
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick243
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick244
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick245
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick246
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick247
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick248
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick249
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick250
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick251
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl5 = union {
  object { Brick_Row11 }
  object { Brick_Row12 }
  translate  8.0*z
}
#declare Brick_Row13 = union {
  box { // Brick252
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick253
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick254
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick255
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick256
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick257
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick258
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick259
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick260
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick261
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick262
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick263
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick264
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick265
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick266
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick267
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick268
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick269
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick270
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick271
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick272
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row14 = union {
  box { // Brick273
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick274
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick275
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick276
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick277
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick278
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick279
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick280
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick281
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick282
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick283
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick284
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick285
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick286
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick287
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick288
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick289
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick290
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick291
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick292
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick293
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl6 = union {
  object { Brick_Row13 }
  object { Brick_Row14 }
  translate  9.6*z
}
#declare Brick_Row15 = union {
  box { // Brick294
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick295
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick296
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick297
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick298
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick299
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick300
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick301
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick302
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick303
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick304
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick305
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick306
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick307
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick308
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick309
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick310
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick311
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick312
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick313
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick314
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row16 = union {
  box { // Brick315
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick316
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick317
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick318
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick319
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick320
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick321
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick322
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick323
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick324
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick325
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick326
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick327
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick328
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick329
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick330
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick331
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick332
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick333
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick334
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick335
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl7 = union {
  object { Brick_Row15 }
  object { Brick_Row16 }
  translate  11.2*z
}
#declare Brick_Row17 = union {
  box { // Brick336
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick337
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick338
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick339
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick340
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick341
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick342
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick343
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick344
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick345
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick346
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick347
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick348
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick349
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick350
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick351
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick352
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick353
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick354
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick355
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick356
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row18 = union {
  box { // Brick357
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick358
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick359
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick360
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick361
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick362
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick363
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick364
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick365
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick366
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick367
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick368
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick369
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick370
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick371
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick372
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick373
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick374
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick375
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick376
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick377
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl8 = union {
  object { Brick_Row17 }
  object { Brick_Row18 }
  translate  12.8*z
}
#declare Brick_Row19 = union {
  box { // Brick378
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick379
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick380
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick381
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick382
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick383
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick384
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick385
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick386
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick387
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick388
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick389
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick390
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick391
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick392
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick393
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick394
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick395
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick396
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick397
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick398
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row20 = union {
  box { // Brick399
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick400
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick401
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick402
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick403
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick404
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick405
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick406
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick407
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick408
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick409
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick410
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick411
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick412
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick413
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick414
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick415
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick416
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick417
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick418
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick419
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl9 = union {
  object { Brick_Row19 }
  object { Brick_Row20 }
  translate  14.4*z
}
#declare Brick_Row21 = union {
  box { // Brick420
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick421
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick422
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick423
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick424
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick425
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick426
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick427
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick428
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick429
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick430
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick431
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick432
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick433
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick434
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick435
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick436
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick437
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick438
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick439
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick440
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row22 = union {
  box { // Brick441
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick442
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick443
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick444
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick445
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick446
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick447
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick448
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick449
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick450
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick451
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick452
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick453
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick454
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick455
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick456
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick457
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick458
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick459
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick460
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick461
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_db10 = union {
  object { Brick_Row21 }
  object { Brick_Row22 }
  translate  16.0*z
}
#declare Brick_Row1 = union {
  box { // Brick
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick2
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick4
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick6
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick9
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick11
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick12
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick13
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick14
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick15
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick16
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick17
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick18
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick19
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick20
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
}
#declare Brick_Row2 = union {
  box { // Brick21
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
  }
  box { // Brick22
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  2.2*x
  }
  box { // Brick23
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  4.4*x
  }
  box { // Brick24
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  6.6*x
  }
  box { // Brick25
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  8.8*x
  }
  box { // Brick26
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  11.0*x
  }
  box { // Brick27
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  13.2*x
  }
  box { // Brick28
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  15.4*x
  }
  box { // Brick29
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  17.6*x
  }
  box { // Brick30
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  19.8*x
  }
  box { // Brick31
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  22.0*x
  }
  box { // Brick32
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  24.2*x
  }
  box { // Brick33
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  26.4*x
  }
  box { // Brick34
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  28.6*x
  }
  box { // Brick35
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  30.8*x
  }
  box { // Brick36
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  33.0*x
  }
  box { // Brick37
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  35.2*x
  }
  box { // Brick38
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  37.4*x
  }
  box { // Brick39
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  39.6*x
  }
  box { // Brick40
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  41.8*x
  }
  box { // Brick41
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.6, 0.3>
    translate  44.0*x
  }
  translate  <1.1, 0.0, 0.8>
}
#declare Brick_row_dbl = union {
  object { Brick_Row1 }
  object { Brick_Row2 }
}
#declare Brick_Wall = union {
  object { Brick_row_dbl1 }
  object { Brick_row_dbl2 }
  object { Brick_row_dbl3 }
  object { Brick_row_dbl4 }
  object { Brick_row_dbl5 }
  object { Brick_row_dbl6 }
  object { Brick_row_dbl7 }
  object { Brick_row_dbl8 }
  object { Brick_row_dbl9 }
  object { Brick_row_db10 }
  object { Brick_row_dbl }
  box { // Mortar
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Mortar_Tex
    }
    scale <-23.450001, -0.1, -8.7>
    rotate -180.0*z
    translate  <22.6, -0.4, 8.5>
  }
  texture {
    Brick_Tex
  }
  translate  -22.7*x
}
union { // Walls
  object { Brick_Wall1 }
  object { Brick_Wall }
  hollow
  scale <0.6, 0.6, 0.7>
  translate  <1.556998, 6.011332, 0.0>
}


#declare Bulb = lathe {
  cubic_spline
  7  // control points
  <0.023657, -0.503148>,
  <0.019628, -0.78586>,
  <0.348287, -0.659573>,
  <0.416684, -0.370722>,
  <0.233638, 0.068954>,
  <0.155522, 0.479581>,
  <0.122001, 0.673303>
  rotate <90,0,90>
  translate  <-0.033067, -0.084341, -0.077389>
}
#declare Broken_bulb = difference {
  object { Bulb }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.505746, 0.551079, 0.374231>
    rotate <-16.895578, 15.608729, 2.050166>
    translate  <-0.091631, -0.106482, -0.967959>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.232056, 0.261347, 0.291993>
    rotate 36.562027*y
    translate  <0.234946, -0.558093, -0.748465>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.203412, 0.503072, 0.27522>
    rotate -37.666245*y
    translate  <-0.024622, -0.041036, -0.637207>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.174711, 0.365106, 0.403701>
    rotate <-43.673061, -35.352734, 14.52334>
    translate  <0.424804, 0.0, -0.879952>
  }
  texture {
    bulb_tex
  }
  translate  <1.936473, -15.025938, 7.203935>
}
#declare screw = lathe {
  linear_spline
  17  // control points
  <0.031654, -1.0>,
  <0.393738, -0.996852>,
  <0.392998, -0.840386>,
  <0.47235, -0.801359>,
  <0.396211, -0.760109>,
  <0.4717, -0.710838>,
  <0.398738, -0.674175>,
  <0.471595, -0.623259>,
  <0.399856, -0.584829>,
  <0.468757, -0.536542>,
  <0.401051, -0.497659>,
  <0.468284, -0.443372>,
  <0.392689, -0.409812>,
  <0.392803, -0.249864>,
  <0.091991, -0.175615>,
  <0.092223, -0.068572>,
  <0.022144, -0.068572>
  rotate <90,0,90>
  pigment {
    Silver
  }
  scale 0.514493
  translate  <1.907914, -15.11199, 7.953516>
}
#declare bulbb = union {
  object { Broken_bulb }
  object { screw }
  scale 0.7
  rotate <0.0, -0.0, -60.0>
  translate  <8.460981, 6.394111, -2.289315>
}
union { // Lightt
  cylinder { // Wire
    <0,0,1>, <0,0,0>, 1
    pigment { DarkBrown }

    scale <0.02, 0.02, 2.6>
    translate  <-0.032055, -0.048239, 3.234205>
  }
  object { bulbb }
  cylinder { // Wire_horiz
    <0,0,1>, <0,0,0>, 1
    pigment { DarkBrown }
    scale <0.02, 0.02, 13.5>
    rotate <0.0, -90.0, -180.0>
    translate  <-0.032055, -0.048239, 5.714131>
  }
  torus { // fit
    1.5, 0.5  rotate -x*90
    texture {
      nonref_silver
    }
    scale <0.034158, 0.031895, 0.05>
    rotate <0.0, -90.0, 0.0>
    translate  <0.0256, -0.048658, 5.717109>
  }
  hollow
  translate  <1.936473, -15.025938, 5.108949>
}


#declare Steps = union {
  box { // Step
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.55, 0.1>
    texture { stair_tex rotate y*90 }
  }
  box { // Step1
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.55, 0.1>
    texture { stair_tex rotate y*90 }
    translate  <0.0, 1.0, 1.0>
  }
  box { // Step2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.55, 0.1>
    texture { stair_tex rotate y*90 }
    translate  <0.0, 2.0, 2.0>
  }
  box { // Step3
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.55, 0.1>
    texture { stair_tex rotate y*90 }
    translate  <0.0, 3.0, 3.0>
  }
  box { // Step4
    <-1, -1, -1>, <1, 1, 1>
    scale <4.0, 0.55, 0.1>
    texture { stair_tex rotate y*90 }
    translate  <0.0, 4.0, 4.0>
  }
}
#declare step_supports = union {
  box { // step_support
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <-3.898084, 0.16777, -0.195732>
    texture { stair_tex }
  }
  box { // step_support1
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <-3.898084, 1.16777, 0.804268>
  }
  box { // step_support2
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <-3.898084, 2.16777, 1.804268>
  }
  box { // step_support3
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <-3.898084, 3.16777, 2.804268>
  }
  box { // step_support4
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <-3.898084, 4.16777, 3.804268>
  }
  box { // step_support5
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <3.894557, 0.16777, -0.195732>
  }
  box { // step_support6
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <3.894557, 1.16777, 0.804268>
  }
  box { // step_support7
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <3.894557, 2.16777, 1.804268>
  }
  box { // step_support8
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <3.894557, 3.16777, 2.804268>
  }
  box { // step_support9
    <-1, -1, -1>, <1, 1, 1>
    texture { stair_tex }
    scale <0.1, 0.25, 0.1>
    translate  <3.894557, 4.16777, 3.804268>
  }
}
#declare gelan = union {
  box { // gelaener
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.5, 0.15>
    rotate 45.0*x
    texture { stair_tex rotate -x*45 translate <1, 2, 1>}
    translate  <4.094735, 1.97243, 4.641639>
  }
  box { // gelaen_poto
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.15, 1.6>
    texture { stair_tex }
    translate  <4.304136, 0.50331, 1.676725>
  }
  box { // gelaen_poto1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.15, 1.6>
    texture { stair_tex translate <2,1,2>}
    translate  <4.304136, 2.50331, 3.676725>
  }
  box { // gelaen_poto2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.15, 1.6>
    texture { stair_tex translate <1,2,1>}
    translate  <4.304136, 4.50331, 5.676725>
  }
}
#declare gelan1 = union {
  box { // gelaener1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.5, 0.15>
    rotate 45.0*x
    texture { stair_tex rotate -x*45 translate <2, 1, 2>}
    translate  <4.094735, 1.97243, 4.641639>
  }
  box { // gelaen_poto3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.15, 1.6>
    texture { stair_tex }
    translate  <4.304136, 0.50331, 1.676725>
  }
  box { // gelaen_poto4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.15, 1.6>
    texture { stair_tex translate <2, 1, 2> }
    translate  <4.304136, 2.50331, 3.676725>
  }
  box { // gelaen_poto5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.15, 1.6>
    texture { stair_tex translate <1,2,1> }
    translate  <4.304136, 4.50331, 5.676725>
  }
  translate  -8.397147*x
}
#declare nails_side = union {
  sphere { // Nail
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 0.498114, 0.230167>
  }
  sphere { // Nail1
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 2.511355, 2.239693>
  }
  sphere { // Nail2
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 4.517256, 4.20815>
  }
  pigment {
    Silver
  }
}
#declare nails_side1 = union {
  sphere { // Nail3
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 0.498114, 0.230167>
  }
  sphere { // Nail4
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 2.511355, 2.239693>
  }
  sphere { // Nail5
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 4.517256, 4.20815>
  }
  pigment {
    Silver
  }
  translate  -8.807696*x
}
#declare nails_side2 = union {
  sphere { // Nail6
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 0.498114, 0.230167>
  }
  sphere { // Nail7
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 2.511355, 2.239693>
  }
  sphere { // Nail8
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 4.517256, 4.20815>
  }
  pigment {
    Silver
  }
  translate  2.899789*z
}
#declare nails_side3 = union {
  sphere { // Nail9
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 0.498114, 0.230167>
  }
  sphere { // Nail10
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 2.511355, 2.239693>
  }
  sphere { // Nail11
    <0,0,0>,1
    scale <0.03, 0.07, 0.07>
    translate  <4.401869, 4.517256, 4.20815>
  }
  pigment {
    Silver
  }
  translate  <-8.807696, 0.0, 2.893142>
}
#declare nails = union {
  object { nails_side }
  object { nails_side1 }
  object { nails_side2 }
  object { nails_side3 }
}
union { // stair
  object { Steps }
  object { step_supports }
  box { // Side_step1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.5, 0.3>
    rotate 45.0*x
    texture { stair_tex rotate -x*45 translate <2, 1, 2> }
    translate  <-4.097752, 2.001823, 1.669709>
  }
  box { // Side_step
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 3.5, 0.3>
    rotate 45.0*x
    texture { stair_tex rotate -x*45 translate <1, 2, 1> }
    translate  <4.097752, 2.001823, 1.669709>
  }
  object { gelan }
  object { gelan1 }
  object { nails }
  hollow
  rotate -180.0*z
  translate  <9.55034, -14.354479, 0.440255>
}


prism {
  linear_sweep
  linear_spline
  -0.01,0.0
  45  // control points
  <-0.125905, 0.701548>,
  <-0.6544, 0.223706>,
  <-0.717972, -0.14214>,
  <-1.340482, -1.236953>,
  <-0.733652, -0.587887>,
  <-0.688625, -0.705882>,
  <-0.563653, -1.544646>,
  <-0.466188, -0.634589>,
  <-0.627532, -0.33441>,
  <-0.493012, -0.159245>,
  <-0.486913, 0.151415>,
  <-0.333826, 0.279284>,
  <-0.217217, 0.103521>,
  <-0.250572, -0.197129>,
  <0.101222, -0.660306>,
  <-0.020049, -0.163563>,
  <0.021439, 0.204367>,
  <-0.174645, 0.389118>,
  <-0.020419, 0.55848>,
  <0.225271, 0.320511>,
  <0.218258, -0.229154>,
  <0.179984, -0.496921>,
  <0.393702, -1.061557>,
  <0.320073, -1.800095>,
  <0.608359, -1.058331>,
  <0.360191, -0.487471>,
  <0.381131, -0.243324>,
  <0.500125, -0.353685>,
  <0.586369, -0.56632>,
  <0.883939, -0.739134>,
  <1.023892, -1.593673>,
  <1.072196, -0.660357>,
  <0.70635, -0.39626>,
  <0.604185, -0.161264>,
  <0.430315, -0.035362>,
  <0.450737, 0.192989>,
  <1.060335, -0.199288>,
  <0.115333, 0.687936>,
  <0.094366, 0.952946>,
  <0.184723, 1.182055>,
  <0.05729, 1.568423>,
  <-0.205007, 1.568423>,
  <-0.103365, 1.276404>,
  <-0.131306, 0.983682>,
  <-0.125905, 0.701548>
  rotate -x*90
  texture {
    lighningtex2
  }
  hollow
  scale <1.200879, 1.697798, 2.5>
  rotate <90.0, 0.0, -50.900002>
  translate  <32.004696, 21.632284, 9.898126>
}


#declare fl_pattern =
union { // Floor_Brick_Pat
  superellipsoid { // Floor_Brick
    <0.1, 0.1>
    texture {
      Floor_Main_Tex
    }
    scale <0.95, 0.45, 0.1>
    translate  -0.5*y
  }
  superellipsoid { // Floor_Brick1
    <0.1, 0.1>
    texture {
      Floor_Main_Tex
    }
    scale <0.95, 0.45, 0.1>
    rotate -90.0*z
    translate  -1.5*x
  }
  superellipsoid { // Floor_Brick2
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <-1.5, 1.5, 0.0>
  }
  superellipsoid { // Floor_Brick4
    <0.1, 0.1>
    texture {
      Floor_Main_Tex
    }
    scale <0.95, 0.45, 0.1>
    rotate -90.0*z
    translate  1.5*x
  }
  superellipsoid { // Floor_Brick5
    <0.1, 0.1>
    texture {
      Floor_Main_Tex
    }
    scale <0.95, 0.45, 0.1>
    translate  0.5*y
  }
  superellipsoid { // Floor_Brick6
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <0.5, 1.5, 0.0>
  }
  superellipsoid { // Floor_Brick7
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <2.5, -0.5, 0.0>
  }
  superellipsoid { // Floor_Brick8
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <2.5, 0.5, 0.0>
  }
  superellipsoid { // Floor_Brick9
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <1.5, 1.5, 0.0>
  }
  superellipsoid { // Floor_Brick10
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <-0.5, 1.5, 0.0>
  }
  superellipsoid { // Floor_Brick13
    <0.1, 0.1>
    texture {
      Floor_Sat_Tex
    }
    scale <0.45, 0.45, 0.1>
    translate  <2.5, 1.5, 0.0>
  }
 // texture { Floor_Tex }
  hollow
  //translate  <-10.777644, 4.015436, -0.228778>
}


#declare cnt_hor=0
#declare cnt_ver=0
#while (cnt_ver<10)
  #while (cnt_hor<8)
    object {fl_pattern translate <-10.777644+(cnt_hor*5), 4.015436+(-cnt_ver*3), -0.228778>
    hollow }
    #declare cnt_hor=cnt_hor+1
  #end
  #declare cnt_hor=0
  #declare cnt_ver=cnt_ver+1
#end

plane { z, -.18
  pigment { Gray75 }
  finish { crand .08 }
  hollow
}


/*
height_field {
  gif "floor31.gif"
  smooth
  finish { crand .05 }
  rotate x*90
  rotate z*180
  translate <.5, .5, 0>
  scale <5, 10, .015>
  translate -y*12

  pigment {
  Gray85
  }

}
*/

/*
object {   // HgtFld001
  height_field {
    gif "floor31.gif"
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  pigment { Gray85 }
  hollow
  scale <16, 15, 0.15>
  translate  <-0.486907, -10.549659, -0.1>
}

*/





// Include contains 'TraSwp001'
#include "cellar1.in7"

#declare TraSwp001 = object {
  TraSwp001_Raw
  scale <5.583223, 1.840258, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-1.907165, 0.192923, -2.040181>
}
// Include contains 'TraSwp2'
#include "cellar1.in8"

#declare TraSwp2 = object {
  TraSwp2_Raw
  scale <5.583223, 1.840258, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <2.279579, 0.192923, -2.040181>
}
// Include contains 'kuff2'
#include "cellar1.in9"

#declare kuff2 = object {
  kuff2_Raw
  texture {
    nonref_silver
  }
  scale <5.583223, 1.840258, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <-1.97891, 0.181529, -2.089963>
}
// Include contains 'kuff'
#include "cellar1.i10"

#declare kuff = object {
  kuff_Raw
  texture {
    nonref_silver
  }
  scale <5.583223, 1.840258, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <2.239346, 0.181696, -2.141219>
}
#declare rumpf = union {
  box { // been
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    translate  <2.093372, -3.22793, -1.106899>
  }
  box { // been1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    translate  <-2.091779, -3.22793, -1.106899>
  }
  box { // been2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    translate  <2.093372, 3.203187, -1.106899>
  }
  box { // been3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 1.0>
    translate  <-2.09619, 3.199195, -1.106899>
  }
  box { // traverse1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.15, 0.1>
    translate  <0.0, -3.223767, -1.000445>
  }
  box { // traverse
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.15, 0.1>
    translate  <0.0, 3.20228, -1.000445>
  }
  object { TraSwp001 }
  object { TraSwp2 }
  object { kuff2 }
  object { kuff }
}
#declare setz = union {
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
    translate  -0.7*x
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
    translate  -1.4*x
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
    translate  -2.1*x
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
    translate  0.7*x
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
    translate  1.4*x
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.22, 5.0, 0.1>
    translate  2.1*x
  }
  box { // quer
    <-1, -1, -1>, <1, 1, 1>
    scale <2.3, 0.2, 0.1>
    translate  -0.2*z
  }
  box { // quer1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.3, 0.2, 0.15>
    translate  <0.0, 3.0, -0.25>
  }
  box { // quer2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.3, 0.2, 0.15>
    translate  <0.0, -3.0, -0.25>
  }
}
#declare front_csg = difference {
  cylinder { // front
    <0,0,1>, <0,0,0>, 1
    scale <0.035, 0.035, 4.2>
    rotate <0.0, -90.0, 0.0>
    translate  <2.115642, 6.235284, 0.0>
  }
  box { // csg_front
    <-1, -1, -1>, <1, 1, 1>
    scale <0.077817, 0.067606, 0.077479>
    translate  <0.000521, 6.230297, -0.011471>
  }

}
#declare half_torus = difference {
  torus { // torus_front
    0.07, 0.03  rotate -x*90
    scale <1.270726, 1.253208, 1.2>
    translate  <0.001373, 6.232969, -0.000642>
  }
  box { // torus_csg
    <-1, -1, -1>, <1, 1, 1>
    scale <0.130721, 0.064934, 0.063035>
    translate  <0.006737, 6.13375, -0.00375>
  }
}
#declare front_cyl = union {
  object { front_csg }
  object { half_torus }
  texture { pigment { Black } finish { specular .2 roughness .005 metallic reflection .05 } }
}
#declare nail = union {
  cylinder { // nail_nail
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.15>
    rotate 90.0*x
    translate  <10.006116, 5.418417, 7.821887>
  }
  cylinder { // nail_point
    <0,0,1>, <0,0,0>, 1
    scale <0.015666, 0.015666, 0.01>
    rotate 90.0*x
    translate  <10.006116, 5.273905, 7.821887>
  }
  texture {
    Silver4
  }
  scale 2.5
  rotate <90.0, -0.0, -180.0>
  translate  <25.01459, -13.297207, -13.258042>
}
union { // schlitt
  object { rumpf }
  object { setz }
  object { front_cyl }
  object { nail }
  hollow
  texture { schlit_tex }
  scale 0.4
  rotate <90.0, 0.0, -180.0>
  translate  <11.972723, 5.574991, 5.318883>
}


#declare Shelf = union {
  box { // Board_horiz
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.05>
    texture { shelf_tx rotate y*90 }
  }
  box { // Board_horiz1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.05>
    texture { shelf_tx rotate y*90 }
    translate  1.0*z
  }
  box { // Board_horiz2
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.05>
    texture { shelf_tx rotate y*90 }
    translate  2.0*z
  }
  box { // Board_horiz3
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 0.05>
    texture { shelf_tx rotate y*90 }
    translate  3.0*z
  }
  box { // Board_vert
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.5, 1.9>
    texture { shelf_tx rotate x*0 }
    translate  <2.0, 0.0, 1.590485>
  }
  box { // Board_vert1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.5, 1.9>
    texture { shelf_tx rotate x*0 }
    translate  <-2.0, 0.0, 1.590485>
  }
  box { // support
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <1.900652, 0.0, -0.148497>
  }
  box { // support1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <-1.898197, 0.0, 0.851503>
  }
  box { // support2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <-1.898197, 0.0, 1.851503>
  }
  box { // support3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <-1.898197, 0.0, 2.851503>
  }
  box { // support4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <1.900652, 0.0, 0.851503>
  }
  box { // support5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <1.900652, 0.0, 1.851503>
  }
  box { // support6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.4, 0.1>
    translate  <1.900652, 0.0, 2.851503>
  }
  texture {
    shelf_tx
  }
}
#declare boxx_front = union {
  box { // boxx_board
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
  }
  box { // boxx_board1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.13*z
  }
  box { // boxx_board2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.26*z
  }
  box { // boxx_board3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.39*z
  }
  box { // boxx_board4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.52*z
  }
  box { // boxx_board5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.65*z
  }
}
#declare boxx_rear = union {
  box { // boxx_board6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.97*y
  }
  box { // boxx_board7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  <0.0, 0.97, 0.13>
  }
  box { // boxx_board8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  <0.0, 0.97, 0.26>
  }
  box { // boxx_board9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  <0.0, 0.97, 0.39>
  }
  box { // boxx_board10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  <0.0, 0.97, 0.52>
  }
  box { // boxx_board11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  <0.0, 0.97, 0.65>
  }
}
#declare boxx_left = union {
  box { // boxx_board13
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    rotate -90.0*z
    translate  <-0.476537, 0.486853, 0.13>
  }
  box { // boxx_board12
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    rotate -90.0*z
    translate  <-0.476537, 0.486853, 0.0>
  }
  box { // boxx_board14
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    rotate -90.0*z
    translate  <-0.476537, 0.486853, 0.26>
  }
  box { // boxx_board15
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    rotate -90.0*z
    translate  <-0.476537, 0.486853, 0.39>
  }
  box { // boxx_board16
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    rotate -90.0*z
    translate  <-0.476537, 0.486853, 0.52>
  }
  box { // boxx_board17
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    rotate -90.0*z
    translate  <-0.476537, 0.486853, 0.65>
  }
}
#declare boxx_right = union {
  box { // boxx_board18
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
  }
  box { // boxx_board19
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.13*z
  }
  box { // boxx_board20
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.26*z
  }
  box { // boxx_board21
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.39*z
  }
  box { // boxx_board22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.52*z
  }
  box { // boxx_board23
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.02, 0.05>
    translate  0.65*z
  }
  rotate -90.0*z
  translate  <0.479792, 0.484222, 0.0>
}
#declare sides = union {
  box { // side_board
    <-1, -1, -1>, <1, 1, 1>
    scale <0.07, 0.015, 0.375>
    translate  <-0.460333, -0.034993, 0.32605>
  }
  box { // side_board1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.015, 0.375>
    rotate -90.0*z
    translate  <-0.51539, 0.029981, 0.32605>
  }
}
#declare sides1 = union {
  box { // side_board2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.07, 0.015, 0.375>
    translate  <-0.460333, -0.034993, 0.32605>
  }
  box { // side_board3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.015, 0.375>
    rotate -90.0*z
    translate  <-0.51539, 0.029981, 0.32605>
  }
  rotate -90.0*z
  translate  <-0.477062, 0.489724, 0.0>
}
#declare sides2 = union {
  box { // side_board4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.07, 0.015, 0.375>
    translate  <-0.460333, -0.034993, 0.32605>
  }
  box { // side_board5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.015, 0.375>
    rotate -90.0*z
    translate  <-0.51539, 0.029981, 0.32605>
  }
  rotate 180.0*z
  translate  <-0.00077, 0.969539, 0.0>
}
#declare sides3 = union {
  box { // side_board6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.07, 0.015, 0.375>
    translate  <-0.460333, -0.034993, 0.32605>
  }
  box { // side_board7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.05, 0.015, 0.375>
    rotate -90.0*z
    translate  <-0.51539, 0.029981, 0.32605>
  }
  rotate 90.0*z
  translate  <0.480291, 0.480675, 0.0>
}
#declare boxxx = union {
  object { boxx_front }
  object { boxx_rear }
  object { boxx_left }
  object { boxx_right }
  object { sides }
  object { sides1 }
  object { sides2 }
  object { sides3 }
  box { // boxx_bottom
    <-1, -1, -1>, <1, 1, 1>
    scale <0.480054, 0.474277, 0.01>
    translate  <0.002981, 0.482363, -0.037778>
  }
  texture {
    DMFWood4
  }
  rotate <0.0, -0.0, 0.0>
}
#declare boxx_handle = union {
  cylinder { // boxx_handle_cyl
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.3>
    rotate -90.0*y
  }
  sphere { // boxx_handle_sph
    <0,0,0>,1
    scale 0.05
  }
  sphere { // boxx_handle_s1
    <0,0,0>,1
    scale 0.05
    translate  -0.3*x
  }
  scale <1.0, 1.0, 1.5>
  rotate 90.0*z
  translate  <0.484156, 0.648925, 0.456468>
}
#declare boxx_handle1 = union {
  cylinder { // boxx_handle_c1
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.3>
    rotate -90.0*y
  }
  sphere { // boxx_handle_s2
    <0,0,0>,1
    scale 0.05
  }
  sphere { // boxx_handle_s3
    <0,0,0>,1
    scale 0.05
    translate  -0.3*x
  }
  scale <1.0, 1.0, 1.5>
  rotate -90.0*z
  translate  <-0.478652, 0.348707, 0.457324>
}
#declare boxxxx = difference {
  object { boxxx }
  object { boxx_handle }
  object { boxx_handle1 }
  texture {
    DMFWood4
  }
  rotate 22.738153*z
  translate  <1.323221, -0.623834, 3.101902>
}
#declare hammerhead = difference {
  box { // hammer_head
    <-1, -1, -1>, <1, 1, 1>
    scale <0.229045, 0.101954, 0.073288>
    translate  0.698309*z
  }
  box { // hammer_head_csg
    <-1, -1, -1>, <1, 1, 1>
    scale <0.229045, 0.127612, 0.073288>
    rotate 25.199831*y
    translate  <0.194646, 0.0, 0.787169>
  }
  texture {
    ironn
  }
}
#declare hammer = union {
  cylinder { // hammer_handle
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Wood10 rotate x*90
    }
    scale <0.05, 0.05, 0.65>
  }
  object { hammerhead }
  rotate <85.259773, 0.0, -78.541214>
  translate  <1.001226, -0.158788, 0.127897>
}
#declare can = union {
  cylinder { // can_body
    <0,0,1>, <0,0,0>, 1
    texture {
      can_tex rotate x*90 rotate z*130
    }

    scale <0.25, 0.25, 0.6>
  }
  cylinder { // rim
    <0,0,1>, <0,0,0>, 1
    texture {
      can_rim_tex
    }
    scale <0.26, 0.26, 0.02>
  }
  cylinder { // rim1
    <0,0,1>, <0,0,0>, 1
    texture {
      can_rim_tex
    }
    scale <0.26, 0.26, 0.02>
    translate  0.587522*z
  }
  torus { // can_handle
    0.22, 0.01  rotate -x*90
    texture {
      ironn
    }
    rotate -20.600002*x
    translate  0.590145*z
  }
  rotate 54.88517*z
  translate  <0.465675, -0.201017, 2.058253>
}
#declare can1 = union {
  cylinder { // can_body1
    <0,0,1>, <0,0,0>, 1
    texture {
      can_tex rotate x*90 rotate -z*20
    }
    scale <0.25, 0.25, 0.6>
  }
  cylinder { // rim2
    <0,0,1>, <0,0,0>, 1
    texture {
      can_rim_tex1
    }
    scale <0.26, 0.26, 0.02>
  }
  cylinder { // rim3
    <0,0,1>, <0,0,0>, 1
    texture {
      can_rim_tex1
    }
    scale <0.26, 0.26, 0.02>
    translate  0.587522*z
  }
  torus { // can_handle1
    0.24, 0.01  rotate -x*90
    texture {
      ironn
    }
    rotate -70.0*x
    translate  0.590145*z
  }
  rotate -11.068522*z
  translate  <-0.324026, 0.142738, 2.059716>
}
#declare can2 = union {
  cylinder { // can_body2
    <0,0,1>, <0,0,0>, 1
    texture {
      can_tex rotate x*90 rotate z*20
    }
    scale <0.25, 0.25, 0.6>
  }
  cylinder { // rim4
    <0,0,1>, <0,0,0>, 1
    texture {
      can_rim_tex2
    }
    scale <0.26, 0.26, 0.02>
  }
  cylinder { // rim5
    <0,0,1>, <0,0,0>, 1
    texture {
      can_rim_tex2
    }
    scale <0.26, 0.26, 0.02>
    translate  0.587522*z
  }
  torus { // can_handle2
    0.24, 0.01  rotate -x*90
    texture {
      ironn
    }
    rotate -70.0*x
    translate  0.590145*z
  }
  scale 0.6
  rotate 72.524536*z
  translate  <1.055204, 0.050313, 2.059716>
}
#declare roll = union {
  cylinder { // roller
    <0,0,1>, <0,0,0>, 1
    pigment { Gray90 }
    normal { bumps frequency 10 scale .01 }
    scale <1.0, 1.0, 6.0>
  }
  torus { // roller_top
    0.75, 0.25  rotate -x*90
    pigment { White }
  }

  torus { // roller_bottom
    0.75, 0.25  rotate -x*90
    pigment { White }
    translate  6.0*z
  }
  cylinder { // roll_still
    <0,0,1>, <0,0,0>, 1
    pigment { Silver }
    scale <0.1, 0.1, 1.0>
    translate  6.0*z
  }
  cylinder { // roll_still2
    <0,0,1>, <0,0,0>, 1
    pigment { Silver }
    scale <0.1, 0.1, 2.5>
    rotate 90.0*y
    translate  7.0*z
  }
  cylinder { // roll_still_3
    <0,0,1>, <0,0,0>, 1
    pigment { Silver }
    scale <0.1, 0.1, 4.1>
    rotate <180.0, 10.0, 180.0>
    translate  <2.5, 0.0, 7.0>
  }
  cylinder { // roll_still_5
    <0,0,1>, <0,0,0>, 1
    pigment { Silver }
    scale <0.1, 0.1, 4.0>
    rotate 90.0*y
    translate  <3.15, 0.0, 3.0>
  }
  superellipsoid { // roll_handle
    <0.1, 0.1>
    scale <2.5, 0.6, 0.6>
    translate  <6.5, 0.0, 3.0>
    pigment { Black }
  }

  scale 0.09
  rotate <-90.0, -75.672096, 75.776276>
  translate  <1.640947, 0.175211, 1.138073>
}
union { // shelf_obj
  object { Shelf }
  object { boxxxx }
  object { hammer }
  object { can }
  object { can1 }
  object { can2 }
  object { roll }
  hollow
  translate  <-6.755705, 5.162378, 3.975685>
}


#declare wheel_csg = difference {
  cylinder { // wheel_cyl
    <0,0,1>, <0,0,0>, 1
    scale <12.0, 12.0, 1.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  cylinder { // wheel_csg_cyl
    <0,0,1>, <0,0,0>, 1
    scale <11.5, 11.5, 1.5>
    rotate -90.0*x
    translate  -0.75*y
  }
  texture { T_Silver_2B }
}
#declare speechel_1 = union {
  cylinder { // speechel
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 0.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel1
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 18.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel2
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 36.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel3
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 54.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel4
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 72.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel5
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 90.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel6
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 108.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel7
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 126.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel8
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 144.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel9
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 162.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel10
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 180.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel11
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 198.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel12
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 216.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel13
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 234.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel14
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 252.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel15
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 270.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel16
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 288.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel17
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 306.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel18
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 324.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel19
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 342.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  cylinder { // speechel20
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <4.000499, 360.0, 1.100628>
    translate  <0.0, 0.8, 0.012504>
  }
  pigment { Silver }
  finish { specular .1 roughness .005 metallic 2 brilliance 1 }
}
#declare speechel_2 = union {
  cylinder { // speechel21
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, -9.0, -1.1>
    translate  <0.0, -0.8, 0.012504>
  }
  cylinder { // speechel22
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 9.0, -1.1>
    translate  <0.003864, -0.8, 0.011892>
  }
  cylinder { // speechel23
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 27.0, -1.1>
    translate  <0.00735, -0.8, 0.010116>
  }
  cylinder { // speechel24
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 45.0, -1.1>
    translate  <0.010116, -0.8, 0.00735>
  }
  cylinder { // speechel25
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 63.0, -1.1>
    translate  <0.011892, -0.8, 0.003864>
  }
  cylinder { // speechel26
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 81.0, -1.1>
    translate  <0.012504, -0.8, -0.0>
  }
  cylinder { // speechel27
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 99.0, -1.1>
    translate  <0.011892, -0.8, -0.003864>
  }
  cylinder { // speechel28
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 117.0, -1.1>
    translate  <0.010116, -0.8, -0.00735>
  }
  cylinder { // speechel29
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 135.0, -1.1>
    translate  <0.00735, -0.8, -0.010116>
  }
  cylinder { // speechel30
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 153.0, -1.1>
    translate  <0.003864, -0.8, -0.011892>
  }
  cylinder { // speechel31
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 171.0, -1.1>
    translate  <-0.0, -0.8, -0.012504>
  }
  cylinder { // speechel32
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 189.0, -1.1>
    translate  <-0.003864, -0.8, -0.011892>
  }
  cylinder { // speechel33
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 207.0, -1.1>
    translate  <-0.00735, -0.8, -0.010116>
  }
  cylinder { // speechel34
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 225.0, -1.1>
    translate  <-0.010116, -0.8, -0.00735>
  }
  cylinder { // speechel35
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 243.0, -1.1>
    translate  <-0.011892, -0.8, -0.003864>
  }
  cylinder { // speechel36
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 261.0, -1.1>
    translate  <-0.012504, -0.8, 0.0>
  }
  cylinder { // speechel37
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 279.0, -1.1>
    translate  <-0.011892, -0.8, 0.003864>
  }
  cylinder { // speechel38
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 297.0, -1.1>
    translate  <-0.010116, -0.8, 0.00735>
  }
  cylinder { // speechel39
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 315.0, -1.1>
    translate  <-0.00735, -0.8, 0.010116>
  }
  cylinder { // speechel40
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 333.0, -1.1>
    translate  <-0.003864, -0.8, 0.011892>
  }
  cylinder { // speechel41
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 11.4>
    rotate <-4.0, 351.0, -1.1>
    translate  <0.0, -0.8, 0.012504>
  }
  pigment { Silver }
  finish { specular .1 roughness .005 metallic 2 brilliance 1 }
}
#declare gear = difference {
  cylinder { // gear_cyl
    <0,0,1>, <0,0,0>, 1
    scale <1.4, 1.4, 0.1>
    rotate -90.0*x
    translate  -1.04644*y
  }
  cylinder { // gear_csg_cyl
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate -90.0*x
    translate  <0.0, -1.056964, 1.357079>
  }
  cylinder { // gear_csg_cyl1
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -12.0, 0.0>
    translate  <-0.282153, -1.056964, 1.327424>
  }
  cylinder { // gear_csg_cyl2
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -24.0, 0.0>
    translate  <-0.551974, -1.056964, 1.239753>
  }
  cylinder { // gear_csg_cyl3
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -36.0, 0.0>
    translate  <-0.797671, -1.056964, 1.0979>
  }
  cylinder { // gear_csg_cyl4
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -48.0, 0.0>
    translate  <-1.008506, -1.056964, 0.908063>
  }
  cylinder { // gear_csg_cyl5
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -60.0, 0.0>
    translate  <-1.175265, -1.056964, 0.678539>
  }
  cylinder { // gear_csg_cyl6
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -72.0, 0.0>
    translate  <-1.290659, -1.056964, 0.41936>
  }
  cylinder { // gear_csg_cyl7
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -84.0, 0.0>
    translate  <-1.349645, -1.056964, 0.141853>
  }
  cylinder { // gear_csg_cyl8
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -96.0, 0.0>
    translate  <-1.349645, -1.056964, -0.141853>
  }
  cylinder { // gear_csg_cyl9
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -108.0, 0.0>
    translate  <-1.290659, -1.056964, -0.41936>
  }
  cylinder { // gear_csg_cyl10
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -120.0, 0.0>
    translate  <-1.175265, -1.056964, -0.678539>
  }
  cylinder { // gear_csg_cyl11
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -132.0, 0.0>
    translate  <-1.008506, -1.056964, -0.908063>
  }
  cylinder { // gear_csg_cyl12
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -144.0, 0.0>
    translate  <-0.797671, -1.056964, -1.0979>
  }
  cylinder { // gear_csg_cyl13
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -156.0, 0.0>
    translate  <-0.551974, -1.056964, -1.239753>
  }
  cylinder { // gear_csg_cyl14
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -168.0, 0.0>
    translate  <-0.282153, -1.056964, -1.327424>
  }
  cylinder { // gear_csg_cyl15
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -180.0, 0.0>
    translate  <0.0, -1.056964, -1.357079>
  }
  cylinder { // gear_csg_cyl16
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -192.0, 0.0>
    translate  <0.282153, -1.056964, -1.327424>
  }
  cylinder { // gear_csg_cyl17
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -204.0, 0.0>
    translate  <0.551974, -1.056964, -1.239753>
  }
  cylinder { // gear_csg_cyl18
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -216.0, 0.0>
    translate  <0.797671, -1.056964, -1.0979>
  }
  cylinder { // gear_csg_cyl19
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -228.0, 0.0>
    translate  <1.008506, -1.056964, -0.908063>
  }
  cylinder { // gear_csg_cyl20
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -240.0, 0.0>
    translate  <1.175265, -1.056964, -0.678539>
  }
  cylinder { // gear_csg_cyl21
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -252.0, 0.0>
    translate  <1.290659, -1.056964, -0.41936>
  }
  cylinder { // gear_csg_cyl22
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -264.0, 0.0>
    translate  <1.349645, -1.056964, -0.141853>
  }
  cylinder { // gear_csg_cyl23
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -276.0, 0.0>
    translate  <1.349645, -1.056964, 0.141853>
  }
  cylinder { // gear_csg_cyl24
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -288.0, 0.0>
    translate  <1.290659, -1.056964, 0.41936>
  }
  cylinder { // gear_csg_cyl25
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -300.0, 0.0>
    translate  <1.175265, -1.056964, 0.678539>
  }
  cylinder { // gear_csg_cyl26
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -312.0, 0.0>
    translate  <1.008506, -1.056964, 0.908063>
  }
  cylinder { // gear_csg_cyl27
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -324.0, 0.0>
    translate  <0.797671, -1.056964, 1.0979>
  }
  cylinder { // gear_csg_cyl28
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -336.0, 0.0>
    translate  <0.551974, -1.056964, 1.239753>
  }
  cylinder { // gear_csg_cyl29
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -348.0, 0.0>
    translate  <0.282153, -1.056964, 1.327424>
  }
  cylinder { // gear_csg_cyl30
    <0,0,1>, <0,0,0>, 1
    scale 0.12
    rotate <-90.0, -360.0, 0.0>
    translate  <-0.0, -1.056964, 1.357079>
  }
  texture { T_Silver_3A }
}
#declare wheel = union {
  object { wheel_csg }
  torus { // rubber
    12.35, 0.65  rotate -x*90
    pigment { Black }
    finish { specular .3 roughness .05 brilliance 1 }
    scale <1.0, 1.0, 1.5>
    rotate -90.0*x
  }
  object { speechel_1 }
  object { speechel_2 }
  cylinder { // axle
    <0,0,1>, <0,0,0>, 1
    texture {
      T_Silver_3B
    }
    scale <0.8, 0.8, 2.2>
    rotate -90.0*x
    translate  -1.1*y
  }
  object { gear }
}
#declare bike_cyls1 = union {
  cylinder { // bike_cyl_low1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.2, 20.0>
    rotate -90.0*y
  }
  cylinder { // bike_cyl_high1
    <0,0,1>, <0,0,0>, 1
    scale <0.29, 0.19, 20.0>
    rotate -50.0*y
  }
  sphere { // bike_sp1
    <0,0,0>,1
    scale <0.2, 0.2, 0.3>
    rotate 14.901264*y
    translate  <0.01606, -0.018302, -0.012523>
  }
  pigment { Red }
  finish { specular .4 roughness .005 metallic }
  translate  <0.186393, 1.402624, -0.05009>
}
#declare chain_part = union {
  cylinder { // chain_part_cyl
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_box
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_bo1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 8.176338*y
  translate  <-0.203803, 0.0, 0.0>
}
#declare chain_part1 = union {
  cylinder { // chain_part_cy1
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_bo2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_bo3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 18.764196*y
  translate  <-0.159563, 0.0, 0.028029>
}
#declare chain_part2 = union {
  cylinder { // chain_part_cy2
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_bo4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_bo5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 28.363213*y
  translate  <-0.097805, 0.0, 0.035036>
}
#declare chain_part3 = union {
  cylinder { // chain_part_cy3
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_bo6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_bo7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 41.840069*y
  translate  <-0.12714, 0.0, 0.0981>
}
#declare chain_part4 = union {
  cylinder { // chain_part_cy4
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_bo8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_bo9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 52.602097*y
  translate  <-0.072389, 0.0, 0.073575>
}
#declare chain_part5 = union {
  cylinder { // chain_part_cy5
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 64.890297*y
  translate  <-0.066689, 0.0, 0.094596>
}
#declare chain_part6 = union {
  cylinder { // chain_part_cy6
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 76.133675*y
  translate  <-0.042492, 0.0, 0.084729>
}
#declare chain_part7 = union {
  cylinder { // chain_part_cy7
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-0.0, 88.731979, -0.0>
  translate  <-0.014822, 0.0, 0.107134>
}
#declare chain_part8 = union {
  cylinder { // chain_part_cy8
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-180.0, 78.037384, -180.0>
  translate  <0.021227, 0.0, 0.149031>
}
#declare chain_part9 = union {
  cylinder { // chain_part_cy9
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-180.0, 70.591583, -180.0>
  translate  <-0.001379, 0.0, 0.02334>
}
#declare chain_part10 = union {
  cylinder { // chain_part_c10
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 58.295311, 180.0>
  translate  <0.009532, 0.0, 0.031719>
}
#declare chain_part11 = union {
  cylinder { // chain_part_c11
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-180.0, 49.541664, -180.0>
  translate  <-0.034023, 0.0, -0.022747>
}
#declare chain_part12 = union {
  cylinder { // chain_part_c12
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-180.0, 47.802013, -180.0>
  translate  <-0.004695, 0.0, 0.006581>
}
#declare chain_part13 = union {
  cylinder { // chain_part_c13
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 31.023865, 180.0>
  translate  <0.095858, 0.0, 0.065237>
}
#declare chain_part15 = union {
  cylinder { // chain_part_c15
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-180.0, 20.381409, -180.0>
  translate  <0.074909, 0.0, 0.035909>
}
#declare chain_part16 = union {
  cylinder { // chain_part_c16
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 3.685659, 180.0>
  translate  <0.185425, 0.0, 0.034463>
}
#declare chain_part17 = union {
  cylinder { // chain_part_c17
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <-180.0, -2.530742, -180.0>
  translate  <0.042656, 0.0, 0.008222>
}
#declare chain_part18 = union {
  cylinder { // chain_part_c18
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b36
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b37
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-0.317679, 0.0, 0.005307>
}
#declare chain_part19 = union {
  cylinder { // chain_part_c19
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b38
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b39
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-0.637679, 0.0, -0.004693>
}
#declare chain_part20 = union {
  cylinder { // chain_part_c20
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-0.957679, 0.0, -0.014693>
}
#declare chain_part21 = union {
  cylinder { // chain_part_c21
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-1.277679, 0.0, -0.024693>
}
#declare chain_part22 = union {
  cylinder { // chain_part_c22
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-1.597679, 0.0, -0.034693>
}
#declare chain_part23 = union {
  cylinder { // chain_part_c23
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b47
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-1.917679, 0.0, -0.044693>
}
#declare chain_part24 = union {
  cylinder { // chain_part_c24
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b48
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b49
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-2.237679, 0.0, -0.054693>
}
#declare chain_part25 = union {
  cylinder { // chain_part_c25
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-2.557679, 0.0, -0.064693>
}
#declare chain_part26 = union {
  cylinder { // chain_part_c26
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-2.877679, 0.0, -0.074693>
}
#declare chain_part27 = union {
  cylinder { // chain_part_c27
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b55
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-3.197679, 0.0, -0.084693>
}
#declare chain_part28 = union {
  cylinder { // chain_part_c28
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b56
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b57
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-3.517679, 0.0, -0.094693>
}
#declare chain_part29 = union {
  cylinder { // chain_part_c29
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b58
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b59
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-3.837679, 0.0, -0.104693>
}
#declare chain_part30 = union {
  cylinder { // chain_part_c30
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b60
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b61
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-4.157679, 0.0, -0.114693>
}
#declare chain_part31 = union {
  cylinder { // chain_part_c31
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b62
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b63
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-4.477679, 0.0, -0.124693>
}
#declare chain_part32 = union {
  cylinder { // chain_part_c32
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b64
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b65
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-4.797679, 0.0, -0.134693>
}
#declare chain_part33 = union {
  cylinder { // chain_part_c33
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b66
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b67
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-5.117679, 0.0, -0.144693>
}
#declare chain_part34 = union {
  cylinder { // chain_part_c34
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b68
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b69
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-5.437679, 0.0, -0.154693>
}
#declare chain_part35 = union {
  cylinder { // chain_part_c35
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b70
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b71
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-5.757679, 0.0, -0.164693>
}
#declare chain_part36 = union {
  cylinder { // chain_part_c36
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b72
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b73
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-6.077679, 0.0, -0.174693>
}
#declare chain_part37 = union {
  cylinder { // chain_part_c37
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b74
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b75
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-6.397679, 0.0, -0.184693>
}
#declare chain_part38 = union {
  cylinder { // chain_part_c38
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b76
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b77
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-6.717679, 0.0, -0.194693>
}
#declare chain_part39 = union {
  cylinder { // chain_part_c39
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b78
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b79
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-7.037679, 0.0, -0.204693>
}
#declare chain_part40 = union {
  cylinder { // chain_part_c40
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b80
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b81
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-7.357679, 0.0, -0.214693>
}
#declare chain_part41 = union {
  cylinder { // chain_part_c41
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b82
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b83
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-7.677679, 0.0, -0.224693>
}
#declare chain_part42 = union {
  cylinder { // chain_part_c42
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b84
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b85
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-7.997679, 0.0, -0.234693>
}
#declare chain_part43 = union {
  cylinder { // chain_part_c43
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b86
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b87
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-8.317679, 0.0, -0.244693>
}
#declare chain_part44 = union {
  cylinder { // chain_part_c44
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b88
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b89
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-8.637679, 0.0, -0.254693>
}
#declare chain_part45 = union {
  cylinder { // chain_part_c45
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b90
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b91
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-8.957679, 0.0, -0.264693>
}
#declare chain_part46 = union {
  cylinder { // chain_part_c46
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b92
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b93
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-9.277679, 0.0, -0.274693>
}
#declare chain_part47 = union {
  cylinder { // chain_part_c47
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b94
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b95
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-9.597679, 0.0, -0.284693>
}
#declare chain_part48 = union {
  cylinder { // chain_part_c48
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b96
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b97
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate <180.0, 1.18638, 180.0>
  translate  <-9.917679, 0.0, -0.294693>
}
#declare chain_part14 = union {
  cylinder { // chain_part_c14
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-0.361601, 0.0, 0.004321>
}
#declare chain_part49 = union {
  cylinder { // chain_part_c49
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_b98
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_b99
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-0.681601, 0.0, 0.012321>
}
#declare chain_part50 = union {
  cylinder { // chain_part_c50
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_100
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_101
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-1.001601, 0.0, 0.020321>
}
#declare chain_part51 = union {
  cylinder { // chain_part_c51
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_102
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_103
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-1.321601, 0.0, 0.028321>
}
#declare chain_part52 = union {
  cylinder { // chain_part_c52
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_104
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_105
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-1.641601, 0.0, 0.036321>
}
#declare chain_part53 = union {
  cylinder { // chain_part_c53
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_106
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_107
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-1.961601, 0.0, 0.044321>
}
#declare chain_part54 = union {
  cylinder { // chain_part_c54
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_108
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_109
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-2.281601, 0.0, 0.052321>
}
#declare chain_part55 = union {
  cylinder { // chain_part_c55
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_110
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_111
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-2.601601, 0.0, 0.060321>
}
#declare chain_part56 = union {
  cylinder { // chain_part_c56
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_112
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_113
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-2.921601, 0.0, 0.068321>
}
#declare chain_part57 = union {
  cylinder { // chain_part_c57
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_114
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_115
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-3.241601, 0.0, 0.076321>
}
#declare chain_part58 = union {
  cylinder { // chain_part_c58
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_116
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_117
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-3.561601, 0.0, 0.084321>
}
#declare chain_part59 = union {
  cylinder { // chain_part_c59
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_118
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_119
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-3.881601, 0.0, 0.092321>
}
#declare chain_part60 = union {
  cylinder { // chain_part_c60
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_120
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_121
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-4.201601, 0.0, 0.100321>
}
#declare chain_part61 = union {
  cylinder { // chain_part_c61
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_122
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_123
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-4.521601, 0.0, 0.108321>
}
#declare chain_part62 = union {
  cylinder { // chain_part_c62
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_124
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_125
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-4.841601, 0.0, 0.116321>
}
#declare chain_part63 = union {
  cylinder { // chain_part_c63
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_126
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_127
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-5.161601, 0.0, 0.124321>
}
#declare chain_part64 = union {
  cylinder { // chain_part_c64
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_128
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_129
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-5.481601, 0.0, 0.132321>
}
#declare chain_part65 = union {
  cylinder { // chain_part_c65
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_130
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_131
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-5.801601, 0.0, 0.140321>
}
#declare chain_part66 = union {
  cylinder { // chain_part_c66
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_132
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_133
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-6.121601, 0.0, 0.148321>
}
#declare chain_part67 = union {
  cylinder { // chain_part_c67
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_134
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_135
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-6.441601, 0.0, 0.156321>
}
#declare chain_part68 = union {
  cylinder { // chain_part_c68
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_136
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_137
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-6.761601, 0.0, 0.164321>
}
#declare chain_part69 = union {
  cylinder { // chain_part_c69
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_138
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_139
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-7.081601, 0.0, 0.172321>
}
#declare chain_part70 = union {
  cylinder { // chain_part_c70
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_140
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_141
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-7.401601, 0.0, 0.180321>
}
#declare chain_part71 = union {
  cylinder { // chain_part_c71
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_142
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_143
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-7.721601, 0.0, 0.188321>
}
#declare chain_part72 = union {
  cylinder { // chain_part_c72
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_144
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_145
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-8.041601, 0.0, 0.196321>
}
#declare chain_part73 = union {
  cylinder { // chain_part_c73
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_146
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_147
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-8.361601, 0.0, 0.204321>
}
#declare chain_part74 = union {
  cylinder { // chain_part_c74
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_148
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_149
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-8.681601, 0.0, 0.212321>
}
#declare chain_part75 = union {
  cylinder { // chain_part_c75
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_150
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_151
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-9.001601, 0.0, 0.220321>
}
#declare chain_part76 = union {
  cylinder { // chain_part_c76
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_152
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_153
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-9.321601, 0.0, 0.228321>
}
#declare chain_part77 = union {
  cylinder { // chain_part_c77
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_154
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_155
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-9.641601, 0.0, 0.236321>
}
#declare chain_part78 = union {
  cylinder { // chain_part_c78
    <0,0,1>, <0,0,0>, 1
    texture {
      chain_cyl_tex
    }
    scale <0.099, 0.099, 0.12>
    rotate -90.0*x
    translate  <-0.005946, -1.055408, 1.352906>
  }
  box { // chain_part_156
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -1.060888, 1.350817>
  }
  box { // chain_part_157
    <-1, -1, -1>, <1, 1, 1>
    texture {
      chain_box_tex
    }
    scale <0.145, 0.005, 0.063064>
    translate  <0.142276, -0.930351, 1.350817>
  }
  rotate 3.333458*y
  translate  <-9.961601, 0.0, 0.244321>
}
#declare chain = union {
  object { chain_part }
  object { chain_part1 }
  object { chain_part2 }
  object { chain_part3 }
  object { chain_part4 }
  object { chain_part5 }
  object { chain_part6 }
  object { chain_part7 }
  object { chain_part8 }
  object { chain_part9 }
  object { chain_part10 }
  object { chain_part11 }
  object { chain_part12 }
  object { chain_part13 }
  object { chain_part15 }
  object { chain_part16 }
  object { chain_part17 }
  object { chain_part18 }
  object { chain_part19 }
  object { chain_part20 }
  object { chain_part21 }
  object { chain_part22 }
  object { chain_part23 }
  object { chain_part24 }
  object { chain_part25 }
  object { chain_part26 }
  object { chain_part27 }
  object { chain_part28 }
  object { chain_part29 }
  object { chain_part30 }
  object { chain_part31 }
  object { chain_part32 }
  object { chain_part33 }
  object { chain_part34 }
  object { chain_part35 }
  object { chain_part36 }
  object { chain_part37 }
  object { chain_part38 }
  object { chain_part39 }
  object { chain_part40 }
  object { chain_part41 }
  object { chain_part42 }
  object { chain_part43 }
  object { chain_part44 }
  object { chain_part45 }
  object { chain_part46 }
  object { chain_part47 }
  object { chain_part48 }
  object { chain_part14 }
  object { chain_part49 }
  object { chain_part50 }
  object { chain_part51 }
  object { chain_part52 }
  object { chain_part53 }
  object { chain_part54 }
  object { chain_part55 }
  object { chain_part56 }
  object { chain_part57 }
  object { chain_part58 }
  object { chain_part59 }
  object { chain_part60 }
  object { chain_part61 }
  object { chain_part62 }
  object { chain_part63 }
  object { chain_part64 }
  object { chain_part65 }
  object { chain_part66 }
  object { chain_part67 }
  object { chain_part68 }
  object { chain_part69 }
  object { chain_part70 }
  object { chain_part71 }
  object { chain_part72 }
  object { chain_part73 }
  object { chain_part74 }
  object { chain_part75 }
  object { chain_part76 }
  object { chain_part77 }
  object { chain_part78 }
}
#declare bike_cyls = union {
  cylinder { // bike_cyl_low
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.2, 20.0>
    rotate -90.0*y
  }
  cylinder { // bike_cyl_high
    <0,0,1>, <0,0,0>, 1
    scale <0.29, 0.19, 20.0>
    rotate -50.0*y
  }
  sphere { // bike_sp
    <0,0,0>,1
    scale <0.2, 0.2, 0.3>
    rotate 14.901264*y
    translate  <0.01606, -0.018302, -0.012523>
  }
  pigment { Red }
  finish { specular .4 roughness .005 metallic }
  translate  <0.186393, -1.374066, -0.05009>
}
#declare blech = difference {
  torus { // rubber1
    13.85, 0.65  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
  }
  torus { // rubber_csg
    13.85, 0.55  rotate -x*90
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
  }
  cylinder { // blech_diam_csg
    <0,0,1>, <0,0,0>, 1
    scale <13.7, 13.7, 4.0>
    rotate -90.0*x
    translate  -2.0*y
  }
  box { // blech_csg_cube
    <-1, -1, -1>, <1, 1, 1>
    scale <16.244625, 1.56634, 7.696104>
    rotate -16.123795*y
    translate  <1.736642, 0.0, -8.816799>
  }
  texture {
    T_Chrome_3C
  }
}
#declare gepaeck = union {
  cylinder { // gepaeck_cyl
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 15.0>
    rotate -90.0*y
    translate  <7.5, 5.0, 20.0>
  }
  cylinder { // gepaeck_cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 15.0>
    rotate -90.0*y
    translate  <7.5, 10.0, 20.0>
  }
  cylinder { // gepaeck_cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 13.0>
    rotate -90.0*y
    translate  <6.5, 6.25, 20.0>
  }
  cylinder { // gepaeck_cyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 13.0>
    rotate -90.0*y
    translate  <6.5, 7.5, 20.0>
  }
  cylinder { // gepaeck_cyl4
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 13.0>
    rotate -90.0*y
    translate  <6.5, 8.75, 20.0>
  }
  cylinder { // gepaeck_cyl9
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.0, 5.0, 19.85>
  }
  cylinder { // gepaeck_cyl8
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <3.75, 5.0, 19.85>
  }
  cylinder { // gepaeck_cyl7
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-3.75, 5.0, 19.85>
  }
  cylinder { // gepaeck_cyl6
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-7.5, 5.0, 20.0>
  }
  cylinder { // gepaeck_cyl5
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 5.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <7.5, 5.0, 20.0>
  }
  cylinder { // gepaeck_cyl
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 17.0>
    rotate <3.547645, 25.721767, -0.040821>
    translate  <0.0, 6.072822, 4.745307>
  }
  cylinder { // gepaeck_cyl1
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 17.0>
    rotate <4.865816, -25.529015, -3.09113>
    translate  <0.0, 6.072822, 4.745307>
  }
  cylinder { // gepaeck_cyl2
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 17.0>
    rotate <-2.322565, -25.601068, -3.082433>
    translate  <0.0, 8.927178, 4.745307>
  }
  cylinder { // gepaeck_cyl3
    <0,0,1>, <0,0,0>, 1
    scale <0.09, 0.09, 17.0>
    rotate <-6.219812, 25.213081, -6.206951>
    translate  <0.0, 8.927178, 4.745307>
  }
  texture { T_Chrome_2C }
  translate  <0.0, -7.5, -4.7>
}
#declare TapSwp001 = prism {
  conic_sweep
  linear_spline
  0.7,1.0
  5  // control points
  <-1.0, -0.509954>,
  <1.0, -0.509954>,
  <1.0, 0.503148>,
  <-1.0, 0.503148>,
  <-1.0, -0.509954>
  rotate <90,0,90>
  pigment {
    Black
  }
  rotate <0.0, -0.0, -90.0>
}
#declare back_light = union {
  object { TapSwp001 }
  superellipsoid { // SuprQ12
    <0.1, 1.0>
    pigment { Red }
    scale <1.0, 0.50028, 0.177129>
    translate  1.004227*z
  }
  scale 2.0
  rotate <0.0, 74.596062, 0.0>
  translate  <11.697298, 0.0, 5.037986>
}
union { // bike
  object { wheel }
  cylinder { // axle_small
    <0,0,1>, <0,0,0>, 1
    texture {
      inner_whheel_tex
    }
    scale <0.15, 0.15, 3.4>
    rotate -90.0*x
    translate  -1.7*y
  }
  object { bike_cyls1 }
  object { chain }
  object { bike_cyls }
  object { blech }
  object { gepaeck }
  object { back_light }
  hollow
  scale 0.11
  rotate <-7.67764, 0.0, 0.0>
  translate  <-6.764572, 4.991572, 1.294692>
}



#declare Blob001 = blob {
  threshold 0.6
  component 1.0, 0.944786, <-0.328367, 0.231178, -0.085132>

  component 1.0, 0.944786, <0.377014, 0.231178, -0.085132>

  component 1.0, 0.944786, <0.465567, -0.644868, -0.072971>

  component 1.0, 0.944786, <-0.465567, -0.657035, -0.072971>

  component 1.0, 0.562327, <0.009501, -0.206845, -0.072971>

  component 1.0, 0.591029, <-0.28231, 1.492395, -0.244275>

  component 1.0, 0.591029, <0.31283, 1.492395, -0.259542>

  component 1.0, 0.591029, <0.02289, 1.112167, -0.21374>

  component 1.0, 0.591029, <0.31283, 1.492395, 0.0>

  component 1.0, 0.591029, <0.02289, 1.112167, -0.015267>

  component 1.0, 0.591029, <-0.28231, 1.492395, -0.045802>

  component 1.0, 0.20016, <0.609423, 1.727756, -0.132885>

  component 1.0, 0.20016, <0.792946, 1.718022, -0.125069>

  component 1.0, 0.20016, <0.679741, 1.562281, -0.132885>

  component 1.0, 0.20016, <-0.742246, 1.698555, -0.156336>

  component 1.0, 0.20016, <-0.562544, 1.727756, -0.164153>

  component 1.0, 0.20016, <-0.640676, 1.562281, -0.164153>

  component 1.0, 0.184748, <-0.06725, 1.298261, -0.539359>

  component 1.0, 0.184748, <0.112083, 1.298261, -0.539359>

  component 1.0, 0.184748, <-0.06725, 1.298261, -0.664427>

  component 1.0, 0.184748, <0.112083, 1.298261, -0.672244>

  component 1.0, 0.184748, <-0.062268, 1.128814, -0.664427>

  component 1.0, 0.184748, <-0.062268, 1.128814, -0.539359>

  component 1.0, 0.184748, <0.112083, 1.12383, -0.539359>

  component 1.0, 0.184748, <0.112083, 1.12383, -0.672244>

  component 1.0, 0.590581, <1.010945, 0.571862, -0.085132>

  component 1.0, 0.590581, <1.386828, 0.766539, -0.09771>

  component 1.0, 0.590581, <-0.858924, 0.547528, -0.316206>

  component 1.0, 0.590581, <-0.966873, 0.539923, -0.713282>

  component 1.0, 0.593358, <0.524475, -0.806085, -0.592886>

  component 1.0, 0.593358, <0.546918, -0.806085, -1.064153>

  component 1.0, 0.593358, <-0.460974, -0.806085, -0.592886>

  component 1.0, 0.593358, <-0.437535, -0.806085, -1.079356>

  texture {
    teddy_tex
  }
  rotate <-180.0, 0.0, -180.0>
}

#declare CSG3 = difference {
  object { Blob001 }
  cylinder { // CSG_cyl
    <0,0,1>, <0,0,0>, 1
    texture {
      teddy_tex
    }
    scale <0.12145, 0.12145, 0.15>
    translate  <0.437, -0.805, 1.33>
  }
  cylinder { // CSG_cyl1
    <0,0,1>, <0,0,0>, 1
    texture {
      teddy_tex
    }
    scale <0.12145, 0.12145, 0.15>
    translate  <-0.545, -0.806, 1.318>
  }
  cylinder { // CSG_cyl2
    <0,0,1>, <0,0,0>, 1
    texture {
      teddy_tex
    }
    scale <0.12145, 0.12145, 0.15>
    translate  <0.965, 0.547, 0.96>
  }
}
// Include contains 'nOSE'
#include "cellar1.in5"

#declare nOSE = object {
  nOSE_Raw
  texture {
    Snout_tex
  }
  scale <0.1, 0.1, 0.4>
  translate  <-0.031279, 1.221286, 0.74>
}
// Include contains 'Mouth'
#include "cellar1.in6"

#declare Mouth = object {
  Mouth_Raw
  texture {
    Snout_tex
  }
  scale <0.15, 0.15, 0.4>
  translate  <-0.034967, 1.080268, 0.72>
}
#declare Patch_circle = difference {
  sphere { // Circle
    <0,0,0>,1
    scale <0.15, 0.15, 0.01>
  }
  box { // Cube
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.02>
    translate  -0.02*z
  }
  pigment {
    MidnightBlue
  }
}
#declare Stitches = union {
  torus { // Stitch
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, 0.0>
    translate  0.15*x
  }
  torus { // Stitch1
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -30.0>
    translate  <0.129904, -0.075, 0.0>
  }
  torus { // Stitch2
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -60.0>
    translate  <0.075, -0.129904, 0.0>
  }
  torus { // Stitch3
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -90.0>
    translate  <-0.0, -0.15, 0.0>
  }
  torus { // Stitch4
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -120.0>
    translate  <-0.075, -0.129904, 0.0>
  }
  torus { // Stitch5
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -150.0>
    translate  <-0.129904, -0.075, 0.0>
  }
  torus { // Stitch6
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -180.0>
    translate  <-0.15, 0.0, 0.0>
  }
  torus { // Stitch7
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -210.0>
    translate  <-0.129904, 0.075, 0.0>
  }
  torus { // Stitch8
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -240.0>
    translate  <-0.075, 0.129904, 0.0>
  }
  torus { // Stitch9
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -270.0>
    translate  <0.0, 0.15, 0.0>
  }
  torus { // Stitch10
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -300.0>
    translate  <0.075, 0.129904, 0.0>
  }
  torus { // Stitch11
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -330.0>
    translate  <0.129904, 0.075, 0.0>
  }
  texture {
    Snout_tex
  }
}
#declare Patch_Leg_Front = union {
  object { Patch_circle }
  object { Stitches }
  scale <0.8, 0.8, 1.0>
  translate  <0.437, -0.805, 1.33>
}
#declare Patch_circle1 = difference {
  sphere { // Circle1
    <0,0,0>,1
    scale <0.15, 0.15, 0.01>
  }
  box { // Cube1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.02>
    translate  -0.02*z
  }
  pigment {
    MidnightBlue
  }
}
#declare Stitches1 = union {
  torus { // Stitch12
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, 0.0>
    translate  0.15*x
  }
  torus { // Stitch13
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -30.0>
    translate  <0.129904, -0.075, 0.0>
  }
  torus { // Stitch14
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -60.0>
    translate  <0.075, -0.129904, 0.0>
  }
  torus { // Stitch15
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -90.0>
    translate  <-0.0, -0.15, 0.0>
  }
  torus { // Stitch16
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -120.0>
    translate  <-0.075, -0.129904, 0.0>
  }
  torus { // Stitch17
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -150.0>
    translate  <-0.129904, -0.075, 0.0>
  }
  torus { // Stitch18
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -180.0>
    translate  <-0.15, 0.0, 0.0>
  }
  torus { // Stitch19
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -210.0>
    translate  <-0.129904, 0.075, 0.0>
  }
  torus { // Stitch20
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -240.0>
    translate  <-0.075, 0.129904, 0.0>
  }
  torus { // Stitch21
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -270.0>
    translate  <0.0, 0.15, 0.0>
  }
  torus { // Stitch22
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -300.0>
    translate  <0.075, 0.129904, 0.0>
  }
  torus { // Stitch23
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -330.0>
    translate  <0.129904, 0.075, 0.0>
  }
  texture {
    Snout_tex
  }
}
#declare Patch_Leg_Rear = union {
  object { Patch_circle1 }
  object { Stitches1 }
  scale <0.8, 0.8, 1.0>
  translate  <-0.545, -0.806, 1.318>
}
#declare Patch_circle2 = difference {
  sphere { // Circle2
    <0,0,0>,1
    scale <0.15, 0.15, 0.01>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 0.02>
    translate  -0.02*z
  }
  pigment {
    MidnightBlue
  }
}
#declare Stitches2 = union {
  torus { // Stitch24
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, 0.0>
    translate  0.15*x
  }
  torus { // Stitch25
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -30.0>
    translate  <0.129904, -0.075, 0.0>
  }
  torus { // Stitch26
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -60.0>
    translate  <0.075, -0.129904, 0.0>
  }
  torus { // Stitch27
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -90.0>
    translate  <-0.0, -0.15, 0.0>
  }
  torus { // Stitch28
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -120.0>
    translate  <-0.075, -0.129904, 0.0>
  }
  torus { // Stitch29
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -150.0>
    translate  <-0.129904, -0.075, 0.0>
  }
  torus { // Stitch30
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -180.0>
    translate  <-0.15, 0.0, 0.0>
  }
  torus { // Stitch31
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -210.0>
    translate  <-0.129904, 0.075, 0.0>
  }
  torus { // Stitch32
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -240.0>
    translate  <-0.075, 0.129904, 0.0>
  }
  torus { // Stitch33
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -270.0>
    translate  <0.0, 0.15, 0.0>
  }
  torus { // Stitch34
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -300.0>
    translate  <0.075, 0.129904, 0.0>
  }
  torus { // Stitch35
    1.5, 0.5  rotate -x*90
    scale <0.015, 0.004, 0.017>
    rotate <-90.0, 10.0, -330.0>
    translate  <0.129904, 0.075, 0.0>
  }
  texture {
    Snout_tex
  }
}
#declare Patch_Arm_Front = union {
  object { Patch_circle2 }
  object { Stitches2 }
  scale <0.8, 0.8, 1.0>
  translate  <0.965, 0.547, 0.96>
}
#declare patches = union {
  object { Patch_Leg_Front }
  object { Patch_Leg_Rear }
  object { Patch_Arm_Front }
}
union { // Teddy
  sphere { // Eye_Right
    <0,0,0>,1
    texture {
      Eye_tex
    }
    scale <0.124189, 0.124189, 0.1>
    translate  <-0.328429, 1.422059, 0.490598>
  }
  sphere { // Eye_Left
    <0,0,0>,1
    texture {
      Eye_tex
    }
    scale <0.124189, 0.124189, 0.1>
    translate  <0.344068, 1.402335, 0.473369>
  }
  object { CSG3 }
  object { nOSE }
  object { Mouth }
  object { patches }
  hollow
  rotate <-22.211548, 17.493195, -143.641129>
  translate  <-3.901932, -20.760984, 5.454301>
}





#include "gl_1.inc"

#declare gl_1_Ref = object {
  gl_1
  texture {
    leather
  }
  scale <1.0, 0.8, 1.0>
  rotate <90.0, 80.836548, 0.0>
  translate  <-1.113549, -0.000106, -0.185956>
}
#include "gl_2.inc"

#declare gl_2_Ref = object {
  gl_2
  texture {
    Ironrust_tex
  }
  scale <1.000954, 0.899032, 1.0>
  rotate <-0.0, 0.0, 0.0>
  translate  <0.03177, -0.534018, -0.116015>
}
#include "gl_3.inc"

#declare gl_3_Ref = object {
  gl_3
  texture {
    Ironrust_tex scale .8 translate <2,3,4>
  }
  scale <1.710295, 1.483472, 1.593265>
  rotate <0.025085, -3.058739, -0.000673>
  translate  <0.023291, -0.277466, -0.366357>
}
#declare Blade_Middle = prism {
  linear_sweep
  cubic_spline
  -0.03,0.0
  21  // control points
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>,
  <0.065431, -0.921108>,
  <0.076908, -0.684344>,
  <0.069428, -0.454847>,
  <0.103624, -0.092459>,
  <0.154003, 0.522677>,
  <0.163283, 1.166778>,
  <0.082492, 1.938292>,
  <-0.131928, 2.534038>,
  <-0.583319, 3.119421>,
  <-0.383015, 2.552365>,
  <-0.176006, 1.794477>,
  <-0.118713, 1.163361>,
  <-0.183401, 0.409721>,
  <-0.219266, 0.080015>,
  <-0.126776, -0.102369>,
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>
  rotate -x*90
  texture {
    blade_tex
  }
  scale <0.300119, 0.329889, 0.317046>
  rotate <-89.49469, -17.846922, 90.38636>
  translate  <-0.079325, -0.032708, -0.688245>
}
#declare Palm_Fing_Bolts = union {
  cylinder { // Bolt_Palm_Finger
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <6.0, -90.0, 0.0>
    translate  <0.056355, 0.172317, -0.789523>
  }
  cylinder { // Bolt_Palm_Fin1
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <-6.0, -90.0, 0.0>
    translate  <0.067939, -0.085858, -0.777696>
  }
  cylinder { // Bolt_Palm_Fin2
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 0.05>
    rotate <10.0, -90.0, 0.0>
    translate  <0.03056, 0.405721, -0.802224>
  }
  cylinder { // Bolt_Palm_Fin3
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <-10.0, -90.0, 0.0>
    translate  <0.0225, -0.368075, -0.809235>
  }
  cylinder { // Bolt_Palm_Fin4
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <-9.5586, -89.982315, -9.575238>
    translate  <-0.016584, -0.458533, -1.001476>
  }
  cylinder { // Bolt_Palm_Fin5
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <-174.348145, -89.98954, -174.359009>
    translate  <0.00838, 0.426734, -1.000435>
  }
  cylinder { // Bolt_Palm_Fin6
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <-172.688507, -78.135368, -172.701935>
    translate  <0.032479, 0.253792, -1.408833>
  }
  cylinder { // Bolt_Palm_Fin7
    <0,0,1>, <0,0,0>, 1
    scale <0.025, 0.025, 0.05>
    rotate <169.209915, -73.83168, 167.748917>
    translate  <0.028012, -0.29516, -1.406721>
  }
  texture {
    Silver2
  }
  scale <0.999577, 1.05682, 1.000485>
  rotate <-89.999992, -89.519005, 0.485051>
  translate  <0.00449, -0.0, 0.059454>
}
#declare Finger_Bolts = union {
  cylinder { // Finger_Bolt
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate <-90.0, -0.0, -7.988839>
    translate  <-0.04956, -0.260354, -0.237536>
  }
  cylinder { // Finger_Bolt1
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate 90.0*x
    translate  <-0.371706, 0.32132, -0.67202>
  }
  cylinder { // Finger_Bolt2
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate -90.0*x
    translate  <-0.359651, 0.247364, -0.482741>
  }
  cylinder { // Finger_Bolt3
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate -90.0*x
    translate  <-0.2391, -0.204806, -0.308248>
  }
  cylinder { // Finger_Bolt4
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate <-90.0, 0.0, -6.771873>
    translate  <-0.046801, -0.468387, -0.234656>
  }
  cylinder { // Finger_Bolt5
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate -90.0*x
    translate  <-0.236689, 0.00266, -0.313636>
  }
  cylinder { // Finger_Bolt6
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate -90.0*x
    translate  <-0.371135, 0.483071, -0.670512>
  }
  cylinder { // Finger_Bolt7
    <0,0,1>, <0,0,0>, 1
    scale <0.015, 0.015, 0.03>
    rotate -90.0*x
    translate  <-0.35724, 0.046547, -0.486225>
  }
  texture {
    Silver2
  }
  scale <0.999577, 1.05682, 1.000485>
  rotate <89.945221, -89.523254, -179.460175>
  translate  <0.003525, -0.000009, 0.055966>
}
#declare Palm_Hand = blob {
  threshold 0.6
  component 1.0, 1.50823, <-0.413502, 0.025316, 0.0>

  component 1.0, 1.59972, <0.43038, -0.008439, 0.0>

  component 1.0, 1.45752, <-0.548523, -1.18987, 0.0>

  component 1.0, 1.4348, <0.700422, -1.20675, 0.0>

  component 1.0, 1.21077, <-1.4346, -0.151899, 0.0>

  component 1.0, 1.24168, <-1.33333, -1.26582, 0.0>

  component 1.0, 0.941965, <-1.0, -2.0, 0.0>

  component 1.0, 0.941965, <0.0, -2.0, 0.0>

  texture {
    skin_tex
  }
  scale <0.28, 0.3, 0.2>
  rotate <90.0, 0.0, -90.0>
  translate  <-0.152742, -0.115519, -0.849456>
}

#declare Finger = blob {
  threshold 0.6
  component 1.0, 0.389717, <0.007601, 0.007605, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.281369, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.570342, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.844106, 0.174825>

  component 1.0, 0.389717, <-0.022803, 1.072243, 0.357251>

  component 1.0, 0.389717, <-0.022803, 1.30038, 0.55488>

  texture {
    skin_tex
  }
  scale <0.2, 0.35, 0.2>
  rotate <159.149002, 0.0, 90.0>
  translate  <-0.592459, 0.399549, -0.777885>
}

#declare Finger2 = blob {
  threshold 0.6
  component 1.0, 0.389717, <0.007601, 0.007605, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.281369, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.570342, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.844106, 0.174825>

  component 1.0, 0.389717, <-0.022803, 1.072243, 0.357251>

  component 1.0, 0.389717, <-0.022803, 1.30038, 0.55488>


sturm
  texture {
    skin_tex
  }
  scale <0.28, 0.45, 0.28>
  rotate <134.031494, 1.395851, -89.822792>
  translate  <-0.114524, -0.090041, -0.512411>
}

#declare Finger3 = blob {
  threshold 0.6
  component 1.0, 0.389717, <0.007601, 0.007605, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.281369, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.570342, 0.0>

  component 1.0, 0.389717, <-0.007601, 0.844106, 0.174825>

  component 1.0, 0.389717, <-0.022803, 1.072243, 0.357251>

  component 1.0, 0.389717, <-0.022803, 1.30038, 0.55488>

  texture {
    skin_tex
  }
  scale <0.25, 0.45, 0.25>
  rotate <157.085251, 0.0, -90.0>
  translate  <-0.121225, 0.158188, -0.599337>
}

#declare Index_Finger = blob {
  threshold 0.6
  component 1.0, 0.714533, <0.759494, 0.911392, 0.0>

  component 1.0, 0.676372, <0.742616, 1.50211, 0.0>

  component 1.0, 0.749914, <0.691983, 2.16034, 0.0>

  component 1.0, 0.708316, <0.599156, 2.79325, 0.0>

  component 1.0, 0.718941, <0.43038, 3.50211, 0.0>


sturm
  texture {
    skin_tex
  }
  scale <0.2, 0.28, 0.2>
  rotate <-90.0, -15.731041, -0.0>
  translate  <-0.396366, -0.378728, 0.274437>
}

#declare Fingers = union {
  object { Palm_Hand }
  object { Finger }
  object { Finger2 }
  object { Finger3 }
  object { Index_Finger }
  scale <0.999577, 1.05682, 1.000485>
  rotate <89.945221, -89.523254, -179.460175>
  translate  <0.003525, -0.000009, 0.055966>
}
#declare CSG_Ring = difference {
  torus { // Ring10
    1.0, 0.1  rotate -x*90
    scale <0.1, 0.1, 0.13>
    translate  <-0.21321, -0.453932, 0.0>
  }
  box { // Box_Ring
    <-1, -1, -1>, <1, 1, 1>
    scale <0.095216, 0.147261, 0.05>
    translate  <-0.117646, -0.456671, 0.0>
  }
  texture {
    Ring_Tex
  }
  scale <0.999236, 0.856958, 0.996915>
  rotate -13.91268*y
  translate  <0.065864, 0.015894, -0.014318>
}
#declare CSG_Ring1 = difference {
  torus { // Ring11
    1.0, 0.1  rotate -x*90
    scale <0.085546, 0.09456, 0.13>
    translate  <-0.21321, -0.453932, 0.0>
  }
  box { // Box_Ring1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.095216, 0.147261, 0.05>
    translate  <-0.117646, -0.456671, 0.0>
  }
  texture {
    Ring_Tex
  }
  scale <0.990536, 0.942783, 0.993009>
  rotate -68.139618*y
  translate  <-0.365546, 0.330586, -0.055554>
}
#declare CSG_Ring2 = difference {
  torus { // Ring12
    1.0, 0.1  rotate -x*90
    scale <0.1, 0.1, 0.13>
    translate  <-0.21321, -0.453932, 0.0>
  }
  box { // Box_Ring2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.095216, 0.147261, 0.05>
    translate  <-0.117646, -0.456671, 0.0>
  }
  texture {
    Ring_Tex
  }
  scale <0.662872, 0.970307, 0.978869>
  rotate -89.441475*y
  translate  <-0.543192, 0.600292, -0.359785>
}
#declare CSG_Ring3 = difference {
  torus { // Ring13
    1.0, 0.1  rotate -x*90
    scale <0.088608, 0.092621, 0.13>
    translate  <-0.21321, -0.453932, 0.0>
  }
  box { // Box_Ring3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.095216, 0.147261, 0.05>
    translate  <-0.117646, -0.456671, 0.0>
  }
  texture {
    Ring_Tex
  }
  scale <0.570923, 0.92838, 0.944117>
  rotate <180.0, -71.471298, 180.0>
  translate  <-0.531891, 0.822036, -0.617329>
}
#declare Rings1 = union {
  object { CSG_Ring }
  object { CSG_Ring1 }
  object { CSG_Ring2 }
  object { CSG_Ring3 }
  scale <0.999577, 1.05682, 1.000485>
  rotate <89.945221, -89.523254, -179.460175>
  translate  <0.003525, -0.000009, 0.055966>
}
#declare Blade_Middle1 = prism {
  linear_sweep
  cubic_spline
  -0.03,0.0
  21  // control points
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>,
  <0.065431, -0.921108>,
  <0.076908, -0.684344>,
  <0.069428, -0.454847>,
  <0.103624, -0.092459>,
  <0.154003, 0.522677>,
  <0.163283, 1.166778>,
  <0.082492, 1.938292>,
  <-0.131928, 2.534038>,
  <-0.583319, 3.119421>,
  <-0.383015, 2.552365>,
  <-0.176006, 1.794477>,
  <-0.118713, 1.163361>,
  <-0.183401, 0.409721>,
  <-0.219266, 0.080015>,
  <-0.126776, -0.102369>,
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>
  rotate -x*90
  texture {
    blade_tex
  }
  scale <0.35, 0.38, 0.32>
  rotate <-89.641014, -69.209496, 90.884888>
  translate  <-0.390508, 0.255994, -0.078791>
}
#declare Blade_Middle2 = prism {
  linear_sweep
  cubic_spline
  -0.03,0.0
  21  // control points
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>,
  <0.065431, -0.921108>,
  <0.076908, -0.684344>,
  <0.069428, -0.454847>,
  <0.103624, -0.092459>,
  <0.154003, 0.522677>,
  <0.163283, 1.166778>,
  <0.082492, 1.938292>,
  <-0.131928, 2.534038>,
  <-0.583319, 3.119421>,
  <-0.383015, 2.552365>,
  <-0.176006, 1.794477>,
  <-0.118713, 1.163361>,
  <-0.183401, 0.409721>,
  <-0.219266, 0.080015>,
  <-0.126776, -0.102369>,
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>
  rotate -x*90
  texture {
    blade_tex
  }
  scale <0.300119, 0.329889, 0.317046>
  rotate <-89.547203, -0.927463, 90.276711>
  translate  <0.196326, -0.387869, -0.789915>
}
#declare Blade_Middle3 = prism {
  linear_sweep
  cubic_spline
  -0.03,0.0
  21  // control points
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>,
  <0.065431, -0.921108>,
  <0.076908, -0.684344>,
  <0.069428, -0.454847>,
  <0.103624, -0.092459>,
  <0.154003, 0.522677>,
  <0.163283, 1.166778>,
  <0.082492, 1.938292>,
  <-0.131928, 2.534038>,
  <-0.583319, 3.119421>,
  <-0.383015, 2.552365>,
  <-0.176006, 1.794477>,
  <-0.118713, 1.163361>,
  <-0.183401, 0.409721>,
  <-0.219266, 0.080015>,
  <-0.126776, -0.102369>,
  <-0.108673, -0.446184>,
  <-0.106676, -0.712561>,
  <-0.093181, -0.934366>
  rotate -x*90
  texture {
    blade_tex
  }
  scale <0.26, 0.29, 0.32>
  rotate <-89.678314, 22.026175, 90.090691>
  translate  <0.44468, -0.733497, -0.692391>
}
#declare weld1 = blob {
  threshold 0.6
  component 1.0, 0.23321, <-1.056552, 0.022814, 0.0>

  component 1.0, 0.23321, <-0.828519, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.676497, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.494071, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.296443, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.129219, -0.007605, 0.0>

  component 1.0, 0.23321, <0.007601, -0.022814, 0.0>

  component 1.0, 0.160102, <0.159623, -0.053232, 0.0>

  component 1.0, 0.090588, <0.28124, -0.068441, 0.0>

  component 1.0, 0.194859, <-1.284585, -0.007605, 0.0>

  component 1.0, 0.160128, <-1.467011, -0.038023, 0.0>

  component 1.0, 0.101262, <-1.619033, -0.068441, 0.0>

  component 0.6, 0.389549, <-0.524476, -0.022814, 0.0>

  component 1.5, 0.290087, <-0.934935, 0.144487, 0.0>

  component 1.3, 0.296468, <-0.235634, 0.068441, -0.152672>

  component 1.0, 0.227332, <-0.64855, 0.0, -0.183206>

  texture {
    Rusty_Chrome
  }
  scale <0.09, 0.08, 0.085>
  rotate <-91.129478, -65.031586, 91.565163>
  translate  <0.44846, -0.654955, -0.465807>
}

#declare weld2 = blob {
  threshold 0.6
  component 1.0, 0.23321, <-1.056552, 0.022814, 0.0>

  component 1.0, 0.23321, <-0.828519, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.676497, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.494071, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.296443, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.129219, -0.007605, 0.0>

  component 1.0, 0.23321, <0.007601, -0.022814, 0.0>

  component 1.0, 0.160102, <0.159623, -0.053232, 0.0>

  component 1.0, 0.090588, <0.28124, -0.068441, 0.0>

  component 1.0, 0.194859, <-1.284585, -0.007605, 0.0>

  component 1.0, 0.160128, <-1.467011, -0.038023, 0.0>

  component 1.0, 0.101262, <-1.619033, -0.068441, 0.0>

  component 0.6, 0.389549, <-0.524476, -0.022814, 0.0>

  component 1.5, 0.290087, <-0.934935, 0.144487, 0.0>

  component 1.3, 0.296468, <-0.235634, 0.068441, -0.152672>

  component 1.0, 0.227332, <-0.64855, 0.0, -0.183206>

  texture {
    Rusty_Chrome
  }
  scale <0.150056, 0.072003, 0.10271>
  rotate <43.124603, -21.071077, -89.110069>
  translate  <-0.381057, -0.028864, -0.0007>
}

#declare weld3 = blob {
  threshold 0.6
  component 1.0, 0.23321, <-1.056552, 0.022814, 0.0>

  component 1.0, 0.23321, <-0.828519, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.676497, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.494071, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.296443, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.129219, -0.007605, 0.0>

  component 1.0, 0.23321, <0.007601, -0.022814, 0.0>

  component 1.0, 0.160102, <0.159623, -0.053232, 0.0>

  component 1.0, 0.090588, <0.28124, -0.068441, 0.0>

  component 1.0, 0.194859, <-1.284585, -0.007605, 0.0>

  component 1.0, 0.160128, <-1.467011, -0.038023, 0.0>

  component 1.0, 0.101262, <-1.619033, -0.068441, 0.0>

  component 0.6, 0.389549, <-0.524476, -0.022814, 0.0>

  component 1.5, 0.290087, <-0.934935, 0.144487, 0.0>

  component 1.3, 0.296468, <-0.235634, 0.068441, -0.152672>

  component 1.0, 0.227332, <-0.64855, 0.0, -0.183206>

  texture {
    Rusty_Chrome
  }
  scale <0.11996, 0.084546, 0.090035>
  rotate <179.733047, 71.104309, 89.888596>
  translate  <-0.070773, -0.092909, -0.58533>
}

#declare weld4 = blob {
  threshold 0.6
  component 1.0, 0.23321, <-1.056552, 0.022814, 0.0>

  component 1.0, 0.23321, <-0.828519, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.676497, 0.007605, 0.0>

  component 1.0, 0.23321, <-0.494071, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.296443, -0.007605, 0.0>

  component 1.0, 0.23321, <-0.129219, -0.007605, 0.0>

  component 1.0, 0.23321, <0.007601, -0.022814, 0.0>

  component 1.0, 0.160102, <0.159623, -0.053232, 0.0>

  component 1.0, 0.090588, <0.28124, -0.068441, 0.0>

  component 1.0, 0.194859, <-1.284585, -0.007605, 0.0>

  component 1.0, 0.160128, <-1.467011, -0.038023, 0.0>

  component 1.0, 0.101262, <-1.619033, -0.068441, 0.0>

  component 0.6, 0.389549, <-0.524476, -0.022814, 0.0>

  component 1.5, 0.290087, <-0.934935, 0.144487, 0.0>

  component 1.3, 0.296468, <-0.235634, 0.068441, -0.152672>

  component 1.0, 0.227332, <-0.64855, 0.0, -0.183206>

  texture {
    Rusty_Chrome
  }
  scale <0.139946, 0.073975, 0.080038>
  rotate <83.356834, 88.371933, -6.566762>
  translate  <0.20643, -0.420936, -0.707897>
}

#declare Glove_Fingers = union {
  object { gl_2_Ref }
  object { gl_3_Ref }
  object { Blade_Middle }
  object { Palm_Fing_Bolts }
  object { Finger_Bolts }
  object { Fingers }
  object { Rings1 }
  object { Blade_Middle1 }
  object { Blade_Middle2 }
  object { Blade_Middle3 }
  object { weld1 }
  object { weld2 }
  object { weld3 }
  object { weld4 }
  scale <0.946227, 0.999519, 1.000427>
  rotate <95.588783, 80.792328, 5.669931>
  translate  <-0.000672, 0.055931, 0.004167>
}
#declare CSG003 = union {
  superellipsoid { // SuprQ3
    <0.1, 0.1>
    scale <0.05, 0.2, 0.03>
  }
  superellipsoid { // SuprQ002
    <1.0, 0.1>
    scale <0.05, 0.2, 0.03>
    translate  <0.04609, 0.001013, 0.0>
  }
}
#declare CSG004 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 0.1>
    rotate 90.0*y
    translate  <-0.111274, 0.0, 0.029029>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.02
    translate  <-0.01166, 0.0, 0.029029>
  }
  translate  <0.013165, -0.001013, 0.0>
}
#declare CSG001 = difference {
  object { CSG003 }
  object { CSG004 }
}
#declare Side1 = union {
  superellipsoid { // SuprQ4
    <1.0, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.03, 0.03, 0.02>
    rotate -90.0*x
    translate  -0.2*x
  }
  superellipsoid { // SuprQ5
    <0.1, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.2, 0.02, 0.03>
  }
  texture {
    Buckle_Tex
  }
  scale <0.7, 1.0, 1.0>
  translate  <-0.1, 0.18, -0.04>
}
#declare Side2 = union {
  superellipsoid { // SuprQ003
    <1.0, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.03, 0.03, 0.02>
    rotate -90.0*x
    translate  -0.2*x
  }
  superellipsoid { // SuprQ004
    <0.1, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.2, 0.02, 0.03>
  }
  texture {
    Buckle_Tex
  }
  scale <0.7, 1.0, 1.0>
  translate  <-0.1, -0.18, -0.04>
}
#declare CSG4 = union {
  superellipsoid { // SuprQ6
    <0.1, 0.1>
    scale <0.05, 0.2, 0.03>
  }
  superellipsoid { // SuprQ7
    <1.0, 0.1>
    scale <0.05, 0.2, 0.03>
    translate  <0.04609, 0.001013, 0.0>
  }
}
#declare CSG2 = union {
  object { CSG4 }
}
#declare Side3 = union {
  superellipsoid { // SuprQ8
    <1.0, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.03, 0.03, 0.02>
    rotate -90.0*x
    translate  -0.2*x
  }
  superellipsoid { // SuprQ9
    <0.1, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.2, 0.02, 0.03>
  }
  texture {
    Buckle_Tex
  }
  scale <0.7, 1.0, 1.0>
  translate  <-0.1, 0.18, -0.04>
}
#declare Side4 = union {
  superellipsoid { // SuprQ10
    <1.0, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.03, 0.03, 0.02>
    rotate -90.0*x
    translate  -0.2*x
  }
  superellipsoid { // SuprQ11
    <0.1, 0.1>
    texture {
      Buckle_Tex
    }
    scale <0.2, 0.02, 0.03>
  }
  texture {
    Buckle_Tex
  }
  scale <0.7, 1.0, 1.0>
  translate  <-0.1, -0.18, -0.04>
}
#declare Buckle_wo_CSG = union {
  object { CSG2 }
  object { Side3 }
  object { Side4 }
  texture {
    Buckle_Tex
  }
  rotate 180.0*z
  translate  -0.48*x
}
#declare hilt = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.01, 0.04>
    rotate -90.0*y
    translate  <0.012752, 0.0, -0.028764>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale <0.005, 0.01, 0.005>
    translate  <-0.026422, 0.000017, -0.028831>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale <0.005, 0.01, 0.005>
    translate  <-0.041943, 0.000017, -0.039232>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.01, 0.02>
    rotate 56.41568*y
    translate  <-0.04296, 0.0, -0.039788>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <0.005, 0.01, 0.17>
    rotate -90.0*y
    translate  <-0.04175, 0.0, -0.039148>
  }
  texture {
    Buckle_Tex
  }
  scale <1.0, 2.0, 1.5>
  rotate -15.09229*y
  translate  <-0.038679, 0.0, 0.075237>
}
// Include contains 'Belt_Palm'
#include "cellar1.i11"

#declare Belt_Palm = object {
  Belt_Palm_Raw
  texture {
    Leather_belt
  }
  scale 0.7
  rotate 90.0*x
  translate  <-0.232871, 0.13613, -0.679887>
}
#declare Belt_PalmCSG = union {
  object { Belt_Palm }
  cylinder { // Bolt_Belt_palm
    <0,0,1>, <0,0,0>, 1
    texture {
      Buckle_Tex
    }
    scale 0.05
    translate  <-0.719573, 0.0, -0.084615>
  }
  cylinder { // Bolt_Belt_pal1
    <0,0,1>, <0,0,0>, 1
    texture {
      Buckle_Tex
    }
    scale 0.05
    translate  <-0.559345, 0.0, -0.084615>
  }
  rotate -13.623634*y
  translate  <0.057615, 0.0, 0.01009>
}
// Include contains 'Belt'
#include "cellar1.i12"

#declare Belt = object {
  Belt_Raw
  texture {
    Leather_belt
  }
  scale 0.21
  rotate <-180.0, 0.0, 98.010292>
  translate  <0.052147, 0.386032, -1.118111>
}
#declare Belt_Holes = difference {
  object { Belt }
  cylinder { // Hole
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.055668>
    rotate <-150.0, -90.0, 0.0>
    translate  <0.036618, 0.382827, -1.15932>
  }
  cylinder { // Hole1
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.055668>
    rotate <-170.0, -90.0, 0.0>
    translate  <-0.016518, 0.500799, -1.15932>
  }
  cylinder { // Hole2
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.055668>
    rotate <-180.0, -90.0, 0.0>
    translate  <0.06201, 0.317276, -1.15932>
  }
  cylinder { // Hole3
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.055668>
    rotate <-180.0, -90.0, 0.0>
    translate  <0.053296, 0.173249, -1.15932>
  }
  cylinder { // Hole4
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.055672>
    rotate <-160.0, -90.0, 0.0>
    translate  <0.007939, 0.439408, -1.15932>
  }
  cylinder { // Hole5
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 0.055668>
    rotate <-190.0, -90.0, 0.0>
    translate  <0.056289, 0.243936, -1.15932>
  }
  scale 3.333333
  rotate <90.0, -68.366074, 180.0>
  translate  <-1.2356, 3.864601, -0.657464>
}
#declare Buckel_with_CSG = union {
  object { CSG001 }
  object { Side1 }
  object { Side2 }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    texture {
      Buckle_Tex
    }
    scale <0.007, 0.007, 0.35>
    rotate -90.0*x
    translate  <-0.239362, -0.174498, -0.039758>
  }
  torus { // Torus001
    0.008, 0.001  rotate -x*90
    texture {
      Buckle_Tex
    }
    scale <1.0, 1.0, 24.0>
    rotate -90.0*x
    translate  <-0.239597, 0.0, -0.039439>
  }
  object { Buckle_wo_CSG }
  object { hilt }
  object { Belt_PalmCSG }
  object { Belt_Holes }
  texture {
    Buckle_Tex
  }
  scale 0.3
  rotate <155.610397, 65.982376, 67.503304>
  translate  <-1.072693, -0.04337, -0.606563>
}
#declare arm = blob {
  threshold 0.6
  component 1.0, 0.431272, <0.00763, 0.0, 0.015267>

  component 1.0, 0.431272, <-0.38913, 0.0, 0.015267>

  component 1.0, 0.431272, <0.00763, 0.0, 0.412214>

  component 1.0, 0.431272, <-0.37387, 0.0, 0.412214>

  component 1.0, 0.431272, <-0.387656, 0.296578, 0.412214>

  component 1.0, 0.431272, <0.007601, 0.311787, 0.412214>

  component 1.0, 0.431272, <-0.372454, 0.296578, 0.015267>

  component 1.0, 0.431272, <0.022803, 0.311787, 0.015267>

  texture {
    skin_tex
  }
  scale <0.65, 0.35, 1.0>
  rotate <11.113823, -80.313583, -177.295151>
  translate  <-2.149544, 0.028091, -0.235854>
}

#declare sleeve_csg =  difference { //union { //difference {
  cone { // Cone001
    <0,0,0>, 1.0, <0,0,1>, 0.9
    texture {
      sleeve_tex scale z*.7 translate z*.3
    }
    scale <0.2, 0.4, 0.8>
    rotate -12.719151*y
    translate  <0.147504, 0.001605, -2.665609>
    no_shadow
    hollow
  }
    cone { // Cone2
    <0,0,0>, 1.0, <0,0,1>, 0.9
    pigment {
      Clear //sleeve_tex scale z*.6 translate z*.4
    }
    scale <0.18, 0.38, 0.9>
    rotate -12.719151*y
    translate  <0.127075, 0.0, -2.603757>
    no_shadow
    hollow
  }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <0.250891, 0.394752, 0.404839>
      rotate -12.210365*y
      translate  <0.050433, -0.0, -2.254815>
    }
  }

  rotate <-80.323875, 0.448469, -89.923538>
  translate  <0.030252, 0.003069, 0.005183>
  no_shadow //*************************
  hollow
}
union { // Glove
  object { gl_1_Ref }
  object { Glove_Fingers }
  object { Buckel_with_CSG }
  torus { // Wrist
    1.55, 0.05  rotate -x*90
    texture {
      leather
    }
    scale <0.095, 0.242204, 1.3>
    rotate <-80.153046, -0.448786, -77.415871>
    translate  <-1.578032, 0.085736, -0.264169>
  }
  object { arm }
  object { sleeve_csg }
  hollow
  scale 1.8
  rotate <-12.171086, -87.783302, -71.429466>
  translate  <-4.491831, -21.952725, 4.281389>
}

hollow
}

//sig

text {
  ttf "c:\windows\fonts\arial.ttf"
  "G.S." .1, 0
  pigment { White } finish {reflection .03 specular .1 roughness .05 metallic }
  scale <.13, .13, .13>
  rotate <90, -6.5, -8>
  translate <-3.15, -22.55, 3.56>
  no_shadow
}

