#ifndef (Master)

	#include "colors.inc"
	#include "textures.inc"
	#include "shapes.inc"

camera {
	location <0,5,-16>
	look_at  <0,3,0>
   right x* 4/3
}


light_source
{
  0*x                     // light's position (translated below)
  color White       // light's color
  spotlight               // this kind of light source
  translate <0, 15, -10> // <x y z> position of light
  point_at <0, 3, 8>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color Gray70       // light's color
  spotlight               // this kind of light source
  translate <-10, 20, -10> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color Gray70       // light's color
  spotlight               // this kind of light source
  translate <10, 20, -10> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

#end

#include "annsph.inc"

#declare RED_PLASTIC = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
    pigment { color Red }
}

#declare REDYELLOW = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
   pigment {
      gradient x
      color_map {
         [0.0 0.25 color Red color Red]
         [0.25 0.50 color Yellow color Yellow]
         [0.50 0.75 color Red color Red]
         [0.75 1.00 color Yellow color Yellow]
      }
      quick_color Red
      scale 0.5
      translate 1*x
   }
}

#declare AMPHI=
difference {
	cylinder { < 0, 0, 0>, < 0, 1, 0>, 1 }
	cylinder { < 0, 0.80, 0>, < 0, 1.1, 0>, 0.95 }
	cylinder { < 0, 0.60, 0>, < 0, 1.1, 0>, 0.9 }
	cylinder { < 0, 0.40, 0>, < 0, 1.1, 0>, 0.85 }
	cylinder { < 0, 0.20, 0>, < 0, 1.1, 0>, 0.8 }
	cylinder { < 0, 0, 0>, < 0, 1.1, 0>, 0.75 texture {REDYELLOW scale 0.2}}
	cylinder { < 0, 0, 1.9>, < 0, 1, 1.9>, 1.2 }
	texture {RED_PLASTIC}
	}

#declare CHAPITEAU=
cone {
  0*y, 1.0,
  1*y, 0.5
  open
	texture {REDYELLOW}
	hollow
	}

#declare PUBLIC1=
union {
	object {Anneau
		texture { pigment { color Gray10 } }
		rotate x*90
		scale <1.5,1.3,1.5>
		translate <0,2.8,0>
		}
	object {Anneau
		texture { pigment { color Gray10 } }
		rotate x*90
		scale <1.6,1.3,1.6>
		translate <0,4.5,0>
		}
	object {Anneau
		texture { pigment { color Gray10 } }
		rotate x*90
		scale <1.7,1.2,1.7>
		translate <0,6.6,0>
		}
	object {Anneau
		texture { pigment { color Gray10 } }
		rotate x*90
		scale <1.8,1.2,1.8>
		translate <0,8.7,0>
		}
}

#declare PUBLIC=
difference {
	object {PUBLIC1}
	cylinder { < 0, 0, 1.85>, < 0, 1, 1.85>, 1.2 scale <19,10,19>}
	cylinder { < 0, 0, -1.85>, < 0, 1, -1.85>, 1.2 scale <19,10,19>}
}


#ifndef (Master)
	object {AMPHI
		scale <19,10,19>
		}
	object {CHAPITEAU
		scale <40,40,40>
		}
	object {PUBLIC}

#end
