// ==== Standard POV-Ray Includes ====

#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "skies.inc"
#include "shapes.inc"

#declare Master = 1
#declare Rideau_on = on
#declare Piste_on = on
#declare Ballon_on = on
#declare Pic_on = on
#declare Cube_on = on
#declare Ours_on = on
#declare Gradin_on = on
#declare Jongleur_on = on
#declare Chevaux_on = on


camera {
	location <0,5,-16>
	look_at  <0,3,0>
   right x* 4/3
}


light_source
{
  0*x                     // light's position (translated below)
  color White       // light's color
  spotlight               // this kind of light source
  translate <0, 40, -10> // <x y z> position of light
  point_at <0, 5, 0>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160              // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color Gray70       // light's color
  spotlight               // this kind of light source
  translate <-20, 40, -20> // <x y z> position of light
  point_at <7, 3, 0>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

light_source
{
  0*x                     // light's position (translated below)
  color Gray70       // light's color
  spotlight               // this kind of light source
  translate <20, 40, -20> // <x y z> position of light
  point_at <-5, 3, -5>      // direction of spotlight
  radius 140                // hotspot (inner, in degrees)
  tightness 20            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 160               // intensity falloff radius (outer, in degrees)
}

#if (Chevaux_on=on)

// piste - cheval de droite
#declare Horse_Base = <1.5,1.5,1.5>
#declare T_Translate = <0,0,0>
#declare Neck_angle = 20
#declare Head_angle = 20
#declare Tail_pivot = -20
#declare Left_front_upper_angle = -10
#declare Left_front_lower_angle = 20
#declare Left_front_hoof_angle = -10
#declare Right_front_upper_angle = -40
#declare Right_front_lower_angle = 80
#declare Right_front_hoof_angle = 40

#declare Left_rear_upper_angle = -10
#declare Left_rear_lower_angle = 20
#declare Left_rear_hoof_angle = -10
#declare Right_rear_upper_angle = -10
#declare Right_rear_lower_angle = 20
#declare Right_rear_hoof_angle = -10

#include "13horse.inc"
object {Horse_13
	rotate y*70
	translate < 7, 0.2, 0>}

// fond - cheval de gauche
#declare Horse_Base = <1.5,1.5,1.5>
#declare T_Translate = <0,0,0>
#declare Neck_angle = 20
#declare Head_angle = 20
#declare Tail_pivot = -20
#declare Left_front_upper_angle = -10
#declare Left_front_lower_angle = 20
#declare Left_front_hoof_angle = -10
#declare Right_front_upper_angle = -10
#declare Right_front_lower_angle = 20
#declare Right_front_hoof_angle = -10

#declare Left_rear_upper_angle = -10
#declare Left_rear_lower_angle = 20
#declare Left_rear_hoof_angle = -10
#declare Right_rear_upper_angle = -10
#declare Right_rear_lower_angle = 20
#declare Right_rear_hoof_angle = -10

#include "13horse.inc"
object {Horse_13
	rotate y*-90
	translate < -2.5, 0.2, 5>}

// fond - cheval de droite
#declare Horse_Base = <1.5,1.5,1.5>
#declare T_Translate = <0,0,0>
#declare Neck_angle = 10
#declare Head_angle = 10
#declare Tail_pivot = -20
#declare Left_front_upper_angle = -10
#declare Left_front_lower_angle = 20
#declare Left_front_hoof_angle = -10
#declare Right_front_upper_angle = -10
#declare Right_front_lower_angle = 20
#declare Right_front_hoof_angle = -10

#declare Left_rear_upper_angle = -10
#declare Left_rear_lower_angle = 20
#declare Left_rear_hoof_angle = -10
#declare Right_rear_upper_angle = -10
#declare Right_rear_lower_angle = 20
#declare Right_rear_hoof_angle = -10

#include "13horse.inc"
object {Horse_13
	rotate y*-90
	translate < 2.5, 0.2, 5>}

// piste - cheval de gauche
#declare Horse_Base = <1.5,1.5,1.5>
#declare T_Translate = <0,0,0>
#declare Neck_angle = 10
#declare Head_angle = 10
#declare Tail_pivot = -20
#declare Left_front_upper_angle = -40
#declare Left_front_lower_angle = 80
#declare Left_front_hoof_angle = 40
#declare Right_front_upper_angle = -10
#declare Right_front_lower_angle = 20
#declare Right_front_hoof_angle = -10

#declare Left_rear_upper_angle = -10
#declare Left_rear_lower_angle = 20
#declare Left_rear_hoof_angle = -10
#declare Right_rear_upper_angle = -10
#declare Right_rear_lower_angle = 20
#declare Right_rear_hoof_angle = -10

#include "13horse.inc"
object {Horse_13
	rotate y*-140
	translate < -5, 0.2, -5>}

#end

#if (Rideau_on=on)
#include "drapes.pov"
object { Rideau
		scale <16, 3, 3>
    translate <0, 12, 8>
		}
object { Circus
		scale <1.2,0.9,0.6>
    translate <-4.5, 8.5, 7.7>
		}
object { Titre
		scale <2.8,1.2,3>
    translate <-4, 8, 7.7>
		}
#end

#if (Piste_on=on)
	#declare Ground = height_field {tga "sand.tga"
	texture{
  	pigment
  	{
    	bozo
    	color_map
    	{
      	[0.00 color rgb<0.961, 0.882, 0.667>]
      	[0.23 color rgb<0.898, 0.835, 0.635>]
      	[0.50 color rgb<0.890, 0.733, 0.514>]
      	[0.71 color rgb<0.945, 0.776, 0.584>]
      	[1.00 color rgb<0.886, 0.788, 0.565>]
    	}
		scale .25
		turbulence 0.5
  	}
	}
		finish {crand 0.2}
		translate <-0.5,-0.5,-0.5>
	}

	object {Ground
				 scale <40,0.5,20>
//				 translate <0,-0.3,0>
	}
#end

#if (Ballon_on=on)
	#include "ballon.pov"
	object {BALLON
	scale <0.5, 0.5, 0.5>
	translate < 1.5, 5.5, -6>
	}
#end

#if (Pic_on=on)
	#include "pic.pov"
	object {PIC
	rotate <-45,0,45>
	scale <0.4, 0.4, 0.4>
	translate < -1.3, 5.7, -6>
	}
#end

#if (Cube_on=on)
	#include "cube.pov"
	object {ABCD
	rotate <-35,35,0>
	scale <0.8, 0.8, 0.8>
	translate < -0.2, 6.5, -6>
	}
#end

#if (Ours_on=on)
	#include "ourshd.pov"
	object {NOUNOURS
	rotate < 0, -40, 0>
	scale <0.4, 0.4, 0.4>
	translate < -5.4, 5.8, -4.5>
	}
	object {NOUNOURS
	rotate < 0, 160, 0>
	scale <0.4, 0.4, 0.4>
	translate < 7.3, 5.8, -1.0>
	}
#end

#if (Gradin_on=on)
	#include "cirque.pov"
	object {AMPHI
	scale <19,10,19>
	translate < 0, -0.5, -5>
	}
	object {CHAPITEAU
		scale <50,50,50>
	}
	object {PUBLIC
	translate < 0, -0.5, -5>
	}
#end

#if (Jongleur_on=on)
	#include "jongleur.pov"
	object {SOCLE
		scale <2,1.2,2>
		translate <0,-0.1,-2>
	}
	#include "ourshd.pov"
	object {NOUNOURS
	scale <0.7, 0.7, 0.7>
	translate < 0, 4.5, -1>
	}
#end

