#ifndef (Master)

	#include "colors.inc"
	#include "textures.inc"
	#include "shapes.inc"

	camera {
	   location <0.1, 2, -3.9>
//	   up       <0, 1, 0>
	   look_at  <0, 0, 0>
	}

	light_source
	{
	  0*x // light's position (translated below)
	  color White
	  translate <-20, 40, -20>
	}

	light_source { < 1.5 , 1.5 , -7.9 > color White }

#end

#declare RED_PLASTIC = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
    pigment { color Red }
}
#declare BLUE_PLASTIC = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
    pigment { color Blue }
}
#declare GREEN_PLASTIC = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
    pigment { color Green }
}
#declare YELLOW_PLASTIC = texture {
    finish { ambient 0.1
             diffuse 0.7
             phong 1.0
             phong_size 70.0 }
    pigment { color Yellow }
}

#declare PIC = union
	{
	cylinder
		{
  	0*y,  1.6*y,  0.2
		texture { RED_PLASTIC}
		}
	cylinder
		{
  	0*y,  -0.6*y,  1
		texture { BLUE_PLASTIC}
		}
	#declare TorCount = 0
	#while (TorCount < 5)
		torus
		{
		(1.2-(TorCount*0.2)), 0.2
		translate y*(TorCount*0.3)
		#switch (TorCount)
		  #case (0)
				texture { RED_PLASTIC}
			#break
	 	  #case (1)
				texture { YELLOW_PLASTIC}
	  	#break
	  	#case (2)
				texture { BLUE_PLASTIC}
	  	#break
	  	#case (3)
				texture { GREEN_PLASTIC}
	  	#break
	  	#case (4)
				texture { YELLOW_PLASTIC}
	  	#break
	  	#else
				texture { RED_PLASTIC}
		#end
		}
  	#declare TorCount = TorCount+1
	#end
	}

#ifndef (Master)
	object {PIC}
#end


