
// Persistence of Vision Ray Tracer Scene Description File
// File: 229.pov
// Vers: 1.00

// Desc: --------* 229 Quakers Road *--------
//         A model of the house that I spent a good part of my childhood in.
//         We lived in this house from 1984 till 1997.
//         Single storey red brick with carport. Only front modelled in detail, sides
//         minimally detailes as some of this is seen in the scene.
//         Created for the Nov-Dec 1997 IRTC.

// Date: 31st Nov 1997
// Auth: Chris Hernandez



// ==== Standard POV-Ray Includes ====
#include "colors.inc"   // Standard Color definitions
#include "SKIES.INC"

#include "FOLIAGE.INC"


background { color rgb <0.6, 0.6, 0.6> }


#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.35
	   diffuse 0.35
	   specular 0.3
       roughness 0.01
	   //reflection 0.05
	}
}

#declare RedT = texture { pigment { color rgb <1,0,0> } finish { ambient 0.6 } }


// ******************************************************************************************
// ----------------------------------- Define Textures --------------------------------------
// ******************************************************************************************


#declare Q229_GutteringTexture = texture {
   pigment { color rgb <0.899, 0.669, 0.422> }
   finish  { ambient 0.5 diffuse 0.5 specular 0.2 roughness 0.025 reflection 0.05 brilliance 2  }
}

#declare Q229_WhiteAluminium = texture {
   pigment { color rgb <0.95, 0.95, 0.95> }
   finish  { ambient 0.5 diffuse 0.5 specular 0.25 roughness 0.015 reflection 0.05 brilliance 2  }
}


#declare Q229_WhitePlaster = texture {
   pigment { color rgb <0.969, 0.969, 0.962> }
   finish  { ambient 0.55 diffuse 0.4 specular 0.15 roughness 0.1 }
}

#declare Q229_Interior = texture {
   pigment { color rgb <0.999, 0.969, 0.822> }
   finish  { ambient 0.35 diffuse 0.4 specular 0.15 roughness 0.1 }
}


#declare Q229_RoofTile = texture {
   pigment { color rgb <0.602, 0.338, 0.300> }
   finish  { ambient 0.4 diffuse 0.35 specular 0.15 roughness 0.1 }
   normal {
      average
      normal_map {
         [ 1.8 gradient x ramp_wave scale 0.20 ]
         [ 1 gradient z sine_wave scale 0.15 ]
      }
   }
   scale 1.2
}


#declare Q229_WindowGlass = texture {
   pigment { color rgbf<0.85, 0.85, 0.85, 0.9> }
   finish  {
	  specular 1
	  roughness 0.001
	  ambient 0.05
	  diffuse 0.05
	  refraction on
	  reflection 0.1
	  ior 1.5
	  caustics 0.5
	  brilliance 2 //8
   }
}


#declare Q229_RedBrick = texture {
   brick
      //---------- Mortar Texture
      texture {
         pigment { color rgb <0.894, 0.871, 0.849> }
         finish { ambient 0.45 diffuse 0.4 specular 0.2 roughness 0.05 crand 0.1 }
      }
      //---------- Brick Texture
      texture {
         pigment {
            bozo
            colour_map {
               [ 0.00 color rgb <0.944, 0.721, 0.499> ]
               [ 0.33 color rgb <0.923, 0.585, 0.240> ]
               [ 0.66 color rgb <0.805, 0.385, 0.201> ]
               [ 1.00 color rgb <0.901, 0.672, 0.201> ]
            }
            turbulence 1
         }
         finish { ambient 0.45 diffuse 0.35 specular 0.2 roughness 0.05 crand 0.15 }
         normal {
            average
            normal_map {
               [ 1 bozo 0.6 turbulence 0.75 ]
               [ 1 crackle 0.4 ]
            }
            scale 0.1
         }
      }
   brick_size <2.35, 1, 1>
   mortar 0.275 //0.4
   scale 0.125
}


#declare Q229_Concrete = texture {
   pigment {
      bozo
      colour_map {
         [ 0.00 color rgb <0.850, 0.850, 0.850> ]
         [ 0.33 color rgb <0.885, 0.885, 0.885> ]
         [ 0.66 color rgb <0.835, 0.835, 0.835> ]
         [ 1.00 color rgb <0.815, 0.815, 0.815> ]
      }
      turbulence 1
   }
   finish { ambient 0.4 diffuse 0.35 crand 0.1 }

   normal {
      average
      normal_map {
         [ 1 bozo 0.6 turbulence 0.75 ]
         [ 0.1 crackle 0.1 ]
      }
      scale 0.5
   }
   //scale 0.35
}


#declare Q229_ScreenDoorTexture = texture {
   pigment {
      gradient x
      colour_map {
         [ 0.00 color rgbt <0.999, 0.969, 0.822, 1.000>]
         [ 0.40 color rgbt <0.999, 0.969, 0.822, 1.000>]
         [ 0.40 color rgbt <0.999, 0.969, 0.822, 0.500>]
         [ 0.60 color rgbt <0.999, 0.969, 0.822, 0.500>]
         [ 0.60 color rgbt <0.999, 0.969, 0.822, 1.000>]
         [ 1.00 color rgbt <0.999, 0.969, 0.822, 1.000>]
      }
   }
   finish  {
      ambient 0.65 diffuse 0.5 specular 0.2
      roughness 0.025 brilliance 2
   }
   scale 0.03
}

#declare Q229_BrownWood = texture {
   pigment { color rgb <0.588, 0.392, 0.000> }
   finish  { ambient 0.4 diffuse 0.4 crand 0.01 }
}

#declare Q229_FenceTexture = texture {
   pigment { color rgbt < 0.98, 0.95, 0.91, 0 > }
   finish { ambient 0.55 diffuse 0.4 crand 0.01 }
}




// ******************************************************************************************
// --------------------------------- Basic Building Blocks ----------------------------------
// ******************************************************************************************


#declare Q229_Roof = object {
   union {
      difference {
         box { <-4.5, 0, 0> <5, 2, 7> }
         plane { x, 0 rotate -z*65 translate -4.5*x }
         plane { -x, 0 rotate z*65 translate  5*x }
         plane { -y, 0 translate y*1.8 }
         plane { z, 0 rotate x*65 }
         plane { -z, 0 rotate -x*65 translate z*7 }
      }
      box { <-4.3, -0.2, 0.2> <4.8, 0, 6.8> texture { Q229_WhitePlaster } }
      difference {
         box { <-4.5, 0, 0> <0.75, 2, 5> }
         plane { x, 0 rotate -z*65 translate -4.5*x }
         plane { -x, 0 rotate z*65 translate  0.75*x }
         plane { z, 0 rotate x*65 }
         translate -z*2
      }
      box { <-4.3, -0.2, 0.2> <0.55, 0, 5> translate -z*2 texture { Q229_WhitePlaster } }
      difference {
         box { <-4.5, 0, 2> <0.75, 2, 7> }
         plane { x, 0 rotate -z*65 translate -4.5*x }
         plane { -x, 0 rotate z*65 translate  0.75*x }
         plane { -z, 0 rotate -x*65 translate z*7 }
         translate z*2
      }
      box { <-4.3, -0.2, 2> <0.55, 0, 6.8> translate z*2 texture { Q229_WhitePlaster } }
      texture { Q229_RoofTile rotate y*90 }
      //scale 1.15
   }
}


#declare Q229_Shell = object {                    // ----- Basic outline of lower part of house
   union {
      box { <-4, 0, 0.7> <4.5, 2.2, 6.5> }
      box { <-4.1, 0, -1.3> <-0.55, 2.2, 5> }     // ----- Master Bedroom
      box { <-4.1, 0, 2> <-0.5, 2.2, 8.5> }       // ----- Back Bedrooms
      box { <0.325, 0, -1.3> <0.525, 2.2, -1.1> } // ----- Porch Support
      box {                                       // ----- Porch Rail
         <0.375, 0.5, -1.1> <0.475, 0.75, 1>
         texture { Q229_BrownWood }
      }
   }
   texture { Q229_RedBrick }
}




// ******************************************************************************************
// ----------------------------------- Windows and Doors ------------------------------------
// ******************************************************************************************


#declare Q229_BWBlockL = object {
   difference {
      box { <-3.95, 0, -2> <-0.75, 1, 5> }
      plane { x, 0 rotate -y*22 translate -3.95*x }
      plane { -x, 0 rotate y*22 translate -0.75*x }
   }
}

#declare Q229_BayWindowL = object {
   union {
      difference {
         object { Q229_BWBlockL }
         object { Q229_BWBlockL scale <1, 10, 1> translate <0, -0.1, 0.1> }
         texture { Q229_RedBrick }
      }
      union {
         // -------------- Central Part
         difference {
            box { < -0.815, 1, -2> <0.815, 2.2, -1.85> }
            box { < -0.715, 1.05, 10> <-0.05, 2.15, -10> }
            box { <  0.715, 1.05, 10> < 0.05, 2.15, -10> }
         }
         cylinder { 1*y, 2.2*y, 0.015 translate <-0.405, 0, -1.925 > }
         cylinder { 1*y, 2.2*y, 0.015 translate < 0.405, 0, -1.925 > }
         cylinder { -0.815*x, 0.815*x, 0.015 translate < 0, 1.30, -1.925 > }
         cylinder { -0.815*x, 0.815*x, 0.015 translate < 0, 1.60, -1.925 > }
         cylinder { -0.815*x, 0.815*x, 0.015 translate < 0, 1.90, -1.925 > }
         box { < -0.815, 1, -1.90> <0.815, 2.2, -1.80> texture { Q229_WindowGlass } }

         // -------------- Right Part
         union {
            difference {
               box { <0, 1, 0> <0.55, 2.2, 0.075> }
               box { <0.05, 1.05, -10> <0.45, 2.15, 10> }
            }
            cylinder { 1*y, 2.2*y, 0.015 translate <0.275, 0, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.30, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.60, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.90, 0.0375 > }
            box { <0, 1, 0.025> <0.55, 2.2, 0.050> texture { Q229_WindowGlass } }
            rotate -y*68
            translate <0.815, 0, -2>
         }

         // -------------- Left Part
         union {
            difference {
               box { <0, 1, 0> <0.55, 2.2, 0.075> }
               box { <0.05, 1.05, -10> <0.45, 2.15, 10> }
            }
            cylinder { 1*y, 2.2*y, 0.015 translate <0.275, 0, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.30, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.60, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.90, 0.0375 > }
            box { <0, 1, 0.025> <0.55, 2.2, 0.050> texture { Q229_WindowGlass } }
            translate -x*0.55
            rotate y*68
            translate <-0.815, 0, -2>
         }
         translate -x*2.35
         texture { Q229_WhiteAluminium }
      }
   }
}

#declare Q229_BWBlockR = object {
   difference {
      box { <1.05, 0, 0> <3.95, 0.5, 5> }
      plane { x, 0 rotate -y*22 translate <1.05, 0, 1> }
      plane { -x, 0 rotate y*22 translate <3.95, 0, 1> }
      //texture { Q229_RedBrick }
   }
}

#declare Q229_BayWindowR = object {
   union {
      difference {
         object { Q229_BWBlockR }
         object { Q229_BWBlockR scale <1, 10, 1> translate <0, -0.1, 0.1> }
         texture { Q229_RedBrick }
      }
      union {

         // -------------- Central Part
         difference {
            box { <-1.0, 0.5, 0> <1.0, 2.2, 0.15> }
            box { <-0.9, 0.6, 10> <-0.05, 2.1, -10> }
            box { < 0.9, 0.6, 10> < 0.05, 2.1, -10> }
         }
         cylinder { 0.5*y, 2.2*y, 0.015 translate <-0.566, 0, 0 > }
         cylinder { 0.5*y, 2.2*y, 0.015 translate <-0.283, 0, 0 > }
         cylinder { 0.5*y, 2.2*y, 0.015 translate < 0.283, 0, 0 > }
         cylinder { 0.5*y, 2.2*y, 0.015 translate < 0.566, 0, 0 > }
         cylinder { -0.9*x, 0.9*x, 0.015 translate < 0, 0.975, 0 > }
         cylinder { -0.9*x, 0.9*x, 0.015 translate < 0, 1.350, 0 > }
         cylinder { -0.9*x, 0.9*x, 0.015 translate < 0, 1.725, 0 > }
         box { <-1, 0.5, 0.025> <1, 2.2, 0.050> texture { Q229_WindowGlass } }

         // -------------- Right Part
         union {
            difference {
               box { <0, 0.5, 0> <0.5, 2.2, 0.075> }
               box { <0.05, 0.55, -10> <0.45, 2.15, 10> }
            }
            cylinder { 0.5*y, 2.2*y, 0.015 translate <0.275, 0, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 0.975, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.350, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.725, 0.0375 > }
            box { <0, 0.5, 0.025> <0.5, 2.2, 0.050> texture { Q229_WindowGlass } }
            rotate -y*68
            translate <1, 0, 0>
         }

         // -------------- Left Part
         union {
            difference {
               box { <0, 0.5, 0> <0.5, 2.2, 0.075> }
               box { <0.05, 0.55, -10> <0.45, 2.15, 10> }
            }
            cylinder { 0.5*y, 2.2*y, 0.015 translate <0.275, 0, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 0.975, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.350, 0.0375 > }
            cylinder { 0*x, 0.55*x, 0.015 translate < 0, 1.725, 0.0375 > }
            box { <0, 0.5, 0.025> <0.5, 2.2, 0.050> texture { Q229_WindowGlass } }
            translate -x*0.5
            rotate y*68
            translate <-1, 0, 0>
         }
         translate x*2.5
         texture { Q229_WhiteAluminium }
      }
   }
}


#declare Q229_DoorHollow = object {
   box { <0, 0.1, 5> <0.675, 1.85, -10> }
}

#declare Q229_BayWindowHollowL = object {
   box { <-3.25, -10, -10> <-1.35, 2.2, 8> }
}

#declare Q229_BayWindowHollowR = object {
   box { <1.55, -10, -10> <3.7, 2.2, 6> }
}

#declare Q229_WindowHollow1 = object {  // ------ Study Window
   box { <-0.35, 0, -10> <0.35, 1.3, 2> }
}

#declare Q229_Window1 = object {
   union {
      difference {
         box { <-0.35, 0, 0.05> <0.35, 1.3, 0.15> }
         box { <-0.30, 0.05, -10> <-0.025, 1.25, 10> }
         box { < 0.30, 0.05, -10> < 0.025, 1.25, 10> }
      }
      box { <-0.30, 0.05, 0.075> <0.30, 1.25, 0.125> texture { Q229_WindowGlass } }
   }
   texture { Q229_WhiteAluminium }
}


#declare Q229_WindowHollow2 = object {  // ------ Living room window
   box { <-0.65, 0, -10> <0.65, 0.6, 2> }
}

#declare Q229_Window2 = object {
   union {
      difference {
         box { <-0.65, 0, 0.05> <0.65, 0.6, 0.15> }
         box { <-0.60, 0.05, -10> < -0.025, 0.55, 10> }
         box { < 0.60, 0.05, -10> <  0.025, 0.55, 10> }
      }
      box { <-0.60, 0.05, 0.075> <0.60, 0.55, 0.125> texture { Q229_WindowGlass } }
   }
   texture { Q229_WhiteAluminium }
}


#declare Q229_Door = object {
   union {
      difference {
         box { <0, 0.1, 0.05> <0.675, 1.85, 0.15> }
         box { <0.1, 0.2, -10> <0.575, 1.75, 10> }
      }
      cylinder { y*0, y*1.85, 0.015 translate <0.218, 0, 0.1> }
      cylinder { y*0, y*1.85, 0.015 translate <0.338, 0, 0.1> }
      cylinder { y*0, y*1.85, 0.015 translate <0.456, 0, 0.1> }
      cylinder { x*0, x*0.675, 0.015 translate <0, 0.308, 0.1> }
      cylinder { x*0, x*0.675, 0.015 translate <0, 0.616, 0.1> }
      cylinder { x*0, x*0.675, 0.015 translate <0, 0.925, 0.1> }
      cylinder { x*0, x*0.675, 0.015 translate <0, 1.232, 0.1> }
      cylinder { x*0, x*0.675, 0.015 translate <0, 1.540, 0.1> }
      box {
         <0.1, 0.1, 0.085> <0.575, 1.75, 0.115>
         texture { Q229_ScreenDoorTexture rotate -z*45 }
         texture { Q229_ScreenDoorTexture rotate  z*45 }
      }
      texture {
         pigment { color rgb <0.98, 0.98, 0.99> }
         finish  {
            ambient 0.6 diffuse 0.5 specular 0.2
            roughness 0.025 reflection 0.05 brilliance 2
         }
      }
   }
}



// ******************************************************************************************
// --------------------------------- Misc Bits and Pieces -----------------------------------
// ******************************************************************************************


#declare Q229_Carport = object {
   union {
      // ----------- Roof, including corrugated top
      difference {
         box { <-3.85, 0, 0.4> <0, 0.15, 10> }
         box { <-3.70, -10, 0.550> <-0.15, 10, 2.875> }
         box { <-3.70, -10, 3.025> <-0.15, 10, 5.200> }
         box { <-3.70, -10, 5.350> <-0.15, 10, 7.525> }
         box { <-3.70, -10, 7.675> <-0.15, 10, 9.850> }
      }
      cylinder { -3.85*x, 0*x, 0.015 translate <0, 0.075, 0.4> }
      box {
         <-3.7, 0.05, 0.55> <0, 0.10, 9.850>
         texture {
            Q229_WhiteAluminium
            normal { gradient x sine_wave scale 0.25 }
         }
      }

      // ----------- Side screen
      box { <-3.85, 0, 2.875> <-3.70, -2.05, 3.025> }
      box { <-3.85, 0, 5.200> <-3.70, -2.05, 5.350> }
      box { <-3.85, 0, 7.525> <-3.70, -2.05, 7.675> }
      difference {
         box { <-3.85, -0.4, 2> <-3.95, -1.2, 9.0> }
         box { <-10, -0.5, 2.1> <10, -1.1, 8.9> }
      }
      box {
         <-3.875, -0.5, 2.1> <-3.925, -1.1, 8.9>
         texture {
            Q229_WhiteAluminium
            normal { gradient y sine_wave scale 0.15 }
         }
      }
      // ----------- Driveway
      union {
         box { <-3.85, -2.04, -1.0> <0, -2.05, 9> }
         difference {
            union {
               box { <-3.85, -2.04, -1.0> <0, -2.05, -9> }
               cylinder { -3.85*x, 0*x, 0.1 scale <1, 1, 1.5> translate <0, -2.15, -9.01> }
            }
            plane { -x, 0 rotate y*12.5 translate -1*z }
         }
         cylinder { -z*9, z*9, 0.025 translate <-1.925, -2.05, 0> }
         cylinder { -x*3.85, x*0, 0.025 translate <0, -2.05, -0.4> }
         texture { Q229_Concrete }
      }
   texture { Q229_WhiteAluminium }
   }
}

#declare Q229_ElectricalBox = object {
   union {
      box { <-0.3, 0, 0> <0, 0.65, 0.6> }
      cylinder { 0*y, -1.3*y, 0.02 translate <-0.15, 0, 0> }
   }
   texture { Q229_GutteringTexture }
}


#declare Q229_Walkway = object {
   union {
      box { <-0.55, 0, 1> <0.55, 0.02, -10> }
      cylinder { -0.55*x, 0.55*x, 0.1 scale <1, 1, 1.5> translate <0, -0.08, -10.01> }
   }
   texture { Q229_Concrete }
}

#declare Q229_Shutter = object {
   union {
      difference {
         box { <-0.2, 0, -0.02> <0.2, 1, 0> }
         box { <-0.17, 0.03, -10> <0.17, 0.97, 10> }
      }
      box {
         <-0.17, 0.03, -0.01> <0.17, 0.97, 0>
         texture {
            pigment { color rgb < 0.8, 0.8, 0.8> }
            finish  { ambient 0.5 diffuse 0.45 specular 0.1 roughness 0.1 }
            normal { gradient y ramp_wave scale 0.05  }
         }
      }
      texture {
         pigment { color rgb < 0.95, 0.95, 0.95> }
         finish  { ambient 0.5 diffuse 0.45 specular 0.1 roughness 0.1 }
      }
   }
}

#declare Q229_MailBox = object {
   union {
      box { <-0.025, 0, -0.025> <0.025, 0.65, 0.025> texture { Q229_BrownWood } }
      difference {
         box { <-0.1, 0.65, -0.2> <0.1, 0.85, 0.2> }
         box { <-0.08, 0.810, -10> <0.08, 0.78, 0> }
         texture { Q229_WhiteAluminium }
      }
      difference {
         cylinder { -0.215*z, 0.215*z, 0.115 open }
         plane { y, 0 translate -y*0.015 }
         translate y*0.85
         texture { Q229_WhiteAluminium pigment { color rgb <0.688, 0.492, 0.000> } }
      }
   }
}


#declare Q229_DrainPipe = object {
   union {
      box { <-0.1, -0.1, -0.1> <0, 1.8, 0.1> }
      box { <-0.4, 2.0, -0.1> <-0.3, 2.2, 0.1> }
      box {
         <-0.05, -0.1, -0.1> <0, 0.5, 0.1>
         rotate z*55
         translate y*1.8
         clipped_by {
            plane { -y, 0 translate y*1.8 }
            plane {  y, 0 translate y*2.0 }
         }
      }
   }
   texture { Q229_GutteringTexture }
}



// ******************************************************************************************
// -------------------------------------- Guttering -----------------------------------------
// ******************************************************************************************


#declare Q229_GutteringStraight = object {
   union {
      cylinder { -0.5*x, 0.5*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { Q229_GutteringTexture }
}

#declare Q229_GutteringStraightR = object {
   union {
      cylinder { -x, 0*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { Q229_GutteringTexture }
}

#declare Q229_GutteringStraightL = object {
   union {
      cylinder { 0*x, x, 0.15 open scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { Q229_GutteringTexture }
}

#declare Q229_GutteringCorner = object {
   union {
      object {
         Q229_GutteringStraight
         clipped_by {
            plane { x,0 rotate -y*45 }
            plane { -x,0 translate -x*0.1 }
         }
      }
      object {
         Q229_GutteringStraight
         rotate -y*90
         clipped_by {
            plane { x,0 rotate y*135 }
            plane { z,0 translate z*0.1 }
         }
      }
   }
   texture { Q229_GutteringTexture }
}



// ******************************************************************************************
// ------------------------------------ Garden/Rockery --------------------------------------
// ******************************************************************************************

#declare Q229_RockeryBlock = object {
   difference {
      torus { 0.3, 0.1 }
      plane { -x, 0 }
      plane { -z, 0 }
   }
}

#declare Q229_RockeryTexture = texture {
   pigment {
      marble //crackle
      colour_map {
         [ 0.00 color rgb < 0.80, 0.70, 0.30 > ]
         [ 0.40 color rgb < 0.70, 0.60, 0.30 > ]
         [ 0.76 color rgb < 0.65, 0.50, 0.35 > ]
         [ 1.00 color rgb < 0.50, 0.50, 0.30 > ]
      }
      turbulence 1
      scale 0.4
      rotate 40
   }
   finish { ambient 0.15 diffuse 0.45 specular 0.2 roughness 0.1}
   normal {
      average
      normal_map {
         [ 1.0 marble 1 turbulence 0.5 ]
         [ 0.5 bozo 0.5 turbulence 0.2 ]
         [ 2.0 crackle 1 ]
      }
      turbulence 0.1
      scale <0.25, 0.5, 0.5>
   }
   scale 0.8
}

#declare Q229_RockeryTop = object {
   union {
      union {
         object {
            Q229_RockeryBlock
            clipped_by { plane {z,0 rotate -y*20} }
            translate <-0.6, 0, 0>
         }
         cylinder { 0*z, 0.6*z, 0.1 rotate -y*20 translate <-0.88, 0, -0.12> }
         object {
            Q229_RockeryBlock
            clipped_by { plane {-z,0 rotate -y*20} }
            translate <-0.8, 0, 0.54>
         }
      }
      object { Q229_RockeryBlock rotate -y*90 translate <-0.6, 0, 0> }
      object { Q229_RockeryBlock rotate y*90 scale <1, 1, 0.25> translate <0, 0, 0> }
      object { Q229_RockeryBlock rotate y*180 scale <1, 1, 0.25> translate <0, 0, 0> }
      object { Q229_RockeryBlock translate <0.6, 0, 0> }
      object {
         Q229_RockeryBlock
         rotate -y*90
         clipped_by { plane {z,0 rotate y*20} }
         translate <0.6, 0, 0>
      }
      cylinder { 0*z, 0.6*z, 0.1 rotate y*20 translate <0.88, 0, -0.12> }
      object {
         Q229_RockeryBlock
         rotate -y*90
         clipped_by { plane {-z,0 rotate y*20} }
         translate <0.8, 0, 0.54>
      }
      scale <1, 1.45, 1>
   }
}

#declare Q229_RockeryBase = object {
   intersection {
      object { Q229_RockeryTop }
      box { <-10, 0, -10> <10, 0.05, 10> }
      texture { Q229_Concrete }
   }
   scale <1.025, 1, 1.075>
   translate -z*0.075
}

#declare Q229_Rockery = object {
   union {
      object { Q229_RockeryTop texture { Q229_RockeryTexture } }
      object { Q229_RockeryBase }
      clipped_by { plane { -y, 0 } }
   }
   scale <1.25, 1.25, 1.5>
}

#declare Q229_Rockery2Top = object {
   union {
      cylinder { -0.6*x, 0*x, 0.1 translate <-0.6, 0, -0.3> }
      object { Q229_RockeryBlock rotate -y*90 translate <-0.6, 0, 0> }
      object { Q229_RockeryBlock rotate y*90 scale <1, 1, 0.25> translate <0, 0, 0> }
      object { Q229_RockeryBlock rotate y*180 scale <1, 1, 0.25> translate <0, 0, 0> }
      object { Q229_RockeryBlock translate <0.6, 0, 0> }
      object {
         Q229_RockeryBlock
         rotate -y*90
         clipped_by { plane {z,0 rotate y*20} }
         translate <0.6, 0, 0>
      }
      cylinder { 0*z, 0.6*z, 0.1 rotate y*20 translate <0.88, 0, -0.12> }
      object {
         Q229_RockeryBlock
         rotate -y*90
         clipped_by { plane {-z,0 rotate y*20} }
         translate <0.8, 0, 0.54>
      }
      scale <1, 1.45, 1>
   }
}

#declare Q229_Rockery2Base = object {
   intersection {
      object { Q229_Rockery2Top }
      box { <-10, 0, -10> <10, 0.05, 10> }
      texture { Q229_Concrete }
   }
   scale <1.025, 1, 1.075>
   translate -z*0.075
}

#declare Q229_Rockery2 = object {
   union {
      object { Q229_Rockery2Top texture { Q229_RockeryTexture } }
      object { Q229_Rockery2Base }
      clipped_by { plane { -y, 0 } }
   }
   scale <1.25, 1.25, 1.5>
}

#declare Q229_Rockery3Top = object {
   torus { 0.2, 0.025 scale <1, 1.65, 1> }
}

#declare Q229_Rockery3Base = object {
   intersection {
      object { Q229_Rockery3Top }
      box { <-10, 0, -10> <10, 0.01, 10> }
      texture { Q229_Concrete }
   }
   scale <1.05, 1, 1.075>
}

#declare Q229_Rockery3 = object {
   union {
      object { Q229_Rockery3Top texture { Q229_RockeryTexture } }
      object { Q229_Rockery3Base }
      clipped_by { plane { -y, 0 } }
   }
   scale <1.25, 1.25, 1.5>
}

#declare Q229_Land = object {
   union {
      box { <-8, -0.1, -10> <8, 0, 10> }
      cylinder { -8*x, 8*x, 0.1 translate <0, -0.1, -10> }
   }
   texture { CBH_Grass1 }
}

#declare Q229_Land = object {
   union {
      height_field {
         gif "grass1.gif"
         translate <-0.5, 0, -0.5>
         water_level 0.01
         scale <20, 0.15, 20>
      }
      cylinder { -10*x, 10*x, 0.15 translate <0, 0, -10> }
      translate -y*0.15
      texture { CBH_Grass1 }
   }
}

#declare Q229_SteppingStone = object {
   union {
      cylinder { 0*y, 0.05*y, 0.25 }
      torus { 0.2, 0.01 translate y*0.05 }
   }
   texture { Q229_Concrete }
}

// ******************************************************************************************
// -------------------------------------- Side Fence ----------------------------------------
// ******************************************************************************************


#declare Q229_Fence = object {
   union {
      box {
         <0, 0, 0> <3, 1.4, -0.1>
         texture {
            pigment {
               gradient x
               sine_wave
               colour_map {
                  [ 0.00 color rgbt < 0.98, 0.95, 0.91, 0 > ]
                  [ 0.35 color rgbt < 0.98, 0.95, 0.91, 0 > ]
                  [ 0.35 color rgbt < 0.98, 0.95, 0.91, 1 > ]
                  [ 1.00 color rgbt < 0.98, 0.95, 0.91, 1 > ]
               }
               scale 0.2
               translate 10*x
            }
            finish { ambient 0.55 diffuse 0.4 }
         }
      }
      box { <0, 1.1, 0> <3, 1.2, 0.075> }
      box { <0, 0.2, 0> <3, 0.3, 0.075> }
      texture { Q229_FenceTexture }
   }
}

#declare Q229_FenceCorner = object {
   union {
      box { <-0.15, 0, -0.15> <0, 1.6, 0> }
      sphere { 0*y, 0.09 scale <1, 1.35, 1> translate <-0.075, 1.585, -0.075> }
   }
   texture { Q229_FenceTexture }
}



// ******************************************************************************************
// ----------------------------------- Plants and Shrubs ------------------------------------
// ******************************************************************************************



#declare Q229_Shrub1 = object {
   union {
      sphere { 0*y, 0.35 scale <0.8, 3.5, 0.8> translate y*1.35 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage4 }
   }
}

#declare Q229_Shrub2 = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.1, 1> translate y*0.5 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}

#declare Q229_Shrub3 = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.3, 1> translate y*0.45 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage2 }
   }
}

#declare Q229_Shrub4 = object {
   union {
      sphere { 0*y, 0.35 scale <0.8, 1.6, 0.6> translate y*0.65 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage2 }
   }
}

#declare Q229_Shrub5 = object {
   union {
      sphere { 0*y, 0.35 scale <1.4, 1.6, 1> translate y*0.6 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}

#declare Q229_Shrub6 = object {
   union {
      sphere { 0*y, 0.08 scale <1, 0.8, 1> translate -z*0.085 rotate y*000 }
      sphere { 0*y, 0.09 scale <1, 0.8, 1> translate -z*0.085 rotate y*120 }
      sphere { 0*y, 0.07 scale <1, 0.8, 1> translate -z*0.085 rotate y*240 }
      texture { CBH_Foliage1 }
   }
   scale <2.25, 2.65, 2.25>
   clipped_by { plane { -y, 0 } }
}



// ******************************************************************************************
// ---------------------------------- Build Main Object -------------------------------------
// ******************************************************************************************


// ------ Assesmble shell and subtract unwanted pieces

#declare Q229_Body = object {
   difference {
      object { Q229_Shell }
      object { Q229_DoorHollow translate <-0.375, 0, 0> texture { Q229_Interior } }
      object { Q229_BayWindowHollowL texture { Q229_Interior } }
      object { Q229_BayWindowHollowR texture { Q229_Interior } }
      object { Q229_DoorHollow rotate y*90 translate <-4, 0, 4> texture { Q229_Interior } }
      object { Q229_WindowHollow1 rotate y*90 translate <0, 0.7, 2> texture { Q229_Interior } }
      object { Q229_WindowHollow2 rotate -y*90 translate <0, 1.5, 2.15> texture { Q229_Interior } }
   }
}


// ------ Attach other parts to shell

#declare Q229_Main = object {
   union {
      // ----------- Main Shell
      object { Q229_Body }
      object { Q229_Roof translate <0, 2.4, 0> }

      // -----------  Front Windows and Doors
      object { Q229_BayWindowL translate <0, 0, 0.3> }
      object { Q229_BayWindowR translate <0, 0, 0.3> }
      object { Q229_Door translate <-0.375, 0, 0.6> }

      // -----------  Side Windows and Doors
      object { Q229_Door rotate y*90 translate <-4.05, 0, 4> }
      object { Q229_Window1 rotate y*90 translate <-4.05, 0.7, 2> }
      object { Q229_Window2 rotate -y*90 translate <4.55, 1.5, 2.15> }

      // -----------  Guttering
      object { Q229_GutteringStraightR scale <4.95, 1, 1> translate <0.65, 2.45, -1.9> }
      object { Q229_GutteringCorner translate <0.65, 2.45, -1.9> }
      object { Q229_GutteringCorner rotate y*90 translate <-4.35, 2.45, -1.9> }
      object { Q229_GutteringStraightR scale <10.8, 1, 1> rotate y*90 translate <-4.35, 2.45, -1.8> }
      object { Q229_GutteringStraightL scale <2, 1, 1> rotate -y*90 translate <0.65, 2.45, -1.8> }
      object { Q229_GutteringStraightR scale <4, 1, 1> translate <4.9, 2.45, 0.125> }
      object { Q229_GutteringCorner translate <4.9, 2.45, 0.125> }
      object { Q229_GutteringStraightL scale <6.8, 1, 1> rotate -y*90 translate <4.9, 2.45, 0.2> }

      // ----------- Misc Bits
      object { Q229_Carport translate <-4.15, 2.05, -1> }
      object { Q229_ElectricalBox translate <-4, 0.8, -0.3> }
      object { Q229_Walkway }

      object { Q229_Shutter translate <-3.70, 1, -1.3> }
      object { Q229_Shutter translate <-1.00, 1, -1.3> }
      object { Q229_Shutter scale <1, 1.5, 1> translate < 4.05, 0.5, 0.7> }
      object { Q229_Shutter scale <1, 1.5, 1> translate < 1.00, 0.5, 0.7> }

      object { Q229_DrainPipe translate <-4.1, 0.1, -0.8> }
      object { Q229_DrainPipe rotate y*180 translate <4.5, 0.1, 1.0> }
      object { Q229_DrainPipe rotate y*180 translate <4.5, 0.1, 6.25> }

      // ----------- Fence Assembly
      object { Q229_Fence translate <4.5, 0, 3> }
      object { Q229_Fence rotate -y*90 translate <7.5, 0, 3> }
      object { Q229_Fence rotate -y*90 translate <7.5, 0, 6> }
      object { Q229_FenceCorner translate <7.5, 0, 3> }

      // ----------- Landscaping on Left
      object { Q229_Rockery translate <-2.35, 0, -2> }
      object { Q229_Shrub1 translate < 1.05, 0, -0.2> }
      object { Q229_Shrub2 translate < 1.85, 0, 0.1> }
      object { Q229_Shrub3 translate < 3, 0.1, -0.1> }
      object { Q229_Shrub4 translate < 3.8, 0,  0.4> }

      // ----------- Landscaping on Right
      object { Q229_Rockery2 scale 1.2 translate <2.5, 0, -0.2> }
      object { Q229_Shrub5 translate < -3.3, 0, -1.9> }
      object { Q229_Shrub2 translate < -2.3, 0, -2> }
      object { Q229_Shrub3 translate < -1.3, 0.1, -1.9> }

      // ----------- Mailbox and landscaping
      object { Q229_MailBox translate <1.5, 0, -9> }
      object { Q229_Shrub6 translate <1.5, 0, -9> }
      object { Q229_Rockery3 scale 1.2 translate <1.5, 0, -9> }

      object { Q229_Land }
      object { Q229_SteppingStone translate <-3.5, 0, -4.5> }
      object { Q229_SteppingStone translate <-2.5, 0, -4.5> }
      object { Q229_SteppingStone translate <-1.5, 0, -4.5> }

      translate y*0.15
   }
}




// ******************************** END OF FILE
