
// Persistence of Vision Ray Tracer Scene Description File
// File: talbingo.pov
// Vers: 1.00

// Desc: --------* 7 Talbingo Place *--------
//         A model of 7 Talbingo Place, the successor to 229 Quakers Road.
//         My parents recently bought this new house.
//         Blond brick, 2 storey house with double garage. Only the front is modelled
//         in any detail, as this is all that is seen of the house.
//         Created for the Nov-Dec 1997 IRTC.

// Date: 31st Nov 1997
// Auth: Chris Hernandez


// ==== Standard POV-Ray Includes ====
#include "colors.inc"   // Standard Color definitions
#include "SKIES.INC"

#include "FOLIAGE.INC"


// ******************************************************************************************
// ----------------------------------- Define Textures --------------------------------------
// ******************************************************************************************


#declare Talbingo_RollADoor = texture {
   pigment { color rgb <0.994, 0.971, 0.749> }
   finish { ambient 0.6 diffuse 0.4 specular 0.2 roughness 0.01 crand 0.01 }
   normal { gradient y scallop_wave }
   scale 0.1
}

#declare Talbingo_GutteringTexture = texture {
   pigment { color rgb <0.999, 0.969, 0.822> }
   finish  { ambient 0.65 diffuse 0.5 specular 0.2 roughness 0.025 reflection 0.05 brilliance 2  }
}

#declare Talbingo_CreamPlaster = texture {
   pigment { color rgb <0.999, 0.969, 0.822> }
   finish  { ambient 0.55 diffuse 0.4 specular 0.15 roughness 0.1 }
}

#declare Talbingo_Interior = texture {
   pigment { color rgb <0.999, 0.969, 0.822> }
   finish  { ambient 0.35 diffuse 0.4 specular 0.15 roughness 0.1 }
}

#declare Talbingo_RoofTile = texture {
   pigment { color rgb <0.702, 0.308, 0.350> }
   finish  { ambient 0.55 diffuse 0.4 specular 0.15 roughness 0.1 }
   normal {
      average
      normal_map {
         [ 1 gradient x ramp_wave scale 0.20 ]
         [ 1 gradient z sine_wave scale 0.15 ]
      }
   }
}

#declare Talbingo_WindowTexture = texture {
   pigment { color rgbf<0.85, 0.85, 0.85, 0.9> }
   finish  {
	  specular 1
	  roughness 0.001
	  ambient 0.05
	  diffuse 0.05
	  refraction on
	  reflection 0.1
	  ior 1.5
	  caustics 0.5
	  //brilliance 2 //8
   }
}


#declare Talbingo_BlondBrick = texture {
   brick
      //---------- Mortar Texture
      texture {
         pigment { color rgb <0.994, 0.971, 0.949> }
         finish { ambient 0.55 diffuse 0.4 specular 0.2 roughness 0.05 crand 0.1 }
      }
      //---------- Brick Texture
      texture {
         pigment {
            bozo
            /*
            colour_map {
               [ 0.00 color rgb <0.894, 0.871, 0.649> ]
               [ 0.33 color rgb <0.873, 0.735, 0.390> ]
               [ 0.66 color rgb <0.755, 0.735, 0.351> ]
               [ 1.00 color rgb <0.851, 0.822, 0.351> ]
            }
            */
            colour_map {
               [ 0.00 color rgb <0.994, 0.921, 0.699> ]
               [ 0.33 color rgb <0.973, 0.785, 0.440> ]
               [ 0.66 color rgb <0.855, 0.785, 0.401> ]
               [ 1.00 color rgb <0.951, 0.872, 0.401> ]
            }
            turbulence 1
         }
         finish { ambient 0.6 diffuse 0.45 specular 0.35 roughness 0.05 crand 0.15 }
         normal {
            average
            normal_map {
               [ 1 bozo 0.6 turbulence 0.75 ]
               [ 1 crackle 0.4 ]
            }
            scale 0.1
         }
      }
   brick_size <2.5, 1, 1>
   mortar 0.25 //0.4
   scale 0.1 //0.2
}


#declare Talbingo_ScreenDoorTexture = texture {
   pigment {
      gradient x
      colour_map {
         [ 0.00 color rgbt <0.999, 0.969, 0.822, 1.000>]
         [ 0.40 color rgbt <0.999, 0.969, 0.822, 1.000>]
         [ 0.40 color rgbt <0.999, 0.969, 0.822, 0.500>]
         [ 0.60 color rgbt <0.999, 0.969, 0.822, 0.500>]
         [ 0.60 color rgbt <0.999, 0.969, 0.822, 1.000>]
         [ 1.00 color rgbt <0.999, 0.969, 0.822, 1.000>]
      }
   }
   finish  {
      ambient 0.65 diffuse 0.5 specular 0.2
      roughness 0.025 brilliance 2
   }
   scale 0.03
}


#declare Talbingo_FenceWood = texture {
   pigment {
      wood
      colour_map {
         [ 0.00 color rgb <0.784, 0.706, 0.235> ]
         [ 0.25 color rgb <0.706, 0.706, 0.235> ]
         [ 0.50 color rgb <0.627, 0.588, 0.353> ]
         [ 0.75 color rgb <0.706, 0.549, 0.157> ]
         [ 1.00 color rgb <0.706, 0.627, 0.471> ]
      }
      turbulence 0.1
   }
   finish { ambient 0.5 diffuse 0.45 crand 0.1 }
   rotate x*90
   scale 0.2
}

#declare Talbingo_RWTexture = texture {  //----- Retaining Wall Texture
   pigment {
      wrinkles //granite
      colour_map {
         [ 0.00 color rgb <0.994, 0.821, 0.899> ]
         [ 0.33 color rgb <0.973, 0.885, 0.740> ]
         [ 0.66 color rgb <0.955, 0.885, 0.701> ]
         [ 1.00 color rgb <0.951, 0.872, 0.801> ]
      }
      turbulence 1
   }
   finish { ambient 0.55 diffuse 0.4 crand 0.1 }
   normal { crackle 1 scale 0.25 }
}



#declare Talbingo_PavingTexture = texture {
   brick
      //---------- Mortar Texture
      texture {
         pigment { color rgb <0.894, 0.871, 0.849> }
         finish { ambient 0.45 diffuse 0.4 specular 0.2 roughness 0.05 crand 0.1 }
      }
      //---------- Brick Texture
      texture {
         pigment {
            bozo
            colour_map {
               [ 0.00 color rgb <0.702, 0.308, 0.350> ]
               [ 0.33 color rgb <0.602, 0.308, 0.350> ]
               [ 0.66 color rgb <0.602, 0.408, 0.450> ]
               [ 1.00 color rgb <0.502, 0.308, 0.450> ]
            }
            turbulence 1
         }
         finish { ambient 0.6 diffuse 0.45 specular 0.35 roughness 0.05 crand 0.15 }
         normal {
            average
            normal_map {
               [ 1 bozo 0.6 turbulence 0.75 ]
               [ 1 crackle 0.4 ]
            }
            scale 0.1
         }
      }
   brick_size <2.5, 1, 1>
   mortar 0.075 //0.175 //0.075 //0.2
   scale 0.35 //0.5
   rotate -x*135
   //rotate y*45
   translate z*2
}



// ******************************************************************************************
// ------------------------------------- Shell of House -------------------------------------
// ******************************************************************************************


#declare Talbingo_Shell = object {
   union {

      // ---------------------------------- Main Part
      difference {
         box { <-4.5, 0, 0> <4.5, 5, 10> texture { Talbingo_BlondBrick } }
         box { <-4.4, 0.1, 0.1> <4.4, 4.9, 9.9> texture { Talbingo_Interior } }
      }
      difference {
         box {
            <-4.5/sqrt(2), -4.5/sqrt(2), 0> <4.5/sqrt(2), 4.5/sqrt(2), 10>
            rotate z*45
            scale <1, 0.35, 1>
            clipped_by { plane { -y, 0 } }
         }
         plane { z, 0 rotate x*45 texture { Talbingo_RoofTile rotate y*90 } }
         plane { -z, -10 rotate -x*45 texture { Talbingo_RoofTile rotate y*90 } }
         translate y*5
         texture { Talbingo_RoofTile }
      }

      // ---------------------------------- Garage
      difference {
         box { < 4.5, 0, -1> <8.5, 2.25, 5> }
         box { < 4.75, -10, -0.75> <6.35, 1.9, -5> /*texture { Talbingo_RollADoor }*/ }
         box { < 6.65, -10, -0.75> <8.25, 1.9, -5> /*texture { Talbingo_RollADoor }*/ }
         texture { Talbingo_BlondBrick }
      }
      box { < 4.75, 0, -0.75> <6.35, 1.9, -0.751> texture { Talbingo_RollADoor } }
      box { < 6.65, 0, -0.75> <8.25, 1.9, -0.751> texture { Talbingo_RollADoor } }
      box {
         < 5.45, 0.7,-0.75> <5.65, 0.8,-0.80>
         texture {
            pigment { color rgb <0.3, 0.3, 0.3> }
            finish  { ambient 0.4 diffuse 0.35 specular 0.15 roughness 0.01 }
         }
      }
      box {
         < 7.35, 0.7,-0.75> <7.55, 0.8,-0.80>
         texture {
            pigment { color rgb <0.3, 0.3, 0.3> }
            finish  { ambient 0.4 diffuse 0.35 specular 0.15 roughness 0.01 }
         }
      }
      union {
         difference {
            box { <-2/sqrt(2), -2/sqrt(2), -1.5> <2/sqrt(2), 2/sqrt(2), 5> }
            box {
               <-2/sqrt(2), -2/sqrt(2), -1> <2/sqrt(2), 2/sqrt(2), -10>
               translate <-0.35, -0.35, 0>
               texture { Talbingo_BlondBrick scale <1,1/0.4,1> rotate -z*45 }
            }
            plane { z, 0 translate -z*1.15 texture { Talbingo_CreamPlaster } }
         }
         cylinder {
            -2/sqrt(2)*y, 2/sqrt(2)*y, 0.075
            scale <1, 1, 0.8>
            translate <(2/sqrt(2)-0.075), 0, -1.15>
            texture { Talbingo_CreamPlaster }
         }
         cylinder {
            -2/sqrt(2)*x, 2/sqrt(2)*x, 0.075
            scale <1, 1, 0.8>
            translate <0, (2/sqrt(2)-0.075), -1.15>
            texture { Talbingo_CreamPlaster }
         }
         rotate z*45
         scale <1, 0.4, 1>
         clipped_by { plane { -y, 0 } }
         translate <6.5, 2.25, 0>
         texture { Talbingo_RoofTile }
      }

      // ---------------------------------- Central (extruded) Part
      difference {
         box { < -1.2, 0, -0.5> <1.2, 5, 5> texture { Talbingo_BlondBrick } }
         box { < -1.1, 0, -0.4> <1.1, 4.9, 5.1> texture { Talbingo_Interior } }
      }
      union {
         difference {
            box { <-1.2/sqrt(2), -1.2/sqrt(2), -1> <1.2/sqrt(2), 1.2/sqrt(2), 5> }
            box {
               <-1.2/sqrt(2), -1.2/sqrt(2), -0.5> <1.2/sqrt(2), 1.2/sqrt(2), -10>
               translate <-0.35, -0.35, 0>
               texture { Talbingo_BlondBrick scale <1,2,1> rotate -z*45 }
            }
            plane { z, 0 translate -z*0.6 texture { Talbingo_CreamPlaster } }
         }
         cylinder {
            -1.2/sqrt(2)*y, 1.2/sqrt(2)*y, 0.075
            scale <1, 1, 0.8>
            translate <(1.2/sqrt(2)-0.075), 0, -0.6>
            texture { Talbingo_CreamPlaster }
         }
         cylinder {
            -1.2/sqrt(2)*x, 1.2/sqrt(2)*x, 0.075
            scale <1, 1, 0.8>
            translate <0, (1.2/sqrt(2)-0.075), -0.6>
            texture { Talbingo_CreamPlaster }
         }
         rotate z*45
         scale <1, 0.5, 1>
         clipped_by { plane { -y, 0 } }
         translate <0, 5, 0>
         texture { Talbingo_RoofTile }
      }

      // ---------------------------------- Porch
      box { <-1.2, 2.2, -1.95> <1.2, 2.55, -0.5> texture { Talbingo_CreamPlaster } }
      union {
         cylinder { 0.4*y, 2.2*y, 0.125 }
         torus { 0.125, 0.075 scale <1, 0.8, 1> translate y*2.2 }
         torus { 0.125, 0.075 scale <1, 0.8, 1> translate y*0.4 }
         box { <-0.25, 0, -0.25> <0.25, 0.4, 0.25> texture { Talbingo_BlondBrick } }
         texture { Talbingo_CreamPlaster }
         translate <-0.925, 0, -1.825>
      }
      union {
         cylinder { 0.4*y, 2.2*y, 0.125 }
         torus { 0.125, 0.075 scale <1, 0.8, 1> translate y*2.2 }
         torus { 0.125, 0.075 scale <1, 0.8, 1> translate y*0.4 }
         box { <-0.25, 0, -0.25> <0.25, 0.4, 0.25> texture { Talbingo_BlondBrick } }
         texture { Talbingo_CreamPlaster }
         translate <0.925, 0, -1.825>
      }
   }
}


// ******************************************************************************************
// ----------------------------------- Windows + Doors --------------------------------------
// ******************************************************************************************


#declare Talbingo_WindowHollow = object {
   box { <-0.415, 0.4, 1> <0.415, 1.9, -10> }
}

#declare Talbingo_DoorHollow = object {
   box { <-0.625, 0.1, 1> <0.625, 2.0, -10> }
}

#declare Talbingo_WindowHollow2 = object {
   union {
      box { <-0.625, 0.25, 1> <0.625, 1.375, -10> }
      cylinder { z*1, -10*z, 0.625 translate y*1.375 }
   }
}

#declare Talbingo_Window1 = object {
   union {
      difference {
         box { <-0.415, 0.4, 0.05> <0.415, 1.9, 0.15> }
         box { <-0.400, 0.415, 10> <0.400, 1.80, -10> }
      }
      box { <-0.400, 0.415, 0.065> <0.400, 1.80, 0.110> texture { Talbingo_WindowTexture } }
      cylinder { 0.4*y, 1.9*y, 0.03 scale <1, 1, 0.85> translate z*0.075 }
      cylinder { -0.415*x, 0.415*x, 0.04 scale <1, 1, 0.85> translate <0, 0.9, 0.075> }
      box {
         <-0.415, 0.05, 0.1> <0.415, -0.1, -0.125>
         texture { Talbingo_BlondBrick rotate y*90 }
         rotate -x*25
         translate y*0.3
      }
   }
   texture {
      pigment { color rgb <0.999, 0.969, 0.822> }
      finish  {
         ambient 0.65 diffuse 0.5 specular 0.2
         roughness 0.025 reflection 0.05 brilliance 2
      }
   }
}

#declare Talbingo_Window2 = object {
   union {
      difference {
         union {
            box { <-0.625, 0.25, 0.05> <0.625, 1.375, 0.15> }
            cylinder { z*0.05, 0.15*z, 0.625 translate y*1.375 }
         }
         union {
            box { <-0.6, 0.275, 10> <0.6, 1.350, -10> }
            cylinder { z*10, -10*z, 0.6 translate y*1.350 }
         }
      }
      cylinder { -x*0.625, x*0.625, 0.030 translate y*1.35 }
      cylinder { -x*0.625, x*0.625, 0.020 translate y*0.967 }
      cylinder { -x*0.625, x*0.625, 0.020 translate y*0.608 }
      cylinder { y*0.25, y*1.9, 0.030 }
      cylinder { y*0.25, y*1.375, 0.020 translate -x*0.3 }
      cylinder { y*0.25, y*1.375, 0.020 translate  x*0.3 }
      union {
         cylinder { 0*y, 0.6*y, 0.020 rotate z*45 }
         cylinder { 0*y, 0.6*y, 0.020 rotate -z*45 }
         torus { 0.3, 0.015 rotate x*90 clipped_by { plane { -y, 0 } } }
         translate y*1.35
      }
      union {
         box { <-0.6, 0.275, 0.065> <0.6, 1.350, 0.110> }
         cylinder { z*0.065, 0.110*z, 0.6 translate y*1.350 }
         texture { Talbingo_WindowTexture }
      }
   }
   texture {
      pigment { color rgb <0.999, 0.969, 0.822> }
      finish  {
         ambient 0.65 diffuse 0.5 specular 0.2
         roughness 0.025 reflection 0.05 brilliance 2
      }
   }
}


#declare Talbingo_Door = object {
   union {
      difference {
         box { <-0.625, 0.1, 0.05> <0.625, 2.1, 0.15> }
         box { <-0.600, 0.3, 10> <0.600, 1.95, -10> }
      }
      difference {
         box { <-0.595, 0.305, 0.05> <0, 1.945, 0.15> }
         box { <-0.585, 0.315, 10> <-0.05, 1.93, -10> }
      }
      difference {
         box { <0.595, 0.305, 0.05> <0, 1.945, 0.15> }
         box { <0.585, 0.315, 10> <0.05, 1.93, -10> }
      }
      union {
         cylinder { -x*0.625, x*0.625, 0.01 translate y*1.35 }
         cylinder { -x*0.625, x*0.625, 0.01 translate y*0.967 }
         cylinder { -x*0.625, x*0.625, 0.01 translate y*0.608 }
         cylinder { y*0.25, y*1.9, 0.030 }
         cylinder { y*0.25, y*1.375, 0.012 translate -x*0.3 }
         cylinder { y*0.25, y*1.375, 0.012 translate  x*0.3 }
         union {
            cylinder { 0*y, 0.6*y, 0.01 rotate z*45 }
            cylinder { 0*y, 0.6*y, 0.01 rotate -z*45 }
            torus { 0.3, 0.015 rotate x*90 clipped_by { plane { -y, 0 } } }
            translate y*1.35
         }
         scale <0.5, 1.1, 1.2>
         translate x*0.315
      }
      box {
         <0.585, 0.315, 0.05> <0.05, 1.93, 0.15>
         texture { Talbingo_ScreenDoorTexture rotate -z*45 }
         texture { Talbingo_ScreenDoorTexture rotate  z*45 }
      }
      union {
         cylinder { -x*0.625, x*0.625, 0.01 translate y*1.35 }
         cylinder { -x*0.625, x*0.625, 0.01 translate y*0.967 }
         cylinder { -x*0.625, x*0.625, 0.01 translate y*0.608 }
         cylinder { y*0.25, y*1.9, 0.030 }
         cylinder { y*0.25, y*1.375, 0.012 translate -x*0.3 }
         cylinder { y*0.25, y*1.375, 0.012 translate  x*0.3 }
         union {
            cylinder { 0*y, 0.6*y, 0.01 rotate z*45 }
            cylinder { 0*y, 0.6*y, 0.01 rotate -z*45 }
            torus { 0.3, 0.015 rotate x*90 clipped_by { plane { -y, 0 } } }
            translate y*1.35
         }
         scale <0.5, 1.1, 1.2>
         translate -x*0.315
      }
      box {
         <-0.585, 0.315, 0.05> <-0.05, 1.93, 0.15>
         texture { Talbingo_ScreenDoorTexture rotate -z*45 }
         texture { Talbingo_ScreenDoorTexture rotate  z*45 }
      }
   }
   texture {
      pigment { color rgb <0.999, 0.969, 0.822> }
      finish  {
         ambient 0.6 diffuse 0.5 specular 0.2
         roughness 0.025 reflection 0.05 brilliance 2
      }
   }
}

#declare Talbingo_Main = object {
   difference {
      object { Talbingo_Shell }
      object { Talbingo_WindowHollow translate <3.65, 0, 0> }
      object { Talbingo_WindowHollow translate <2.20, 0, 0> }
      object { Talbingo_WindowHollow translate <-3.65, 0, 0> }
      object { Talbingo_WindowHollow translate <-2.20, 0, 0> }
      object { Talbingo_WindowHollow translate <3.65, 2.5, 0> }
      object { Talbingo_WindowHollow translate <2.20, 2.5, 0> }
      object { Talbingo_WindowHollow translate <-3.65, 2.5, 0> }
      object { Talbingo_WindowHollow translate <-2.20, 2.5, 0> }
      object { Talbingo_DoorHollow }
      object { Talbingo_WindowHollow2 translate <0, 2.5, 0> }
   }
   texture { Talbingo_BlondBrick }
}



// ******************************************************************************************
// -------------------------------------- Guttering -----------------------------------------
// ******************************************************************************************

#declare Talbingo_GutteringStraight = object {
   union {
      cylinder { -0.5*x, 0.5*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { Talbingo_GutteringTexture }
}

#declare Talbingo_GutteringStraightR = object {
   union {
      cylinder { -x, 0*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { Talbingo_GutteringTexture }
}

#declare Talbingo_GutteringStraightL = object {
   union {
      cylinder { 0*x, x, 0.15 open scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { Talbingo_GutteringTexture }
}

#declare Talbingo_GutteringCorner = object {
   union {
      object {
         Talbingo_GutteringStraight
         clipped_by {
            plane { x,0 rotate -y*45 }
            plane { -x,0 translate -x*0.1 }
         }
      }
      object {
         Talbingo_GutteringStraight
         rotate -y*90
         clipped_by {
            plane { x,0 rotate y*135 }
            plane { z,0 translate z*0.1 }
         }
      }
   }
   texture { Talbingo_GutteringTexture }
}


// ******************************************************************************************
// ----------------------------------- Misc Components --------------------------------------
// ******************************************************************************************

#declare Talbingo_AlarmBox = object {
   union {
      box {
         <-0.15, 0, 0> <0.15, 0.2, -0.2>
         texture { Talbingo_GutteringTexture normal { gradient y scallop_wave scale 0.01} }
      }
      sphere {
         0*y, 0.135
         scale <1, 1.3, 1>
         texture {
            pigment { color rgbf <0.5, 0.5, 0.8, 0.8> }
            finish  { ambient 0.5 diffuse 0.35 specular 0.3 roughness 0.001 reflection 0.1 }
         }
      }
   }
   scale <0.775, 0.9, 0.8>
}


#declare Talbingo_Fence = object {
   difference {
      union {
         box { <-0.015, -0.6, -6> <0.015, 1.6, 20> }
         box { <-0.025, 1.55, -10> <0.025, 1.7, 20> texture { Talbingo_FenceWood } }
         box { <-0.025, 0.30, -10> <0.025, 0.45, 20> texture { Talbingo_FenceWood } }
         box {
            <-0.025, 1.55, -10> <0.025, 1.7, 20>
            texture { Talbingo_FenceWood }
            rotate -x*10 translate -z*1.5
         }
      }
      plane { -y,0 translate y*1.7 }
      plane { -y,0 translate y*1.7 rotate -x*10 translate -z*1.5 }
      plane {  z,0 translate -z*6 }
   }
   texture {
      Talbingo_FenceWood
      normal {
         gradient z
         scallop_wave
         slope_map {
            [ 0.00  0 ]
            [ 0.25  0 ]
            [ 0.25  1 ]
            [ 0.75  1 ]
            [ 0.75  0 ]
            [ 1.00  0 ]
         }
         scale <1, 1, 0.5>
      }
   }
}


#declare Talbingo_BackFence = object {
   union {
      box { <-0.015, -0.6, -8.5> <0.015, 1.6, 8.5> }
      box { <-0.025, 1.55, -8.5> <0.025, 1.7, 8.5> texture { Talbingo_FenceWood } }
      box { <-0.025, 0.30, -8.5> <0.025, 0.45, 8.5> texture { Talbingo_FenceWood } }
      texture {
         Talbingo_FenceWood
         normal {
            gradient z
            scallop_wave
            slope_map {
               [ 0.00  0 ]
               [ 0.25  0 ]
               [ 0.25  1 ]
               [ 0.75  1 ]
               [ 0.75  0 ]
               [ 1.00  0 ]
            }
            scale <1, 1, 0.5>
         }
      }
   }
}



#declare Talbingo_MailBox = object {
   union {
      difference {
         box { <-0.2, 0, -0.2> <0.2, 0.1, 0.2> }
         cylinder { -10*x, 10*x, 0.05 scale <1.2, 1.4, 3.5> translate <0, 0.1,  0.2> }
         cylinder { -10*x, 10*x, 0.05 scale <1.2, 1.4, 3.5> translate <0, 0.1, -0.2> }
         cylinder { -10*z, 10*z, 0.05 scale <2.5, 1.4, 1.2> translate < 0.2, 0.1, 0> }
         cylinder { -10*z, 10*z, 0.05 scale <2.5, 1.4, 1.2> translate <-0.2, 0.1, 0> }
         scale <1.1, 1, 1.1>
         translate y*0.125
      }
      difference {
         box { <-0.2, -0.125, -0.2> <0.2, 0, 0.2> }
         plane { -x, 0 rotate -z*20 translate  x*0.2 }
         plane {  x, 0 rotate  z*20 translate -x*0.2 }
         plane { -z, 0 rotate  x*20 translate  z*0.2 }
         plane {  z, 0 rotate -x*20 translate -z*0.2 }
         box { <-0.15, -0.05, 0> <0.15, -0.025, -10> }
         translate y*0.125
      }
      box { <-0.03, -1, -0.03> <0.05, 0, 0.03> }
      union {
         torus {
            0.1, 0.005
            rotate x*90
            clipped_by { plane {-x,0} plane{y,0} }
            scale <2, 1, 1>
            translate -0.23*x
         }
         torus {
            0.1, 0.005
            rotate x*90
            clipped_by { plane {x,0} plane{y,0} }
            scale <0.5, 0.5, 1>
            translate <-0.23, -0.045, 0>
         }
         torus {
            0.1, 0.01
            rotate x*90
            clipped_by { plane {x,0} plane{-y,0} }
            scale <0.25, 0.25, 1>
            translate <-0.255, -0.045, 0>
         }
         box { <-0.325, -0.105, 0.01> <-0.075, -0.225, -0.01> }
         translate -y*0.1
      }
      cylinder { -0.15*z, 0.15*z, 0.065 open translate <0.115, -0.0735, 0> }
   }
   texture {
      pigment { color rgb <0.949, 0.919, 0.772> }
      finish  { ambient 0.6 diffuse 0.5 specular 0.1 roughness 0.025 reflection 0.05 }
   }
   translate y*0.45
   scale 1.2
}



// ******************************************************************************************
// -------------------------------------- Landscaping ---------------------------------------
// ******************************************************************************************

#declare Talbingo_Land = object {
   difference {
      union {
         cylinder {
            -8.5*x, 8.5*x, 0.6
            clipped_by { plane { z,0 } plane { -y,0 } }
            scale <1, 1, 12>
         }
         box { <-8.5, 0, 0> <8.5, 0.6, 22> }
      }
      // -------- Remove dirt to create different levels for retaining wall
      box { <-8.55, 0.3, 22> <-5.8, 0.65, -5.01> }
      box { <-8.55, 0.3, -4.99> <1.6, 0.65, -10> }
      difference {
         cylinder { 0.3*y, 0.65*y, 2 }
         plane { x, 0 }
         translate -z*2
         scale <1, 1, 2>
         translate <1.6, 0, -3>
      }
      difference {
         cylinder { 0.3*y, 0.65*y, 2 }
         plane { -x, 0 translate x*0.01 }
         translate -z*2
         scale <1.25, 1, 0.5>
         translate <1.6, 0, -3>
      }
      box { <0, 0.3, 0> <2, 0.6, -1.01> translate <-1, 0, -4> }
      difference {
         box { <0, 0.3, -0.01> <1.1, 0.6, 1> }
         cylinder { -10*y, 10*y, 1 translate <0, 0, 1> }
         scale <2, 1, 1>
         translate <-2.9, 0, -5>
      }
      difference {
         box { <0, 0.3, 0.01> <1, 0.65, -1> }
         cylinder { -10*y, 10*y, 1 translate <1, 0, 0> }
         scale <2.5, 1, 6>
         translate <-5.8, 0, 1>
      }
      box { <-8.5, 0.075, -6.5> < 3.5, 0.3, -100> }
   }
   texture { CBH_Grass1 }
}

#declare Talbingo_RWBlock = object {
   merge {
      box { <-8.55, 0, 22> <-5.79, 0.65, -5.01> }
      box { <-8.55, 0, -4.99> <1.61, 0.65, -10> }
      difference {
         cylinder { 0*y, 0.65*y, 2 translate -x*0.01}
         plane { x, 0 }
         translate -z*2
         scale <1, 1, 2>
         translate <1.6, 0, -3>
      }
      difference {
         cylinder { 0*y, 0.65*y, 2 }
         plane { -x, 0 translate x*0.01 }
         translate -z*2
         scale <1.25, 1, 0.5>
         translate <1.6, 0, -3>
      }
      box { <0, 0, 0.01> <2, 0.6, -1.01> translate <-1, 0, -4> }
      difference {
         box { <-0.01, 0, -0.01> <1, 0.6, 1.1> }
         cylinder { -10*y, 10*y, 1 translate <0, 0, 1> }
         scale <2, 1, 1>
         translate <-2.9, 0, -5>
      }
      difference {
         box { <-0.01, 0, 0.01> <1, 0.65, -1.01> }
         cylinder { -10*y, 10*y, 1 translate <1, 0, 0> }
         scale <2.5, 1, 6>
         translate <-5.8, 0, 1>
      }
   }
}


#declare Talbingo_RetainingWall1 = object {
   intersection {
      difference {
         object { Talbingo_RWBlock }
         object { Talbingo_RWBlock scale <1, 20, 1> translate <0, -7, -0.20> }
      }
      cylinder {
         -8.5*x, 8.5*x, 0.6
         clipped_by { plane { z,0 } plane { -y,0 } }
         scale <1, 1.05, 12>
      }
   }
   scale <1, 1.1, 1>
   texture { Talbingo_RWTexture }
}

#declare Talbingo_RetainingWall2 = object {
   box { <-8.5, 0.1, -6.5> < 3.5, 0.35, -6.65> }
   texture { Talbingo_RWTexture }
}


#declare Talbingo_Paving = object {
   difference {
      intersection {
         union {
            box { < 5.2, -10, 2> <8.5, 10, -20> }
            box { < -0.75, -10, -1.5> <8.5, 10, -2.5> }
            box { < -0.65, -10,  1> <0.65, 10, -2.5> }
            cylinder { -10*y, 10*y, 0.7 scale <1, 1, 4> translate <5.2, 0, -1.5> }
         }
         cylinder {
            -8.5*x, 8.5*x, 0.61
            clipped_by { plane { z,0 translate z*0.2} plane { -y,0 } }
            scale <1, 1, 12>
         }
      }
      cylinder {
         -10*y, 10*y, 0.7
         clipped_by { plane { -z,0 } }
         translate -z*0.7
         scale <2, 1, 10>
         translate <5.1, 0, -4.4>
      }
      texture { Talbingo_PavingTexture }
   }
}


// ******************************************************************************************
// ---------------------------------- Shrubs and Plants -------------------------------------
// ******************************************************************************************

#declare Talbingo_Shrub1 = object {
   union {
      sphere { 0*y, 0.35 scale <0.8, 3.5, 0.8> translate y*1.35 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage4 }
   }
}

#declare Talbingo_Shrub2 = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.1, 1> translate y*0.5 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}

#declare Talbingo_Shrub3 = object {
   union {
      sphere { 0*y, 0.35 scale <1.5, 1.3, 1> translate y*0.45 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage2 }
   }
}

#declare Talbingo_Shrub4 = object {
   union {
      sphere { 0*y, 0.35 scale <0.8, 1.6, 0.6> translate y*0.65 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage2 }
   }
}

#declare Talbingo_Shrub5 = object {
   union {
      sphere { 0*y, 0.35 scale <1.4, 1.6, 1> translate y*0.6 }
      cylinder {
         0.4*y, 0*y, 0.04
         texture { pigment { color rgb <0.7, 0.5, 0.2> } }
      }
      texture { CBH_Foliage3 }
   }
}

#declare Talbingo_Shrub6 = object {
   union {
      sphere { 0*y, 0.08 scale <1, 0.8, 1> translate -z*0.085 rotate y*000 }
      sphere { 0*y, 0.09 scale <1, 0.8, 1> translate -z*0.085 rotate y*120 }
      sphere { 0*y, 0.07 scale <1, 0.8, 1> translate -z*0.085 rotate y*240 }
      texture { CBH_Foliage1 }
   }
   scale <2.25, 2.65, 2.25>
   clipped_by { plane { -y, 0 } }
}


#declare Talbingo_Shrub7 = object {
   box { <-8, 0.4, -6.2> < 3.5, 1.2, -5.8> }
   texture { CBH_Foliage4 }
}




// ******************************************************************************************
// ------------------------------------- Main Object ----------------------------------------
// ******************************************************************************************

#declare Talbingo = object {
   union {
      object { Talbingo_Main }

      // --------- Guttering - upper left
      object { Talbingo_GutteringStraightL scale <3.3, 1, 1> translate <1.2, 5, 0> }
      object { Talbingo_GutteringCorner translate <4.5, 5, 0> }
      object { Talbingo_GutteringCorner translate <1.2, 5, -0.5> }
      object { Talbingo_GutteringCorner rotate y*90 translate <1.1, 5, -0.5> }
      object { Talbingo_GutteringStraightL scale <0.1, 1, 1> translate <1.1, 5, -0.5> }
      object { Talbingo_GutteringStraightL scale <0.6, 1, 1> rotate y*90 translate <1.45, 5, 0> }
      object { Talbingo_GutteringStraightL scale <10, 1, 1> rotate -y*90 translate <4.5, 5, 0> }

      // --------- Guttering - upper right
      object { Talbingo_GutteringStraightR scale <3.3, 1, 1> translate <-1.2, 5, 0> }
      object { Talbingo_GutteringCorner rotate y*90 translate <-4.5, 5, 0> }
      object { Talbingo_GutteringCorner translate <-1.1, 5, -0.5> }
      object { Talbingo_GutteringStraightR scale <0.1, 1, 1> translate <-1.1, 5, -0.5> }
      object { Talbingo_GutteringCorner rotate y*90 translate <-1.2, 5, -0.5> }
      object { Talbingo_GutteringStraightR scale <0.6, 1, 1> rotate -y*90 translate <-1.45, 5, 0> }
      object { Talbingo_GutteringStraightR scale <10, 1, 1> rotate y*90 translate <-4.5, 5, 0> }

      // --------- Guttering - porch
      object { Talbingo_GutteringStraightR scale <1.1, 1, 1> translate <0, 2.55, -1.95> }
      object { Talbingo_GutteringStraightL scale <1.1, 1, 1> translate <0, 2.55, -1.95> }
      object { Talbingo_GutteringCorner rotate y*0 translate <1.1, 2.55, -1.95> }
      object { Talbingo_GutteringCorner rotate y*90 translate <-1.1, 2.55, -1.95> }
      object { Talbingo_GutteringStraightL scale <1.5, 1, 1> rotate -y*90 translate <1.1, 2.55, -1.85> }
      object { Talbingo_GutteringStraightR scale <1.5, 1, 1> rotate y*90 translate <-1.1, 2.55, -1.85> }

      // --------- Guttering - garage
      object { Talbingo_GutteringCorner translate <4.75, 2.25, -1.1> }
      object { Talbingo_GutteringCorner rotate y*90 translate <4.5, 2.25, -1.1> }
      object { Talbingo_GutteringStraightL scale <0.25, 1, 1> translate <4.5, 2.25, -1.1> }
      object { Talbingo_GutteringStraightR scale <1.1, 1, 1> rotate y*90 translate <4.5, 2.25, -1.1> }
      object { Talbingo_GutteringCorner translate <8.5, 2.25, -1.1> }
      object { Talbingo_GutteringCorner rotate y*90 translate <8.25, 2.25, -1.1> }
      object { Talbingo_GutteringStraightL scale <0.25, 1, 1> translate <8.25, 2.25, -1.1> }
      object { Talbingo_GutteringStraightL scale <6, 1, 1> rotate -y*90 translate <8.5, 2.25, -1.1> }

      // --------- Windows + Doors
      object { Talbingo_Window1 translate <3.65, 0, 0> }
      object { Talbingo_Window1 translate <2.20, 0, 0> }
      object { Talbingo_Window1 translate <-3.65, 0, 0> }
      object { Talbingo_Window1 translate <-2.20, 0, 0> }
      object { Talbingo_Window1 translate <3.65, 2.5, 0> }
      object { Talbingo_Window1 translate <2.20, 2.5, 0> }
      object { Talbingo_Window1 translate <-3.65, 2.5, 0> }
      object { Talbingo_Window1 translate <-2.20, 2.5, 0> }
      object { Talbingo_Window2 translate <0, 2.5, -0.5> }
      object { Talbingo_Door translate <0, 0, -0.5> }

      // --------- Other Bits
      object { Talbingo_AlarmBox translate < -4.15, 4.5, 0> }
      object { Talbingo_Fence translate < 10, 0, 0> }
      object { Talbingo_Fence translate < -7, 0, 0> }
      object { Talbingo_BackFence rotate y*90 translate < 1.5, 0, 20> }

      // --------- Landscaping
      object { Talbingo_Land translate <1.5, -0.6, -1> }
      object { Talbingo_Paving translate <0, -0.6, -1> }
      object { Talbingo_RetainingWall1 translate <1.5, -0.6, -1> }
      object { Talbingo_RetainingWall2 translate <1.5, -0.6, -1> }

      object { Talbingo_Shrub1 translate <-1.8, 0, -1.5> }
      object { Talbingo_Shrub6 translate <-2.8, 0, -2.2> }
      object { Talbingo_Shrub6 translate <-2.4, 0, -1.9> }
      object { Talbingo_Shrub6 translate <-2.3, 0, -2.3> }
      object { Talbingo_Shrub3 translate <-3.8, 0, -1.8> }

      object { Talbingo_Shrub2 translate < 2, 0, -1.4> }
      object { Talbingo_Shrub3 translate < 3, 0, -2.2> }
      object { Talbingo_Shrub4 translate < 4, 0, -1.5> }
      object { Talbingo_Shrub1 translate < 9, 0, -2.0> }

      object { Talbingo_Shrub4 translate <-3.8, -0.3, -6.0> }
      object { Talbingo_Shrub4 translate < 2.2, -0.3, -6.5> }
      object { Talbingo_Shrub4 translate < 3.2, -0.3, -5.3> }
      object { Talbingo_Shrub6 translate < 4.4, 0, -6.8> }
      object { Talbingo_Shrub6 translate < 4.1, 0, -6.5> }
      object { Talbingo_Shrub6 translate < 4.0, 0, -6.9> }

      object { Talbingo_MailBox translate <5.6, 0, -7.8> }

      translate y*0.6
   }
}



// ******************************** END OF FILE
