//model07.pov          12/12/97
              
#include "colors.inc"   
#include "finish.inc"   
#include "textures.inc"  
#include "glass.inc"      
#include "woodmaps.inc"  
#include "skies.inc"
#include "metals.inc"
#include "woods.inc" 

camera {
        location < 0, 3, -40 > 
        look_at  < 0, 5.5, 0 > 
        angle 30
        }
background { color rgb < 0.4, 0.4, 0.9 > }

sky_sphere { S_Cloud5  rotate 20*y }
sphere { 0, 1                                 // SMOKE TRAIL
        pigment { color rgbt < 1, 1, 1, 1 > }
        halo { 
        attenuating
        spherical_mapping
        linear
        turbulence 1.25
        color_map {
                  [ 0.0 color rgbt < 0.1, 0.1, 0.1, 1 > ]   
                  [ 0.4 color rgbt < 0.1, 0.1, 0.1, 1 > ]  
                  [ 0.5 color rgbt < 0, 0, 0, -1 > ]
                  [ 1.0 color rgbt < 0, 0, 0, -1 > ]   
                  }
        samples 10
        scale < 0.5, 1, 0.5 >
             }
        hollow 
        scale  < 2, 20, 2 >
        rotate -20*z
        translate < -20, 17, 150 >
      }
height_field {                              // LANDSCAPE
               tga "wrinc2.tga"   smooth
               texture {
                       pigment {
                               granite
                               turbulence 0.7
                               color_map {
                                        [ 0.1 color rgb < 0.8, 0.8, 0.4 > ]
                                        [ 0.4 color rgb < 0.5, 0.6, 0.2 > ]
                                        [ 0.7 color rgb < 0.6, 0.5, 0.1 > ]
                                        [ 1 color rgb < 0.5, 0.6, 0.4 > ]
                                          }
                                scale 2
                                }
                       finish { ambient 0.4 }
                       }
              hollow
              scale < 300, 60, 300 >
              translate < -100, -30, 25 >

            }
plane { y, -20     hollow                             // SEA
           pigment { color rgb < 0.5, 0.5, 1 > }
           finish { ambient 0.2 
                    reflection 0.4  }
      }

plane { z, 16     hollow                            // MIST
           pigment { 
                     bozo 
                     turbulence 1.0
                        color_map {
                              [ 0.0  color rgbt < 0.9, 0.9, 0.9, 0.6 > ] 
                              [ 0.3  color rgbt < 0.85, 0.85, 0.85, 0.5 > ]
                              [ 0.5  color rgbt < 0.85, 0.85, 0.85, 0.5 > ] 
                              [ 0.6  color rgbt < 0.8, 0.8, 0.8, 0.6 > ]
                              [ 0.7  color rgbt < 0.85, 0.85, 0.85, 0.5 > ]
                              [ 0.8  color rgbt < 0.85, 0.85, 0.85, 0.5> ] 
                              [ 1.0  color rgbt < 0.9, 0.9, 0.9, 0.6 > ]
                                 }
                         scale 20
                     }
            finish { ambient 0.2 }
            translate < 10, 3, 0 >
       }

light_source { < 0, 3, -40 > color  Gray45 shadowless  }   
light_source { < 100, 30, 60 > color  White  }
light_source { < -10, 25, -15 > color  White  
                spotlight 
                radius  20
                falloff  40
                tightness  10
                point_at < 1, 0, -1 > 
             }
light_source { < -5, 5, -25 > color  White  
                spotlight 
                radius  20
                falloff  40
                tightness  10
                point_at < 0, 0, -1 > 
             }

#declare Silo =                     // BURNING PLANE
              union {
                     sphere { < 0, 0, 0 >,1  scale < 0.1, 1, 0.1 > }
                     box { < -1, 0, 0.01 >,< 1, -0.4, 0 > }
                     box { < -0.3, 1, 0.01 >,< 0.3, 1.1, 0 > }
                     pigment { color Gray15 }
                     }
object { Silo rotate -20*z translate < -22, 10, 150 > }

// MODEL
#declare Carve =
             texture { pigment { P_WoodGrain4A color_map { M_Wood10A  }}
                        rotate 90*y }
             texture { pigment { P_WoodGrain4B color_map { M_Wood10B  }}
                        rotate 90*y } 

#declare Ping =
             sphere { < 0, 0, 0 >,8  scale < 0.18, 0.04, 1 >
                   clipped_by {
                            box { < -3, -1, 0 >,< 3, 1, 10 > }
                              }
                    texture { Carve }
                    finish { ambient 0.2 }
                    }
#declare Xht =
               cylinder { < 0, 0, 0 >,< 0.1, 0, 0 >,0.1  open
                          rotate 45*y
                          texture { Carve }
                          finish { ambient 0.2 }
                        }
#declare Tubs =
               union {
                     object { Xht translate < -1.4, 0.15, -0.6 > }
                     object { Xht translate < -1.2, 0.15, -0.6 > }
                     object { Xht translate < -1.0, 0.15, -0.6 > }
                     object { Xht translate < -0.8, 0.15, -0.6 > }
                     object { Xht translate < -0.6, 0.15, -0.6 > }
                     object { Xht translate < -0.4, 0.15, -0.6 > }

                     }
#declare Xubs =
            union {
                object { Xht rotate 180*x translate < -1.4, 0.15, 0.6 > }
                object { Xht rotate 180*x translate < -1.2, 0.15, 0.6 > }
                object { Xht rotate 180*x translate < -1.0, 0.15, 0.6 > }
                object { Xht rotate 180*x translate < -0.8, 0.15, 0.6 > }
                object { Xht rotate 180*x translate < -0.6, 0.15, 0.6 > }
                object { Xht rotate 180*x translate < -0.4, 0.15, 0.6 > }

                     }

#declare Nose =
             union {
                   object { Tubs }
                   object { Xubs }
                   cone { < 2, 0, 0 >,0.3 < -1.8, 0, 0 >,0.4 open
                            scale < 1, 0.4, 0.8 >
                            translate -0.6*y
                        }    
                   sphere { < 0, 0, 0 >,2.75   scale < 1, 0.275, 0.24 > }
                   sphere { < 0, 0, 0 >,2.75   scale < 1, 0.15, 0.205 >
                            translate 0.25*y
                          }
                    texture { Carve }
                    finish { ambient 0.2 }
                    }
#declare Pin =
             union {
              sphere { < 0, 0, 0 >,0.35  scale < 1.65, 1, 1 >
                    texture { Carve }
                    finish { ambient 0.2 }
                     }
              cylinder { < 0, 0, 0 >,< 0.35, 0, 0 >,0.375
                    texture { Carve }
                    finish { ambient 0.2 }
                       }
                    }
#declare Stk =              
              difference {
                    box { < 5.4, 0.9, -0.02 >,< 6.9, 1.7, 0.02 > }
                    cylinder { < 5.4, 1.7, -0.5 >,< 5.4, 1.7, 0.5 >,0.8 }
                      texture { Carve }
                      finish { ambient 0.2 }
                         }
#declare Arf =
            union {  
              object { Stk  translate < 0.01, -0.4, 0 > }
              sphere { < 0, 0, 0 >,1 scale < 0.7, 1, 0.04 >    // fin
                       translate < 6.9, 0.8, 0 >
                     }
              cone { < 0, 0.2, 0 >,0.9 < 7, 0.1, 0 >,0.3       // tailcone
                     scale < 1, 1.2, 0.64 >
                   }
              difference {
              sphere { < 0, 0, 0 >,2.25 scale < 0.3, 0.01, 1 >   // tailplane
                     }
              box { < -0.4, 1, -0.4 >,< 0.4, -1, 0.4 >
                     rotate 45*y
                     translate 0.675*x
                  }
                  translate < 6.5, 0.35, 0 >  
                         }
                     texture { Carve }
                     finish { ambient 0.2 }
                    }
#declare Til =
           difference {
              object { Arf }
              box { < 0, 0.45, -1 >,< 1.6, 1.5, 1 > 
                    pigment { color Gray50 }
                  }
                      }
#declare Bod =
             union {
                   object { Nose translate < -1.25, 0.6, 0 > } 
                   object { Pin translate < -3.8, 0.65, 0 > }
                   object { Til translate 0.5*y }
                   torus { 0.66, 0.02  rotate 90*z  scale < 1, 1.3, 0.75 >
                           translate < 0.23, 0.925, 0 >
                           texture { Carve }                // frame
                           finish { ambient 0.2 }
                         }
                   torus { 0.6, 0.02  rotate 90*x  scale < 1.8, 1.3, 0.75 >
                           translate < 0.75, 0.925, -0.3 >
                           texture { Carve }                // frame
                           finish { ambient 0.2 }
                         }
                   torus { 0.6, 0.02  rotate 90*x  scale < 1.8, 1.3, 0.75 >
                           translate < 0.75, 0.925, 0.3 >
                           texture { Carve }                // frame
                           finish { ambient 0.2 }
                         }
                   sphere { < 0, 0, 0 >,0.7   scale < 1.8, 1.3, 0.75 > // cab
                     translate < 0.75, 0.925, 0 >   
                     texture { Carve }
                          }
                     } 
#declare Things =                     
               union {
                   object { Ping rotate < -6, 0, -4 > }
                   object { Ping rotate < -174, 0, -4 > } 
                     }
object { Bod rotate < -30, 60, 6 > translate < 1, -0.2, 1 > }
object { Things rotate < -6, -40, 0 >  translate < -4, -0.5, -5.6 > }    
 // TABLE  
box { < 4.3, -0.5, 15 >,< -15, -4, -22 >   rotate 15*y         
       translate < 8, 0, 8 >
       pigment { 
                 bozo
                 turbulence 0.8
                 color_map {
                           [ 0.0 color rgb < 0.8, 0.6, 0.4 > ]
                           [ 0.2 color rgb < 0.6, 0.7, 0.1 > ]
                           [ 0.4 color rgb < 0.7, 0.4, 0.2 > ]
                           [ 0.6 color rgb < 0.7, 0.6, 0.4 > ]
                           [ 0.8 color rgb < 0.5, 0.7, 0.1 > ]
                           [ 1.0 color rgb < 0.7, 0.4, 0.2 > ]
                           }
               }
       finish { ambient 0.2
                reflection 0.1 }
    }

// BOOK
#declare Spine =
         difference {
        cylinder { < -4, 0, 0 >,< 4, 0, 0 >,0.3  open  scale < 1, 1, 0.3 > }   
        box { < -4.5, 0.2, 0 >,< 4.5, -0.2, 1 > }
            translate -0.45*y
            pigment { 
                    image_map {
                                gif "latin.gif"   once
                              }
                     translate  < -0.5, -0.5, 0 >
                     scale 4
                    }                
            normal { bumps 0.25 scale 0.01 }      
            finish { ambient 0.1 
                     diffuse 0.4
                     phong 0.5 }        
                    }          
          
#declare Cover =
          union {
                box { < -2, 0.25, 0 >,< 2, 0.2, 3 >
                      pigment { color Red }
                      finish { ambient 0.1 
                               diffuse 0.4 } 
                    }
                difference {
                box { < -1.9, 0.2, 2.9 >,< 1.9, -0.2, 0 >
                      pigment { color White }
                      finish { ambient 0.2 
                               diffuse 0.4  }
                     }
                cylinder { < -2, 0, 0 >,< 2, 0, 0 >,0.2
                         scale < 1, 1, 0.2 >
                         translate 2.9*z
                      pigment { color White }
                      finish { ambient 0.2 
                               diffuse 0.4 }
                     }
                           }
                box { < -2, -0.25, 0 >,< 2, -0.2, 3 >
                      pigment { color Red }
                      finish { ambient 0.2 
                               diffuse 0.4 } 
                    }
                translate -0.45*y
                  }

#declare Book =
              union {
                    object { Cover }
                    object { Spine }
                    }
object { Book rotate < 0, 60, 0 > translate < 4.6, 0.29, -6.3 > }

// "REAL" PLANES
#declare Camo =               // CAMOFLAGE PAINT
             pigment { 
                      gradient x
                      turbulence 0.75
                      color_map {
                                  [ 0.0 color rgb < 0.3, 0.8, 0.1 > ]
                                  [ 0.5 color rgb < 0.3, 0.8, 0.1 > ] 
                                  [ 0.5 color rgb < 0.6, 0.6, 0.4 > ]
                                  [ 1.0 color rgb < 0.6, 0.6, 0.4 > ]
                                 }
                      rotate 30*y

                     }
#declare Pilot =
               union {
                      superellipsoid { < 1, 0.2 >  scale < 0.5, 0.2, 0.5 >
                                       rotate < 90, 90, 0 >
                                       translate < 0.28, -0.5, 0 >
                                       pigment { color Black }    // seat
                                     }
                      torus { 0.2, 0.05  rotate 90*x scale < 0.5, 0.6, 1 >
                              translate < -0.08, -0.25, 0 >
                              pigment { color Black }             // oxy
                            }
                      sphere { < 0, 0, 0 >,0.14 scale < 0.3, 0.5, 0.95 > 
                               translate -0.12*x 
                               pigment { color Gray75 }            // gogg
                               finish { reflection 0.35 }
                              } 
                      sphere { < 0, 0, 0 >,0.18 scale < 0.9, 1.15, 0.8 > }

                      superellipsoid { < 1, 0.2 >  scale < 0.5, 0.2, 0.5 >
                                       rotate < 90, 90, 0 >
                                       translate < 0.08, -0.7, 0 >
                                     }
                      pigment { color Gray25 }
                      finish { ambient 0.2 }
                      }
#declare Prop =
             disc { < 0, 0, 0 >, < 0, 1, 0 >,2
                   pigment {
                             radial
                             color_map {
                                         [ 0.0 color White ]    // blade
                                         [ 0.03 color Clear ]
                                         [ 0.3 color Clear ]
                                         [ 0.33 color White ]   // blade
                                         [ 0.36 color Clear ]
                                         [ 0.63 color Clear ]
                                         [ 0.66 color White ]    // blade
                                         [ 0.69 color Clear ]
                                         [ 0.97 color Clear ]
                                         [ 1.0 color White ]
                                        }
                             }
                    finish { reflection 0.15 }
                   }

#declare Wing =
             sphere { < 0, 0, 0 >,8  scale < 0.18, 0.04, 1 >
                   clipped_by {
                            box { < -3, -1, 0 >,< 3, 1, 10 > }
                              }
                    pigment { Camo }
                    finish { ambient 0.2 }
                    }
#declare Exht =
               cylinder { < 0, 0, 0 >,< 0.1, 0, 0 >,0.1  open
                          rotate 45*y
                          pigment { color Gray65 }
                          finish { ambient 0.2 }
                        }
#declare Stubs =
               union {
                     object { Exht translate < -1.4, 0.15, -0.6 > }
                     object { Exht translate < -1.2, 0.15, -0.6 > }
                     object { Exht translate < -1.0, 0.15, -0.6 > }
                     object { Exht translate < -0.8, 0.15, -0.6 > }
                     object { Exht translate < -0.6, 0.15, -0.6 > }
                     object { Exht translate < -0.4, 0.15, -0.6 > }

                     }
#declare Tubs =
            union {
                object { Exht rotate 180*x translate < -1.4, 0.15, 0.6 > }
                object { Exht rotate 180*x translate < -1.2, 0.15, 0.6 > }
                object { Exht rotate 180*x translate < -1.0, 0.15, 0.6 > }
                object { Exht rotate 180*x translate < -0.8, 0.15, 0.6 > }
                object { Exht rotate 180*x translate < -0.6, 0.15, 0.6 > }
                object { Exht rotate 180*x translate < -0.4, 0.15, 0.6 > }

                     }

#declare Cowl =
             union {
                   object { Stubs }
                   object { Tubs }
                   cone { < 2, 0, 0 >,0.3 < -1.8, 0, 0 >,0.4 open
                            scale < 1, 0.4, 0.8 >
                            translate -0.6*y
                        }    
                   sphere { < 0, 0, 0 >,2.75   scale < 1, 0.275, 0.24 > }
                   sphere { < 0, 0, 0 >,2.75   scale < 1, 0.15, 0.205 >
                            translate 0.25*y
                          }
                    pigment { Camo }
                    finish { ambient 0.2 }
                    }

#declare Fair =
              cone { < 0.3, 0, 0 >,0.0 < 1.8, 0, 0 >,0.35 open
                     clipped_by {
                            box { < 0, 0, 1 >,< 1.82, -1, -1 >
                                }
                                 }
                     rotate < -45, 16, -10 >
                     translate < -0.1, -0.075, -0.5 >
                     pigment { color Green }
                     finish { ambient 0.2 }
                    }
#declare Sair =     
              cone { < 0.3, 0, 0 >,0.0 < 1.8, 0, 0 >,0.35 open
                     clipped_by {
                            box { < 0, 0, 1 >,< 1.82, -1, -1 >
                                }
                                 }
                     rotate < 45, -16, -10 >
                     translate < -0.1, -0.075, 0.5 >
                     pigment { color Green }
                     finish { ambient 0.2 }
                    }


#declare Spin =
             union {
              sphere { < 0, 0, 0 >,0.35  scale < 1.65, 1, 1 >
                    pigment { color White }
                    finish { ambient 0.2 }
                     }
              cylinder { < 0, 0, 0 >,< 0.35, 0, 0 >,0.375
                    pigment { color Green }
                    finish { ambient 0.2 }
                       }
                    }
#declare Strak =              
              difference {
                    box { < 5.4, 0.9, -0.02 >,< 6.9, 1.7, 0.02 > }
                    cylinder { < 5.4, 1.7, -0.5 >,< 5.4, 1.7, 0.5 >,0.8 }
                      pigment { Camo }
                      finish { ambient 0.2 }
                         }
#declare Aft =
            union {  
              object { Strak  translate < 0.01, -0.4, 0 > }
              object { Fair }
              object { Sair }   
              sphere { < 0, 0, 0 >,1 scale < 0.7, 1, 0.04 >    // fin
                       translate < 6.9, 0.8, 0 >
                     }
              cone { < 0, 0.2, 0 >,0.9 < 7, 0.1, 0 >,0.3       // tailcone
                     scale < 1, 1.2, 0.64 >
                   }
              difference {
              sphere { < 0, 0, 0 >,2.25 scale < 0.3, 0.01, 1 >   // tailplane
                     }
              box { < -0.4, 1, -0.4 >,< 0.4, -1, 0.4 >
                     rotate 45*y
                     translate 0.675*x
                  }
                  translate < 6.5, 0.35, 0 >  
                         }
                     pigment { Camo }
                     finish { ambient 0.2 }
                    }
#declare Tail =
           difference {
              object { Aft }
              box { < 0, 0.45, -1 >,< 1.6, 1.5, 1 > 
                    pigment { color Gray50 }
                  }
                      }
#declare Plane =
             union {
                   object { Wing rotate < -6, 0, -4 > }
                   object { Wing rotate < -174, 0, -4 > } 
                   object { Cowl translate < -1.25, 0.6, 0 > } 
                   object { Spin translate < -3.8, 0.65, 0 > }
                   object { Prop rotate 90*z translate < -3.8, 0.65, 0 > }
                   object { Tail translate 0.5*y }
                   torus { 0.66, 0.02  rotate 90*z  scale < 1, 1.3, 0.75 >
                           translate < 0.23, 0.925, 0 >
                           pigment { color Gray65 }                // frame
                           finish { ambient 0.2 }
                         }
                   torus { 0.6, 0.02  rotate 90*x  scale < 1.8, 1.3, 0.75 >
                           translate < 0.75, 0.925, -0.3 >
                           pigment { color Gray65 }                // frame
                           finish { ambient 0.2 }
                         }
                   torus { 0.6, 0.02  rotate 90*x  scale < 1.8, 1.3, 0.75 >
                           translate < 0.75, 0.925, 0.3 >
                           pigment { color Gray65 }                // frame
                           finish { ambient 0.2 }
                         }
                   sphere { < 0, 0, 0 >,0.7   scale < 1.8, 1.3, 0.75 > // cab
                     translate < 0.75, 0.925, 0 >   
                     texture { T_Glass2 }
                          }
                   object { Pilot translate < 0.85, 1.35, 0 > }
                     }
object { Plane scale 2.5 rotate < -45, -40, 0 > translate < 12, 15, 80 > }
object { Plane scale 0.95 rotate < -5, -75, -10 > translate < 25, 30, 90 > } 
object { Plane scale 0.95 rotate < -30, -65, 0 > translate < -22, 25, 80 > }

// PAINT POTS
#declare Jar =  
            lathe {
                  cubic_spline
                  19,
        < -1, 0 >,< 0, 0 >,< 1, 0 >,< 1.25, 0.25 >,< 1.5, 0.5 >,
        < 1.5, 2.25 >,< 1.25, 2.5 >,< 0.8, 3 >,< 1, 3.75 >,< 1.15, 4 >,
        < 1.25, 3.75 >,< 1.25, 3 >,< 1.75, 2.25 >,< 1.75, 0.5 >,< 1.75, 0 >,
        < 1.5, -0.3 >,< 1, -0.5 >,< 0, -0.5 >,< -1, -0.5 >
                 texture { Glass3 }
                  }
#declare Paint =
            lathe {
                  cubic_spline
                  8,
        < -1, 0 >,< 0, 0 >,< 1, 0 >,< 1.25, 0.25 >,< 1.5, 0.5 >,
        < 1.5, 2.25 >,< 0, 2.25 >,< -1, 2.25 >
                  pigment { color rgbt < 0.6, 0.6, 0.4, 0.3 > }
                  finish { ambient 0.2 }
                   }
#declare Baint =
            lathe {
                  cubic_spline
                  8,
        < -1, 0 >,< 0, 0 >,< 1, 0 >,< 1.25, 0.25 >,< 1.5, 0.5 >,
        < 1.5, 1.75 >,< 0, 1.75 >,< -1, 1.75 >       
                  pigment { color rgbt < 0.3, 0.8, 0.1, 0.3 > }
                  finish { ambient 0.2 }
                   }
#declare Maint =
            lathe {
                  cubic_spline
                  8,
        < -1, 0 >,< 0, 0 >,< 1, 0 >,< 1.25, 0.25 >,< 1.5, 0.5 >,
        < 1.5, 1.25 >,< 0, 1.25 >,< -1, 1.25 >       
                  pigment { color rgbt < 0.6, 0.6, 0.8, 0.3 > }
                  finish { ambient 0.2 }
                   }
#declare Dope =
            lathe {
                  cubic_spline
                  8,
        < -1, 0 >,< 0, 0 >,< 1, 0 >,< 1.25, 0.25 >,< 1.5, 0.5 >,
        < 1.5, 2.25 >,< 0, 2.25 >,< -1, 2.25 >       
                  pigment { color rgbt < 1.0, 0.4, 0.2, 0.6 > }
                  finish { ambient 0.2 }
                   }

#declare Kork =
              texture {
                  pigment {
                       bozo
                       turbulence 0.8
                       color_map {
                                  [ 0.0, 0.8 color rgb < 0.9, 0.7, 0.5 > 
                                             color rgb < 0.98, 0.8, 0.6 > ]
                                  [ 0.8, 1.0 color rgb < 0.6, 0.3, 0.2 > 
                                             color rgb < 0.7, 0.6, 0.2 > ]
                                  }
                            scale 0.3
                          }
                    finish { ambient 0.2 }
                        }
#declare Stopper =
                cone { < 0, 3.5, 0 >,0.9 < 0, 4.5, 0 >,1.1
                      texture { Kork }
                     }

#declare First =
            union {
                  object { Jar }
                  object { Paint }
                  object { Stopper }
                  }
#declare Second =
            union {
                  object { Jar }
                  object { Baint }
                  object { Stopper }
                  }
#declare Third =
            union {
                  object { Jar }
                  object { Maint }
                  object { Stopper }
                  }
#declare Forth =
            union {
                  object { Jar }
                  object { Dope }
                  object { Stopper }
                  }



object { First scale 0.25 translate < -4, -0.375, 5 > }
object { Second scale 0.25 translate < -2.6, -0.375, 4 > }  
object { Third scale 0.25 translate < 1, -0.375, -4 > }  
object { Forth scale 0.25 translate < -7, -0.375, -7.5 > } 

#declare Brush =
             union { 
                   cone { < 0.75, 0, 0 >,0.1 < 1.25, 0, 0 >,0.08
                        texture { T_Chrome_1D }
                        }
                   sphere { < 0, 0, 0 >,0.3  scale < 1, 0.3, 0.2 >
                            translate 1.42*x
                            pigment { color rgb < 0.2, 0.2, 0.1 > }
                            finish { ambient 0.1 }
                          }
                   cone { < 0, 0, 0 >,0.2 < -3.5, 0, 0 >,0.01 }
                   sphere { < 0, 0, 0 >,1  scale < 1, 0.2, 0.2 > }
                            pigment { color rgb < 0.6, 0.55, 0.3 > }
                            finish { ambient 0.2 }
                   rotate 3*z
                   }
object { Brush rotate 40*y translate < -1, -0.3, -4.6 > }
object { Brush  rotate  -75*y   translate < -3.3, -0.3, 4.5 > }
object { Brush  rotate  35*y   translate < -5, -0.3, 4 > }   
#declare Sand =
               cylinder { < 0, 0, 0 >,< 0, 0, 6 >,5 open
                          clipped_by {
                                box { < -6, -2, -1 >,< 6, -6, 7 > }
                                     }
                          scale < 1, 0.3, 1 >
                          pigment { color rgb < 0.6, 0.5, 0.4 > }
                          normal { bumps 0.8 scale 0.00025 }
                          finish { ambient 0.2 }
                       }
object { Sand scale 0.5 rotate 85*y translate < 8, 0.4, 8 > }
