#declare p_Wood_Grain_1 =
pigment {
    wood
    turbulence 0.02
    scale 0.1
    translate <10, 0, 0>
}

#declare m_Wood_Blue =
color_map {
    [0.00, 0.10 color rgb <0.05, 0.05, 0.70>
                color rgb <0.05, 0.05, 0.72>]
    [0.10, 0.92 color rgb <0.05, 0.05, 0.80>
                color rgb <0.05, 0.05, 0.85>]
    [0.92, 1.00 color rgb <0.05, 0.05, 0.52>
                color rgb <0.05, 0.05, 0.56>]
}

#declare m_Wood_Red =
color_map {
    [0.00, 0.10 color rgb <0.70, 0.00, 0.00>
                color rgb <0.72, 0.00, 0.00>]
    [0.10, 0.92 color rgb <0.80, 0.00, 0.00>
                color rgb <0.85, 0.00, 0.00>]
    [0.92, 1.00 color rgb <0.52, 0.00, 0.00>
                color rgb <0.56, 0.00, 0.00>]
}

#declare m_Wood_Green =
color_map {
    [0.00, 0.10 color rgb <0.00, 0.70, 0.00>
                color rgb <0.00, 0.72, 0.00>]
    [0.10, 0.92 color rgb <0.00, 0.80, 0.00>
                color rgb <0.00, 0.85, 0.00>]
    [0.92, 1.00 color rgb <0.00, 0.52, 0.00>
                color rgb <0.00, 0.56, 0.00>]
}

#declare m_Wood_Yellow =
color_map {
    [0.00, 0.10 color rgb <0.70, 0.70, 0.00>
                color rgb <0.72, 0.72, 0.00>]
    [0.10, 0.92 color rgb <0.80, 0.80, 0.00>
                color rgb <0.85, 0.85, 0.00>]
    [0.92, 1.00 color rgb <0.52, 0.52, 0.00>
                color rgb <0.56, 0.56, 0.00>]
}

#declare t_Wood_Blue =
texture {
	pigment{ p_Wood_Grain_1 color_map { m_Wood_Blue } }
	 finish {
    	ambient .2
        diffuse .6
        phong .15
        phong_size 15
    }
}

#declare t_Wood_Red =
texture {
	pigment{ p_Wood_Grain_1 color_map { m_Wood_Red } }
	 finish {
    	ambient .2
        diffuse .6
        phong .15
        phong_size 15
    }
}

#declare t_Wood_Green =
texture {
	pigment{ p_Wood_Grain_1 color_map { m_Wood_Green } }
	 finish {
    	ambient .2
        diffuse .6
        phong .15
        phong_size 15
    }
}

#declare t_Wood_Yellow =
texture {
	pigment{ p_Wood_Grain_1 color_map { m_Wood_Yellow } }
	 finish {
    	ambient .2
        diffuse .6
        phong .15
        phong_size 15
    }
}

#declare R = seed(123)

#declare Tinker_Rod_Blue =
object {
	#if (d_Tinker = 2)
		difference {
			cylinder { <-2.75,0,0><2.75,0,0> 0.10 }
		 	box { <-2.8,-0.035,-0.15><-2.45,0.035,0.15> }
		 	box { < 2.8,-0.035,-0.15>< 2.45,0.035,0.15> }
		}
		texture { t_Wood_Blue scale 1.5 rotate 80*y }
	#else
		cylinder { <-2.75,0,0><2.75,0,0> 0.10 }
		texture { pigment { color Blue } }
	#end
	translate 2.75*x
}

#declare Tinker_Rod_Red =
object {
	#if (d_Tinker = 2)
		difference {
			cylinder { <-2.25,0,0><2.25,0,0> 0.10 }
		 	box { <-2.3,-0.035,-0.15><-1.95,0.035,0.15> }
		 	box { < 2.3,-0.035,-0.15>< 1.95,0.035,0.15> }
		}
		texture { t_Wood_Red scale 1.5 rotate 80*y }
	#else
		cylinder { <-2.25,0,0><2.25,0,0> 0.10 }
		texture { pigment { color Red } }
	#end
	translate 2.25*x
}

#declare Tinker_Rod_Green =
object {
	#if (d_Tinker = 2)
		difference {
			cylinder { <-3.50,0,0><3.50,0,0> 0.10 }
		 	box { <-3.6,-0.035,-0.15><-3.20,0.035,0.15> }
		 	box { < 3.6,-0.035,-0.15>< 3.20,0.035,0.15> }
		}
		texture { t_Wood_Green scale 1.5 rotate 80*y }
	#else
		cylinder { <-3.50,0,0><3.50,0,0> 0.10 }
		texture { pigment { color Green } }
	#end
	translate 3.50*x
}

#declare Tinker_Rod_Yellow =
object {
	#if (d_Tinker = 2)
		difference {
			cylinder { <-2.20,0,0><2.20,0,0> 0.10 }
		 	box { <-2.30,-0.035,-0.15><-1.90,0.035,0.15> }
		 	box { < 2.30,-0.035,-0.15>< 1.90,0.035,0.15> }
		}
		texture { t_Wood_Yellow scale 1.5 rotate 80*y }
	#else
		cylinder { <-2.20,0,0><2.20,0,0> 0.10 }
		texture { pigment { color Yellow } }
	#end
	translate 2.00*x
}

#declare Tinker_Wheel_1 =
object {
#if (d_Tinker = 2)
	intersection {
		difference {
			cylinder { <0,-0.23,0><0,0.23,0> 0.70 }
			// center hole
			cylinder { <0,-0.24,0><0,0.24,0> 0.10 }
			// spoke holes
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 45*y }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 90*y }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 135*y }
		}
		// round off the edges of the disk
		sphere { <0,0,0> 0.73 scale <1,0.67,1> }
	}
	texture { T_Wood1 scale 13 translate <4,0,0> rotate <80,30,120> }
#else
	cylinder { <0,-0.23,0><0,0.23,0> 0.70 texture { pigment { color Tan } } }
#end
}

#declare Tinker_Wheel_2 =
object {
#if (d_Tinker = 2)
	intersection {
		difference {
			cylinder { <0,-0.23,0><0,0.23,0> 0.70 }
			// center hole
			cylinder { <0,-0.24,0><0,0.24,0> 0.10 }
			// spoke holes
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 45*y }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 90*y }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 135*y }
		}
		// round off the edges of the disk
		sphere { <0,0,0> 0.73 scale <1,0.67,1> }
	}
	texture { T_Wood1 scale 9 translate <7,0,0> rotate <85,20,140> }
#else
	cylinder { <0,-0.23,0><0,0.23,0> 0.70 texture { pigment { color Tan } } }
#end
}

#declare Tinker_Wheel_3 =
object {
#if (d_Tinker = 2)
	intersection {
		difference {
			cylinder { <0,-0.23,0><0,0.23,0> 0.70 }
			// center hole
			cylinder { <0,-0.24,0><0,0.24,0> 0.10 }
			// spoke holes
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 45*y }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 90*y }
			cylinder { <0,0,-0.8><0,0,0.8> 0.10 rotate 135*y }
		}
		// round off the edges of the disk
		sphere { <0,0,0> 0.73 scale <1,0.67,1> }
	}
	texture { T_Wood1 scale 2.5 translate <4,2,0> rotate <86,8,17> }
#else
	cylinder { <0,-0.23,0><0,0.23,0> 0.70 texture { pigment { color Tan } } }
#end
}

#declare Tinker_House =
union {
	// house
	// base
	object { Tinker_Wheel_1 rotate 90*y translate <-3.6,0,0> }
	object { Tinker_Wheel_2 rotate 90*y translate <3.6,0,0> }
	object { Tinker_Wheel_3 rotate 90*y translate <-3.6,0,4.7> }
	object { Tinker_Wheel_1 rotate -90*y translate <3.6,0,4.7> }
	object { Tinker_Rod_Green rotate 10*x translate <-3.5,0,0> }
	object { Tinker_Rod_Green rotate 40*x translate <-3.5,0,4.7> }
	object { Tinker_Rod_Red rotate 100*x rotate 90*y translate <-3.6,0,4.7> }
	object { Tinker_Rod_Red rotate 160*x rotate 90*y translate <3.6,0,4.7> }
	// upper frame
	object { Tinker_Wheel_1 rotate 90*x rotate 45*z translate <-3.6,5.5,0> }
	object { Tinker_Wheel_2 rotate 90*x rotate 135*z translate <3.6,5.5,0> }
	object { Tinker_Wheel_3 rotate -90*x rotate 90*z translate <-3.6,5.5,4.7> }
	object { Tinker_Wheel_1 rotate -90*x rotate 270*z translate <3.6,5.5,4.7> }
	object { Tinker_Rod_Green rotate 10*x translate <-3.5,5.5,0> }
	object { Tinker_Rod_Green rotate 40*x translate <-3.5,5.5,4.7> }
	object { Tinker_Rod_Red rotate 100*x rotate 90*y translate <-3.6,5.5,4.7> }
	object { Tinker_Rod_Red rotate 160*x rotate 90*y translate <3.6,5.5,4.7> }
	// vertical supports
	object { Tinker_Rod_Blue rotate 10*x rotate 90*z translate <-3.6,-0.15,0> }
	object { Tinker_Rod_Blue rotate 10*x rotate 90*z translate <3.6,-0.15,0> }
	object { Tinker_Rod_Blue rotate 10*x rotate 90*z translate <-3.6,-0.15,4.7> }
	object { Tinker_Rod_Blue rotate 10*x rotate 90*z translate <3.6,-0.15,4.7> }
	// roof
	object { Tinker_Wheel_3 rotate 90*x rotate 45*z translate <0,8.8,0> }
	object { Tinker_Wheel_2 rotate 90*x rotate 235*z translate <0,8.8,4.7> }
	object { Tinker_Rod_Yellow rotate 35*x rotate 45*z translate <-3.3,5.6,0> }
	object { Tinker_Rod_Yellow rotate 135*x rotate 135*z translate <3.3,5.6,0> }
	object { Tinker_Rod_Yellow rotate 85*x rotate 45*z translate <-3.3,5.6,4.7> }
	object { Tinker_Rod_Yellow rotate 335*x rotate 135*z translate <3.3,5.6,4.7> }
	object { Tinker_Rod_Red rotate 260*x rotate 90*y translate <0,8.9,4.7> }
	translate <0,0.23,-2.35>
}	
