#declare Trap_Point =
union {
	box { <-0.1,-0.1,-0.05><0.1,0.1,0.05> rotate 45*z scale <0.5,1,1>
		clipped_by { plane {-y,0} }
		clipped_by { plane {y,0.08} }
	}
	cylinder { <0,0.070,-0.05><0,0.070,0.05> 0.037 scale <0.85,1,1> }
	scale <1.2,1.3,1>
}

#declare Trap_Post =
#if (d_Trap = 2)
union {
	// long straight
	box { <0,-0.15,-0.03><7.3,0.15,0.03> }
	cylinder { <0,0,0><1.0,0,0> 0.06 scale <1,1,1.8> }
	cylinder { <1.0,0,0><1.15,0,0> 0.06 scale <1,1,1.8>
		clipped_by { plane {-z,0}  } }
	box { <1.00,-0.05,-0.08><6.3,0.05,0> }
	cylinder { <6.5,0><7.3,0,0> 0.06 scale <1,1,1.8> }
	cylinder { <6.3,0,0><6.5,0,0> 0.06 scale <1,1,1.8>
		clipped_by { plane {z,0}  } }
	box { <1.00,-0.05,0.08><6.5,0.05,0> }
	// small tab at end of bar
	box { <-0.30,-0.15,-0.03><0.0,0.03,0.03> }
	// curve #1
	difference {
		cylinder { <0,0,-0.03><0,0,0.03> 0.45 }
		cylinder { <0,0,-0.035><0,0,0.035> 0.15 }
		clipped_by { plane {-x,0} }
		clipped_by { box {<0.0,-1.0,-0.035><1.0,0.0,0.035> } rotate -30*z translate 0.00*y }
		translate <7.3,0.30,0>
	}
	torus { 0.30, 0.06 rotate 90*x scale <1,1,1.8>
		clipped_by { plane {-x,0} }
		clipped_by { box {<0.0,-1.0,-0.55><1.0,0.0,0.55> } rotate -30*z translate 0.00*y }
		translate <7.3,0.30,0>
	}
	// small straight between curves
	box { <0,-0.15,-0.03><0.6,0.15,0.03> rotate 60*z translate <7.553,0.14,0> }
	cylinder { <0,0,0><0.6,0,0> 0.06 scale <1,1,1.8> rotate 60*z translate <7.553,0.14,0> }
	// curve #2
	difference {
		cylinder { <0,0,-0.03><0,0,0.03> 0.45 }
		cylinder { <0,0,-0.035><0,0,0.035> 0.15 }
		clipped_by { plane {x,0} }
		clipped_by { box {<-1.0,0.0,-0.035><0.0,1.0,0.035> } rotate  -30*z translate 0.0*y }
		translate <8.107,0.50,0>
	}
	torus { 0.30, 0.06 rotate 90*x scale <1,1,1.8>
		clipped_by { plane {x,0} }
		clipped_by { box {<-1.0,0.0,-0.55><0.0,1.0,0.55> } rotate  -30*z translate 0.0*y }
		translate <8.107,0.50,0>
	}
	// small straight
	box { <0,-0.15,-0.03><1.0,0.15,0.03> translate <8.10,0.80,0> }
	cylinder { <0,0,0><1.0,0,0> 0.06 scale <1,1,1.8> translate <8.10,0.80,0> }
	// cap on top
	difference {
		cylinder { <-0.05,0,0><0.05,0,0> 0.16 }
		box { <-0.06,-1,0><0.06,0,1> }
		translate <9.1,0.80,0>
	}
	// tabs near top
	box { <0,0,-0.028><0.1,0.1,0.028> translate <8.2,0.6,0> }
	box { <0,0,-0.028><0.1,0.1,0.028> rotate 90*x translate <8.2,0.8,0.05> }
	box { <0,0,0><0.06,0.14,0.11> translate <8.11,0.8,0.0> }

	// points
	#declare x_offset = 1.3
	#while (x_offset < 6.3)
		object { Trap_Point rotate -90*x translate<x_offset,0,-0.08> }
		#declare x_offset = x_offset + 0.31
	#end
	#declare x_offset = 1.115
	#while (x_offset < 6.3)
		object { Trap_Point rotate 90*x translate<x_offset,0,0.08> }
		#declare x_offset = x_offset + 0.31
	#end
	texture {
		pigment { color Yellow }
		finish { phong 0.8 phong_size 20 }
	}
}
#else
union {
	cylinder { <0,0,0><7.3,0,0> 0.15 }
	cylinder { <0,0,0><1.0,0,0> 0.15 translate <8.10,0.80,0> }
	pigment { color Yellow }
}
#end

#declare Trap_Cage_Bar =
union {
	box { <0,-0.02,-0.1><2.0,0.02,0.1> }
	difference {
		cylinder { <2.0,-0.38,-0.1><2.0,-0.38,0.1> 0.4 }
		cylinder { <2.0,-0.38,-0.11><2.0,-0.38,0.11> 0.36 }
		clipped_by { plane { -x,-2.0} }
		clipped_by { plane {-y, 0.20} }
	}
	scale <0.9,1,1>
}

#declare Trap_Cage =
#if (d_Trap = 2)
union {
	// rings at top
	difference
	{
		union {
			cylinder { <0,-0.04,0><0,0,0> 0.65 }
			cylinder { <0,-0.04,0><0,0.02,0> 0.59 }
		}
		cylinder { <0,-0.05,0><0,0.1,0> 0.25 }
	}
	// bars
	#declare ang = 0
	#while (ang < 316)
		object { Trap_Cage_Bar
					translate -2.16*x
					rotate -90*x
					rotate 90*z
					rotate 22*x
					translate <0,0.115,-0.75>
					rotate ang*y
		}
		#declare ang = ang + 45
	#end
	// little ring
	difference  {
		intersection {
			sphere { <0,0,0> 1 }
			box { <-2,0.35,-2><2,0.45,2> }
		}
		intersection {
			sphere { <0,0,0> 0.95 }
			box { <-2,0.34,-2><2,0.46,2> }
		}
		scale 1.32
		translate <0,-1.59,0>
	}
	// big ring
	difference  {
		intersection {
			sphere { <0,0,0> 1 }
			box { <-2,0.35,-2><2,0.45,2> }
		}
		intersection {
			sphere { <0,0,0> 0.95 }
			box { <-2,0.34,-2><2,0.46,2> }
		}
		scale 1.80
		translate <0,-2.65,0>
	}
	difference {
		cylinder { <0,-0.03,0><0,0,0> 1.76 }
		cylinder { <0,-0.04,0><0,0.1,0> 1.61 }
		translate -2.0*y
	}
	scale <0.86,1,1>
	texture {
		pigment { color Red }
		finish { phong 0.8 phong_size 20 }
	}
}
#else
sphere { <0,0,0> 2
	clipped_by { plane {-y,0} }
	scale <0.8,1,0.8>
	translate -2*y
	pigment { color Red }
}
#end

#declare Trap =
union {
	object { Trap_Post
		 rotate -80*x
		 rotate 2.3*z
		 rotate -13*y
		 translate <-4,0.15,4.42>
	}
	object { Trap_Cage rotate -112.5*z translate <4.3,0.63,5.5> }
}

