
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.02
// Desc: "CADILLAC'59" MODEL KIT REAR BUMPER
// Date: 30.12.1997
// Auth: (c) N.B. 1997

#declare R_Bump_Prt02 =
intersection{
   union{
      #declare No_Rows01 = 3
      #declare No_Clms01 = 8
      #declare Dist_br01 = (9-4.3)/(No_Rows01+1)
      #declare Dist_bc01 = 27.5/(No_Clms01+1)
      #declare Dist_Cr01 = 4.7*tan(atan2(6,29))
      #declare Ang_Cr01 = degrees(atan2(6,29))*SIDE
      #while ( No_Rows01 > 0)
          cylinder{ <0,-.5*SIDE,0><0,32*SIDE,0>.4
             scale <1.5,1,1>
             translate x*-2
             translate < 0,0,-9+Dist_br01*No_Rows01>
          }
          #while ( No_Clms01 > 0)
             cylinder{<2,0,0><0,0,0>0.4
                rotate z*-Ang_Cr01
                translate < -2.5,(Dist_bc01*No_Clms01 + Dist_Cr01)*SIDE,-9+Dist_br01*No_Rows01>
             }
             #if (No_Rows01 = 1)
                box{<1,-.3,-4.3><0,.3,-9>
                   rotate z*-Ang_Cr01
                   translate < -2.5,(Dist_bc01*No_Clms01 + Dist_Cr01)*SIDE,0>
                }
             #end
             #declare No_Clms01 = No_Clms01-1
          #end
          #declare No_Clms01 = 8
          #declare No_Rows01 = No_Rows01-1
      #end
      intersection{
         prism { linear_sweep cubic_spline 32*SIDE, -.5*SIDE, 6,
            < -5, .5>, < -2, .4>, < 2.2, -1.3>, < -4.3,  -6.5>, < -2, .4>, < -2,  1>
         }
         box{<-2,-.45*SIDE,0><5,30*SIDE,-4.3>}
         translate x*-.5
      }
      intersection{
         prism { linear_sweep cubic_spline 32*SIDE, -.5*SIDE, 8,
            < -5, -.1>, < -2, 0>, < 2.8, -.4>, < 1.7,  -3>,< -0.1,  -7.9>,//< -.5,  -8>,
            < -7,  -6>,< -2, 0>, < -2,  1>
         }
         box{<-2,-.45*SIDE,0><5,30*SIDE,-8>}
         translate <-1,0,-9>
      }
      box{<-3,-.45*SIDE,-9.5><-2.5,30*SIDE,-4>}
      translate x*-2.2
      rotate x*-90
      rotate y*90
      rotate y*Ang_Cr01
      }
   box{<-26*SIDE,-20,-10><0,5,20>}
}

// density = strength * (1 - radius^2)^2
// sphere { <CENTER>, RADIUS, [ strength ] STRENGTH }
// density = threshold ?
// radius = 1; radius # RADIUS; RADIUS = radius * k; k - integer

// threshold
#declare BLOB_DENS01 = .5

// strength
#declare BLOB_STRN01 = .7

// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

#declare R_Bump_Prt01=
blob{ threshold BLOB_DENS01
   cylinder{<0,-1,0><0,1,0> 1/BLOB_A_R01, BLOB_STRN01 scale <1,.7,1.05>*.92}
   cylinder{<-1,0,0><1,0,0> 1/BLOB_A_R01, BLOB_STRN01 scale <.7,1,1.05>*.92}

#declare BLOB_STRN01 = 2
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   cylinder{<0,-2,0><0,2,0> .8/BLOB_A_R01, BLOB_STRN01 scale <.65,1,1.1>}

#declare BLOB_STRN01 = 2
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   cylinder{<0,-3,0><0,3,0> 1/BLOB_A_R01, BLOB_STRN01 scale <3,1,1.05>
      rotate x*-5
      translate <0,0,1>
   }

#declare BLOB_STRN01 = -3
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   cylinder{<0,-1,0><0,1,0> 1/BLOB_A_R01, BLOB_STRN01 scale <1,.6,2>*.72 translate z*-1}
   cylinder{<-1,0,0><1,0,0> 1/BLOB_A_R01, BLOB_STRN01 scale <.6,1,2>*.72 translate z*-1}

#declare BLOB_STRN01 = -1
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   sphere{0, 1/BLOB_A_R01, BLOB_STRN01 scale<5,5,.1> translate z*-1.4}
   scale <1,1,1.5>
}

#declare R_Bump_Prt03 =
difference{
   union{
      object{R_Bump_Prt01}
      superellipsoid{<.8,.2>
         scale 1
         translate z*-.3
         texture {T_Chrome_4D
            finish { reflection .1 ambient .2}
            pigment{color rgb <1,0,0>}
         }
      }
      superellipsoid{<.8,.2>
         scale .6
         translate z*-.73
      }
      #declare Tube_Thk01 = 0.1
      #declare X_Dist01 = .7
      #declare Z_Dist01 = .7
      #declare Bend_Rad01 = .4
      #include "q_torus.inc"
      object{ TUBE01
         scale <1,2,1>
         rotate x*-90
         translate z*-1.3
      }
      prism {
         conic_sweep
         linear_spline
         1, 0, 5,
         < 0, .5>, < 4,  2>, < 0, -.5>, < -4,  2>, < 0, .5>
         scale .2
         rotate z*180
         rotate x*-90
         translate <0,-.1,-1.7>
      }
   }
   box{<-5*SIDE,-5,-.7><0*SIDE,5,5>}
   box{<1.57*SIDE,-5,-5><5*SIDE,5,5>}
   box{<-5*SIDE,1.5,-5><5*SIDE,5,5>}
   box{<-5*SIDE,-2.75,-5><5*SIDE,-5,5>}
   box{<-5*SIDE,-5,1><5*SIDE,5,5>}

   translate <-1.57*SIDE,-1.5,0>
   scale 12/3
   texture {T_Chrome_4D}
}
