
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3
// Desc: "Single-blob" toy dinosaur, part01
// Date: 02.12.97
// Auth: (c) N.B. 1997

// requires part02: "din02.inc" (leg)

#declare DIN_TEX01=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 10
   }
   normal {quilted .5 turbulence .8 scale .3}
   pigment{quilted turbulence .8 scale .3
      pigment_map{
         [0 color rgb <.7,.6,.7>]
         [1 color rgb <0,.5,1>*.4]
      }
   }
}

#declare DIN_TEX02=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 10
   }
   normal {quilted .5 turbulence .8 scale <.3,1,.3>}
   pigment{quilted turbulence .8 scale <.3,1,.3>
      pigment_map{
         [0 color rgb <1,.5,0>]
         [1 color rgb <.3,0,0>]
      }
   }
}

// density = strength * (1 - radius^2)^2
// sphere { <CENTER>, RADIUS, [ strength ] STRENGTH }
// density = threshold ?
// radius = 1; radius # RADIUS; RADIUS = radius * k; k - integer

// threshold
#declare BLOB_DENS01 = .5

// strength
#declare BLOB_STRN01 = .65

// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )


#declare DIN01=
blob{ threshold BLOB_DENS01

#declare Total_Length = 12
#declare Tail_Length = 2
#declare Body_Length = Total_Length - Tail_Length

#declare Curv01 = 1
#declare Curv02 = .8
#declare Curv03 = .2
#declare Min_Rad = .9
#declare Max_Rad = .8

#declare XX1 = 0
#declare YY1 = 0
#declare ZZ1 = 0
//#declare R01= Min_Rad
#declare R02=0
#declare NW01 = 1
#declare NS01 = 48
#declare KOUNT0 = NS01*NW01
#declare dX = Body_Length/KOUNT0
#declare ANG = -pi/2
#declare dANG = 2*pi/NS01
#declare ANG_S = -pi/2
#declare dANG_S = 2*pi/NS01
#declare dRad = (Max_Rad - Min_Rad)/KOUNT0
#declare KOUNT1 = KOUNT0


// head:

#declare BLOB_STRN01 = .57
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
#declare YY1=sin(ANG)*Curv01
   sphere{0,.9/BLOB_A_R01, BLOB_STRN01 scale <1.3,1,1.2> translate <-.7,YY1,0>}
   sphere{0,1/BLOB_A_R01, BLOB_STRN01 scale <.3,.2,.3> translate <-1,YY1-.1,0>}
   sphere{0,1/BLOB_A_R01, BLOB_STRN01 scale <.25,.2,.2> rotate z*15 translate <-1.1,YY1+.4,0>}
   sphere{0,.5/BLOB_A_R01, BLOB_STRN01 scale <.3,.3,.25> translate <-.8,YY1+.7,-.3>}
   sphere{0,.5/BLOB_A_R01, BLOB_STRN01 scale <.3,.3,.25> translate <-.8,YY1+.7,.3>}

   sphere{0,.2/BLOB_A_R01, BLOB_STRN01 scale <.3,.3,.25> translate <-.86,YY1+.7,-.7>
   }
   sphere{0,.2/BLOB_A_R01, BLOB_STRN01 scale <.3,.3,.25> translate <-.86,YY1+.7,.7>
   }

#declare BLOB_STRN01 = -1
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   sphere{0,1/BLOB_A_R01, BLOB_STRN01 scale <.5,.15,1> translate <-2,YY1-.2,0>}
#declare BLOB_STRN01 = -.6
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   sphere{0,.3/BLOB_A_R01, BLOB_STRN01 scale <.3,.3,.25> translate <-.86,YY1+.7,-.7>}
   sphere{0,.3/BLOB_A_R01, BLOB_STRN01 scale <.3,.3,.25> translate <-.86,YY1+.7,.7>}


// body:

#declare BLOB_STRN01 = .65
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

#while (KOUNT1>=0)
   #declare YY1=sin(ANG)*Curv01
   //#declare ZZ1=cos(ANG)*Curv01
   #declare R01=1.2+(sin(ANG_S)*Curv02)+R02
   sphere{0,R01/BLOB_A_R01, BLOB_STRN01 scale <(.2/R01),1,1> translate <XX1,YY1,ZZ1>}
   #declare XX1=XX1+dX
   #declare ANG=ANG+dANG
   #declare ANG_S=ANG_S+dANG_S
   #declare R02=R02+dRad
   #declare KOUNT1=KOUNT1-1
#end

#declare NW01 = .4
#declare NS01 = 36
#declare KOUNT0 = NS01*NW01
#declare dX = Tail_Length/KOUNT0
#declare KOUNT1 = KOUNT0
#while (KOUNT1>=0)
   #declare YY1=sin(ANG)*Curv01
   #declare ZZ1=cos(ANG)*Curv03
   sphere{0,R01/BLOB_A_R01, BLOB_STRN01 scale <(.2/R01),1,1> translate <XX1,YY1,ZZ1>}
   #declare XX1=XX1+dX
   #declare ANG=ANG+dANG
   #declare ANG_S=ANG_S+dANG_S
   #declare R01=R01*.92
   #declare KOUNT1=KOUNT1-1
#end

// front left leg:
#declare Prt01_Ang = 115
#declare Prt02_Ang = -43
#declare Prt03_Ang = -60
#declare Leg01_Scl = .6
#declare Leg01_Trm = <2.7,-.9,-2>
#declare Leg01_Ang = 5
#declare Side = 1
#include "din02.inc"

// front right leg:
#declare Prt01_Ang = 117
#declare Prt02_Ang = -40
#declare Prt03_Ang = -62
#declare Leg01_Trm = <2.7,-.9,2>
#declare Leg01_Ang = -4
#declare Side = -1
#include "din02.inc"

// rear left leg:
#declare Prt01_Ang = 63
#declare Prt02_Ang = 48
#declare Prt03_Ang = -93
#declare Leg01_Scl = .8
#declare Leg01_Trm = <6.2,.1,-3.3>
#declare Leg01_Ang = -7
#declare Side = 1
#include "din02.inc"

// rear right leg:
#declare Prt01_Ang = 70
#declare Prt02_Ang = 53
#declare Prt03_Ang = -104
#declare Leg01_Scl = .8
#declare Leg01_Trm = <6.2,.1,3.3>
#declare Leg01_Ang = 10
#declare Side = -1
#include "din02.inc"

texture {DIN_TEX01}
translate x*-(Total_Length/2)
translate y*4.6
scale <1.5,1,1>
}

// needle:
#declare NDL01=
superellipsoid{<.8,1.5>
   rotate z*45
   rotate x*90
   translate y*1
   scale <.15,2,.15>
   texture {DIN_TEX02}
}
#declare NDLS=
union{
   object{NDL01 rotate <-30,0,15>}
   object{NDL01 rotate <30,0,15>}
   object{NDL01 rotate <-30,0,-15>}
   object{NDL01 rotate <30,0,-15>}
   translate <XX1-dX,YY1,ZZ1>
   translate x*-(Total_Length/2)
   translate y*4.6
   scale <1.5,1,1>
}


// spine:
#declare Total_Length = 12
#declare Tail_Length = 2
#declare Body_Length = Total_Length - Tail_Length

#declare Curv01 = 1
#declare Curv02 = .8
#declare Curv03 = .2
#declare Min_Rad = .9
#declare Max_Rad = .8

#declare XX1 = 0
#declare YY1 = 0
#declare ZZ1 = 0
//#declare R01= Min_Rad
#declare R02=0
#declare NW01 = 1
#declare NS01 = 12
#declare KOUNT0 = NS01*NW01
#declare dX = Body_Length/KOUNT0
#declare ANG = -pi/2
#declare dANG = 2*pi/NS01
#declare ANG_S = -pi/2
#declare dANG_S = 2*pi/NS01
#declare dRad = (Max_Rad - Min_Rad)/KOUNT0
#declare KOUNT1 = KOUNT0


#declare DIN02=
union{
#while (KOUNT1>=0)
   #declare YY1=sin(ANG)*Curv01
   //#declare ZZ1=cos(ANG)*Curv01
   #declare R01=1.2+(sin(ANG_S)*Curv02)+R02
   
   superellipsoid{<0.2,1.2> rotate z*45 scale <1,1,.2> texture {DIN_TEX02}
      translate y*R01
      scale <.5,1,1>*R01/2
      rotate z*degrees(abs (90-ANG))/2
      rotate x*-30
      translate <XX1-.2,YY1,ZZ1>
    }
   superellipsoid{<0.2,1.2> rotate z*45 scale <1,1,.2> texture {DIN_TEX02}
      translate y*R01
      scale <.5,1,1>*R01/2
      rotate z*degrees(abs (90-ANG))/2
      rotate x*30
      translate <XX1+.2,YY1,ZZ1>
   }
   #declare XX1=XX1+dX
   #declare ANG=ANG+dANG
   #declare ANG_S=ANG_S+dANG_S
   #declare R02=R02+dRad
   #declare KOUNT1=KOUNT1-1
#end

translate x*-(Total_Length/2)
scale <1,1.5,1>
translate y*5.3
scale <1.5,1,1>
scale 1
}

#declare DIN00=
union{
   object{DIN01}
   object{DIN02}
   object{NDLS}
}

//object{DIN00 scale 5 translate <115,6,-128>}
