
// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.02
// Desc: "CADILAC'59" MODEL KIT FRONt END
// Date: 30.12.1997
// Auth: (c) N.B. 1997

#declare BLOB_DENS01 = .5
#declare BLOB_STRN01 = 2
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

#declare FRONT_LAMP01=
intersection{
   union{
      difference{
         blob{ threshold BLOB_DENS01
            cylinder {<0,0,0><0,0,3> 1/BLOB_A_R01, BLOB_STRN01
               scale <10,1,5>
               translate x*-1*SIDE
            }
            cylinder {<0,0,0><0,0,3> 4.5/BLOB_A_R01, BLOB_STRN01
               scale <1,1,.7>
               translate <4.5*SIDE,-4.5,-.5>
            }
            cylinder {<0,0,0><0,0,3> 5/BLOB_A_R01, BLOB_STRN01
               scale <1,1,1>
               translate <-4*SIDE,-1,-.5>
            }

            #declare BLOB_STRN01 = -2
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder {<0,0,0><0,0,-3> 2.8/BLOB_A_R01, BLOB_STRN01
               scale <1,1,.7>
               translate <4.5*SIDE,-4.5,-2>
            }
          }
          cylinder {<0,0,0><0,0,-3> 3.4
             translate <4.5*SIDE,-4.5,-1.5>
          }
          sphere {<0,0,0> 3.4
             scale <1,1,.45>
             translate <4.5*SIDE,-4.5,-1.5>
          }
      }
      sphere {0, 3.4
         scale <1,1,.3>
         translate <4.5*SIDE,-4.5,-1.5>
         // texture{DEF_TEX pigment{color rgb<1,.5,0,>}}
      }
   }
   box{<0,0,-7><12*SIDE,-10,1>}
}

#declare FRONT_BUMP01=
union{
   intersection{
      superellipsoid {<.7,.6>
         rotate z*90
         translate z*1
         scale <12,1.5,11>
         translate x*-3*SIDE
      }
      box{<0,-3,-10><10*SIDE,3,11>}
      translate z*-5
   }
   intersection{
      superellipsoid {<.7,.1>
         rotate z*90
         translate z*1
         scale <12,1.5,11>
         translate x*-3*SIDE
      }
      box{<0,-3,11><10*SIDE,3,25>}
      translate z*-5
   }
}

#declare FRONT_BUMP02=
union{
   union{
      intersection{
         #declare BLOB_DENS01 = .5
         #declare BLOB_STRN01 = 1
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         blob{ threshold BLOB_DENS01
            sphere {0 1/BLOB_A_R01, BLOB_STRN01
               scale <3.5,3.5,15>
               translate <2.5*SIDE1,0,16>
            }
            cylinder{<0,0,0><0,0,16>4/BLOB_A_R01, BLOB_STRN01
               translate <3.5*SIDE1,0,0>
            }
            sphere {0 1/BLOB_A_R01, BLOB_STRN01
               scale <3.5,3.5,15>
               translate <-2.5*SIDE1,0,16>
            }
            cylinder{<0,0,0><0,0,16>4/BLOB_A_R01, BLOB_STRN01
               translate <-3.5*SIDE1,0,0>
            }

            cylinder{<-5*SIDE1,0,0><0,0,0> 2.5/BLOB_A_R01, BLOB_STRN01
               translate <-7*SIDE1,-1.2,3>
            }

            #declare BLOB_STRN01 = 2
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder{<0,0,0><0,0,16>4/BLOB_A_R01, BLOB_STRN01
               scale <.15,1,1>
            }

            #declare BLOB_STRN01 = 1
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder{<0,0,0><0,0,15.5>.5/BLOB_A_R01, BLOB_STRN01
               scale <1.2,1,1>
               rotate y*1.7*SIDE1
               translate <6.7*SIDE1,0,0>
            }

            #declare BLOB_STRN01 = -2
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder{<0,0,0><0,0,-16*1.2> 2/BLOB_A_R01, BLOB_STRN01
               scale <1,1.05,1/1.2>
               rotate y*-3*SIDE1
               translate <3.7*SIDE1,0,0>
            }
            cylinder{<0,0,0><0,0,-16*1.2> 2/BLOB_A_R01, BLOB_STRN01
               scale <1,1.05,1/1.2>
               rotate y*3*SIDE1
               translate <-3.7*SIDE1,0,0>
            }

            #declare BLOB_STRN01 = -1
            #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
            cylinder{<0,0,0><0,0,10> 1/BLOB_A_R01, BLOB_STRN01
               scale <10,10,.2>
               translate <0,0,16>
            }
         }
         box{<-9*SIDE1,-10,-10><10*SIDE1,10,16>}
      }
      sphere {0, 3
         scale <1,1,.3>
         translate z*-1.8
         rotate y*-3*SIDE1
         translate <3.7*SIDE1,0,0>
         // texture{DEF_TEX pigment{color rgb<1,.5,0,>}}
      }
      sphere {0, 3
         scale <1,1,.3>
         translate z*-1.8
         rotate y*3*SIDE1
         translate <-3.7*SIDE1,0,0>
         // texture{DEF_TEX pigment{color rgb<1,.5,0,>}}
      }
      scale <1.1,.8,1>
   }
   box{<-10*SIDE1,-3,3><5*SIDE1,3,15.5> translate y*3.5}
   cylinder{ <0,0,0><0,0,15.5-3>.4
      scale <1.5,1,1>
      translate <5*SIDE1,4.8,3>
   }
   #declare Num = 5
   #declare Dist = (15-3)/Num
   #while ( Num >= 0 )
      box{<5*SIDE1,-3,0><5.7*SIDE1,3,-.5> translate <0,3.5,15.5-Dist*Num>}
      #declare Num = Num - 1
   #end

   translate x*1*SIDE1
}

#declare FRONT_BUMP03 =
intersection{
   union{
      #declare Ang_Cr01 = degrees(atan2(4,21))*SIDE

      #declare No_Rows01 = 3
      #declare No_Clms01 = 8
      #declare Dist_br01 = (9-4.3)/(No_Rows01+1)
      #declare Dist_bc01 = 22/cos(atan2(4,21))/(No_Clms01+1)
      #declare Dist_Cr01 = 4.7*tan(atan2(4,21))

      #declare GRILL01=
      union{
         #while ( No_Rows01 > 0)
          cylinder{ <0,-.5*SIDE,0><0,32*SIDE,0>.4
             scale <1.5,1,1>
             translate x*-2
             translate < 0,0,-9+Dist_br01*No_Rows01>
          }
          #while ( No_Clms01 > 0)
             cylinder{<2,0,0><0,0,0>0.4
                rotate z*-Ang_Cr01
                translate < -2.5,(Dist_bc01*No_Clms01 + Dist_Cr01)*SIDE,-9+Dist_br01*No_Rows01>
             }
             #if (No_Rows01 = 1)
                box{<1,-.3,-4.3><0,.3,-9>
                   rotate z*-Ang_Cr01
                   translate < -2.5,(Dist_bc01*No_Clms01 + Dist_Cr01)*SIDE,0>
                }
             #end
             #declare No_Clms01 = No_Clms01-1
          #end
          #declare No_Clms01 = 8
          #declare No_Rows01 = No_Rows01-1
      #end
      }

      object{GRILL01
         rotate z*90
         rotate x*-90
         translate <0,2.5,1>
      }
      object{GRILL01
         rotate z*90
         rotate x*-90
         translate <0,-4,1>
      }

      box{<-25*SIDE,0,4><.5*SIDE,-2,0>}
      cylinder{<-25*SIDE,0,0><.5*SIDE,0,0> 1 scale <1,1,1.5> translate y*-1}

      box{<-25*SIDE,0,5><.5*SIDE,-2,0> translate <0,-6.5,-1>}
      cylinder{<-25*SIDE,0,0><.5*SIDE,0,0> 1 scale <1,1,1.5> translate <0,-7.5,-1>}

      #declare BLOB_DENS01 = .5
      #declare BLOB_STRN01 = 1
      #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
      blob{ threshold BLOB_DENS01
         cylinder{<-25*SIDE,0,0><.5*SIDE,0,0> 4/BLOB_A_R01, BLOB_STRN01
            scale <1,1.1,1>
         }

         #declare BLOB_STRN01 = -1.5
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<-25*SIDE,0,0><.5*SIDE,0,0> 4/BLOB_A_R01, BLOB_STRN01
            scale <1,.5,1.5>
            translate y*2
         }
         translate <0,-13,1.5>
      }
      translate z*1.5
      rotate y*degrees(atan2(4,21))*SIDE
   }
   box{ <-22*SIDE,2,-5><0,-20,15> }
}

#declare L_PLATE01=
union{
      intersection{
         union{
            difference{
               cylinder{<0,0,0><-8*SIDE,0,0>5 } //scale <1,1,.95>}
               box{<-10*SIDE,-3.75,-3><.5*SIDE,10,-10>}
               superellipsoid {<0.01,.1> scale <7.5,3.2,4> translate <0,.3,-6.5>}
            }
            cylinder{<-8.5*SIDE,0,0><-7.5*SIDE,0,0>4.5}
            torus{ 4.5,.5 rotate z*90 translate x*-8*SIDE}

            cylinder{<-8*SIDE,0,-4.5><-8*SIDE,5,-4.5>.5 rotate x*-5}
            box{<-.5,5,-4.5><.5,0,2> translate x*-8*SIDE rotate x*-5}

            cylinder{<0,0,-4.5><-8*SIDE,0,-4.5>.5 rotate x*-degrees(asin(3.75/5)) }
         }
         box{<-10*SIDE,3.5,0><.5*SIDE,-10,-10>}
      }
      cylinder{<-8*SIDE,3.5,-(4.5+3.5*tan(radians (5)))><-8*SIDE,3.5,0>.5}
      sphere{<-8*SIDE,3.5,-(4.5+3.5*tan(radians (5)))>.5}

      intersection{
         union{
            cylinder{<10*SIDE,0,0><-10*SIDE,0,0>.5
               rotate y*degrees(atan2(4,21))*SIDE
               translate <-8*SIDE,3.5,-(4.5+3.5*tan(radians (5)))>
            }
            box{<10*SIDE,0.5,0><-10*SIDE,-0.5,10>
               rotate y*degrees(atan2(4,21))*SIDE
               translate <-8*SIDE,3.5,-(4.5+3.5*tan(radians (5)))>
            }
         }
         box{<0,1,0><-8*SIDE,-1,-10> translate y*3.5}
      }
}
