
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: RC CAR
// Date: 21.11.97
// Auth: N.B.(c)1997

// scale approx. 300/8 to get cm.

/*
background {color rgb 0}
camera {
   location <-100,70,-150>*.15*.5

   //location <0,30,0>
   look_at <0,0,0>
   angle 30
   }

light_source { <-2000, 2000, -2000> rgb 1 }

#include "metals.inc"

#declare DEF_TEX=
texture{
   finish{
      diffuse .9
      ambient .2
      phong .5
      phong_size 10
   }
   pigment{
      color rgb .7
   }
}
*/

#declare TTEX =
   texture{
      finish{
         ambient <0.9,0.85,.8>*.2
         diffuse .95
         phong .05
         phong_size 3
      }
      pigment{color rgb <0.9,0.85,.8>*.2}
   }

#declare BTEX =
   texture{
      finish {
         ambient <1,.9,.05>*.3
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.3
      }
      normal {bumps 0.05 scale 20}
      //pigment{color rgb <1,.9,.05>}
      //pigment{color rgb <1,.7,.0>}
      //pigment{color rgb 0.05}
   }

#declare BTEX01 = texture { BTEX pigment{color rgb 0.05} }
#declare BTEX02 = texture { BTEX pigment{color rgb <.3,0,.3>}}
#declare BTEX03 = texture { BTEX
   pigment {
      image_map {
         gif "graphic1.gif"
         map_type 2
         once
      }
      scale 10
      rotate z*-90
      translate x*-5
   }
}
#declare BTEX04 =
texture { BTEX
   pigment {
      image_map {
         gif "graphic4.gif"
         map_type 2
         once
      }
      translate y*-.5
      rotate x*-90
      rotate z*-70
      scale 5
   }
}


#declare C_Num_Elm = 36
#declare C_Num_Turn = 5
#declare C_Tot_Hgh = 1
#declare C_Rad_01 = .2
#declare C_Rad_02 = .05
#declare C_Num_Tot = C_Num_Elm * C_Num_Turn -1
#declare XZ_Ang00 = 360/C_Num_Elm
#declare XZ_Ang0i = 0
#declare dY_Hgh = C_Tot_Hgh/C_Num_Tot
#declare BB1 = < C_Rad_01, 0, 0 >

#declare CSG_Coil01 =
union {
   sphere { BB1 C_Rad_02 }
   #while ( C_Num_Tot >= 0 )
      #declare BB2 = vrotate ( ( BB1 + < 0, dY_Hgh,0 > ), < 0, XZ_Ang00, 0 > )
      cylinder { BB1 BB2 C_Rad_02 }
      sphere { BB2 C_Rad_02 }
      #declare BB1 = BB2
      #declare C_Num_Tot = C_Num_Tot - 1
   #end
}

#declare C_Num_Elm = 36
#declare C_Num_Turn = 5
#declare C_Tot_Hgh = 1
#declare C_Rad_01 = .2
#declare C_Rad_02 = .05
#declare C_Num_Tot = C_Num_Elm * C_Num_Turn -1
#declare XZ_Ang00 = 360/C_Num_Elm
#declare XZ_Ang0i = 0
#declare dY_Hgh = C_Tot_Hgh/C_Num_Tot
#declare BB1 = < C_Rad_01, 0, 0 >

// threshold
#declare BLOB_DENS01 = .6
// strength
#declare BLOB_STRN01 = 2
// blob actual radius
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( BLOB_DENS01 / BLOB_STRN01 ) )

#declare Blob_Coil01 =
blob{ threshold BLOB_DENS01
   #while ( C_Num_Tot >= 0 )
      #declare BB2 = vrotate ( ( BB1 + < 0, dY_Hgh,0 > ), < 0, XZ_Ang00, 0 > )
      cylinder { BB1 BB2 C_Rad_02/BLOB_A_R01,BLOB_STRN01 }
      sphere { BB2 C_Rad_02/BLOB_A_R01, BLOB_STRN01*-.7 }
      #declare BB1 = BB2
      #declare C_Num_Tot = C_Num_Tot - 1
   #end
}

#declare RUB01=
   intersection{
      union{
         cone { < 0, 0, 0 > 1.05 < 0, 0, -.5 > 1.02 }
         cone { < 0, 0, -.5 > 1.02 < 0, 0, -.65 > .65 }
      }
      #declare NUM01 = 16
      #declare ANG01 = 360 / ( NUM01 + 1 )
      union{
         #while ( NUM01 >= 0 )
            box { < 0, 0, 0 > < .15, 1.2 , -1 >
               rotate y*-30
               rotate z*ANG01*NUM01
            }
            #declare NUM01 = NUM01 - 1
         #end
      }
   }
#declare RUB02=
   intersection{
      union{
         cone { < 0, 0, 0 > 1.05 < 0, 0, -.5 > 1.02 }
         cone { < 0, 0, -.5 > 1.02 < 0, 0, -.65 > .65 }
      }
      #declare NUM01 = 16
      #declare ANG01 = 360 / ( NUM01 + 1 )
      union{
         #while ( NUM01 >= 0 )
            box { < 0, 0, 0 > < -.15, 1.2 , -1 >
               rotate y*30
               rotate z*ANG01*NUM01
            }
            #declare NUM01 = NUM01 - 1
         #end
      }
      rotate z*ANG01/2
   }

#declare M_TYRE =
union {
   difference{
      union{
         object {RUB01 }
         object {RUB02 rotate y*180 }
      }
      cylinder { < 0, 0, 1 > < 0, 0, -1 > 0.8 }
   //cone { < 0, 0, -.65 > 0.55 < 0, 0, -.75 > 1 }
   }
   difference{
      union{
         torus { .7 .28
            rotate x*90
            scale < 1, 1, .8 >
            translate z*-.38
         }
         torus { .7 .28
            rotate x*90
            scale < 1, 1, .8 >
            translate z*.38
         }
         cylinder { < 0, 0, .38 > < 0, 0, -.38 > 0.98 }
      }
      cylinder { < 0, 0, 1 > < 0, 0, -1 > 0.55 }
   }
}

#declare M_WHEEL=
union {
   difference{
      cylinder { < 0, 0, .55 > < 0, 0, -.55 > 0.55 }
      cone { < 0, 0, -.58 > 0.6 < 0, 0, -.42 > 0.25 }
      cylinder { < 0, 0, -.55 > < 0, 0, -.4 > 0.47 }
      cone { < 0, 0, -.40001 > 0.47 < 0, 0, -.22 > 0.12 }
      cylinder { < 0, 0, -.55 > < 0, 0, -.15 > 0.40 }
      cylinder { < 0, 0, -.55 > < 0, 0, -.1 > 0.2 }
      #declare NUM01 = 16
      #declare ANG01 = 360 / ( NUM01 + 1 )
      union{
         #while ( NUM01 >= 0 )
            cylinder { < 0, .3, -.55 > < 0, .3, 0 > 0.05
               rotate z*ANG01*NUM01
               }
            #declare NUM01 = NUM01 - 1
         #end
      }
   }
   cone { < 0, 0, -.1 >.1 < 0, 0, -.3 > .07 }
}

#declare M_WHEEL00=
union{
   object { M_TYRE   texture { TTEX}}
   object { M_WHEEL  texture { T_Chrome_4D}}
   translate <0,1,0>
}

#declare AXLE01=
intersection{
   superellipsoid { <.3, 2>
      scale <.6, .6, 3>
   }
   box{<-.5,-.5,-2><.5,.5,2>}
}

#declare BASE01=
union{
   box{ <0,1,-.8> <5,.5,.8> }
   object {AXLE01 translate < 0, 1, 0 >}
   object {AXLE01 translate < 5, 1, 0 >}
   // front bumper
   union{
      cylinder { <0,0,-1.5> <0,0,1.5> .12 translate < -1.6, 1.25, 0 >}
      cylinder { <0,0,0> <0,0,-1> .12 rotate x*15 translate < -1.6, 1.25, -1.5 >}
      sphere { < -1.6, 1.25, -1.5 > .12 }
      sphere { <0,0,-1> .12 rotate x*15 translate < -1.6, 1.25, -1.5 >}

      cylinder { <0,0,0> <0,0,1> .12 rotate x*-15 translate < -1.6, 1.25, 1.5 >}
      sphere { < -1.6, 1.25, 1.5 > .12 }
      sphere { <0,0,1> .12 rotate x*-15 translate < -1.6, 1.25, 1.5 >}

      cylinder { <0,0,-1> <0,0,1> .15 translate < -.45, 1.2, 0 >}
      sphere { <0,0,1> .15 translate < -.45, 1.2, 0 >}
      sphere { <0,0,-1> .15 translate < -.45, 1.2, 0 >}
      texture { T_Chrome_4D}
   }
   cylinder { <0,0,-.8> <0,0,.8> .7 translate < 4.7, 1.5, 0 >}

   difference{
      prism {
         linear_sweep
         linear_spline
         -.2,
         1,
         10,
         < -2, 0 >, < -1.8, -.6 >,
         <4,  -1.5>, <5,  -1>, <6,  -1.0>,
         <6, 1.0>, <5, 1.0>, <4,  1.5>,
         < -1.8, .6 >, <-2, 0 >
      }
      box{ <0,2,2> <-2,-5,-2> rotate z*70 translate <-2, .2, 0> }
      box{ <0,2,2> <2,-5,-2> rotate z*-45 translate <6,.2,0> }
      box{ <12,2,2> <-2,0,-2> rotate z*3 translate <-2, .5, 0> }
      box{ <0,-.1,-1.1> <4,.2,-2>}
      box{ <0,-.1,1.1> <4,.2,2>}
      box{ <0,.3,-1.1> <4,.6,-2>}
      box{ <0,.3,1.1> <4,.6,2>}
      translate y*1
   }

texture { BTEX01 } }

#declare BODY01=
union{
   difference{
      union {
         superellipsoid { <1.2, 1.2>
            scale <5, 1, 1.5>
         }
         sphere{ 0, 1 scale <1.5,.2,.2> rotate y*2 rotate z*12 translate <-3,.4,-.5>}
         sphere{ 0, 1 scale <1.5,.2,.2> rotate y*-2 rotate z*12 translate <-3,.4,.5>}
         texture {BTEX03}
      }
      cylinder{<0,0,-2><0,0,2>1
         scale <2.5,1.2,1>
         translate <3,-.5,0>
      }
      box{<-6,-.2,-3><6,-3,3> rotate z*-2}
      superellipsoid { <.1, .3>
         scale <1,1,.8>
         translate <-.5, 1, 0>
      }
   }
   #declare RG01=
   union{
      cylinder{<0,1,0><0,-.5,0>.1
         rotate z*-45
         translate <-1.2,.7,0>
      }
      sphere{<0,1,0>.1
         rotate z*-45
         translate <-1.2,.7,0>
      }
      cylinder{<0,0,0><0,1,0>.1
         rotate z*-45
         translate <0,1,0>
         rotate z*-45
         translate <-1.2,.7,0>
      }
      sphere{<0,1,0>.1
         rotate z*-45
         translate <0,1,0>
         rotate z*-45
         translate <-1.2,.7,0>
      }
      cylinder{<1,0,0><1,-1,0>.1
         rotate z*45
         translate <0,1,0>
         rotate z*-45
         translate <-1.2,.7,0>
      }
   }
   object{RG01 translate z*-.7}
   object{RG01 translate z*.7}
   cylinder{<0,1,0.7><0,1,-0.7>.1
      rotate z*-45
      translate <-1.2,.7,0>
   }
   cylinder{<0,1,0.7><0,1,-0.7>.1
      rotate z*-45
      translate <0,1,0>
      rotate z*-45
      translate <-1.2,.7,0>
   }
   cylinder{<0,0,-2><0,0,2>1
      texture { BTEX04 }
      scale <1,.1,1>
      translate <3.5,1.5,0>
   }
   #declare WING01=
   prism {
      linear_sweep
      linear_spline
      -.05,
      .05,
      5,
      < -1, 0.5 >, < .7, 0.5 >, < 2, 1.5 >, < 1, 1.5 >, < -1, 0.5 >
      rotate x*-90
   }
   #declare WING02=
   prism {
      linear_sweep
      linear_spline
      -.05,
      .05,
      6,
      < -1.1, -0.1 >, < 1.1, -0.1 >, < 1.2, .1 >, < .5, 0.7 >, < -1.2, 0.1 >, < -1.1, -0.1 >
      rotate x*-90
   }
   object {WING01 translate <1.5,0,0>}
   object {WING01 translate <1.5,0,-.5>}
   object {WING01 translate <1.5,0,.5>}
   object {WING02 translate <3.5,1.5,-2>}
   object {WING02 translate <3.5,1.5,2>}

   rotate z*5
   translate <3.1,2,0>
texture { BTEX02 } }


 #declare SHOCK_ABS01=
 union {
       //cylinder{<0,0,0><0,1,0>.2 texture { T_Chrome_4D normal { spiral1 1 1 rotate x*90 scale <1,.15,1>}}
       union{
       //object { CSG_Coil01 texture { T_Chrome_4D} }
          object { Blob_Coil01 }
          cylinder{<0,0,0><0,1,0>.1 }
          rotate x*15
          texture { T_Chrome_4D }
       }
       sphere{<0,1,0>.15
          rotate x*15
          texture { T_Chrome_4D}
       }
       prism {
         linear_sweep
         linear_spline
         -.1,
         .1,
         5,
         < -.1, 1.1 >, < .1, 1.1 >, < .4, 0 >, < -.4, 0 >, < -.1, 1.1 >
         rotate x*-90
         rotate x*-15
         translate <0,0,.7>
   }
   translate <0,1.2,-1.5>
   texture { BTEX02 }
}

#declare STWH01=
union{
   torus{7,.8 }
   sphere {0,1 scale <2,.8,2> translate y*.5 }
   cone{<0,0,0>1,<0,0,7>.5 scale <1,.7,1>  texture { T_Chrome_4D }}
   cone{<0,0,0>1,<0,0,7>.5 scale <1,.7,1> rotate y*120  texture { T_Chrome_4D }}
   cone{<0,0,0>1,<0,0,7>.5 scale <1,.7,1> rotate y*-120  texture { T_Chrome_4D }}
   cylinder {<0,0.5,0><0,-12,0>2 }
   scale .07
   rotate <90,90 0>
   texture {BTEX02}
}

#declare RAD_CAR01=
union{
   object {M_WHEEL00 rotate y*-15 translate z*-2}
   object {M_WHEEL00 rotate y*180 rotate y*-15 translate z*2}
   object {M_WHEEL00 translate <5,0,-2.2>}
   object {M_WHEEL00 rotate y*180 translate <5,0,2.2>}

   object {BASE01}

   object {BODY01}

   object {SHOCK_ABS01}
   object {SHOCK_ABS01 rotate y*180}
   object {SHOCK_ABS01 translate x*5}
   object {SHOCK_ABS01 rotate y*180 translate x*5}

   cylinder{ <0,2,0><0,10,0> .04 translate <3.5,0,-1.2> texture { T_Chrome_4D } }

   object{STWH01 rotate z*15 translate <2.4,2.4,0>}
}


#declare CNTRL_TEX=
texture{
   finish{
      diffuse .9
      brilliance .5
      ambient .2
      phong .5
      phong_size 20
   }
   normal {bumps .1 scale 1/200}
   pigment{
      bozo
      turbulence 2
      color_map{
         [ 0 color rgb .15 ]
         [ 0.5 color rgb .12 ]
         [ 1 color rgb .15 ]
      }
      scale 1/200
   }
}

#declare CNTRL01=
intersection{
   union{
      difference{
         box{<-1,0,-1><1,1,1> texture { T_Chrome_4D } }
         cylinder {<0,-.2,0><0,1.2,0>.5 }
      }
      superellipsoid { < 1, 0.5 > translate y*1.0 scale <.5,.5,.75> }
      cylinder { <0,.5,-.2><0,.5,.2>.52 texture { T_Chrome_4D } }
      cylinder { <0,.5,0><0,1.3,0>.15 texture { T_Chrome_4D } }
      sphere { <0,1.3,0>.15 texture { T_Chrome_4D } }
      }
   cylinder { <0,.5,0><0,3,0>.6 }
}

#declare CONTROL01=
union{
   difference{
      union{
         superellipsoid { < 0.5, 0.4 > translate y*1 scale <2,.7,1.7> }
         superellipsoid { < .7, 1.1 > scale <.5,.5,1> translate <0,.9,1.2>}
      }
      cone{<0,0,0>.05 <0,1,0>.5 translate <0,1.2,0>}
      cone{<0,0,0>.05 <0,1,0>.5 translate <0,1.2,0.7>}
   }
   object {CNTRL01 translate <1,.55,.5>}
   object {CNTRL01 rotate y*90 translate <-1,.55,.5>}
   superellipsoid { < 0.3, 0.2 >
      scale <1.7,.7,1.7>*.25
      translate <1.15,.8,1.3>
      texture { CNTRL_TEX pigment {color rgb < 0.65, 0, 0> } }
   }
   cylinder {<0,.9,1><0,.9,7>.05 texture { T_Chrome_4D } }
   rotate y*180
   texture { CNTRL_TEX }
}

//object{RAD_CAR01}
//plane { y 0 texture {DEF_TEX}}

