//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 5 lights, 41 textures and 397 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/26/1997    (26.12.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.2 //2.3 //1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10

}

background { color <0.000,0.000,0.000> }

camera {  //  Camera camera0_102
  location  <0.114, -40.016, 0.132>
  direction <0.0,     0.0,  1.6573>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.000, 0.000, 0.000>
}

// *******  L I G H T S *******





light_source {   // Light001
  <-0.714, -121.965, 16.573>
  color rgb <0.398, 0.398, 0.398>
  atmosphere off
}

light_source {   // light_s2_3
  <2.127, -70.791, 23.337>
  color rgb <0.376, 0.376, 0.376>
  shadowless
  atmosphere off
}

light_source {   // light_s1_2
  <61.856, -49.359, 25.433>
  color rgb <0.374, 0.374, 0.374>
  shadowless
  atmosphere off
}

light_source {   // BackLight
  <9.126, 89.177, 17.303>
  color rgb <0.513, 0.513, 0.513>
  atmosphere off
}

light_source {   // light_s3_4
  <-45.611, -46.729, 3.319>
  color rgb <0.369, 0.369, 0.369>
  shadowless
  atmosphere off
}


// ********  TEXTURES  *******
//

#include "colors.inc"
#include "page6w.inc"



// ********  REFERENCED OBJECTS  *******
#declare FPTex =  pigment {color rgb <0.7,0.5,0.3>}
#declare LogTex = pigment {colour rgb < 0.31, 0.27, 0.19>}
#declare BLK = pigment {colour rgb < 0.0, 0.0, 0.0>}

//Halos*************************



#declare FPHalo =
halo
{
 attenuating //emitting  //
  spherical_mapping
 // max_value 1.0
linear
turbulence 1.5
  colour_map
  {
    [ 0 color rgbt <.5, 0, 0, 1.0>] //<1, 0, 0, 1.0> ] //
    [ 1 color rgbt <1, 1, 0, -1.0> ] //<1, .5, 0, -1.0> ] //
  }
  samples 10
scale <0.75,0.5,1>
translate <-0.3,0,0> //<-0.4,0,0>

  //aa_level 5
  //aa_threshold 0.1
  //jitter 0.8
}
#declare FPHalo1 =
halo
{
 emitting  //attenuating
  spherical_mapping
 // max_value 1.0
linear
turbulence 1.5
  colour_map
  {
    [ 0 color rgbt <.5, 0, 0, 1.0> ]//<1, 0, 0, 1.0> ] //<.5, 0, 0, 1.0> ]
    [ 1 color rgbt <1, 1, 0, -1.0> ] //<1, .5, 0, -1.0> ] //<1, 1, 0, -1.0> ]
  }
  samples 10
scale <0.75,0.5,1>
translate <0.4,0,0>

  //aa_level 5
  //aa_threshold 0.1
  //jitter 0.8
}

#declare FPHalo2 =
halo
{
 emitting  //attenuating
  spherical_mapping
 // max_value 1.0
linear
turbulence 1.5
  colour_map
  {
    [ 0 color rgbt <.5, 0, 0, 1.0>] //<1, 0, 0, 1.0> ] //<.5, 0, 0, 1.0> ]
    [ 1 color rgbt <1, 1, 0, -1.0> ] //<1, .5, 0, -1.0> ] //<1, 1, 0, -1.0> ]
  }
  samples 10
scale .5 //<0.75,0.5,1>
translate <0,0,0.2>

  //aa_level 5
  //aa_threshold 0.1
  //jitter 0.8
}



// ********  OBJECTS  *******

/*sphere { // Halos
  <0,0,0>,1
  texture {
    CastWindowTex
  }
  scale <6.0, 2.595187, 1.622384>
  rotate <0.0, 8.0, 0.0>
  translate  <2.644917, 42.217468, -11.773172>
}*/
sphere { // FireSub
  <0,0,0>,2
pigment { color rgbt <1,1,1,1>}

halo{FPHalo}
halo{FPHalo1}
halo{FPHalo2}



      hollow

scale <6.0, 2.595187, 5> //<6.0, 2.595187, 3>
  rotate <0.0, 8.0, 0.0>
  translate <2.44917, 42.217468, -8.0773172> //<2.44917, 42.217468, -11.0773172>
   // <2.644917, 42.217468, -11.773172>

}



/*sphere { // Spark2
  <0,0,0>,1
  texture {
    WandTex
  }
  scale 0.5
  rotate <21.406469, -33.725971, -35.224819>
  translate <0.112671, 33.46, 13.3075> //<-0.089738, 33.432149, 11.531503> // <1.335457, 31.532534, 11.743396>
}*/
#declare camera_location = <0.114, -40.016, 0.132> //<0.000, -40.000, 0.000>

//#declare camera_direction = <0.0,     0.0,  1.6574> //1.9398>
  #declare camera_sky = <0.0,     0.0,  1.0>  // Use right handed-system!
  #declare camera_up = <0.0,     0.0,  1.0>  // Where Z is up
  #declare camera_right = <1.33333, 0.0,  0.0>


   #declare camera_look_at = <0, 0, 0>
   #declare effect_location = <-0.089738, 33.432149, 11.531503> // <1.335457, 31.532534, 11.743396> //<-2.23, 22.07, 7.98> //<-3.086654, 6.67187, 4.28803> //<-13.430637, 1.612422, 4.908245>
#declare effect_scale = .5
    #declare effect_type ="Sparkle"
#declare effect_color = <1, 0.61, 1> //<1, 0.61, 0.70>

#declare source_color = <1, 0.61, 1> //<1, 0.61, 0.70>
   #include "Lens.inc"


box { // Cube003
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PBlack
  }
  scale <0.1, 22.0, 20.0>
  translate  <12.914609, 72.829422, 0.0>
}






#include "ttf_obj.inc"

#declare ttf_1_Ref = object {
  ttf_00000
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-13.779662, 10.589337, 10.5434>
}
#declare ttf_3_Ref = object {
  ttf_00002
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-12.820922, 10.589337, 10.5434>
}
#declare ttf_4_Ref = object {
  ttf_00003
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-12.237182, 10.589337, 10.5434>
}
#declare ttf_5_Ref = object {
  ttf_00004
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-11.487182, 10.589337, 10.5434>
}
#declare ttf_7_Ref = object {
  ttf_00006
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-10.44641, 10.589337, 10.5434>
}
#declare ttf_8_Ref = object {
  ttf_00007
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-9.86267, 10.589337, 10.5434>
}
#declare ttf_9_Ref = object {
  ttf_00008
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-9.196898, 10.589337, 10.5434>
}
#declare ttf_11_Ref = object {
  ttf_00010
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-8.40515, 10.589337, 10.5434>
}
#declare ttf_12_Ref = object {
  ttf_00011
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-7.73938, 10.589337, 10.5434>
}
#declare ttf_13_Ref = object {
  ttf_00012
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-7.239868, 10.589337, 10.5434>
}
#declare ttf_14_Ref = object {
  ttf_00013
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-6.489868, 10.589337, 10.5434>
}
#declare ttf_15_Ref = object {
  ttf_00014
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-6.07312, 10.589337, 10.5434>
}
#declare ttf_16_Ref = object {
  ttf_00015
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-5.32312, 10.589337, 10.5434>
}
#declare ttf_18_Ref = object {
  ttf_00017
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-4.19812, 10.589337, 10.5434>
}
#declare ttf_19_Ref = object {
  ttf_00018
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-3.44812, 10.589337, 10.5434>
}
#declare ttf_21_Ref = object {
  ttf_00020
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-2.32312, 10.589337, 10.5434>
}
#declare ttf_22_Ref = object {
  ttf_00021
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-1.906372, 10.589337, 10.5434>
}
#declare ttf_23_Ref = object {
  ttf_00022
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-1.156372, 10.589337, 10.5434>
}
#declare ttf_25_Ref = object {
  ttf_00024
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <-0.1156, 10.589337, 10.5434>
}
#declare ttf_26_Ref = object {
  ttf_00025
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <0.6344, 10.589337, 10.5434>
}
#declare ttf_27_Ref = object {
  ttf_00026
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <1.300172, 10.589337, 10.5434>
}
#declare ttf_28_Ref = object {
  ttf_00027
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <1.965943, 10.589337, 10.5434>
}
#declare ttf_29_Ref = object {
  ttf_00028
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <2.465455, 10.589337, 10.5434>
}
#declare ttf_30_Ref = object {
  ttf_00029
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <2.882203, 10.589337, 10.5434>
}
#declare ttf_31_Ref = object {
  ttf_00030
  scale <1.5, 1.5, 1.59375>
  rotate 90.0*x
  translate  <3.632203, 10.589337, 10.5434>
}
#declare Print1 = union {
  object { ttf_1_Ref }
  object { ttf_3_Ref }
  object { ttf_4_Ref }
  object { ttf_5_Ref }
  object { ttf_7_Ref }
  object { ttf_8_Ref }
  object { ttf_9_Ref }
  object { ttf_11_Ref }
  object { ttf_12_Ref }
  object { ttf_13_Ref }
  object { ttf_14_Ref }
  object { ttf_15_Ref }
  object { ttf_16_Ref }
  object { ttf_18_Ref }
  object { ttf_19_Ref }
  object { ttf_21_Ref }
  object { ttf_22_Ref }
  object { ttf_23_Ref }
  object { ttf_25_Ref }
  object { ttf_26_Ref }
  object { ttf_27_Ref }
  object { ttf_28_Ref }
  object { ttf_29_Ref }
  object { ttf_30_Ref }
  object { ttf_31_Ref }
  texture {
    PBlack
  }
  scale <0.645161, 1.0, 0.4>
  translate  <-1.007217, -8.5, -7.095852>
}
#declare ttf_33_Ref = object {
  ttf_00032
  texture {
    PBlack
  }
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <6.027623, 11.038386, -12.42832>
}
#declare ttf_34_Ref = object {
  ttf_00033
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <7.028111, 11.038386, -12.42832>
}
#declare ttf_35_Ref = object {
  ttf_00034
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <7.444858, 11.038386, -12.42832>
}
#declare ttf_36_Ref = object {
  ttf_00035
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <8.194858, 11.038386, -12.42832>
}
#declare ttf_37_Ref = object {
  ttf_00036
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <8.944858, 11.038386, -12.42832>
}
#declare ttf_38_Ref = object {
  ttf_00037
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <9.610629, 11.038386, -12.42832>
}
#declare ttf_39_Ref = object {
  ttf_00038
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <10.110141, 11.038386, -12.42832>
}
#declare ttf_40_Ref = object {
  ttf_00039
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <10.526889, 11.038386, -12.42832>
}
#declare ttf_41_Ref = object {
  ttf_00040
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <10.943636, 11.038386, -12.42832>
}
#declare ttf_42_Ref = object {
  ttf_00041
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <11.360384, 11.038386, -12.42832>
}
#declare ttf_44_Ref = object {
  ttf_00043
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <12.401154, 11.038386, -12.42832>
}
#declare ttf_45_Ref = object {
  ttf_00044
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <12.984895, 11.038386, -12.42832>
}
#declare ttf_46_Ref = object {
  ttf_00045
  scale <1.499999, 1.5, 1.59375>
  rotate 90.0*x
  translate  <13.650666, 11.038386, -12.42832>
}
#declare print2 = union {
  object { ttf_33_Ref }
  object { ttf_34_Ref }
  object { ttf_35_Ref }
  object { ttf_36_Ref }
  object { ttf_37_Ref }
  object { ttf_38_Ref }
  object { ttf_39_Ref }
  object { ttf_40_Ref }
  object { ttf_41_Ref }
  object { ttf_42_Ref }
  object { ttf_44_Ref }
  object { ttf_45_Ref }
  object { ttf_46_Ref }
  texture {
    PBlack
  }
  scale <0.645161, 1.0, 0.4>
  rotate <0.0, 0.0, 0.0>
  translate  <-14.676023, -8.472999, 1.460343>
}
#declare PrintGo_8 = union {
  cylinder { // cylinde7_70
    <0,0,1>, <0,0,0>, 1
    scale <13.268734, 5.0, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-0.314122, 5.586563, 7.358509>
  }
  object { Print1 }
  object { print2 }
}
#declare CurveCu_9 = difference {
  cylinder { // cylinde8_75
    <0,0,1>, <0,0,0>, 1
    scale <13.268734, 5.0, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <-0.363292, -1.376528, 8.281654>
  }
  cylinder { // cylinde9_76
    <0,0,1>, <0,0,0>, 1
    scale <13.268734, 5.0, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.0, 0.582864, 8.281654>
  }
  texture {
    PBlack
  }
  translate  <-0.140001, 4.732058, -1.007178>
}
#declare FrontPage = difference {
  object { PrintGo_8 }
  object { CurveCu_9 }
  box { // box25_77
    <-1, -1, -1>, <1, 1, 1>
    scale <15.521128, 9.640905, 10.163723>
    rotate 345.701996*z
    translate  <0.39014, 14.393173, 0.0>
  }
  box { // box26_78
    <-1, -1, -1>, <1, 1, 1>
    scale <9.5, 34.0, 4.3>
    translate  <-1.814536, 31.484223, 2.054224>
  }
  texture {
    PageTex
  }
  no_shadow
  scale <1.55, 1.0, 2.5>
  translate  <1.413656, 8.949049, -5.251074>
}
#include "trimsh00.inc"

#declare LetterA_Ref = object {
  TriMsh001
  texture {
    PRed
  }
  no_shadow
  scale <0.2, 0.2134, 1.732078>
  rotate <90.0, 0.0, -7.759797>
  translate  <-15.248015, 13.034298, -12.595705>
}
#declare Roof_0 = difference {
  box { // box0_19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood4
    }
    scale 0.930786
    rotate 315.0*y
    translate  <0.0, 1.736494, 0.922481>
  }
  box { // box1_20
    <-1, -1, -1>, <1, 1, 1>
    scale 0.930786
    rotate 315.0*y
    translate  <0.0, 0.063447, 0.781534>
  }
  texture {
    ClockTex
  }
  translate  <0.0, -1.629633, -0.096753>
}
#declare Door_1 = union {
  box { // box2_22
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 0.4>
    translate  -0.397106*z
  }
  cylinder { // cylinde0_23
    <0,0,1>, <0,0,0>, 1
    scale 0.3
    rotate <90.0, 0.0, 180.0>
    translate  <0.0, -0.3, 0.0>
  }
  texture {
    DMFWood2
  }
  translate  <0.0, -0.444335, 1.219826>
}
#declare Clock = union {
  box { // box3_17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ClockTex
    }
    scale <1.250468, 1.178305, 1.008987>
    translate  <0.0, 0.542644, -0.199592>
  }
  object { Roof_0 }
  object { Door_1 }
  cylinder { // cylinde1_24
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFWood2
    }
    scale <0.6, 0.6, 0.225>
    rotate <90.0, 0.0, 180.0>
    translate  <0.0, -0.669335, -0.341982>
  }
  cone { // cone1_25
    <0,0,0>, 0.0, <0,0,1>, 0.1
    scale 0.4
    rotate 179.753845*x
    translate  <0.0, -0.70353, 0.111084>
  }
  cone { // cone2_26
    <0,0,0>, 0.0, <0,0,1>, 0.1
    scale 0.3
    rotate <359.753845, 307.05365, 180.0>
    translate  <-0.382302, -0.705811, -0.63751>
  }
  cone { // cone3_27
    <0,0,0>, 0.1, <0,0,1>, 0.1
    scale <0.4, 0.4, 3.0>
    translate  <-0.931126, -0.462849, -3.290893>
  }
  cone { // cone4_28
    <0,0,0>, 0.1, <0,0,1>, 0.1
    scale <0.4, 0.4, 4.5>
    translate  <0.746561, -0.481363, -5.159391>
  }
  cone { // cone5_29
    <0,0,0>, 0.1, <0,0,1>, 0.1
    scale <0.4, 0.4, 2.0>
    translate  <0.023216, -0.462849, -2.825262>
  }
  sphere { // sphere1_30
    <0,0,0>,1
    scale <0.1, 0.044458, 0.183313>
    translate  <-0.934125, -0.460542, -3.334939>
  }
  sphere { // sphere2_31
    <0,0,0>,1
    scale <0.1, 0.044458, 0.183313>
    translate  <0.771514, -0.446471, -5.151956>
  }
  sphere { // sphere3_32
    <0,0,0>,1
    scale <0.1, 0.044458, 0.183313>
    translate  <0.026506, -0.446471, -2.673401>
  }
  sphere { // sphere4_33
    <0,0,0>,1
    scale <0.1, 0.044458, 0.183313>
    rotate 90.0*y
    translate  <0.028117, -0.446471, -2.93151>
  }
  texture {
    PBlack
  translate <1.595584, -20.025991, -5.907338>
  }
  translate  <-1.595584, 20.025991, 5.907338>
}
#declare HgtFld0_2 = object {
  height_field {
    tga "C:\CARNIVL\page.tga"
    water_level 0.0109
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <88.714554, 35.971497, 19.151802>
  rotate <360.0, 0.0, 360.0>
  translate  <33.888217, 159.909124, 21.013476>
}
#declare Mts_5 = difference {
  object { HgtFld0_2 }
  box { // box14_54
    <-1, -1, -1>, <1, 1, 1>
    scale .01 //40.0
    translate  <-51.154862, 161.32321, 0.0>
  }
  texture {
    MtTex
  }
  translate  <0.179142, 0.000515, 0.025177>
}
#declare Castle1 = union {
  cylinder { // cylinde2_37
    <0,0,1>, <0,0,0>, 1
    scale <1.2, 1.2, 6.0>
    rotate <180.0, 0.0, 180.0>
    translate  <33.252998, 145.58459, 10.97682>
  }
  cylinder { // cylinde3_38
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  <27.29012, 146.630183, 13.015768>
  }
  cylinder { // cylinde4_39
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 10.0>
    rotate <180.0, 0.0, 180.0>
    translate  <31.31217, 146.737488, 15.453068>
  }
  box { // box4_40
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.672007, 3.491061>
    translate  <28.788608, 146.528392, 8.611247>
  }
  box { // box5_41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <29.331, 146.01071, 11.439104>
  }
  box { // box6_42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 0.259119>
    translate  <31.10923, 145.646459, 11.260669>
  }
  box { // box7_43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.942737, 146.01071, 11.439104>
  }
  box { // box8_44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.554474, 146.01071, 11.439104>
  }
  box { // box9_45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.16621, 146.01071, 11.439104>
  }
  box { // box10_46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.163239, 146.01071, 10.362892>
  }
  box { // box11_47
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.551341, 146.01071, 10.365157>
  }
  box { // box12_48
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.939604, 146.008198, 10.365157>
  }
  box { // box13_49
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <29.331, 146.01071, 10.365157>
  }
  cone { // cone6_50
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      CastRoofTex1
    }
    scale <2.512356, 2.512356, 4.024711>
    rotate <180.0, 0.0, 180.0>
    translate  <31.271969, 146.733828, 19.349526>
  }
  cone { // cone7_51
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      CastRoofTex1
    }
    scale <1.2, 1.2, 1.922361>
    rotate <180.0, 0.0, 180.0>
    translate  <27.274163, 146.733828, 14.867211>
  }
  cone { // cone8_52
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      CastRoofTex1
    }
    scale <1.4, 1.4, 2.242754>
    rotate <180.0, 0.0, 180.0>
    translate  <33.262993, 145.615495, 12.997155>
  }
  box { // box13_50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.164254, 146.01071, 9.246812>
  }
  box { // box13_51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.553169, 146.01071, 9.251585>
  }
  box { // box13_52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <28.938754, 146.01071, 9.249305>
  }
  box { // box13_53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.072785, 0.214507, 0.318597>
    translate  <29.331, 146.006978, 9.245573>
  }
  box { // box6_43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 0.259119>
    translate  <30.552092, 145.628477, 9.850153>
  }
  box { // box6_44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 0.626265>
    translate  <26.998924, 146.312629, 10.290728>
  }
  box { // box6_45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 1.140269>
    translate  <33.169038, 145.195432, 9.18929>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFWood3
    }
    scale <1.0, 1.0, 2.154516>
    rotate 90.0*x
    translate  <30.940253, 146.20117, 13.486466>
  }
  box { // box6_46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 0.259119>
    translate  <26.560934, 146.357644, 11.771679>
  }
  box { // box6_47
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 0.259119>
    translate  <32.526774, 145.203129, 9.675468>
  }
  box { // box6_48
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.172741, 0.95745, 0.259119>
    translate  <32.439432, 145.203129, 7.6666>
  }
  box { // box13_54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CastWindowTex
    }
    scale <0.334811, 0.214507, 1.366702>
    translate  <28.787966, 146.01071, 6.281954>
  }
  texture {
    CastleTex1
  }
 scale 2 //1.5
  translate  <50.933043, 14.589688, 36.086651> //<37.53004, 17.253187, 20.003079>
}
#declare BackGround = union {
  object { Mts_5 }
  box { // Horizon
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PRed
    }
    scale <100.801643, 100.0, 0.1>
    rotate 4.0*x
    translate  <-8.630606, 52.262208, -11.131955>
  }
  sphere { // Moon
    <0,0,0>,1
    texture {
      MoonTex
    }
    scale <2.0, 0.05, 2.0>
    translate  <-38.153226, -7.03402, 11.907238> //<-36.539257, -7.03402, 11.285928>
  }
  object { Castle1 }
  //scale 1.5
  translate  <13.884466, 75.110684, 3.931403>
}
#declare CSG005_6 = union {
  box { // Floor
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FloorTex
    }
    scale <14.73, 34.0, 0.01>
    translate  <-1.3295, 43.302473, -10.765259>
  }
  box { // Cieling
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Texture4
    }
    scale <14.73, 34.0, 0.01>
    translate  <-1.3295, 43.266474, 10.64>
  }
  box { // RtWall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ClockTex
    }
    scale <0.1, 4.8, 11.5>
    translate  <13.4, 15.6, 0.03463>
  }
  box { // LWall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      ClockTex
    }
    scale <0.1, 4.8, 11.5>
    translate  <-16.181839, 16.7, 0.0>
  }
  box { // COVER
    <-1, -1, -1>, <1, 1, 1>
    texture {
      CoverTex
    }
    scale <33.21257, 0.1, 24.757557>
    translate  <-2.930819, 23.837326, 0.0>
  }
}
#declare CSG2_7 = difference {
  cylinder { // cylinde5_65
    <0,0,1>, <0,0,0>, 1
    scale <13.268734, 5.0, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.132831, -2.319787, 8.281654>
  }
  cylinder { // cylinde6_66
    <0,0,1>, <0,0,0>, 1
    scale <13.268734, 5.0, 15.0>
    rotate <180.0, 0.0, 180.0>
    translate  <0.0, 0.582864, 8.281654>
  }
  scale <1.55, 1.0, 2.5>
  translate  <0.580306, 13.966103, -7.76902>
}
#declare differe3_57 = difference {
  object { CSG005_6 }
  object { CSG2_7 }
  box { // box21_67
    <-1, -1, -1>, <1, 1, 1>
    scale <-18.820642, -39.417652, -13.388245>
    rotate <180.0, 0.0, 180.0>
    translate  <0.175677, 62.51021, 0.298708>
  }
  no_shadow
}
#declare CSG004 = union {
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <9.003862, 2.242633, 6.93531>
    rotate -90.0*x
    translate  <1.51619, 24.378977, -2.932245>
  }
  box { // FirePlaceCut
    <-1, -1, -1>, <1, 1, 1>
    scale <9.024651, 3.438245, 5.174865>
    translate  <1.51552, 27.876886, -8.122902>
  }
 /* texture {
    FireCrackle
  }*/


texture{
   pigment{
     crackle pigment_map{[0.0 BLK][1.0 FPTex]} // color_map{[0.0 Orange][1.0 White]}
     scale 1.3 //.14 //0.240

   }
 }



  scale 0.729927
  translate  <-2.367196, 0.0, -0.2124>
}
#declare HearthC_12 = difference {
  box { // BackWall
    <-1, -1, -1>, <1, 1, 1>
    scale <15.5, 2.0, 11.5>
    translate  <-1.286425, 22.587567, 0.0>
  }
  box { // box29_83
    <-1, -1, -1>, <1, 1, 1>
    scale <3.995084, 2.181179, 4.2>
    translate  <8.934303, 22.639898, 3.6>
  }
  box { // box30_84
    <-1, -1, -1>, <1, 1, 1>
    scale <3.995084, 2.181179, 4.2>
    translate  <-11.037351, 22.639898, 3.6>
  }
  object { CSG004 }

texture{
   pigment{
     crackle pigment_map{[0.0 LogTex][1.0 FPTex]} // color_map{[0.0 Orange][1.0 White]}
     scale 1.30 //.5//.14 //0.240

   }
 }




  /*texture {
    WallCrackle
  }*/
}
#declare Andiron_10 = union {
  sphere { // sphere6_89
    <0,0,0>,1
    scale 0.3
    translate  <-0.007028, 0.002343, 3.092506>
  }
  cylinder { // cylinde10_90
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 3.0>
    rotate <0.0, 360.0, 360.0>
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    FairyHairTex
  }
  translate  <-2.512523, 9.093485, -5.529027>
}
#declare Andiron_11 = union {
  sphere { // sphere7_92
    <0,0,0>,1
    scale 0.3
    translate  <-0.007028, 0.002343, 3.092506>
  }
  cylinder { // cylinde11_93
    <0,0,1>, <0,0,0>, 1
    scale <0.2, 0.2, 3.0>
    rotate <0.0, 360.0, 360.0>
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    FairyHairTex
  }
  translate  <1.944984, 9.019193, -5.529027>
}
#declare FirePla_13 = union {
  object { Andiron_10 }
  object { Andiron_11 }
  cylinder { // cylinde12_94
    <0,0,1>, <0,0,0>, 1
texture {
    Ebony_Wood1
    scale 0.660358
  translate <-0.351261, -4.659796, 1.332616>
  }

    scale <0.3, 0.3, 5.5>
    rotate <180.0, 270.148499, 180.0>
    translate  <2.523694, 9.586811, -4.87304>
  }
  cylinder { // cylinde13_95
    <0,0,1>, <0,0,0>, 1
texture {
    Ebony_Wood1
    scale 0.660358
  translate <-0.351261, -4.659796, 1.332616>
  }

    scale <0.2, 0.2, 6.0>
    rotate <6.055511, 276.331512, 0.103073>
    translate  <2.769896, 10.032561, -4.779328>
  }
  cylinder { // cylinde14_96
    <0,0,1>, <0,0,0>, 1

texture {
    Ebony_Wood1
    scale 0.660358
  translate <-0.351261, -4.659796, 1.332616>
  }
      scale <0.2, 0.2, 5.0>
    rotate <180.0, 277.678589, 180.0>
    translate  <2.721805, 9.83445, -3.935917>
  }
  cylinder { // cylinde15_97
    <0,0,1>, <0,0,0>, 1

texture {
    Ebony_Wood1
    scale 0.660358
  translate <-0.351261, -4.659796, 1.332616>
  }

    scale <0.3, 0.3, 5.5>
    rotate <180.0, 270.148499, 180.0>
    translate  <2.523694, 9.586811, -4.498191>
  }
  /*sphere { // sphere8_87
    <0,0,0>,1
    texture {
      CastWindowTex
    }
    scale <1.687571, 0.729927, 0.456315>
    rotate <0.0, 0.0, 0.0>
    translate  <-0.482856, 9.173982, -5.046371>
  }*/
 /* texture {
    Ebony_Wood1
    scale 0.660358
  translate <-0.351261, -4.659796, 1.332616>
  }*/
  scale 1.51433
  translate  <-0.995325, 7.056469, -1.146316>
}
#declare Windows = union {
  box { // box31_99
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WindowTex
    }
    scale <0.203616, 0.007407, 5.176207>
    rotate <180.0, 90.0, 0.0>
    translate  <9.240959, 23.097356, 3.468829>
  }
  box { // box32_100
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WindowTex
    }
    scale <0.203616, 0.007407, 5.176207>
    rotate 180.0*z
    translate  <8.585949, 23.097356, 3.468829>
  }
  box { // box33_101
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WindowTex
    }
    scale <0.203616, 0.007407, 5.176207>
    rotate 180.0*z
    translate  <-11.320655, 23.097356, 3.954959>
  }
  box { // box34_102
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WindowTex
    }
    scale <0.203616, 0.007407, 5.176207>
    rotate <180.0, 90.0, 0.0>
    translate  <-12.45029, 23.097356, 3.468829>
  }
  translate  0.363679*x
}
#declare WallBack = union {
  object { HearthC_12 }
  box { // Mantle
    <-1, -1, -1>, <1, 1, 1>
   /* texture {
      MantleCrackle
    }*/

texture{
   pigment{
     crackle pigment_map{[0.0 LogTex][1.0 FPTex]} // color_map{[0.0 Orange][1.0 White]}
     //scale 1.3 //.14 //0.240
     scale <.2, .6, 1.2> //<.1, .3, .4> //<.1,.2, .2> //.14 //0.240
rotate <90,0,0>

   }
 }




    scale <7.122997, 2.540397, 0.65773>
    translate  <-1.225599, 22.407651, -10.309766>
  }
  object { FirePla_13 }
  object { Windows }
  translate  -0.181839*x
}
#declare Pump1 = union {
  torus { // Torus9
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.432543, 0.735621, 1.453392>
    rotate <-90.0, 0.0, 106.762115>
    translate  <0.013687, 0.0, -0.09739>
  }
  torus { // Torus10
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.634767, 0.689792, 1.186741>
    rotate <-90.0, 0.0, 64.773224>
  }
  torus { // Torus11
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, 19.345379>
  }
  torus { // Torus12
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -20.954004>
  }
  torus { // Torus13
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -140.020325>
  }
  torus { // Torus14
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -46.849075>
  }
  torus { // Torus15
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -90.0>
  }
  torus { // Torus16
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate -90.0*x
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      PumpTex3
    }
    scale <2.805561, 2.811541, 1.287961>
  }
  cone { // cone0_16
    <0,0,0>, 0.1, <0,0,1>, 0.3
    texture {
      PumpkinStemTe1
    }
    scale <1.4, 1.4, 1.707494>
    rotate <18.317148, 26.796261, 1.554387>
    translate  <-0.19005, 0.086754, 0.498695>
  }
  scale 0.81
  translate  <8.789581, 18.337498, -9.661152>
}
#declare CSG3 = union {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere4
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, -2.021623>
  }
  texture {
    PRed
  }
  scale <1.913289, 1.25, 1.25>
  rotate 90.0*z
  translate  <-1.379854, -3.817502, 0.047213>
}
#declare CSG4 = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, -2.021623>
  }
  texture {
    PRed
  }
  scale <2.88438, 1.884439, 1.884439>
  rotate 90.0*z
  translate  <-2.151143, -4.065553, 0.075203>
}
#declare CSG5 = difference {
  sphere { // Sphere9
    <0,0,0>,1
    scale 1.137711
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <0.698366, 0.967043, 1.302421>
    translate  <-0.000142, 0.001173, 0.720435>
  }
  scale <1.409411, 1.583395, 1.585561>
  rotate -6.515064*z
  translate  <0.03837, -2.732047, -1.6>
}
#declare Nail = difference {
  object { CSG3 }
  object { CSG4 }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.438808, 1.018016, 2.063637>
    translate  <0.0, -1.606266, -0.962861>
  }
  object { CSG5 }
  texture {
    PRed
  }
  scale <1.126519, 1.0, 1.0>
  translate  <-0.041424, 2.026123, 0.96286>
}
#declare CSG001 = union {
  sphere { // Sphere001
    <0,0,0>,1
  }
  cone { // Cone001
    <0,0,0>, 1.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.8>
  }
  texture {
    SkinTex
  }
}
#declare CSG002 = union {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere10
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  scale <1.913289, 1.25, 1.25>
  rotate 90.0*z
  translate  <-1.379854, -3.817502, 0.047213>
}
#declare CSG003 = difference {
  object { CSG001 }
  object { CSG002 }
  texture {
    SkinTex
  }
  no_shadow
}
#declare Digit = union {
  object { Nail }
  object { CSG003 }
  scale <0.01, 0.007227, 0.008398>
  rotate 89.233116*y
  translate  <10.233662, 8.410216, 11.88251>
}
#declare CSG30 = union {
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere40
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere41
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, -2.021623>
  }
  texture {
    NailTex
  }
  scale <1.913289, 1.25, 1.25>
  rotate 90.0*z
  translate  <-1.379854, -3.817502, 0.047213>
}
#declare CSG31 = union {
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere42
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere43
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, -2.021623>
  }
  texture {
    NailTex
  }
  scale <2.88438, 1.884439, 1.884439>
  rotate 90.0*z
  translate  <-2.151143, -4.065553, 0.075203>
}
#declare CSG32 = difference {
  sphere { // Sphere44
    <0,0,0>,1
    scale 1.137711
  }
  sphere { // Sphere45
    <0,0,0>,1
    scale <0.698366, 0.967043, 1.302421>
    translate  <-0.000142, 0.001173, 0.720435>
  }
  scale <1.409411, 1.583395, 1.585561>
  rotate -6.515064*z
  translate  <0.03837, -2.732047, -1.6>
}
#declare Nail4 = difference {
  object { CSG30 }
  object { CSG31 }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.438808, 1.018016, 2.063637>
    translate  <0.0, -1.606266, -0.962861>
  }
  object { CSG32 }
  texture {
    NailTex
  }
  scale <1.18, 1.0, 1.0>
  translate  <-0.041424, 2.026123, 0.96286>
}
#declare CSG33 = union {
  sphere { // Sphere46
    <0,0,0>,1
  }
  cone { // Cone6
    <0,0,0>, 1.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.8>
  }
}
#declare CSG34 = union {
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere47
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  scale <1.913289, 1.25, 1.25>
  rotate 90.0*z
  translate  <-1.379854, -3.817502, 0.047213>
}
#declare CSG35 = difference {
  object { CSG33 }
  object { CSG34 }
  texture {
    SkinTex
  }
}
#declare Digit5 = union {
  object { Nail4 }
  object { CSG35 }
  torus { // Torus3
    1.925, 0.1  rotate -x*90
    texture {
      FingerTex
    }
    no_shadow
    scale <0.435942, 0.623142, 0.598749>
    rotate <34.935833, 0.0, 180.0>
    translate  <0.025254, -0.372533, 0.536204>
  }
  no_shadow
  scale <1.383724, 1.0, 1.162014>
  rotate <180.0, -43.378399, -180.0>
  translate  <-13.607078, 8.308737, -6.423418>
}
#declare CSG36 = union {
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere48
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere49
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, -2.021623>
  }
  texture {
    NailTex
  }
  scale <1.913289, 1.25, 1.25>
  rotate 90.0*z
  translate  <-1.379854, -3.817502, 0.047213>
}
#declare CSG37 = union {
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere50
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere51
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, -2.021623>
  }
  texture {
    NailTex
  }
  scale <2.88438, 1.884439, 1.884439>
  rotate 90.0*z
  translate  <-2.151143, -4.065553, 0.075203>
}
#declare CSG38 = difference {
  sphere { // Sphere52
    <0,0,0>,1
    scale 1.137711
  }
  sphere { // Sphere53
    <0,0,0>,1
    scale <0.698366, 0.967043, 1.302421>
    translate  <-0.000142, 0.001173, 0.720435>
  }
  scale <1.409411, 1.583395, 1.585561>
  rotate -6.515064*z
  translate  <0.03837, -2.732047, -1.6>
}
#declare Nail5 = difference {
  object { CSG36 }
  object { CSG37 }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <1.438808, 1.018016, 2.063637>
    translate  <0.0, -1.606266, -0.962861>
  }
  object { CSG38 }
  texture {
    NailTex
  }
  scale <1.18, 1.0, 1.0>
  translate  <-0.041424, 2.026123, 0.96286>
}
#declare CSG39 = union {
  sphere { // Sphere54
    <0,0,0>,1
  }
  cone { // Cone7
    <0,0,0>, 1.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.8>
  }
}
#declare CSG40 = union {
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.8, 2.258698>
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  sphere { // Sphere55
    <0,0,0>,1
    scale 0.8
    rotate <180.0, 0.0, -77.79512>
    translate  <1.221667, -1.118341, 0.201542>
  }
  scale <1.913289, 1.25, 1.25>
  rotate 90.0*z
  translate  <-1.379854, -3.817502, 0.047213>
}
#declare CSG41 = difference {
  object { CSG39 }
  object { CSG40 }
  texture {
    SkinTex
  }
}
#declare Digit6 = union {
  object { Nail5 }
  object { CSG41 }
  torus { // Torus5
    1.925, 0.1  rotate -x*90
    texture {
      FingerTex
    }
    no_shadow
    scale <0.435942, 0.623142, 0.598749>
    rotate <34.935833, 0.0, 180.0>
    translate  <-0.058021, -0.372533, 0.560956>
  }
  no_shadow
  scale <1.383724, 1.0, 1.162014>
  rotate <-180.0, 89.412827, -180.0>
  translate  <4.290338, 8.452937, 7.012882>
}
#declare bicubic0_8 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.035500, 0.406400, 0.104000>, <-0.044700, 0.330800, 0.147600>, <-0.057100, 0.230000, 0.205800>, <-0.066300, 0.154400, 0.249400>,
      <-0.031300, 0.406400, 0.105000>, <-0.040500, 0.330800, 0.148600>, <-0.050000, 0.236100, 0.206500>, <-0.059200, 0.160500, 0.250100>,
      <-0.025500, 0.409200, 0.102400>, <-0.031900, 0.338900, 0.146900>, <-0.037400, 0.253100, 0.211800>, <-0.043800, 0.182900, 0.256300>,
      <-0.021400, 0.409100, 0.103500>, <-0.027700, 0.338800, 0.147900>, <-0.036200, 0.245100, 0.207200>, <-0.042600, 0.174800, 0.251700>
    }
  }
}
#declare bicubic1_9 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.035500, 0.406400, 0.104000>, <-0.039200, 0.406400, 0.103100>, <-0.042500, 0.409200, 0.098500>, <-0.046200, 0.409100, 0.097600>,
      <-0.044700, 0.330800, 0.147600>, <-0.048500, 0.330800, 0.146800>, <-0.055800, 0.339200, 0.141000>, <-0.059600, 0.339100, 0.140100>,
      <-0.057100, 0.230000, 0.205800>, <-0.064400, 0.236500, 0.202800>, <-0.068600, 0.242200, 0.200700>, <-0.077400, 0.245900, 0.196800>,
      <-0.066300, 0.154400, 0.249400>, <-0.073600, 0.160900, 0.246400>, <-0.082000, 0.172300, 0.243200>, <-0.090800, 0.175900, 0.239300>
    }
  }
}
#declare bicubic2_10 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.021400, 0.409100, 0.103500>, <-0.027700, 0.338800, 0.147900>, <-0.036200, 0.245100, 0.207200>, <-0.042600, 0.174800, 0.251700>,
      <-0.018700, 0.409000, 0.104100>, <-0.025100, 0.338700, 0.148600>, <-0.030000, 0.202700, 0.182800>, <-0.036400, 0.132400, 0.227300>,
      <-0.017700, 0.406300, 0.108400>, <-0.027500, 0.293100, 0.128800>, <-0.048900, 0.183300, 0.180800>, <-0.058700, 0.070000, 0.201100>,
      <-0.015100, 0.405900, 0.109200>, <-0.024900, 0.292700, 0.129500>, <-0.038000, 0.141700, 0.156700>, <-0.047800, 0.028400, 0.177100>
    }
  }
}
#declare bicubic3_11 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.015100, 0.405900, 0.109200>, <-0.024900, 0.292700, 0.129500>, <-0.038000, 0.141700, 0.156700>, <-0.047800, 0.028400, 0.177100>,
      <-0.011600, 0.405400, 0.110300>, <-0.021400, 0.292100, 0.130600>, <-0.035100, 0.130800, 0.150400>, <-0.044900, 0.017600, 0.170800>,
      <-0.006400, 0.406100, 0.109200>, <-0.008200, 0.298000, 0.129500>, <-0.019600, 0.155500, 0.156700>, <-0.021400, 0.047500, 0.177100>,
      <-0.002600, 0.406100, 0.109200>, <-0.004400, 0.298000, 0.129500>, <-0.006900, 0.154000, 0.156700>, <-0.008700, 0.045900, 0.177100>
    }
  }
}
#declare bicubic4_12 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.002600, 0.406100, 0.109200>, <-0.004400, 0.298000, 0.129500>, <-0.006900, 0.154000, 0.156700>, <-0.008700, 0.045900, 0.177100>,
      <0.001100, 0.406100, 0.109200>, <-0.000700, 0.298000, 0.129500>, <0.003800, 0.152700, 0.156700>, <0.002000, 0.044600, 0.177100>,
      <0.006300, 0.405400, 0.110300>, <0.008400, 0.289700, 0.130600>, <0.004900, 0.140800, 0.156700>, <0.007000, 0.025200, 0.177100>,
      <0.009800, 0.405900, 0.109200>, <0.011900, 0.290300, 0.129500>, <0.014600, 0.136200, 0.156700>, <0.016700, 0.020500, 0.177100>
    }
  }
}
#declare bicubic5_13 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.009800, 0.405900, 0.109200>, <0.011900, 0.290300, 0.129500>, <0.014600, 0.136200, 0.156700>, <0.016700, 0.020500, 0.177100>,
      <0.012400, 0.406300, 0.108400>, <0.014500, 0.290700, 0.128800>, <0.019000, 0.134100, 0.156700>, <0.021000, 0.018500, 0.177100>,
      <0.013500, 0.409000, 0.104300>, <0.018100, 0.294300, 0.126400>, <0.023100, 0.144500, 0.155000>, <0.027600, 0.029800, 0.177100>,
      <0.016100, 0.409100, 0.103500>, <0.020700, 0.294400, 0.125500>, <0.026800, 0.141500, 0.155000>, <0.031400, 0.026800, 0.177100>
    }
  }
}
#declare bicubic6_14 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.016100, 0.409100, 0.103500>, <0.020700, 0.294400, 0.125500>, <0.026800, 0.141500, 0.155000>, <0.031400, 0.026800, 0.177100>,
      <0.019700, 0.409200, 0.102300>, <0.024200, 0.294500, 0.124400>, <0.037300, 0.133000, 0.154900>, <0.041900, 0.018300, 0.176900>,
      <0.024800, 0.406400, 0.104600>, <0.033100, 0.281100, 0.126600>, <0.034800, 0.114100, 0.159000>, <0.043100, -0.011200, 0.181100>,
      <0.028300, 0.406400, 0.103100>, <0.036600, 0.281100, 0.125200>, <0.047700, 0.114100, 0.154600>, <0.056000, -0.011200, 0.176600>
    }
  }
}
#declare bicubic7_15 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.016100, 0.409100, 0.103500>, <0.019700, 0.409200, 0.102300>, <0.024800, 0.406400, 0.104600>, <0.028300, 0.406400, 0.103100>,
      <0.020700, 0.294400, 0.125500>, <0.024200, 0.294500, 0.124400>, <0.033100, 0.281100, 0.126600>, <0.036600, 0.281100, 0.125200>,
      <0.026800, 0.141500, 0.155000>, <0.037300, 0.133000, 0.154900>, <0.034800, 0.114100, 0.159000>, <0.047700, 0.114100, 0.154600>,
      <0.031400, 0.026800, 0.177100>, <0.041900, 0.018300, 0.176900>, <0.043100, -0.011200, 0.181100>, <0.056000, -0.011200, 0.176600>
    }
  }
}
#declare bicubic8_16 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.028300, 0.406400, 0.103100>, <0.036600, 0.281100, 0.125200>, <0.047700, 0.114100, 0.154600>, <0.056000, -0.011200, 0.176600>,
      <0.031600, 0.406400, 0.101800>, <0.039900, 0.281100, 0.123900>, <0.061200, 0.114100, 0.149900>, <0.069500, -0.011200, 0.172000>,
      <0.033200, 0.409200, 0.096600>, <0.046200, 0.294500, 0.116100>, <0.057600, 0.132600, 0.147400>, <0.070500, 0.017900, 0.167000>,
      <0.036500, 0.409100, 0.095200>, <0.049400, 0.294400, 0.114800>, <0.066600, 0.141500, 0.140900>, <0.079600, 0.026800, 0.160400>
    }
  }
}
#declare bicubic9_17 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.028300, 0.406400, 0.103100>, <0.031600, 0.406400, 0.101800>, <0.033200, 0.409200, 0.096600>, <0.036500, 0.409100, 0.095200>,
      <0.036600, 0.281100, 0.125200>, <0.039900, 0.281100, 0.123900>, <0.046200, 0.294500, 0.116100>, <0.049400, 0.294400, 0.114800>,
      <0.047700, 0.114100, 0.154600>, <0.061200, 0.114100, 0.149900>, <0.057600, 0.132600, 0.147400>, <0.066600, 0.141500, 0.140900>,
      <0.056000, -0.011200, 0.176600>, <0.069500, -0.011200, 0.172000>, <0.070500, 0.017900, 0.167000>, <0.079600, 0.026800, 0.160400>
    }
  }
}
#declare bicubic10_18 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.036500, 0.409100, 0.095200>, <0.049400, 0.294400, 0.114800>, <0.066600, 0.141500, 0.140900>, <0.079600, 0.026800, 0.160400>,
      <0.038300, 0.409000, 0.094400>, <0.051200, 0.294300, 0.114000>, <0.069100, 0.143900, 0.139100>, <0.082000, 0.029200, 0.158700>,
      <0.039800, 0.406300, 0.098000>, <0.053800, 0.290700, 0.114800>, <0.071400, 0.134400, 0.138600>, <0.085400, 0.018800, 0.155400>,
      <0.041700, 0.405900, 0.097500>, <0.055600, 0.290300, 0.114300>, <0.074200, 0.136200, 0.136700>, <0.088200, 0.020500, 0.153500>
    }
  }
}
#declare bicubic11_19 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.041700, 0.405900, 0.097500>, <0.055600, 0.290300, 0.114300>, <0.074200, 0.136200, 0.136700>, <0.088200, 0.020500, 0.153500>,
      <0.045200, 0.405300, 0.096400>, <0.059200, 0.289600, 0.113200>, <0.082000, 0.141200, 0.131200>, <0.095900, 0.025500, 0.148000>,
      <0.049000, 0.406100, 0.092700>, <0.066100, 0.298000, 0.107300>, <0.083200, 0.154000, 0.130800>, <0.100300, 0.045900, 0.145400>,
      <0.052100, 0.406100, 0.090600>, <0.069300, 0.298000, 0.105300>, <0.092200, 0.154000, 0.124800>, <0.109300, 0.045900, 0.139500>
    }
  }
}
#declare bicubic12_20 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.052100, 0.406100, 0.090600>, <0.069300, 0.298000, 0.105300>, <0.092200, 0.154000, 0.124800>, <0.109300, 0.045900, 0.139500>,
      <0.055200, 0.406100, 0.088500>, <0.072400, 0.298000, 0.103200>, <0.101100, 0.154000, 0.118900>, <0.118300, 0.045900, 0.133600>,
      <0.059900, 0.405400, 0.086400>, <0.080300, 0.289800, 0.098900>, <0.101900, 0.140800, 0.118100>, <0.122200, 0.025200, 0.130700>,
      <0.062500, 0.405900, 0.083700>, <0.082900, 0.290300, 0.096300>, <0.110100, 0.136200, 0.113000>, <0.130500, 0.020500, 0.125500>
    }
  }
}
#declare bicubic13_21 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.062500, 0.405900, 0.083700>, <0.082900, 0.290300, 0.096300>, <0.110100, 0.136200, 0.113000>, <0.130500, 0.020500, 0.125500>,
      <0.064800, 0.406400, 0.081400>, <0.085200, 0.290800, 0.093900>, <0.113700, 0.134100, 0.110800>, <0.134100, 0.018500, 0.123300>,
      <0.065500, 0.409200, 0.077000>, <0.088100, 0.294500, 0.090200>, <0.117400, 0.143800, 0.108100>, <0.140000, 0.029200, 0.121300>,
      <0.067700, 0.409100, 0.074600>, <0.090300, 0.294400, 0.087800>, <0.120500, 0.141500, 0.105400>, <0.143100, 0.026800, 0.118600>
    }
  }
}
#declare bicubic14_22 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.067700, 0.409100, 0.074600>, <0.090300, 0.294400, 0.087800>, <0.120500, 0.141500, 0.105400>, <0.143100, 0.026800, 0.118600>,
      <0.070500, 0.408900, 0.071700>, <0.093100, 0.294300, 0.084900>, <0.127800, 0.135800, 0.098600>, <0.150500, 0.021100, 0.111800>,
      <0.075900, 0.405200, 0.070500>, <0.100300, 0.283000, 0.080100>, <0.129800, 0.133000, 0.094100>, <0.155200, 0.005500, 0.104100>,
      <0.078100, 0.405200, 0.067200>, <0.102500, 0.283000, 0.076800>, <0.134000, 0.125600, 0.089100>, <0.159500, -0.001900, 0.099100>
    }
  }
}
#declare bicubic15_23 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.159500, -0.001900, 0.099100>, <0.164000, 0.007100, 0.092600>, <0.169300, 0.020800, 0.087000>, <0.174100, 0.026800, 0.078500>,
      <0.134000, 0.125600, 0.089100>, <0.138600, 0.134600, 0.082600>, <0.141400, 0.135500, 0.080200>, <0.146100, 0.141500, 0.071600>,
      <0.102500, 0.283000, 0.076800>, <0.104700, 0.283000, 0.073700>, <0.107300, 0.294200, 0.065900>, <0.108800, 0.294400, 0.062500>,
      <0.078100, 0.405200, 0.067200>, <0.080300, 0.405200, 0.064100>, <0.079300, 0.408900, 0.059000>, <0.080900, 0.409100, 0.055600>
    }
  }
}
#declare bicubic16_24 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.080900, 0.409100, 0.055600>, <0.108800, 0.294400, 0.062500>, <0.146100, 0.141500, 0.071600>, <0.174100, 0.026800, 0.078500>,
      <0.081400, 0.409200, 0.054500>, <0.109300, 0.294500, 0.061400>, <0.147800, 0.143600, 0.068600>, <0.175700, 0.028900, 0.075400>,
      <0.082700, 0.406300, 0.056600>, <0.110900, 0.290700, 0.060000>, <0.147700, 0.134300, 0.066900>, <0.175900, 0.018700, 0.070300>,
      <0.083400, 0.405900, 0.055600>, <0.111500, 0.290300, 0.059000>, <0.149000, 0.136200, 0.063500>, <0.177200, 0.020500, 0.066900>
    }
  }
}
#declare bicubic17_25 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.083400, 0.405900, 0.055600>, <0.111500, 0.290300, 0.059000>, <0.149000, 0.136200, 0.063500>, <0.177200, 0.020500, 0.066900>,
      <0.085400, 0.404800, 0.052600>, <0.113500, 0.289200, 0.056000>, <0.152500, 0.141100, 0.054600>, <0.180600, 0.025500, 0.057900>,
      <0.086900, 0.404800, 0.047600>, <0.116600, 0.297200, 0.047500>, <0.153400, 0.153600, 0.053700>, <0.183100, 0.045900, 0.053500>,
      <0.088400, 0.404800, 0.044200>, <0.118100, 0.297200, 0.044100>, <0.157700, 0.153600, 0.043800>, <0.187400, 0.045900, 0.043700>
    }
  }
}
#declare bicubic18_26 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.088400, 0.404800, 0.044200>, <0.118100, 0.297200, 0.044100>, <0.157700, 0.153600, 0.043800>, <0.187400, 0.045900, 0.043700>,
      <0.090000, 0.404800, 0.040800>, <0.119700, 0.297200, 0.040600>, <0.162100, 0.153600, 0.034000>, <0.191800, 0.045900, 0.033800>,
      <0.092300, 0.405300, 0.036300>, <0.123600, 0.289700, 0.032600>, <0.162100, 0.140900, 0.032800>, <0.193400, 0.025300, 0.029100>,
      <0.093500, 0.405900, 0.032800>, <0.124700, 0.290300, 0.029100>, <0.166400, 0.136200, 0.024200>, <0.197700, 0.020500, 0.020500>
    }
  }
}
#declare bicubic19_27 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.093500, 0.405900, 0.032800>, <0.124700, 0.290300, 0.029100>, <0.166400, 0.136200, 0.024200>, <0.197700, 0.020500, 0.020500>,
      <0.094600, 0.406600, 0.029400>, <0.125900, 0.290900, 0.025700>, <0.168200, 0.134200, 0.020600>, <0.199500, 0.018600, 0.016900>,
      <0.095000, 0.409000, 0.024800>, <0.127600, 0.294300, 0.021100>, <0.170600, 0.144500, 0.015600>, <0.203300, 0.029800, 0.011900>,
      <0.096000, 0.409100, 0.021400>, <0.128700, 0.294400, 0.017600>, <0.172200, 0.141500, 0.012600>, <0.204800, 0.026800, 0.008900>
    }
  }
}
#declare bicubic20_28 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.096000, 0.409100, 0.021400>, <0.128700, 0.294400, 0.017600>, <0.172200, 0.141500, 0.012600>, <0.204800, 0.026800, 0.008900>,
      <0.096900, 0.409200, 0.018300>, <0.129600, 0.294500, 0.014500>, <0.176600, 0.132700, 0.004100>, <0.209300, 0.018000, 0.000300>,
      <0.098600, 0.407200, 0.014600>, <0.098600, 0.407200, 0.012700>, <0.175200, 0.114100, 0.008600>, <0.209400, -0.011200, 0.001900>,
      <0.099800, 0.406400, 0.011700>, <0.099800, 0.406400, 0.009800>, <0.179600, 0.114100, -0.003800>, <0.213800, -0.011200, -0.010400>
    }
  }
}
#declare bicubic21_29 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.096000, 0.409100, 0.021400>, <0.096900, 0.409200, 0.018300>, <0.098600, 0.407200, 0.014600>, <0.099800, 0.406400, 0.011700>,
      <0.128700, 0.294400, 0.017600>, <0.129600, 0.294500, 0.014500>, <0.098600, 0.407200, 0.012700>, <0.099800, 0.406400, 0.009800>,
      <0.172200, 0.141500, 0.012600>, <0.176600, 0.132700, 0.004100>, <0.175200, 0.114100, 0.008600>, <0.179600, 0.114100, -0.003800>,
      <0.204800, 0.026800, 0.008900>, <0.209300, 0.018000, 0.000300>, <0.209400, -0.011200, 0.001900>, <0.213800, -0.011200, -0.010400>
    }
  }
}
#declare bicubic22_30 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.213800, -0.011200, -0.010400>, <0.217600, -0.011200, -0.021300>, <0.215100, 0.016000, -0.012800>, <0.213800, 0.026800, -0.016500>,
      <0.179600, 0.114100, -0.003800>, <0.183400, 0.114100, -0.014700>, <0.182000, 0.130600, -0.009100>, <0.180700, 0.141500, -0.012800>,
      <0.099800, 0.406400, 0.009800>, <0.100900, 0.407200, 0.005000>, <0.135200, 0.294500, -0.003100>, <0.136500, 0.294400, -0.007800>,
      <0.099800, 0.406400, 0.011700>, <0.100900, 0.407200, 0.006900>, <0.102100, 0.409200, 0.000600>, <0.103400, 0.409100, -0.004100>
    }
  }
}
#declare bicubic23_31 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.213800, -0.011200, -0.010400>, <0.179600, 0.114100, -0.003800>, <0.099800, 0.406400, 0.009800>, <0.099800, 0.406400, 0.011700>,
      <0.217600, -0.011200, -0.021300>, <0.183400, 0.114100, -0.014700>, <0.100900, 0.407200, 0.005000>, <0.100900, 0.407200, 0.006900>,
      <0.215100, 0.016000, -0.012800>, <0.182000, 0.130600, -0.009100>, <0.135200, 0.294500, -0.003100>, <0.102100, 0.409200, 0.000600>,
      <0.213800, 0.026800, -0.016500>, <0.180700, 0.141500, -0.012800>, <0.136500, 0.294400, -0.007800>, <0.103400, 0.409100, -0.004100>
    }
  }
}
#declare bicubic24_32 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.113100, 0.409100, -0.029100>, <-0.147800, 0.294400, -0.051500>, <-0.194000, 0.141500, -0.081400>, <-0.228700, 0.026800, -0.103800>,
      <-0.116800, 0.409100, -0.028900>, <-0.151500, 0.294400, -0.051300>, <-0.195100, 0.139600, -0.077600>, <-0.229700, 0.024900, -0.100000>,
      <-0.113500, 0.406700, -0.020800>, <-0.149000, 0.291100, -0.043000>, <-0.196000, 0.134200, -0.072800>, <-0.231600, 0.018600, -0.095000>,
      <-0.113800, 0.405900, -0.017200>, <-0.149400, 0.290300, -0.039400>, <-0.196700, 0.136200, -0.069000>, <-0.232300, 0.020500, -0.091200>
    }
  }
}
#declare bicubic25_33 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.113800, 0.405900, -0.017200>, <-0.149400, 0.290300, -0.039400>, <-0.196700, 0.136200, -0.069000>, <-0.232300, 0.020500, -0.091200>,
      <-0.114200, 0.405100, -0.013500>, <-0.149700, 0.289500, -0.035700>, <-0.198400, 0.141000, -0.059500>, <-0.233900, 0.025300, -0.081700>,
      <-0.114900, 0.403600, -0.008600>, <-0.150900, 0.296300, -0.026900>, <-0.198100, 0.153200, -0.058300>, <-0.234100, 0.045900, -0.076700>,
      <-0.115400, 0.403600, -0.004800>, <-0.151400, 0.296300, -0.023200>, <-0.199400, 0.153200, -0.047700>, <-0.235400, 0.045900, -0.066000>
    }
  }
}
#declare bicubic26_34 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.115400, 0.403600, -0.004800>, <-0.151400, 0.296300, -0.023200>, <-0.199400, 0.153200, -0.047700>, <-0.235400, 0.045900, -0.066000>,
      <-0.115900, 0.403600, -0.001000>, <-0.151900, 0.296300, -0.019400>, <-0.200700, 0.153200, -0.037000>, <-0.236700, 0.045900, -0.055400>,
      <-0.116300, 0.404500, 0.004100>, <-0.152800, 0.288800, -0.010400>, <-0.203000, 0.141000, -0.035900>, <-0.239400, 0.025400, -0.050400>,
      <-0.116900, 0.405900, 0.007600>, <-0.153400, 0.290300, -0.006900>, <-0.202100, 0.136200, -0.026300>, <-0.238600, 0.020500, -0.040900>
    }
  }
}
#declare bicubic27_35 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.116900, 0.405900, 0.007600>, <-0.153400, 0.290300, -0.006900>, <-0.202100, 0.136200, -0.026300>, <-0.238600, 0.020500, -0.040900>,
      <-0.117100, 0.406300, 0.008500>, <-0.153600, 0.290700, -0.006000>, <-0.201700, 0.134100, -0.022200>, <-0.238200, 0.018500, -0.036700>,
      <-0.117600, 0.409100, 0.007100>, <-0.151800, 0.294500, -0.003800>, <-0.197400, 0.144500, -0.020900>, <-0.231700, 0.029900, -0.031800>,
      <-0.117700, 0.409100, 0.008100>, <-0.152000, 0.294400, -0.002800>, <-0.197600, 0.141500, -0.017400>, <-0.231900, 0.026800, -0.028300>
    }
  }
}
#declare bicubic28_36 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.117700, 0.409100, 0.008100>, <-0.152000, 0.294400, -0.002800>, <-0.197600, 0.141500, -0.017400>, <-0.231900, 0.026800, -0.028300>,
      <-0.118300, 0.408900, 0.011900>, <-0.152600, 0.294200, 0.001000>, <-0.198300, 0.132500, -0.006900>, <-0.232500, 0.017800, -0.017800>,
      <-0.119900, 0.405200, 0.016500>, <-0.156500, 0.280300, 0.009300>, <-0.205400, 0.113700, -0.010400>, <-0.241900, -0.011200, -0.017600>,
      <-0.118900, 0.405200, 0.020300>, <-0.155500, 0.280300, 0.013000>, <-0.204200, 0.113700, 0.003400>, <-0.240800, -0.011200, -0.003800>
    }
  }
}
#declare bicubic29_37 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.117700, 0.409100, 0.008100>, <-0.118300, 0.408900, 0.011900>, <-0.119900, 0.405200, 0.016500>, <-0.118900, 0.405200, 0.020300>,
      <-0.152000, 0.294400, -0.002800>, <-0.152600, 0.294200, 0.001000>, <-0.156500, 0.280300, 0.009300>, <-0.155500, 0.280300, 0.013000>,
      <-0.197600, 0.141500, -0.017400>, <-0.198300, 0.132500, -0.006900>, <-0.205400, 0.113700, -0.010400>, <-0.204200, 0.113700, 0.003400>,
      <-0.231900, 0.026800, -0.028300>, <-0.232500, 0.017800, -0.017800>, <-0.241900, -0.011200, -0.017600>, <-0.240800, -0.011200, -0.003800>
    }
  }
}
#declare bicubic30_38 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.118900, 0.405200, 0.020300>, <-0.155500, 0.280300, 0.013000>, <-0.204200, 0.113700, 0.003400>, <-0.240800, -0.011200, -0.003800>,
      <-0.118000, 0.405200, 0.023700>, <-0.154500, 0.280300, 0.016500>, <-0.203000, 0.113700, 0.017600>, <-0.239500, -0.011200, 0.010400>,
      <-0.113600, 0.409000, 0.026100>, <-0.148300, 0.294300, 0.023700>, <-0.197600, 0.132700, 0.013700>, <-0.232300, 0.018000, 0.011400>,
      <-0.112100, 0.409100, 0.029300>, <-0.146700, 0.294400, 0.027000>, <-0.193000, 0.141500, 0.023900>, <-0.227600, 0.026800, 0.021600>
    }
  }
}
#declare bicubic31_39 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.118900, 0.405200, 0.020300>, <-0.118000, 0.405200, 0.023700>, <-0.113600, 0.409000, 0.026100>, <-0.112100, 0.409100, 0.029300>,
      <-0.155500, 0.280300, 0.013000>, <-0.154500, 0.280300, 0.016500>, <-0.148300, 0.294300, 0.023700>, <-0.146700, 0.294400, 0.027000>,
      <-0.204200, 0.113700, 0.003400>, <-0.203000, 0.113700, 0.017600>, <-0.197600, 0.132700, 0.013700>, <-0.193000, 0.141500, 0.023900>,
      <-0.240800, -0.011200, -0.003800>, <-0.239500, -0.011200, 0.010400>, <-0.232300, 0.018000, 0.011400>, <-0.227600, 0.026800, 0.021600>
    }
  }
}
#declare bicubic32_40 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.112100, 0.409100, 0.029300>, <-0.146700, 0.294400, 0.027000>, <-0.193000, 0.141500, 0.023900>, <-0.227600, 0.026800, 0.021600>,
      <-0.110500, 0.409200, 0.032600>, <-0.145200, 0.294500, 0.030300>, <-0.191600, 0.144000, 0.026800>, <-0.226300, 0.029300, 0.024500>,
      <-0.110500, 0.406400, 0.037300>, <-0.145000, 0.290800, 0.035000>, <-0.191000, 0.134300, 0.032000>, <-0.225500, 0.018700, 0.029700>,
      <-0.109300, 0.405900, 0.040700>, <-0.143700, 0.290300, 0.038300>, <-0.189600, 0.136200, 0.035300>, <-0.224000, 0.020500, 0.033000>
    }
  }
}
#declare bicubic33_41 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.109300, 0.405900, 0.040700>, <-0.143700, 0.290300, 0.038300>, <-0.189600, 0.136200, 0.035300>, <-0.224000, 0.020500, 0.033000>,
      <-0.108000, 0.405500, 0.044100>, <-0.142400, 0.289900, 0.041800>, <-0.185800, 0.141100, 0.044000>, <-0.220200, 0.025500, 0.041700>,
      <-0.105400, 0.406100, 0.048500>, <-0.138100, 0.298000, 0.049600>, <-0.186800, 0.154300, 0.046100>, <-0.219500, 0.046300, 0.047300>,
      <-0.103800, 0.406100, 0.051800>, <-0.136500, 0.298000, 0.053000>, <-0.180100, 0.154000, 0.054500>, <-0.212800, 0.045900, 0.055700>
    }
  }
}
#declare bicubic34_42 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.103800, 0.406100, 0.051800>, <-0.136500, 0.298000, 0.053000>, <-0.180100, 0.154000, 0.054500>, <-0.212800, 0.045900, 0.055700>,
      <-0.102100, 0.406100, 0.055200>, <-0.134800, 0.298000, 0.056400>, <-0.172000, 0.153500, 0.064700>, <-0.204700, 0.045500, 0.065900>,
      <-0.100400, 0.405100, 0.060100>, <-0.127300, 0.288900, 0.064700>, <-0.172300, 0.135100, 0.067400>, <-0.199200, 0.018800, 0.072000>,
      <-0.098200, 0.405900, 0.063000>, <-0.125100, 0.289700, 0.067700>, <-0.160900, 0.134800, 0.073800>, <-0.187800, 0.018600, 0.078400>
    }
  }
}
#declare bicubic35_43 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.098200, 0.405900, 0.063000>, <-0.125100, 0.289700, 0.067700>, <-0.160900, 0.134800, 0.073800>, <-0.187800, 0.018600, 0.078400>,
      <-0.097500, 0.406200, 0.064000>, <-0.124400, 0.290000, 0.068600>, <-0.149200, 0.134500, 0.080500>, <-0.176000, 0.018300, 0.085100>,
      <-0.096300, 0.409000, 0.062000>, <-0.113500, 0.299700, 0.070000>, <-0.136500, 0.143400, 0.073300>, <-0.153700, 0.034000, 0.081400>,
      <-0.095500, 0.409100, 0.062900>, <-0.112600, 0.299700, 0.071000>, <-0.135500, 0.153900, 0.081700>, <-0.152700, 0.044500, 0.089800>
    }
  }
}
#declare bicubic36_44 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.095500, 0.409100, 0.062900>, <-0.112600, 0.299700, 0.071000>, <-0.135500, 0.153900, 0.081700>, <-0.152700, 0.044500, 0.089800>,
      <-0.092800, 0.409200, 0.066000>, <-0.109900, 0.299800, 0.074000>, <-0.132300, 0.187000, 0.108300>, <-0.149500, 0.077700, 0.116400>,
      <-0.091300, 0.406400, 0.071400>, <-0.117400, 0.329200, 0.104100>, <-0.142200, 0.202700, 0.124900>, <-0.169400, 0.122100, 0.159000>,
      <-0.088300, 0.406400, 0.074200>, <-0.114400, 0.329200, 0.106800>, <-0.148000, 0.229800, 0.149000>, <-0.175200, 0.149200, 0.183100>
    }
  }
}
#declare bicubic37_45 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.175200, 0.149200, 0.183100>, <-0.169200, 0.158000, 0.188400>, <-0.163500, 0.171600, 0.193800>, <-0.155900, 0.177500, 0.200100>,
      <-0.148000, 0.229800, 0.149000>, <-0.142000, 0.238600, 0.154300>, <-0.140200, 0.241100, 0.157200>, <-0.132600, 0.247000, 0.163600>,
      <-0.114400, 0.329200, 0.106800>, <-0.111900, 0.329200, 0.109100>, <-0.104100, 0.339700, 0.112700>, <-0.101600, 0.339600, 0.114800>,
      <-0.088300, 0.406400, 0.074200>, <-0.085800, 0.406400, 0.076400>, <-0.080800, 0.409200, 0.076100>, <-0.078300, 0.409100, 0.078300>
    }
  }
}
#declare bicubic38_46 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.078300, 0.409100, 0.078300>, <-0.101600, 0.339600, 0.114800>, <-0.132600, 0.247000, 0.163600>, <-0.155900, 0.177500, 0.200100>,
      <-0.075800, 0.409000, 0.080400>, <-0.099100, 0.339500, 0.117000>, <-0.130100, 0.248900, 0.165700>, <-0.153400, 0.179400, 0.202200>,
      <-0.075300, 0.406200, 0.085000>, <-0.097600, 0.335700, 0.120800>, <-0.127800, 0.239800, 0.169000>, <-0.150100, 0.169300, 0.204900>,
      <-0.072900, 0.405900, 0.087200>, <-0.095200, 0.335500, 0.123100>, <-0.124900, 0.241500, 0.170800>, <-0.147200, 0.171000, 0.206700>
    }
  }
}
#declare bicubic39_47 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.072900, 0.405900, 0.087200>, <-0.095200, 0.335500, 0.123100>, <-0.124900, 0.241500, 0.170800>, <-0.147200, 0.171000, 0.206700>,
      <-0.070200, 0.405600, 0.089800>, <-0.092500, 0.335100, 0.125700>, <-0.116800, 0.246300, 0.176000>, <-0.139100, 0.175800, 0.211800>,
      <-0.065500, 0.407300, 0.091700>, <-0.084300, 0.343900, 0.129500>, <-0.032400, 0.539500, 0.009500>, <-0.134100, 0.196000, 0.214200>,
      <-0.062200, 0.407300, 0.093700>, <-0.081000, 0.343900, 0.131500>, <-0.023200, 0.539200, 0.015000>, <-0.124900, 0.195800, 0.219700>
    }
  }
}
#declare bicubic40_48 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.062200, 0.407300, 0.093700>, <-0.081000, 0.343900, 0.131500>, <-0.023200, 0.539200, 0.015000>, <-0.124900, 0.195800, 0.219700>,
      <-0.059000, 0.407300, 0.095600>, <-0.077800, 0.343900, 0.133400>, <-0.014000, 0.539000, 0.020600>, <-0.115700, 0.195600, 0.225300>,
      <-0.055200, 0.405500, 0.099200>, <-0.070900, 0.334700, 0.139000>, <-0.096400, 0.245600, 0.188200>, <-0.112100, 0.174800, 0.228000>,
      <-0.051600, 0.405900, 0.100100>, <-0.067200, 0.335100, 0.139900>, <-0.088100, 0.240800, 0.193000>, <-0.103800, 0.170000, 0.232800>
    }
  }
}
#declare bicubic41_49 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.051600, 0.405900, 0.100100>, <-0.067200, 0.335100, 0.139900>, <-0.088100, 0.240800, 0.193000>, <-0.103800, 0.170000, 0.232800>,
      <-0.049600, 0.406100, 0.100600>, <-0.065300, 0.335400, 0.140400>, <-0.084400, 0.238600, 0.195100>, <-0.100100, 0.167800, 0.234900>,
      <-0.048200, 0.409000, 0.097100>, <-0.061500, 0.339100, 0.139600>, <-0.081400, 0.247500, 0.195000>, <-0.094800, 0.177600, 0.237500>,
      <-0.046200, 0.409100, 0.097600>, <-0.059600, 0.339100, 0.140100>, <-0.077400, 0.245900, 0.196800>, <-0.090800, 0.175900, 0.239300>
    }
  }
}
#declare bicubic42_50 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.103400, 0.409100, -0.004100>, <0.136500, 0.294400, -0.007800>, <0.180700, 0.141500, -0.012800>, <0.213800, 0.026800, -0.016500>,
      <0.103700, 0.409100, -0.005100>, <0.136800, 0.294400, -0.008800>, <0.180400, 0.144000, -0.013600>, <0.213500, 0.029300, -0.017300>,
      <0.104200, 0.406300, -0.003700>, <0.135900, 0.290700, -0.008700>, <0.178200, 0.134700, -0.014000>, <0.209900, 0.019100, -0.019000>,
      <0.104400, 0.405900, -0.004600>, <0.136000, 0.290300, -0.009600>, <0.178200, 0.136200, -0.016200>, <0.209900, 0.020500, -0.021200>
    }
  }
}
#declare bicubic43_51 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.104400, 0.405900, -0.004600>, <0.136000, 0.290300, -0.009600>, <0.178200, 0.136200, -0.016200>, <0.209900, 0.020500, -0.021200>,
      <0.104800, 0.404500, -0.008000>, <0.136500, 0.288800, -0.013000>, <0.178200, 0.142000, -0.025300>, <0.209900, 0.026300, -0.030300>,
      <0.104500, 0.403600, -0.013200>, <0.137100, 0.296300, -0.022000>, <0.179500, 0.153200, -0.026900>, <0.212100, 0.045900, -0.035700>,
      <0.105000, 0.403600, -0.016900>, <0.137700, 0.296300, -0.025700>, <0.181100, 0.153200, -0.037500>, <0.213800, 0.045900, -0.046300>
    }
  }
}
#declare bicubic44_52 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.105000, 0.403600, -0.016900>, <0.137700, 0.296300, -0.025700>, <0.181100, 0.153200, -0.037500>, <0.213800, 0.045900, -0.046300>,
      <0.105600, 0.403600, -0.020700>, <0.138300, 0.296300, -0.029600>, <0.182800, 0.153200, -0.048100>, <0.215400, 0.045900, -0.056900>,
      <0.112100, 0.405800, -0.029000>, <0.144900, 0.290200, -0.041700>, <0.182800, 0.141000, -0.049300>, <0.215700, 0.025300, -0.061900>,
      <0.108200, 0.405900, -0.029200>, <0.141000, 0.290300, -0.041900>, <0.184800, 0.136200, -0.058700>, <0.217700, 0.020500, -0.071400>
    }
  }
}
#declare Skirt2 = union {
  object { bicubic0_8 }
  object { bicubic1_9 }
  object { bicubic2_10 }
  object { bicubic3_11 }
  object { bicubic4_12 }
  object { bicubic5_13 }
  object { bicubic6_14 }
  object { bicubic7_15 }
  object { bicubic8_16 }
  object { bicubic9_17 }
  object { bicubic10_18 }
  object { bicubic11_19 }
  object { bicubic12_20 }
  object { bicubic13_21 }
  object { bicubic14_22 }
  object { bicubic15_23 }
  object { bicubic16_24 }
  object { bicubic17_25 }
  object { bicubic18_26 }
  object { bicubic19_27 }
  object { bicubic20_28 }
  object { bicubic21_29 }
  object { bicubic22_30 }
  object { bicubic23_31 }
  object { bicubic24_32 }
  object { bicubic25_33 }
  object { bicubic26_34 }
  object { bicubic27_35 }
  object { bicubic28_36 }
  object { bicubic29_37 }
  object { bicubic30_38 }
  object { bicubic31_39 }
  object { bicubic32_40 }
  object { bicubic33_41 }
  object { bicubic34_42 }
  object { bicubic35_43 }
  object { bicubic36_44 }
  object { bicubic37_45 }
  object { bicubic38_46 }
  object { bicubic39_47 }
  object { bicubic40_48 }
  object { bicubic41_49 }
  object { bicubic42_50 }
  object { bicubic43_51 }
  object { bicubic44_52 }
  texture {
    SkirtTex
  }
  scale <62.0, 60.0, 60.0>
  rotate 90.0*x
  translate  <-0.274318, 0.647315, -16.875429>
}
#declare Waist4 = difference {
  cone { // cone0_19
    <0,0,0>, 10.0, <0,0,1>, 8.0
    scale <0.8, 0.5, 21.0>
  }
  torus { // Torus22
    8.75, 4.0  rotate -x*90
    texture {
      BodiceTex2
    }
    scale <0.9, 1.262274, 2.6>
    rotate <0.0, 0.0, -90.0>
    translate  <-0.069344, 0.577916, 13.5>
  }
  rotate <90.0, 0.0, 180.0>
}
#declare Shirt_B_4 = union {
  cone { // cone0_18
    <0,0,0>, 10.0, <0,0,1>, 8.0
    scale <0.01, 0.00625, 0.2625>
    rotate 270.0*x
  }
  sphere { // sphere0_15
    <0,0,0>,1
    scale <8.0, 4.0, 4.0>
    translate  21.0*y
  }
  cylinder { // cylinde0_16
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 16.0>
    rotate 90.0*y
    translate  <-8.0, 21.0, 0.0>
  }
  sphere { // sphere1_17
    <0,0,0>,1
    scale 3.0
    translate  <-8.0, 21.0, 0.0>
  }
  sphere { // sphere2_18
    <0,0,0>,1
    scale 3.0
    translate  <8.0, 21.0, 0.0>
  }
  object { Waist4 }
}
#declare Shirt_16 = union {
  object { Shirt_B_4 }
  cylinder { // Left_Sl_5
    <0,0,1>, <0,0,0>, 1 open
    scale <3.0, 3.0, 6.0>
    rotate <147.267593, 335.59549, 267.267578>
    translate  <-8.0, 21.0, 0.0>
  }
  texture {
    ShirtTex2
  }
}
#declare Left_Fo_10 = union {
  sphere { // P4_Righ_11
    <0,0,0>,1
    scale <1.8, 2.717746, 3.942703>
    rotate 90.0*y
    translate  -14.0*x
  }
  cylinder { // cylinde3_25
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate <180.0, 270.0, 180.0>
  }
  sphere { // sphere4_26
    <0,0,0>,1
    scale 2.0
  }
  rotate <300.0, 330.0, 180.0>
  translate  -14.0*x
}
#declare Left_Ar_17 = union {
  cylinder { // cylinde5_22
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate <180.0, 270.0, 180.0>
  }
  object { Left_Fo_10 }
  rotate <50.0, 310.0, 30.0>
  translate  <-8.0, 21.0, 0.0>
}
#declare Right_F_11 = union {
  sphere { // P4_Righ_12
    <0,0,0>,1
    scale <1.894429, 2.86032, 4.149539>
    rotate 270.0*y
    translate  14.0*x
  }
  cylinder { // cylinde4_31
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate 90.0*y
  }
  sphere { // sphere5_32
    <0,0,0>,1
    scale 2.0
  }
  rotate <-34.074379, 24.615467, -157.364548>
  translate  14.0*x
}
#declare Right_A_18 = union {
  cylinder { // cylinde6_28
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate 90.0*y
  }
  object { Right_F_11 }
  cylinder { // Right_S_6
    <0,0,1>, <0,0,0>, 1 open
    texture {
      ShirtTex2
    }
    scale <3.0, 3.0, 6.0>
    rotate <-178.723053, 90.0, -178.723053>
    translate  0.0*x
  }
  rotate <50.488155, 9.827532, -19.03709>
  translate  <8.0, 21.0, 0.0>
}
#declare Neck_13 = union {
  cone { // cone1_36
    <0,0,0>, 3.0, <0,0,1>, 1.7
    scale <1.0, 1.0, 6.0>
    rotate 270.0*x
  }
  sphere { // sphere6_37
    <0,0,0>,1
    scale 3.0
  }
}
#declare Head_14 = difference {
  sphere { // HeadOval
    <0,0,0>,1
    scale <5.0, 5.0, 7.5>
    rotate <90.0, 0.0, 180.0>
    translate  <0.105426, 0.062832, -0.264276>
  }
  sphere { // eyeSco1
    <0,0,0>,1
    scale <2.042807, 0.893724, 1.139728>
    rotate <90.962845, 18.759617, -174.692062>
    translate  <2.523591, 1.183323, -4.52319>
  }
  sphere { // EyeS2
    <0,0,0>,1
    scale <3.27992, 1.024686, 1.716128>
    rotate <91.5942, 28.445726, -174.234406>
    translate  <1.88, 1.18, -5.51>
  }
  sphere { // EyeS3
    <0,0,0>,1
    scale <3.27992, 1.024686, 1.716128>
    rotate <-91.5942, -28.445726, -174.234406>
    translate  <-1.88, 1.18, -5.51>
  }
  sphere { // EyeS4
    <0,0,0>,1
    scale <2.042807, 0.893724, 1.139728>
    rotate <-90.962845, -18.759617, -174.692062>
    translate  <-2.523591, 1.183323, -4.52319>
  }
  translate  7.5*y
}
#declare Nose4 = union {
  cone { // NoseCone4
    <0,0,0>, 0.7, <0,0,1>, 0.2
    scale <1.0, 1.0, 3.2>
    rotate <0.0, 0.0, 0.0>
    translate  <0.035142, -4.966163, -1.444079>
  }
  sphere { // Sphere15
    <0,0,0>,1
    scale <0.75, 0.7, 0.5>
    translate  <0.036405, -4.929194, -1.413741>
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.105426, 7.584325, 0.03663>
}
#declare Mouth4 = union {
  torus { // Torus23
    1.5, 0.5  rotate -x*90
    texture {
      LipTex1
    }
    scale <1.0, 1.0, 0.35>
    rotate <19.346189, 0.0, 0.0>
    translate  <0.0, -3.222807, -2.333757>
  }
  torus { // Torus24
    1.5, 0.5  rotate -x*90
    texture {
      LipTex1
    }
    scale <1.0, 1.0, 0.35>
    rotate <-8.826151, 0.0, 0.0>
    translate  <0.0, -3.572273, -2.608983>
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.105426, 7.387784, -0.264276>
}
#declare P4_Hair_11 = difference {
  sphere { // sphere23_52
    <0,0,0>,1
    scale <5.5, 8.250001, 5.5>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 0.000001>
  }
  box { // box11_53
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 12.0, 5.0>
    rotate 350.0*x
    translate  <0.0, -8.746703, -3.534853>
  }
  box { // box12_54
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 8.5, 10.0>
    translate  <0.0, -17.147112, 0.0>
  }
  texture {
    CBHairTex
  }
  scale 0.96
  rotate <0.0, 0.0, 0.0>
  translate  <0.127741, 7.709181, 0.06328>
}
#declare Eye1 = union {
  sphere { // sphere7_22
    <0,0,0>,1
    texture {
      WHITE
      scale <1.0, 1.666667, 5.0>
    }
    scale <1.238095, 0.742857, 0.247619>
    rotate <90.0, 0.0, 164.0>
    translate  <-2.306093, 19.676254, 8.057111>
  }
  sphere { // sphere9_24
    <0,0,0>,1
    texture {
      Iris
      scale <1.0, 1.0, 3.333333>
    }
    scale <0.495238, 0.495238, 0.148571>
    rotate <90.0, 0.0, 164.0>
    translate  <-2.306093, 19.552444, 8.057111>
  }
  sphere { // sphere11_26
    <0,0,0>,1
    texture {
      PBlack
      scale <1.0, 1.0, 1.428571>
    }
    scale <0.247619, 0.247619, 0.173333>
    rotate <90.0, 0.0, 164.0>
    translate  <-2.306093, 19.552444, 8.057111>
  }
  scale 1.08
  rotate <90.0, 0.0, -180.0>
  translate  <-0.430478, -0.129131, -25.096648>
}
#declare Eye2 = union {
  sphere { // sphere7_23
    <0,0,0>,1
    texture {
      WHITE
      scale <1.0, 1.666667, 5.0>
    }
    scale <1.238095, 0.742857, 0.247619>
    rotate <90.0, 0.0, -164.0>
    translate  <2.306093, 19.676254, 8.057111>
  }
  sphere { // sphere9_25
    <0,0,0>,1
    texture {
      Iris
      scale <1.0, 1.0, 3.333333>
    }
    scale <0.495238, 0.495238, 0.148571>
    rotate <90.0, 0.0, -164.0>
    translate  <2.306093, 19.552444, 8.057111>
  }
  sphere { // sphere11_27
    <0,0,0>,1
    texture {
      PBlack
      scale <1.0, 1.0, 1.428571>
    }
    scale <0.247619, 0.247619, 0.173333>
    rotate <90.0, 0.0, -164.0>
    translate  <2.306093, 19.552444, 8.057111>
  }
  scale 1.08
  rotate <90.0, 0.0, -180.0>
  translate  <0.430478, -0.129131, -25.096648>
}
#declare HairTest1 = union {
  torus { // Torus25
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate -90.0*x
    translate  <-1.458018, 23.02973, 4.833183>
  }
  torus { // Torus26
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -16.0>
    translate  <-1.458018, 23.02973, 4.833183>
  }
  torus { // Torus27
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -32.0>
    translate  <-1.458018, 23.525518, 4.833183>
  }
  torus { // Torus28
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -48.0>
    translate  <-1.458018, 23.711438, 4.833183>
  }
  torus { // Torus29
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -64.0>
    translate  <-1.458018, 24.145253, 4.833183>
  }
  torus { // Torus30
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -80.0>
    translate  <-1.148151, 24.331173, 4.833183>
  }
  torus { // Torus31
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -96.0>
    translate  <-1.148151, 24.45512, 4.833183>
  }
  torus { // Torus32
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -107.823288>
    translate  <-0.280523, 24.45512, 4.833183>
  }
  torus { // Torus33
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 16.0>
    translate  <-1.458018, 23.02973, 4.833183>
  }
  torus { // Torus34
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 31.969688>
    translate  <-1.458018, 23.02973, 4.833183>
  }
  torus { // Torus35
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 47.969688>
    translate  <-1.458018, 23.02973, 4.833183>
  }
  torus { // Torus36
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 69.934425>
    translate  <-1.829859, 22.65789, 4.833183>
  }
  torus { // Torus37
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 85.934425>
    translate  <-1.581965, 22.533943, 4.833183>
  }
  torus { // Torus38
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 90.0>
    translate  <-0.466443, 22.286049, 4.833183>
  }
  torus { // Torus39
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 106.0>
    translate  <-0.342496, 21.976182, 4.833183>
  }
  torus { // Torus40
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 122.0>
    translate  <-0.156576, 21.852235, 4.833183>
  }
  torus { // Torus41
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 138.0>
    translate  <-0.032629, 21.728288, 4.833183>
  }
  torus { // Torus42
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 154.0>
    translate  <0.153291, 21.728288, 4.833183>
  }
  torus { // Torus57
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 170.0>
    translate  <0.399921, 21.169759, 4.833183>
  }
  torus { // Torus58
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, 186.0>
    translate  <0.552334, 21.359151, 4.833183>
  }
  torus { // Torus59
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -152.410126>
    translate  <0.552334, 21.359151, 4.833183>
  }
  torus { // Torus60
    20.0, 0.3  rotate -x*90
    scale <0.2, 0.5, 2.0>
    rotate <-90.0, 0.0, -134.195633>
    translate  <1.173624, 22.024419, 4.833183>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare Hair = difference {
  object { HairTest1 }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <10.791192, 7.371193, 5.901765>
    translate  <-0.927317, 22.990634, -6.69838>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <4.183177, 5.792879, 10.114323>
    translate  <-0.647932, 19.532402, 0.0>
  }
  texture {
    CBHairTex
  }
  scale 1.05
  rotate <90.0, 0.0, -180.0>
  translate  <-0.315756, 0.249214, -24.55231>
}
#declare Girl1Head2 = union {
  object { Neck_13 }
  object { Head_14 }
  object { Nose4 }
  object { Mouth4 }
  object { P4_Hair_11 }
  cone { // EyeLido
    <0,0,0>, 0.3, <0,0,1>, 1.3
    scale <1.6, 0.846658, 1.186733>
     rotate <-91.680656, 20.021484, -174.198898> //<-90.0, 20.222914, 180.0>
    translate  <1.958402, 10.03744, -3.700844>
  }
  object { Eye1 }
  cone { // EyeLid1
    <0,0,0>, 0.3, <0,0,1>, 1.3
    scale <1.6, 0.846658, 1.186733>
    rotate <-90.0, -20.222914, 180.0>
    translate  <-1.958402, 10.03744, -3.700844>
  }
  object { Eye2 }
  object { Hair }
  scale 0.833333
  //rotate <19.762903, -0.281318, 11.248158>

rotate <13.980248, 1.916595, 2.362592>
  translate  <0.51439, 24.781785, 0.50756>

  //translate  <0.490881, 24.48524, 0.473147>
}
#declare Upeer_Body4 = union {
  object { Shirt_16 }
  object { Left_Ar_17 }
  object { Right_A_18 }
  object { Girl1Head2 }
}
#declare Left_Sh_16 = union {
  sphere { // sphere10_55
    <0,0,0>,1
    scale 3.0
  }
  cone { // cone6_56
    <0,0,0>, 3.0, <0,0,1>, 1.5
    scale <1.0, 1.0, 16.0>
    rotate 90.0*x
  }
  translate  -15.0*y
}
#declare Left_Le_23 = union {
  object { Left_Sh_16 }
  cone { // cone8_57
    <0,0,0>, 5.0, <0,0,1>, 3.0
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
  }
  translate  -3.0*x
}
#declare Right_S_17 = union {
  sphere { // sphere11_60
    <0,0,0>,1
    scale 3.0
  }
  cone { // cone7_61
    <0,0,0>, 3.0, <0,0,1>, 1.6
    scale <1.0, 1.0, 16.0>
    rotate <61.839569, 0.0, 0.0>
  }
  translate  -15.0*y
}
#declare Right_L_24 = union {
  object { Right_S_17 }
  cone { // cone9_62
    <0,0,0>, 5.0, <0,0,1>, 3.0
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
  }
  rotate <42.0, 0.0, 0.0>
  translate  3.0*x
}
#declare Girl8 = union {
  object { Upeer_Body4 }
  object { Left_Le_23 }
  object { Right_L_24 }
  texture {
    SkinTex
  }
  rotate <90.0, 0.0, 176.807617>
}
#declare Shoes2 = union {
  sphere { // Sphere18
    <0,0,0>,1
    scale <4.41933, 2.566616, 1.584243>
    rotate <90.0, -74.021194, 0.0>
    translate  <-4.27841, -35.082295, -12.863008>
  }
  sphere { // Sphere19
    <0,0,0>,1
    scale <4.41933, 2.566616, 1.584243>
    rotate <90.0, -74.021194, 0.0>
    translate  <1.768213, -38.677307, 0.649288>
  }
  texture {
    PBlack
  }
  rotate <90.0, 0.0, 130.331314>
  translate  <2.396627, -4.176844, 7.789913>
}
#declare Cindy = union {
  object { Skirt2 }
  object { Girl8 }
  object { Shoes2 }
  scale 0.213
  rotate <0.0, 0.0, 58.853855>
  translate  <-2.243433, 17.151014, 1.073548>
}
#declare Left_Fo_7 = union {
  sphere { // P4_Righ_4
    <0,0,0>,1
    scale <1.894429, 2.86032, 4.149539>
    rotate 90.0*y
    translate  -14.0*x
  }
  cylinder { // cylinde3_22
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate <180.0, 270.0, 180.0>
  }
  sphere { // sphere4_23
    <0,0,0>,1
    scale 2.0
  }
  rotate <-24.304518, -69.216507, 151.039169>
  translate  -14.0*x
}
#declare LeftArm3 = union {
  cylinder { // cylinde5_19
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate <180.0, 270.0, 180.0>
  }
  object { Left_Fo_7 }
  cylinder { // Left_Sl_2
    <0,0,1>, <0,0,0>, 1 open
    texture {
      DrTex1
    }
    scale <3.0, 3.0, 6.0>
    rotate <-78.270622, -89.999985, 78.270622>
    translate  0.0*z
  }
  rotate <-15.449943, -7.922527, 52.066315>
  translate  <-8.0, 21.0, 0.0>
}
#declare Right_F_8 = union {
  sphere { // P4_Righ_6
    <0,0,0>,1
    scale <1.894429, 2.86032, 4.149539>
    rotate 270.0*y
    translate  14.0*x
  }
  cylinder { // cylinde4_28
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate 90.0*y
  }
  sphere { // sphere5_29
    <0,0,0>,1
    scale 2.0
  }
  rotate <-41.222073, 15.656182, -10.347429>
  translate  14.0*x
}
#declare RightArm3 = union {
  cylinder { // cylinde6_25
    <0,0,1>, <0,0,0>, 1
    scale <2.0, 2.0, 14.0>
    rotate 90.0*y
  }
  object { Right_F_8 }
  cylinder { // Right_S_3
    <0,0,1>, <0,0,0>, 1 open
    texture {
      DrTex1
    }
    scale <3.0, 3.0, 6.0>
    rotate <-178.723053, 90.0, -178.723053>
    translate  <0.0, 0.0, 0.0>
  }
  rotate <71.879158, 43.532017, 10.139346>
  translate  <8.0, 21.0, 0.0>
}
#declare Waist1 = difference {
  cone { // cone0_13
    <0,0,0>, 10.0, <0,0,1>, 8.0
    scale <0.8, 0.5, 21.0>
  }
  torus { // Torus6
    8.75, 4.0  rotate -x*90
    scale <0.9, 1.262274, 2.6>
    rotate <0.0, 0.0, -90.0>
    translate  <-0.069344, 0.577916, 13.5>
  }
  rotate <90.0, 0.0, 180.0>
}
#declare Shirt_B_1 = union {
  cone { // cone0_12
    <0,0,0>, 10.0, <0,0,1>, 8.0
    scale <0.01, 0.00625, 0.2625>
    rotate 270.0*x
  }
  sphere { // sphere0_12
    <0,0,0>,1
    scale <8.0, 4.0, 4.0>
    translate  21.0*y
  }
  cylinder { // cylinde0_13
    <0,0,1>, <0,0,0>, 1
    scale <3.0, 3.0, 16.0>
    rotate 90.0*y
    translate  <-8.0, 21.0, 0.0>
  }
  sphere { // sphere1_14
    <0,0,0>,1
    scale 3.0
    translate  <-8.0, 21.0, 0.0>
  }
  sphere { // sphere2_15
    <0,0,0>,1
    scale 3.0
    translate  <8.0, 21.0, 0.0>
  }
  object { Waist1 }
  texture {
    DrTex1
  }
  rotate <0.0, 0.0, 0.0>
}
#declare Neck_16 = union {
  cone { // cone1_39
    <0,0,0>, 3.0, <0,0,1>, 1.7
    scale <1.0, 1.0, 6.0>
    rotate 270.0*x
  }
  sphere { // sphere6_40
    <0,0,0>,1
    scale 2.8
  }
}
#declare Head_17 = difference {
  sphere { // HeadOval3
    <0,0,0>,1
    scale <5.0, 5.0, 7.5>
    rotate <90.0, 0.0, 180.0>
    translate  <0.105426, 0.062832, -0.264276>
  }
  sphere { // eyeSco4
    <0,0,0>,1
    scale <2.042807, 0.893724, 1.139728>
    rotate <90.962845, 18.759617, -174.692062>
    translate  <2.523591, 1.183323, -4.52319>
  }
  sphere { // EyeS11
    <0,0,0>,1
    scale <3.27992, 1.024686, 1.716128>
    rotate <91.5942, 28.445726, -174.234406>
    translate  <1.88, 1.18, -5.51>
  }
  sphere { // EyeS12
    <0,0,0>,1
    scale <3.27992, 1.024686, 1.716128>
    rotate <-91.5942, -28.445726, -174.234406>
    translate  <-1.88, 1.18, -5.51>
  }
  sphere { // EyeS13
    <0,0,0>,1
    scale <2.042807, 0.893724, 1.139728>
    rotate <-90.962845, -18.759617, -174.692062>
    translate  <-2.523591, 1.183323, -4.52319>
  }
  translate  7.5*y
}
#declare Nose7 = union {
  cone { // NoseCone7
    <0,0,0>, 0.7, <0,0,1>, 0.2
    scale <1.0, 1.0, 3.2>
    rotate <0.0, 0.0, 0.0>
    translate  <0.035142, -4.966163, -1.444079>
  }
  sphere { // Sphere20
    <0,0,0>,1
    scale <0.75, 0.7, 0.5>
    translate  <0.036405, -4.929194, -1.413741>
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.105426, 7.584325, 0.03663>
}
#declare Mouth7 = union {
  torus { // Torus43
    1.5, 0.5  rotate -x*90
    texture {
      LipTex
    }
    scale <1.0, 1.0, 0.35>
    rotate <19.346189, 0.0, 0.0>
    translate  <0.0, -3.222807, -2.333757>
  }
  torus { // Torus73
    1.5, 0.5  rotate -x*90
    texture {
      LipTex
    }
    scale <1.0, 1.0, 0.35>
    rotate <-8.826151, 0.0, 0.0>
    translate  <0.0, -3.572273, -2.608983>
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.105426, 7.387784, -0.264276>
}
#declare P4_Hair_14 = difference {
  sphere { // sphere23_55
    <0,0,0>,1
    scale <5.5, 8.250001, 5.5>
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.0, 0.000001>
  }
  box { // box11_56
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 12.0, 5.0>
    rotate 350.0*x
    translate  <0.0, -8.746703, -3.534853>
  }
  box { // box12_57
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 8.5, 10.0>
    translate  <1.877951, -12.025059, -0.022043>
  }
  texture {
    FairyHairTex
  }
  scale 0.96
  rotate <0.0, 0.0, 0.0>
  translate  <0.127741, 7.709181, 0.06328>
}
#declare Eye7 = union {
  sphere { // sphere7_28
    <0,0,0>,1
    texture {
      WHITE
      scale <1.0, 1.666667, 5.0>
    }
    scale <1.238095, 0.742857, 0.247619>
    rotate <90.0, 0.0, 164.0>
    translate  <-2.306093, 19.676254, 8.057111>
  }
  sphere { // sphere9_30
    <0,0,0>,1
    texture {
      Iris
      scale <1.0, 1.0, 3.333333>
    }
    scale <0.495238, 0.495238, 0.148571>
    rotate <90.0, 0.0, 164.0>
    translate  <-2.306093, 19.552444, 8.057111>
  }
  sphere { // sphere11_32
    <0,0,0>,1
    texture {
      PBlack
      scale <1.0, 1.0, 1.428571>
    }
    scale <0.247619, 0.247619, 0.173333>
    rotate <90.0, 0.0, 164.0>
    translate  <-2.306093, 19.552444, 8.057111>
  }
  scale 1.08
  rotate <90.0, 0.0, -180.0>
  translate  <-0.430478, -0.129131, -25.096648>
}
#declare Eye8 = union {
  sphere { // sphere7_29
    <0,0,0>,1
    texture {
      WHITE
      scale <1.0, 1.666667, 5.0>
    }
    scale <1.238095, 0.742857, 0.247619>
    rotate <90.0, 0.0, -164.0>
    translate  <2.306093, 19.676254, 8.057111>
  }
  sphere { // sphere9_31
    <0,0,0>,1
    texture {
      Iris
      scale <1.0, 1.0, 3.333333>
    }
    scale <0.495238, 0.495238, 0.148571>
    rotate <90.0, 0.0, -164.0>
    translate  <2.306093, 19.552444, 8.057111>
  }
  sphere { // sphere11_33
    <0,0,0>,1
    texture {
      PBlack
      scale <1.0, 1.0, 1.428571>
    }
    scale <0.247619, 0.247619, 0.173333>
    rotate <90.0, 0.0, -164.0>
    translate  <2.306093, 19.552444, 8.057111>
  }
  scale 1.08
  rotate <90.0, 0.0, -180.0>
  translate  <0.430478, -0.129131, -25.096648>
}
#declare LeftEar4 = union {
  sphere { // sphere4_46
    <0,0,0>,1
    scale <1.5, 0.15, 1.5>
  }
  torus { // torus0_47
    1.3, 0.3  rotate -x*90
    scale 0.1
  }
  scale 0.909091
  rotate <88.79129, 30.894743, 2.519114>
  translate  <-4.733731, 7.300542, 0.124531>
}
#declare GHat4 = union {
  torus { // Torus74
    5.125, 1.125  rotate -x*90
    texture {
      HatBandTex
    }
    scale <0.986566, 1.122245, 1.55362>
    translate  <-0.061499, 0.0, 5.718463>
  }
  cone { // Cone10
    <0,0,0>, 4.5, <0,0,1>, 0.0
    texture {
      DrTex1
    }
    scale <1.1, 1.1, 13.761684>
    translate  <-0.367314, -0.147723, 5.871291>
  }
  rotate <-21.22946, -0.894039, 0.167555>
  translate  <0.0, 0.0, 0.0>
}
#declare Hair3 = union {
  torus { // Torus75
    1.5, 0.5  rotate -x*90
    texture {
      FairyHairTex
    }
    scale 3.2
    rotate -30.5*x
    translate  <0.0, 1.009595, 1.570482>
  }
  torus { // Torus76
    1.5, 0.5  rotate -x*90
    texture {
      FairyHairTex
    }
    scale 3.0
    rotate -30.5*x
    translate  <0.0, 1.458305, 3.253141>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare FairyHair3 = union {
  object { GHat4 }
  object { Hair3 }
  scale 0.909091
  rotate <91.038712, 3.099131, -176.804031>
  translate  <0.518239, 7.349588, -0.472875>
}
#declare Girl1Head4 = union {
  object { Neck_16 }
  object { Head_17 }
  object { Nose7 }
  object { Mouth7 }
  object { P4_Hair_14 }
  cone { // EyeLid6
    <0,0,0>, 0.3, <0,0,1>, 1.3
    scale <1.6, 0.846658, 1.186733>
    rotate <-90.0, 20.222914, 180.0>
    translate  <1.958402, 10.03744, -3.700844>
  }
  object { Eye7 }
  cone { // EyeLid7
    <0,0,0>, 0.3, <0,0,1>, 1.3
    scale <1.6, 0.846658, 1.186733>
    rotate <-90.0, -20.222914, 180.0>
    translate  <-1.958402, 10.03744, -3.700844>
  }
  object { Eye8 }
  object { LeftEar4 }
  object { FairyHair3 }
  rotate <29.092979, -7.976379, -6.988897>
  translate  <-2.283728, 23.17297, 0.050678>
}
#declare Upeer_Body1 = union {
  object { LeftArm3 }
  object { RightArm3 }
  object { Shirt_B_1 }
  object { Girl1Head4 }
}
#declare Left_Sh_13 = union {
  sphere { // sphere10_52
    <0,0,0>,1
    scale 3.0
  }
  cone { // cone6_53
    <0,0,0>, 3.0, <0,0,1>, 1.5
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
  }
  translate  -15.0*y
}
#declare Left_Le_20 = union {
  object { Left_Sh_13 }
  cone { // cone8_54
    <0,0,0>, 5.0, <0,0,1>, 3.0
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
  }
  texture {
    DrTex1
  }
  translate  -3.0*x
}
#declare Right_S_14 = union {
  sphere { // sphere11_57
    <0,0,0>,1
    scale 3.0
  }
  cone { // cone7_58
    <0,0,0>, 3.0, <0,0,1>, 1.6
    scale <1.0, 1.0, 15.0>
    rotate <89.155777, 0.209907, -0.213023>
  }
  translate  -15.0*y
}
#declare Right_L_21 = union {
  object { Right_S_14 }
  cone { // cone9_59
    <0,0,0>, 5.0, <0,0,1>, 3.0
    scale <1.0, 1.0, 15.0>
    rotate 90.0*x
  }
  texture {
    DrTex2
  }
  rotate <0.0, 0.0, 0.0>
  translate  3.0*x
}
#declare Girl1 = union {
  object { Upeer_Body1 }
  object { Left_Le_20 }
  object { Right_L_21 }
  texture {
    SkinTex
  }
  scale 0.3
  rotate <2.138299, -1.86794, 89.930298>
}
#declare Wand1 = union {
  cylinder { // Wnd1
    <0,0,1>, <0,0,0>, 1
    texture {
    WandTex
    }
     no_shadow
    scale <0.1, 0.1, 5.0>
    rotate -10.295931*y
    translate  <-12.439649, 1.20093, -0.125985>
  }
  sphere { // Spark1
    <0,0,0>,1
    texture {
      WandTex
    }
    scale 0.001
    translate  <-13.4628, 1.176825, 5.243364>
  }
rotate <34.956497, -54.270535, -49.639435>
  translate  <-3.241433, 0.291112, 3.716088>

  //rotate <21.406469, -33.725971, -35.224819>
  //translate  <0.36259, 0.038788, -0.097152>
}
#declare bicubic0_5 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.350700, -0.074400, 0.085600>, <0.046400, -0.175400, 0.125400>, <0.575900, -0.310000, 0.178500>, <0.973100, -0.411000, 0.218300>,
      <-0.350500, -0.072100, 0.086200>, <0.046700, -0.173100, 0.126000>, <0.530000, -0.267400, 0.183400>, <0.927100, -0.368400, 0.223200>,
      <-0.348200, -0.069400, 0.085400>, <0.034600, -0.160100, 0.126700>, <0.555100, -0.294300, 0.180400>, <0.937900, -0.385100, 0.221700>,
      <-0.347700, -0.067100, 0.085300>, <0.035100, -0.157800, 0.126600>, <0.545500, -0.278800, 0.181700>, <0.928300, -0.369500, 0.223100>
    }
  }
}
#declare bicubic1_6 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.350700, -0.074400, 0.085600>, <-0.351000, -0.076500, 0.085100>, <-0.349100, -0.078600, 0.083200>, <-0.349100, -0.080400, 0.082100>,
      <0.046400, -0.175400, 0.125400>, <0.046200, -0.177400, 0.124900>, <0.031900, -0.185700, 0.120200>, <0.031900, -0.187500, 0.119200>,
      <0.575900, -0.310000, 0.178500>, <0.560300, -0.318000, 0.174700>, <0.551900, -0.318300, 0.174300>, <0.540000, -0.330400, 0.168500>,
      <0.973100, -0.411000, 0.218300>, <0.957500, -0.418900, 0.214500>, <0.932900, -0.425400, 0.211400>, <0.921000, -0.437500, 0.205500>
    }
  }
}
#declare bicubic2_7 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.347700, -0.067100, 0.085300>, <0.035100, -0.157800, 0.126600>, <0.545500, -0.278800, 0.181700>, <0.928300, -0.369500, 0.223100>,
      <-0.347400, -0.066000, 0.085300>, <0.035400, -0.156700, 0.126600>, <0.542700, -0.274300, 0.182100>, <0.925500, -0.365000, 0.223400>,
      <-0.348100, -0.064600, 0.085300>, <0.038000, -0.152100, 0.126600>, <0.554600, -0.272700, 0.181700>, <0.940700, -0.360200, 0.223100>,
      <-0.348400, -0.063600, 0.085300>, <0.037800, -0.151100, 0.126600>, <0.552600, -0.267800, 0.181700>, <0.938800, -0.355300, 0.223100>
    }
  }
}
#declare bicubic3_8 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.348400, -0.063600, 0.085300>, <0.037800, -0.151100, 0.126600>, <0.552600, -0.267800, 0.181700>, <0.938800, -0.355300, 0.223100>,
      <-0.348800, -0.061500, 0.085300>, <0.037300, -0.149000, 0.126600>, <0.547000, -0.253600, 0.181700>, <0.933100, -0.341200, 0.223100>,
      <-0.350200, -0.058800, 0.085300>, <0.026800, -0.136500, 0.126600>, <0.528100, -0.253200, 0.181700>, <0.905200, -0.330900, 0.223100>,
      <-0.350000, -0.056600, 0.085300>, <0.027100, -0.134300, 0.126600>, <0.529800, -0.238000, 0.181700>, <0.906800, -0.315700, 0.223100>
    }
  }
}
#declare bicubic4_9 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.350000, -0.056600, 0.085300>, <0.027100, -0.134300, 0.126600>, <0.529800, -0.238000, 0.181700>, <0.906800, -0.315700, 0.223100>,
      <-0.349700, -0.054500, 0.085300>, <0.027300, -0.132200, 0.126600>, <0.531400, -0.222800, 0.181700>, <0.908400, -0.300500, 0.223100>,
      <-0.347800, -0.052100, 0.085300>, <0.040200, -0.122200, 0.126600>, <0.550400, -0.226700, 0.181700>, <0.938400, -0.296700, 0.223100>,
      <-0.346900, -0.050200, 0.085300>, <0.041100, -0.120200, 0.126600>, <0.558400, -0.213600, 0.181700>, <0.946500, -0.283700, 0.223100>
    }
  }
}
#declare bicubic5_10 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.346900, -0.050200, 0.085300>, <0.041100, -0.120200, 0.126600>, <0.558400, -0.213600, 0.181700>, <0.946500, -0.283700, 0.223100>,
      <-0.346500, -0.049200, 0.085300>, <0.041500, -0.119300, 0.126600>, <0.562000, -0.207800, 0.181700>, <0.950000, -0.277900, 0.223100>,
      <-0.345500, -0.048000, 0.085300>, <0.040100, -0.112500, 0.126700>, <0.549400, -0.202300, 0.181800>, <0.935000, -0.266800, 0.223100>,
      <-0.345500, -0.046900, 0.085300>, <0.040100, -0.111500, 0.126600>, <0.554200, -0.197500, 0.181700>, <0.939800, -0.262000, 0.223100>
    }
  }
}
#declare bicubic6_11 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.345500, -0.046900, 0.085300>, <0.040100, -0.111500, 0.126600>, <0.554200, -0.197500, 0.181700>, <0.939800, -0.262000, 0.223100>,
      <-0.345500, -0.044800, 0.085300>, <0.040100, -0.109400, 0.126600>, <0.567900, -0.183900, 0.181600>, <0.953500, -0.248400, 0.222900>,
      <-0.347300, -0.042000, 0.085900>, <0.056000, -0.099900, 0.127100>, <0.592100, -0.193300, 0.187500>, <0.995400, -0.251200, 0.228700>,
      <-0.347100, -0.040100, 0.085100>, <0.056300, -0.098000, 0.126300>, <0.594000, -0.175200, 0.181300>, <0.997300, -0.233000, 0.222400>
    }
  }
}
#declare bicubic7_12 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.345500, -0.046900, 0.085300>, <-0.345500, -0.044800, 0.085300>, <-0.347300, -0.042000, 0.085900>, <-0.347100, -0.040100, 0.085100>,
      <0.040100, -0.111500, 0.126600>, <0.040100, -0.109400, 0.126600>, <0.056000, -0.099900, 0.127100>, <0.056300, -0.098000, 0.126300>,
      <0.554200, -0.197500, 0.181700>, <0.567900, -0.183900, 0.181600>, <0.592100, -0.193300, 0.187500>, <0.594000, -0.175200, 0.181300>,
      <0.939800, -0.262000, 0.223100>, <0.953500, -0.248400, 0.222900>, <0.995400, -0.251200, 0.228700>, <0.997300, -0.233000, 0.222400>
    }
  }
}
#declare bicubic8_13 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.347100, -0.040100, 0.085100>, <0.056300, -0.098000, 0.126300>, <0.594000, -0.175200, 0.181300>, <0.997300, -0.233000, 0.222400>,
      <-0.346900, -0.038300, 0.084400>, <0.056400, -0.096200, 0.125600>, <0.596100, -0.156100, 0.174600>, <0.999400, -0.214000, 0.215800>,
      <-0.344700, -0.037400, 0.082100>, <0.042700, -0.084800, 0.117700>, <0.571000, -0.160700, 0.173100>, <0.958400, -0.208000, 0.208700>,
      <-0.344300, -0.036000, 0.080800>, <0.043100, -0.083300, 0.116400>, <0.559700, -0.146500, 0.163900>, <0.947200, -0.193900, 0.199500>
    }
  }
}
#declare bicubic9_14 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.347100, -0.040100, 0.085100>, <-0.346900, -0.038300, 0.084400>, <-0.344700, -0.037400, 0.082100>, <-0.344300, -0.036000, 0.080800>,
      <0.056300, -0.098000, 0.126300>, <0.056400, -0.096200, 0.125600>, <0.042700, -0.084800, 0.117700>, <0.043100, -0.083300, 0.116400>,
      <0.594000, -0.175200, 0.181300>, <0.596100, -0.156100, 0.174600>, <0.571000, -0.160700, 0.173100>, <0.559700, -0.146500, 0.163900>,
      <0.997300, -0.233000, 0.222400>, <0.999400, -0.214000, 0.215800>, <0.958400, -0.208000, 0.208700>, <0.947200, -0.193900, 0.199500>
    }
  }
}
#declare bicubic10_15 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.344300, -0.036000, 0.080800>, <0.043100, -0.083300, 0.116400>, <0.559700, -0.146500, 0.163900>, <0.947200, -0.193900, 0.199500>,
      <-0.344100, -0.035200, 0.080200>, <0.043300, -0.082600, 0.115700>, <0.556700, -0.142700, 0.161400>, <0.944200, -0.190100, 0.197000>,
      <-0.344800, -0.033900, 0.079500>, <0.045900, -0.078800, 0.112700>, <0.568700, -0.142000, 0.159100>, <0.959400, -0.186900, 0.192300>,
      <-0.345100, -0.033100, 0.079000>, <0.045600, -0.078000, 0.112200>, <0.566600, -0.137800, 0.156400>, <0.957300, -0.182700, 0.189500>
    }
  }
}
#declare bicubic11_16 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.345100, -0.033100, 0.079000>, <0.045600, -0.078000, 0.112200>, <0.566600, -0.137800, 0.156400>, <0.957300, -0.182700, 0.189500>,
      <-0.345600, -0.031300, 0.077900>, <0.045100, -0.076200, 0.111000>, <0.560700, -0.126100, 0.148600>, <0.951400, -0.171000, 0.181700>,
      <-0.347000, -0.029000, 0.076500>, <0.034500, -0.065500, 0.104800>, <0.541900, -0.125100, 0.149800>, <0.923300, -0.161700, 0.178100>,
      <-0.346800, -0.027200, 0.075300>, <0.034700, -0.063700, 0.103600>, <0.543300, -0.112400, 0.141400>, <0.924700, -0.149000, 0.169700>
    }
  }
}
#declare bicubic12_17 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.346800, -0.027200, 0.075300>, <0.034700, -0.063700, 0.103600>, <0.543300, -0.112400, 0.141400>, <0.924700, -0.149000, 0.169700>,
      <-0.346600, -0.025400, 0.074100>, <0.034800, -0.062000, 0.102400>, <0.544600, -0.099800, 0.132900>, <0.926100, -0.136300, 0.161300>,
      <-0.344700, -0.023500, 0.072700>, <0.047500, -0.053800, 0.096200>, <0.563600, -0.103500, 0.133600>, <0.955900, -0.133900, 0.157100>,
      <-0.343900, -0.021900, 0.071600>, <0.048400, -0.052200, 0.095000>, <0.571500, -0.092600, 0.126400>, <0.963800, -0.122900, 0.149900>
    }
  }
}
#declare bicubic13_18 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.343900, -0.021900, 0.071600>, <0.048400, -0.052200, 0.095000>, <0.571500, -0.092600, 0.126400>, <0.963800, -0.122900, 0.149900>,
      <-0.343500, -0.021100, 0.071000>, <0.048800, -0.051400, 0.094500>, <0.574900, -0.087800, 0.123200>, <0.967200, -0.118100, 0.146700>,
      <-0.342500, -0.020000, 0.070300>, <0.047300, -0.045600, 0.091400>, <0.563200, -0.082600, 0.122800>, <0.953000, -0.108100, 0.143800>,
      <-0.342500, -0.019200, 0.069700>, <0.047300, -0.044700, 0.090800>, <0.567000, -0.078700, 0.118900>, <0.956800, -0.104200, 0.139900>
    }
  }
}
#declare bicubic14_19 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.342500, -0.019200, 0.069700>, <0.047300, -0.044700, 0.090800>, <0.567000, -0.078700, 0.118900>, <0.956800, -0.104200, 0.139900>,
      <-0.342600, -0.017400, 0.068500>, <0.047200, -0.042900, 0.089500>, <0.576200, -0.069100, 0.109300>, <0.966000, -0.094600, 0.130400>,
      <-0.344300, -0.014600, 0.067500>, <0.058900, -0.036200, 0.081500>, <0.567700, -0.067700, 0.104800>, <0.988800, -0.090200, 0.119400>,
      <-0.344200, -0.013300, 0.065700>, <0.059100, -0.034900, 0.079700>, <0.578900, -0.062800, 0.097700>, <0.999900, -0.085400, 0.112200>
    }
  }
}
#declare bicubic15_20 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.999900, -0.085400, 0.112200>, <0.987900, -0.077600, 0.103100>, <0.969300, -0.068000, 0.095200>, <0.961500, -0.060400, 0.083000>,
      <0.578900, -0.062800, 0.097700>, <0.566800, -0.055000, 0.088500>, <0.578300, -0.053500, 0.088100>, <0.570500, -0.045900, 0.075900>,
      <0.059100, -0.034900, 0.079700>, <0.059200, -0.033800, 0.078000>, <0.048900, -0.027200, 0.068500>, <0.049200, -0.026600, 0.066500>,
      <-0.344200, -0.013300, 0.065700>, <-0.344100, -0.012200, 0.064000>, <-0.342100, -0.012700, 0.061400>, <-0.341700, -0.012100, 0.059400>
    }
  }
}
#declare bicubic16_21 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.341700, -0.012100, 0.059400>, <0.049200, -0.026600, 0.066500>, <0.570500, -0.045900, 0.075900>, <0.961500, -0.060400, 0.083000>,
      <-0.341600, -0.011800, 0.058400>, <0.049400, -0.026300, 0.065500>, <0.567800, -0.043200, 0.071600>, <0.958800, -0.057700, 0.078600>,
      <-0.342400, -0.011100, 0.057300>, <0.051700, -0.025000, 0.060300>, <0.579200, -0.045200, 0.068200>, <0.973300, -0.059100, 0.071300>,
      <-0.342700, -0.010600, 0.056400>, <0.051400, -0.024500, 0.059400>, <0.576800, -0.043000, 0.063500>, <0.970800, -0.056900, 0.066500>
    }
  }
}
#declare bicubic17_22 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.342700, -0.010600, 0.056400>, <0.051400, -0.024500, 0.059400>, <0.576800, -0.043000, 0.063500>, <0.970800, -0.056900, 0.066500>,
      <-0.343300, -0.009700, 0.054500>, <0.050800, -0.023600, 0.057500>, <0.570400, -0.037400, 0.050800>, <0.964400, -0.051300, 0.053800>,
      <-0.344800, -0.008500, 0.052100>, <0.039600, -0.017800, 0.047200>, <0.551500, -0.035500, 0.052500>, <0.935900, -0.044700, 0.047500>,
      <-0.344700, -0.007700, 0.050200>, <0.039700, -0.017000, 0.045200>, <0.552200, -0.029300, 0.038500>, <0.936600, -0.038600, 0.033500>
    }
  }
}
#declare bicubic18_23 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.344700, -0.007700, 0.050200>, <0.039700, -0.017000, 0.045200>, <0.552200, -0.029300, 0.038500>, <0.936600, -0.038600, 0.033500>,
      <-0.344600, -0.006800, 0.048200>, <0.039800, -0.016100, 0.043200>, <0.552900, -0.023200, 0.024600>, <0.937200, -0.032400, 0.019600>,
      <-0.342900, -0.006000, 0.045900>, <0.052000, -0.012800, 0.032800>, <0.571800, -0.026500, 0.025900>, <0.966600, -0.033300, 0.012900>,
      <-0.342100, -0.005200, 0.044000>, <0.052700, -0.012000, 0.031000>, <0.579100, -0.021100, 0.013600>, <0.974000, -0.028000, 0.000600>
    }
  }
}
#declare bicubic19_24 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.342100, -0.005200, 0.044000>, <0.052700, -0.012000, 0.031000>, <0.579100, -0.021100, 0.013600>, <0.974000, -0.028000, 0.000600>,
      <-0.341700, -0.004800, 0.043100>, <0.053100, -0.011700, 0.030100>, <0.582200, -0.018900, 0.008500>, <0.977000, -0.025700, -0.004500>,
      <-0.340800, -0.004400, 0.041900>, <0.051300, -0.008300, 0.024900>, <0.569600, -0.014700, 0.005300>, <0.961700, -0.018600, -0.011700>,
      <-0.340900, -0.004000, 0.040900>, <0.051200, -0.007900, 0.023900>, <0.574100, -0.013000, 0.001200>, <0.966200, -0.016900, -0.015900>
    }
  }
}
#declare bicubic20_25 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.340900, -0.004000, 0.040900>, <0.051200, -0.007900, 0.023900>, <0.574100, -0.013000, 0.001200>, <0.966200, -0.016900, -0.015900>,
      <-0.341000, -0.003300, 0.039300>, <0.051100, -0.007200, 0.022200>, <0.587200, -0.008100, -0.011000>, <0.979300, -0.012000, -0.028100>,
      <-0.342300, -0.002400, 0.037300>, <-0.342300, -0.002400, 0.031300>, <0.611400, -0.013700, -0.002100>, <1.020600, -0.016200, -0.025800>,
      <-0.342900, -0.001700, 0.035700>, <-0.342900, -0.001700, 0.029700>, <0.612000, -0.007600, -0.019600>, <1.021300, -0.010100, -0.043300>
    }
  }
}
#declare bicubic21_26 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.340900, -0.004000, 0.040900>, <-0.341000, -0.003300, 0.039300>, <-0.342300, -0.002400, 0.037300>, <-0.342900, -0.001700, 0.035700>,
      <0.051200, -0.007900, 0.023900>, <0.051100, -0.007200, 0.022200>, <-0.342300, -0.002400, 0.031300>, <-0.342900, -0.001700, 0.029700>,
      <0.574100, -0.013000, 0.001200>, <0.587200, -0.008100, -0.011000>, <0.611400, -0.013700, -0.002100>, <0.612000, -0.007600, -0.019600>,
      <0.966200, -0.016900, -0.015900>, <0.979300, -0.012000, -0.028100>, <1.020600, -0.016200, -0.025800>, <1.021300, -0.010100, -0.043300>
    }
  }
}
#declare bicubic22_27 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.021300, -0.010100, -0.043300>, <1.021900, -0.004600, -0.058800>, <0.983100, -0.004000, -0.046700>, <0.967600, -0.004300, -0.052000>,
      <0.612000, -0.007600, -0.019600>, <0.612600, -0.002100, -0.035100>, <0.590700, -0.002700, -0.022900>, <0.575200, -0.003000, -0.028200>,
      <-0.342900, -0.001700, 0.029700>, <-0.342200, -0.001200, 0.027100>, <0.051600, -0.001800, 0.006100>, <0.052000, -0.001300, 0.003400>,
      <-0.342900, -0.001700, 0.035700>, <-0.342200, -0.001200, 0.033100>, <-0.340800, -0.000500, 0.029800>, <-0.340400, 0.000000, 0.027200>
    }
  }
}
#declare bicubic23_28 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <1.021300, -0.010100, -0.043300>, <0.612000, -0.007600, -0.019600>, <-0.342900, -0.001700, 0.029700>, <-0.342900, -0.001700, 0.035700>,
      <1.021900, -0.004600, -0.058800>, <0.612600, -0.002100, -0.035100>, <-0.342200, -0.001200, 0.027100>, <-0.342200, -0.001200, 0.033100>,
      <0.983100, -0.004000, -0.046700>, <0.590700, -0.002700, -0.022900>, <0.051600, -0.001800, 0.006100>, <-0.340800, -0.000500, 0.029800>,
      <0.967600, -0.004300, -0.052000>, <0.575200, -0.003000, -0.028200>, <0.052000, -0.001300, 0.003400>, <-0.340400, 0.000000, 0.027200>
    }
  }
}
#declare bicubic24_29 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.353000, -0.116300, 0.013700>, <0.023000, -0.270300, -0.043200>, <0.524400, -0.475500, -0.119100>, <0.900300, -0.629400, -0.176000>,
      <-0.353100, -0.117400, 0.013700>, <0.022900, -0.271300, -0.043200>, <0.526800, -0.477300, -0.113700>, <0.902800, -0.631200, -0.170600>,
      <-0.353700, -0.116600, 0.016000>, <0.025100, -0.272200, -0.036500>, <0.532700, -0.479100, -0.111000>, <0.911500, -0.634800, -0.163600>,
      <-0.354100, -0.116600, 0.017000>, <0.024700, -0.272300, -0.035500>, <0.529800, -0.479800, -0.105600>, <0.908700, -0.635400, -0.158100>
    }
  }
}
#declare bicubic25_30 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.354100, -0.116600, 0.017000>, <0.024700, -0.272300, -0.035500>, <0.529800, -0.479800, -0.105600>, <0.908700, -0.635400, -0.158100>,
      <-0.354800, -0.116800, 0.019000>, <0.024000, -0.272500, -0.033500>, <0.522800, -0.481500, -0.092100>, <0.901600, -0.637100, -0.144700>,
      <-0.356400, -0.117000, 0.021600>, <0.012200, -0.272600, -0.022200>, <0.503900, -0.478500, -0.093700>, <0.872500, -0.634100, -0.137500>,
      <-0.356500, -0.117200, 0.023700>, <0.012200, -0.272900, -0.020100>, <0.503700, -0.480400, -0.078600>, <0.872300, -0.636000, -0.122400>
    }
  }
}
#declare bicubic26_31 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.356500, -0.117200, 0.023700>, <0.012200, -0.272900, -0.020100>, <0.503700, -0.480400, -0.078600>, <0.872300, -0.636000, -0.122400>,
      <-0.356500, -0.117500, 0.025800>, <0.012100, -0.273100, -0.018000>, <0.503500, -0.482300, -0.063400>, <0.872100, -0.637900, -0.107200>,
      <-0.354900, -0.118000, 0.028400>, <0.023700, -0.275800, -0.006700>, <0.522100, -0.487100, -0.065100>, <0.900700, -0.644900, -0.100200>,
      <-0.354300, -0.118300, 0.030400>, <0.024300, -0.276100, -0.004700>, <0.529100, -0.486500, -0.051500>, <0.907700, -0.644300, -0.086600>
    }
  }
}
#declare bicubic27_32 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.354300, -0.118300, 0.030400>, <0.024300, -0.276100, -0.004700>, <0.529100, -0.486500, -0.051500>, <0.907700, -0.644300, -0.086600>,
      <-0.353900, -0.118500, 0.031400>, <0.024700, -0.276300, -0.003700>, <0.532100, -0.486300, -0.045600>, <0.910700, -0.644100, -0.080700>,
      <-0.353100, -0.118700, 0.032700>, <0.022800, -0.273300, 0.002000>, <0.519700, -0.478700, -0.043000>, <0.895600, -0.633200, -0.073800>,
      <-0.353200, -0.118800, 0.033800>, <0.022700, -0.273400, 0.003000>, <0.523900, -0.479400, -0.038000>, <0.899900, -0.634000, -0.068800>
    }
  }
}
#declare bicubic28_33 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.353200, -0.118800, 0.033800>, <0.022700, -0.273400, 0.003000>, <0.523900, -0.479400, -0.038000>, <0.899900, -0.634000, -0.068800>,
      <-0.353500, -0.119000, 0.035800>, <0.022400, -0.273600, 0.005100>, <0.536500, -0.481700, -0.023100>, <0.912500, -0.636200, -0.053900>,
      <-0.355600, -0.119800, 0.038300>, <0.036700, -0.279700, 0.016000>, <0.559700, -0.494000, -0.031300>, <0.952100, -0.653900, -0.053600>,
      <-0.355600, -0.119300, 0.040300>, <0.036800, -0.279200, 0.018000>, <0.559900, -0.492400, -0.011700>, <0.952200, -0.652300, -0.034000>
    }
  }
}
#declare bicubic29_34 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.353200, -0.118800, 0.033800>, <-0.353500, -0.119000, 0.035800>, <-0.355600, -0.119800, 0.038300>, <-0.355600, -0.119300, 0.040300>,
      <0.022700, -0.273400, 0.003000>, <0.022400, -0.273600, 0.005100>, <0.036700, -0.279700, 0.016000>, <0.036800, -0.279200, 0.018000>,
      <0.523900, -0.479400, -0.038000>, <0.536500, -0.481700, -0.023100>, <0.559700, -0.494000, -0.031300>, <0.559900, -0.492400, -0.011700>,
      <0.899900, -0.634000, -0.068800>, <0.912500, -0.636200, -0.053900>, <0.952100, -0.653900, -0.053600>, <0.952200, -0.652300, -0.034000>
    }
  }
}
#declare bicubic30_35 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.355600, -0.119300, 0.040300>, <0.036800, -0.279200, 0.018000>, <0.559900, -0.492400, -0.011700>, <0.952200, -0.652300, -0.034000>,
      <-0.355500, -0.118700, 0.042200>, <0.036800, -0.278700, 0.019900>, <0.560100, -0.490700, 0.008500>, <0.952400, -0.650600, -0.013800>,
      <-0.353300, -0.116800, 0.043600>, <0.022800, -0.270500, 0.030700>, <0.536200, -0.482200, 0.000600>, <0.912300, -0.635900, -0.012400>,
      <-0.352900, -0.115800, 0.045200>, <0.023100, -0.269400, 0.032300>, <0.524500, -0.474300, 0.015100>, <0.900500, -0.628000, 0.002100>
    }
  }
}
#declare bicubic31_36 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.355600, -0.119300, 0.040300>, <-0.355500, -0.118700, 0.042200>, <-0.353300, -0.116800, 0.043600>, <-0.352900, -0.115800, 0.045200>,
      <0.036800, -0.279200, 0.018000>, <0.036800, -0.278700, 0.019900>, <0.022800, -0.270500, 0.030700>, <0.023100, -0.269400, 0.032300>,
      <0.559900, -0.492400, -0.011700>, <0.560100, -0.490700, 0.008500>, <0.536200, -0.482200, 0.000600>, <0.524500, -0.474300, 0.015100>,
      <0.952200, -0.652300, -0.034000>, <0.952400, -0.650600, -0.013800>, <0.912300, -0.635900, -0.012400>, <0.900500, -0.628000, 0.002100>
    }
  }
}
#declare bicubic32_37 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.352900, -0.115800, 0.045200>, <0.023100, -0.269400, 0.032300>, <0.524500, -0.474300, 0.015100>, <0.900500, -0.628000, 0.002100>,
      <-0.352700, -0.115200, 0.046100>, <0.023300, -0.268900, 0.033200>, <0.521200, -0.472100, 0.019200>, <0.897200, -0.625700, 0.006300>,
      <-0.353500, -0.114700, 0.047400>, <0.025600, -0.267600, 0.038400>, <0.533200, -0.473200, 0.022600>, <0.912300, -0.626100, 0.013600>,
      <-0.353800, -0.114200, 0.048300>, <0.025300, -0.267100, 0.039300>, <0.530800, -0.470900, 0.027300>, <0.909900, -0.623800, 0.018300>
    }
  }
}
#declare bicubic33_38 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.353800, -0.114200, 0.048300>, <0.025300, -0.267100, 0.039300>, <0.530800, -0.470900, 0.027300>, <0.909900, -0.623800, 0.018300>,
      <-0.354400, -0.113200, 0.050100>, <0.024700, -0.266100, 0.041100>, <0.524400, -0.464800, 0.039800>, <0.903500, -0.617700, 0.030800>,
      <-0.355900, -0.111900, 0.052400>, <0.013600, -0.259900, 0.051300>, <0.505600, -0.462900, 0.038000>, <0.875100, -0.610800, 0.036900>,
      <-0.355800, -0.111000, 0.054300>, <0.013700, -0.258900, 0.053200>, <0.506300, -0.456200, 0.051700>, <0.875800, -0.604100, 0.050600>
    }
  }
}
#declare bicubic34_39 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.355800, -0.111000, 0.054300>, <0.013700, -0.258900, 0.053200>, <0.506300, -0.456200, 0.051700>, <0.875800, -0.604100, 0.050600>,
      <-0.355700, -0.110000, 0.056200>, <0.013800, -0.258000, 0.055100>, <0.507000, -0.449400, 0.065400>, <0.876500, -0.597400, 0.064300>,
      <-0.354000, -0.109100, 0.058600>, <0.026000, -0.254200, 0.065300>, <0.526000, -0.452800, 0.064100>, <0.905900, -0.598000, 0.070900>,
      <-0.353200, -0.108300, 0.060400>, <0.026800, -0.253400, 0.067100>, <0.533400, -0.446900, 0.076200>, <0.913300, -0.592100, 0.082900>
    }
  }
}
#declare bicubic35_40 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.353200, -0.108300, 0.060400>, <0.026800, -0.253400, 0.067100>, <0.533400, -0.446900, 0.076200>, <0.913300, -0.592100, 0.082900>,
      <-0.352800, -0.107900, 0.061300>, <0.027200, -0.253000, 0.068000>, <0.536500, -0.444500, 0.081200>, <0.916400, -0.589600, 0.088000>,
      <-0.351900, -0.107400, 0.062500>, <0.025400, -0.249400, 0.073200>, <0.524800, -0.441500, 0.084100>, <0.902000, -0.583600, 0.094800>,
      <-0.351900, -0.106900, 0.063400>, <0.025300, -0.248900, 0.074100>, <0.528300, -0.438300, 0.088400>, <0.905600, -0.580400, 0.099100>
    }
  }
}
#declare bicubic36_41 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.351900, -0.106900, 0.063400>, <0.025300, -0.248900, 0.074100>, <0.528300, -0.438300, 0.088400>, <0.905600, -0.580400, 0.099100>,
      <-0.352100, -0.105900, 0.065300>, <0.025200, -0.247900, 0.076000>, <0.537400, -0.430200, 0.099300>, <0.914700, -0.572300, 0.110000>,
      <-0.354000, -0.105000, 0.068000>, <0.036800, -0.242100, 0.084900>, <0.529600, -0.422400, 0.101200>, <0.937700, -0.565500, 0.118800>,
      <-0.353900, -0.103400, 0.069500>, <0.037000, -0.240500, 0.086300>, <0.540800, -0.417200, 0.108100>, <0.948900, -0.560300, 0.125700>
    }
  }
}
#declare bicubic37_42 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <0.948900, -0.560300, 0.125700>, <0.937000, -0.550700, 0.133200>, <0.918500, -0.541000, 0.140800>, <0.911100, -0.529600, 0.149800>,
      <0.540800, -0.417200, 0.108100>, <0.528900, -0.407600, 0.115600>, <0.539900, -0.411400, 0.117400>, <0.532500, -0.400000, 0.126400>,
      <0.037000, -0.240500, 0.086300>, <0.037100, -0.239000, 0.087700>, <0.027200, -0.229100, 0.094300>, <0.027700, -0.227200, 0.095200>,
      <-0.353900, -0.103400, 0.069500>, <-0.353700, -0.101900, 0.070800>, <-0.351400, -0.099500, 0.070900>, <-0.350900, -0.097700, 0.071700>
    }
  }
}
#declare bicubic38_43 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.350900, -0.097700, 0.071700>, <0.027700, -0.227200, 0.095200>, <0.532500, -0.400000, 0.126400>, <0.911100, -0.529600, 0.149800>,
      <-0.350700, -0.096700, 0.072100>, <0.027900, -0.226300, 0.095600>, <0.530000, -0.396300, 0.129400>, <0.908600, -0.525900, 0.152800>,
      <-0.351500, -0.095600, 0.072900>, <0.030400, -0.222600, 0.098600>, <0.541400, -0.395300, 0.130800>, <0.923300, -0.522300, 0.156600>,
      <-0.351700, -0.094700, 0.073500>, <0.030200, -0.221700, 0.099200>, <0.539400, -0.391000, 0.133400>, <0.921300, -0.518100, 0.159100>
    }
  }
}
#declare bicubic39_44 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.351700, -0.094700, 0.073500>, <0.030200, -0.221700, 0.099200>, <0.539400, -0.391000, 0.133400>, <0.921300, -0.518100, 0.159100>,
      <-0.352200, -0.092900, 0.074500>, <0.029700, -0.219900, 0.100200>, <0.533500, -0.378900, 0.140700>, <0.915400, -0.506000, 0.166400>,
      <-0.353600, -0.090500, 0.075800>, <0.019100, -0.208900, 0.106100>, <0.514700, -0.378100, 0.139600>, <0.887300, -0.496500, 0.169800>,
      <-0.353400, -0.088700, 0.076900>, <0.019200, -0.207100, 0.107200>, <0.516100, -0.365000, 0.147500>, <0.888700, -0.483500, 0.177700>
    }
  }
}
#declare bicubic40_45 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.353400, -0.088700, 0.076900>, <0.019200, -0.207100, 0.107200>, <0.516100, -0.365000, 0.147500>, <0.888700, -0.483500, 0.177700>,
      <-0.353200, -0.086800, 0.078000>, <0.019400, -0.205300, 0.108300>, <0.517500, -0.352000, 0.155300>, <0.890100, -0.470500, 0.185600>,
      <-0.351300, -0.084800, 0.079400>, <0.032200, -0.196900, 0.114100>, <0.536500, -0.355800, 0.154700>, <0.920000, -0.467900, 0.189500>,
      <-0.350500, -0.083200, 0.080400>, <0.033000, -0.195200, 0.115200>, <0.544400, -0.344600, 0.161500>, <0.927900, -0.456600, 0.196200>
    }
  }
}
#declare bicubic41_46 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.350500, -0.083200, 0.080400>, <0.033000, -0.195200, 0.115200>, <0.544400, -0.344600, 0.161500>, <0.927900, -0.456600, 0.196200>,
      <-0.350000, -0.082300, 0.080900>, <0.033500, -0.194400, 0.115700>, <0.547800, -0.339700, 0.164500>, <0.931300, -0.451700, 0.199200>,
      <-0.349100, -0.081300, 0.081600>, <0.032000, -0.188400, 0.118600>, <0.535500, -0.334900, 0.166300>, <0.916500, -0.442000, 0.203400>,
      <-0.349100, -0.080400, 0.082100>, <0.031900, -0.187500, 0.119200>, <0.540000, -0.330400, 0.168500>, <0.921000, -0.437500, 0.205500>
    }
  }
}
#declare bicubic42_47 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.340400, 0.000000, 0.027200>, <0.052000, -0.001300, 0.003400>, <0.575200, -0.003000, -0.028200>, <0.967600, -0.004300, -0.052000>,
      <-0.340300, 0.000200, 0.026100>, <0.052100, -0.001100, 0.002400>, <0.571600, -0.003000, -0.029400>, <0.964000, -0.004300, -0.053200>,
      <-0.341100, 0.000400, 0.024800>, <0.054000, -0.003000, 0.000000>, <0.582600, -0.007600, -0.030800>, <0.977800, -0.011000, -0.055600>,
      <-0.341500, 0.000600, 0.023800>, <0.053700, -0.002800, -0.000900>, <0.580600, -0.007300, -0.034000>, <0.975800, -0.010800, -0.058700>
    }
  }
}
#declare bicubic43_48 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.341500, 0.000600, 0.023800>, <0.053700, -0.002800, -0.000900>, <0.580600, -0.007300, -0.034000>, <0.975800, -0.010800, -0.058700>,
      <-0.342100, 0.001000, 0.021800>, <0.053100, -0.002400, -0.003000>, <0.572400, -0.006500, -0.046800>, <0.967600, -0.009900, -0.071600>,
      <-0.343700, 0.001600, 0.019300>, <0.041600, 0.000600, -0.014200>, <0.555100, -0.002700, -0.045800>, <0.940300, -0.003700, -0.079200>,
      <-0.343700, 0.001900, 0.017200>, <0.041600, 0.000900, -0.016300>, <0.555300, -0.000400, -0.060900>, <0.940600, -0.001400, -0.094300>
    }
  }
}
#declare bicubic44_49 = object {   object {
    bicubic_patch { type 1 flatness 0.0000 u_steps 3 v_steps 3,
      <-0.343700, 0.001900, 0.017200>, <0.041600, 0.000900, -0.016300>, <0.555300, -0.000400, -0.060900>, <0.940600, -0.001400, -0.094300>,
      <-0.343600, 0.002200, 0.015000>, <0.041600, 0.001200, -0.018400>, <0.555600, 0.001900, -0.076000>, <0.940800, 0.000900, -0.109400>,
      <-0.341100, 0.004800, 0.010600>, <0.054400, 0.004100, -0.031600>, <0.574500, -0.001100, -0.074400>, <0.969900, -0.001800, -0.116500>,
      <-0.341200, 0.002700, 0.010500>, <0.054200, 0.002000, -0.031600>, <0.581500, 0.001000, -0.087800>, <0.977000, 0.000200, -0.129900>
    }
  }
}
#declare union0_4 = union {
  object { bicubic0_5 }
  object { bicubic1_6 }
  object { bicubic2_7 }
  object { bicubic3_8 }
  object { bicubic4_9 }
  object { bicubic5_10 }
  object { bicubic6_11 }
  object { bicubic7_12 }
  object { bicubic8_13 }
  object { bicubic9_14 }
  object { bicubic10_15 }
  object { bicubic11_16 }
  object { bicubic12_17 }
  object { bicubic13_18 }
  object { bicubic14_19 }
  object { bicubic15_20 }
  object { bicubic16_21 }
  object { bicubic17_22 }
  object { bicubic18_23 }
  object { bicubic19_24 }
  object { bicubic20_25 }
  object { bicubic21_26 }
  object { bicubic22_27 }
  object { bicubic23_28 }
  object { bicubic24_29 }
  object { bicubic25_30 }
  object { bicubic26_31 }
  object { bicubic27_32 }
  object { bicubic28_33 }
  object { bicubic29_34 }
  object { bicubic30_35 }
  object { bicubic31_36 }
  object { bicubic32_37 }
  object { bicubic33_38 }
  object { bicubic34_39 }
  object { bicubic35_40 }
  object { bicubic36_41 }
  object { bicubic37_42 }
  object { bicubic38_43 }
  object { bicubic39_44 }
  object { bicubic40_45 }
  object { bicubic41_46 }
  object { bicubic42_47 }
  object { bicubic43_48 }
  object { bicubic44_49 }
  scale <89.115082, 95.200165, 73.510468>
  rotate <90.0, 0.422202, 0.0>
  translate  <20.09683, -9.350051, 3.817691>
}
#declare FSkirt = difference {
  object { union0_4 }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale 33.333332
    translate  <62.444265, -0.780936, -11.360154>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale 128.212326
    rotate <107.784561, -36.504879, 3.125584>
    translate  <197.442283, -32.934854, -102.704755>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale 200.0
    translate  <301.365062, -51.037322, -175.320857>
  }
  texture {
    DrTex2
  }
  scale 0.3 //0.3
  rotate <-5.285279, -10.9806, -3.354081> //<-4.285279, -10.9806, -3.354081>
  translate  <-0.4, 0.34723, -0.37394>
}
// Include contains 'Wing2'
#include "page6w.in1"

#declare Wing2 = object {
  Wing2_Raw
  texture {
    Wing_tex
  }
  scale <1.0, 1.0, 0.1>
  rotate <75.966972, 4.311818, -25.756445>
  translate  <-1.422911, -1.012002, 5.558874>
}
// Include contains 'wing3'
#include "page6w.in2"

#declare wing3 = object {
  wing3_Raw
  texture {
    Wing_tex
  }
  scale <1.0, 1.0, 0.1>
  rotate 81.61087*x
  translate  <-1.640854, 0.0, 5.907076>
}
#declare Wings1 = union {
  object { Wing2 }
  object { wing3 }
  scale 2.0
  rotate <21.406469, -33.725971, -35.224819>
  translate  <5.139105, -1.268419, -2.555592>
}
#declare Fairy1 = union {
  object { Girl1 }
  object { Wand1 }
  object { FSkirt }
  object { Wings1 }
  scale 0.6
  rotate <-1.23, 38.56,21.24 > //<0.0, 39.0, 28.0>
  translate  <12.212289, 14.866736, 4.93534>
}


#declare Pump = union {
  torus { // Torus8
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, 106.762115>
  }
  torus { // Torus7
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, 64.773224>
  }
  torus { // Torus17
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, 19.345379>
  }
  torus { // Torus18
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -20.954004>
  }
  torus { // Torus4
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -140.020325>
  }
  torus { // Torus19
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -46.849075>
  }
  torus { // Torus2
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate <-90.0, 0.0, -90.0>
  }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    texture {
      PumpTex2
    }
    scale <1.467937, 0.676043, 1.0>
    rotate -90.0*x
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      PumpTex3
    }
    scale <2.805561, 2.811541, 1.287961>
  }
  cone { // cone0_17
    <0,0,0>, 0.1, <0,0,1>, 0.3
    texture {
      PumpkinStemTe1
    }
    scale <1.4, 1.4, 1.707494>
    rotate <18.317148, 26.796261, 1.554387>
    translate  <0.169197, 0.15193, 0.705266>
  }
  scale 0.81
  translate  <8.65098, 18.284705, -9.904669>
}



#declare Both = union {
  object { Cindy }
  object { Fairy1 }
  translate  <-8.0, 0.0, -5.0>
}
union { // All
  object { FrontPage }
  object { LetterA_Ref }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Starfield1
    }
    scale <200.259064, 3.989331, 154.674011>
    translate  <0.0, 532.100865, 2.989331>
  }
  object { Clock }
  object { BackGround }
  object { differe3_57 }
  object { WallBack }
  object { Pump }
  object { Digit }
  object { Digit5 }
  object { Digit6 }
  object { Both }
  texture {
    PageTex
  }
  scale 2.0
  rotate 8.0*y
  translate  <8.0, 0.0, 5.0>
}








