// Building
// Robert Fremin 1997
// This is a special building just for the scene "playground".
// A lot of details are missing to make the building complete.
//
// objects:
//		(Window)
//		Building



#declare NumWins   = 5
#declare WinStart  = -2500
#declare WinDist   = 560
#declare WinWidth  = 75		// x2
#declare WinHeight = 200

#declare Window =
union
{
	difference
	{
		box { <-WinWidth,0,0-5> <WinWidth,WinHeight,1+5> }
		box { <-WinWidth+5,0,0-15> <WinWidth-5,WinHeight,1+15> }
		pigment { White }
	}

	box
	{
		<-WinWidth+5,0+5,0> <WinWidth-5,WinHeight-5,1>
		pigment { Clear }
		finish { refraction on ior 1.33 specular .1 reflection .1 }
	}
	box { <-WinWidth,0,0> <WinWidth,3,-30> rotate x*-10 texture { T_Chrome_4B } }
}

#declare Building =
union
{
	difference
	{
		box
		{
			<-3000,0,0> <1500,1000,1000>
			pigment { color <1,.9,.8> }
			normal { dents scale 1 turbulence .9 }
		}

		#declare c = 0
		#while (c < NumWins)
			box {
				<WinStart+c*WinDist-WinWidth-20, 200-20,           -10>
				<WinStart+c*WinDist+WinWidth+20, 200+WinHeight+20, .75>
				pigment { color <1,.9,.8> }
			}
			#declare c = c + 1
		#end

		box { <-3000+20,0+20,0+40> <1500-20,1000-20,1000-20> pigment { White } }

		// window opening
		#declare c = 0
		#while (c < NumWins)
			box
			{
				<WinStart+c*WinDist-WinWidth,200,-10>
				<WinStart+c*WinDist+WinWidth,200+WinHeight,100>
				pigment { color <.9,.8,.7> }
			}
			#declare c = c + 1
		#end
	}

	box { <-3000,0,-1> <1500,100,10> pigment { Grey } normal { bumps scale <1,1,.1> } }		// foundation

	// window
	#declare c = 0
	#while (c < NumWins)
		object { Window translate <WinStart+c*WinDist,200,20> }
		#declare c = c + 1
	#end

	union
	{
		cylinder { <-1100,50,-20> <-1100,1000,-20> 10   }		// tube
		cylinder { <-1100,250,-20> <-1100,270,-20> 10.5 }		// wall attachement
		intersection
		{
			difference
			{
				torus { 20 10 rotate z*90 }
				torus { 20 9 rotate z*90 }
			}
			box { <-50,0,0> <50,-50,50> }

			translate <-1100,50,-40>
		}
		pigment { Gray20 }
		finish { specular .3 ambient .2 phong .5 metallic }
	}

	#declare Cr = seed(4574)
	#declare cc = 0
	#while (cc < NumWins)
		object
		{
			#if (cc = 1 | cc = 4)
				#declare ClosedFactor = .075+0.025*rand(Cr)
			#else
				#declare ClosedFactor = .8+.2*rand(Cr)
			#end
			#declare WhichWindow  = cc
			#declare DrawnFactor  = .3+.7*rand(Cr)
			#include "persienn.inc"
		}
		#declare cc = cc + 1
	#end
}
