// Plastic toys
// by Robert Fremin 1997
//
// objects:	plastic_truck
//			spade
//			bucket
//          sand_shell

#include "mytex.inc"


#declare plastic_truck =
union
{
	union
	{
		difference {
			cylinder { z*-10 z*10 5 }
			cylinder { z*-20 z*-8 3 texture { T_Chrome_3C } }
			cylinder { z*20 z*8 3 texture { T_Chrome_3C } }
			translate x*-15
		}
		difference {
			cylinder { z*-10 z*10 5 }
			cylinder { z*-20 z*-8 3 texture { T_Chrome_3C } }
			cylinder { z*20 z*8 3 texture { T_Chrome_3C } }
			translate x*15
		}
		texture { BlackPlastic }
	}

	union
	{
		intersection {
			box { <-20,0,-20> <20,20,20> }
			difference {
				cylinder { z*-8 z*8 7 }
				cylinder { z*-10 z*10 6 }
			}
			translate x*-15
		}
		intersection {
			box { <-20,0,-20> <20,20,20> }
			difference {
				cylinder { z*-8 z*8 7 }
				cylinder { z*-10 z*10 6 }
			}
			translate x*15
		}
		texture { YellowPlastic }
	}

	union
	{
		cylinder { y*5 y*20 1 translate <-9.5,0,-8.5> }
		superellipsoid { .3 scale <2.5,3,8> translate <-23.5,3,0> }
		difference {
			superellipsoid { .3 scale <8,7,8> }
			box { <-5,-2,-20> <2,3,20> translate y*2 }
			box { <-20,-2,-7> <0,3,7> translate y*2 }
			translate <-17,10,0>
		}
		superellipsoid { .3 scale <15,3,6> translate <8,4,0> }
		superellipsoid { .3 scale <5,4,8> translate <0,2,0> }

		texture { YellowPlastic }
	}

	difference {
		box { <-8,7,-10> <25,18,10> }
		box { <-7,8,-9> <30,20,9> }
		box { <-3,15,-20> <30,25,20> }
		box { <-2,-2,-20> <2,2,20> rotate z*45 translate <-3,18,0> }
		texture { RedPlastic }
	}


	translate y*5
}


#declare plastic_spade =
union
{
	difference
	{
		superellipsoid { .2 scale <5,5,2> }
		superellipsoid { .2 scale <4.5,4.5,2> translate <0,-.5,-.5> }
	}
	superellipsoid { .2 scale <2,6,2> translate y*9.5 }
//	scale .5
	texture { RedPlastic }
}


#declare plastic_bucket =
union
{
	difference
	{
		cone { y*0 8 y*20 10 }
		cone { y*0 7 y*20 9.5 translate y*1 }
	}
	torus { 10 .75 translate y*20 }

	union
	{
		torus { 10 .5 scale <1,1,1.2> clipped_by { plane { z,0 } } rotate x*-35 translate y*19 }
		sphere { <10,19,0> .75 }
		sphere { <-10,19,0> .75 }
		texture { RedPlastic }
	}

	disc { y*17 y 9 texture { Sand } }

	texture { GreenPlastic }
}


#declare sand_shell =
union
{
	#declare c = 0
	#while (c < 10)
		sphere { <5,0,0> 2 rotate y*(360/10)*c }
		sphere { y*3 2 scale <2,1,1> translate x*1 rotate y*(360/10)*c }
		sphere { y*1.7 2 scale <2,1,1> translate x*2.2 rotate y*(360/10)*c }
		#declare c = c + 1
	#end
	texture { YellowPlastic }
}
