// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "CONSTS.INC"
#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
#include "WOODS.INC"
//#include "atmos.inc"
//#include "glass.inc"

#include "mytex.inc"


#declare final = 1
#declare night = 0


camera
{
//	location <160, 190,-1000+1000> look_at <-50, 95, 0+1000>			// closeup on rightmost window
//	location <560, 190+200,-1400-200> look_at <50, 5+100, -450-100>		// final from higher altitude
	location <560, 190,-1400> look_at <50, 5, -450>						// FINAL
	ultra_wide_angle
}

#if (!night)
light_source
{
	<20000, 10000, -10000>
//	color White
	color <1,.7,.7>
	#if (final)
		area_light
		x*100 y*100
		8, 8
		adaptive 0  // 0,1,2,3...
		jitter
	#end
}

light_source { <20000,20000,-15000> color <.8,.8,.5> shadowless }
#end

sky_sphere
{
	#if (final)
		S_Cloud1
	#else
		#if (night)
			pigment { color <.05,.05,.07> }
		#else
			pigment { SkyBlue }
		#end
	#end
}

#declare GrassTexture =
texture
{
	pigment {
		granite
		pigment_map {
			[0.0 ForestGreen]
			[0.1 color <.2,.5,.1>]
			[1.0 Green]
		}
		scale 10
		turbulence .7
	}
//	normal { bumps scale 5 }
	normal { granite scale 10 turbulence .7 }
	finish { diffuse .5 }
}

#declare ground =
height_field
{
	gif "plasma3.gif" smooth
	translate <-.6,0,-.6>
	scale <2000,10,2000>
	clipped_by { plane { z,100 } }
	texture { GrassTexture }
}

#include "swings.inc"
#include "sandbox.inc"
#include "horse.inc"
#include "plasttoy.inc"
#include "lightposts.inc"
#include "building.inc"

// --------------------------------------------------------------------------

#declare fence_tile =
box { <-5,5,0> <5,80,3> texture { T_Wood8 rotate x*90 scale <2,8,5> } }

#declare fence_pole =
cylinder { <5,-20,5> <5,70,5> 5 pigment { Gray40 } }

#declare fence =
union
{
	#declare Num = 100
	#declare c = 0
	#while (c < Num)
		object { fence_tile translate c*x*15 }
		cylinder { <c*15,80,0> <c*15,80,3> 5 }
		sphere { <c*15,20,-3> .75 texture { T_Chrome_3A } }
		sphere { <c*15,65,-3> .75 texture { T_Chrome_3A } }
		#if (mod(c, 20) = 0)
			object { fence_pole translate c*x*15-z*10 }
		#end
		#declare c = c + 1
	#end

	box { <0,60,0> <15*Num,70,-3> }
	box { <0,15,0> <15*Num,25,-3> }

	#declare R = seed(1972)
	#declare c = 0
	#while (c < Num*10)
		triangle
		{
			x*-rand(R) x*rand(R) y*(20+rand(R)*20)
			rotate <rand(R)*20-10,rand(R)*20-10,rand(R)*30-10>
			translate <(c/10)*15+rand(R)*5, 0, -20-18*rand(R)>
			pigment { color <.3+.4*rand(R), .6+.4*rand(R), .2+.3*rand(R)> }
		}
		#declare c = c + 1
	#end

	translate x*-15*Num/2
	texture { T_Wood8 rotate y*90 scale <10,5,10> }
}


#declare duck_wheel =
union
{
	cylinder { y*-.7 y*.7 5 }
	torus { 5 1 }
	sphere { 0 1 scale <2,1.2,2> texture { T_Chrome_3C } }

	rotate x*90
	pigment { Red }
}

#declare duck =
union
{
	object { duck_wheel translate x*-10-z*3 }
	object { duck_wheel translate x*10-z*3 }
	object { duck_wheel translate x*-10+z*3 }
	object { duck_wheel translate x*10+z*3 }

	union {
		cylinder { z*-1 z*1 10 scale <1.5,1,1> translate y*5 }	// body
		cylinder { z*-1 z*1 3 translate x*15+y*5 }				// tail
		cylinder { z*-1 z*1 5 translate x*-10+y*10 }			// neck
		cylinder { z*-1 z*1 4 translate x*-12+y*12 }			// neck
		cylinder { z*-1 z*1 6 translate x*-15+y*15 }			// head
		cylinder { z*-.9999 z*.9999 5 scale <1,.5,1> rotate z*45 translate x*-19+y*9 texture { RedPlastic } }	// beak
		sphere { <-16,15,0> 2.05 texture { WhitePlastic } }	// eye
		sphere { 0 2.5 scale <.5,.5,1> translate <-16,15,0> texture { BlackPlastic } }	// eye
		texture { YellowPlastic }
	}

	torus { 1.5 .3 rotate x*90 translate x*-16.5+y*2 texture { T_Chrome_3C } }	// string loop
	cylinder { <-10,0,-3> <-10,0,3> 1 texture { T_Chrome_3C } }
	cylinder { <10,0,-3> <10,0,3> 1 texture { T_Chrome_3C } }

	translate y*5
}

#declare Street =
union
{
	box
	{
		<-3000,0,100+300+10> <1500,1,100+300+1000-10>

		pigment { Gray20 }
		normal { bumps scale 2 }
		finish { specular .2 }
	}

	union
	{
		#declare c = 0
		#declare c2 = 0
		#while (c < 45)
			box { <0,0,-10> <50,2,10> translate <-3000+c*100,0,100+300+30> }
			box { <0,0,-10> <50,2,10> translate <-3000+c*100,0,100+300+1000-30> }
			#if (mod(c, 4) = 0)
				#declare c2 = c2 + 1
				box { <0,0,-10> <200,2,10> translate <-3000+c2*400,0,100+300+1000/2> }
			#end
			#declare c = c + 1
		#end

		pigment { White }
		finish { ambient .4 }
	}
}

#declare SideWalks =
union
{
	union
	{
		box { <-3000,0,100> <1500,10,100+300> }
		difference
		{
			box { <-3000,0,100+300+1000> <1500,10,100+300+1000+300> }
			box { <-1100-10, 5, 100+300+1000> <-1100+10, 50, 100+300+1000+300> pigment { Grey } }
		}
		#if (final)
			normal { bump_map { tga "platta.tga" } rotate x*90 scale 100 }
		#end
		pigment { image_map { tga "platta.tga" } rotate x*90 scale 100 }
	}

	union
	{
		#declare c = 0
		#while (c < 45)
			box { <0,0,0> <95,10,10> translate <-3000+c*100,0,100+300> }
			box { <0,0,0> <95,10,10> translate <-3000+c*100,0,100+300+1000-10> }
			#declare c = c + 1
		#end

		pigment
		{
			bumps
			pigment_map
			{
				[0.0 Gray70]
				[1.0 White]
			}
		}
	}
}

#declare Tree =
object { #include "\povwin3\tree construction\trees.inc" scale 30 }


// --------------------------------------------------------------------------

object { ground }
object { Tree translate <700,0,-500> }
object { Tree scale .7 rotate y*45 translate <800,0,-300> }
object { Tree scale 1.5 rotate y*115 translate <900,0,-900> }
object { Tree rotate y*245 translate <600,0,-1200> }

object { Building translate <0,0,100+300+1000+300> }
object { Street }
object { SideWalks }
object { lightpost3 rotate y*-90 translate <-1000, 10, 100+250> }
object { lightpost3 rotate y*-90 translate <  200, 10, 100+250> }
object { fence }
object { fence rotate y*-90 translate <-15*50,0,-15*50> }

//#declare sand_play =
union {
		object { sandbox translate x*-125-z*125 }
	object { plastic_truck rotate y*30 translate <50,7,70> }
	object { plastic_spade rotate x*35+y*-55 translate <-30,14,36> }
	object { plastic_bucket rotate y*45+z*-10 translate <20,6,-30> }
	object { sand_shell translate <-120,26,-80> }

	#declare R = seed(19273)
	#declare c = 0
	#while (c < 200)
		triangle
		{
			x*-rand(R) x*rand(R) y*(3+rand(R)*5)
			rotate <rand(R)*10-10,rand(R)*20-10,rand(R)*20-10>
			translate <c*1.25-125+rand(R), 5, -125-11-rand(R)*8>
			pigment { color <.2*rand(R),.5+.4*rand(R),.2*rand(R)> }
		}
		triangle
		{
			x*-rand(R) x*rand(R) y*(3+rand(R)*5)
			rotate <rand(R)*20-10,rand(R)*20-10,rand(R)*30-10>
			translate <125+rand(R)*8, 5, c*1.25-125+rand(R)>
			pigment { color <.2*rand(R),.5+.4*rand(R),.2*rand(R)> }
		}
		#declare c = c + 1
	#end

	translate <300,0,-700>
}
object { horse rotate y*25 translate <200,0,-300> }
object { HorseGrass rotate y*25 translate <200,0,-300> }
object { horse rotate y*20 translate <330,0,-300> }
object { HorseGrass rotate y*20 translate <330,0,-300> }
object { complete_swing rotate y*90 translate z*-300-x*450 }
object { duck rotate x*-100 translate <-50,8,-600> }
