// Rack with three swings.
// by Robert Fremin 1997
//
// objects:	rack
//			swing (chains + tire)
//			complete_swing (3 swings + rack)
//			(rack)


#declare chainlink =
torus
{
	1.5 .5
	rotate x*90
	scale <1,2,1>
}


#declare chains =
union
{
	#declare Ra = seed(4656574)
	#declare Rb = seed(908234)
	#declare ang1 = rand(Ra)
	#declare ang2 = rand(Rb)
	#declare cwidth = 26  // chain angle
	#declare c = 0
	#while (c < 25)
		object { chainlink rotate y*ang1 translate x*-cwidth+y*(-4.5*c+222) }
		object { chainlink rotate y*ang2 translate x*cwidth+y*(-4.5*c+222) }
		#declare c = c + 1
		#declare ang1 = ang1 + 90 + rand(Ra)*45-22.5
		#declare ang2 = ang2 + 90 + rand(Rb)*45-22.5
	#end
	#declare c1 = c
	#declare c = 0
	#while (c < 11)
		object { chainlink rotate y*ang1 translate x*-cwidth+y*(-4.5*c) rotate x*-15 translate y*(222+c1*-4.5) }
		object { chainlink rotate y*ang2 translate x*cwidth+y*(-4.5*c)  rotate x*-15 translate y*(222+c1*-4.5) }
		object { chainlink rotate y*ang1 translate x*-cwidth+y*(-4.5*c) rotate x*15  translate y*(222+c1*-4.5) }
		object { chainlink rotate y*ang2 translate x*cwidth+y*(-4.5*c)  rotate x*15  translate y*(222+c1*-4.5) }
		#declare c = c + 1
		#declare ang1 = ang1 + 90 + rand(Ra)*45-22.5
		#declare ang2 = ang2 + 90 + rand(Rb)*45-22.5
	#end

	#declare SwingHeight = y*(222+(c1+c)*-4.5-10)

	// plate on tire
	cylinder { y*1 y*-1 3 rotate x*15  translate x*-cwidth+y*(-4.5*c) rotate x*-15 translate y*(222+c1*-4.5) }
	cylinder { y*1 y*-1 3 rotate x*15  translate x*cwidth+y*(-4.5*c)  rotate x*-15 translate y*(222+c1*-4.5) }
	cylinder { y*1 y*-1 3 rotate x*-15 translate x*-cwidth+y*(-4.5*c) rotate x*15  translate y*(222+c1*-4.5) }
	cylinder { y*1 y*-1 3 rotate x*-15 translate x*cwidth+y*(-4.5*c)  rotate x*15  translate y*(222+c1*-4.5) }

	// rings on tire
	#declare c = c - .5
	torus { 2 .75 rotate x*90 rotate x*15  translate x*-cwidth+y*(-4.5*c) rotate x*-15 translate y*(222+c1*-4.5) }
	torus { 2 .75 rotate x*90 rotate x*15  translate x*cwidth+y*(-4.5*c)  rotate x*-15 translate y*(222+c1*-4.5) }
	torus { 2 .75 rotate x*90 rotate x*-15 translate x*-cwidth+y*(-4.5*c) rotate x*15  translate y*(222+c1*-4.5) }
	torus { 2 .75 rotate x*90 rotate x*-15 translate x*cwidth+y*(-4.5*c)  rotate x*15  translate y*(222+c1*-4.5) }

	difference {
		box { <-cwidth-1,235,5> <-cwidth+1,222,-5> }
		cylinder { <-40,226,0> <-20,226,0> 3 }
		pigment { Red }
	}

	difference
	{
		box { <cwidth-1,235,5> <cwidth+1,222,-5> }
		cylinder { <20,226,0> <40,226,0> 3 }
		pigment { Red }
	}

	texture { T_Chrome_3A }
}

#declare GrassAtBase =
union
{
	#declare Rr = seed(31874)
	#declare c = 0
	#while (c < 40)
		triangle
		{
			x*-1.1*rand(Rr) x*1.1*rand(Rr) y*(5+rand(Rr)*10)
			rotate <rand(Rr)*20-10, rand(Rr)*20-10, rand(Rr)*20-10>
			translate <rand(Rr)*20-10, 0, rand(Rr)*20-10>
			pigment { color <.3*rand(Rr), .4+.3*rand(Rr), .2*rand(Rr)> }
		}
		#declare c = c + 1
	#end
}

#declare rack_ =
union
{
	#declare r1 = <0,-5,-150>
	#declare r2 = <0,-5, 150>

	cylinder { r1 <0,235,0>+vrotate(z*-10,x*45) 5 }
	cylinder { r2 <0,235,0>+vrotate(z*10,x*-45) 5 }
	intersection
	{
		torus { 10 5 rotate z*90 }
		box { <-1,-1,-1> <1,1,1> scale 20 translate <0,18,-18> }
		rotate x*45
		translate y*235
	}
	cylinder { <0,225,-15> <0,225,15> 5 }
	cylinder { <0,218,0> <0,252,0> 2 texture { T_Chrome_3C } }

	object { GrassAtBase translate r1+y*10+z*5 }
	object { GrassAtBase translate r2+y*10-z*5 }
}

#declare Rust =
texture { T_Chrome_3B pigment { color <.6,.4,.2> } }

#declare rack =
union
{
	object { rack_ translate x*-200 }
	cylinder { <-210,235,0> <210,235,0> 5 }
	object { rack_ translate x*200 }

	texture
	{
		granite
		texture_map
		{
			[0.0 pigment { Red } ]
			[0.9 Rust ]
			[1.0 T_Chrome_2A ]
		}
		scale 200
		turbulence .8
	}
}


#declare tire =
union
{
	difference
	{
		intersection
		{
			cylinder { y*15 y*-15 38 }
			torus { 30 10 }
		}
		torus { 28 8.5 }
	}
	torus { 23 1 translate y*6.5 }
	torus { 23 1 translate y*-6.5 }

	scale <1,1.15,1>
	translate y*SwingHeight
	pigment { color <.2,.2,.2> }
	finish { specular .2 ambient .2 diffuse .5 }
	normal { bumps scale <20,.5,20> }
}


#declare swing =
union
{
	object { chains }
	object { tire }
}


#declare complete_swing =
union
{
	object { rack }
	object { swing translate x*-125 }
	object { swing translate x*0 }
	object { swing translate x*125 }
}
