/***************************************************************************/
//		pooh.inc
/***************************************************************************/
//				Constants
/***************************************************************************/
//blob constants
#declare T = 0.57	//0.25	//threshold
#declare R = 2	//1.5	//radius
#declare S = 1	//0.81	//strength

//Winnie the Pooh
#declare Pooh_Right_Arm_Angle = 25
#declare Pooh_Left_Arm_Angle = -145
/***************************************************************************/
//				Textures
/***************************************************************************/
#declare Fur_Texture =
texture{
  pigment{ color (Tan*1+Orange*1+DarkWood*1+Gold*3)/6 }
  normal{ bumps 0.2 scale 0.025 }
  finish{
    ambient 0.1
    diffuse 0.6
    brilliance 0.75
  }
}
#declare Pooh_Shirt_Texture =
texture{
  pigment{ color (Red+Scarlet)/2 }
  normal{ bumps 0.1 scale 0.025 }
  finish{
    ambient 0.1
    diffuse 0.6
    brilliance 0.75
  }
}
/***************************************************************************/
#declare Pooh_Leg =
blob{
  threshold T
  sphere{ 0,R,S scale <0.8,1.5,0.8> translate <0,-1.5,0> }
  sphere{ 0,R,S scale <0.675,1.5,0.675> translate <0,-2,0> }
  sphere{ 0,R,S scale <0.75,0.5,1.25> translate <0,-4,0.5> }
  texture{ Fur_Texture }
}
#declare Pooh_Tummy =
blob{
  threshold T
  sphere{ 0,R,S scale <2.5,2.5,2.5> }
  texture{ Fur_Texture }
}
#declare Pooh_Shirt =
blob{
  threshold T
  //main part
//  sphere{ 0,R,S scale <2.25,2.25,2.25> translate <0,0.125,0> }
  sphere{ 0,R,S scale <2.325,2.5,2.325> translate <0,0.125-0.25,0> }
  sphere{ 0,R,-S*2.25 scale <2.125,2.5,2.125> translate <0,-4.5,0> }
  
  //collar
  sphere{ 0,R,S scale <0.85,0.3,0.85> translate <0,2.125,-0.25> }
  
  //right sleeve
  sphere{ 0,R,S scale <0.75,1,0.75> translate <0,-1,0> rotate z*Pooh_Right_Arm_Angle translate <1.75,1.5,0> }
  sphere{ 0,R,-S*2.25 scale <0.75,1,0.75> translate <0,-2.875,0> rotate z*Pooh_Right_Arm_Angle translate <1.75,1.5,0> }
  
  //left sleeve
  sphere{ 0,R,S scale <0.75,1,0.75> translate <0,-1,0> rotate z*Pooh_Left_Arm_Angle translate <-1.75,1.5,0> }
  sphere{ 0,R,-S*2.25 scale <0.75,1,0.75> translate <0,-2.875,0> rotate z*Pooh_Left_Arm_Angle translate <-1.75,1.5,0> }
  texture{ Pooh_Shirt_Texture }
}
#declare Pooh_Right_Arm =
blob{
  threshold T
  //the arm itself
  sphere{ 0,R,S scale <0.875,2.25,0.875> translate <0,-2,0> rotate z*Pooh_Right_Arm_Angle translate <1.75,1.5,0> }
  
  //the hand and thumb
  sphere{ 0,R,S scale <0.25,0.625,0.5> translate <0,-0.25,0> rotate z*-20 translate <0,-4,0> rotate y*20+z*Pooh_Right_Arm_Angle translate <1.75,1.5,0> }
  sphere{ 0,R,S*2 scale <0.25,0.25,0.5> translate <0,0.1,0.375> rotate z*-20 translate <0,-4,0> rotate y*20+z*Pooh_Right_Arm_Angle translate <1.75,1.5,0> }
  texture{ Fur_Texture }
}
#declare Pooh_Left_Arm =
blob{
  threshold T
  //the arm itself
  sphere{ 0,R,S scale <0.875,2.25,0.875> translate <0,-2,0> rotate z*Pooh_Left_Arm_Angle translate <-1.75,1.5,0> }
  
  //the hand and thumb
  sphere{ 0,R,S scale <0.25,0.625,0.5> translate <0,-0.25,0> rotate z*0 translate <0,-4,0> rotate y*-60+z*Pooh_Left_Arm_Angle translate <-1.75,1.5,0> }
  sphere{ 0,R,S*2 scale <0.25,0.25,0.5> translate <0,0.1,0.375> rotate z*0 translate <0,-4,0> rotate y*-60+z*Pooh_Left_Arm_Angle translate <-1.75,1.5,0> }
  texture{ Fur_Texture }
}
#declare Pooh_Head =
blob{
  threshold T
  //lower skull
  sphere{ 0,R,S scale <1.2,1,1> translate <0,-0.5,-0.5> }
  sphere{ 0,R,S scale <0.9,0.875,0.875> translate <0,-0.5,0> }
  sphere{ 0,R,S scale <0.9,0.75,0.75> translate <0,-0.5,0.25> }
  
  //nose
  sphere{ 0,R,S*3 scale <0.5,0.375,0.75> rotate x*-15 translate <0,-0.625,0.6> }
  
  //upper skull
  sphere{ 0,R,S scale <1.2,1,1> translate <0,0.5,-0.25> }
  
  //ears
  sphere{ 0,R,S scale <0.175,0.4,0.3> translate <1.25,1.1,-0.625> }
  sphere{ 0,R,S scale <0.175,0.4,0.3> translate <-1.25,1.1,-0.625> }
  texture{ Fur_Texture }
}

/***************************************************************************/
#declare Pooh =
union{
  object{ Pooh_Leg scale <1.,1,1.> translate <1.375,0.2,0.125> }
  object{ Pooh_Leg scale <1.,1,1.> translate <-1.375,0.2,0.125> }
  object{ Pooh_Tummy translate <0,0.75,0.375> }
  object{ Pooh_Shirt translate <0,2,0> }
  object{ Pooh_Right_Arm translate <0,2,0> }
  object{ Pooh_Left_Arm translate <0,2,0> }
  object{ Pooh_Head scale 1.2 translate <0,5.75,0> }
}
