/***************************************************************************/
//		pooh.pov
/***************************************************************************/
#include "colors.inc"

#declare Zoom = 1
#declare Vector = <40,35,-30>
//#declare Vector = <0,0,150>
#declare Look_At = <0,40,5>
camera{
//  orthographic
  location Vector
  direction <0,0,Zoom>
  up <0,1,0>//*20
  right <4/3,0,0>//*20
  look_at Look_At
}
light_source{ (Vector + <0,0,0>) rgb 1/2 }

//the light from the sunset
#declare Lights = 4
light_source{
  <90,85,120>
  color (Orange*1+White*0)
  area_light <20,20,0>,<-20,-20,0> Lights,Lights
  adaptive 1
  jitter
}

#declare Q = seed(0)
global_settings{ max_trace_level 20 }
/***************************************************************************/
//				Scene Elements
/***************************************************************************/
#declare Sky_Visible        = 1
#declare Clouds_Visible     = 1
#declare Hill_Visible       = 1
#declare Characters_Visible = 1
#declare Tree_Visible       = 1
#declare Leaves_Visible     = 1
#declare Text               = 1
/***************************************************************************/
//				The Sky
/***************************************************************************/
#if (Sky_Visible = 1)
sphere{ 0,1
  texture{
    pigment{
      gradient y
      scale 1.1
      translate <0,-0.2,0>
      color_map{
        [0.00 color (Pink*1+Red*1+Orange*3)/5]
        [0.75 color (Violet*4+Pink*1)/9]
        [1.00 color (Violet*4+Pink*1)/9]
      }
    }
    finish{ ambient 1 diffuse 0 }
  }
  scale 10000
  no_shadow
  hollow
}
#end
/***************************************************************************/
//				Textures
/***************************************************************************/
#declare Grass_Texture =
texture{
  pigment{
    bozo
    scale 3
    turbulence 1
    lambda 3
    color_map{
      [0.0 color (DarkGreen*2+ForestGreen*3+Orange*2)/7]
      [1.0 color (DarkGreen*3+ForestGreen*2+Orange*2)/7]
    }
  }
  normal{ bumps 0.3 scale 0.1 }
  finish{
    ambient 0.0
    diffuse 0.8
    brilliance 0.5
  }
}
#declare Cloud_Texture =
texture{
  pigment{
    onion
    scale <1,1,100>*2
//    turbulence 0.1
    omega 0.25
    lambda 4
    color_map{
      [0.00/2 color (White*1+Pink*1)/2]
      [0.25/2 color (White*1+Pink*1)/2]
//      [0.80/2 color (Pink*4+Red*1+White*1)/6 transmit 0.0]
      [0.80/2 color (Pink*4+Red*1+White*1)/6 transmit 0.0]
      [1.00/2 color (Pink*4+Red*1+White*1)/6 transmit 1.0]
      [1.00/1 color (Pink*4+Red*1+White*1)/6 transmit 1.0]
    }
  }
  finish{ ambient 0.175 diffuse 0.525 brilliance 0 }
}
/***************************************************************************/
//				The Clouds
/***************************************************************************/
#if (Clouds_Visible = 1)
#declare C = 0
#declare N = 35
union{
  #while (C < N)
    //sphere{ 0,1
    disc{ 0,z,1.5
      texture{ Cloud_Texture }
      #declare Cloud_Size = 30+20*rand(Q)
      scale <Cloud_Size,Cloud_Size*3/4,0.1>
      translate <sin(C/N*pi*20+rand(Q))*150*(C/N+0.5)*3/4,-200*C/N,-C/N*100>
    }
    #declare C = C+1
  #end
  pigment{ White }
  translate <0,0,60>
  rotate y*-50
  translate <-100,40,90-15>
  no_shadow
}
#end
/***************************************************************************/
//				The Hill
/***************************************************************************/
#if (Hill_Visible = 1)
#declare T = 0.57	//0.25	//threshold
#declare R = 2	//1.5	//radius
#declare S = 1	//0.81	//strength

#declare HW = 45
#declare HH = 20
#declare HL = 60
blob{
  threshold T
  
  #declare C = 0
  #declare N = 350
  #while (C < N)
    sphere{ 0,R,S
      #declare Ball_Location = <HW*rand(Q),pow(C/N,1/2)*HH,C/N*HL-HL/2>
      scale <2.5,1.5,2>*2
//      scale <1.5+1*rand(Q),1+0.5*rand(Q),1+1*rand(Q)>*2
      translate Ball_Location
      translate y*(-pow(Ball_Location.x/HW,3)*Ball_Location.y)
      translate x*(-pow(Ball_Location.z/HL*Ball_Location.x/HW,1/1)*20)
    }
    #declare C = C+1
  #end
  #declare C = 0
  #declare N = 350
  #while (C < N)
    sphere{ 0,R,S
      #declare Ball_Location = <-HW*rand(Q)*2,pow(C/N,1/2)*HH,C/N*HL-HL/2>
      scale <2.5,1.5,2>*2
//      scale <1.5+1*rand(Q),1+0.5*rand(Q),1+1*rand(Q)>*2
      translate Ball_Location
      translate y*(pow(Ball_Location.x/HW,3)*Ball_Location.y)/3
      translate x*(pow(Ball_Location.z/HL*Ball_Location.x/HW,1/1)*20)*-1
    }
    #declare C = C+1
  #end
  texture{ Grass_Texture }
  
  
  //the leaves texture
  #declare N = 60
  #declare C = 0
  #while (C < N)
    #declare Leaf_Rotation = y*360*rand(Q)
    #declare Leaf_Position = <-30+60*rand(Q),0,HL-75+35*rand(Q)>
    #declare Leaf_Size = (1.75+0.5*rand(Q))*1.75
    texture{
      pigment{
        image_map{
          #declare Leaf_Map = C/N
          #switch (Leaf_Map)
            #range (0,1/3)           gif "leaf2-2.gif" #break
            #range (1/3+0.00001,2/3) gif "leaf2-3.gif" #break
            #range (2/3+0.00001,3/3) gif "leaf2-4.gif" #break
          #end
          once
          interpolate 2
          transmit all 0.2
          transmit 0 1
        }
        scale Leaf_Size
        rotate x*90
      }
      finish{ ambient 0.0 diffuse 0.1 brilliance 0 }
      rotate Leaf_Rotation
      translate Leaf_Position+<0.125,0,-0.375>
    }
    texture{
      pigment{
        image_map{
          #declare Leaf_Map = C/N
          #switch (Leaf_Map)
            #range (0,1/3)           gif "leaf2-2.gif" #break
            #range (1/3+0.00001,2/3) gif "leaf2-3.gif" #break
            #range (2/3+0.00001,3/3) gif "leaf2-4.gif" #break
          #end
          once
          interpolate 2
          transmit 0 1
        }
        rotate x*90
      }
      normal{
        bump_map{
          gif "leafbmp7.gif"
          interpolate 2
        }
        rotate x*90
      }
      finish{ ambient 0.15 diffuse 1 brilliance 1 }
      scale Leaf_Size
      rotate Leaf_Rotation
      translate Leaf_Position
    }
    #declare C = C+1
  #end
}
#end
/***************************************************************************/
//		Christopher Robin and Winnie the Pooh
/***************************************************************************/
#if (Characters_Visible = 1)
#include "chrisrbn.inc"
#include "pooh.inc"
union{
  object{ Pooh              translate <5.75,-6.875,-0.25> }
  object{ Christopher_Robin translate <-5.75,0,0> }
  translate <1,HH+13.25,HL-45>
}
#end
/***************************************************************************/
//				The Tree
/***************************************************************************/
#if (Tree_Visible = 1)
#include "tree.inc"
object{ Tree
  scale 3
  rotate y*-90
  rotate x*5
  translate <-25,HH-25,HL-82>
}
#end
/***************************************************************************/
//				Leaves
/***************************************************************************/
#if (Leaves_Visible = 1)
#declare N = 150
#declare C = 0
#while (C < N)
  height_field{
    gif "leafbmp7.gif"
    water_level 0.1
    smooth
    scale <1,0.3,1>
    texture{
      pigment{
        image_map{
          #declare Leaf_Map = rand(Q)
          #switch (Leaf_Map)
            #range (0,1/3)           gif "leaf2-2.gif" #break
            #range (1/3+0.00001,2/3) gif "leaf2-3.gif" #break
            #range (2/3+0.00001,3/3) gif "leaf2-4.gif" #break
          #end
          interpolate 2
          transmit 0 1
        }
        rotate x*90
      }
      normal{
        bump_map{
          gif "leafbmp7.gif"
          interpolate 2
        }
        rotate x*90
      }
      finish{ ambient 0.15 diffuse 1 brilliance 1 }
    }
    translate <-0.5,0,-0.5>
    scale 1.5+0.75*rand(Q)
    #declare Flip = rand(Q)
    #switch (Flip)
      #range (0,0.5)     scale <1,1,1>  #break
      #range (0.50001,1) scale <1,-1,1> rotate z*180 #break
    #end
    rotate x*(70-25+50*rand(Q))
    rotate y*(80-20+40*rand(Q))
    translate <0-7*rand(Q),5-9*rand(Q),11-21*rand(Q)>
    rotate y*35
    rotate x*-10
    translate <25,HH+25,HL-80>
  }
  #declare C = C+1
#end
#end
/***************************************************************************/
//				Text
/***************************************************************************/
#if (Text = 1)
union{
  text{ ttf "corsiva.ttf" "\" The Last Day of Summer \"" 0,0
    scale 1/4.5
    rotate y*-48.81
    translate <36,36.875,-29.5>
  }
  text{ ttf "corsiva.ttf" "Hero Ngauv '97" 0,0
    scale 1/14
    rotate y*-48.81
    translate <39.34,34.58,-29>
  }
  texture{
    pigment{ Orange transmit 0.75 }
    finish{ ambient 1 diffuse 0 brilliance 0 }
  }
}
#end
