/***************************************************************************/
//		tree.pov
/***************************************************************************/
//				Constants
#declare Q = seed(0)
//blob constants
#declare T = 0.57	//0.25	//threshold
#declare R = 2	//1.5	//radius
#declare S = 1	//0.81	//strength

//tree constants
#declare TL = 20
#declare TW = 2
#declare B1L = 7
#declare B1W = 0.2
#declare B2L = 3.5
#declare B2W = 0.51
#declare B3L = 2
#declare B3W = 0.1
/***************************************************************************/
//				Textures
/***************************************************************************/
#declare Bark_Texture =
texture{
  pigment{
    bozo
    scale <0.1,0.3,0.1>
    turbulence 1
    lambda 3
    color_map{
      [0.0 color (BakersChoc*1+DarkWood*2)/3]
      [1.0 color (BakersChoc*2+DarkWood*1)/3]
    }
  }
  normal{ bumps 0.75 scale <0.1,0.3,0.1> turbulence 1 lambda 3 }
}
/***************************************************************************/
#declare Trunk =
blob{
  threshold T
  #declare N = 75
  #declare C = 0
  #while (C < N)
    sphere{ 0,R,S
      scale <(0.75+0.25*rand(Q)),(0.75+0.25*rand(Q))*2,(0.75+0.25*rand(Q))>//*(1-0*C/N)
      translate <0,rand(Q)*TL,(rand(Q)*TW+0)>
      rotate y*(360*C/N+30*rand(Q))
    }
    #declare C = C+1
  #end
  texture{ Bark_Texture }
}
/***************************************************************************/
#declare B1 =
blob{
  threshold T
  #declare N = 150
  #declare C = 0
  #while (C < N)
    sphere{ 0,R,S
      scale <(0.75+0.25*rand(Q))*1/3,(0.75+0.25*rand(Q))*2,(0.75+0.25*rand(Q))*1/3>*(1-B1W/TW*C/N)
      translate <0,rand(Q)*B1L,(rand(Q)*(TW-(TW-B1W)*C/N))>
      rotate y*(360*C/N+30*rand(Q))
    }
    #declare C = C+1
  #end
  texture{ Bark_Texture }
}
/***************************************************************************/
#declare B2 =
blob{
  threshold T
  #declare N = 50
  #declare C = 0
  #while (C < N)
    sphere{ 0,R,S
      scale <(0.75+0.25*rand(Q))*2/4,(0.75+0.25*rand(Q))*2,(0.75+0.25*rand(Q))*2/4>*(1-B2W/B1W*C/N)
      translate <0,rand(Q)*B2L,(rand(Q)*(B1W-(B1W-B2W)*C/N))>
      rotate y*(360*C/N+30*rand(Q))
    }
    #declare C = C+1
  #end
  texture{ Bark_Texture }
}
/***************************************************************************/
#declare B3 =
blob{
  threshold T
  #declare N = 25
  #declare C = 0
  #while (C < N)
    sphere{ 0,R,S
      scale <(0.75+0.25*rand(Q))*1/4,(0.75+0.25*rand(Q))*2,(0.75+0.25*rand(Q))*1/4>*(1-0.9*C/N)
      translate <0,rand(Q)*B3L,(rand(Q)*(B2W-(B2W-0)*C/N))>
      rotate y*(360*C/N+30*rand(Q))
    }
    #declare C = C+1
  #end
  texture{ Bark_Texture }
}
/***************************************************************************/
#declare Tree =
union{
  object{ Trunk }
  union{
    #declare B1N = 7
    #declare B1C = 0
    #while (B1C < B1N)
      union{
        object{ B1 }
        #declare B2N = 4
        #declare B2C = 0
        #while (B2C < B2N)
          union{
            object{ B2 }
            #declare B3N = 4
            #declare B3C = 0
            #while (B3C < B3N)
              object{ B3 translate y*B3L rotate y*360*rand(Q) rotate z*(20+20*rand(Q)) rotate y*(360*B3C/B3N+20*rand(Q)) translate <0,B2L-B2L*0*rand(Q),0> }
              #declare B3C = B3C+1
            #end
            translate y*B2L/3 rotate y*360*rand(Q) rotate z*(20+20*rand(Q)) rotate y*(360*B2C/B2N+20*rand(Q)) translate <0,B1L-B1L*0.2*rand(Q),0>
          }
          #declare B2C = B2C+1
        #end
        rotate y*360*rand(Q)
        translate y*B1L/4
        rotate z*(20+40*rand(Q))
        rotate y*(360*B1C/B1N+20-40*rand(Q))
        translate <0,TL-TL*0.333*rand(Q),0>
      }
      #declare B1C = B1C+1
    #end
  }
}
