// Persistence of Vision Ray Tracer Scene Description File
// File: rosebud.pov
// Vers: 3
// Desc: Imaginary scene from "Citizen Kane." Topic: childhood
// Date: 12/9/97
// Auth: Mike Sawyer
// Render time: ??

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "CHARS.INC"   // FIXME-add comments describing each of these
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"

#declare Fencewood =pigment { wood turbulence 0.04 octaves 3 scale <0.05, .05, 1>  color_map {
        [0.0, 0.1 color Gray90 color Gray90] [0.1, 0.9 color Gray90 color Gray70] [0.9, 1.0 color Gray70 color Gray70]  }}

#declare FencewoodDark =pigment { wood turbulence 0.04 octaves 3 scale <0.05, .05, 1>  color_map {
        [0.0, 0.1 color Gray80 color Gray80] [0.1, 0.9 color Gray80 color Gray60] [0.9, 1.0 color Gray60 color Gray60]  }}

#declare Bricks =  pigment { checker Gray55, Gray60 scale <1000,3,1000>}

//#declare Rough = finish { }

#declare SkyCloud =
texture {
    pigment {
        bozo turbulence 1.2 octaves 10 omega .5 lambda 2.5
        color_map {[0.0, 0.5 color rgbf<.85, .85, .85, 0> color rgbf<.9, .9, .9, .9> ]
                   [0.5, 0.7 color rgbf<.9, .9, .9, .9> color rgbf<1, 1, 1, 1> ]
                   [0.7, 1.0 color rgbf<1, 1, 1, 1> color rgbf<1, 1, 1, 1> ] } }
        finish {ambient 0.9 diffuse 0.1 }}


light_source{<2000,1500,-500>color Gray40}
light_source{<2000,1300,-500>color Gray40}
light_source{<2000,1400,-550>color Gray40}
//light_source{<1500,1700,-400>color rgb <.50,.5,.5>}
global_settings { ambient_light color rgb <3,3,3> }

camera {location <800,72,200> look_at <360,50,650>} //house view, from right side
//camera {location <650,110,400> look_at <600,110,650>} //close at icicles
//camera {location <600,72,0> look_at <450,50,240>} //house view, from right front
//camera {location <300,72,0> look_at <300,50,240>} //house view, from left front
//camera {location <135,72,200> look_at <150,50,350>} //house view, from left side
//camera {location <432,96,200> look_at <432,130,500>} // front of house
//camera {location <432,180,400> look_at <432,200,500>} // at peek of roof
//camera {location <200,1000,-100> look_at <200,0,300>} //above
//camera {location <150,120,190> look_at <-250,10,800>} //by sled
//camera {location <0,72,0> look_at <100,72,400>} //general view, from origin
//camera {location <200,72,0> look_at <250,50,400>} //general view, from close to origin
//camera {location <340,50,260> look_at <380,14,360>} //at front stairs
//camera {location <200,64,100> look_at <170,50,200>} //at fence
//camera {location <135,72,1000> look_at <400,50,850>} // back wall
//camera {location <432,500,0> look_at <432,100,600>} // bird's-eye view
//camera {location <232,56,280> look_at <380,70,500>} // at porch
//camera {location <602,56,380> look_at <380,40,460>} // on porch
//camera {location <470,40,430> look_at <415,30,460>} // at firewood
//camera {location <670,72,550> look_at <624,130,600>} //at stovepipe
//camera {location <1000,800,-1500> look_at <432,160,700>} // far away
//camera {location <492,106,345> look_at <322,100,460>} // at sign
//camera {location <0,200,0> look_at <0,200,10>} //test object
camera {location <750,72,150> look_at <500,20,400>} //final scene


//camera view indicator
//sphere {<150,120,190> 10 pigment {Red}}
//box {<-250,10,800><-240,20,810> pigment {Green}}

//fence
#declare Slat=difference{
         box {<0,0,0><0.5,72,5.5> pigment {Fencewood rotate <90,0,0> translate <12,0,1002> scale 100}}
         box {<-1,-.1,-12><1,12,0> pigment {Gray70} rotate <30,0,0> translate <0,70.5,0>}
         box {<-1,-.1,-12><1,12,0> pigment {Gray70} rotate <0,180,0> rotate <-30,0,0> translate <0,70.5,5.5>}
         }

#declare FenceSegment=union{
         box {<0,0,0><4,73,4> pigment {Gray70}} // 4x4 post
         box {<0,60,4><2,64,120> pigment {FencewoodDark translate <12,36,0> scale 20}} // support studs
         box {<0,24,4><2,28,120> pigment {FencewoodDark translate <12,36,0> scale 20}}
                  #declare Counter=1
                  #declare Distance=4
                  #while (Counter < 20)
                  object{Slat translate <0,0,Distance>}
                  #declare Distance=Distance + 6
                  #declare Counter=Counter + 1
                  #end
         }

#declare FenceSegment2=union{
         box {<0,0,0><4,73,4> pigment {Gray70}} // 4x4 post
         box {<0,63,4><2,67,120> pigment {FencewoodDark translate <12,36,0> scale 20}} // support studs
         box {<0,27,4><2,31,120> pigment {FencewoodDark translate <12,36,0> scale 20}}
                  #declare Counter=1
                  #declare Distance=4
                  #while (Counter < 20)
                  object{Slat translate <0,0,Distance>}
                  #declare Distance=Distance + 6
                  #declare Counter=Counter + 1
                  #end
         }

#declare Fence=union{
         object {FenceSegment translate <0,0,-2>}
         object {FenceSegment2 translate <0,0,118>}
         object {FenceSegment translate <0,0,238>}
         object {FenceSegment2 translate <0,0,358>}
         object {FenceSegment translate <0,0,478>}
         object {FenceSegment2 translate <0,0,598>}
         object {FenceSegment translate <0,0,718>}
         }

//sled
#declare SledSide=union{
         difference {
           box {<6,0,0><36,3,1> pigment {color DarkWood}}
//           box {<6,0,0><36,3,1> texture {T_Wood10 scale 3 rotate <0,90,0> translate <0,0,-5> }}
           cylinder {<10.5,2,-.10><10.5,2,1.10> .5 pigment {color DarkWood}}
           cylinder {<20.5,2,-.10><20.5,2,1.10> .5 pigment {color DarkWood}}
           cylinder {<30.5,2,-.10><30.5,2,1.10> .5 pigment {color DarkWood}}
           cylinder {<14,1.5,-.10><14,1.5,1.10> .5 pigment {color DarkWood}}
           cylinder {<17.5,1.5,-.10><17.5,1.5,1.10> .5 pigment {color DarkWood}}
           box {<14,1,-.10><17.5,2,1.1> pigment {color DarkWood}}
           box {<0,1,-.1><10,10,1.1> rotate <0,0,45> translate <37,0,0> pigment {color DarkWood}}
           }
         difference {
           cylinder {<6,10,0><6,10,1>10 pigment {color DarkWood}}
           cylinder {<6,30,-.1><6,30,1.1>27 pigment {color DarkWood}}
           box {<6,2,-.1><20,10,1.1> pigment {color DarkWood}}
           }
         difference{
           cylinder {<-1.3, 4.4, .05><-1.3, 4.4, .95> .9 pigment {color Gray10}}
           cylinder {<-1.3, 4.4, -.1><-1.3, 4.4, 1.1> .85 pigment {color Gray10}}
         }
         }

#declare SledSlat=box {<-.50,1.5,1><1,2.5,17> texture {T_Wood10 scale 3 }}

#declare Chopper=union{
         cylinder {<0,0,0><4.5,0,0> 3 pigment {color rgb <1,.245,.164>}}
         sphere {<0,0,0> 3 pigment {color rgb <1,.245,.164>}}
         sphere {<4.5,0,0> 3 pigment {color rgb <1,.245,.164>}}
         }
#declare SledTop=
           difference{
                    union{
                           box {<8,2.5,2.5><30,2.85,15.5> pigment {image_map {tga "sledcrak.tga"}rotate <90,0,0> scale <14,1,27> rotate <0,-90,0> translate <34.5,0,2>}}
                           cylinder {<0,2.5,10.50><0,2.85,10.50> 8 scale <.5,1,1> translate <30,0,0> pigment {image_map {tga "sledcrak.tga"}rotate <90,0,0> scale <14,1,27> rotate <0,-90,0> translate <34.5,0,2>}}
                           cylinder {<0,2.5,7.50><0,2.85,7.50> 8 scale <.5,1,1> translate <30,0,0> pigment {image_map {tga "sledcrak.tga"}rotate <90,0,0> scale <14,1,27> rotate <0,-90,0> translate <34.5,0,2>}}
                           box {<29,2.5,7.5><34,2.85,10.5> pigment {image_map {tga "sledcrak.tga"}rotate <90,0,0> scale <14,1,27> rotate <0,-90,0> translate <34.5,0,2>}}
                           }
                    box {<20,2,15.5><40,4,25> pigment {color rgb <1,.266,.187>}}
                    box {<20,2,-10><40,4,2.5> pigment {color rgb <1,.266,.187>}}
                    cylinder {<0,-20,9><0,20,9> 6 scale <.25,1,1> translate <7.5,7,0>}
                    object {Chopper  translate <13,3,0.1>}
                    object {Chopper  translate <23,3,0.1>}
                    object {Chopper  translate <13,3,17.9>}
                    object {Chopper  translate <23,3,17.9>}
           }

#declare Sled=union{
         object {SledSide}
         object {SledSide translate <0,0,17>}
         object {SledSlat translate <9.75,0,0>}
         object {SledSlat translate <19.75,0,0>}
         object {SledSlat translate <29.75,0,0>}
         object {SledTop}
}

#declare Icicle=cone {<0,0,0>1<0,-18,0>.1 texture {pigment {color White} finish {Dull}}}

#declare Window=
         union{
               box {<-12,0,.75><12,48,1> pigment {Gray20}} //pane
               box {<-12,0,-1><-10,48,1> pigment {Gray90}} //frame
               box {<10,0,-1><12,48,1> pigment {Gray90}}
               box {<-12,46,-1><12,48,1> pigment {Gray90}}
               box {<-12,0,-1><12,2,1> pigment {Gray95}}
               box {<-12,23,-.5><12,25,1> pigment {Gray95}}  //separator
               cylinder {<0,0,-.25><0,48,-.25> .2 pigment {White}} // cord
               }

#declare HouseFoundation=
         box{<0,0,0><384,24,576> pigment {Bricks} } // 32' wide, 48' long

#declare WallSlat=box {<0,0,0><0.1,96,11.5> pigment {Fencewood rotate <90,0,0> translate <12,0,2> scale 100}}

#declare LongWall=union{
                  #declare Counter=0
                  #declare Distance=0
                  #while (Counter < 38)
                  object{WallSlat translate <0,0,Distance>}
                  #declare Distance=Distance + 12
                  #declare Counter=Counter + 1
                  #end
         object {Window rotate <0,90,0> translate <0,24,60>} //windows on right
         object {Window rotate <0,90,0> translate <0,24,216>} //windows on right
         object {Window rotate <0,90,0> translate <0,24,372>} //windows on right
         object {Window rotate <0,-90,0> translate <0,24,60>} //windows on left
         object {Window rotate <0,-90,0> translate <0,24,216>} //windows on left
         object {Window rotate <0,-90,0> translate <0,24,372>} //windows on left
         }

#declare RoofCutter=
         union{
         box {<-100,0,-20><250,500,500> rotate <0,0,-25> pigment {White}} // cutter
         box {<-250,0,-20><100,500,500> rotate <0,0,25> pigment {White}} // cutter
         }

#declare ShortWall=union{
                  #declare Counter=0
                  #declare Distance=0
                  #while (Counter < 32)
                  object{WallSlat translate <0,0,Distance>}
                  #declare Distance=Distance + 12
                  #declare Counter=Counter + 1
                  #end
         }

#declare TopWall= difference{
         union{
               object{ShortWall rotate <0,90,0> translate <0,120,120>}
               object {Window translate <192,144,119>}
               }
         object {RoofCutter translate <192,216,0>}
         }

#declare FrontWall=union{
         object{ShortWall rotate <0,90,0> translate <0,24,120>}
         object {Window translate <36,48,119>}
         object {Window translate <230,48,119>}
         object {Window translate <348,48,119>}
         }

#declare BackWall=box {<0,0,-1><384,96,1> pigment {Gray50}}

#declare HouseRoof=
         union{
         box {<0,-1,0><215,0,456> pigment{White}}  //main roof
         cylinder {<215,-6,0><215,-6,456>6 pigment {White}} //long edge
         sphere {<215,-6,0>6 pigment {White}}
         sphere {<215,-6,456>6 pigment {White}}
         cylinder {<0,-6,0><0,-6,456>6 pigment {White}}  //center ridge
         sphere {<0,-6,0>6 pigment {White}}
         sphere {<0,-6,456>6 pigment {White}}
         cylinder {<0,-6,0><215,-6,0>6 pigment {White}} //front edge
         cylinder {<0,-6,456><215,-6,456>6 pigment {White}} //back edge
         }

#declare HouseRoof=union{    // 38' long (456")
         object {HouseRoof translate <0,6,0> rotate <0,0,-25> translate <192,218,120>}
         object {HouseRoof translate <0,6,0> rotate <0,0,-25> rotate <0,180,0> translate <192,218,576>}
         sphere {<192,216,119>6 pigment {White}}
         object {Icicle translate <390,120,130>}
         object {Icicle scale .5 translate <390,120,140>}
         object {Icicle translate <390,120,215>}
         object {Icicle translate <390,120,300>}
         object {Icicle scale .5 translate <390,120,320>}
         object {Icicle scale .5 translate <390,120,340>}
         object {Icicle translate <390,120,430>}
         object {Icicle translate <390,120,500>}
         }

#declare Door=union{
         box {<-2,0,-1><0,86,2> pigment {color Gray90}}    //frame
         box {<36,0,-1><38,86,2> pigment {color Gray90}}   //frame
         box {<-2,84,-1><38,86,2> pigment {color White}}   //frame
         difference{
             box {<0,0,0><36,84,2> pigment {color White}}      // door
             box {<4,4,-1><15,28,.5> pigment {color Gray80}}   // door panel
             box {<20,4,-1><31,28,.5> pigment {color Gray80}}  // door panel
         }
         box {<4,38,-.1><32,80,0> pigment {color Gray30}}  //window
         box {<17.75,25.5,-.2><18.25,80.5,0> pigment {color White}}  //window pane separator
         box {<3.5,49.75,-.2><32.5,50.25,0> pigment {color White}}  //window pane separator
         box {<3.5,65.75,-.2><32.5,66.25,0> pigment {color White}}  //window pane separator
         sphere {<0,0,0>1.5 scale <1,1,.5> pigment {color Gray70} translate <2,32,-1>} //doorknob
         }

#declare Log=union{
         cylinder {<0,0,0><0,0,20>6 pigment {FencewoodDark scale 20}}
         cylinder {<0,0,-.1><0,0,20>5.5 pigment {Fencewood scale 20}}
         }

#declare LogHalf=difference{
         object {Log}
         box {<-10,0,-1><10,10,25> pigment {Fencewood scale 20}}
         }

#declare LogQuarter=difference{
         object {Log}
         box {<-10,0,-1><10,10,25> pigment {Fencewood scale 20}}
         box {<0,-10,-1><10,1,25> pigment {Fencewood scale 20}}
         }

#declare LogSmall=union{
         cylinder {<0,0,0><0,0,20>3 pigment {FencewoodDark scale 20}}
         cylinder {<0,0,-.1><0,0,20>2.75 pigment {Fencewood scale 20}}
         }

#declare Firewood=union{
         //level 1
         object {LogSmall translate <0,3,-1>}
         object {LogQuarter rotate <0,0,180> translate <4,0,0>}
         object {LogQuarter rotate <0,0,-90> translate <22,0,0>}
         object {LogHalf rotate <0,0,180>translate <-9,0,-3>}
         object {LogSmall translate <13,3,-2>}
         object {LogQuarter rotate <0,0,180> translate <23,0,1>}
         //level 2
         object {LogSmall translate <18,7,-5>}
         object {LogQuarter rotate <0,0,-90> translate <-2,7,0>}
         object {LogQuarter rotate <0,0,-75> translate <13,9,-2>}
         object {LogHalf rotate <0,0,-160>translate <8,10,-2>}
         //level 3
         object {LogSmall translate <13,14,-2>}
         object {LogQuarter rotate <0,0,-135> translate <0,13,-5>}
         object {LogQuarter rotate <0,0,-110> translate <11,14,-3>}
         }

#declare Sign= union{
         box {<0,0,0><72,12,1> pigment {image_map {tga "sign2.tga"}scale <72,12,1>}}
         box {<0,0,0><2,1,6> pigment {color Gray50} rotate <45,0,0> translate <1,4,.5>}
         box {<0,0,0><2,1,6> pigment {color Gray50} rotate <45,0,0> translate <69,4,.5>}
         }

#declare Triangle=union{
         cylinder {<-4,0,0><4,0,0>.2 pigment {color Black}}
         cylinder {<-4,0,0><3,0,0>.2 pigment {color Black} translate <4,0,0> rotate <0,0,120> translate <4,0,0>}
         cylinder {<-4,0,0><4,0,0>.2 pigment {color Black}translate <-4,0,0>  rotate <0,0,-120>translate <-4,0,0>}
         sphere {<4,0,0>.2  pigment {color Black}}
         sphere {<-4,0,0>.2 pigment {color Black}}
         cylinder {<0,6,0><0,18,0> .1 pigment {color Gray70}}
         }

#declare Bench=union{
         box {<0,16,0><48,18,5>pigment {Fencewood scale 20 rotate <0,90,0>}}
         box {<0,16,0><48,18,5>pigment {Fencewood scale 20 rotate <0,90,0>} translate <0,0,7>}
         box {<0,14,0><2,16,12>pigment {FencewoodDark scale 10 translate <5,0,0>}}
         box {<46,14,0><48,16,12>pigment {FencewoodDark scale 10 translate <5,0,0>}}
         box {<-1,-20,-4><1,0,0>pigment {Fencewood scale 20 rotate <90,0,0> translate <5,0,0>} rotate <-30,0,0> translate <3,17,4>} //legs
         box {<-1,-20,-4><1,0,0>pigment {Fencewood scale 20 rotate <90,0,0> translate <5,0,0>} rotate <-30,0,0> translate <45,17,4>}
         box {<-1,-20,-4><1,0,0>pigment {Fencewood scale 20 rotate <90,0,0> translate <5,0,0>} rotate <30,0,0> translate <3,17,12>} //legs
         box {<-1,-20,-4><1,0,0>pigment {Fencewood scale 20 rotate <90,0,0> translate <5,0,0>} rotate <30,0,0> translate <45,17,12>} //legs
         }

#declare Barrel=union{
         difference{
                    sphere {<0,0,0> 18 scale <1,2,1> pigment {color Gray95}}
                    box {<-100,-500,-100><100,-18,100>}
                    box {<-100,18,-100><100,500,100> pigment {color Gray75}}
                    }
         cylinder {<0,-12,0><0,12,0>17.2 pigment {color Black}}
         translate <0,18,0>}
         
// 32' wide, 48' long (384" x 576")
#declare HousePorch=union{
         box {<0,24,0><384,24.01,122> pigment {color White}} //surface
         // vertical supports
         box {<0,24,0><8,108,8> pigment {Fencewood rotate <90,0,0> translate <12,0,4> scale 100}} box {<92,24,0><100,108,8> pigment {Fencewood rotate <90,0,0> translate <12,0,4> scale 100}} box {<188,24,0><196,108,8> pigment {Fencewood rotate <90,0,0> translate <12,0,4> scale 100}} box {<284,24,0><292,108,8> pigment {Fencewood rotate <90,0,0> translate <12,0,4> scale 100}}   box {<376,24,0><384,108,8> pigment {Fencewood rotate <90,0,0> translate <12,0,4> scale 100}}
         //stairs
         box {<100,0,-12><188,20,0> pigment {color Gray60}}  box {<100,0,-24><188,15,-12> pigment {color Gray65}} box {<100,0,-36><188,10,-24> pigment {color Gray70}} box {<100,0,-48><188,5,-36> pigment {color Gray60}}
         object {Door translate <120,24,119>}
         difference{
                    union{
                          box {<2,0,0><382,2,130> pigment {Gray95} rotate <-10,0,0> translate <0,106,0>} //porch roof
                          box {<3,-50,0><5,0,130> pigment {Fencewood scale 20} rotate <-10,0,0> translate <0,106,0>} //porch roof
                          box {<378,-50,0><380,0,130> pigment {Fencewood scale 20} rotate <-10,0,0> translate <0,106,0>} //porch roof
                          box {<0,0,0><2,2,130> pigment {Gray95} translate <0,106,0>}
                          box {<380,0,0><382,2,130> pigment {Gray95} translate <0,106,0>}
                          }
                    box {<-10,-500,-10><500,0,300> pigment {Gray95} translate <0,106,0>}
                    }
         object {Firewood translate <180,24,96>}
         object {Sign translate <156,109,4>}
         object {Triangle translate <210,90,6>}
         object {Bench translate <48,24,105>}
         object {Bench rotate <0,-30,0> translate <20,24,30>}
         object {Barrel translate <300,24,100>}
         }

#declare Stovepipe=union{
         cylinder {<0,0,0><18,0,0>4 pigment {Gray20}} //horizontal
         sphere {<18,0,0> 4 pigment {Gray30}} //elbow
         cylinder {<18,0,0><18,72,0>4 pigment {Gray40}} //vertical
         cone {<18,72.5,0>6 <18,76,0>.5 pigment {Gray05}} //cone
         }

#declare House=union{   //house at origin
         object {HouseRoof}
         object {HouseFoundation}
         object {LongWall translate <384,24,120>} //right wall
         object {LongWall translate <0,24,120>} //left wall
         object {HousePorch }  //24" high
         object {BackWall translate <0,24,576>} // back wall
         object {TopWall} object {TopWall translate <0,0,456>}
         object {FrontWall}
         object {Stovepipe translate <384,90,240>}
         }

//object {Icicle translate <0,200,10>} //test object

object {Fence translate <127,0,115>}object {Fence rotate <0,90,0> translate <127,0,951>} object {Fence rotate <0,90,0> translate <963,0,951>}
object {House translate <240,0,360>}
object {Sled rotate <0,35,0> translate <710,60,170>}
height_field {tga "snowgrnd.tga" smooth pigment {White} scale <1080, 24, 1080> translate <0,0,-120>}//snow
height_field {tga "hillfenc.tga" smooth pigment {White} scale <4000, 1000, 6000> translate <-4000,0,-2000>}// hill behind fence
sphere {<0,0,0>240 scale <1,.6,1> translate <790,-80,190> pigment {White}}//hill
plane {y, 0 pigment {White}}
plane {-y, -5000 texture {SkyCloud  scale <10000,10000,20000> translate <-10000,0,0>}}
