// Persistence of Vision Ray Tracer Scene Description File
// File: Snoopy.inc
// Vers: 3
// Desc: Snoopy
// Date: 11/27/1997
// Auth: Steve Sloan II

// Set blob parameters
#declare StrengthVal = 1.0 // (+ or -) strength of component's radiating density
#declare RadiusVal   = 1.0 // (0 < RadiusVal) outer sphere of influence on other components

// Create textures

// Snoopy's grizzled, once-white fur (think "old towel")
#declare white_fur =
texture {
    pigment { color Gray70 }
    normal { bumps .75 scale 0.1 }
    finish { ambient 0.2 diffuse 0.5 }
}

// Black fur on Snoopy's ears
#declare black_fur =
texture {
    pigment { color Gray15 }
    normal { bumps .75 scale 0.1 }
    finish { ambient 0.2 diffuse 0.5 }
}

// Snoopy's eyes
#declare eye_texture = texture { pigment { color Black } }

// Snoopy's stained red shirt
#declare shirt_texture =
texture {
    pigment { bozo color_map { [0 color <0.5, 0, 0>] [1 color <1.0, 0, 0>] } }
//    normal { gradient y scale 0.05 }
    finish { ambient 0.2 diffuse 0.5 }
}

// Location of the center of the head
#declare head_location = <0, 23, 0>

// Snoopy's eye
#declare eye = sphere { 0, 1 scale <0.75, 0.75, 0.3> texture { eye_texture } }

// One of Snoopy's legs
#declare leg =
union {
    cylinder { 0, -12*y, 1 scale <2.25, 1, 2.25> }
    sphere { 0, 2.25 translate -12*y }
    sphere {
        0, 1
        scale <2.25, 4.5, 2.25>
        rotate -45*x
        translate <0, -13, 1.25>
    }
    texture { white_fur }
}

// One of Snoopy's arms
#declare arm =
union {
    intersection {
        sphere { 0, 1 scale <1.5, 2, 2> }
        plane {  y, 0.0 rotate -45*x }
        texture { white_fur }
    }
    intersection {
        sphere { 0, 1 scale <1.5, 9, 2> }
        plane { -y, 0.0 rotate -45*x }
        texture { shirt_texture }
    }
    cylinder {
        0, 5*y, 1
        scale <0.5, 1, 1.25>
        rotate -15*z
        translate 7*y
        texture { shirt_texture }
    }
    translate 2*y
}

// Basic shape of Snoopy's ear
#declare ear =
union {
    intersection {
        torus { 1, 0.175 rotate 90*x }
        box { <0, 0, -2>, <2, 2, 2> }
        scale <1, 2, (1.75/0.175)>
    }
    union {
        cone { 0, 1.0, -6.75*y, (2.25/1.75) }
        intersection {
            sphere { 0, (2.25/1.75) }
            plane { y, 0 }
            translate -6.75*y
        }
        scale <0.175, 1, 1.75>
        translate x
    }
    texture { black_fur }
}

// Snoopy's body
#declare body =
union {
    // Snoopy's furry behind
    sphere {
        0, 1
        scale <5.25, 5, 4>
        translate 5*y
        texture { white_fur }
    }

    // Hem of Snoopy's shirt
    cylinder {
        0*y, 1*y, 1
        scale <5.35, 1, 4.1>
        translate 5*y
        texture { shirt_texture }
    }

    // Collar of Snoopy's shirt
    cone {
        0*y, 0.75, 1*y, 0.6
        scale <5.25, 1, 4>
        translate 18*y
        texture { shirt_texture }
    }

    // Shirt
    intersection {
        sphere { 0, 1 scale <5.25, 17, 4> }
        plane { -y, 0 }
        translate 5*y
        texture { shirt_texture }
    }
}

// Snoopy's head
#declare head =
blob {
    threshold 0.6

    // Head
    sphere {
        0, StrengthVal, RadiusVal
        scale <4, 6.5, 4.5> scale 2.1
        translate head_location
        texture { white_fur }
    }

    // Muzzle
    sphere {
        0, StrengthVal, RadiusVal
        scale <3, 3.25, 3.5> scale 2.1
        scale 0.6
        translate <0, -3, 6.5>
        texture { white_fur }
        translate head_location
    }
}

// Put Snoopy together
#declare Snoopy =
union {
    // Snoopy's head
    object { head }

    // Snoopy's body
    object { body }

    // Left and right ear
    object {
        ear
        rotate 10*z
        scale <-1, 0.75, 0.8>
        translate <-3, 3, 0>
        translate head_location
    }
    object {
        ear
        rotate 10*z
        scale <1, 0.75, 0.8>
        translate <3, 3, 0>
        translate head_location
    }

    // Left and right eye
    object { eye translate <0, 1, 4.4> rotate  25*y translate head_location }
    object { eye translate <0, 1, 4.4> rotate -25*y translate head_location }

    // Left and right leg
    object { leg rotate -90*x rotate -10*y translate <-3, 2.25, 0> }
    object { leg rotate -90*x rotate  10*y translate < 3, 2.25, 0> }

    // Left and right arm
    object { arm rotate -10*z translate <-7, 2.5, 0> }
    object { arm scale <-1, 1, 1> rotate  10*z translate < 7, 2.5, 0> }

    // Snoopy was defined in centimeters
    scale cm
}


