#include "colors.inc"
#include "skies.inc"
#include "textures.inc"
#include "woods.inc"
#include "shapes.inc"
#include "stones.inc"
#include "consts.inc"

// Constants used by 'rad_def.inc' are set in 'const.inc'
//#declare Rad_Quality = Radiosity_Debug
//#declare Rad_Quality = Radiosity_Fast
//#declare Rad_Quality = Radiosity_Normal
//#declare Rad_Quality = Radiosity_2Bounce
#declare Rad_Quality = Radiosity_Final

#include "rad_def.inc"

camera
{
    location <0, 2, 11 /*5, 4, 2*/>
    look_at <0, 3, 0 /*0, 4, 0*/>
}

// An area light (creates soft shadows)
// WARNING: This special light can significantly slow down rendering times!
light_source
{
  0*x // light's position (translated below)
  color White/*rgb 1.0*/  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <70, 0, 0> <0, 0, 70> // lights spread out across this distance (x * z)
  8, 8                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 2          // 0,1,2,3...
  jitter              // adds random softening of light
  translate <-800, 500, 1000>   // <x y z> position of light
}
//light_source{<800,500,1000> color White}

sky_sphere{pigment {P_Cloud4}}

 plane
 {
    y, -2
    pigment{color White}
    finish
    {
        roughness 1// 1.0=rough, 0.001=smooth [0.05]
        diffuse 1.0
        //crand 0.13
        // texture finish attribute
        brilliance 0.3 // tightness of diffuse illumination

    }

      normal{
      bozo .6
      scale .6}
      finish{phong .8 phong_size 200}

 }

 #declare Snow_Texture =
 texture
 {
    pigment{color Gray85}
    finish
    {
        roughness 1.0
        diffuse 1.0
        //crand 0.11
        brilliance 0.3
        //ambient .15
    }
    normal{
    bozo .6
    scale .26}
    finish{phong .8 phong_size 200}
 }

 #declare Coal_Texture =
 texture
 {
    T_Grnt15
      finish
      {
        roughness 1.0
      }
 }
 #declare Coal =
 sphere
 {
    <6, 0, 0>, 0.11
    texture
    {Coal_Texture}

 }


 #declare Body =
 union
 {
 sphere
 {
     <0, -0.8, 0>, 2
     texture{Snow_Texture}
 }

 sphere
 {
     <0, 2, .02>, 1.5
     texture{Snow_Texture}
 }

 object{Coal translate <-6, 2, 1.5>}
 //object{Coal translate <-6, 2.35, 1.5>}
 object{Coal translate <-6, 2.7, 1.4>}
 //object{Coal translate <-6, 1.65, 1.45>}
 object{Coal translate <-6, 1.3, 1.32>}
 //object{Coal translate <-6, .9, 1.3>}
 object{Coal translate <-6, .55, 1.46>}
 //object{Coal translate <-6, .22, 1.7>}
 object{Coal translate <-6, -.13, 1.83>}
 }

 #declare Head =
 union
 {
 sphere
 {
     <0, 4, .04>, 1
     texture{Snow_Texture}
 }

 cone
 {
    <0, 3.8, .96>, 0.15
    <0, 3.8, 1.4> 0

    pigment{Orange}
 }



 object{Coal translate <-5.8, 4.2, 1.03>}
 object{Coal translate <-6.2, 4.2, 1.03>}
 object{Coal translate <-6, 3.45, .85>}
 object{Coal translate <-5.75, 3.55, .87>}
 object{Coal translate <-6.25, 3.55, .87>}
 }

 #declare Hat =

// create a Surface of Revolution shape (like lathe, but faster)
sor
{
    6, // # of points
    <0.000000, 0.000000> // list of <u,v> points
    <1.2, 0.000000>
    <1.2, .01>
    <0.8, .011>
    <0.8, 1>
    <0, 1.001>
    texture{T_Grnt21}
    //finish{ambient .6}

}

#declare Arms =
union
{
    cylinder
    {
        <0, 0, 0> <1, 0.08, 0>, .12
        texture{T_Wood8}
    }

    sphere
    {
        <1, 0.08, 0>, .12
        texture{T_Wood8}
    }

    cylinder
    {
        <1, 0.08, 0> <1.5, 1.08, 0>, .12
        texture{T_Wood8}
    }

    sphere
    {
        <1.5, 1.08, 0>, .12
        texture{T_Wood8}
    }

    cone
    {
        <1.5, 1.08, 0>, .12
        <2, .9, 0>, 0
        texture{T_Wood8}
    }

    cone
    {
        <1.5, 1.08, 0>, .12
        <1.5, 1.5, 0>, 0
        texture{T_Wood8}
    }
 }

 #declare Snowman =
 union{
 object{Arms translate <1.3, 2.6, .09>}
 object{Arms rotate y * 180 rotate x *45 translate <-1.3, 2.6, .09>}
 object{Hat translate <0, 4.7, 0>}
 object{Body}
 object{Head translate <0, 0.12, 0.01>}}

 #declare _cone0 =
// CONE _cone0
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { T_Stone40 }
 //finish{ambient .2}
 scale  < 2, 1.88235, 2 >
 translate  < -0.0625114, 4.65662, -35.1031 >
 }


#declare _cone1 =
// CONE _cone1
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { T_Stone40 }
 //finish{ambient .2}
 scale  < 2.95465, 2.82333, 3.30435 >
 translate  < -0.0624962, 1.90662, -34.9781 >
 }




// CONE _cone2
#declare _cone2 =
union{
cone { <0, -1, 0>, 1
  < 0, 1, 0>, 0
 texture { T_Stone40 }
 //finish{ambient .2}
 scale  < 4.06566, 4, 4.12518 >
 translate  < -0.0624924, -1.84338, -34.9781 >
 }}


// CYLINDER _cylinder0
#declare Trunk =
union{
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { T_Wood4 }
 //finish{ambient .3}
 scale  < 0.606858, 1.75, 0.575802 >
 translate  < 0.0096041, -7.64338, -35.1608 >
 }}

// DEFAULT GROUP
#declare Tree =
union {
  object { _cone0 }
  object { _cone1 }
  object { _cone2 }
  object { Trunk }
}


object{Tree scale 15 translate <30, 120, 210>  /*translate x + 4*/ }
object{Tree scale 12 translate <-100, 100, 35> }
object{Tree scale 4 translate <50, 30, 46 >}
object{Tree scale 9 translate <-115, 70, 90>}
object{Tree translate <15, 6.5, -9>}
object{Tree translate <-18, 6.5, 5>}
object{Tree translate <-14, 6.5, 27>}
object{Tree scale 4 translate <45, 30, 85>}
object{Snowman translate <0, 0, -2>}




