
// Persistence of Vision Ray Tracer Object Include File
// File: toycrate.inc
// Vers: 3
// Desc: Include file for a plastic folding crate with castors
// Date: 12/11/97
// Auth: Tony Ewen


// By using this identifier, the user can change the color of the
// crate easily, defaults to standard blue.

#ifndef (Crate_Color)
 #declare Crate_Color = Blue
#end

// Let's start with a castor ( cause I've got the plan finished )
// We'll need four of these once the cart is actually done.
#declare Castor =
union
{
 // Need the wheels
 cylinder { < 1.25, 1.25, 0.625 > < 1.25, 1.25, -0.625 > 1.25 }
 // And the axle strut
 difference
 {
  cylinder {< 0, 1.25, 0> < 0, 3.0, 0 > 0.2 }
  cylinder {< 1.25, 1.25, 0.7 > < 1.25, 1.25, -0.7 > 1.45 }
 }
 // And the axle cover
 difference
 {
  cylinder {< 1.25, 1.25, 0.7 > < 1.25, 1.25, -0.7 > 1.45 }
  box { < 3, -1, 1 > < -3, 1.25, -1 > }
 }
}

// Now the crate
#declare CrateBox =
difference
{
 // now for the crate base
 box { <0, 3, 0> <18.5, 12, 13.5 > }
 // And the panel cutouts
 union
 {
  box { <.5, 3.5, .5> < 18, 11.5, 13 > } // Hollow
  box { <.5, 3.5, -1 > < 18, 11.5, .4 > }  // Inset
  box { <.5, 3.5, 13.1 > < 18, 11.5, 14 > }  // Inset
  box { <-1, 3.5, .5 > < 0.4, 11.5, 13 > }  // Inset
  box { <18.1, 3.5, .5 > < 19, 11.5, 13 > }  // Inset
  box { <.5, 11, .5> < 18, 13, 13 > }  // Top cutout
  #ifndef ( Solid )
   // and the z-axis holes - the x-axis holes will be only a little trickier
   #declare countx = 0
   #while (countx < 35)
    #declare county = 0
    #while (county < 8)
     cylinder
     {
      <.75 + countx / 2, 3.75 + county, -1 >
      <.75 + countx / 2, 3.75 + county, 14 >
      .125
     }
     cylinder
     {
      <.75 + countx / 2, 4.25 + county, -1>
      <.75 + countx / 2, 4.25 + county, 14>
      .125
     }
     box
     {
      < .625 + countx / 2, 3.75 + county, -1 >
      < .875 + countx / 2, 4.25 + county, 14>
     }
     #declare county = county + 1
    #end
    #declare countx = countx + 1
   #end
   // and the z-axis holes
   #declare countz = 0
   #while (countz < 25)
    #declare county = 0
    #while (county < 6)
     cylinder
     {
      <-1, 3.75 + county, .75 + countz / 2 >
      <19, 3.75 + county, .75 + countz / 2 >
      .125
     }
     cylinder
     {
      <-1, 4.25 + county, .75 + countz / 2>
      <19, 4.25 + county, .75 + countz / 2>
      .125
     }
     box
     {
      < -1, 3.75 + county, .625 + countz / 2 >
      < 19, 4.25 + county, .875 + countz / 2 >
     }
     #declare county = county + 1
    #end
    #declare countz = countz + 1
   #end
  #end
  // Now the handles
  cylinder { < -1, 11, 8.25 > < 19, 11, 8.25 > .5 }
  cylinder { < -1, 11, 5.25 > < 19, 11, 5.25 > .5 }
  box { < -1, 10.5, 5.25 > < 19, 11.5, 8.25> }
 }
 pigment { color Crate_Color }
}

#declare Crate =
union
{
 object { Castor translate <1, 0, 1>}
 object { Castor translate <17.5, 0, 1>}
 object { Castor translate <1, 0, 12.5>}
 object { Castor translate <17.5, 0, 12.5>}
 object { CrateBox }
}

