
// Persistence of Vision Ray Tracer Scene Description File
// File: walker.inc
// Vers: 3
// Desc: Joshua's walker model
// Date: 11/11/97
// Auth: Tony Ewen
//
// Include this file, plus the standard textures and colors, and you'll
// then be able to add a child's walker to a scene by using the following syntax :
// object { Childs_Walker }
// All the other declarations in here are to make the coding easier - not intended
//  for separate use.

#version 3

// Declare the side panels of the walker
#declare Walker_Side_Panel =
merge
{
 cylinder { <0.5, 0.5, 0.0> <0.5, 0.5, 1.0> 0.5 }
 cylinder { <0.5, 2.0, 0.0> <0.5, 2.0, 1.0> 0.5 }
 cylinder { <16.5, 0.5, 0.0> <16.5, 0.5, 1.0> 0.5 }
 cylinder { <16.5, 2.0, 0.0> <16.5, 2.0, 1.0> 0.5 }
 union
 {
  box { <0.0, 0.5, 0.0> <17.0, 2.0, 1.0> }
  box { <0.5, 0.0, 0.0> <16.5, 2.5, 1.0> }
 }
 pigment { Pine_Wood rotate y * 90 scale 0.5 }
}

// Now the end panels
#declare Walker_End_Panel = box { <0, 0, 0> < 9,  2.5,  .75> pigment { Pine_Wood } }

// the Floor
#declare Walker_Floor = box { <-7, 2.25, 5> <7, 2.5, -4.25> }

//  The Walker base component
#declare Walker_Main =
union
{
 object { Walker_Side_Panel translate <-8.5, 2, 4.75> }
 object { Walker_Side_Panel translate <-8.5, 2, -4.75> }
 object { Walker_End_Panel rotate y * 90 translate <6.5, 2, 4.75> }
 object { Walker_End_Panel rotate y * 90 translate <-7.0, 2, 4.75> }
 object { Walker_Floor }
}

#declare Wheel_Nut =
intersection
{
 prism {
  linear_sweep
  linear_spline
  0.0,
  4,
  7,
  <0,1>, <.866, .5>, <.866, -.5>, <0, -1>, <-.866, -.5>, <-.866, .5>, <0,1>}
 sphere { 0, 2 }
 texture { Copper_Metal }
 scale .25
}

#declare Walker_Wheel =
union
{
 lathe {
  linear_spline
  5,
  <2.0, 0.0>, <2.0, 1.0>, <1.65, 1.25>, <1.0, 0.75>, <0.0, 0.75>
  pigment { color Yellow } rotate x * 90
 }
 object {Wheel_Nut rotate x * 90 translate z * 0.5}
}

#declare Walker_Wheel_Set =
union {
 object { Walker_Wheel rotate x * 180 translate <-7, 3, -4.8> }
 object { Walker_Wheel rotate x * 180 translate <7, 3, -4.8> }
 object { Walker_Wheel translate <-7, 3, 5.8> }
 object { Walker_Wheel translate <7, 3, 5.8> }
}

//Now the handle
#declare Walker_Handle_Stem =
union
{
 merge // This is the actual stem - with rounded ends
 { box { <0, 1.75, -6.3> <1, 16.75, -5.8> }
  cylinder { <0.5, 1.75, -6.3> <0.5, 1.75, -5.8> 0.5 scale <1, .5, 1> translate y}
  cylinder { <0.5, 16.75, -6.3> <0.5, 16.75, -5.8> 0.5 }
  pigment { Gray90 }
 }
 union
 {  //These are the screws that hold it in place - with some fakery added
  sphere { 0, .125 translate < 0.5, 2.5, -6.3> }
  sphere { 0, .125 translate < 0.5, 3.75, -6.3> }
  sphere { 0, .125 translate < 0.5, 2.5, -5.8> }
  sphere { 0, .125 translate < 0.5, 3.75, -5.8> }
  texture { Brushed_Aluminum }
 }
}

#declare Walker_Handle =
union
{
 object { Walker_Handle_Stem }
 object { Walker_Handle_Stem translate z * 11 }
 // Add the actual handle bar
 cylinder {< 0.5, 16.75, -6 > <0.5, 16.75, 5> .25  pigment {Gray90 }}
}

// Place the objects
#declare Childs_Walker =
union
{
 object { Walker_Main }
 object { Walker_Wheel_Set }
 object { Walker_Handle translate <0,0,0> rotate z * -20 translate <2, .5, 1>}
}
