// "Childhood" rendering for POVRAY contest by Robert Woodbury 1997
// a bunch of childhood toys reminiscent of the floor when I was a kid.
// Never forget getting the jack stuck in my foot in 1971.
// Some objects created in Moray. Some created with a QBASIC program
// Specifically designed for the purpose.

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// ********  T E X T U R E S  *******//
#declare Feather = pigment{ radial frequency 40
      color_map{ [0 color Clear] [.1 color White] [ .5 color White]
      [ .6 color Clear]  [ 1 color Clear]  } }

camera {  //  Camera Camera01
  location  <.5, -12, 6.3>
  direction z * 2.4
  sky z  up  z // right handed system
  right  x*1.3   look_at  z*1.2 }
  
// *******  L I G H T S *******
light_source {  <-9.2, -3.7, 11.8> color red 1 }
light_source {  <-10, -3.7, 12> color green 1 }
light_source {  <-8, -3.7, 12> color blue 1 }
// ******** Textures ******
#declare Dixie = pigment { leopard
		    color_map {[0 color Blue ][ .2 color Blue ]
			       [.2 color White][.7 color Pink] [1 color Red ]}
				scale .1}
#declare Fur = texture {
			pigment { Brown }
			normal { bumps 20 }
		      scale .1
		     }

#declare Cotton = texture {
			pigment { White }
			normal { bumps 1 turbulence 1 }
		      scale .1
		     }
#declare Tin = texture {
			pigment{ blue 1 green .95 red .95 }

       finish { reflection .7 brilliance 3 crand .1 phong .1}
		       }
#declare Rainbow = pigment { gradient z
			       color_map{
			       [.1 color Red ] [.3 color Yellow]
			       [.5 color Green] [.7 color Blue]
			       [1 color Violet]
				}
			    }
#declare Paper = texture { pigment { White}
	      finish { reflection .1 ambient .3 crand .2 }
	       }

// ********  O B J E C T S *******
#declare Seed = union { cone { <0,2.5,0>,.01 <0,0,0>,.1
      texture {pigment { color Black} } }
      cone {<0,2.49,0>,0 <0,2.5,0>,.75
      texture{ pigment{Feather}}}
      rotate x*90   translate <0, 0, .5>}

 #declare Seed1 = union { cone { <0,2.5,0>,.01 <0,0,0>,.05
      texture {pigment { color Black} } }
      sphere {<0,0,0>,.07 scale <1,3,1>
      texture {
      pigment { color Black} normal { wrinkles .5 }
      } }
      cone {<0,2.49,0>,0 <0,2.5,0>,.75
      texture {pigment{ Feather}}}
      rotate x*90   translate <0, 0, .5>}

 #declare Seeds = union {
 #declare PartNum=1
 #declare R1=seed(1234)
 #while (PartNum<=75)
      object {Seed rotate <rand(R1)*360,rand(R1)*360,rand(R1)*360>}
      #declare PartNum=PartNum+1#end }
      #declare flowerheart = object {
      sphere {<0,0,0>,1} scale <1, 1, 0.5>}

 #declare base = cylinder { <0,0,1>, <0,0,0>, 1 scale <0.5, 0.5, 1>
 translate <0, 0, -1.4> }
#declare basebit2 = cone {  <0,0,0>, 0  <0,0,1>, 1
 scale <0.5, 0.5, 1> translate <0, 0, -2.4>}
#declare knob = union {
 object { flowerheart }
 object { base }
 object { basebit2 }
 texture { pigment {
	gradient z color_map { [.1 color White] [1 color green .7 ]} }
	}
  }

#declare Dandy = union {
 // Dandylion
 object { Seeds }  object { knob }
 cylinder {<0,0,0>,<0,0,-25>,.125 pigment{ Green } }
 }

//jack parts
#declare jackbit1 = union{ cone { <0,0,.75>, .02 <0,0,0>, .125 }
			  sphere{ <0,0,.75>, .02 } }
#declare jackbit2 = union{ cone { <0,0,-.75>, .02 <0,0,0>, .125 }
			  sphere{ <0,0,.75>, .02 } }
#declare jackarm = union { sphere {<.8,0,0>, .125 }
			  cone {<0,0,0>,.125 <.8,0,0>,.01}}
//Boogle eyes
#declare Boogle=union {
		sphere{<0,0,0>,.5
		texture { pigment {White} finish { Shiny }}
		}
		sphere {<0,-.5,-.2>,.2
		texture { pigment {Black} finish { Shiny }}
		}
		scale < .8,.2,1>
		}

#declare Stuffy=union {
		sphere {<0,0,0>,4 texture {Fur}  scale <1,1,.7>}
		object{Boogle rotate <-20,-10,0> translate <-.25,-4,.75>}
		object{Boogle rotate <-20,-10,0> translate <.25,-4,.75>}
		sphere {<0,-4.2,0>,.4
			texture{pigment{Red} finish{Shiny} } }
		}

// create a smooth blobby shape
#declare StrengthVal = 1.0 
#declare RadiusVal   = 1.0 
#declare Spill = blob{
  threshold 0.6
  sphere { < 0.85,   0,    0>, 1, RadiusVal }
  sphere { <-0.375,  0.65, 0>, 1, RadiusVal }
  sphere { <-0.375, -0.75, 0>, 1, RadiusVal }
  scale <1,1,.7> texture { Water}
}


//qtip parts
#declare Nib1 = sphere {<0,0,0>, 1  scale <0.2, 0.5, 0.2>
  translate <0, 2, 0>
  }
#declare Nib2 = sphere { <0,0,0>,1
 scale <0.2, 0.5, 0.2>
 translate <0, -2, 0>
}
#declare shaft = cylinder { <0,-2,0>, <0,2,0>, .06}

#declare Floor=plane { z,0
  texture { pigment{DMFLightOak}  normal {brick .1} scale <.4,5,.5> }
	rotate z*-25
}
#declare Qtip = union {   // qtip
  object { Nib1 texture { Cotton }}
 object { Nib2 texture { Cotton }}
  object { shaft texture { Paper }}
 }
// a dixie cup
#declare Cup = merge { difference{
	cone { <0,0,0>,1 <0,0,2.2>,1.5 texture {pigment{Dixie}} }
	cone { <0,0,.1>,.94 <0,0,2.4>,1.45 texture {Paper} }
	}
	torus { 1.5,.1 rotate x*90 translate z*2.2 texture {Paper}} 
}

#declare Jackball = sphere {<0,0,0>,1
  pigment { Rainbow }
}
#declare Jack = union {   // jack
  object { jackbit1 } object { jackbit2 }
 object { jackarm }
  object { jackarm rotate z*90}
 object { jackarm rotate z*180}
 object { jackarm rotate z*270}
 texture { Tin }
 rotate z * 45 rotate y * -45}
object { Dandy scale .35 rotate <0,80,10> translate <-1.5,-2,.55>}
object { Seed1 scale .4 rotate <0,20,20> translate <-1,-1,.8> }
object { Seed1 scale .45 rotate <20,-20,20> translate <-1,1.5,2> }
object { Seed1 scale .5 rotate <20,-50,20> translate <2.5,-4.5,2.5> }
object {Floor}
object {Jack rotate z*85 translate <1,1,.7> }
object {Jack rotate z*25 translate <2,-1,.6> }
object {Jack  translate <.2, -0.45, 0.7> }
object {Jackball  rotate <10,20,0>  translate <0, 3 , 1.06>}
object {Qtip rotate z*-45 translate <-1.73, 4.25, 0.4>}
object {Qtip rotate z*-25 translate <-1.5,5, 0.24>}
object { Stuffy rotate z*20 translate <-4.5,8,1.5> }
object { Cup rotate x*78 rotate z*50 translate <2,7,1> }
object {Spill rotate y*2 translate <4.6,4.8,0>}
fog {color White distance 40 }
