// Persistence of Vision Ray Tracer 3.02 for Windows Input File
// Trumpet.POV
#version 3.02
global_settings { assumed_gamma 3 }
#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#declare DarkGlass = texture {pigment {color White filter 0.45} finish {Glass_Finish}}
#declare FeltGreen = color red 0.18 green 0.6 blue 0.18
#declare New_Candy_Cane =
pigment {
    gradient x+y
    color_map {
        [0.00, 0.25 color rgbf <.6,0,0,0>  color rgbf <.6,0,0,0>]
        [0.25, 0.75 color rgbf <.87,.83,.81,0>  color rgbf <.87,.83,.81,0>]
        [0.75, 1.00 color rgbf <.6,0,0,0>  color rgbf <.6,0,0,0>]
    }
}
#declare New_Gold = texture {
   pigment {color rgb <0.80, 0.50, 0.1>}
   finish {
      ambient 0.3 diffuse 0.35
      reflection 0.6 brilliance 6 specular 0.5
      phong 0.451 phong_size 5
   }
}

// Camera
camera{
  perspective
   translate <-5.4, 25, -20.1>
  direction <0, 0, 4>
  up <0, 1, 0>
  right <1.33333, 0, 0>
  look_at <-1.95, 0, -0.1>
}

// Light Zero
light_source {
   <-1.5,25,-7.5>
   color red 0.8 green 0.8 blue 0.8
}
// Shadow Filter
sphere {<0, 0, 0>,0.16
   scale <0.6,1.11,1.2>
   rotate -45*z
   translate <-1.375, 14.8, -3.75>
   texture {DarkGlass}
}

// Light One
light_source {
   <-6.9,5.35,-10>
   color red 0.8 green 0.8 blue 0.8
   area_light <3.8,0,0>,<0,0.7,0>,3,2
   adaptive 1
   jitter
}

// Light Two
light_source {
   <-5,4,5>
   color red 0.6 green 0.6 blue 0.6
}

// Light Three
light_source {
   <-10,10,5>
   color red 0.2 green 0.2 blue 0.2
}

//Light Four
light_source {
   <10,5,5>
   color red 0.5 green 0.5 blue 0.5
}

//Bell
#declare BellMinusHoop = object {
difference {
torus {1.24,1
   translate <-1.5,1,0>
   scale <1,1.5,1>
}
torus {1.25,1
   translate <-1.5,1,0>
   scale <1,1.5,1>
}
cylinder {<-1.5,1.5,0><-1.5,3.1,0>,1.29}
   translate <0,-0.5,0>
    translate <0,-8.55,0> rotate 0.95*x translate <0,8.55,0>
     translate <-0.1,0,0> rotate -6*y translate <0.1,0,0>
      translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>
}
}
#declare BellPlusHoop = object {
torus {1.24,0.025
   translate <-1.5,0.025,0> translate <0,-0.5,0>
    translate <0,-8.55,0> rotate 0.95*x translate <0,8.55,0>
     translate <-0.1,0,0> rotate -6*y translate <0.1,0,0>
      translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>
}
}
//(Generic A) Joint1
#declare JointA = object {
torus {0.3,0.135
   rotate 90*x
   rotate 90*y
}
   clipped_by{
box {<0.45,0,-0.15><-0.45,-0.45,-0.45>}}
}
//(Generic B) Joint4
#declare JointB = object {
torus {0.3,0.135
   rotate 90*x
   rotate 90*y
}
   clipped_by{
box {<0.45,-0.15,0><-0.45,-0.45,-0.45>}}
}
//Bell Straights
#declare BellStraightTop = object {
cone {<-1.5,1,0>,0.25<-1.5,7.75,0>,0.135
   clipped_by {
box {<-2,0.5,1><-1,7.75,-1>}}
}
    translate <0,-8.55,0> rotate 0.95*x translate <0,8.55,0>
     translate <-0.1,0,0> rotate -6*y translate <0.1,0,0>
      translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>
}
#declare BellStraightBottom = object {
union {
cylinder {<0.175,7.75,0><0.175,5.75,0>,0.135
   clipped_by{
box {<-0.5,7.75,-0.5><0.5,5.75,0.5>}}
}
//Insert Joint1
  object {JointA translate <0.175,5.75,0.3>}
   translate <-0.075,0,0> translate <0.55,0,-0.45> rotate 4*y
    translate <-0.55,0,0.45>
}
}
//Bell Coil
#declare BellCoilBottom = object {
torus {0.8,0.135
   rotate 90*x
}
   clipped_by{
box {<0,0,-1><1,1,1>}}
    translate <-0.8,7.5,0> rotate -6*y translate <0.1,0,0>
     translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>
      translate <0,0.25,0>
}
#declare BellCoilTop = object {
torus {0.8,0.135
   rotate 90*x
}
   clipped_by{
box {<-1,0,-1><0,1,1>}}
    translate <0,-0.8,0> rotate 0.95*x translate <0,0.8,0>
     translate <-0.8,7.5,0> rotate -6*y translate <0.1,0,0>
      translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>
       translate <0,0.25,0>
}
#declare Bell = object {
union {
object {BellMinusHoop}
object {BellPlusHoop}
object {BellCoilTop}
object {BellCoilBottom}
object {BellStraightTop}
object {BellStraightBottom}
translate <0,0,0.248>
}
}

//Valves
#declare Valve1 = object {
union {
//Cylinder
cylinder {<-1.125,5.5,0><1.226,5.5,0>,0.21
  texture {New_Gold}
}
//Cylinder Cap (Bottom)
cylinder {<1.225,5.5,0><1.375,5.5,0>,0.225
  texture {New_Gold}
}
//Cylinder Cap (Top)
cone {<-1.176,5.5,0>,0.225<-1.076,5.5,0>,0.22
  texture {New_Gold}
}
//Piston
cylinder {<-1.52,5.5,0><-1,5.5,0>,0.045
  texture {Chrome_Texture}
}
//Piston Rim
cylinder {<-1.2,5.5,0><-1,5.5,0>,0.075
  texture {New_Gold}
}
// Felt Ring
cylinder {<-1.177,5.5,0><-1.076,5.5,0>,0.2
  pigment {FeltGreen}
  finish {ambient 0 diffuse 1 crand 0.21}
}
//Finger
cylinder {<-1.6,5.5,0><-1.515,5.5,0>,0.16
  texture {New_Gold}
}
//Finger Surface
cylinder {<0.002,0,0><-0.002,0,0>,0.14
  pigment {White_Marble scale <0.1,0.1,0.1> rotate 25*x translate <0,0.1,0.1>}
  finish {ambient 0.5 diffuse 0.5 reflection 0.2}
  translate <-1.6,5.5,0>
}
}
}
#declare Valve2 = object {
union {
//Cylinder
cylinder {<-1.125,5.5,0><1.226,5.5,0>,0.21
  texture {New_Gold}
}
//Cylinder Cap (Bottom)
cylinder {<1.225,5.5,0><1.375,5.5,0>,0.225
  texture {New_Gold}
}
//Cylinder Cap (Top)
cone {<-1.176,5.5,0>,0.225<-1.076,5.5,0>,0.22
  texture {New_Gold}
}
//Piston
cylinder {<-1.52,5.5,0><-1,5.5,0>,0.045
  texture {Chrome_Texture}
}
//Piston Rim
cylinder {<-1.2,5.5,0><-1,5.5,0>,0.075
  texture {New_Gold}
}
//Felt Ring
cylinder {<-1.177,5.5,0><-1.076,5.5,0>,0.2
  pigment {FeltGreen}
  finish {ambient 0 diffuse 1 crand 0.21}
}
//Finger
cylinder {<-1.6,5.5,0><-1.515,5.5,0>,0.16
  texture {New_Gold}
}
//Finger Surface
cylinder {<0.002,0,0><-0.002,0,0>,0.14
  pigment {White_Marble scale <0.1,0.1,0.1> rotate 45*x translate <0,0.1,0>}
  finish {ambient 0.5 diffuse 0.5 reflection 0.2}
  translate <-1.6,5.5,0>
}
}
}
#declare Valve3 = object {
union {
//Cylinder
cylinder {<-1.125,5.5,0><1.226,5.5,0>,0.21
  texture {New_Gold}
}
//Cylinder Cap (Bottom)
cylinder {<1.225,5.5,0><1.375,5.5,0>,0.225
  texture {New_Gold}
}
//Cylinder Cap (Top)
cone {<-1.176,5.5,0>,0.225<-1.076,5.5,0>,0.22
  texture {New_Gold}
}
//Piston
cylinder {<-1.52,5.5,0><-1,5.5,0>,0.045
  texture {Chrome_Texture}
}
//Piston Rim
cylinder {<-1.2,5.5,0><-1,5.5,0>,0.075
  texture {New_Gold}
}
// Felt Ring
cylinder {<-1.177,5.5,0><-1.076,5.5,0>,0.2
  pigment {FeltGreen}
  finish {ambient 0 diffuse 1 crand 0.21}
}
//Finger
cylinder {<-1.6,5.5,0><-1.515,5.5,0>,0.16
  texture {New_Gold}
}
//Finger Surface
cylinder {<0.002,0,0><-0.002,0,0>,0.14
  pigment {White_Marble scale <0.1,0.1,0.1> rotate -45*x translate <0.1,0,0>}
  finish {ambient 0.5 diffuse 0.5 reflection 0.2}
  translate <-1.6,5.5,0>
}
}
}

//Pegs
#declare Pegs = object {
union {
sphere {<0,0,0>, 0.06 scale <1,1.4,1> translate <1.1,5.25,0>}
sphere {<0,0,0>, 0.06 scale <1,1.4,1> translate <-0.3,5.25,0>}
sphere {<0,0,0>, 0.06 scale <1,1.4,1> translate <1.1,4.75,0>}
sphere {<0,0,0>, 0.06 scale <1,1.4,1> translate <-0.3,4.75,0>}
sphere {<0,0,0>, 0.06 scale <1,1,1.4> translate <-0.955,5,0.24>}
sphere {<0,0,0>, 0.06 scale <1,1,1.4> translate <-0.955,5,-0.23>}
  rotate 4*y
  translate <-0.55,0,0.45>
}
}

//Crossbars
#declare Crossbars = object {
union {
cylinder {<-0.787,5.36,0><-0.787,5.36,-0.9>,0.04}
cylinder {<-0.787,0.36,0><-0.787,0.36,-0.9>,0.04}
cylinder {<-0.787,5.36,-0.6><-0.787,5.36,-0.9>,0.06}
cylinder {<-0.787,0.36,-0.6><-0.787,0.36,-0.9>,0.06}
cylinder {<-0.787,5.36,0><-0.787,5.36,-0.28>,0.06}
cylinder {<-0.787,0.36,0><-0.787,0.36,-0.28>,0.06}
  translate <-0.7,1.64,0.9> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>
}
}

//First Valve Slide
//1st Valve Slide Coil
#declare VS1Coil = object {
torus {0.175,0.135}
   clipped_by{
box {<-0.5,-0.5,-0.5><0.5,0.5,0>}}
   rotate 90*x
}
//1st Valve Slide Straight
#declare VS1Straight = object {
union {
cylinder {<-0.175,0.25,0><-0.175,-0.75,0>,0.135}
cylinder {<0.175,0.25,0><0.175,-0.75,0>,0.135}
cylinder {<-0.175,0.25,0><-0.175,0,0>,0.141}
cylinder {<0.175,0.25,0><0.175,0,0>,0.141}
   clipped_by{
box {<-0.5,0.25,-0.5><0.5,-1,0.5>}}
}
}
//1st Valve Slide Knob
#declare VS1Knob = object {
union {
cylinder {<0,0,-0.425><0,0.165,-0.425>,0.05}
sphere {<0,0.165,-0.425>,0.05}
}
   rotate 90*x
}
//1st Valve Slide
#declare VS1 = object {
union {
object {VS1Straight}
object {VS1Coil translate <0,0.25,0>}
object {VS1Knob}
}
}

//Second Valve Slide
//2nd Valve Slide Coil
#declare VS2Coil = object {
torus {0.175,0.135}
   clipped_by{
box {<-0.5,-0.5,0><0.5,0.5,0.5>}}
}
//2nd Valve Slide Straight
#declare VS2Straight = object {
union {
cylinder {<-0.175,0,-0.5><-0.175,0,0>,0.135}
cylinder {<0.175,0,-0.5><0.175,0,0>,0.135}
cylinder {<-0.175,0,-0.25><-0.175,0,0>,0.141}
cylinder {<0.175,0,-0.25><0.175,0,0>,0.141}
   clipped_by{
box {<-0.5,-0.5,-0.5><0.5,0.5,0>}}
}
}
//2nd Valve Slide Knob
#declare VS2Knob = object {
union {
cylinder {<0,0,0.175><0,-0.165,0.175>,0.05}
sphere {<0,-0.165,0.175>,0.05}
}
}
//2nd Valve Slide
#declare VS2 = object {
union {
object {VS2Straight}
object {VS2Coil}
object {VS2Knob}
}
}

//Third Valve Slide
//3rd Valve Slide Coil
#declare VS3Coil = object {
torus {0.175,0.135}
   clipped_by{
box {<-0.5,-0.5,0><0.5,0.5,0.5>}}
   rotate 90*x
}
//3rd Valve Slide Straight
#declare VS3Straight = object {
union {
cylinder {<-0.175,0,0><-0.175,2.1,0>,0.135}
cylinder {<0.175,0,0><0.175,2.1,0>,0.135}
cylinder {<-0.175,0.75,0><-0.175,1,0>,0.141}
cylinder {<0.175,0.75,0><0.175,1,0>,0.141}
   clipped_by{
box {<-0.5,0,-0.5><0.5,2,0.5>}}
}
}
//3rd Valve Slide
#declare VS3 = object {
union {
object {VS3Straight}
object {VS3Coil}
}
}
//Third Finger Ring
#declare Ring = object {
difference {
cylinder {<-0.61,1.4,-0.05><-0.61,1.4,0.05>,0.29}
cylinder {<-0.61,1.4,-0.1><-0.61,1.4,0.1>,0.21}
}
}
#declare FR3 = object {
union {
box {<-0.28,0.4,-0.07><-0.44,0.6,0.07>}
box {<-0.32,0.0,-0.05><-0.40,1.4,0.05>}
cylinder{<-0.3,0.5,0><-0.49,0.5,0>,0.03}
cylinder{<-0.49,0.5,0><-0.53,0.5,0>,0.1}
object {Ring}
}
}
//Third Watering Valve
#declare Lever1 = object {
torus {0.355,0.025}
   bounded_by {
box {<0,-1.5,0><1.5,1.5,-1.5>}}
   clipped_by {bounded_by}
}
#declare Lever2 = object {
torus {0.675,0.025}
   bounded_by {
box {<0,-1.5,0><-1.5,1.5,1.5>}}
   clipped_by {bounded_by}
translate <0,0,-1.03>
}
#declare Lever3 = object {
union {
object {Lever1}
object {Lever2}
}
}
#declare Lever4 = object {
object {Lever3}
   bounded_by {
box {<0,-1.5,0><1.5,1.5,-1.5> rotate 30*y}}
   clipped_by {bounded_by}
rotate -90*x
}
#declare WV3 = object {
union {
//Button
sphere {<-0.23,0,-0.4>,0.04 rotate -90*x}
//Stopper
cylinder {<0.3,0,0><0.35,0,0>,0.05 rotate -30*z}
cylinder {<0.33,0,0><0.38,0,0>,0.1 rotate -30*z}
//Hinge
box {<0.24,-0.05,-0.06><0.36,0.05,-0.07> rotate -90*z}
box {<0.24,-0.05,0.06><0.36,0.05,0.07> rotate -90*z}
cylinder {<0.36,0,0.06><0.36,0,0.07>,0.05 rotate -90*z}
cylinder {<0.36,0,-0.06><0.36,0,-0.07>,0.05 rotate -90*z}
cylinder {<0.36,0,-0.06><0.36,0,0.06>,0.04 rotate -90*z}
object {Lever4}
}
}

//Main Valve Slide
//4th Valve Slide Coil
#declare VS4CoilBottom = object {
torus {0.7125,0.135}
   clipped_by{
box {<0,-0.9,0><0.9,0.9,0.9>}}
   rotate 90*x
   translate <-0.0875,0,0>
}
#declare VS4CoilTop = object {
torus {0.7125,0.135}
   clipped_by{
box {<-0.9,-0.9,0><0,0.9,0.9>}}
   rotate 90*x
   translate <-0.0875,0,0>
}
//4th Valve Slide Straight
#declare VS4StraightBottom = object {
union {
cylinder {<0.625,0,0><0.625,2.6,0>,0.135
   clipped_by{
box {<0,0,-1><1,2.6,1>}}
}
cylinder {<0.625,0,0><0.625,0.25,0>,0.141
   clipped_by{
box {<0,0,-1><1,0.25,1>}}
}
//(Generic A) Joint8
  object {JointA rotate 180*x translate <0,0,-0.3> rotate -6*y
   translate <0,0,0.3> translate <0.625,2.6,-0.3>}
}
}
//Main Finger Ring
#declare FR4 = object {
union {
torus {0.26,0.04
   clipped_by{
box {<-0.5,-0.5,0><0.5,0.5,0.5>}}
}
sphere {<-0.26,0,0>,0.04}
sphere {<0.26,0,0>,0.04}
   rotate -90*x
   scale <1,1.5,1.8>
   translate <-1.189,2,0>
}
}
#declare VS4StraightTop = object {
union {
cone {<-0.8,0,0>,0.135<-0.8,6.5,0>,0.125
   clipped_by{
box {<-1,0,-1><0,6.5,1>}}
}
cylinder {<-0.8,0,0><-0.8,0.25,0>,0.141
   clipped_by{
box {<-1,0,-1><0,0.25,1>}}
}
cylinder {<-0.8,6,0><-0.8,6.5,0>,0.133
   clipped_by{
box {<-1,6,-1><0,6.5,1>}}
}
}
}

//4th Valve Slide
#declare VS4A = object {
union {
object {VS4StraightBottom}
object {VS4CoilBottom}
translate <0.8,0,0>
rotate 6*y
}
}
#declare VS4B = object {
union {
object {VS4CoilTop translate <0,0.7125,0> rotate 0.05*x
 translate <0,-0.7125,0> translate <0.8,0,0> rotate 6*y translate <-0.8,0,0>}
object {VS4A translate <-0.8,0,0>}
object {VS4StraightTop translate <0,0.7125,0> rotate 0.05*x
 translate <0,-0.7125,0>}
object {FR4 translate <0,0.7125,0> rotate 0.05*x translate <0,-0.7125,0>}
}
}
// 4th Watering Valve
#declare Lever5 = object {
torus {0.8925,0.025}
   bounded_by {
box {<0,-1.5,0><1.5,1.5,-1.5>}}
   clipped_by {bounded_by}
rotate -90*x
}
#declare Lever6 = object {
union {
object {Lever5}
torus {0.8925,0.025
   bounded_by {
box {<0,-1.5,0><1.5,1.5,-1.5>}}
   clipped_by {bounded_by}
rotate -90*x
}
   bounded_by {
box {<0,-1.5,0><1.5,1.5,-1.5> rotate -65*y rotate -90*x}}
   clipped_by {bounded_by}
}
}
#declare Lever7 = object {
union {
object {Lever2}
torus {0.675,0.025
   bounded_by {
box {<0,-1.5,0><-1.5,1.5,1.5>}}
   clipped_by {bounded_by}
   translate <0,0,-1.03>
}
   bounded_by {
box {<0,-1.5,0><1.5,1.5,-1.5> rotate 30*y}}
   clipped_by {bounded_by}
   rotate -90*x
}
}
#declare WV4A = object {
union {
//Button
sphere {<-0.23,0,-0.4>,0.04 rotate -90*x}
//Hinge
box {<0.24,-0.05,-0.06><0.36,0.05,-0.07> rotate -90*z}
box {<0.24,-0.05,0.06><0.36,0.05,0.07> rotate -90*z}
cylinder {<0.36,0,0.06><0.36,0,0.07>,0.05 rotate -90*z}
cylinder {<0.36,0,-0.06><0.36,0,-0.07>,0.05 rotate -90*z}
cylinder {<0.36,0,-0.06><0.36,0,0.06>,0.04 rotate -90*z}
object {Lever7}
}
}
#declare WV4B = object {
union {
object {WV4A rotate 90*z translate <0.5375,0,0> rotate -55*z
 translate <0.7125,0,0> rotate 6*y translate <-0.8,0,0>}
object {Lever6 rotate -30*z translate <0.7125,0,0> rotate 6*y
      translate <-0.7125,0,0> translate <-0.0875,0,0>}
//Stopper
cylinder {<0.7125,0,0><0.8875,0,0>,0.05 rotate -30*z translate <0.7125,0,0>
 rotate 6*y translate <-0.8,0,0>}
cylinder {<0.8675,0,0><0.9175,0,0>,0.1 rotate -30*z translate <0.7125,0,0>
 rotate 6*y translate <-0.8,0,0>}
}
}

//Trumpet One
#declare One = object {
union {
//Insert First Valve Slide
  object {VS1 translate <-0.075,6.5,0.9> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>}
//Insert Valve1
  object {Valve1 rotate 4*y translate <-0.55,0,0.45> translate <0,0,0.298>}
//Insert Joint4
  object {JointB rotate 270*x translate <0.1,5.75,0.6>
   translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>}
//Insert Joint5
  object {JointB rotate 270*x translate <-0.25,5.75,0.6>
   translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>}
}
}

//Trumpet Two
#declare Two = object {
union {
//Insert Second Valve Slide
  object {VS2 translate <0,0,0.1> rotate -40*x translate <-0.075,5.2,0.35>
   translate <0.55,0,0> rotate 4*y translate <-0.55,0,0.45>}
//Insert Valve2
  object {Valve2 rotate 4*y translate <-0.55,0,0.45> translate <0,-0.5,0>}
}
}

//Trumpet Three
#declare Three = object {
union {
//Insert Third Valve Slide
  object {VS3 translate <-0.075,2.24,0> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>}
//Insert Third Finger Ring
  object {FR3 translate <-0.075,2.24,0> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>}
//Insert Third Watering Valve
  object {WV3 translate <-0.075,2.24,0> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>}
//Insert Valve3
  object {Valve3 rotate 4*y translate <-0.55,0,0.45> translate <0,-1,0>
   translate <0,0,-0.321>}
//Insert Joint6
  object {JointB rotate 90*x translate <0.1,4.24,0.3>
   translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>}
//Insert Joint7
  object {JointB rotate 90*x translate <-0.25,4.24,0.3>
   translate <0.55,0,-0.45> rotate 4*y translate <-0.55,0,0.45>}
}
}

//Trumpet Main
#declare Main = object {
union {
//Insert Main Valve Slide
  object {VS4B translate <-0.7,1.64,0.9> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>}
//Insert Main Watering Valve
  object {WV4B translate <-0.7,1.64,0.9> translate <0.55,0,-0.45>
   rotate 4*y translate <-0.55,0,0.45>}
}
}

//Trumpet All
union {
//Insert Bell
  object {Bell}
//Insert Joint2
  object {JointA rotate 40*x translate <0.1,5.25,0.65>}
//Insert Joint3
  object {JointA rotate 40*x translate <-0.075,4.7,0.65>}
//Insert Pegs
  object {Pegs}
//Insert Crossbars
  object {Crossbars}
//Insert Trumpet One
  object {One translate <0,0,-0.298>}
//Insert Trumpet Two
  object {Two}
//Insert Trumpet Three
  object {Three translate <0,0,0.321>}
//Insert Trumpet Main
  object {Main translate <-0.0125,0,-0.069>}
  translate <1.5,0,0> rotate 192*y
  translate <0,0.5,-1.265> rotate 96.68*x
  rotate 50*y translate <-4.65,0,-3.65>
  texture {New_Gold}
}

//Floor
object{
  plane{ <0,1,0>,0 }
     pigment { New_Candy_Cane }
         finish { ambient 0.225 diffuse 0.55 reflection 0.0 }
         scale 2.6
         rotate y*45
         normal {wrinkles .5}
}

//Mouthpiece
#declare MPStraight = object {
difference {
cone {<-0.8,1.71,0>,0.0975<-0.8,0,0>,0.1175
}
cone {<-0.8,1.72,0>,0.07<-0.8,0,0>,0.09
}
}
}
union {
object {MPStraight}
torus {0.1175,0.015
  translate <-0.8,0.46,0>
}
sphere {<-0.8,0.26,0>,0.2
}
torus {0.18,0.05
   translate <-0.8,0.26,0>
}
torus {0.22, 0.05
  translate <-0.8,0.16,0>
}
cylinder {<-0.8,0.16,0><-0.8,0.05,0>,0.27
   texture {New_Gold}
}
torus {0.22, 0.05
  translate <-0.8,0.05,0>
}
translate <-3.5,0,1.75>
texture {Silver2}
}

//End of file
