//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 9 textures and 65 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5a.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/14/1997    (14.12.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 4.5
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.0
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera02
  location  <2.735, -14.772, 0.974>
  direction <0.0,     0.0,  1.4812>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.933, -1.292, 5.770>
}

//    Other cameras are commented out.
/*
camera {  //  Camera nebencam1
  location  <7.658, -7.295, 8.631>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <1.526, -4.042, 8.460>
}

*/

/*
camera {  //  Camera nebencam2
  location  <-3.165, -10.899, 7.287>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.898, -3.635, 7.514>
}

*/

// *******  L I G H T S *******
light_source {   // Light002
  <1.297, -3.241, 11.280>
  color rgb <0.596, 0.569, 1.035>
}

light_source {   // Light003
  <-2.767, -4.361, 3.105>
  color rgb <1.867, 1.867, 1.867>
  shadowless
  fade_distance  3.0
  fade_power 1.0
  atmosphere off
}

light_source {   // Light001
  <-59.292, 224.377, 239.970>
  color rgb <1.204, 1.204, 1.204>
  atmosphere off
  atmospheric_attenuation on
}


// ********  TEXTURES  *******
//

#include "twiride.inc"



// ********  REFERENCED OBJECTS  *******

#declare topsurf = object {
  cone { // topsurf
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      gischt_superd6d0
    }
    scale <0.35852, 0.682702, 2.814596>
    rotate <-114.642464, -62.56535, 102.704811>
    translate  <-6.389797, -2.440131, 5.607482>
  }
}
#declare splash = object {
  box { // splash
    <-1, -1, -1>, <1, 1, 1>
    texture {
      gischt_superd7
    }
    scale <0.044706, 0.376218, 1.448059>
    rotate <40.082005, 25.458389, -8.178913>
    translate  <2.928144, 0.137463, 3.001531>
  }
}
#declare splash1 = object {
  box { // splash1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      gischt_superd7
    }
    scale <1.014792, 0.162526, 1.022565>
    rotate <39.466125, 20.779577, 42.088276>
    translate  <2.730024, 1.619765, 3.443197>
  }
}




#declare ear_left = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.280091, 0.047187, 1.889482>, <0.292739, 0.151105, 1.867587>, <0.284813, 0.148801, 1.869536>, <0.289853, 0.148947, 1.868544>, 
      <0.190469, -0.119308, 2.289713>, <0.342111, 0.445010, 2.154937>, <0.823047, 0.447673, 2.062390>, <0.505151, 0.438495, 2.124953>, 
      <0.484256, 0.168349, 3.824708>, <0.635897, 0.732667, 3.689932>, <1.116834, 0.735330, 3.597386>, <0.798938, 0.726152, 3.659948>, 
      <0.749061, 0.434870, 3.636251>, <0.747138, 0.435994, 3.636408>, <0.734042, 0.435593, 3.638990>, <0.742669, 0.435842, 3.637292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.289853, 0.148947, 1.868544>, <0.294893, 0.149092, 1.867552>, <0.267443, -0.056732, 1.911377>, <0.280091, 0.047187, 1.889482>, 
      <0.505151, 0.438495, 2.124953>, <0.187255, 0.429317, 2.187516>, <0.038828, -0.683626, 2.424488>, <0.190469, -0.119308, 2.289713>, 
      <0.798938, 0.726152, 3.659948>, <0.481042, 0.716974, 3.722511>, <0.332615, -0.395969, 3.959484>, <0.484256, 0.168349, 3.824708>, 
      <0.742669, 0.435842, 3.637292>, <0.751296, 0.436091, 3.635594>, <0.750984, 0.433747, 3.636093>, <0.749061, 0.434870, 3.636251>
    }
  }
  scale <0.95871, 0.615038, 0.436314>
  rotate <-10.579534, -3.016711, 23.168432>
  translate  <3.329015, -0.02997, 33.862479>
}




// ********  OBJECTS  *******

sphere { // giscgttop4
  <0,0,0>,1
  texture {
    gischt_superd6d2
  }
  scale <1.621081, 0.293482, 0.372749>
  rotate <1.685322, 12.670825, 24.005184>
  translate  <-0.412012, -2.517851, 4.898364>
}


sphere { // gischttop3
  <0,0,0>,1
  texture {
    gischt_superd6d2
  }
  scale <1.906279, 0.30171, 0.239592>
  rotate <5.944496, 27.466072, 39.023544>
  translate  <1.2903, -2.134833, 4.149253>
}


sphere { // gischttop_lef1
  <0,0,0>,1
  texture {
    gischt_superd6d2
  }
  scale <4.670915, 0.964591, 0.29917>
  translate  <-4.874329, -2.612068, 5.382191>
}




sphere { // gischttop_left
  <0,0,0>,1
  texture {
    gischt_sparse
  }
  scale <4.71539, 0.964591, 0.877354>
  translate  <-4.874329, -2.612068, 5.382191>
}


sphere { // gischttop_right
  <0,0,0>,1
  texture {
    gischt_sparse
  }
  scale <4.115986, 0.527598, 0.304623>
  rotate <-1.725174, 9.016173, -11.935528>
  translate  <6.51839, -1.527035, 2.712197>
}


union { // topsurfcsg2
  object { // topsurf7->topsurf
    topsurf
    rotate <9.765544, 31.772873, 53.247044>
    translate  <1.509328, 3.095953, -4.28638>
  }
  object { // topsurf8->topsurf
    topsurf
    rotate <0.967479, 31.478752, 0.44249>
    translate  <4.059816, -0.715768, -3.824762>
  }
  object { // topsurf9->topsurf
    topsurf
    rotate <0.0, 6.801411, 0.0>
    translate  <4.927101, -0.810845, -1.001657>
  }
  object { // topsurf10->topsurf
    topsurf
    rotate <180.0, -57.977722, -168.280106>
    translate  <1.562804, 0.751874, 13.384207>
  }
  object { // topsurf11->topsurf
    topsurf
    rotate <7.54788, 11.160775, 30.616196>
    translate  <0.914285, 3.301367, -0.846227>
  }
  object { // topsurf12->topsurf
    topsurf
    rotate <0.0, 0.424008, 0.0>
    translate  <2.467945, -0.707646, 0.12089>
  }
  cone { // topsurf13
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      gischt_superd6d1
    }
    scale <0.35852, 0.682702, 2.814596>
    rotate <-114.642464, -62.56535, 102.704811>
    translate  <-6.389797, -2.440131, 5.607482>
  }
  rotate 5.440291*z
  translate  <0.17607, 0.12393, 0.0>
}


union { // gischtcsg
  object { // splash5->splash
    splash
    rotate <-98.256477, -51.494434, 17.222525>
  }
  object { // splash2->splash
    splash
    rotate <-40.722836, -31.079948, 5.048851>
    translate  0.081674*x
  }
  object { splash }
  object { // splash4->splash1
    splash1
    rotate <115.400276, -35.273148, 173.274796>
    translate  <5.472183, -3.196571, 0.968829>
  }
  object { // splash3->splash1
    splash1
    rotate <103.633934, -73.847244, -135.263153>
    translate  <5.999545, -1.136703, 0.705118>
  }
  object { splash1 }
}


union { // topsurfcsg1
  object { // topsurf6->topsurf
    topsurf
    rotate <9.765544, 31.772873, 53.247044>
    translate  <1.509328, 3.095953, -4.28638>
  }
  object { // topsurf5->topsurf
    topsurf
    rotate <0.0, 22.784935, 0.0>
    translate  <5.058128, -0.810845, -2.935891>
  }
  object { // topsurf4->topsurf
    topsurf
    rotate <0.0, 6.801411, 0.0>
    translate  <4.927101, -0.810845, -1.001657>
  }
  object { // topsurf3->topsurf
    topsurf
    rotate <180.0, -57.977722, -168.280106>
    translate  <1.562804, 0.751874, 13.384207>
  }
  object { // topsurf2->topsurf
    topsurf
    rotate <7.54788, 11.160775, 30.616196>
    translate  <0.914285, 3.301367, -0.846227>
  }
  object { // topsurf1->topsurf
    topsurf
    rotate <0.0, 0.424008, 0.0>
    translate  <2.467945, -0.707646, 0.12089>
  }
  object { topsurf }
}


plane { // sky_w_sun
  z,0
  texture {
    skyt
  }
  scale 405.262085
  rotate <105.382408, 0.0, 19.128317>
  translate  <-127.386104, 375.747522, 107.956817>
}




union { // wave2
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.230810, 24.391618, -0.852355>, <0.153125, 18.527437, -1.079182>, <-7.456044, 7.083896, -2.484491>, <-8.465286, 4.618903, -0.569650>, 
      <-6.316284, 28.599012, -0.852355>, <-6.537571, 22.734831, -1.079182>, <-6.293072, 7.095512, 1.731770>, <-7.480643, 4.630519, 1.546402>, 
      <0.785244, 24.414850, -0.852355>, <-5.747917, 22.746447, -1.079182>, <-5.503418, 7.107128, 1.731770>, <-5.376226, 4.642135, 3.577701>, 
      <-1.581039, 26.524355, -0.852355>, <-4.958262, 22.758063, -1.079182>, <-2.077796, 8.621449, 1.267480>, <-3.283137, 5.405103, 3.260472>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.581039, 26.524355, -0.852355>, <-4.958262, 22.758063, -1.079182>, <-2.077796, 8.621449, 1.267480>, <-3.283137, 5.405103, 3.260472>, 
      <-3.947322, 28.633860, -0.852355>, <-4.168608, 22.769679, -1.079182>, <1.347826, 10.135770, 0.803190>, <-1.190047, 6.168072, 2.943243>, 
      <-3.157668, 28.645476, -0.852355>, <-3.378954, 22.781295, -1.079182>, <1.625044, 10.147386, 0.803190>, <-0.671160, 6.179688, 2.858159>, 
      <-0.493169, 26.559203, -0.852355>, <-0.642655, 20.695022, -1.079182>, <0.034948, 12.256891, 0.803190>, <-1.085930, 7.240248, 2.773074>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.493169, 26.559203, -0.852355>, <-0.642655, 20.695022, -1.079182>, <0.034948, 12.256891, 0.803190>, <-1.085930, 7.240248, 2.773074>, 
      <2.171329, 24.472930, -0.852355>, <2.093644, 18.608749, -1.079182>, <-1.555148, 14.366395, 0.803190>, <-1.500699, 8.300809, 2.687990>, 
      <2.448546, 24.484546, -0.852355>, <-1.009992, 22.816143, -1.079182>, <-0.765494, 14.378012, 0.803190>, <-0.725594, 8.312425, 2.602906>, 
      <1.619574, 26.594051, -0.852355>, <-0.220338, 22.827759, -1.079182>, <0.024160, 14.389628, 0.803190>, <0.049511, 8.324041, 2.517822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.619574, 26.594051, -0.852355>, <-0.220338, 22.827759, -1.079182>, <0.024160, 14.389628, 0.803190>, <0.049511, 8.324041, 2.517822>, 
      <0.790602, 28.703556, -0.852355>, <0.569316, 22.839375, -1.079182>, <0.813814, 14.401244, 0.803190>, <0.824617, 8.335657, 2.432737>, 
      <1.580256, 28.715172, -0.852355>, <1.358970, 22.850991, -1.079182>, <1.603468, 14.412860, 0.803190>, <1.599722, 8.347273, 2.347653>, 
      <2.707444, 26.628900, -0.852355>, <2.148624, 22.862607, -1.079182>, <2.723124, 12.326587, 0.803190>, <2.539829, 7.309945, 2.262569>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.707444, 26.628900, -0.852355>, <2.148624, 22.862607, -1.079182>, <2.723124, 12.326587, 0.803190>, <2.539829, 7.309945, 2.262569>, 
      <3.834631, 24.542627, -0.852355>, <2.938278, 22.874223, -1.079182>, <3.842780, 10.240314, 0.803190>, <3.479935, 6.272616, 2.177485>, 
      <4.111848, 24.554243, -0.852355>, <3.727932, 22.885840, -1.079182>, <4.119997, 10.251930, 0.803190>, <3.998822, 6.284233, 2.092401>, 
      <4.389065, 24.565859, -0.852355>, <4.158264, 20.799567, -1.079182>, <4.835867, 12.361435, 0.803190>, <4.648398, 7.344793, 1.865278>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.389065, 24.565859, -0.852355>, <4.158264, 20.799567, -1.079182>, <4.835867, 12.361435, 0.803190>, <4.648398, 7.344793, 1.865278>, 
      <4.666282, 24.577475, -0.852355>, <4.588597, 18.713294, -1.079182>, <5.551738, 14.470940, 0.803190>, <5.297974, 8.405353, 1.638155>, 
      <4.943499, 24.589091, -0.852355>, <4.865814, 18.724910, -1.079182>, <6.341392, 14.482556, 0.803190>, <6.250355, 8.416970, 1.837148>, 
      <5.220716, 24.600707, -0.852355>, <6.886548, 22.932304, -1.079182>, <9.786740, 14.494172, -2.590322>, <9.736054, 8.428586, -0.967369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.465286, 4.618903, -0.569650>, <-9.474527, 2.153910, 1.345190>, <-9.398629, -4.564086, 7.927786>, <-8.804636, -2.329502, 3.386154>, 
      <-7.480643, 4.630519, 1.546402>, <-8.668213, 2.165526, 1.361035>, <-8.592315, -4.552470, 7.943631>, <-7.413679, -2.317886, 5.543554>, 
      <-5.376226, 4.642135, 3.577701>, <-5.249035, 2.177142, 5.423632>, <-4.707311, -4.918387, 7.984939>, <-5.673791, -2.495036, 2.541142>, 
      <-3.283137, 5.405103, 3.260472>, <-4.488478, 2.188758, 5.253464>, <-4.010199, -5.036329, 7.127989>, <-4.730419, -2.539964, 3.624200>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.283137, 5.405103, 3.260472>, <-4.488478, 2.188758, 5.253464>, <-4.010199, -5.036329, 7.127989>, <-4.730419, -2.539964, 3.624200>, 
      <-1.190047, 6.168072, 2.943243>, <-3.727921, 2.200374, 5.083296>, <-3.313087, -5.154272, 6.271039>, <-3.787047, -2.584893, 4.707258>, 
      <-0.671160, 6.179688, 2.858159>, <-2.967364, 2.211990, 4.913127>, <-2.914546, -5.406173, 6.100870>, <-2.995487, -2.721505, 4.622174>, 
      <-1.085930, 7.240248, 2.773074>, <-2.206807, 2.223606, 4.742959>, <-2.439069, -5.352364, 6.009806>, <-2.362921, -2.688793, 4.576642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.085930, 7.240248, 2.773074>, <-2.206807, 2.223606, 4.742959>, <-2.439069, -5.352364, 6.009806>, <-2.362921, -2.688793, 4.576642>, 
      <-1.500699, 8.300809, 2.687990>, <-1.446251, 2.235222, 4.572790>, <-1.963592, -5.298555, 5.918742>, <-1.730356, -2.656080, 4.531110>, 
      <-0.725594, 8.312425, 2.602906>, <-0.685694, 2.246838, 4.402622>, <-0.709378, -5.122241, 5.748574>, <-0.708422, -2.562115, 4.446025>, 
      <0.049511, 8.324041, 2.517822>, <0.074863, 2.258454, 4.232453>, <-0.541210, -5.357672, 5.578405>, <-0.352925, -2.682257, 4.360941>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.049511, 8.324041, 2.517822>, <0.074863, 2.258454, 4.232453>, <-0.541210, -5.357672, 5.578405>, <-0.352925, -2.682257, 4.360941>, 
      <0.824617, 8.335657, 2.432737>, <0.835420, 2.270070, 4.062285>, <-0.373043, -5.593103, 5.408237>, <0.002571, -2.802400, 4.275857>, 
      <1.599722, 8.347273, 2.347653>, <1.595976, 2.281686, 3.892116>, <1.868487, -4.823875, 5.238068>, <1.156148, -1.531070, 3.472402>, 
      <2.539829, 7.309945, 2.262569>, <2.356533, 2.293303, 3.721948>, <2.283483, -3.146415, 3.748521>, <2.062895, -1.118751, 3.086813>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.539829, 7.309945, 2.262569>, <2.356533, 2.293303, 3.721948>, <2.283483, -3.146415, 3.748521>, <2.062895, -1.118751, 3.086813>, 
      <3.479935, 6.272616, 2.177485>, <3.117090, 2.304919, 3.551779>, <2.698480, -1.468955, 2.258973>, <2.969642, -0.706432, 2.701225>, 
      <3.998822, 6.284233, 2.092401>, <3.877647, 2.316535, 3.381611>, <3.853963, -2.593301, 3.525546>, <3.977666, -1.262797, 3.675404>, 
      <4.648398, 7.344793, 1.865278>, <4.460928, 2.328151, 2.927366>, <4.437244, -2.581685, 3.071300>, <4.557768, -1.251181, 3.135796>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.648398, 7.344793, 1.865278>, <4.460928, 2.328151, 2.927366>, <4.437244, -2.581685, 3.071300>, <4.557768, -1.251181, 3.135796>, 
      <5.297974, 8.405353, 1.638155>, <5.044210, 2.339767, 2.473120>, <5.020526, -2.570069, 2.617055>, <5.137871, -1.239565, 2.596189>, 
      <6.250355, 8.416970, 1.837148>, <6.159317, 2.351383, 2.871105>, <6.135633, -2.558453, 3.015040>, <6.267527, -1.227949, 3.079259>, 
      <9.736054, 8.428586, -0.967369>, <9.685368, 2.362999, 0.655583>, <9.661684, -2.202244, 3.116694>, <9.227349, -3.287480, 1.184112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.804636, -2.329502, 3.386154>, <-8.210643, -0.094917, -1.155478>, <-7.013092, -0.002720, 0.391184>, <-7.001486, -1.128002, -0.591913>, 
      <-7.413679, -2.317886, 5.543554>, <-6.235043, -0.083301, 3.143477>, <-6.223438, 0.008896, 0.391184>, <-6.211832, -1.116386, -0.591913>, 
      <-5.673791, -2.495036, 2.541142>, <-6.640271, -0.071685, -2.902654>, <-5.433783, 0.020512, 0.391184>, <-5.422178, -1.104770, -0.591913>, 
      <-4.730419, -2.539964, 3.624200>, <-5.450639, -0.043599, 0.120411>, <-4.644129, 0.032128, 0.391184>, <-4.632524, -1.093153, -0.591913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.730419, -2.539964, 3.624200>, <-5.450639, -0.043599, 0.120411>, <-4.644129, 0.032128, 0.391184>, <-4.632524, -1.093153, -0.591913>, 
      <-3.787047, -2.584893, 4.707258>, <-4.261007, -0.015513, 3.143477>, <-3.854475, 0.043744, 0.391184>, <-3.842870, -1.081537, -0.591913>, 
      <-2.995487, -2.721505, 4.622174>, <-3.076427, -0.036837, 3.143477>, <-3.064821, 0.055360, 0.391184>, <-3.053216, -1.069921, -0.591913>, 
      <-2.362921, -2.688793, 4.576642>, <-2.286773, -0.025221, 3.143477>, <-1.518226, 0.528131, 0.391184>, <-1.885091, -0.827728, -0.591913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.362921, -2.688793, 4.576642>, <-2.286773, -0.025221, 3.143477>, <-1.518226, 0.528131, 0.391184>, <-1.885091, -0.827728, -0.591913>, 
      <-1.730356, -2.656080, 4.531110>, <-1.497119, -0.013605, 3.143477>, <0.028370, 1.000902, 0.391184>, <-0.716966, -0.585534, -0.591913>, 
      <-0.708422, -2.562115, 4.446025>, <-0.707465, -0.001989, 3.143477>, <-0.695859, 0.090208, 0.391184>, <-0.684254, -1.035073, -0.591913>, 
      <-0.352925, -2.682257, 4.360941>, <-0.164640, -0.006843, 3.143477>, <-0.087213, 0.299462, 0.391184>, <0.014897, -0.924638, -0.591913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.352925, -2.682257, 4.360941>, <-0.164640, -0.006843, 3.143477>, <-0.087213, 0.299462, 0.391184>, <0.014897, -0.924638, -0.591913>, 
      <0.002571, -2.802400, 4.275857>, <0.378185, -0.011696, 3.143477>, <0.521433, 0.508716, 0.391184>, <0.714047, -0.814203, -0.591913>, 
      <1.156148, -1.531070, 3.472402>, <0.443808, 1.761736, 1.706736>, <2.199671, 0.652091, 0.391184>, <1.947993, -0.736708, -0.591913>, 
      <2.062895, -1.118751, 3.086813>, <1.842307, 0.908914, 2.425106>, <2.726041, 0.400190, 0.391184>, <2.606005, -0.856850, -0.591913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.062895, -1.118751, 3.086813>, <1.842307, 0.908914, 2.425106>, <2.726041, 0.400190, 0.391184>, <2.606005, -0.856850, -0.591913>, 
      <2.969642, -0.706432, 2.701225>, <3.240805, 0.056092, 3.143477>, <3.252411, 0.148289, 0.391184>, <3.264017, -0.976993, -0.591913>, 
      <3.977666, -1.262797, 3.675404>, <4.101369, 0.067708, 3.825261>, <4.042065, 0.159905, 0.391184>, <4.053671, -0.965377, -0.591913>, 
      <4.557768, -1.251181, 3.135796>, <4.678293, 0.079324, 3.200292>, <4.831719, 0.171521, 0.391184>, <4.843325, -0.953761, -0.591913>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.557768, -1.251181, 3.135796>, <4.678293, 0.079324, 3.200292>, <4.831719, 0.171521, 0.391184>, <4.843325, -0.953761, -0.591913>, 
      <5.137871, -1.239565, 2.596189>, <5.255217, 0.090940, 2.575323>, <5.621373, 0.183137, 0.391184>, <5.632979, -0.942144, -0.591913>, 
      <6.267527, -1.227949, 3.079259>, <6.399421, 0.102556, 3.143477>, <6.411027, 0.194753, 0.391184>, <6.422633, -0.930528, -0.591913>, 
      <9.227349, -3.287480, 1.184112>, <8.793015, -4.372717, -0.748471>, <10.087653, 0.206369, -2.958338>, <8.655773, -0.918912, -2.266674>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.001486, -1.128002, -0.591913>, <-6.989880, -2.253283, -1.575009>, <-6.978274, -3.266922, 0.391184>, <-7.347879, -13.881829, -2.457872>, 
      <-6.211832, -1.116386, -0.591913>, <-6.200226, -2.241667, -1.575009>, <-6.188620, -3.255306, 0.391184>, <-6.177014, -13.870213, -1.424719>, 
      <-5.422178, -1.104770, -0.591913>, <-5.410572, -2.230051, -1.575009>, <-5.398966, -3.243690, 0.391184>, <-5.387360, -13.858597, -1.424719>, 
      <-4.632524, -1.093153, -0.591913>, <-4.620918, -2.218435, -1.575009>, <-4.494125, -3.034436, 0.391184>, <-4.597706, -13.846981, -1.424719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.632524, -1.093153, -0.591913>, <-4.620918, -2.218435, -1.575009>, <-4.494125, -3.034436, 0.391184>, <-4.597706, -13.846981, -1.424719>, 
      <-3.842870, -1.081537, -0.591913>, <-3.831264, -2.206819, -1.575009>, <-3.589285, -2.825182, 0.391184>, <-3.808052, -13.835365, -1.424719>, 
      <-3.053216, -1.069921, -0.591913>, <-3.041610, -2.195203, -1.575009>, <-3.030004, -3.077083, 0.391184>, <-3.018398, -13.823749, -1.424719>, 
      <-1.885091, -0.827728, -0.591913>, <-2.251956, -2.183587, -1.575009>, <-2.240350, -3.131346, 0.391184>, <-2.228744, -13.812132, -1.424719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.885091, -0.827728, -0.591913>, <-2.251956, -2.183587, -1.575009>, <-2.240350, -3.131346, 0.391184>, <-2.228744, -13.812132, -1.424719>, 
      <-0.716966, -0.585534, -0.591913>, <-1.462302, -2.171971, -1.575009>, <-1.450696, -3.185609, 0.391184>, <-1.439090, -13.800516, -1.424719>, 
      <-0.684254, -1.035073, -0.591913>, <-0.672648, -2.160354, -1.575009>, <-0.661042, -3.173993, 0.391184>, <-0.649436, -13.788900, -1.424719>, 
      <0.014897, -0.924638, -0.591913>, <0.117006, -2.148738, -1.575009>, <0.128612, -3.162377, 0.391184>, <0.140218, -13.777284, -1.424719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.014897, -0.924638, -0.591913>, <0.117006, -2.148738, -1.575009>, <0.128612, -3.162377, 0.391184>, <0.140218, -13.777284, -1.424719>, 
      <0.714047, -0.814203, -0.591913>, <0.906660, -2.137122, -1.575009>, <0.918266, -3.150761, 0.391184>, <0.929872, -13.765668, -1.424719>, 
      <1.947993, -0.736708, -0.591913>, <1.696314, -2.125506, -1.575009>, <1.707920, -3.139145, 0.391184>, <1.719526, -13.754052, -1.424719>, 
      <2.606005, -0.856850, -0.591913>, <2.485968, -2.113890, -1.575009>, <2.497574, -3.127529, 0.391184>, <2.509180, -13.742436, -1.424719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.606005, -0.856850, -0.591913>, <2.485968, -2.113890, -1.575009>, <2.497574, -3.127529, 0.391184>, <2.509180, -13.742436, -1.424719>, 
      <3.264017, -0.976993, -0.591913>, <3.275622, -2.102274, -1.575009>, <3.287228, -3.115913, 0.391184>, <3.298834, -13.730820, -1.424719>, 
      <4.053671, -0.965377, -0.591913>, <4.065276, -2.090658, -1.575009>, <4.076882, -3.104297, 0.391184>, <4.088488, -13.719204, -1.424719>, 
      <4.843325, -0.953761, -0.591913>, <4.854930, -2.079042, -1.575009>, <4.866536, -3.092681, 0.391184>, <4.878142, -13.707588, -1.424719>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.843325, -0.953761, -0.591913>, <4.854930, -2.079042, -1.575009>, <4.866536, -3.092681, 0.391184>, <4.878142, -13.707588, -1.424719>, 
      <5.632979, -0.942144, -0.591913>, <5.644584, -2.067426, -1.575009>, <5.656190, -3.081065, 0.391184>, <5.667796, -13.695972, -1.424719>, 
      <6.422633, -0.930528, -0.591913>, <6.434239, -2.055810, -1.575009>, <6.445844, -3.069449, 0.391184>, <6.457450, -13.684356, -1.424719>, 
      <8.655773, -0.918912, -2.266674>, <7.223893, -2.044194, -1.575009>, <10.120103, -3.057833, -2.950353>, <9.362978, -13.672740, -1.698272>
    }
  }
  texture {
    surf5
  }
}


#declare dolph_mainbody = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.297192, 0.000000, -2.000453>, <3.297192, -0.134543, -2.000453>, <3.390590, -0.244624, -1.916943>, <3.461307, -0.190483, -1.755152>, 
      <0.685405, 0.008918, 0.254201>, <0.685405, -0.307094, 0.254201>, <0.704382, -0.573174, 0.335319>, <0.816177, -0.573174, 0.873845>, 
      <-1.272380, 0.016717, -0.631413>, <-1.272380, -0.735920, -0.631413>, <-1.275459, -1.369637, -0.548145>, <-1.528219, -1.369637, 0.528168>, 
      <-2.547614, 0.000000, -1.162114>, <-2.547614, -0.294338, -1.162114>, <-2.743542, -0.535160, -0.915587>, <-2.983009, -0.535160, -0.614276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.461307, -0.190483, -1.755152>, <3.532024, -0.136343, -1.593361>, <3.462540, -0.030382, -1.314393>, <3.462540, 0.000000, -1.314393>, 
      <0.816177, -0.573174, 0.873845>, <0.927972, -0.573174, 1.412371>, <1.018198, -0.314619, 1.846902>, <1.018198, 0.001393, 1.846902>, 
      <-1.528219, -1.369637, 0.528168>, <-1.780979, -1.369637, 1.604481>, <-1.784073, -0.753843, 2.060688>, <-1.784073, -0.001206, 2.060688>, 
      <-2.983009, -0.535160, -0.614276>, <-3.222477, -0.535160, -0.312966>, <-3.418405, -0.294338, -0.066439>, <-3.418405, 0.000000, -0.066439>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.462540, 0.000000, -1.314393>, <3.462540, 0.030382, -1.314393>, <3.532024, 0.136343, -1.593361>, <3.461307, 0.190483, -1.755152>, 
      <1.018198, 0.001393, 1.846902>, <1.018198, 0.317405, 1.846902>, <0.927972, 0.575960, 1.412371>, <0.816177, 0.575960, 0.873845>, 
      <-1.784073, -0.001206, 2.060688>, <-1.784073, 0.751431, 2.060688>, <-1.780979, 1.367225, 1.604481>, <-1.528219, 1.367225, 0.528168>, 
      <-3.418405, 0.000000, -0.066439>, <-3.418405, 0.294338, -0.066439>, <-3.222477, 0.535160, -0.312966>, <-2.983009, 0.535160, -0.614276>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.461307, 0.190483, -1.755152>, <3.390590, 0.244624, -1.916943>, <3.297192, 0.134543, -2.000453>, <3.297192, 0.000000, -2.000453>, 
      <0.816177, 0.575960, 0.873845>, <0.704382, 0.575960, 0.335319>, <0.685405, 0.324931, 0.254201>, <0.685405, 0.008918, 0.254201>, 
      <-1.528219, 1.367225, 0.528168>, <-1.275459, 1.367225, -0.548145>, <-1.272380, 0.769354, -0.631413>, <-1.272380, 0.016717, -0.631413>, 
      <-2.983009, 0.535160, -0.614276>, <-2.743542, 0.535160, -0.915587>, <-2.547614, 0.294338, -1.162114>, <-2.547614, 0.000000, -1.162114>
    }
  }
  rotate <0.0, 0.0, 0.0>
  translate  0.818008*x
}
#declare top_fin = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.060040, -0.214173, -0.320708>, <-0.978754, -0.214173, -0.268126>, <-0.875897, -0.214173, -0.266007>, <-0.728070, -0.214173, -0.223493>, 
      <-1.070661, -0.175185, -0.304288>, <-0.972707, -0.175185, -0.246451>, <-0.875897, -0.175185, -0.246451>, <-0.728070, -0.175185, -0.203937>, 
      <-1.070661, -0.136197, -0.304288>, <-0.972707, -0.136197, -0.246451>, <-0.875897, -0.136197, -0.246451>, <-0.728070, -0.136197, -0.203937>, 
      <-1.070661, -0.097209, -0.304288>, <-0.623658, -0.097209, 0.212427>, <-0.271985, -0.097209, 0.274109>, <0.078530, -0.100662, 0.377280>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.070661, -0.097209, -0.304288>, <-0.623658, -0.097209, 0.212427>, <-0.271985, -0.097209, 0.274109>, <0.078530, -0.100662, 0.377280>, 
      <-1.070661, -0.058221, -0.304288>, <-0.274608, -0.058221, 0.671305>, <0.331928, -0.058221, 0.794669>, <0.791283, -0.058221, 0.856872>, 
      <-1.070661, -0.019233, -0.304288>, <-0.274608, -0.019233, 0.671305>, <0.331928, -0.019233, 0.794669>, <0.791283, -0.019233, 0.856872>, 
      <-1.070661, 0.019754, -0.304288>, <-0.623658, 0.019754, 0.212427>, <-0.271985, 0.019754, 0.274109>, <-0.011569, 0.023238, 0.314374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.070661, 0.019754, -0.304288>, <-0.623658, 0.019754, 0.212427>, <-0.271985, 0.019754, 0.274109>, <-0.011569, 0.023238, 0.314374>, 
      <-1.070661, 0.058742, -0.304288>, <-0.972707, 0.058742, -0.246451>, <-0.875897, 0.058742, -0.246451>, <-0.728070, 0.058742, -0.203937>, 
      <-1.070661, 0.097730, -0.304288>, <-0.972707, 0.097730, -0.246451>, <-0.875897, 0.097730, -0.246451>, <-0.728070, 0.097730, -0.203937>, 
      <-1.060040, 0.136718, -0.320708>, <-0.978754, 0.136718, -0.268126>, <-0.875897, 0.136718, -0.266007>, <-0.728070, 0.136718, -0.223493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.728070, -0.214173, -0.223493>, <-0.580244, -0.214173, -0.180979>, <-0.023024, -0.214173, -0.121460>, <0.105959, -0.214173, -0.125077>, 
      <-0.728070, -0.175185, -0.203937>, <-0.580244, -0.175185, -0.161424>, <-0.023024, -0.175185, -0.101904>, <0.110331, -0.175185, -0.106553>, 
      <-0.728070, -0.136197, -0.203937>, <-0.580244, -0.136197, -0.161424>, <-0.023024, -0.136197, -0.101904>, <0.110331, -0.136197, -0.106553>, 
      <0.078530, -0.100662, 0.377280>, <0.335197, -0.097209, 0.378826>, <0.429168, -0.097209, 0.389474>, <0.404594, -0.100662, 0.240903>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.078530, -0.100662, 0.377280>, <0.335197, -0.097209, 0.378826>, <0.429168, -0.097209, 0.389474>, <0.404594, -0.100662, 0.240903>, 
      <0.791283, -0.058221, 0.856872>, <1.250639, -0.058221, 0.919075>, <0.881361, -0.058221, 0.880853>, <0.624761, -0.058221, 0.525978>, 
      <0.791283, -0.019233, 0.856872>, <1.250639, -0.019233, 0.919075>, <0.881361, -0.019233, 0.880853>, <0.624761, -0.019233, 0.525978>, 
      <-0.011569, 0.023238, 0.314374>, <0.335197, 0.019754, 0.378826>, <0.429168, 0.019754, 0.389474>, <0.374088, 0.023238, 0.203394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.011569, 0.023238, 0.314374>, <0.335197, 0.019754, 0.378826>, <0.429168, 0.019754, 0.389474>, <0.374088, 0.023238, 0.203394>, 
      <-0.728070, 0.058742, -0.203937>, <-0.580244, 0.058742, -0.161424>, <-0.023024, 0.058742, -0.101904>, <0.110331, 0.058742, -0.106553>, 
      <-0.728070, 0.097730, -0.203937>, <-0.580244, 0.097730, -0.161424>, <-0.023024, 0.097730, -0.101904>, <0.110331, 0.097730, -0.106553>, 
      <-0.728070, 0.136718, -0.223493>, <-0.580244, 0.136718, -0.180979>, <-0.023024, 0.136718, -0.121460>, <0.105959, 0.136718, -0.125077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.105959, -0.214173, -0.125077>, <0.234942, -0.214173, -0.128695>, <0.321536, -0.214173, -0.171980>, <0.408131, -0.214173, -0.215265>, 
      <0.110331, -0.175185, -0.106553>, <0.243685, -0.175185, -0.111203>, <0.330280, -0.175185, -0.154488>, <0.416874, -0.175185, -0.197773>, 
      <0.110331, -0.136197, -0.106553>, <0.243685, -0.136197, -0.111203>, <0.330280, -0.136197, -0.154488>, <0.416874, -0.136197, -0.197773>, 
      <0.404594, -0.100662, 0.240903>, <0.305923, -0.097209, 0.029951>, <0.330280, -0.097209, -0.154488>, <0.416874, -0.097209, -0.197773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.404594, -0.100662, 0.240903>, <0.305923, -0.097209, 0.029951>, <0.330280, -0.097209, -0.154488>, <0.416874, -0.097209, -0.197773>, 
      <0.624761, -0.058221, 0.525978>, <0.368161, -0.058221, 0.171104>, <0.330280, -0.058221, -0.154488>, <0.416874, -0.058221, -0.197773>, 
      <0.624761, -0.019233, 0.525978>, <0.368161, -0.019233, 0.171104>, <0.330280, -0.019233, -0.154488>, <0.416874, -0.019233, -0.197773>, 
      <0.374088, 0.023238, 0.203394>, <0.305923, 0.019754, 0.029951>, <0.330280, 0.019754, -0.154488>, <0.416874, 0.019754, -0.197773>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.374088, 0.023238, 0.203394>, <0.305923, 0.019754, 0.029951>, <0.330280, 0.019754, -0.154488>, <0.416874, 0.019754, -0.197773>, 
      <0.110331, 0.058742, -0.106553>, <0.243685, 0.058742, -0.111203>, <0.330280, 0.058742, -0.154488>, <0.416874, 0.058742, -0.197773>, 
      <0.110331, 0.097730, -0.106553>, <0.243685, 0.097730, -0.111203>, <0.330280, 0.097730, -0.154488>, <0.416874, 0.097730, -0.197773>, 
      <0.105959, 0.136718, -0.125077>, <0.234942, 0.136718, -0.128695>, <0.321536, 0.136718, -0.171980>, <0.408131, 0.136718, -0.215265>
    }
  }
  translate  <0.06956, 0.092625, 1.4519>
}
#declare fluke = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.963952, 0.000000, -2.604987>, <4.963952, -0.263162, -2.604987>, <4.968707, -0.478476, -2.607414>, <4.974518, -0.478476, -2.610380>, 
      <4.687853, 0.000000, -2.402674>, <4.687853, -0.263162, -2.402674>, <5.727724, -1.978567, -2.769998>, <5.752549, -1.978567, -2.748467>, 
      <4.860601, 0.000000, -2.580259>, <4.860601, -0.263162, -2.580259>, <5.800691, -1.784969, -2.843133>, <5.829681, -1.784969, -2.819921>, 
      <4.666293, 0.000000, -2.452668>, <4.666293, -0.263162, -2.436380>, <5.171001, -1.355544, -2.555987>, <5.215621, -1.355544, -2.533982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.974518, -0.478476, -2.610380>, <4.980330, -0.478476, -2.613346>, <4.985085, -0.263162, -2.615773>, <4.985085, 0.000000, -2.615773>, 
      <5.752549, -1.978567, -2.748467>, <5.777374, -1.978567, -2.726937>, <4.781740, -0.263162, -2.327991>, <4.781740, 0.000000, -2.327991>, 
      <5.829681, -1.784969, -2.819921>, <5.858670, -1.784969, -2.796708>, <4.969005, -0.263162, -2.498834>, <4.969005, 0.000000, -2.498834>, 
      <5.215621, -1.355544, -2.533982>, <5.260241, -1.355544, -2.479402>, <4.830430, -0.263162, -2.299016>, <4.830430, 0.000000, -2.315304>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.985085, 0.000000, -2.615773>, <4.985085, 0.263162, -2.615773>, <4.980330, 0.478476, -2.613346>, <4.974518, 0.478476, -2.610380>, 
      <4.781740, 0.000000, -2.327991>, <4.781740, 0.263162, -2.327991>, <5.777374, 1.978567, -2.726937>, <5.752549, 1.978567, -2.748467>, 
      <4.969005, 0.000000, -2.498834>, <4.969005, 0.263162, -2.498834>, <5.858670, 1.784969, -2.796708>, <5.829681, 1.784969, -2.819921>, 
      <4.830430, 0.000000, -2.315304>, <4.830430, 0.263162, -2.299016>, <5.260241, 1.355544, -2.479402>, <5.215621, 1.355544, -2.533982>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.974518, 0.478476, -2.610380>, <4.968707, 0.478476, -2.607414>, <4.963952, 0.263162, -2.604987>, <4.963952, 0.000000, -2.604987>, 
      <5.752549, 1.978567, -2.748467>, <5.727724, 1.978567, -2.769998>, <4.687853, 0.263162, -2.402674>, <4.687853, 0.000000, -2.402674>, 
      <5.829681, 1.784969, -2.819921>, <5.800691, 1.784969, -2.843133>, <4.860601, 0.263162, -2.580259>, <4.860601, 0.000000, -2.580259>, 
      <5.215621, 1.355544, -2.533982>, <5.171001, 1.355544, -2.555987>, <4.666293, 0.263162, -2.436380>, <4.666293, 0.000000, -2.452668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.666293, 0.000000, -2.452668>, <4.666293, -0.263162, -2.436380>, <5.171001, -1.355544, -2.555987>, <5.215621, -1.355544, -2.533982>, 
      <4.471985, 0.000000, -2.292501>, <4.471985, -0.263162, -2.292501>, <4.541310, -0.926120, -2.268840>, <4.601560, -0.926120, -2.215467>, 
      <4.260288, 0.000000, -2.170457>, <4.260288, -0.263162, -2.170457>, <4.331023, -0.478476, -2.104755>, <4.417477, -0.478476, -2.024453>, 
      <4.088998, 0.000000, -1.996851>, <4.088998, -0.088437, -1.996851>, <4.160117, -0.160795, -1.931533>, <4.223079, -0.160795, -1.775251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.215621, -1.355544, -2.533982>, <5.260241, -1.355544, -2.479402>, <4.830430, -0.263162, -2.299016>, <4.830430, 0.000000, -2.315304>, 
      <4.601560, -0.926120, -2.215467>, <4.661811, -0.926120, -2.162095>, <4.691856, -0.263162, -2.099198>, <4.691856, 0.000000, -2.099198>, 
      <4.417477, -0.478476, -2.024453>, <4.503930, -0.478476, -1.944151>, <4.574665, -0.263162, -1.878449>, <4.574665, 0.000000, -1.878449>, 
      <4.223079, -0.160795, -1.775251>, <4.286041, -0.160795, -1.618970>, <4.238250, -0.088437, -1.270863>, <4.238250, 0.000000, -1.270863>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.830430, 0.000000, -2.315304>, <4.830430, 0.263162, -2.299016>, <5.260241, 1.355544, -2.479402>, <5.215621, 1.355544, -2.533982>, 
      <4.691856, 0.000000, -2.099198>, <4.691856, 0.263162, -2.099198>, <4.661811, 0.926120, -2.162095>, <4.601560, 0.926120, -2.215467>, 
      <4.574665, 0.000000, -1.878449>, <4.574665, 0.263162, -1.878449>, <4.503930, 0.478476, -1.944151>, <4.417477, 0.478476, -2.024453>, 
      <4.238250, 0.000000, -1.270863>, <4.238250, 0.088437, -1.270863>, <4.286041, 0.160795, -1.618970>, <4.223079, 0.160795, -1.775251>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.215621, 1.355544, -2.533982>, <5.171001, 1.355544, -2.555987>, <4.666293, 0.263162, -2.436380>, <4.666293, 0.000000, -2.452668>, 
      <4.601560, 0.926120, -2.215467>, <4.541310, 0.926120, -2.268840>, <4.471985, 0.263162, -2.292501>, <4.471985, 0.000000, -2.292501>, 
      <4.417477, 0.478476, -2.024453>, <4.331023, 0.478476, -2.104755>, <4.260288, 0.263162, -2.170457>, <4.260288, 0.000000, -2.170457>, 
      <4.223079, 0.160795, -1.775251>, <4.160117, 0.160795, -1.931533>, <4.088998, 0.088437, -1.996851>, <4.088998, 0.000000, -1.996851>
    }
  }
}
#declare dolph_lowerhead = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.608801, 0.031428, -1.122760>, <-1.608801, -0.155593, -1.122760>, <-1.847504, -0.325612, -0.946319>, <-1.954177, -0.441608, -0.873436>, 
      <-1.938537, 0.031428, -1.240653>, <-1.938537, -0.155593, -1.240653>, <-2.035513, -0.325612, -1.174395>, <-2.142185, -0.325612, -1.101512>, 
      <-2.002531, 0.031428, -1.274184>, <-2.002531, -0.155593, -1.274184>, <-2.019429, -0.291832, -1.150452>, <-2.125808, -0.291832, -1.077173>, 
      <-2.037888, 0.028646, -1.312690>, <-2.041592, -0.097180, -1.312690>, <-2.116281, -0.194678, -1.224243>, <-2.184199, -0.194678, -1.175010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.954177, -0.441608, -0.873436>, <-2.060849, -0.557605, -0.800553>, <-1.976479, -0.155593, -1.116055>, <-1.976479, 0.031428, -1.116055>, 
      <-2.142185, -0.325612, -1.101512>, <-2.248858, -0.325612, -1.028629>, <-2.046246, -0.155593, -1.208153>, <-2.046246, 0.031428, -1.208153>, 
      <-2.125808, -0.291832, -1.077173>, <-2.232188, -0.291832, -1.003894>, <-2.242328, -0.155593, -1.198129>, <-2.242328, 0.031428, -1.198129>, 
      <-2.184199, -0.194678, -1.175010>, <-2.259526, -0.194678, -1.125776>, <-2.205070, -0.114822, -1.343782>, <-2.201365, 0.024677, -1.343782>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.976479, 0.031428, -1.116055>, <-1.976479, 0.218449, -1.116055>, <-2.060849, 0.586457, -0.800553>, <-1.954177, 0.470461, -0.873436>, 
      <-2.046246, 0.031428, -1.208153>, <-2.046246, 0.218449, -1.208153>, <-2.248858, 0.354464, -1.028629>, <-2.142185, 0.354464, -1.101512>, 
      <-2.242328, 0.031428, -1.198129>, <-2.242328, 0.218449, -1.198129>, <-2.232188, 0.302536, -1.003894>, <-2.125808, 0.302536, -1.077173>, 
      <-2.201365, 0.024677, -1.343782>, <-2.205070, 0.164175, -1.343782>, <-2.259526, 0.220018, -1.125776>, <-2.184199, 0.220018, -1.175010>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.954177, 0.470461, -0.873436>, <-1.847504, 0.354464, -0.946319>, <-1.608801, 0.218449, -1.122760>, <-1.608801, 0.031428, -1.122760>, 
      <-2.142185, 0.354464, -1.101512>, <-2.035513, 0.354464, -1.174395>, <-1.938537, 0.218449, -1.240653>, <-1.938537, 0.031428, -1.240653>, 
      <-2.125808, 0.302536, -1.077173>, <-2.019429, 0.302536, -1.150452>, <-2.002531, 0.218449, -1.274184>, <-2.002531, 0.031428, -1.274184>, 
      <-2.184199, 0.220018, -1.175010>, <-2.116281, 0.220018, -1.224243>, <-2.041592, 0.154473, -1.312690>, <-2.037888, 0.028646, -1.312690>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.037888, 0.028646, -1.312690>, <-2.041592, -0.097180, -1.312690>, <-2.116281, -0.194678, -1.224243>, <-2.184199, -0.194678, -1.175010>, 
      <-2.080653, 0.025865, -1.351196>, <-2.080653, -0.038767, -1.351196>, <-2.213134, -0.097523, -1.298034>, <-2.249998, -0.097523, -1.272847>, 
      <-2.578110, 0.025865, -1.852890>, <-2.578110, -0.038767, -1.852890>, <-2.540728, -0.147013, -1.843026>, <-2.622123, -0.147013, -1.722994>, 
      <-2.635323, 0.023140, -1.695617>, <-2.635323, 0.018457, -1.695617>, <-2.637265, 0.014201, -1.694290>, <-2.639936, 0.014201, -1.692465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.184199, -0.194678, -1.175010>, <-2.259526, -0.194678, -1.125776>, <-2.205070, -0.114822, -1.343782>, <-2.201365, 0.024677, -1.343782>, 
      <-2.249998, -0.097523, -1.272847>, <-2.286863, -0.097523, -1.247659>, <-2.167811, -0.074050, -1.489436>, <-2.167811, 0.017926, -1.489436>, 
      <-2.622123, -0.147013, -1.722994>, <-2.703518, -0.147013, -1.602962>, <-2.656206, -0.038767, -1.677777>, <-2.656206, 0.025865, -1.677777>, 
      <-2.639936, 0.014201, -1.692465>, <-2.642607, 0.014201, -1.690641>, <-2.645384, 0.018457, -1.689443>, <-2.645384, 0.023140, -1.689443>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.201365, 0.024677, -1.343782>, <-2.205070, 0.164175, -1.343782>, <-2.259526, 0.220018, -1.125776>, <-2.184199, 0.220018, -1.175010>, 
      <-2.167811, 0.017926, -1.489436>, <-2.167811, 0.109902, -1.489436>, <-2.286863, 0.137501, -1.247659>, <-2.249998, 0.137501, -1.272847>, 
      <-2.656206, 0.025865, -1.677777>, <-2.656206, 0.090496, -1.677777>, <-2.703518, 0.187445, -1.602962>, <-2.622123, 0.187445, -1.722994>, 
      <-2.645384, 0.023140, -1.689443>, <-2.645384, 0.027822, -1.689443>, <-2.642607, 0.031228, -1.690641>, <-2.639936, 0.031228, -1.692465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.184199, 0.220018, -1.175010>, <-2.116281, 0.220018, -1.224243>, <-2.041592, 0.154473, -1.312690>, <-2.037888, 0.028646, -1.312690>, 
      <-2.249998, 0.137501, -1.272847>, <-2.213134, 0.137501, -1.298034>, <-2.080653, 0.090496, -1.351196>, <-2.080653, 0.025865, -1.351196>, 
      <-2.622123, 0.187445, -1.722994>, <-2.540728, 0.187445, -1.843026>, <-2.578110, 0.090496, -1.852890>, <-2.578110, 0.025865, -1.852890>, 
      <-2.639936, 0.031228, -1.692465>, <-2.637265, 0.031228, -1.694290>, <-2.635323, 0.027822, -1.695617>, <-2.635323, 0.023140, -1.695617>
    }
  }
}
#declare dolph_forehead = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.934871, -0.024422, -1.175168>, <-1.934871, -0.428123, -1.175168>, <-2.040919, -0.517732, -0.988371>, <-2.265714, -0.528448, -0.668238>, 
      <-1.948913, 0.035767, -1.028083>, <-1.948913, -0.388366, -1.028083>, <-2.145703, -0.581897, -1.104540>, <-2.425390, -0.488000, -0.990463>, 
      <-2.132406, -0.021492, -1.215455>, <-2.132406, 0.005341, -1.215455>, <-2.257106, -0.418707, -1.109757>, <-2.350224, -0.292873, -1.214751>, 
      <-2.187293, -0.021492, -1.230332>, <-2.187293, -0.003533, -1.230332>, <-2.259969, -0.290744, -1.177391>, <-2.341435, -0.227827, -1.195684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.265714, -0.528448, -0.668238>, <-2.490510, -0.539165, -0.348105>, <-2.636800, -0.260778, -0.173990>, <-2.636800, 0.001636, -0.173990>, 
      <-2.425390, -0.488000, -0.990463>, <-2.705078, -0.394103, -0.876386>, <-2.725782, -0.305261, -0.117382>, <-2.725782, 0.001636, -0.117382>, 
      <-2.350224, -0.292873, -1.214751>, <-2.443342, -0.167038, -1.319746>, <-2.909895, -0.134861, -0.971507>, <-2.909895, 0.007479, -0.971507>, 
      <-2.341435, -0.227827, -1.195684>, <-2.422902, -0.164910, -1.213977>, <-2.753693, -0.074166, -1.041948>, <-2.753693, 0.007479, -1.041948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.636800, 0.001636, -0.173990>, <-2.636800, 0.264049, -0.173990>, <-2.490510, 0.542437, -0.348105>, <-2.265714, 0.541152, -0.668238>, 
      <-2.725782, 0.001636, -0.117382>, <-2.725782, 0.308533, -0.117382>, <-2.705078, 0.409061, -0.876386>, <-2.425390, 0.506546, -0.990463>, 
      <-2.909895, 0.007479, -0.971507>, <-2.909895, 0.149818, -0.971507>, <-2.443342, 0.181996, -1.319746>, <-2.350224, 0.318346, -1.214751>, 
      <-2.753693, 0.007479, -1.041948>, <-2.753693, 0.089123, -1.041948>, <-2.422902, 0.179867, -1.213977>, <-2.341435, 0.248043, -1.195684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.265714, 0.541152, -0.668238>, <-2.040919, 0.539867, -0.988371>, <-1.934871, 0.379279, -1.175168>, <-1.934871, -0.024422, -1.175168>, 
      <-2.425390, 0.506546, -0.990463>, <-2.145703, 0.604032, -1.104540>, <-1.948913, 0.459900, -1.028083>, <-1.948913, 0.035767, -1.028083>, 
      <-2.350224, 0.318346, -1.214751>, <-2.257106, 0.454696, -1.109757>, <-2.132406, -0.048324, -1.215455>, <-2.132406, -0.021492, -1.215455>, 
      <-2.341435, 0.248043, -1.195684>, <-2.259969, 0.316218, -1.177391>, <-2.187293, -0.039450, -1.230332>, <-2.187293, -0.021492, -1.230332>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.187293, -0.021492, -1.230332>, <-2.187293, -0.003533, -1.230332>, <-2.259969, -0.290744, -1.177391>, <-2.341435, -0.227827, -1.195684>, 
      <-2.242180, -0.021492, -1.245208>, <-2.242180, -0.012407, -1.245208>, <-2.262831, -0.162781, -1.245025>, <-2.332646, -0.162781, -1.176617>, 
      <-2.715762, 0.007479, -1.975500>, <-2.715762, -0.085286, -1.975500>, <-2.767291, -0.161185, -1.802859>, <-2.836654, -0.161185, -1.795581>, 
      <-2.776303, 0.007479, -1.805761>, <-2.776303, 0.009376, -1.805761>, <-2.775194, 0.010928, -1.806847>, <-2.773839, 0.010928, -1.808175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.341435, -0.227827, -1.195684>, <-2.422902, -0.164910, -1.213977>, <-2.753693, -0.074166, -1.041948>, <-2.753693, 0.007479, -1.041948>, 
      <-2.332646, -0.162781, -1.176617>, <-2.402462, -0.162781, -1.108208>, <-2.597491, -0.013471, -1.112389>, <-2.597491, 0.007479, -1.112389>, 
      <-2.836654, -0.161185, -1.795581>, <-2.906016, -0.161185, -1.788303>, <-2.961251, -0.085286, -1.733956>, <-2.961251, 0.007479, -1.733956>, 
      <-2.773839, 0.010928, -1.808175>, <-2.772484, 0.010928, -1.809503>, <-2.771375, 0.009376, -1.810589>, <-2.771375, 0.007479, -1.810589>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.753693, 0.007479, -1.041948>, <-2.753693, 0.089123, -1.041948>, <-2.422902, 0.179867, -1.213977>, <-2.341435, 0.248043, -1.195684>, 
      <-2.597491, 0.007479, -1.112389>, <-2.597491, 0.028429, -1.112389>, <-2.402462, 0.177739, -1.108208>, <-2.332646, 0.177739, -1.176617>, 
      <-2.961251, 0.007479, -1.733956>, <-2.961251, 0.100244, -1.733956>, <-2.906016, 0.176143, -1.788303>, <-2.836654, 0.176143, -1.795581>, 
      <-2.771375, 0.007479, -1.810589>, <-2.771375, 0.005582, -1.810589>, <-2.772484, 0.004030, -1.809503>, <-2.773839, 0.004030, -1.808175>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.341435, 0.248043, -1.195684>, <-2.259969, 0.316218, -1.177391>, <-2.187293, -0.039450, -1.230332>, <-2.187293, -0.021492, -1.230332>, 
      <-2.332646, 0.177739, -1.176617>, <-2.262831, 0.177739, -1.245025>, <-2.242180, -0.030576, -1.245208>, <-2.242180, -0.021492, -1.245208>, 
      <-2.836654, 0.176143, -1.795581>, <-2.767291, 0.176143, -1.802859>, <-2.715762, 0.100244, -1.975500>, <-2.715762, 0.007479, -1.975500>, 
      <-2.773839, 0.004030, -1.808175>, <-2.775194, 0.004030, -1.806847>, <-2.776303, 0.005582, -1.805761>, <-2.776303, 0.007479, -1.805761>
    }
  }
  rotate 0.939209*y
  translate  <0.086934, 0.0, 0.087936>
}
#declare dolph_leftfin = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.956483, 0.544899, 0.346751>, <-1.673620, 0.284452, 0.056641>, <-1.800141, 0.387170, 0.339338>, <-1.033453, 0.607388, 0.518732>, 
      <-0.745892, 0.747536, 0.339802>, <-1.144992, 0.604933, 0.176986>, <-1.216483, 0.667752, 0.332310>, <-0.789384, 0.785753, 0.434295>, 
      <-0.710252, 1.176692, 0.192538>, <-1.114840, 1.039619, 0.040954>, <-1.154801, 1.073168, 0.129368>, <-0.734563, 1.197103, 0.246325>, 
      <-0.206564, 1.670626, 0.011279>, <-0.239075, 1.665590, -0.003005>, <-0.236238, 1.633147, 0.019463>, <-0.204839, 1.650889, 0.024948>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.033453, 0.607388, 0.518732>, <-0.266766, 0.827606, 0.698126>, <-0.239347, 0.805345, 0.636860>, <-0.956483, 0.544899, 0.346751>, 
      <-0.789384, 0.785753, 0.434295>, <-0.362285, 0.903753, 0.536280>, <-0.346791, 0.890139, 0.502619>, <-0.745892, 0.747536, 0.339802>, 
      <-0.734563, 1.197103, 0.246325>, <-0.314324, 1.321037, 0.363282>, <-0.305664, 1.313766, 0.344121>, <-0.710252, 1.176692, 0.192538>, 
      <-0.204839, 1.650889, 0.024948>, <-0.173439, 1.668632, 0.030432>, <-0.174054, 1.675663, 0.025563>, <-0.206564, 1.670626, 0.011279>
    }
  }
  translate  <0.0, 0.058924, -0.847606>
}
#declare dolph_rightfin = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.016315, 0.544899, 0.414536>, <-1.728361, 0.284452, 0.112146>, <-1.859720, 0.387170, 0.392628>, <-1.096229, 0.607388, 0.585170>, 
      <-0.805635, 0.747536, 0.411207>, <-1.201879, 0.604933, 0.241557>, <-1.276028, 0.667752, 0.395630>, <-0.850745, 0.785753, 0.504939>, 
      <-0.767470, 1.176692, 0.264577>, <-1.169394, 1.039619, 0.106064>, <-1.210868, 1.073168, 0.193777>, <-0.792701, 1.197103, 0.317939>, 
      <-0.260742, 1.670626, 0.092000>, <-0.293002, 1.665590, 0.077160>, <-0.290552, 1.633147, 0.099674>, <-0.259252, 1.650889, 0.105697>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.096229, 0.607388, 0.585170>, <-0.332738, 0.827606, 0.777712>, <-0.304270, 0.805345, 0.716926>, <-1.016315, 0.544899, 0.414536>, 
      <-0.850745, 0.785753, 0.504939>, <-0.425461, 0.903753, 0.614248>, <-0.409392, 0.890139, 0.580858>, <-0.805635, 0.747536, 0.411207>, 
      <-0.792701, 1.197103, 0.317939>, <-0.374535, 1.321037, 0.442100>, <-0.365547, 1.313766, 0.423091>, <-0.767470, 1.176692, 0.264577>, 
      <-0.259252, 1.650889, 0.105697>, <-0.227951, 1.668632, 0.111720>, <-0.228482, 1.675663, 0.106841>, <-0.260742, 1.670626, 0.092000>
    }
  }
  scale <1.0, -1.0, 1.0>
  translate  <0.0, 0.056101, -0.904973>
}
#declare dolphin = union {
  object { dolph_mainbody }
  object { top_fin }
  object { fluke }
  object { dolph_lowerhead }
  object { dolph_forehead }
  object { dolph_leftfin }
  object { dolph_rightfin }
  texture {
    dolph_skin
  }
  rotate <7.458404, -11.991222, 57.784321>
  translate  <0.4217, -3.790205, 5.803277>
}
#declare head = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.749572, 1.049646, 31.886531>, <1.732622, 1.681441, 32.141403>, <1.827938, 1.808413, 32.283446>, <2.220812, 1.808413, 32.283446>, 
      <1.785459, 0.546131, 33.162009>, <1.804396, 0.961003, 33.523764>, <1.861575, 1.393369, 32.872170>, <2.254590, 1.393369, 32.872170>, 
      <1.886607, 0.660340, 33.508942>, <1.763787, 0.897792, 33.494819>, <1.581657, 1.047378, 33.285924>, <2.254590, 1.047378, 33.285924>, 
      <1.770032, 0.399225, 33.618855>, <1.635107, 0.919532, 33.615449>, <1.577822, 1.093420, 33.494761>, <2.255245, 1.093420, 33.494761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.220812, 1.808413, 32.283446>, <2.613687, 1.808413, 32.283446>, <2.779180, 1.681441, 32.141403>, <2.756475, 1.049646, 31.886531>, 
      <2.254590, 1.393369, 32.872170>, <2.647604, 1.393369, 32.872170>, <2.704783, 0.961003, 33.523764>, <2.719277, 0.546131, 33.162009>, 
      <2.254590, 1.047378, 33.285924>, <2.927523, 1.047378, 33.285924>, <2.745392, 0.897792, 33.494819>, <2.622572, 0.660340, 33.508942>, 
      <2.255245, 1.093420, 33.494761>, <2.932669, 1.093420, 33.494761>, <2.874072, 0.919532, 33.615449>, <2.739803, 0.399225, 33.618855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.756475, 1.049646, 31.886531>, <2.733770, 0.417852, 31.631659>, <2.486805, 0.222333, 31.600374>, <2.220812, 0.222333, 31.600374>, 
      <2.719277, 0.546131, 33.162009>, <2.733770, 0.131258, 32.800253>, <2.683737, -0.011477, 33.997110>, <2.255901, -0.011477, 33.997110>, 
      <2.622572, 0.660340, 33.508942>, <2.499752, 0.422888, 33.523065>, <2.561878, -0.379342, 33.284381>, <2.251093, -0.379342, 33.284381>, 
      <2.739803, 0.399225, 33.618855>, <2.605534, -0.121081, 33.622261>, <2.664841, -0.714168, 33.500738>, <2.253497, -0.714168, 33.500738>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.220812, 0.222333, 31.600374>, <1.954819, 0.222333, 31.600374>, <1.766523, 0.417852, 31.631659>, <1.749572, 1.049646, 31.886531>, 
      <2.255901, -0.011477, 33.997110>, <1.828066, -0.011477, 33.997110>, <1.766523, 0.131258, 32.800253>, <1.785459, 0.546131, 33.162009>, 
      <2.251093, -0.379342, 33.284381>, <1.940309, -0.379342, 33.284381>, <2.009427, 0.422888, 33.523065>, <1.886607, 0.660340, 33.508942>, 
      <2.253497, -0.714168, 33.500738>, <1.842153, -0.714168, 33.500738>, <1.904957, -0.121081, 33.622261>, <1.770032, 0.399225, 33.618855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.770032, 0.399225, 33.618855>, <1.635107, 0.919532, 33.615449>, <1.577822, 1.093420, 33.494761>, <2.255245, 1.093420, 33.494761>, 
      <1.653457, 0.138110, 33.728768>, <1.506427, 0.941272, 33.736079>, <1.573988, 1.139461, 33.703597>, <2.255901, 1.139461, 33.703597>, 
      <1.424066, 0.373603, 34.122947>, <1.243948, 1.215790, 34.104416>, <1.262777, 1.223578, 34.176799>, <2.255901, 1.223578, 34.176799>, 
      <1.314543, 0.337389, 34.552134>, <1.242196, 1.241595, 34.542769>, <1.282056, 1.524383, 34.547929>, <2.255901, 1.524383, 34.547929>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.255245, 1.093420, 33.494761>, <2.932669, 1.093420, 33.494761>, <2.874072, 0.919532, 33.615449>, <2.739803, 0.399225, 33.618855>, 
      <2.255901, 1.139461, 33.703597>, <2.937815, 1.139461, 33.703597>, <3.002752, 0.941272, 33.736079>, <2.857034, 0.138110, 33.728768>, 
      <2.255901, 1.223578, 34.176799>, <3.249025, 1.223578, 34.176799>, <3.267854, 1.215790, 34.104416>, <3.087736, 0.373603, 34.122947>, 
      <2.255901, 1.524383, 34.547929>, <3.229746, 1.524383, 34.547929>, <3.291174, 1.241595, 34.542769>, <3.208044, 0.337389, 34.552134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.739803, 0.399225, 33.618855>, <2.605534, -0.121081, 33.622261>, <2.664841, -0.714168, 33.500738>, <2.253497, -0.714168, 33.500738>, 
      <2.857034, 0.138110, 33.728768>, <2.711316, -0.665051, 33.721457>, <2.767805, -1.048994, 33.717094>, <2.255901, -1.048994, 33.717094>, 
      <3.087736, 0.373603, 34.122947>, <2.907618, -0.468583, 34.141478>, <2.988456, -0.793790, 34.313209>, <2.255901, -0.793790, 34.313209>, 
      <3.208044, 0.337389, 34.552134>, <3.124913, -0.566817, 34.561499>, <2.800537, -0.666773, 34.620082>, <2.255901, -0.666773, 34.620082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.253497, -0.714168, 33.500738>, <1.842153, -0.714168, 33.500738>, <1.904957, -0.121081, 33.622261>, <1.770032, 0.399225, 33.618855>, 
      <2.255901, -1.048994, 33.717094>, <1.743998, -1.048994, 33.717094>, <1.800487, -0.665051, 33.721457>, <1.653457, 0.138110, 33.728768>, 
      <2.255901, -0.793790, 34.313209>, <1.523346, -0.793790, 34.313209>, <1.604184, -0.468583, 34.141478>, <1.424066, 0.373603, 34.122947>, 
      <2.255901, -0.666773, 34.620082>, <1.711265, -0.666773, 34.620082>, <1.386889, -0.566817, 34.561499>, <1.314543, 0.337389, 34.552134>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.314543, 0.337389, 34.552134>, <1.242196, 1.241595, 34.542769>, <1.282056, 1.524383, 34.547929>, <2.255901, 1.524383, 34.547929>, 
      <1.205019, 0.301174, 34.981321>, <1.240444, 1.267399, 34.981121>, <1.301335, 1.825188, 34.919059>, <2.255901, 1.825188, 34.919059>, 
      <1.161478, 0.482013, 35.148178>, <1.102012, 1.439680, 35.142722>, <1.173910, 1.934844, 35.617250>, <2.255901, 1.934844, 35.617250>, 
      <1.121344, 0.589530, 35.648178>, <1.060163, 1.439680, 35.562743>, <1.256072, 1.897971, 35.860828>, <2.256979, 1.897971, 35.860828>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.255901, 1.524383, 34.547929>, <3.229746, 1.524383, 34.547929>, <3.291174, 1.241595, 34.542769>, <3.208044, 0.337389, 34.552134>, 
      <2.255901, 1.825188, 34.919059>, <3.210467, 1.825188, 34.919059>, <3.314495, 1.267399, 34.981121>, <3.328351, 0.301174, 34.981321>, 
      <2.255901, 1.934844, 35.617250>, <3.337892, 1.934844, 35.617250>, <3.452927, 1.439680, 35.142722>, <3.371892, 0.482013, 35.148178>, 
      <2.256979, 1.897971, 35.860828>, <3.257885, 1.897971, 35.860828>, <3.493698, 1.439680, 35.562743>, <3.421734, 0.589530, 35.648178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.208044, 0.337389, 34.552134>, <3.124913, -0.566817, 34.561499>, <2.800537, -0.666773, 34.620082>, <2.255901, -0.666773, 34.620082>, 
      <3.328351, 0.301174, 34.981321>, <3.342208, -0.665051, 34.981520>, <2.612619, -0.539757, 34.926954>, <2.255901, -0.539757, 34.926954>, 
      <3.371892, 0.482013, 35.148178>, <3.290857, -0.475653, 35.153633>, <3.004573, -0.527784, 35.530955>, <2.206612, -0.527784, 35.530955>, 
      <3.421734, 0.589530, 35.648178>, <3.349769, -0.260620, 35.733613>, <3.204908, -1.035252, 35.547702>, <2.249199, -1.035252, 35.547702>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.255901, -0.666773, 34.620082>, <1.711265, -0.666773, 34.620082>, <1.386889, -0.566817, 34.561499>, <1.314543, 0.337389, 34.552134>, 
      <2.255901, -0.539757, 34.926954>, <1.899184, -0.539757, 34.926954>, <1.169594, -0.665051, 34.981520>, <1.205019, 0.301174, 34.981321>, 
      <2.206612, -0.527784, 35.530955>, <1.408651, -0.527784, 35.530955>, <1.220945, -0.475653, 35.153633>, <1.161478, 0.482013, 35.148178>, 
      <2.249199, -1.035252, 35.547702>, <1.293490, -1.035252, 35.547702>, <1.182524, -0.260620, 35.733613>, <1.121344, 0.589530, 35.648178>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.121344, 0.589530, 35.648178>, <1.060163, 1.439680, 35.562743>, <1.256072, 1.897971, 35.860828>, <2.256979, 1.897971, 35.860828>, 
      <1.081209, 0.697047, 36.148178>, <1.018314, 1.439680, 35.982764>, <1.338235, 1.861098, 36.104407>, <2.258056, 1.861098, 36.104407>, 
      <1.251028, 0.447873, 36.735986>, <1.053361, 1.128700, 36.656070>, <1.473805, 1.705816, 36.521755>, <2.277469, 1.705816, 36.521755>, 
      <2.296753, 0.644456, 36.907508>, <2.296753, 0.647602, 36.907508>, <2.296703, 0.650176, 36.907508>, <2.296641, 0.650176, 36.907508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.256979, 1.897971, 35.860828>, <3.257885, 1.897971, 35.860828>, <3.493698, 1.439680, 35.562743>, <3.421734, 0.589530, 35.648178>, 
      <2.258056, 1.861098, 36.104407>, <3.177878, 1.861098, 36.104407>, <3.534469, 1.439680, 35.982764>, <3.471575, 0.697047, 36.148178>, 
      <2.277469, 1.705816, 36.521755>, <3.081134, 1.705816, 36.521755>, <3.501577, 1.128700, 36.656070>, <3.303910, 0.447873, 36.735986>, 
      <2.296641, 0.650176, 36.907508>, <2.296579, 0.650176, 36.907508>, <2.296529, 0.647602, 36.907508>, <2.296529, 0.644456, 36.907508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.421734, 0.589530, 35.648178>, <3.349769, -0.260620, 35.733613>, <3.204908, -1.035252, 35.547702>, <2.249199, -1.035252, 35.547702>, 
      <3.471575, 0.697047, 36.148178>, <3.408681, -0.045587, 36.313592>, <3.405243, -1.542720, 35.564448>, <2.291786, -1.542720, 35.564448>, 
      <3.303910, 0.447873, 36.735986>, <3.106243, -0.232955, 36.815901>, <2.821585, -1.193435, 36.811260>, <2.277469, -1.193435, 36.811260>, 
      <2.296529, 0.644456, 36.907508>, <2.296529, 0.641310, 36.907508>, <2.296579, 0.436872, 36.907508>, <2.296641, 0.436872, 36.907508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.249199, -1.035252, 35.547702>, <1.293490, -1.035252, 35.547702>, <1.182524, -0.260620, 35.733613>, <1.121344, 0.589530, 35.648178>, 
      <2.291786, -1.542720, 35.564448>, <1.178329, -1.542720, 35.564448>, <1.144103, -0.045587, 36.313592>, <1.081209, 0.697047, 36.148178>, 
      <2.277469, -1.193435, 36.811260>, <1.733354, -1.193435, 36.811260>, <1.448695, -0.232955, 36.815901>, <1.251028, 0.447873, 36.735986>, 
      <2.296641, 0.436872, 36.907508>, <2.296703, 0.436872, 36.907508>, <2.296753, 0.641310, 36.907508>, <2.296753, 0.644456, 36.907508>
    }
  }
  translate  <0.067279, 0.121081, -0.242162>
}
#declare face = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.684667, 1.195142, 2.459276>, <-1.608792, 0.959655, 2.459276>, <-1.270264, 0.219569, 2.266683>, <-1.005495, 0.156495, 2.188592>, 
      <-1.805209, 1.613715, 2.143344>, <-1.660414, 0.633465, 1.618494>, <-1.459034, 0.258983, 1.885013>, <-1.212914, 0.163737, 1.798994>, 
      <-1.902946, 1.141606, 1.498297>, <-1.890533, 0.397124, 1.321929>, <-1.505442, 0.129461, 1.669922>, <-1.223759, 0.126158, 1.662122>, 
      <-1.961934, 1.192009, 1.157168>, <-1.778604, 0.202934, 1.068984>, <-1.374972, 0.219354, 1.281694>, <-0.967859, 0.350930, 1.283298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.961934, 1.192009, 1.157168>, <-1.778604, 0.202934, 1.068984>, <-1.374972, 0.219354, 1.281694>, <-0.967859, 0.350930, 1.283298>, 
      <-2.020922, 1.242413, 0.816039>, <-1.666674, 0.008745, 0.816039>, <-1.244501, 0.309247, 0.893465>, <-0.711958, 0.575702, 0.904473>, 
      <-1.939311, 1.340997, 0.168023>, <-1.744939, -0.003141, 0.685558>, <-0.998572, 0.082237, 0.749567>, <-0.541863, 0.025064, 0.865172>, 
      <-1.857202, 1.390866, -0.180353>, <-1.525852, -0.046122, -0.028488>, <-1.020868, 0.079706, 0.276501>, <-0.604560, 0.018360, 0.333775>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.857202, 1.390866, -0.180353>, <-1.525852, -0.046122, -0.028488>, <-1.020868, 0.079706, 0.276501>, <-0.604560, 0.018360, 0.333775>, 
      <-1.775093, 1.440735, -0.528730>, <-1.306766, -0.089103, -0.742534>, <-1.043163, 0.077174, -0.196565>, <-0.667257, 0.011657, -0.197623>, 
      <-1.639102, 1.488679, -0.727919>, <-1.241734, 0.260387, -0.925276>, <-0.752436, 0.037499, -0.810632>, <-0.611385, 0.010934, -0.509098>, 
      <-1.574968, 1.524050, -0.919803>, <-1.194246, 0.295925, -1.093849>, <-0.886704, 0.076109, -0.898878>, <-0.734867, 0.050212, -0.922166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.574968, 1.524050, -0.919803>, <-1.194246, 0.295925, -1.093849>, <-0.886704, 0.076109, -0.898878>, <-0.734867, 0.050212, -0.922166>, 
      <-1.510835, 1.559422, -1.111687>, <-1.146758, 0.331463, -1.262423>, <-1.020971, 0.114718, -0.987124>, <-0.858350, 0.089490, -1.335233>, 
      <-1.400906, 1.081539, -1.443127>, <-1.112239, 0.447147, -1.637279>, <-0.822928, 0.148239, -1.605814>, <-0.679373, 0.140042, -1.581492>, 
      <-1.066273, 2.332639, -1.115046>, <-0.993964, 2.151531, -1.190106>, <-0.519607, 0.824344, -1.731861>, <-0.505818, 0.798202, -1.722089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.005495, 0.156495, 2.188592>, <-0.740726, 0.093422, 2.110500>, <-0.372217, 0.138814, 2.111787>, <-0.002411, 0.135473, 2.111787>, 
      <-1.212914, 0.163737, 1.798994>, <-0.966795, 0.068492, 1.712976>, <-0.343775, 0.034106, 1.769732>, <-0.002822, 0.030689, 1.769732>, 
      <-1.223759, 0.126158, 1.662122>, <-0.942076, 0.122855, 1.654321>, <-0.140793, 0.113626, 1.318088>, <-0.002005, 0.112235, 1.318088>, 
      <-0.967859, 0.350930, 1.283298>, <-0.560745, 0.482506, 1.284901>, <-0.146657, 0.135518, 1.056436>, <-0.000198, 0.134050, 1.056436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.967859, 0.350930, 1.283298>, <-0.560745, 0.482506, 1.284901>, <-0.146657, 0.135518, 1.056436>, <-0.000198, 0.134050, 1.056436>, 
      <-0.711958, 0.575702, 0.904473>, <-0.179415, 0.842157, 0.915482>, <-0.152522, 0.157410, 0.794784>, <0.001610, 0.155865, 0.794784>, 
      <-0.541863, 0.025064, 0.865172>, <-0.085153, -0.032110, 0.980778>, <-0.356285, -0.300860, 0.258729>, <-0.008290, -0.304348, 0.258729>, 
      <-0.604560, 0.018360, 0.333775>, <-0.188252, -0.042985, 0.391049>, <-0.330816, -0.463745, -0.061593>, <0.013507, -0.430735, -0.061593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.604560, 0.018360, 0.333775>, <-0.188252, -0.042985, 0.391049>, <-0.330816, -0.463745, -0.061593>, <0.013507, -0.430735, -0.061593>, 
      <-0.667257, 0.011657, -0.197623>, <-0.291350, -0.053860, -0.198680>, <-0.305346, -0.626630, -0.381915>, <0.035304, -0.633034, -0.381915>, 
      <-0.611385, 0.010934, -0.509098>, <-0.470333, -0.015632, -0.207565>, <-0.019893, -0.012755, -0.240011>, <0.040694, -0.016461, -0.240011>, 
      <-0.734867, 0.050212, -0.922166>, <-0.583031, 0.024315, -0.945453>, <-0.184730, 0.018872, -0.685394>, <0.030466, 0.015167, -0.685394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.734867, 0.050212, -0.922166>, <-0.583031, 0.024315, -0.945453>, <-0.184730, 0.018872, -0.685394>, <0.030466, 0.015167, -0.685394>, 
      <-0.858350, 0.089490, -1.335233>, <-0.695729, 0.064262, -1.683342>, <-0.349567, 0.050500, -1.130776>, <0.020238, 0.046794, -1.130776>, 
      <-0.679373, 0.140042, -1.581492>, <-0.535818, 0.131845, -1.557169>, <-0.283731, 0.491395, -1.683112>, <-0.006082, 0.488613, -1.683112>, 
      <-0.505818, 0.798202, -1.722089>, <-0.492029, 0.772059, -1.712318>, <-0.296763, 0.618580, -1.810557>, <-0.019114, 0.615798, -1.810557>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.002411, 0.135473, 2.111787>, <0.367394, 0.132133, 2.111787>, <0.738494, 0.078923, 2.110500>, <1.001673, 0.134861, 2.188592>, 
      <-0.002822, 0.030689, 1.769732>, <0.338132, 0.027273, 1.769732>, <0.937543, 0.049409, 1.751012>, <1.188738, 0.139671, 1.837030>, 
      <-0.002005, 0.112235, 1.318088>, <0.136784, 0.110845, 1.318088>, <0.938090, 0.104014, 1.654321>, <1.220063, 0.101669, 1.662122>, 
      <-0.000198, 0.134050, 1.056436>, <0.146262, 0.132583, 1.056436>, <0.561756, 0.471258, 1.284901>, <0.927774, 0.331934, 1.283298>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.000198, 0.134050, 1.056436>, <0.146262, 0.132583, 1.056436>, <0.561756, 0.471258, 1.284901>, <0.927774, 0.331934, 1.283298>, 
      <0.001610, 0.155865, 0.794784>, <0.155741, 0.154321, 0.794784>, <0.185421, 0.838501, 0.915482>, <0.635484, 0.562200, 0.904473>, 
      <-0.008290, -0.304348, 0.258729>, <0.339705, -0.307835, 0.258729>, <0.076946, -0.033734, 0.980778>, <0.534709, 0.014275, 0.865172>, 
      <0.013507, -0.430735, -0.061593>, <0.357829, -0.473637, -0.061593>, <0.224433, -0.047121, 0.391049>, <0.621223, 0.006077, 0.338761>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.013507, -0.430735, -0.061593>, <0.357829, -0.473637, -0.061593>, <0.224433, -0.047121, 0.391049>, <0.621223, 0.006077, 0.338761>, 
      <0.035304, -0.633034, -0.381915>, <0.375953, -0.639439, -0.381915>, <0.371921, -0.060507, -0.198680>, <0.707737, -0.002122, -0.187651>, 
      <0.040694, -0.016461, -0.240011>, <0.101280, -0.020167, -0.240011>, <0.551634, -0.025873, -0.207565>, <0.654067, 0.008462, -0.489682>, 
      <0.030466, 0.015167, -0.685394>, <0.245662, 0.011461, -0.685394>, <0.593104, 0.012529, -0.945453>, <0.748320, 0.044060, -0.915234>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.030466, 0.015167, -0.685394>, <0.245662, 0.011461, -0.685394>, <0.593104, 0.012529, -0.945453>, <0.748320, 0.044060, -0.915234>, 
      <0.020238, 0.046794, -1.130776>, <0.390043, 0.043089, -1.130776>, <0.634573, 0.050931, -1.683342>, <0.842574, 0.079658, -1.340786>, 
      <-0.006082, 0.488613, -1.683112>, <0.271566, 0.485831, -1.683112>, <0.544908, 0.126839, -1.553115>, <0.645182, 0.157484, -1.590297>, 
      <-0.019114, 0.615798, -1.810557>, <0.258535, 0.613016, -1.810557>, <0.545334, 0.761664, -1.729903>, <0.608290, 0.785124, -1.714444>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.001673, 0.134861, 2.188592>, <1.264852, 0.190799, 2.266683>, <1.518356, 0.929171, 2.459276>, <1.606692, 1.161946, 2.459276>, 
      <1.188738, 0.139671, 1.837030>, <1.439933, 0.229933, 1.923049>, <1.596421, 0.600829, 1.659519>, <1.772923, 1.576298, 2.172318>, 
      <1.220063, 0.101669, 1.662122>, <1.502036, 0.099324, 1.669922>, <1.731969, 0.360824, 1.380935>, <1.770833, 1.103777, 1.498297>, 
      <0.927774, 0.331934, 1.283298>, <1.293791, 0.192611, 1.281694>, <1.642848, 0.168649, 1.098487>, <1.835705, 1.153447, 1.157168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.927774, 0.331934, 1.283298>, <1.293791, 0.192611, 1.281694>, <1.642848, 0.168649, 1.098487>, <1.835705, 1.153447, 1.157168>, 
      <0.635484, 0.562200, 0.904473>, <1.085547, 0.285898, 0.893465>, <1.553728, -0.023526, 0.816039>, <1.900577, 1.203116, 0.816039>, 
      <0.534709, 0.014275, 0.865172>, <0.992473, 0.062285, 0.749567>, <1.623821, -0.036899, 0.685558>, <1.840648, 1.303118, 0.168023>, 
      <0.621223, 0.006077, 0.338761>, <1.018013, 0.059274, 0.286473>, <1.349237, -0.074933, -0.041912>, <1.705267, 1.356163, -0.185646>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.621223, 0.006077, 0.338761>, <1.018013, 0.059274, 0.286473>, <1.349237, -0.074933, -0.041912>, <1.705267, 1.356163, -0.185646>, 
      <0.707737, -0.002122, -0.187651>, <1.043554, 0.056264, -0.176622>, <1.074653, -0.112966, -0.769382>, <1.569886, 1.409208, -0.539316>, 
      <0.654067, 0.008462, -0.489682>, <0.756499, 0.042797, -0.771798>, <1.057056, 0.237352, -0.925276>, <1.471615, 1.457508, -0.727919>, 
      <0.748320, 0.044060, -0.915234>, <0.903537, 0.075590, -0.885015>, <1.010289, 0.273834, -1.093849>, <1.408204, 1.494157, -0.919803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.748320, 0.044060, -0.915234>, <0.903537, 0.075590, -0.885015>, <1.010289, 0.273834, -1.093849>, <1.408204, 1.494157, -0.919803>, 
      <0.842574, 0.079658, -1.340786>, <1.050575, 0.108384, -0.998231>, <0.963523, 0.310316, -1.262423>, <1.344792, 1.530806, -1.111687>, 
      <0.645182, 0.157484, -1.590297>, <0.745456, 0.188129, -1.627479>, <0.995545, 0.435541, -1.668186>, <1.230087, 1.032045, -1.477432>, 
      <0.608290, 0.785124, -1.714444>, <0.671247, 0.808583, -1.698985>, <0.980239, 2.131748, -1.190106>, <1.058824, 2.311344, -1.115046>
    }
  }
  scale <0.489474, 0.665113, 0.629144>
  rotate <5.527758, 2.218544, 0.107116>
  translate  <2.340176, -0.954974, 34.14091>
}
#declare headcsg = union {
  object { head }
  object { ear_left }
  object { // ear_right->ear_left
    ear_left
    rotate <-168.903824, 2.213111, -10.461768>
    translate  <-2.21011, -5.239862, 69.627804>
  }
  object { face }
  scale <0.875, 0.7, 0.875>
  rotate -20.0*x
  translate  <0.524547, -9.437556, -7.766752>
}
#declare torso = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.989469, 2.382820, 22.014276>, <0.989469, 2.363166, 22.001402>, <1.977129, 2.490252, 21.885656>, <2.465859, 2.490252, 21.885656>, 
      <-0.558889, 1.951491, 21.906675>, <-0.558889, 2.667759, 22.621711>, <0.947801, 3.048590, 23.164448>, <2.468992, 3.048590, 23.164448>, 
      <-0.083648, 1.741980, 21.849038>, <0.911503, 4.119071, 22.983228>, <1.527516, 1.629103, 25.100354>, <2.439169, 1.629103, 25.100354>, 
      <-0.077085, 1.154252, 23.156753>, <0.361070, 2.678057, 24.097813>, <1.450474, 1.447485, 25.226258>, <2.454644, 1.447485, 25.226258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.465859, 2.490252, 21.885656>, <2.954590, 2.490252, 21.885656>, <3.941291, 2.363166, 22.001402>, <3.941291, 2.382820, 22.014276>, 
      <2.468992, 3.048590, 23.164448>, <3.990184, 3.048590, 23.164448>, <5.495479, 2.667759, 22.621711>, <5.495479, 1.951491, 21.906675>, 
      <2.439169, 1.629103, 25.100354>, <3.350822, 1.629103, 25.100354>, <3.688747, 4.119071, 22.983228>, <4.810530, 1.741980, 21.849038>, 
      <2.454644, 1.447485, 25.226258>, <3.458814, 1.447485, 25.226258>, <4.409131, 2.678057, 24.097813>, <4.910632, 1.154252, 23.156753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.941291, 2.382820, 22.014276>, <3.941291, 2.402475, 22.027149>, <2.954590, 2.506369, 21.896213>, <2.465859, 2.506369, 21.896213>, 
      <5.495479, 1.951491, 21.906675>, <5.495479, 1.235223, 21.191639>, <2.991781, 0.774149, 21.569084>, <2.468034, 0.774149, 21.569084>, 
      <4.810530, 1.741980, 21.849038>, <5.932312, -0.635111, 20.714848>, <2.984751, 0.950261, 22.267946>, <2.468992, 0.950261, 22.267946>, 
      <4.910632, 1.154252, 23.156753>, <5.412132, -0.239475, 22.215692>, <3.328962, 0.733576, 23.186725>, <2.469937, 0.733576, 23.186725>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.465859, 2.506369, 21.896213>, <1.977129, 2.506369, 21.896213>, <0.989469, 2.402475, 22.027149>, <0.989469, 2.382820, 22.014276>, 
      <2.468034, 0.774149, 21.569084>, <1.944287, 0.774149, 21.569084>, <-0.558889, 1.235223, 21.191639>, <-0.558889, 1.951491, 21.906675>, 
      <2.468992, 0.950261, 22.267946>, <1.953234, 0.950261, 22.267946>, <-1.078800, -0.635111, 20.714848>, <-0.083648, 1.741980, 21.849038>, 
      <2.469937, 0.733576, 23.186725>, <1.610911, 0.733576, 23.186725>, <-0.515241, -0.239475, 22.215692>, <-0.077085, 1.154252, 23.156753>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.077085, 1.154252, 23.156753>, <0.361070, 2.678057, 24.097813>, <1.450474, 1.447485, 25.226258>, <2.454644, 1.447485, 25.226258>, 
      <-0.070522, 0.696601, 24.464467>, <-0.189362, 1.237043, 25.212399>, <1.373432, 1.265867, 25.352162>, <2.470119, 1.265867, 25.352162>, 
      <0.379696, 0.414646, 25.267694>, <0.083557, 1.084818, 25.355302>, <0.444186, 1.190884, 27.091112>, <2.469778, 1.190884, 27.091112>, 
      <0.089562, 0.276065, 26.644490>, <-0.460772, 1.117186, 26.898831>, <0.444186, 1.223233, 27.703192>, <2.469778, 1.223233, 27.703192>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.454644, 1.447485, 25.226258>, <3.458814, 1.447485, 25.226258>, <4.409131, 2.678057, 24.097813>, <4.910632, 1.154252, 23.156753>, 
      <2.470119, 1.265867, 25.352162>, <3.566807, 1.265867, 25.352162>, <5.129515, 1.237043, 25.212399>, <5.010733, 0.696601, 24.464467>, 
      <2.469778, 1.190884, 27.091112>, <4.495370, 1.190884, 27.091112>, <4.855641, 1.084818, 25.355302>, <4.559454, 0.414646, 25.267694>, 
      <2.469778, 1.223233, 27.703192>, <4.495370, 1.223233, 27.703192>, <5.400149, 1.117186, 26.898831>, <4.849791, 0.276065, 26.644490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.910632, 1.154252, 23.156753>, <5.412132, -0.239475, 22.215692>, <3.328962, 0.733576, 23.186725>, <2.469937, 0.733576, 23.186725>, 
      <5.010733, 0.696601, 24.464467>, <4.891952, 0.156160, 23.716535>, <3.673174, 0.516890, 24.105503>, <2.470881, 0.516890, 24.105503>, 
      <4.559454, 0.414646, 25.267694>, <4.263267, -0.255526, 25.180086>, <4.274660, -0.510324, 25.452736>, <2.469551, -0.510324, 25.452736>, 
      <4.849791, 0.276065, 26.644490>, <4.299432, -0.565057, 26.390150>, <4.124187, -0.736862, 26.575018>, <2.469664, -0.736862, 26.575018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.469937, 0.733576, 23.186725>, <1.610911, 0.733576, 23.186725>, <-0.515241, -0.239475, 22.215692>, <-0.077085, 1.154252, 23.156753>, 
      <2.470881, 0.516890, 24.105503>, <1.268588, 0.516890, 24.105503>, <0.048319, 0.156160, 23.716535>, <-0.070522, 0.696601, 24.464467>, 
      <2.469551, -0.510324, 25.452736>, <0.664442, -0.510324, 25.452736>, <0.675834, -0.255526, 25.180086>, <0.379696, 0.414646, 25.267694>, 
      <2.469664, -0.736862, 26.575018>, <0.815142, -0.736862, 26.575018>, <0.639897, -0.565057, 26.390150>, <0.089562, 0.276065, 26.644490>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.089562, 0.276065, 26.644490>, <-0.460772, 1.117186, 26.898831>, <0.444186, 1.223233, 27.703192>, <2.469778, 1.223233, 27.703192>, 
      <-0.200571, 0.137483, 28.021287>, <-1.005101, 1.149554, 28.442360>, <0.444186, 1.255581, 28.315272>, <2.469778, 1.255581, 28.315272>, 
      <-0.134699, 0.215818, 28.679122>, <-0.873356, 1.004623, 28.819824>, <0.444186, 1.673545, 29.162143>, <2.469778, 1.673545, 29.162143>, 
      <-0.533290, 0.642693, 29.370094>, <-0.864632, 1.140674, 29.072960>, <0.444186, 1.385045, 29.922505>, <2.469778, 1.385045, 29.922505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.469778, 1.223233, 27.703192>, <4.495370, 1.223233, 27.703192>, <5.400149, 1.117186, 26.898831>, <4.849791, 0.276065, 26.644490>, 
      <2.469778, 1.255581, 28.315272>, <4.495370, 1.255581, 28.315272>, <5.944657, 1.149554, 28.442360>, <5.140127, 0.137483, 28.021287>, 
      <2.469778, 1.673545, 29.162143>, <4.495370, 1.673545, 29.162143>, <5.812026, 1.004623, 28.819824>, <5.073812, 0.215818, 28.679122>, 
      <2.469778, 1.385045, 29.922505>, <4.495370, 1.385045, 29.922505>, <5.765535, 0.753364, 29.072960>, <5.358440, 0.449039, 29.370094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.849791, 0.276065, 26.644490>, <4.299432, -0.565057, 26.390150>, <4.124187, -0.736862, 26.575018>, <2.469664, -0.736862, 26.575018>, 
      <5.140127, 0.137483, 28.021287>, <4.335597, -0.874588, 27.600213>, <3.973715, -0.963401, 27.697300>, <2.469778, -0.963401, 27.697300>, 
      <5.073812, 0.215818, 28.679122>, <4.335597, -0.572986, 28.538420>, <4.710026, -0.440240, 29.316601>, <2.469778, -0.440240, 29.316601>, 
      <5.358440, 0.449039, 29.370094>, <4.951345, 0.144713, 29.667227>, <4.076556, -0.268021, 29.627737>, <2.422229, -0.268021, 29.627737>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.469664, -0.736862, 26.575018>, <0.815142, -0.736862, 26.575018>, <0.639897, -0.565057, 26.390150>, <0.089562, 0.276065, 26.644490>, 
      <2.469778, -0.963401, 27.697300>, <0.965841, -0.963401, 27.697300>, <0.603959, -0.874588, 27.600213>, <-0.200571, 0.137483, 28.021287>, 
      <2.469778, -0.440240, 29.316601>, <0.229530, -0.440240, 29.316601>, <0.603959, -0.572986, 28.538420>, <-0.134699, 0.215818, 28.679122>, 
      <2.422229, -0.268021, 29.627737>, <0.767902, -0.268021, 29.627737>, <-0.201949, 0.144713, 29.667227>, <-0.533290, 0.642693, 29.370094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.533290, 0.642693, 29.370094>, <-0.864632, 1.140674, 29.072960>, <0.444186, 1.385045, 29.922505>, <2.469778, 1.385045, 29.922505>, 
      <-0.931882, 1.069569, 30.061065>, <-0.855907, 1.276725, 29.326097>, <0.444186, 1.096546, 30.682867>, <2.469778, 1.096546, 30.682867>, 
      <2.204805, 0.828707, 30.413585>, <2.131747, 1.342344, 30.180068>, <2.282301, 1.325931, 30.628829>, <2.442423, 1.331468, 30.623316>, 
      <1.901380, 0.873445, 30.918030>, <1.823723, 1.068380, 30.956546>, <2.083314, 1.379985, 30.774510>, <2.400591, 1.379985, 30.774510>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.469778, 1.385045, 29.922505>, <4.495370, 1.385045, 29.922505>, <5.765535, 0.753364, 29.072960>, <5.358440, 0.449039, 29.370094>, 
      <2.469778, 1.096546, 30.682867>, <4.495370, 1.096546, 30.682867>, <5.719044, 0.502106, 29.326097>, <5.643069, 0.682259, 30.061065>, 
      <2.442423, 1.331468, 30.623316>, <2.602544, 1.337005, 30.617803>, <2.855916, 1.359808, 30.153403>, <2.905149, 0.846172, 30.395109>, 
      <2.400591, 1.379985, 30.774510>, <2.717868, 1.379985, 30.774510>, <2.977458, 1.068380, 30.956546>, <2.899580, 0.873445, 30.918030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.358440, 0.449039, 29.370094>, <4.951345, 0.144713, 29.667227>, <4.076556, -0.268021, 29.627737>, <2.422229, -0.268021, 29.627737>, 
      <5.643069, 0.682259, 30.061065>, <5.567094, 0.862413, 30.796034>, <3.443086, -0.095801, 29.938873>, <2.374680, -0.095801, 29.938873>, 
      <2.905149, 0.846172, 30.395109>, <2.954383, 0.332536, 30.636815>, <2.678852, 0.228396, 29.949249>, <2.457639, 0.225348, 29.956209>, 
      <2.899580, 0.873445, 30.918030>, <2.821701, 0.678509, 30.879515>, <2.632102, 0.682494, 31.186098>, <2.400369, 0.682494, 31.186098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.422229, -0.268021, 29.627737>, <0.767902, -0.268021, 29.627737>, <-0.201949, 0.144713, 29.667227>, <-0.533290, 0.642693, 29.370094>, 
      <2.374680, -0.095801, 29.938873>, <1.306273, -0.095801, 29.938873>, <-1.007857, 0.862413, 30.796034>, <-0.931882, 1.069569, 30.061065>, 
      <2.457639, 0.225348, 29.956209>, <2.236427, 0.222299, 29.963168>, <2.277864, 0.315071, 30.647101>, <2.204805, 0.828707, 30.413585>, 
      <2.400369, 0.682494, 31.186098>, <2.168637, 0.682494, 31.186098>, <1.979037, 0.678509, 30.879515>, <1.901380, 0.873445, 30.918030>
    }
  }
  translate  <0.354218, 0.01552, -0.736536>
}
#declare armleft = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.062929, 4.012445, 30.292883>, <-10.062929, 4.024529, 30.315068>, <-10.063359, 3.949398, 30.185817>, <-10.063358, 3.937314, 30.163632>, 
      <-11.980367, 4.077150, 30.212755>, <-11.976632, 5.791650, 29.245360>, <-9.989956, 5.716520, 29.116110>, <-9.993691, 4.002019, 30.083505>, 
      <-12.208274, 3.359403, 28.847616>, <-12.204539, 4.330190, 28.312527>, <-10.217863, 4.255059, 28.183276>, <-10.221598, 3.284272, 28.718365>, 
      <-12.310387, 2.641656, 27.482477>, <-12.307125, 3.604853, 26.951800>, <-10.572037, 3.529722, 26.822549>, <-10.575299, 2.566525, 27.353226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.063358, 3.937314, 30.163632>, <-10.063357, 3.925229, 30.141448>, <-10.062928, 4.000360, 30.270698>, <-10.062929, 4.012445, 30.292883>, 
      <-9.993691, 4.002019, 30.083505>, <-9.997426, 2.287518, 31.050900>, <-11.984102, 2.362649, 31.180151>, <-11.980367, 4.077150, 30.212755>, 
      <-10.221598, 3.284272, 28.718365>, <-10.225333, 2.313486, 29.253455>, <-12.212009, 2.388616, 29.382706>, <-12.208274, 3.359403, 28.847616>, 
      <-10.575299, 2.566525, 27.353226>, <-10.578561, 1.603329, 27.883904>, <-12.313649, 1.678460, 28.013154>, <-12.310387, 2.641656, 27.482477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.310387, 2.641656, 27.482477>, <-12.307125, 3.604853, 26.951800>, <-10.572037, 3.529722, 26.822549>, <-10.575299, 2.566525, 27.353226>, 
      <-12.412501, 1.923910, 26.117338>, <-12.409712, 2.879515, 25.591073>, <-10.926211, 2.804385, 25.461822>, <-10.929000, 1.848779, 25.988087>, 
      <-12.595150, 1.629407, 25.451471>, <-12.592531, 2.500032, 24.974604>, <-11.199546, 2.424901, 24.845353>, <-11.202165, 1.554276, 25.322220>, 
      <-12.749319, 1.409457, 24.979654>, <-12.657398, 2.207410, 24.810585>, <-11.040036, 2.190498, 24.681604>, <-11.131956, 1.516817, 25.015366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.575299, 2.566525, 27.353226>, <-10.578561, 1.603329, 27.883904>, <-12.313649, 1.678460, 28.013154>, <-12.310387, 2.641656, 27.482477>, 
      <-10.929000, 1.848779, 25.988087>, <-10.931789, 0.893173, 26.514352>, <-12.415290, 0.968304, 26.643603>, <-12.412501, 1.923910, 26.117338>, 
      <-11.202165, 1.554276, 25.322220>, <-11.204784, 0.683651, 25.799088>, <-12.597768, 0.758782, 25.928339>, <-12.595150, 1.629407, 25.451471>, 
      <-11.131956, 1.516817, 25.015366>, <-11.223877, 0.843135, 25.349127>, <-12.841240, 0.611504, 25.148724>, <-12.749319, 1.409457, 24.979654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.749319, 1.409457, 24.979654>, <-12.657398, 2.207410, 24.810585>, <-11.040036, 2.190498, 24.681604>, <-11.131956, 1.516817, 25.015366>, 
      <-12.903488, 1.189508, 24.507837>, <-12.722265, 1.914789, 24.646566>, <-10.880525, 1.956095, 24.517855>, <-11.061748, 1.479357, 24.708511>, 
      <-12.864075, 1.027613, 23.991705>, <-12.860857, 2.113415, 23.504789>, <-11.149380, 2.055748, 23.382530>, <-11.152597, 0.969945, 23.869447>, 
      <-12.791375, 0.564763, 22.856872>, <-12.788791, 1.564509, 22.410548>, <-11.414624, 1.397753, 22.339746>, <-11.417207, 0.512080, 22.732263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.131956, 1.516817, 25.015366>, <-11.223877, 0.843135, 25.349127>, <-12.841240, 0.611504, 25.148724>, <-12.749319, 1.409457, 24.979654>, 
      <-11.061748, 1.479357, 24.708511>, <-11.242971, 1.002620, 24.899167>, <-13.084711, 0.464226, 24.369109>, <-12.903488, 1.189508, 24.507837>, 
      <-11.152597, 0.969945, 23.869447>, <-11.155815, -0.115858, 24.356363>, <-12.867292, -0.058190, 24.478621>, <-12.864075, 1.027613, 23.991705>, 
      <-11.417207, 0.512080, 22.732263>, <-11.419791, -0.373593, 23.124780>, <-12.793958, -0.434984, 23.303197>, <-12.791375, 0.564763, 22.856872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.791375, 0.564763, 22.856872>, <-12.788791, 1.564509, 22.410548>, <-11.414624, 1.397753, 22.339746>, <-11.417207, 0.512080, 22.732263>, 
      <-12.718674, 0.101913, 21.722040>, <-12.716725, 1.015603, 21.316307>, <-11.679868, 0.739758, 21.296961>, <-11.681817, 0.054215, 21.595079>, 
      <-12.685075, 0.014035, 21.395083>, <-12.683443, 0.699578, 21.096965>, <-11.814937, 0.641910, 20.974707>, <-11.816570, -0.043633, 21.272825>, 
      <-12.649915, -0.516120, 20.104641>, <-12.648858, 0.039263, 19.867919>, <-12.086731, -0.018405, 19.745661>, <-12.087788, -0.573787, 19.982383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.417207, 0.512080, 22.732263>, <-11.419791, -0.373593, 23.124780>, <-12.793958, -0.434984, 23.303197>, <-12.791375, 0.564763, 22.856872>, 
      <-11.681817, 0.054215, 21.595079>, <-11.683766, -0.631327, 21.893196>, <-12.720624, -0.811777, 22.127772>, <-12.718674, 0.101913, 21.722040>, 
      <-11.816570, -0.043633, 21.272825>, <-11.818203, -0.729175, 21.570942>, <-12.686708, -0.671507, 21.693201>, <-12.685075, 0.014035, 21.395083>, 
      <-12.087788, -0.573787, 19.982383>, <-12.088845, -1.129170, 20.219106>, <-12.650972, -1.071502, 20.341364>, <-12.649915, -0.516120, 20.104641>
    }
  }
  texture {
    darktan2
  }
  scale -1.0
  rotate -180.0*x
  translate  <-5.055885, 1.782213, 0.296837>
}
#declare thumbleft = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.754691, -0.796860, 18.003109>, <-2.755504, -0.795169, 18.002817>, <-2.753898, -0.794284, 18.002665>, <-2.753085, -0.795975, 18.002956>, 
      <-2.610226, -0.497728, 17.864273>, <-2.821391, -0.243154, 17.779336>, <-3.151856, -0.425333, 17.810758>, <-3.075615, -0.754287, 17.908523>, 
      <-2.582770, -0.700667, 18.684401>, <-2.703868, -0.455457, 18.642109>, <-2.963177, -0.598409, 18.666764>, <-2.842079, -0.843618, 18.709057>, 
      <-2.669969, -0.122757, 19.604566>, <-2.798097, 0.039863, 19.096297>, <-3.210579, -0.187530, 19.135517>, <-3.082451, -0.350150, 19.643785>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.753085, -0.795975, 18.002956>, <-2.752271, -0.797666, 18.003248>, <-2.753877, -0.798551, 18.003401>, <-2.754691, -0.796860, 18.003109>, 
      <-3.075615, -0.754287, 17.908523>, <-2.999374, -1.083241, 18.006287>, <-2.399061, -0.752301, 17.949209>, <-2.610226, -0.497728, 17.864273>, 
      <-2.842079, -0.843618, 18.709057>, <-2.720981, -1.088828, 18.751349>, <-2.461673, -0.945877, 18.726693>, <-2.582770, -0.700667, 18.684401>, 
      <-3.082451, -0.350150, 19.643785>, <-2.954323, -0.512770, 20.152054>, <-2.541841, -0.285377, 20.112835>, <-2.669969, -0.122757, 19.604566>
    }
  }
  texture {
    darktan2
  }
  rotate <4.784626, -10.325432, 7.905827>
  translate  <3.360143, 2.972645, -0.43797>
}
#declare indexf = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.887823, -1.021958, 19.249804>, <-1.887194, -1.019952, 19.249052>, <-1.884704, -1.020351, 19.250070>, <-1.885332, -1.022356, 19.250823>, 
      <-1.445884, -1.055183, 18.979924>, <-1.364723, -0.613338, 18.881779>, <-1.792379, -0.665425, 18.856058>, <-2.077906, -0.896198, 18.936772>, 
      <-2.120939, -1.263242, 20.409205>, <-2.056834, -1.069772, 20.154994>, <-2.270391, -0.918627, 20.250386>, <-2.334496, -1.112096, 20.504597>, 
      <-1.106457, -0.135537, 20.238937>, <-1.075090, 0.053339, 20.042784>, <-1.433940, 0.266716, 20.190861>, <-1.465307, 0.077840, 20.387014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.885332, -1.022356, 19.250823>, <-1.885961, -1.024361, 19.251575>, <-1.888451, -1.023963, 19.250557>, <-1.887823, -1.021958, 19.249804>, 
      <-2.077906, -0.896198, 18.936772>, <-2.363433, -1.126971, 19.017486>, <-1.527044, -1.497029, 19.078069>, <-1.445884, -1.055183, 18.979924>, 
      <-2.334496, -1.112096, 20.504597>, <-2.398601, -1.305566, 20.758808>, <-2.185043, -1.456711, 20.663416>, <-2.120939, -1.263242, 20.409205>, 
      <-1.465307, 0.077840, 20.387014>, <-1.496675, -0.111036, 20.583166>, <-1.137825, -0.324413, 20.435089>, <-1.106457, -0.135537, 20.238937>
    }
  }
  texture {
    darktan2
  }
  rotate <71.745613, -23.796843, -88.134033>
  translate  <16.550574, -2.737086, 12.043377>
}
#declare palmleft = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.682305, -4.310634, 19.712248>, <-3.654979, -5.037325, 19.709148>, <-3.615571, -5.037325, 19.709148>, <-3.642897, -4.310634, 19.712248>, 
      <-4.260433, -4.259280, 19.120530>, <-4.260433, -5.273803, 18.539423>, <-3.247520, -5.508326, 20.742897>, <-3.150430, -4.553044, 20.770705>, 
      <-4.157979, -4.212679, 21.898800>, <-4.157979, -5.058814, 22.004479>, <-3.562875, -7.241668, 21.839585>, <-3.465785, -5.348502, 21.401466>, 
      <-4.088376, -4.243723, 21.930958>, <-4.088376, -4.772166, 22.184432>, <-3.291147, -4.812319, 22.018034>, <-3.291147, -4.283876, 21.764561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.642897, -4.310634, 19.712248>, <-3.670222, -3.583942, 19.715347>, <-3.709630, -3.583942, 19.715347>, <-3.682305, -4.310634, 19.712248>, 
      <-3.150430, -4.553044, 20.770705>, <-3.053341, -3.597762, 20.798513>, <-4.260433, -3.244757, 19.701637>, <-4.260433, -4.259280, 19.120530>, 
      <-3.465785, -5.348502, 21.401466>, <-3.368696, -3.455336, 20.963347>, <-4.157979, -3.366543, 21.793121>, <-4.157979, -4.212679, 21.898800>, 
      <-3.291147, -4.283876, 21.764561>, <-3.291147, -3.755434, 21.511087>, <-4.088376, -3.715281, 21.677485>, <-4.088376, -4.243723, 21.930958>
    }
  }
  texture {
    darktan2
  }
  rotate 0.196922*y
  translate  <0.681159, 5.229327, -2.507844>
}
#declare middlef = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.901481, -1.368572, 19.309602>, <-1.900764, -1.366285, 19.308744>, <-1.897924, -1.366740, 19.309906>, <-1.898641, -1.369027, 19.310764>, 
      <-1.397507, -1.406461, 19.001839>, <-1.304955, -0.902594, 18.889918>, <-1.792641, -0.961993, 18.860587>, <-2.118247, -1.225160, 18.952630>, 
      <-2.167320, -1.327763, 20.502490>, <-2.094216, -1.107136, 20.212596>, <-2.337751, -0.934774, 20.321378>, <-2.410854, -1.155401, 20.611273>, 
      <-1.010436, -0.041763, 20.308322>, <-0.974665, 0.173626, 20.084635>, <-1.383887, 0.416955, 20.253498>, <-1.419658, 0.201567, 20.477184>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.898641, -1.369027, 19.310764>, <-1.899358, -1.371313, 19.311622>, <-1.902198, -1.370859, 19.310460>, <-1.901481, -1.368572, 19.309602>, 
      <-2.118247, -1.225160, 18.952630>, <-2.443853, -1.488326, 19.044674>, <-1.490060, -1.910329, 19.113761>, <-1.397507, -1.406461, 19.001839>, 
      <-2.410854, -1.155401, 20.611273>, <-2.483957, -1.376028, 20.901167>, <-2.240423, -1.548390, 20.792385>, <-2.167320, -1.327763, 20.502490>, 
      <-1.419658, 0.201567, 20.477184>, <-1.455428, -0.013822, 20.700871>, <-1.046206, -0.257151, 20.532008>, <-1.010436, -0.041763, 20.308322>
    }
  }
  texture {
    darktan2
  }
  scale 0.9
  rotate <71.745613, -23.796843, -88.134033>
  translate  <14.579481, -1.991857, 12.199079>
}
#declare indexf1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.404287, -1.255673, 19.716582>, <-2.403658, -1.253668, 19.715830>, <-2.401168, -1.254067, 19.716848>, <-2.401796, -1.256072, 19.717601>, 
      <-1.962348, -1.288899, 19.446702>, <-1.881187, -0.847053, 19.348557>, <-2.308843, -0.899141, 19.322836>, <-2.594370, -1.129914, 19.403550>, 
      <-2.120939, -1.263242, 20.409205>, <-2.056834, -1.069772, 20.154994>, <-2.270391, -0.918627, 20.250386>, <-2.334496, -1.112096, 20.504597>, 
      <-1.106457, -0.135537, 20.238937>, <-1.075090, 0.053339, 20.042784>, <-1.433940, 0.266716, 20.190861>, <-1.465307, 0.077840, 20.387014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.401796, -1.256072, 19.717601>, <-2.402425, -1.258077, 19.718353>, <-2.404915, -1.257678, 19.717334>, <-2.404287, -1.255673, 19.716582>, 
      <-2.594370, -1.129914, 19.403550>, <-2.879897, -1.360686, 19.484264>, <-2.043508, -1.730744, 19.544847>, <-1.962348, -1.288899, 19.446702>, 
      <-2.334496, -1.112096, 20.504597>, <-2.398601, -1.305566, 20.758808>, <-2.185043, -1.456711, 20.663416>, <-2.120939, -1.263242, 20.409205>, 
      <-1.465307, 0.077840, 20.387014>, <-1.496675, -0.111036, 20.583166>, <-1.137825, -0.324413, 20.435089>, <-1.106457, -0.135537, 20.238937>
    }
  }
  texture {
    darktan2
  }
  scale 0.9
  rotate <71.745613, -23.796843, -88.134033>
  translate  <14.438515, -1.664299, 12.216115>
}
#declare thumbleft1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.882781, -0.689637, 18.214769>, <-2.882148, -0.688672, 18.214589>, <-2.881172, -0.689238, 18.214496>, <-2.881805, -0.690202, 18.214675>, 
      <-2.679408, -0.670948, 18.129413>, <-2.612212, -0.479025, 18.077194>, <-2.812914, -0.362661, 18.096512>, <-2.962055, -0.507074, 18.156617>, 
      <-2.777621, -0.749724, 18.633624>, <-2.686815, -0.608219, 18.607623>, <-2.844301, -0.516910, 18.622781>, <-2.935108, -0.658416, 18.648783>, 
      <-2.500797, -0.520643, 19.199338>, <-2.455729, -0.401607, 18.886857>, <-2.706243, -0.256363, 18.910968>, <-2.751311, -0.375399, 19.223450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.881805, -0.690202, 18.214675>, <-2.882438, -0.691166, 18.214854>, <-2.883413, -0.690601, 18.214948>, <-2.882781, -0.689637, 18.214769>, 
      <-2.962055, -0.507074, 18.156617>, <-3.111195, -0.651487, 18.216723>, <-2.746605, -0.862870, 18.181631>, <-2.679408, -0.670948, 18.129413>, 
      <-2.935108, -0.658416, 18.648783>, <-3.025914, -0.799922, 18.674784>, <-2.868427, -0.891230, 18.659626>, <-2.777621, -0.749724, 18.633624>, 
      <-2.751311, -0.375399, 19.223450>, <-2.796379, -0.494435, 19.535932>, <-2.545865, -0.639679, 19.511820>, <-2.500797, -0.520643, 19.199338>
    }
  }
  texture {
    darktan2
  }
  scale 0.9
  rotate <24.297575, 1.782109, -52.462303>
  translate  <4.212042, 4.478822, 1.173023>
}
#declare handleftcsg = union {
  object { thumbleft }
  object { indexf }
  object { palmleft }
  object { middlef }
  object { indexf1 }
  object { thumbleft1 }
  scale -1.0
  rotate <159.944473, -1.263285, -54.615574>
  translate  <-0.350814, -0.876935, 2.89829>
}
#declare armleftcsg = union {
  object { armleft }
  object { handleftcsg }
  scale <0.6, 0.714071, 0.6>
  rotate <11.99372, 35.0, 40.0>
  translate  <-4.768291, -8.277699, 15.967855>
}
#declare armleft1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.062929, 4.012445, 30.292883>, <-10.062929, 4.024529, 30.315068>, <-10.063359, 3.949398, 30.185817>, <-10.063358, 3.937314, 30.163632>, 
      <-11.980367, 4.077150, 30.212755>, <-11.976632, 5.791650, 29.245360>, <-9.989956, 5.716520, 29.116110>, <-9.993691, 4.002019, 30.083505>, 
      <-12.208274, 3.359403, 28.847616>, <-12.204539, 4.330190, 28.312527>, <-10.217863, 4.255059, 28.183276>, <-10.221598, 3.284272, 28.718365>, 
      <-12.310387, 2.641656, 27.482477>, <-12.307125, 3.604853, 26.951800>, <-10.572037, 3.529722, 26.822549>, <-10.575299, 2.566525, 27.353226>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.063358, 3.937314, 30.163632>, <-10.063357, 3.925229, 30.141448>, <-10.062928, 4.000360, 30.270698>, <-10.062929, 4.012445, 30.292883>, 
      <-9.993691, 4.002019, 30.083505>, <-9.997426, 2.287518, 31.050900>, <-11.984102, 2.362649, 31.180151>, <-11.980367, 4.077150, 30.212755>, 
      <-10.221598, 3.284272, 28.718365>, <-10.225333, 2.313486, 29.253455>, <-12.212009, 2.388616, 29.382706>, <-12.208274, 3.359403, 28.847616>, 
      <-10.575299, 2.566525, 27.353226>, <-10.578561, 1.603329, 27.883904>, <-12.313649, 1.678460, 28.013154>, <-12.310387, 2.641656, 27.482477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.310387, 2.641656, 27.482477>, <-12.307125, 3.604853, 26.951800>, <-10.572037, 3.529722, 26.822549>, <-10.575299, 2.566525, 27.353226>, 
      <-12.412501, 1.923910, 26.117338>, <-12.409712, 2.879515, 25.591073>, <-10.926211, 2.804385, 25.461822>, <-10.929000, 1.848779, 25.988087>, 
      <-12.595150, 1.629407, 25.451471>, <-12.592531, 2.500032, 24.974604>, <-11.199546, 2.424901, 24.845353>, <-11.202165, 1.554276, 25.322220>, 
      <-12.749319, 1.409457, 24.979654>, <-12.657398, 2.207410, 24.810585>, <-11.040036, 2.190498, 24.681604>, <-11.131956, 1.516817, 25.015366>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-10.575299, 2.566525, 27.353226>, <-10.578561, 1.603329, 27.883904>, <-12.313649, 1.678460, 28.013154>, <-12.310387, 2.641656, 27.482477>, 
      <-10.929000, 1.848779, 25.988087>, <-10.931789, 0.893173, 26.514352>, <-12.415290, 0.968304, 26.643603>, <-12.412501, 1.923910, 26.117338>, 
      <-11.202165, 1.554276, 25.322220>, <-11.204784, 0.683651, 25.799088>, <-12.597768, 0.758782, 25.928339>, <-12.595150, 1.629407, 25.451471>, 
      <-11.131956, 1.516817, 25.015366>, <-11.223877, 0.843135, 25.349127>, <-12.841240, 0.611504, 25.148724>, <-12.749319, 1.409457, 24.979654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.749319, 1.409457, 24.979654>, <-12.657398, 2.207410, 24.810585>, <-11.040036, 2.190498, 24.681604>, <-11.131956, 1.516817, 25.015366>, 
      <-12.903488, 1.189508, 24.507837>, <-12.722265, 1.914789, 24.646566>, <-10.880525, 1.956095, 24.517855>, <-11.061748, 1.479357, 24.708511>, 
      <-12.864075, 1.027613, 23.991705>, <-12.860857, 2.113415, 23.504789>, <-11.149380, 2.055748, 23.382530>, <-11.152597, 0.969945, 23.869447>, 
      <-12.791375, 0.564763, 22.856872>, <-12.788791, 1.564509, 22.410548>, <-11.414624, 1.397753, 22.339746>, <-11.417207, 0.512080, 22.732263>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.131956, 1.516817, 25.015366>, <-11.223877, 0.843135, 25.349127>, <-12.841240, 0.611504, 25.148724>, <-12.749319, 1.409457, 24.979654>, 
      <-11.061748, 1.479357, 24.708511>, <-11.242971, 1.002620, 24.899167>, <-13.084711, 0.464226, 24.369109>, <-12.903488, 1.189508, 24.507837>, 
      <-11.152597, 0.969945, 23.869447>, <-11.155815, -0.115858, 24.356363>, <-12.867292, -0.058190, 24.478621>, <-12.864075, 1.027613, 23.991705>, 
      <-11.417207, 0.512080, 22.732263>, <-11.419791, -0.373593, 23.124780>, <-12.793958, -0.434984, 23.303197>, <-12.791375, 0.564763, 22.856872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-12.791375, 0.564763, 22.856872>, <-12.788791, 1.564509, 22.410548>, <-11.414624, 1.397753, 22.339746>, <-11.417207, 0.512080, 22.732263>, 
      <-12.718674, 0.101913, 21.722040>, <-12.716725, 1.015603, 21.316307>, <-11.679868, 0.739758, 21.296961>, <-11.681817, 0.054215, 21.595079>, 
      <-12.685075, 0.014035, 21.395083>, <-12.683443, 0.699578, 21.096965>, <-11.814937, 0.641910, 20.974707>, <-11.816570, -0.043633, 21.272825>, 
      <-12.649915, -0.516120, 20.104641>, <-12.648858, 0.039263, 19.867919>, <-12.086731, -0.018405, 19.745661>, <-12.087788, -0.573787, 19.982383>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-11.417207, 0.512080, 22.732263>, <-11.419791, -0.373593, 23.124780>, <-12.793958, -0.434984, 23.303197>, <-12.791375, 0.564763, 22.856872>, 
      <-11.681817, 0.054215, 21.595079>, <-11.683766, -0.631327, 21.893196>, <-12.720624, -0.811777, 22.127772>, <-12.718674, 0.101913, 21.722040>, 
      <-11.816570, -0.043633, 21.272825>, <-11.818203, -0.729175, 21.570942>, <-12.686708, -0.671507, 21.693201>, <-12.685075, 0.014035, 21.395083>, 
      <-12.087788, -0.573787, 19.982383>, <-12.088845, -1.129170, 20.219106>, <-12.650972, -1.071502, 20.341364>, <-12.649915, -0.516120, 20.104641>
    }
  }
  texture {
    darktan2
  }
  scale -1.0
  rotate -180.0*x
  translate  <-5.055885, 1.782213, 0.296837>
}
#declare finger11 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.754691, -0.700717, 17.978962>, <-2.755504, -0.699002, 17.978962>, <-2.753898, -0.698103, 17.978962>, <-2.753085, -0.699819, 17.978962>, 
      <-2.610226, -0.382340, 17.892988>, <-2.821391, -0.117034, 17.852557>, <-3.151856, -0.301903, 17.852557>, <-3.075615, -0.642687, 17.892988>, 
      <-2.582770, -0.721719, 18.666691>, <-2.703868, -0.472889, 18.666691>, <-2.963177, -0.617951, 18.666691>, <-2.842079, -0.866781, 18.666691>, 
      <-2.669969, -0.308614, 19.671692>, <-2.798097, -0.061972, 19.198458>, <-3.210579, -0.292723, 19.198458>, <-3.082451, -0.539364, 19.671692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.753085, -0.699819, 17.978962>, <-2.752271, -0.701535, 17.978962>, <-2.753877, -0.702433, 17.978962>, <-2.754691, -0.700717, 17.978962>, 
      <-3.075615, -0.642687, 17.892988>, <-2.999374, -0.983472, 17.933420>, <-2.399061, -0.647645, 17.933420>, <-2.610226, -0.382340, 17.892988>, 
      <-2.842079, -0.866781, 18.666691>, <-2.720981, -1.115612, 18.666691>, <-2.461673, -0.970549, 18.666691>, <-2.582770, -0.721719, 18.666691>, 
      <-3.082451, -0.539364, 19.671692>, <-2.954323, -0.786006, 20.144926>, <-2.541841, -0.555256, 20.144926>, <-2.669969, -0.308614, 19.671692>
    }
  }
  texture {
    darktan2
  }
  rotate <2.987594, -10.271558, 12.253675>
  translate  <3.163114, 2.760434, 0.0342>
}
#declare finger12 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.722626, -0.208343, 19.335560>, <-1.721560, -0.208706, 19.337487>, <-1.719642, -0.210109, 19.336162>, <-1.720709, -0.209745, 19.334235>, 
      <-1.220590, -0.281023, 19.326967>, <-1.062679, -0.205846, 19.710405>, <-1.457234, 0.082749, 19.983136>, <-1.776236, 0.125400, 19.711051>, 
      <-2.474584, -1.804119, 19.302543>, <-2.304922, -1.365859, 19.206308>, <-2.520572, -1.221661, 19.307568>, <-2.690234, -1.659921, 19.403803>, 
      <-1.348480, -0.795506, 20.567001>, <-1.230099, -0.555387, 20.508159>, <-1.592604, -0.342462, 20.647742>, <-1.710986, -0.582582, 20.706583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.720709, -0.209745, 19.334235>, <-1.721775, -0.209382, 19.332308>, <-1.723692, -0.207980, 19.333633>, <-1.722626, -0.208343, 19.335560>, 
      <-1.776236, 0.125400, 19.711051>, <-2.095238, 0.168051, 19.438965>, <-1.378502, -0.356200, 18.943530>, <-1.220590, -0.281023, 19.326967>, 
      <-2.690234, -1.659921, 19.403803>, <-2.859897, -2.098182, 19.500037>, <-2.644247, -2.242380, 19.398778>, <-2.474584, -1.804119, 19.302543>, 
      <-1.710986, -0.582582, 20.706583>, <-1.829367, -0.822701, 20.765425>, <-1.466862, -1.035625, 20.625842>, <-1.348480, -0.795506, 20.567001>
    }
  }
  texture {
    darktan2
  }
  rotate <71.745613, -23.796843, -88.134033>
  translate  <17.077111, -3.044059, 12.43941>
}
#declare palmright2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.874701, -4.709920, 19.078126>, <-3.874701, -5.710269, 18.943564>, <-3.824428, -5.710269, 18.943564>, <-3.824428, -4.709920, 19.078126>, 
      <-4.366687, -4.345629, 18.773846>, <-4.395981, -5.149582, 18.878568>, <-3.303166, -5.773561, 18.807945>, <-3.325355, -4.691669, 18.768063>, 
      <-4.035876, -4.237690, 21.312369>, <-4.035876, -5.015048, 21.372489>, <-3.605444, -7.020469, 21.278683>, <-3.535220, -5.281188, 21.029440>, 
      <-3.985533, -4.266211, 21.330664>, <-3.985533, -4.751699, 21.474862>, <-3.408906, -4.788588, 21.380200>, <-3.408906, -4.303100, 21.236002>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.824428, -4.709920, 19.078126>, <-3.824428, -3.709572, 19.212687>, <-3.874701, -3.709572, 19.212687>, <-3.874701, -4.709920, 19.078126>, 
      <-3.325355, -4.691669, 18.768063>, <-3.347544, -3.609777, 18.728182>, <-4.337394, -3.541677, 18.669123>, <-4.366687, -4.345629, 18.773846>, 
      <-3.535220, -5.281188, 21.029440>, <-3.464996, -3.541908, 20.780198>, <-4.035876, -3.460332, 21.252249>, <-4.035876, -4.237690, 21.312369>, 
      <-3.408906, -4.303100, 21.236002>, <-3.408906, -3.817612, 21.091803>, <-3.985533, -3.780723, 21.186465>, <-3.985533, -4.266211, 21.330664>
    }
  }
  texture {
    darktan2
  }
  rotate <13.825461, -8.688465, 0.541283>
  translate  <3.540986, 9.707821, 0.330089>
}
#declare finger13 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.722626, -0.208343, 19.335560>, <-1.721560, -0.208706, 19.337487>, <-1.719642, -0.210109, 19.336162>, <-1.720709, -0.209745, 19.334235>, 
      <-1.220590, -0.281023, 19.326967>, <-1.062679, -0.205846, 19.710405>, <-1.457234, 0.082749, 19.983136>, <-1.776236, 0.125400, 19.711051>, 
      <-2.474584, -1.804119, 19.302543>, <-2.304922, -1.365859, 19.206308>, <-2.520572, -1.221661, 19.307568>, <-2.690234, -1.659921, 19.403803>, 
      <-1.348480, -0.795506, 20.567001>, <-1.230099, -0.555387, 20.508159>, <-1.592604, -0.342462, 20.647742>, <-1.710986, -0.582582, 20.706583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.720709, -0.209745, 19.334235>, <-1.721775, -0.209382, 19.332308>, <-1.723692, -0.207980, 19.333633>, <-1.722626, -0.208343, 19.335560>, 
      <-1.776236, 0.125400, 19.711051>, <-2.095238, 0.168051, 19.438965>, <-1.378502, -0.356200, 18.943530>, <-1.220590, -0.281023, 19.326967>, 
      <-2.690234, -1.659921, 19.403803>, <-2.859897, -2.098182, 19.500037>, <-2.644247, -2.242380, 19.398778>, <-2.474584, -1.804119, 19.302543>, 
      <-1.710986, -0.582582, 20.706583>, <-1.829367, -0.822701, 20.765425>, <-1.466862, -1.035625, 20.625842>, <-1.348480, -0.795506, 20.567001>
    }
  }
  texture {
    darktan2
  }
  scale 0.95
  rotate <71.745613, -23.796843, -88.134033>
  translate  <16.046177, -2.517313, 12.660371>
}
#declare finger14 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.722626, -0.208343, 19.335560>, <-1.721560, -0.208706, 19.337487>, <-1.719642, -0.210109, 19.336162>, <-1.720709, -0.209745, 19.334235>, 
      <-1.220590, -0.281023, 19.326967>, <-1.062679, -0.205846, 19.710405>, <-1.457234, 0.082749, 19.983136>, <-1.776236, 0.125400, 19.711051>, 
      <-2.474584, -1.804119, 19.302543>, <-2.304922, -1.365859, 19.206308>, <-2.520572, -1.221661, 19.307568>, <-2.690234, -1.659921, 19.403803>, 
      <-1.348480, -0.795506, 20.567001>, <-1.230099, -0.555387, 20.508159>, <-1.592604, -0.342462, 20.647742>, <-1.710986, -0.582582, 20.706583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.720709, -0.209745, 19.334235>, <-1.721775, -0.209382, 19.332308>, <-1.723692, -0.207980, 19.333633>, <-1.722626, -0.208343, 19.335560>, 
      <-1.776236, 0.125400, 19.711051>, <-2.095238, 0.168051, 19.438965>, <-1.378502, -0.356200, 18.943530>, <-1.220590, -0.281023, 19.326967>, 
      <-2.690234, -1.659921, 19.403803>, <-2.859897, -2.098182, 19.500037>, <-2.644247, -2.242380, 19.398778>, <-2.474584, -1.804119, 19.302543>, 
      <-1.710986, -0.582582, 20.706583>, <-1.829367, -0.822701, 20.765425>, <-1.466862, -1.035625, 20.625842>, <-1.348480, -0.795506, 20.567001>
    }
  }
  texture {
    darktan2
  }
  scale 0.9025
  rotate <71.745613, -23.796843, -88.134033>
  translate  <15.056272, -1.980279, 12.849668>
}
#declare finger15 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.722626, -0.208343, 19.335560>, <-1.721560, -0.208706, 19.337487>, <-1.719642, -0.210109, 19.336162>, <-1.720709, -0.209745, 19.334235>, 
      <-1.220590, -0.281023, 19.326967>, <-1.062679, -0.205846, 19.710405>, <-1.457234, 0.082749, 19.983136>, <-1.776236, 0.125400, 19.711051>, 
      <-2.474584, -1.804119, 19.302543>, <-2.304922, -1.365859, 19.206308>, <-2.520572, -1.221661, 19.307568>, <-2.690234, -1.659921, 19.403803>, 
      <-1.348480, -0.795506, 20.567001>, <-1.230099, -0.555387, 20.508159>, <-1.592604, -0.342462, 20.647742>, <-1.710986, -0.582582, 20.706583>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.720709, -0.209745, 19.334235>, <-1.721775, -0.209382, 19.332308>, <-1.723692, -0.207980, 19.333633>, <-1.722626, -0.208343, 19.335560>, 
      <-1.776236, 0.125400, 19.711051>, <-2.095238, 0.168051, 19.438965>, <-1.378502, -0.356200, 18.943530>, <-1.220590, -0.281023, 19.326967>, 
      <-2.690234, -1.659921, 19.403803>, <-2.859897, -2.098182, 19.500037>, <-2.644247, -2.242380, 19.398778>, <-2.474584, -1.804119, 19.302543>, 
      <-1.710986, -0.582582, 20.706583>, <-1.829367, -0.822701, 20.765425>, <-1.466862, -1.035625, 20.625842>, <-1.348480, -0.795506, 20.567001>
    }
  }
  texture {
    darktan2
  }
  scale 0.857375
  rotate <71.745613, -23.796843, -88.134033>
  translate  <14.251787, -1.545814, 13.118948>
}
#declare handrightcsg = union {
  object { finger11 }
  object { finger12 }
  object { palmright2 }
  object { finger13 }
  object { finger14 }
  object { finger15 }
  scale -1.0
  rotate <150.28421, -23.460108, -33.515259>
  translate  <5.030468, -8.874991, 4.334385>
}
#declare armrightcsg = union {
  object { armleft1 }
  object { handrightcsg }
  scale <-0.8, -0.714071, -0.630367>
  rotate <179.429031, -27.851519, 8.107947>
  translate  <13.518243, -1.823939, 14.453341>
}
#declare leg2 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.020775, 3.319227, 12.667123>, <1.321211, 3.460353, 12.369530>, <1.868405, 3.502035, 12.743328>, <1.714520, 3.372072, 13.141033>, 
      <1.065019, 2.076478, 12.432196>, <1.542071, 2.529604, 12.150005>, <2.089265, 2.571286, 12.523803>, <1.997568, 2.182847, 13.350526>, 
      <1.168930, 1.492607, 12.345190>, <1.761234, 1.701360, 11.921533>, <2.308428, 1.743042, 12.295331>, <2.101479, 1.598977, 13.263519>, 
      <1.303129, 0.743128, 12.185182>, <1.765861, 0.656370, 11.615664>, <2.673233, 0.657620, 12.482335>, <2.288403, 0.844647, 13.128290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.714520, 3.372072, 13.141033>, <1.560635, 3.242109, 13.538738>, <0.720339, 3.178101, 12.964717>, <1.020775, 3.319227, 12.667123>, 
      <1.997568, 2.182847, 13.350526>, <1.905870, 1.794409, 14.177249>, <0.587967, 1.623352, 12.714388>, <1.065019, 2.076478, 12.432196>, 
      <2.101479, 1.598977, 13.263519>, <1.894529, 1.454912, 14.231708>, <0.576626, 1.283854, 12.768847>, <1.168930, 1.492607, 12.345190>, 
      <2.288403, 0.844647, 13.128290>, <1.903574, 1.031674, 13.774245>, <0.840398, 0.829886, 12.754701>, <1.303129, 0.743128, 12.185182>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.303129, 0.743128, 12.185182>, <1.765861, 0.656370, 11.615664>, <2.673233, 0.657620, 12.482335>, <2.288403, 0.844647, 13.128290>, 
      <1.437328, -0.006351, 12.025175>, <1.770488, -0.388619, 11.309795>, <3.038038, -0.427801, 12.669340>, <2.475328, 0.090318, 12.993062>, 
      <1.546292, -0.176028, 12.098822>, <1.748861, -0.361088, 11.338384>, <3.016953, -0.390565, 12.683897>, <2.458255, -0.110834, 12.969667>, 
      <1.379264, -0.331387, 12.316034>, <1.730359, -0.914375, 11.651850>, <2.998658, -0.746696, 12.776675>, <2.386076, -0.140366, 13.144065>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.288403, 0.844647, 13.128290>, <1.903574, 1.031674, 13.774245>, <0.840398, 0.829886, 12.754701>, <1.303129, 0.743128, 12.185182>, 
      <2.475328, 0.090318, 12.993062>, <1.912618, 0.608437, 13.316783>, <1.104169, 0.375918, 12.740555>, <1.437328, -0.006351, 12.025175>, 
      <2.458255, -0.110834, 12.969667>, <1.899557, 0.168897, 13.255437>, <1.343722, 0.009033, 12.859261>, <1.546292, -0.176028, 12.098822>, 
      <2.386076, -0.140366, 13.144065>, <1.773494, 0.465964, 13.511454>, <1.028170, 0.251600, 12.980218>, <1.379264, -0.331387, 12.316034>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.379264, -0.331387, 12.316034>, <1.730359, -0.914375, 11.651850>, <2.998658, -0.746696, 12.776675>, <2.386076, -0.140366, 13.144065>, 
      <1.212237, -0.486747, 12.533246>, <1.711858, -1.467663, 11.965317>, <2.980363, -1.102826, 12.869453>, <2.313897, -0.169898, 13.318463>, 
      <0.571270, -0.385535, 13.217206>, <1.075668, -1.404381, 13.175617>, <2.375084, -0.664480, 13.865279>, <1.930208, 0.057715, 14.116252>, 
      <0.116453, -0.159829, 13.625562>, <0.455183, -1.232004, 13.592673>, <1.573251, -0.607652, 14.636587>, <1.275040, 0.287081, 14.637198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.386076, -0.140366, 13.144065>, <1.773494, 0.465964, 13.511454>, <1.028170, 0.251600, 12.980218>, <1.379264, -0.331387, 12.316034>, 
      <2.313897, -0.169898, 13.318463>, <1.647431, 0.763031, 13.767472>, <0.712617, 0.494168, 13.101176>, <1.212237, -0.486747, 12.533246>, 
      <1.930208, 0.057715, 14.116252>, <1.485332, 0.779911, 14.367226>, <0.066872, 0.633311, 13.258796>, <0.571270, -0.385535, 13.217206>, 
      <1.275040, 0.287081, 14.637198>, <0.976830, 1.181814, 14.637810>, <-0.222278, 0.912346, 13.658452>, <0.116453, -0.159829, 13.625562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.116453, -0.159829, 13.625562>, <0.455183, -1.232004, 13.592673>, <1.573251, -0.607652, 14.636587>, <1.275040, 0.287081, 14.637198>, 
      <-0.338365, 0.065876, 14.033918>, <-0.165303, -1.059628, 14.009728>, <0.771418, -0.550823, 15.407894>, <0.619873, 0.516447, 15.158144>, 
      <-1.175296, 0.321640, 14.823384>, <-1.429726, -0.991670, 15.339440>, <0.042761, 0.051635, 16.322791>, <0.051186, 1.146274, 15.806735>, 
      <-2.414540, 1.225030, 15.301874>, <-2.804766, 0.245567, 15.888520>, <-1.801748, 0.965909, 17.511911>, <-1.745017, 2.166767, 16.950880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.275040, 0.287081, 14.637198>, <0.976830, 1.181814, 14.637810>, <-0.222278, 0.912346, 13.658452>, <0.116453, -0.159829, 13.625562>, 
      <0.619873, 0.516447, 15.158144>, <0.468328, 1.583716, 14.908394>, <-0.511428, 1.191380, 14.058108>, <-0.338365, 0.065876, 14.033918>, 
      <0.051186, 1.146274, 15.806735>, <0.059612, 2.240913, 15.290679>, <-0.920866, 1.634950, 14.307328>, <-1.175296, 0.321640, 14.823384>, 
      <-1.745017, 2.166767, 16.950880>, <-1.688287, 3.367624, 16.389849>, <-2.024313, 2.204494, 14.715229>, <-2.414540, 1.225030, 15.301874>
    }
  }
  rotate 0.0*z
  translate  <1.064878, 0.817679, -3.173264>
}
#declare foot1 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.193623, 0.959575, 2.761335>, <0.193623, 0.950272, 2.494923>, <0.192195, 0.950272, 2.494923>, <0.192195, 0.959575, 2.761335>, 
      <-0.186056, 0.774943, 2.714683>, <-0.888605, 0.889664, 1.533880>, <1.274423, 0.889664, 1.533880>, <1.058420, 0.774943, 2.740762>, 
      <0.058648, 0.304250, 4.826723>, <-0.407102, 0.500406, 0.862703>, <0.792919, 0.500406, 0.862703>, <1.097496, 0.304250, 4.841678>, 
      <-0.070285, -0.165698, 3.515056>, <-0.303159, -0.205452, 1.450153>, <0.815150, -0.205452, 1.450153>, <0.967438, -0.165698, 3.522534>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.192195, 0.959575, 2.761335>, <0.192195, 0.968877, 3.027748>, <0.193623, 0.968877, 3.027748>, <0.193623, 0.959575, 2.761335>, 
      <1.058420, 0.774943, 2.740762>, <0.842417, 0.660221, 3.947643>, <0.516493, 0.660221, 3.895486>, <-0.186056, 0.774943, 2.714683>, 
      <1.097496, 0.304250, 4.841678>, <1.402072, 0.108093, 8.820653>, <0.524397, 0.108093, 8.790742>, <0.058648, 0.304250, 4.826723>, 
      <0.967438, -0.165698, 3.522534>, <1.119726, -0.125944, 5.594914>, <0.162590, -0.125944, 5.579959>, <-0.070285, -0.165698, 3.515056>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.070285, -0.165698, 3.515056>, <-0.303159, -0.205452, 1.450153>, <0.815150, -0.205452, 1.450153>, <0.967438, -0.165698, 3.522534>, 
      <-0.199217, -0.635646, 2.203389>, <-0.199217, -0.911310, 2.037603>, <0.837380, -0.911310, 2.037603>, <0.837380, -0.635646, 2.203389>, 
      <-0.644409, -2.944094, 1.823563>, <-0.639635, -2.791221, 1.036166>, <1.617452, -4.544197, 0.877247>, <1.701894, -4.697069, 1.664645>, 
      <-0.224174, -2.787570, 1.870117>, <-0.224174, -2.760523, 1.833614>, <0.990481, -2.760523, 1.833614>, <0.990481, -2.787570, 1.870117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.967438, -0.165698, 3.522534>, <1.119726, -0.125944, 5.594914>, <0.162590, -0.125944, 5.579959>, <-0.070285, -0.165698, 3.515056>, 
      <0.837380, -0.635646, 2.203389>, <0.837380, -0.359982, 2.369175>, <-0.199217, -0.359982, 2.369175>, <-0.199217, -0.635646, 2.203389>, 
      <1.701894, -4.697069, 1.664645>, <1.786335, -4.849941, 2.452042>, <-0.649184, -3.096966, 2.610960>, <-0.644409, -2.944094, 1.823563>, 
      <0.990481, -2.787570, 1.870117>, <0.990481, -2.814618, 1.906620>, <-0.224174, -2.814618, 1.906620>, <-0.224174, -2.787570, 1.870117>
    }
  }
  scale <-1.215802, -0.656459, -0.91695>
  rotate <-148.912811, 4.585322, 8.026973>
  translate  <7.461508, 3.477854, 11.867097>
}
#declare footcsg = union {
  object { foot1 }
  sphere { // toe5
    <0,0,0>,1
    scale <-0.125219, -0.152879, -0.110351>
    rotate <-153.918259, 1.715587, 13.479961>
    translate  <8.001442, 1.050615, 12.251014>
  }
  sphere { // toe6
    <0,0,0>,1
    scale <-0.146593, -0.247289, -0.118757>
    rotate <-153.918259, 1.715587, 13.479961>
    translate  <7.679849, 0.857392, 12.230195>
  }
  sphere { // toe7
    <0,0,0>,1
    scale <-0.14655, -0.255193, -0.146774>
    rotate <-153.913605, 1.649564, 13.51904>
    translate  <7.307798, 0.743871, 12.197918>
  }
  sphere { // toe8
    <0,0,0>,1
    scale <-0.175963, -0.25185, -0.146768>
    rotate <-154.144897, 3.888167, 9.339452>
    translate  <6.960972, 0.617147, 12.17315>
  }
  sphere { // bigtoe1
    <0,0,0>,1
    scale <-0.286043, -0.251722, -0.211859>
    rotate <-163.385864, 4.585322, 8.026973>
    translate  <6.486994, 0.483704, 12.182281>
  }
  scale <0.6, 0.973131, 0.55271>
  rotate <45.395691, 0.3655, 3.546193>
  translate  <-2.32446, 8.62744, 2.819997>
}
#declare leftleg = union {
  object { leg2 }
  object { footcsg }
  no_shadow
  scale <1.453692, 0.896085, 1.577883>
  rotate <18.937664, 5.029776, -9.079128>
  translate  <4.381159, 6.260668, 2.168946>
}
#declare torsocsg = union {
  object { torso }
  object { armleftcsg }
  object { armrightcsg }
  object { leftleg }
  scale <0.88, 0.893608, 0.633761>
}
#declare child_csg = union {
  object { headcsg }
  object { torsocsg }
  texture {
    darktan2
  }
  scale <0.150193, 0.24, 0.192157>
  rotate <-38.505383, 4.000311, -34.598007>
  translate  <-0.558987, -4.571802, 5.466041>
}
union { // dolphPchild
  object { dolphin }
  sphere { // dolphbody_gischt
    <0,0,0>,1
    texture {
      gischt_sparse
    }
    scale <-1.430092, -5.657205, -1.655239>
    rotate <162.758118, -5.960609, -26.018751>
    translate  <2.265145, -0.143402, 4.163227>
  }
  cone { // child_gischt
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      gischt_sparse
    }
    scale <1.759982, 1.407712, -9.967192>
    rotate <-101.861008, 25.255604, -28.416586>
    translate  <5.002639, 5.559514, 5.293721>
  }
  object { child_csg }
}




