
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod body + seats + trunks + lamps + wind shield
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

// default yellow paint:
#declare BTEX =
   texture{
      finish {
         ambient <1,.9,.05>*.3
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.3
      }
      normal {bumps 0.05 scale 2}
      //pigment{color rgb <1,.9,.05>}
   }

// body texture
#declare BODY_TEX01=
texture { BTEX
   pigment{ //color rgb <1,.5,0>
      image_map {
         gif "t01.gif"
         map_type 2
         once
      }
      //rotate x*90
      //rotate y*90
      rotate z*-90
      scale 17
      translate x*-4
   }
}

//#declare METAL01 =  texture { T_Chrome_4D } //texture {DEF_TEX pigment {color rgb <0,0,1>} }

// seat texture
#declare Upholsery_TEX01=

texture{
   finish{
      diffuse .9
      brilliance .5
      ambient .2
      phong .6
      phong_size 10
   }
   normal { gradient z
      normal_map{
         [0.0 gradient z .3
             slope_map {
                [0 <0, .5>]
                [0.25  <1,0>]
                [0.75 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
         ]
         [0.5 gradient z .3
             slope_map {
                [0 <0, .5>]
                [0.1  <1,0>]
                [0.9 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
         ]
         [0.5 gradient x .3
             slope_map {
                [0 <0, .5>]
                [0.1  <1,0>]
                [0.9 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
         ]
         [1.0 gradient x .3
             slope_map {
                [0 <0, .5>]
                [0.1  <1,0>]
                [0.9 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
          ]
       }
   }
   pigment{
      crackle
         color_map {
            [0 color rgb <1*.15, .75*.15, .5*.15> ]
            [0.5 color rgb <.1, .1, .1> ]
            [1 color rgb <1*.15, .75*.15, .5*.15> ]
         }
         turbulence .5
         scale .02
      }
   scale 3.4
}

// trunk texture
#declare Upholsery_TEX02=

texture{
   finish{
      diffuse .9
      brilliance .5
      ambient .2
      phong .6
      phong_size 10
   }
   normal { gradient z
      normal_map{
         [0.0 gradient z .3
             slope_map {
                [0 <0, .5>]
                [0.25  <1,0>]
                [0.75 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
         ]
         [0.5 gradient z .3
             slope_map {
                [0 <0, .5>]
                [0.1  <1,0>]
                [0.9 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
         ]
         [0.5 gradient x .3
             slope_map {
                [0 <0, .5>]
                [0.1  <1,0>]
                [0.9 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
         ]
         [1.0 gradient x .3
             slope_map {
                [0 <0, .5>]
                [0.1  <1,0>]
                [0.9 <1, 0>]
                [1 <0, -.5>]
             }
             scale .07
          ]
       }
   }
   pigment{
      crackle
         color_map {
            [0 color rgb <1*.15, .75*.15, .5*.15> ]
            [0.5 color rgb <.1, .1, .1> ]
            [1 color rgb <1*.15, .75*.15, .5*.15> ]
         }
         turbulence .5
         scale .02
      }
   scale 3.4
}

// bucket
#declare BODY01=
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 0.1801, 1.4846> <-2.2829, 0.1801, 1.5042> <-2.0832, 0.1801, 1.5229> <-1.9356, 0.1801, 1.5501>
		<-2.4317, 0.3158, 1.5148> <-2.2829, 0.3158, 1.5345> <-2.0832, 0.3158, 1.5545> <-1.9356, 0.3158, 1.5816>
		<-2.4318, 0.4951, 1.5631> <-2.2829, 0.4951, 1.5841> <-2.0831, 0.4949, 1.6032> <-1.9356, 0.4949, 1.6322>
		<-2.4317, 0.6322, 1.5854> <-2.2829, 0.6322, 1.6064> <-2.0831, 0.6322, 1.6263> <-1.9356, 0.6322, 1.6553>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9356, 0.1801, 1.5501> <-1.7802, 0.1801, 1.5786> <-1.5784, 0.1801, 1.6424> <-1.4229, 0.1801, 1.6702>
		<-1.9356, 0.3158, 1.5816> <-1.7802, 0.3158, 1.6102> <-1.5784, 0.3158, 1.6764> <-1.4229, 0.3158, 1.7043>
		<-1.9356, 0.4949, 1.6322> <-1.7800, 0.4949, 1.6628> <-1.5790, 0.4946, 1.7307> <-1.4230, 0.4946, 1.7589>
		<-1.9356, 0.6322, 1.6553> <-1.7800, 0.6322, 1.6859> <-1.5790, 0.6322, 1.7555> <-1.4229, 0.6322, 1.7837>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4229, 0.1801, 1.6702> <-0.9577, 0.1801, 1.7536> <-0.3392, 0.1801, 1.8933> <0.1327, 0.1801, 1.9206>
		<-1.4229, 0.3158, 1.7043> <-0.9577, 0.3158, 1.7876> <-0.3017, 0.3158, 1.9325> <0.1702, 0.3158, 1.9597>
		<-1.4230, 0.4946, 1.7589> <-0.9205, 0.4946, 1.8495> <-0.2802, 0.4918, 1.9933> <0.2295, 0.4918, 2.0225>
		<-1.4229, 0.6322, 1.7837> <-0.9205, 0.6322, 1.8743> <-0.2520, 0.6322, 2.0219> <0.2577, 0.6322, 2.0511>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1327, 0.1801, 1.9206> <0.6305, 0.1801, 1.9493> <1.3049, 0.1801, 1.9545> <1.7937, 0.1801, 1.8559>
		<0.1702, 0.3158, 1.9597> <0.6680, 0.3158, 1.9885> <1.3799, 0.3158, 1.9923> <1.8687, 0.3158, 1.8937>
		<0.2295, 0.4918, 2.0225> <0.7648, 0.4918, 2.0531> <1.4608, 0.4861, 2.0608> <1.9863, 0.4861, 1.9538>
		<0.2577, 0.6322, 2.0511> <0.7930, 0.6322, 2.0817> <1.5183, 0.6322, 2.0890> <2.0437, 0.6322, 1.9820>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.7937, 0.1801, 1.8559> <1.9769, 0.1801, 1.8189> <2.2337, 0.1801, 1.6615> <2.2937, 0.1801, 1.4846>
		<1.8687, 0.3158, 1.8937> <2.0519, 0.3158, 1.8567> <2.3087, 0.3158, 1.6918> <2.3687, 0.3158, 1.5148>
		<1.9863, 0.4861, 1.9538> <2.1739, 0.4861, 1.9155> <2.4289, 0.4866, 1.7455> <2.4868, 0.4866, 1.5630>
		<2.0437, 0.6322, 1.9820> <2.2313, 0.6322, 1.9437> <2.4858, 0.6322, 1.7679> <2.5437, 0.6322, 1.5854>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2937, 0.1801, 1.4846> <2.4360, 0.1801, 1.0648> <2.4187, 0.1801, 0.4556> <2.4187, 0.1801, 0.0124>
		<2.3687, 0.3158, 1.5148> <2.5110, 0.3158, 1.0950> <2.4937, 0.3158, 0.4557> <2.4937, 0.3158, 0.0125>
		<2.4868, 0.4866, 1.5630> <2.6300, 0.4866, 1.1119> <2.6124, 0.4879, 0.4859> <2.6124, 0.4879, 0.0127>
		<2.5437, 0.6322, 1.5854> <2.6869, 0.6322, 1.1343> <2.6687, 0.6322, 0.4860> <2.6687, 0.6322, 0.0128>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2937, 0.1801, -1.4728> <2.3687, 0.3158, -1.5030> <2.4868, 0.4866, -1.5513> <2.5437, 0.6322, -1.5736>
		<2.4364, 0.1801, -1.0490> <2.5114, 0.3158, -1.0793> <2.6303, 0.4866, -1.0960> <2.6872, 0.6322, -1.1183>
		<2.4187, 0.1801, -0.4348> <2.4937, 0.3158, -0.4346> <2.6124, 0.4879, -0.4647> <2.6687, 0.6322, -0.4646>
		<2.4187, 0.1801, 0.0124> <2.4937, 0.3158, 0.0125> <2.6124, 0.4879, 0.0127> <2.6687, 0.6322, 0.0128>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2937, 0.1801, -1.4728> <2.2341, 0.1801, -1.6498> <1.9769, 0.1801, -1.8071> <1.7937, 0.1801, -1.8440>
		<2.3687, 0.3158, -1.5030> <2.3091, 0.3158, -1.6801> <2.0519, 0.3158, -1.8449> <1.8687, 0.3158, -1.8819>
		<2.4868, 0.4866, -1.5513> <2.4293, 0.4866, -1.7339> <2.1739, 0.4861, -1.9038> <1.9863, 0.4861, -1.9420>
		<2.5437, 0.6322, -1.5736> <2.4862, 0.6322, -1.7562> <2.2313, 0.6322, -1.9320> <2.0437, 0.6322, -1.9702>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.7937, 0.1801, -1.8440> <1.3049, 0.1801, -1.9427> <0.6305, 0.1801, -1.9375> <0.1327, 0.1801, -1.9087>
		<1.8687, 0.3158, -1.8819> <1.3799, 0.3158, -1.9805> <0.6680, 0.3158, -1.9766> <0.1702, 0.3158, -1.9479>
		<1.9863, 0.4861, -1.9420> <1.4608, 0.4861, -2.0490> <0.7648, 0.4918, -2.0413> <0.2295, 0.4918, -2.0107>
		<2.0437, 0.6322, -1.9702> <1.5183, 0.6322, -2.0772> <0.7930, 0.6322, -2.0699> <0.2577, 0.6322, -2.0393>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.1327, 0.1801, -1.9087> <-0.3392, 0.1801, -1.8815> <-0.9577, 0.1801, -1.7417> <-1.4229, 0.1801, -1.6584>
		<0.1702, 0.3158, -1.9479> <-0.3017, 0.3158, -1.9207> <-0.9577, 0.3158, -1.7758> <-1.4229, 0.3158, -1.6924>
		<0.2295, 0.4918, -2.0107> <-0.2802, 0.4918, -1.9815> <-0.9205, 0.4946, -1.8377> <-1.4230, 0.4946, -1.7471>
		<0.2577, 0.6322, -2.0393> <-0.2520, 0.6322, -2.0102> <-0.9205, 0.6322, -1.8626> <-1.4229, 0.6322, -1.7719>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4229, 0.1801, -1.6584> <-1.5784, 0.1801, -1.6305> <-1.7802, 0.1801, -1.5668> <-1.9356, 0.1801, -1.5382>
		<-1.4229, 0.3158, -1.6924> <-1.5784, 0.3158, -1.6646> <-1.7802, 0.3158, -1.5984> <-1.9356, 0.3158, -1.5698>
		<-1.4230, 0.4946, -1.7471> <-1.5790, 0.4946, -1.7189> <-1.7800, 0.4949, -1.6510> <-1.9356, 0.4949, -1.6204>
		<-1.4229, 0.6322, -1.7719> <-1.5790, 0.6322, -1.7437> <-1.7800, 0.6322, -1.6741> <-1.9356, 0.6322, -1.6435>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9356, 0.1801, -1.5382> <-2.0832, 0.1801, -1.5111> <-2.2829, 0.1801, -1.4924> <-2.4317, 0.1801, -1.4728>
		<-1.9356, 0.3158, -1.5698> <-2.0832, 0.3158, -1.5427> <-2.2829, 0.3158, -1.5227> <-2.4317, 0.3158, -1.5030>
		<-1.9356, 0.4949, -1.6204> <-2.0831, 0.4949, -1.5914> <-2.2829, 0.4951, -1.5723> <-2.4318, 0.4951, -1.5513>
		<-1.9356, 0.6322, -1.6435> <-2.0831, 0.6322, -1.6146> <-2.2829, 0.6322, -1.5946> <-2.4317, 0.6322, -1.5736>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 0.6322, 1.5854> <-2.2829, 0.6322, 1.6064> <-2.0831, 0.6322, 1.6263> <-1.9356, 0.6322, 1.6553>
		<-2.4317, 0.8574, 1.6220> <-2.2828, 0.8574, 1.6429> <-2.0830, 0.8600, 1.6647> <-1.9355, 0.8600, 1.6937>
		<-2.4317, 1.1598, 1.6576> <-2.2829, 1.1624, 1.6799> <-2.0829, 1.1634, 1.7001> <-1.9356, 1.1660, 1.7308>
		<-2.4314, 1.3867, 1.6806> <-2.2826, 1.3894, 1.7029> <-2.0827, 1.3932, 1.7241> <-1.9353, 1.3957, 1.7548>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9356, 0.6322, 1.6553> <-1.7800, 0.6322, 1.6859> <-1.5790, 0.6322, 1.7555> <-1.4229, 0.6322, 1.7837>
		<-1.9355, 0.8600, 1.6937> <-1.7800, 0.8600, 1.7242> <-1.5789, 0.8623, 1.7970> <-1.4229, 0.8623, 1.8251>
		<-1.9356, 1.1660, 1.7308> <-1.7799, 1.1686, 1.7632> <-1.5795, 1.1696, 1.8368> <-1.4230, 1.1716, 1.8652>
		<-1.9353, 1.3957, 1.7548> <-1.7796, 1.3983, 1.7872> <-1.5793, 1.4019, 1.8625> <-1.4228, 1.4039, 1.8909>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4229, 0.6322, 1.7837> <-0.9205, 0.6322, 1.8743> <-0.2520, 0.6322, 2.0219> <0.2577, 0.6322, 2.0511>
		<-1.4229, 0.8623, 1.8251> <-0.9205, 0.8623, 1.9158> <-0.2050, 0.8667, 2.0697> <0.3047, 0.8667, 2.0989>
		<-1.4230, 1.1716, 1.8652> <-0.8835, 1.1787, 1.9629> <-0.1848, 1.1779, 2.1139> <0.3625, 1.1848, 2.1449>
		<-1.4228, 1.4039, 1.8909> <-0.8833, 1.4110, 1.9885> <-0.1647, 1.4191, 2.1434> <0.3826, 1.4261, 2.1744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2577, 0.6322, 2.0511> <0.7930, 0.6322, 2.0817> <1.5183, 0.6322, 2.0890> <2.0437, 0.6322, 1.9820>
		<0.3047, 0.8667, 2.0989> <0.8401, 0.8667, 2.1295> <1.6117, 0.8698, 2.1348> <2.1371, 0.8698, 2.0278>
		<0.3625, 1.1848, 2.1449> <0.9353, 1.1921, 2.1773> <1.6741, 1.1922, 2.1889> <2.2361, 1.1997, 2.0738>
		<0.3826, 1.4261, 2.1744> <0.9554, 1.4334, 2.2068> <1.7315, 1.4436, 2.2162> <2.2935, 1.4511, 2.1011>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0437, 0.6322, 1.9820> <2.2313, 0.6322, 1.9437> <2.4858, 0.6322, 1.7679> <2.5437, 0.6322, 1.5854>
		<2.1371, 0.8698, 2.0278> <2.3247, 0.8698, 1.9896> <2.5797, 0.8724, 1.8047> <2.6376, 0.8724, 1.6222>
		<2.2361, 1.1997, 2.0738> <2.4281, 1.2023, 2.0344> <2.6793, 1.2044, 1.8471> <2.7355, 1.2052, 1.6594>
		<2.2935, 1.4511, 2.1011> <2.4855, 1.4537, 2.0618> <2.7372, 1.4575, 1.8684> <2.7934, 1.4583, 1.6806>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5437, 0.6322, 1.5854> <2.6869, 0.6322, 1.1343> <2.6687, 0.6322, 0.4860> <2.6687, 0.6322, 0.0128>
		<2.6376, 0.8724, 1.6222> <2.7808, 0.8724, 1.1711> <2.7631, 0.8739, 0.4862> <2.7631, 0.8739, 0.0129>
		<2.7355, 1.2052, 1.6594> <2.8793, 1.2073, 1.1788> <2.8617, 1.2069, 0.5147> <2.8617, 1.2069, 0.0131>
		<2.7934, 1.4583, 1.6806> <2.9372, 1.4604, 1.2000> <2.9184, 1.4601, 0.5148> <2.9184, 1.4601, 0.0131>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.6687, 0.6322, 0.0128> <2.6687, 0.6322, -0.4646> <2.6872, 0.6322, -1.1183> <2.5437, 0.6322, -1.5736>
		<2.7631, 0.8739, 0.0129> <2.7631, 0.8739, -0.4645> <2.7811, 0.8724, -1.1552> <2.6376, 0.8724, -1.6105>
		<2.8617, 1.2069, 0.0131> <2.8617, 1.2069, -0.4929> <2.8796, 1.2073, -1.1626> <2.7355, 1.2052, -1.6477>
		<2.9184, 1.4601, 0.0131> <2.9184, 1.4601, -0.4929> <2.9376, 1.4604, -1.1839> <2.7934, 1.4583, -1.6689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5437, 0.6322, -1.5736> <2.4862, 0.6322, -1.7562> <2.2313, 0.6322, -1.9320> <2.0437, 0.6322, -1.9702>
		<2.6376, 0.8724, -1.6105> <2.5801, 0.8724, -1.7931> <2.3247, 0.8698, -1.9778> <2.1371, 0.8698, -2.0161>
		<2.7355, 1.2052, -1.6477> <2.6796, 1.2044, -1.8355> <2.4281, 1.2023, -2.0227> <2.2361, 1.1997, -2.0621>
		<2.7934, 1.4583, -1.6689> <2.7376, 1.4575, -1.8568> <2.4855, 1.4537, -2.0501> <2.2935, 1.4511, -2.0894>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0437, 0.6322, -1.9702> <1.5183, 0.6322, -2.0772> <0.7930, 0.6322, -2.0699> <0.2577, 0.6322, -2.0393>
		<2.1371, 0.8698, -2.0161> <1.6117, 0.8698, -2.1231> <0.8401, 0.8667, -2.1177> <0.3047, 0.8667, -2.0871>
		<2.2361, 1.1997, -2.0621> <1.6741, 1.1922, -2.1772> <0.9353, 1.1921, -2.1656> <0.3625, 1.1848, -2.1332>
		<2.2935, 1.4511, -2.0894> <1.7315, 1.4436, -2.2045> <0.9554, 1.4334, -2.1951> <0.3826, 1.4261, -2.1627>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2577, 0.6322, -2.0393> <-0.2520, 0.6322, -2.0102> <-0.9205, 0.6322, -1.8626> <-1.4229, 0.6322, -1.7719>
		<0.3047, 0.8667, -2.0871> <-0.2050, 0.8667, -2.0580> <-0.9205, 0.8623, -1.9041> <-1.4229, 0.8623, -1.8134>
		<0.3625, 1.1848, -2.1332> <-0.1848, 1.1779, -2.1022> <-0.8835, 1.1787, -1.9511> <-1.4230, 1.1716, -1.8535>
		<0.3826, 1.4261, -2.1627> <-0.1647, 1.4191, -2.1317> <-0.8833, 1.4110, -1.9768> <-1.4228, 1.4039, -1.8792>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4229, 0.6322, -1.7719> <-1.5790, 0.6322, -1.7437> <-1.7800, 0.6322, -1.6741> <-1.9356, 0.6322, -1.6435>
		<-1.4229, 0.8623, -1.8134> <-1.5789, 0.8623, -1.7852> <-1.7800, 0.8600, -1.7125> <-1.9355, 0.8600, -1.6819>
		<-1.4230, 1.1716, -1.8535> <-1.5795, 1.1696, -1.8251> <-1.7799, 1.1686, -1.7515> <-1.9356, 1.1660, -1.7191>
		<-1.4228, 1.4039, -1.8792> <-1.5793, 1.4019, -1.8508> <-1.7796, 1.3983, -1.7755> <-1.9353, 1.3957, -1.7431>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9356, 0.6322, -1.6435> <-2.0831, 0.6322, -1.6146> <-2.2829, 0.6322, -1.5946> <-2.4317, 0.6322, -1.5736>
		<-1.9355, 0.8600, -1.6819> <-2.0830, 0.8600, -1.6529> <-2.2828, 0.8574, -1.6312> <-2.4317, 0.8574, -1.6102>
		<-1.9356, 1.1660, -1.7191> <-2.0829, 1.1634, -1.6884> <-2.2829, 1.1624, -1.6682> <-2.4317, 1.1598, -1.6459>
		<-1.9353, 1.3957, -1.7431> <-2.0827, 1.3932, -1.7124> <-2.2826, 1.3894, -1.6912> <-2.4314, 1.3867, -1.6689>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4314, 1.3867, 1.6806> <-2.2826, 1.3894, 1.7029> <-2.0827, 1.3932, 1.7241> <-1.9353, 1.3957, 1.7548>
		<-2.4312, 1.5818, 1.7004> <-2.2823, 1.5845, 1.7226> <-2.0824, 1.5909, 1.7447> <-1.9351, 1.5935, 1.7754>
		<-2.4314, 1.8431, 1.7422> <-2.2826, 1.8485, 1.7651> <-2.0824, 1.8520, 1.7866> <-1.9353, 1.8583, 1.8181>
		<-2.4298, 2.0386, 1.7278> <-2.2810, 2.0440, 1.7506> <-2.0810, 2.0503, 1.7725> <-1.9339, 2.0566, 1.8040>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9353, 1.3957, 1.7548> <-1.7796, 1.3983, 1.7872> <-1.5793, 1.4019, 1.8625> <-1.4228, 1.4039, 1.8909>
		<-1.9351, 1.5935, 1.7754> <-1.7793, 1.5961, 1.8079> <-1.5791, 1.6048, 1.8849> <-1.4226, 1.6068, 1.9133>
		<-1.9353, 1.8583, 1.8181> <-1.7795, 1.8651, 1.8515> <-1.5866, 1.8727, 1.9177> <-1.4299, 1.8783, 1.9469>
		<-1.9339, 2.0566, 1.8040> <-1.7781, 2.0634, 1.8374> <-1.5783, 2.0767, 1.9148> <-1.4216, 2.0822, 1.9439>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4228, 1.4039, 1.8909> <-0.8833, 1.4110, 1.9885> <-0.1647, 1.4191, 2.1434> <0.3826, 1.4261, 2.1744>
		<-1.4226, 1.6068, 1.9133> <-0.8831, 1.6139, 2.0110> <-0.1470, 1.6315, 2.1694> <0.4003, 1.6384, 2.2004>
		<-1.4299, 1.8783, 1.9469> <-0.8908, 1.8975, 2.0473> <-0.1647, 1.8978, 2.1958> <0.3825, 1.9245, 2.2266>
		<-1.4216, 2.0822, 1.9439> <-0.8825, 2.1014, 2.0443> <-0.1640, 2.1123, 2.2047> <0.3832, 2.1390, 2.2355>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3826, 1.4261, 2.1744> <0.9554, 1.4334, 2.2068> <1.7315, 1.4436, 2.2162> <2.2935, 1.4511, 2.1011>
		<0.4003, 1.6384, 2.2004> <0.9731, 1.6457, 2.2328> <1.7865, 1.6851, 2.2425> <2.3485, 1.6926, 2.1274>
		<0.3825, 1.9245, 2.2266> <0.9926, 1.9544, 2.2610> <1.8011, 1.9773, 2.2631> <2.3996, 2.0219, 2.1439>
		<0.3832, 2.1390, 2.2355> <0.9934, 2.1688, 2.2698> <1.8187, 2.2252, 2.2793> <2.4172, 2.2698, 2.1601>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2935, 1.4511, 2.1011> <2.4855, 1.4537, 2.0618> <2.7372, 1.4575, 1.8684> <2.7934, 1.4583, 1.6806>
		<2.3485, 1.6926, 2.1274> <2.5405, 1.6951, 2.0881> <2.7962, 1.7148, 1.8900> <2.8524, 1.7156, 1.7022>
		<2.3996, 2.0219, 2.1439> <2.5977, 2.0367, 2.1044> <2.8561, 2.0564, 1.9089> <2.9139, 2.0650, 1.7150>
		<2.4172, 2.2698, 2.1601> <2.6153, 2.2845, 2.1207> <2.8746, 2.3203, 1.9217> <2.9323, 2.3289, 1.7278>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.7934, 1.4583, 1.6806> <2.9372, 1.4604, 1.2000> <2.9184, 1.4601, 0.5148> <2.9184, 1.4601, 0.0131>
		<2.8524, 1.7156, 1.7022> <2.9962, 1.7177, 1.2216> <2.9784, 1.7282, 0.5149> <2.9784, 1.7282, 0.0132>
		<2.9139, 2.0650, 1.7150> <3.0610, 2.0870, 1.2211> <3.0399, 2.0911, 0.5311> <3.0399, 2.0911, 0.0153>
		<2.9323, 2.3289, 1.7278> <3.0795, 2.3509, 1.2339> <3.0567, 2.3653, 0.5291> <3.0567, 2.3653, 0.0133>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9184, 1.4601, 0.0131> <2.9184, 1.4601, -0.4929> <2.9376, 1.4604, -1.1839> <2.7934, 1.4583, -1.6689>
		<2.9784, 1.7282, 0.0132> <2.9784, 1.7282, -0.4928> <2.9965, 1.7177, -1.2055> <2.8524, 1.7156, -1.6905>
		<3.0399, 2.0911, 0.0153> <3.0399, 2.0911, -0.5050> <3.0614, 2.0870, -1.2048> <2.9139, 2.0650, -1.7033>
		<3.0567, 2.3653, 0.0133> <3.0567, 2.3653, -0.5070> <3.0798, 2.3509, -1.2176> <2.9323, 2.3289, -1.7161>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.7934, 1.4583, -1.6689> <2.7376, 1.4575, -1.8568> <2.4855, 1.4537, -2.0501> <2.2935, 1.4511, -2.0894>
		<2.8524, 1.7156, -1.6905> <2.7965, 1.7148, -1.8784> <2.5405, 1.6951, -2.0764> <2.3485, 1.6926, -2.1157>
		<2.9139, 2.0650, -1.7033> <2.8565, 2.0564, -1.8973> <2.5977, 2.0367, -2.0927> <2.3996, 2.0219, -2.1322>
		<2.9323, 2.3289, -1.7161> <2.8749, 2.3203, -1.9101> <2.6153, 2.2845, -2.1090> <2.4172, 2.2698, -2.1485>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2935, 1.4511, -2.0894> <1.7315, 1.4436, -2.2045> <0.9554, 1.4334, -2.1951> <0.3826, 1.4261, -2.1627>
		<2.3485, 1.6926, -2.1157> <1.7865, 1.6851, -2.2308> <0.9731, 1.6457, -2.2211> <0.4003, 1.6384, -2.1887>
		<2.3996, 2.0219, -2.1322> <1.8011, 1.9773, -2.2514> <0.9926, 1.9544, -2.2493> <0.3825, 1.9245, -2.2149>
		<2.4172, 2.2698, -2.1485> <1.8187, 2.2252, -2.2677> <0.9934, 2.1688, -2.2582> <0.3832, 2.1390, -2.2238>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3826, 1.4261, -2.1627> <-0.1647, 1.4191, -2.1317> <-0.8833, 1.4110, -1.9768> <-1.4228, 1.4039, -1.8792>
		<0.4003, 1.6384, -2.1887> <-0.1470, 1.6315, -2.1577> <-0.8831, 1.6139, -1.9993> <-1.4226, 1.6068, -1.9016>
		<0.3825, 1.9245, -2.2149> <-0.1647, 1.8978, -2.1841> <-0.8908, 1.8975, -2.0355> <-1.4299, 1.8783, -1.9352>
		<0.3832, 2.1390, -2.2238> <-0.1640, 2.1123, -2.1930> <-0.8825, 2.1014, -2.0327> <-1.4216, 2.0822, -1.9323>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4228, 1.4039, -1.8792> <-1.5793, 1.4019, -1.8508> <-1.7796, 1.3983, -1.7755> <-1.9353, 1.3957, -1.7431>
		<-1.4226, 1.6068, -1.9016> <-1.5791, 1.6048, -1.8733> <-1.7793, 1.5961, -1.7962> <-1.9351, 1.5935, -1.7637>
		<-1.4299, 1.8783, -1.9352> <-1.5866, 1.8727, -1.9060> <-1.7795, 1.8650, -1.8398> <-1.9353, 1.8583, -1.8064>
		<-1.4216, 2.0822, -1.9323> <-1.5783, 2.0767, -1.9031> <-1.7781, 2.0634, -1.8258> <-1.9339, 2.0566, -1.7923>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9353, 1.3957, -1.7431> <-2.0827, 1.3932, -1.7124> <-2.2826, 1.3894, -1.6912> <-2.4314, 1.3867, -1.6689>
		<-1.9351, 1.5935, -1.7637> <-2.0824, 1.5909, -1.7330> <-2.2823, 1.5845, -1.7109> <-2.4312, 1.5818, -1.6887>
		<-1.9353, 1.8583, -1.8064> <-2.0824, 1.8519, -1.7748> <-2.2826, 1.8485, -1.7534> <-2.4314, 1.8431, -1.7305>
		<-1.9339, 2.0566, -1.7923> <-2.0810, 2.0503, -1.7608> <-2.2810, 2.0440, -1.7390> <-2.4298, 2.0386, -1.7161>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4298, 2.0386, 1.7278> <-2.2810, 2.0440, 1.7506> <-2.0810, 2.0503, 1.7725> <-1.9339, 2.0566, 1.8040>
		<-2.4283, 2.2213, 1.7142> <-2.2795, 2.2267, 1.7371> <-2.0796, 2.2392, 1.7590> <-1.9325, 2.2456, 1.7906>
		<-2.4207, 2.4895, 1.7022> <-2.2722, 2.5012, 1.7249> <-2.0559, 2.4903, 1.7420> <-1.9137, 2.5228, 1.7798>
		<-2.4210, 2.6330, 1.5884> <-2.2726, 2.6447, 1.6111> <-2.0683, 2.6396, 1.6262> <-1.9261, 2.6722, 1.6640>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9339, 2.0566, 1.8040> <-1.7781, 2.0634, 1.8374> <-1.5783, 2.0767, 1.9148> <-1.4216, 2.0822, 1.9439>
		<-1.9325, 2.2456, 1.7906> <-1.7767, 2.2523, 1.8240> <-1.5685, 2.3160, 1.9113> <-1.4118, 2.3216, 1.9405>
		<-1.9137, 2.5228, 1.7798> <-1.7344, 2.5639, 1.8275> <-1.5311, 2.6632, 1.9645> <-1.3475, 2.6813, 2.0098>
		<-1.9261, 2.6722, 1.6640> <-1.7468, 2.7132, 1.7117> <-1.5462, 2.8570, 1.8245> <-1.3626, 2.8751, 1.8698>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4216, 2.0822, 1.9439> <-0.8825, 2.1014, 2.0443> <-0.1640, 2.1123, 2.2047> <0.3832, 2.1390, 2.2355>
		<-1.4118, 2.3216, 1.9405> <-0.8727, 2.3407, 2.0409> <-0.1632, 2.3407, 2.2141> <0.3840, 2.3674, 2.2449>
		<-1.3475, 2.6813, 2.0098> <-0.8290, 2.7326, 2.1379> <-0.1393, 2.6415, 2.2289> <0.3939, 2.6763, 2.2770>
		<-1.3626, 2.8751, 1.8698> <-0.8441, 2.9264, 1.9979> <-0.1454, 2.8662, 2.1873> <0.3879, 2.9009, 2.2355>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3832, 2.1390, 2.2355> <0.9934, 2.1688, 2.2698> <1.8187, 2.2252, 2.2793> <2.4172, 2.2698, 2.1601>
		<0.3840, 2.3674, 2.2449> <0.9942, 2.3972, 2.2793> <1.8368, 2.4798, 2.2960> <2.4353, 2.5244, 2.1768>
		<0.3939, 2.6763, 2.2770> <1.0011, 2.7158, 2.3319> <1.8168, 2.7811, 2.3412> <2.4118, 2.8660, 2.2314>
		<0.3879, 2.9009, 2.2355> <0.9950, 2.9405, 2.2903> <1.8173, 3.0360, 2.3206> <2.4122, 3.1210, 2.2107>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4172, 2.2698, 2.1601> <2.6153, 2.2845, 2.1207> <2.8746, 2.3203, 1.9217> <2.9323, 2.3289, 1.7278>
		<2.4353, 2.5244, 2.1768> <2.6334, 2.5392, 2.1374> <2.8941, 2.5996, 1.9353> <2.9519, 2.6082, 1.7413>
		<2.4118, 2.8660, 2.2314> <2.6127, 2.8947, 2.1943> <2.8907, 2.9624, 2.0022> <2.9464, 2.9858, 1.8049>
		<2.4122, 3.1210, 2.2107> <2.6132, 3.1497, 2.1737> <2.8638, 3.2391, 1.9655> <2.9194, 3.2624, 1.7682>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9323, 2.3289, 1.7278> <3.0795, 2.3509, 1.2339> <3.0567, 2.3653, 0.5291> <3.0567, 2.3653, 0.0133>
		<2.9519, 2.6082, 1.7413> <3.0990, 2.6302, 1.2475> <3.0754, 2.6699, 0.5270> <3.0754, 2.6699, 0.0112>
		<2.9464, 2.9858, 1.8049> <3.0902, 3.0460, 1.2952> <3.0633, 3.0784, 0.5369> <3.0633, 3.0784, 0.0039>
		<2.9194, 3.2624, 1.7682> <3.0633, 3.3226, 1.2585> <3.0363, 3.3823, 0.5325> <3.0363, 3.3823, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0567, 2.3653, 0.0133> <3.0567, 2.3653, -0.5070> <3.0798, 2.3509, -1.2176> <2.9323, 2.3289, -1.7161>
		<3.0754, 2.6699, 0.0112> <3.0754, 2.6699, -0.5091> <3.0993, 2.6303, -1.2312> <2.9519, 2.6082, -1.7297>
		<3.0633, 3.0784, 0.0039> <3.0633, 3.0784, -0.5253> <3.0900, 3.0454, -1.2836> <2.9464, 2.9853, -1.7894>
		<3.0363, 3.3823, -0.0005> <3.0363, 3.3823, -0.5297> <3.0630, 3.3225, -1.2508> <2.9194, 3.2624, -1.7566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9323, 2.3289, -1.7161> <2.8749, 2.3203, -1.9101> <2.6153, 2.2845, -2.1090> <2.4172, 2.2698, -2.1485>
		<2.9519, 2.6082, -1.7297> <2.8944, 2.5997, -1.9237> <2.6334, 2.5392, -2.1257> <2.4353, 2.5244, -2.1652>
		<2.9464, 2.9853, -1.7894> <2.8904, 2.9618, -1.9866> <2.6127, 2.8944, -2.1788> <2.4118, 2.8657, -2.2159>
		<2.9194, 3.2624, -1.7566> <2.8635, 3.2389, -1.9538> <2.6132, 3.1497, -2.1621> <2.4122, 3.1210, -2.1992>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4172, 2.2698, -2.1485> <1.8187, 2.2252, -2.2677> <0.9934, 2.1688, -2.2582> <0.3832, 2.1390, -2.2238>
		<2.4353, 2.5244, -2.1652> <1.8368, 2.4798, -2.2844> <0.9942, 2.3972, -2.2676> <0.3840, 2.3674, -2.2333>
		<2.4118, 2.8657, -2.2159> <1.8168, 2.7808, -2.3257> <1.0011, 2.7152, -2.3166> <0.3939, 2.6756, -2.2618>
		<2.4122, 3.1210, -2.1992> <1.8173, 3.0360, -2.3089> <0.9951, 2.9405, -2.2786> <0.3879, 2.9009, -2.2238>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3832, 2.1390, -2.2238> <-0.1640, 2.1123, -2.1930> <-0.8825, 2.1014, -2.0327> <-1.4216, 2.0822, -1.9323>
		<0.3840, 2.3674, -2.2333> <-0.1632, 2.3407, -2.2025> <-0.8727, 2.3407, -2.0293> <-1.4118, 2.3216, -1.9289>
		<0.3939, 2.6756, -2.2618> <-0.1393, 2.6409, -2.2136> <-0.8289, 2.7315, -2.1247> <-1.3474, 2.6802, -1.9968>
		<0.3879, 2.9009, -2.2238> <-0.1454, 2.8662, -2.1757> <-0.8441, 2.9264, -1.9863> <-1.3626, 2.8751, -1.8584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4216, 2.0822, -1.9323> <-1.5783, 2.0767, -1.9031> <-1.7781, 2.0634, -1.8258> <-1.9339, 2.0566, -1.7923>
		<-1.4118, 2.3216, -1.9289> <-1.5685, 2.3160, -1.8997> <-1.7767, 2.2523, -1.8124> <-1.9325, 2.2455, -1.7790>
		<-1.3474, 2.6802, -1.9968> <-1.5310, 2.6620, -1.9515> <-1.7343, 2.5628, -1.8149> <-1.9136, 2.5218, -1.7673>
		<-1.3626, 2.8751, -1.8584> <-1.5462, 2.8570, -1.8131> <-1.7469, 2.7132, -1.7006> <-1.9261, 2.6722, -1.6529>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9339, 2.0566, -1.7923> <-2.0810, 2.0503, -1.7608> <-2.2810, 2.0440, -1.7390> <-2.4298, 2.0386, -1.7161>
		<-1.9325, 2.2455, -1.7790> <-2.0796, 2.2392, -1.7475> <-2.2795, 2.2267, -1.7255> <-2.4283, 2.2213, -1.7026>
		<-1.9136, 2.5218, -1.7673> <-2.0558, 2.4892, -1.7294> <-2.2722, 2.5001, -1.7121> <-2.4207, 2.4883, -1.6893>
		<-1.9261, 2.6722, -1.6529> <-2.0683, 2.6396, -1.6151> <-2.2726, 2.6447, -1.5997> <-2.4210, 2.6330, -1.5769>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9261, 2.6722, -1.6529> <-1.9363, 2.7944, -1.5600> <-1.9899, 2.8372, -1.3333> <-2.0008, 2.8600, -1.1815>
		<-1.7469, 2.7132, -1.7006> <-1.7571, 2.8354, -1.6076> <-1.8332, 2.8814, -1.3519> <-1.8441, 2.9043, -1.2002>
		<-1.5462, 2.8570, -1.8131> <-1.5589, 3.0204, -1.6971> <-1.6308, 2.9864, -1.4009> <-1.6499, 3.0135, -1.2028>
		<-1.3626, 2.8751, -1.8584> <-1.3753, 3.0385, -1.7424> <-1.4792, 3.0414, -1.4302> <-1.4983, 3.0684, -1.2322>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9261, 2.6722, -1.6529> <-2.0683, 2.6396, -1.6151> <-2.2726, 2.6447, -1.5997> <-2.4210, 2.6330, -1.5769>
		<-1.9363, 2.7944, -1.5600> <-2.0785, 2.7618, -1.5222> <-2.2729, 2.7602, -1.5101> <-2.4213, 2.7484, -1.4873>
		<-1.9899, 2.8372, -1.3333> <-2.1157, 2.8016, -1.3183> <-2.3015, 2.7991, -1.2837> <-2.4308, 2.7825, -1.2656>
		<-2.0008, 2.8600, -1.1815> <-2.1266, 2.8244, -1.1665> <-2.3025, 2.8213, -1.1393> <-2.4317, 2.8047, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9261, 2.6722, 1.6640> <-1.9365, 2.7960, 1.5679> <-1.9897, 2.8368, 1.3359> <-2.0008, 2.8600, 1.1809>
		<-2.0683, 2.6396, 1.6262> <-2.0786, 2.7635, 1.5301> <-2.1156, 2.8013, 1.3209> <-2.1266, 2.8244, 1.1659>
		<-2.2726, 2.6447, 1.6111> <-2.2729, 2.7620, 1.5180> <-2.3015, 2.7987, 1.2863> <-2.3025, 2.8213, 1.1384>
		<-2.4210, 2.6330, 1.5884> <-2.4213, 2.7502, 1.4953> <-2.4307, 2.7821, 1.2681> <-2.4317, 2.8047, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9261, 2.6722, 1.6640> <-1.7468, 2.7132, 1.7117> <-1.5462, 2.8570, 1.8245> <-1.3626, 2.8751, 1.8698>
		<-1.9365, 2.7960, 1.5679> <-1.7572, 2.8371, 1.6156> <-1.5591, 3.0222, 1.7051> <-1.3754, 3.0403, 1.7505>
		<-1.9897, 2.8368, 1.3359> <-1.8330, 2.8811, 1.3546> <-1.6306, 2.9861, 1.4036> <-1.4790, 3.0411, 1.4329>
		<-2.0008, 2.8600, 1.1809> <-1.8441, 2.9043, 1.1996> <-1.6500, 3.0135, 1.2022> <-1.4983, 3.0684, 1.2314>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 2.8047, -1.1212> <-2.4340, 2.8558, -0.7882> <-2.4317, 2.8752, -0.3374> <-2.4317, 2.8752, -0.0005>
		<-2.3025, 2.8213, -1.1393> <-2.3047, 2.8724, -0.8063> <-2.3157, 2.8888, -0.3373> <-2.3157, 2.8888, -0.0005>
		<-2.1266, 2.8244, -1.1665> <-2.1518, 2.8771, -0.8163> <-2.1573, 2.8886, -0.3554> <-2.1573, 2.8886, -0.0003>
		<-2.0008, 2.8600, -1.1815> <-2.0260, 2.9126, -0.8313> <-2.0449, 2.9206, -0.3554> <-2.0449, 2.9206, -0.0003>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0008, 2.8600, -1.1815> <-2.0260, 2.9126, -0.8313> <-2.0449, 2.9206, -0.3554> <-2.0449, 2.9206, -0.0003>
		<-1.8441, 2.9043, -1.2002> <-1.8693, 2.9569, -0.8499> <-1.8880, 2.9654, -0.3554> <-1.8880, 2.9654, -0.0003>
		<-1.6499, 3.0135, -1.2028> <-1.6853, 3.0634, -0.8377> <-1.6959, 3.0736, -0.3706> <-1.6959, 3.0736, -0.0003>
		<-1.4983, 3.0684, -1.2322> <-1.5337, 3.1183, -0.8671> <-1.5425, 3.1291, -0.3706> <-1.5425, 3.1291, -0.0004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 2.8752, -0.0005> <-2.4317, 2.8752, 0.3363> <-2.4340, 2.8554, 0.7871> <-2.4317, 2.8047, 1.1201>
		<-2.3157, 2.8888, -0.0005> <-2.3157, 2.8888, 0.3364> <-2.3047, 2.8720, 0.8053> <-2.3025, 2.8213, 1.1384>
		<-2.1573, 2.8886, -0.0003> <-2.1573, 2.8886, 0.3548> <-2.1516, 2.8767, 0.8156> <-2.1266, 2.8244, 1.1659>
		<-2.0449, 2.9206, -0.0003> <-2.0449, 2.9206, 0.3548> <-2.0258, 2.9123, 0.8306> <-2.0008, 2.8600, 1.1809>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0449, 2.9206, -0.0003> <-2.0449, 2.9206, 0.3548> <-2.0258, 2.9123, 0.8306> <-2.0008, 2.8600, 1.1809>
		<-1.8880, 2.9654, -0.0003> <-1.8880, 2.9654, 0.3548> <-1.8691, 2.9566, 0.8493> <-1.8441, 2.9043, 1.1996>
		<-1.6959, 3.0736, -0.0003> <-1.6959, 3.0736, 0.3699> <-1.6851, 3.0631, 0.8369> <-1.6500, 3.0135, 1.2022>
		<-1.5425, 3.1291, -0.0004> <-1.5425, 3.1291, 0.3698> <-1.5335, 3.1180, 0.8662> <-1.4983, 3.0684, 1.2314>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9718, 3.3201, -0.0005> <2.9755, 3.3467, -0.0005> <3.0339, 3.4091, -0.0009> <3.0363, 3.3823, -0.0005>
		<2.9718, 3.3201, -0.4859> <2.9755, 3.3467, -0.4859> <3.0339, 3.4091, -0.5301> <3.0363, 3.3823, -0.5297>
		<2.9688, 3.2697, -1.1434> <2.9759, 3.3180, -1.1567> <3.0581, 3.3725, -1.2449> <3.0630, 3.3225, -1.2508>
		<2.8454, 3.2225, -1.6104> <2.8524, 3.2708, -1.6237> <2.9146, 3.3124, -1.7507> <2.9194, 3.2624, -1.7566>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9718, 3.3201, -0.0005> <2.9718, 3.3201, -0.4859> <2.9688, 3.2697, -1.1434> <2.8454, 3.2225, -1.6104>
		<2.9417, 3.1018, -0.0005> <2.9417, 3.1018, -0.4859> <2.9381, 3.0586, -1.0850> <2.8147, 3.0114, -1.5520>
		<2.9473, 2.8064, -0.0005> <2.9473, 2.8064, -0.4655> <2.9594, 2.7549, -1.1139> <2.8287, 2.7089, -1.5577>
		<2.9267, 2.5870, -0.0005> <2.9267, 2.5870, -0.4655> <2.9377, 2.5353, -1.0990> <2.8069, 2.4893, -1.5429>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9718, 3.3201, -0.0005> <2.9417, 3.1018, -0.0005> <2.9473, 2.8064, -0.0005> <2.9267, 2.5870, -0.0005>
		<2.9718, 3.3201, 0.4848> <2.9417, 3.1018, 0.4848> <2.9473, 2.8064, 0.4645> <2.9267, 2.5870, 0.4645>
		<2.9688, 3.2697, 1.1423> <2.9382, 3.0595, 1.0808> <2.9594, 2.7549, 1.1128> <2.9377, 2.5353, 1.0979>
		<2.8454, 3.2225, 1.6093> <2.8148, 3.0123, 1.5478> <2.8287, 2.7089, 1.5567> <2.8069, 2.4893, 1.5418>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9718, 3.3201, -0.0005> <2.9718, 3.3201, 0.4848> <2.9688, 3.2697, 1.1423> <2.8454, 3.2225, 1.6093>
		<2.9755, 3.3467, -0.0005> <2.9755, 3.3467, 0.4848> <2.9763, 3.3209, 1.1573> <2.8529, 3.2737, 1.6243>
		<3.0339, 3.4091, -0.0009> <3.0339, 3.4091, 0.5321> <3.0581, 3.3758, 1.2515> <2.9143, 3.3156, 1.7612>
		<3.0363, 3.3823, -0.0005> <3.0363, 3.3823, 0.5325> <3.0633, 3.3226, 1.2585> <2.9194, 3.2624, 1.7682>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8454, 3.2225, 1.6093> <2.8148, 3.0123, 1.5478> <2.8287, 2.7089, 1.5567> <2.8069, 2.4893, 1.5418>
		<2.7955, 3.2034, 1.7982> <2.7649, 2.9932, 1.7367> <2.7722, 2.6891, 1.7483> <2.7504, 2.4695, 1.7335>
		<2.6100, 3.1324, 2.0551> <2.5882, 2.9198, 1.9960> <2.5623, 2.6180, 1.9868> <2.5323, 2.3991, 1.9671>
		<2.4188, 3.1086, 2.0923> <2.3969, 2.8959, 2.0332> <2.3661, 2.5980, 2.0242> <2.3360, 2.3792, 2.0045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8454, 3.2225, 1.6093> <2.7955, 3.2034, 1.7982> <2.6100, 3.1324, 2.0551> <2.4188, 3.1086, 2.0923>
		<2.8529, 3.2737, 1.6243> <2.8030, 3.2547, 1.8132> <2.6136, 3.1667, 2.0646> <2.4223, 3.1429, 2.1018>
		<2.9143, 3.3156, 1.7612> <2.8586, 3.2923, 1.9585> <2.6133, 3.1854, 2.1708> <2.4123, 3.1567, 2.2079>
		<2.9194, 3.2624, 1.7682> <2.8638, 3.2391, 1.9655> <2.6132, 3.1497, 2.1737> <2.4122, 3.1210, 2.2107>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4188, 3.1086, 2.0923> <2.3969, 2.8959, 2.0332> <2.3661, 2.5980, 2.0242> <2.3360, 2.3792, 2.0045>
		<1.8150, 3.0334, 2.2097> <1.7931, 2.8208, 2.1506> <1.7904, 2.5395, 2.1338> <1.7603, 2.3206, 2.1142>
		<0.9785, 2.9520, 2.1469> <0.9754, 2.7604, 2.0797> <0.9617, 2.4501, 2.0769> <0.9641, 2.2481, 2.0567>
		<0.3624, 2.9134, 2.0923> <0.3594, 2.7218, 2.0251> <0.3751, 2.4444, 2.0247> <0.3775, 2.2424, 2.0045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4188, 3.1086, 2.0923> <1.8150, 3.0334, 2.2097> <0.9785, 2.9520, 2.1469> <0.3624, 2.9134, 2.0923>
		<2.4223, 3.1429, 2.1018> <1.8185, 3.0677, 2.2193> <0.9791, 2.9933, 2.1614> <0.3631, 2.9547, 2.1068>
		<2.4123, 3.1567, 2.2079> <1.8174, 3.0717, 2.3177> <0.9939, 2.9835, 2.2824> <0.3867, 2.9440, 2.2275>
		<2.4122, 3.1210, 2.2107> <1.8173, 3.0360, 2.3206> <0.9950, 2.9405, 2.2903> <0.3879, 2.9009, 2.2355>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3624, 2.9134, 2.0923> <0.3594, 2.7218, 2.0251> <0.3751, 2.4444, 2.0247> <0.3775, 2.2424, 2.0045>
		<-0.1175, 2.8833, 2.0497> <-0.1205, 2.6917, 1.9826> <-0.0859, 2.4399, 1.9836> <-0.0835, 2.2379, 1.9635>
		<-0.7739, 2.8453, 1.9658> <-0.7108, 2.7013, 1.9186> <-0.7233, 2.4611, 1.8988> <-0.7101, 2.2983, 1.8834>
		<-1.2138, 2.8808, 1.7703> <-1.1508, 2.7369, 1.7231> <-1.1439, 2.5082, 1.7115> <-1.1307, 2.3454, 1.6961>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3624, 2.9134, 2.0923> <-0.1175, 2.8833, 2.0497> <-0.7739, 2.8453, 1.9658> <-1.2138, 2.8808, 1.7703>
		<0.3631, 2.9547, 2.1068> <-0.1169, 2.9246, 2.0642> <-0.7945, 2.8924, 1.9812> <-1.2344, 2.9280, 1.7858>
		<0.3867, 2.9440, 2.2275> <-0.1465, 2.9093, 2.1794> <-0.7995, 2.9281, 1.9680> <-1.3180, 2.8769, 1.8400>
		<0.3879, 2.9009, 2.2355> <-0.1454, 2.8662, 2.1873> <-0.8441, 2.9264, 1.9979> <-1.3626, 2.8751, 1.8698>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3624, 2.9134, -2.0933> <0.3630, 2.9514, -2.1059> <0.3868, 2.9404, -2.2172> <0.3879, 2.9009, -2.2238>
		<-0.1175, 2.8833, -2.0508> <-0.1169, 2.9213, -2.0634> <-0.1464, 2.9057, -2.1690> <-0.1454, 2.8662, -2.1757>
		<-0.7739, 2.8453, -1.9668> <-0.7938, 2.8909, -1.9807> <-0.7994, 2.9281, -1.9602> <-0.8441, 2.9264, -1.9863>
		<-1.2138, 2.8808, -1.7714> <-1.2338, 2.9265, -1.7853> <-1.3180, 2.8769, -1.8323> <-1.3626, 2.8751, -1.8584>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3624, 2.9134, -2.0933> <-0.1175, 2.8833, -2.0508> <-0.7739, 2.8453, -1.9668> <-1.2138, 2.8808, -1.7714>
		<0.3594, 2.7206, -2.0295> <-0.1205, 2.6905, -1.9869> <-0.7105, 2.7005, -1.9227> <-1.1504, 2.7361, -1.7273>
		<0.3751, 2.4444, -2.0257> <-0.0859, 2.4399, -1.9847> <-0.7233, 2.4611, -1.8999> <-1.1439, 2.5082, -1.7126>
		<0.3775, 2.2424, -2.0056> <-0.0835, 2.2379, -1.9646> <-0.7101, 2.2983, -1.8844> <-1.1307, 2.3454, -1.6971>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3624, 2.9134, -2.0933> <0.9785, 2.9520, -2.1479> <1.8150, 3.0334, -2.2108> <2.4188, 3.1086, -2.0933>
		<0.3630, 2.9514, -2.1059> <0.9791, 2.9900, -2.1605> <1.8181, 3.0643, -2.2188> <2.4219, 3.1394, -2.1014>
		<0.3868, 2.9404, -2.2172> <0.9940, 2.9800, -2.2720> <1.8173, 3.0680, -2.3068> <2.4123, 3.1529, -2.1971>
		<0.3879, 2.9009, -2.2238> <0.9951, 2.9405, -2.2786> <1.8173, 3.0360, -2.3089> <2.4122, 3.1210, -2.1992>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3624, 2.9134, -2.0933> <0.3594, 2.7206, -2.0295> <0.3751, 2.4444, -2.0257> <0.3775, 2.2424, -2.0056>
		<0.9785, 2.9520, -2.1479> <0.9754, 2.7593, -2.0841> <0.9617, 2.4501, -2.0779> <0.9641, 2.2481, -2.0578>
		<1.8150, 3.0334, -2.2108> <1.7930, 2.8199, -2.1550> <1.7904, 2.5395, -2.1349> <1.7603, 2.3206, -2.1152>
		<2.4188, 3.1086, -2.0933> <2.3968, 2.8950, -2.0376> <2.3661, 2.5980, -2.0252> <2.3360, 2.3792, -2.0056>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8454, 3.2225, -1.6104> <2.8524, 3.2708, -1.6237> <2.9146, 3.3124, -1.7507> <2.9194, 3.2624, -1.7566>
		<2.7955, 3.2034, -1.7993> <2.8025, 3.2517, -1.8126> <2.8586, 3.2890, -1.9479> <2.8635, 3.2389, -1.9538>
		<2.6100, 3.1324, -2.0561> <2.6132, 3.1632, -2.0642> <2.6132, 3.1816, -2.1600> <2.6132, 3.1497, -2.1621>
		<2.4188, 3.1086, -2.0933> <2.4219, 3.1394, -2.1014> <2.4123, 3.1529, -2.1971> <2.4122, 3.1210, -2.1992>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8454, 3.2225, -1.6104> <2.7955, 3.2034, -1.7993> <2.6100, 3.1324, -2.0561> <2.4188, 3.1086, -2.0933>
		<2.8147, 3.0114, -1.5520> <2.7647, 2.9923, -1.7409> <2.5881, 2.9189, -2.0004> <2.3968, 2.8950, -2.0376>
		<2.8287, 2.7089, -1.5577> <2.7722, 2.6891, -1.7494> <2.5623, 2.6180, -1.9879> <2.3661, 2.5980, -2.0252>
		<2.8069, 2.4893, -1.5429> <2.7504, 2.4695, -1.7345> <2.5323, 2.3991, -1.9682> <2.3360, 2.3792, -2.0056>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3626, 2.8751, -1.8584> <-1.3753, 3.0385, -1.7424> <-1.4792, 3.0414, -1.4302> <-1.4983, 3.0684, -1.2322>
		<-1.3180, 2.8769, -1.8323> <-1.3307, 3.0402, -1.7163> <-1.4584, 3.0489, -1.4343> <-1.4775, 3.0760, -1.2363>
		<-1.2338, 2.9265, -1.7853> <-1.3887, 2.9390, -1.7165> <-1.4293, 3.0588, -1.4548> <-1.4544, 3.0817, -1.2883>
		<-1.2138, 2.8808, -1.7714> <-1.3687, 2.8933, -1.7026> <-1.4243, 3.0369, -1.4549> <-1.4494, 3.0598, -1.2884>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2138, 2.8808, -1.7714> <-1.3687, 2.8933, -1.7026> <-1.4243, 3.0369, -1.4549> <-1.4494, 3.0598, -1.2884>
		<-1.1504, 2.7361, -1.7273> <-1.3053, 2.7486, -1.6585> <-1.3821, 2.8517, -1.4555> <-1.4071, 2.8747, -1.2890>
		<-1.1439, 2.5082, -1.7126> <-1.2862, 2.5242, -1.6492> <-1.2369, 2.6076, -1.4061> <-1.2599, 2.6004, -1.2514>
		<-1.1307, 2.3454, -1.6971> <-1.2729, 2.3613, -1.6337> <-1.3310, 2.4436, -1.3891> <-1.3541, 2.4364, -1.2344>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4983, 3.0684, -1.2322> <-1.5337, 3.1183, -0.8671> <-1.5425, 3.1291, -0.3706> <-1.5425, 3.1291, -0.0004>
		<-1.4775, 3.0760, -1.2363> <-1.5129, 3.1259, -0.8711> <-1.5249, 3.1354, -0.3706> <-1.5249, 3.1354, -0.0004>
		<-1.4544, 3.0817, -1.2883> <-1.5115, 3.1340, -0.9092> <-1.4838, 3.1432, -0.3875> <-1.4838, 3.1432, -0.0005>
		<-1.4494, 3.0598, -1.2884> <-1.5065, 3.1120, -0.9093> <-1.4804, 3.1249, -0.3875> <-1.4804, 3.1249, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4494, 3.0598, -1.2884> <-1.5065, 3.1120, -0.9093> <-1.4804, 3.1249, -0.3875> <-1.4804, 3.1249, -0.0005>
		<-1.4071, 2.8747, -1.2890> <-1.4642, 2.9269, -0.9099> <-1.4334, 2.8701, -0.3875> <-1.4334, 2.8701, -0.0006>
		<-1.2599, 2.6004, -1.2514> <-1.3149, 2.5833, -0.8821> <-1.2352, 2.4793, -0.3743> <-1.2352, 2.4793, -0.0005>
		<-1.3541, 2.4364, -1.2344> <-1.4091, 2.4193, -0.8651> <-1.3835, 2.2669, -0.3743> <-1.3835, 2.2669, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5425, 3.1291, -0.0004> <-1.5425, 3.1291, 0.3698> <-1.5335, 3.1180, 0.8662> <-1.4983, 3.0684, 1.2314>
		<-1.5249, 3.1354, -0.0004> <-1.5249, 3.1354, 0.3698> <-1.5127, 3.1256, 0.8702> <-1.4776, 3.0760, 1.2354>
		<-1.4838, 3.1432, -0.0005> <-1.4838, 3.1432, 0.3864> <-1.5115, 3.1339, 0.9081> <-1.4544, 3.0817, 1.2873>
		<-1.4804, 3.1249, -0.0005> <-1.4804, 3.1249, 0.3864> <-1.5065, 3.1120, 0.9082> <-1.4494, 3.0598, 1.2874>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4804, 3.1249, -0.0005> <-1.4804, 3.1249, 0.3864> <-1.5065, 3.1120, 0.9082> <-1.4494, 3.0598, 1.2874>
		<-1.4334, 2.8701, -0.0006> <-1.4334, 2.8701, 0.3864> <-1.4642, 2.9269, 0.9088> <-1.4071, 2.8747, 1.2879>
		<-1.2352, 2.4793, -0.0005> <-1.2352, 2.4793, 0.3732> <-1.3149, 2.5833, 0.8811> <-1.2599, 2.6004, 1.2503>
		<-1.3835, 2.2669, -0.0005> <-1.3835, 2.2669, 0.3732> <-1.4091, 2.4193, 0.8641> <-1.3541, 2.4364, 1.2334>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4983, 3.0684, 1.2314> <-1.4790, 3.0411, 1.4329> <-1.3754, 3.0403, 1.7505> <-1.3626, 2.8751, 1.8698>
		<-1.4776, 3.0760, 1.2354> <-1.4582, 3.0486, 1.4369> <-1.3308, 3.0421, 1.7206> <-1.3180, 2.8769, 1.8400>
		<-1.4544, 3.0817, 1.2873> <-1.4293, 3.0587, 1.4538> <-1.3893, 2.9405, 1.7170> <-1.2344, 2.9280, 1.7858>
		<-1.4494, 3.0598, 1.2874> <-1.4243, 3.0369, 1.4538> <-1.3687, 2.8933, 1.7015> <-1.2138, 2.8808, 1.7703>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.4494, 3.0598, 1.2874> <-1.4243, 3.0369, 1.4538> <-1.3687, 2.8933, 1.7015> <-1.2138, 2.8808, 1.7703>
		<-1.4071, 2.8747, 1.2879> <-1.3821, 2.8517, 1.4544> <-1.3057, 2.7494, 1.6543> <-1.1508, 2.7369, 1.7231>
		<-1.2599, 2.6004, 1.2503> <-1.2369, 2.6076, 1.4050> <-1.2862, 2.5242, 1.6482> <-1.1439, 2.5082, 1.7115>
		<-1.3541, 2.4364, 1.2334> <-1.3310, 2.4436, 1.3880> <-1.2729, 2.3613, 1.6327> <-1.1307, 2.3454, 1.6961>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3783, 1.5579, 1.9571> <0.9262, 1.5459, 2.0067> <1.6727, 1.5745, 2.0624> <2.2120, 1.6043, 1.9571>
		<0.3564, 1.2784, 1.9346> <0.9043, 1.2664, 1.9842> <1.6246, 1.2984, 2.0413> <2.1639, 1.3282, 1.9360>
		<0.3279, 0.8661, 2.0121> <0.8624, 0.8818, 2.0631> <1.6611, 0.8630, 2.0973> <2.1870, 0.8960, 1.9931>
		<0.2512, 0.6329, 1.8750> <0.7857, 0.6486, 1.9260> <1.5150, 0.6539, 1.9792> <2.0409, 0.6870, 1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3783, 1.5579, 1.9571> <0.3944, 1.7624, 1.9736> <0.3799, 2.0376, 1.9841> <0.3775, 2.2424, 2.0045>
		<0.9262, 1.5459, 2.0067> <0.9423, 1.7504, 2.0232> <0.9665, 2.0433, 2.0363> <0.9641, 2.2481, 2.0567>
		<1.6727, 1.5745, 2.0624> <1.7131, 1.8062, 2.0801> <1.7283, 2.0879, 2.0933> <1.7603, 2.3206, 2.1142>
		<2.2120, 1.6043, 1.9571> <2.2524, 1.8360, 1.9748> <2.3040, 2.1464, 1.9836> <2.3360, 2.3792, 2.0045>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3783, 1.5579, 1.9571> <0.3564, 1.2784, 1.9346> <0.3279, 0.8661, 2.0121> <0.2512, 0.6329, 1.8750>
		<-0.0785, 1.5678, 1.9158> <-0.1004, 1.2884, 1.8933> <-0.0509, 0.8550, 1.9760> <-0.1275, 0.6217, 1.8389>
		<-0.6976, 1.5493, 1.7936> <-0.6703, 1.2243, 1.7732> <-0.6288, 0.9126, 1.8219> <-0.6310, 0.5992, 1.7292>
		<-1.1161, 1.6771, 1.6559> <-1.0888, 1.3521, 1.6356> <-0.9817, 0.9115, 1.6791> <-0.9838, 0.5981, 1.5865>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3783, 1.5579, 1.9571> <-0.0785, 1.5678, 1.9158> <-0.6976, 1.5493, 1.7936> <-1.1161, 1.6771, 1.6559>
		<0.3944, 1.7624, 1.9736> <-0.0624, 1.7724, 1.9322> <-0.7144, 1.7491, 1.8062> <-1.1329, 1.8769, 1.6685>
		<0.3799, 2.0376, 1.9841> <-0.0811, 2.0331, 1.9431> <-0.6939, 2.0989, 1.8644> <-1.1145, 2.1461, 1.6771>
		<0.3775, 2.2424, 2.0045> <-0.0835, 2.2379, 1.9635> <-0.7101, 2.2983, 1.8834> <-1.1307, 2.3454, 1.6961>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1161, 1.6771, 1.6559> <-1.4123, 1.7676, 1.5585> <-1.7608, 2.1521, 1.4726> <-1.9104, 2.2570, 1.2042>
		<-1.1329, 1.8769, 1.6685> <-1.4291, 1.9674, 1.5710> <-1.7437, 2.3267, 1.4803> <-1.8933, 2.4315, 1.2119>
		<-1.1145, 2.1461, 1.6771> <-1.2568, 2.1620, 1.6138> <-1.4181, 2.2919, 1.3723> <-1.4412, 2.2847, 1.2176>
		<-1.1307, 2.3454, 1.6961> <-1.2729, 2.3613, 1.6327> <-1.3310, 2.4436, 1.3880> <-1.3541, 2.4364, 1.2334>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1161, 1.6771, 1.6559> <-1.0888, 1.3521, 1.6356> <-0.9817, 0.9115, 1.6791> <-0.9838, 0.5981, 1.5865>
		<-1.4123, 1.7676, 1.5585> <-1.3850, 1.4426, 1.5381> <-1.1760, 0.9108, 1.6005> <-1.1782, 0.5974, 1.5078>
		<-1.7608, 2.1521, 1.4726> <-1.8099, 1.6528, 1.4506> <-1.6485, 1.0348, 1.3210> <-1.4525, 0.5728, 1.3400>
		<-1.9104, 2.2570, 1.2042> <-1.9594, 1.7576, 1.1822> <-1.7278, 1.0890, 1.1347> <-1.5318, 0.6270, 1.1537>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2120, 1.6043, 1.9571> <2.4075, 1.6151, 1.9190> <2.6334, 1.6693, 1.6950> <2.6929, 1.6857, 1.5054>
		<2.1639, 1.3282, 1.9360> <2.3594, 1.3390, 1.8978> <2.5731, 1.3902, 1.6788> <2.6326, 1.4066, 1.4892>
		<2.1870, 0.8960, 1.9931> <2.3607, 0.9069, 1.9587> <2.5227, 1.0030, 1.6562> <2.5701, 1.0185, 1.4859>
		<2.0409, 0.6870, 1.8750> <2.2147, 0.6979, 1.8406> <2.3881, 0.7545, 1.6125> <2.4355, 0.7700, 1.4422>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2120, 1.6043, 1.9571> <2.2524, 1.8360, 1.9748> <2.3040, 2.1464, 1.9836> <2.3360, 2.3792, 2.0045>
		<2.4075, 1.6151, 1.9190> <2.4479, 1.8468, 1.9367> <2.5003, 2.1664, 1.9462> <2.5323, 2.3991, 1.9671>
		<2.6334, 1.6693, 1.6950> <2.6847, 1.9072, 1.7088> <2.7264, 2.2275, 1.7171> <2.7504, 2.4695, 1.7335>
		<2.6929, 1.6857, 1.5054> <2.7443, 1.9236, 1.5191> <2.7829, 2.2473, 1.5254> <2.8069, 2.4893, 1.5418>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.6929, 1.6857, 1.5054> <2.8286, 1.7229, 1.0734> <2.8269, 1.7730, 0.4538> <2.8269, 1.7730, -0.0005>
		<2.6326, 1.4066, 1.4892> <2.7683, 1.4438, 1.0572> <2.7681, 1.4934, 0.4538> <2.7681, 1.4934, -0.0005>
		<2.5701, 1.0185, 1.4859> <2.6864, 1.0566, 1.0682> <2.7325, 1.0879, 0.4348> <2.7325, 1.0879, -0.0005>
		<2.4355, 0.7700, 1.4422> <2.5518, 0.8081, 1.0245> <2.5630, 0.8579, 0.4348> <2.5630, 0.8579, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.6929, 1.6857, 1.5054> <2.7443, 1.9236, 1.5191> <2.7829, 2.2473, 1.5254> <2.8069, 2.4893, 1.5418>
		<2.8286, 1.7229, 1.0734> <2.8800, 1.9608, 1.0872> <2.9136, 2.2933, 1.0816> <2.9377, 2.5353, 1.0979>
		<2.8269, 1.7730, 0.4538> <2.8775, 2.0138, 0.4538> <2.9038, 2.3420, 0.4645> <2.9267, 2.5870, 0.4645>
		<2.8269, 1.7730, -0.0005> <2.8775, 2.0138, -0.0005> <2.9038, 2.3420, -0.0005> <2.9267, 2.5870, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8269, 1.7730, -0.0005> <2.8775, 2.0138, -0.0005> <2.9038, 2.3420, -0.0005> <2.9267, 2.5870, -0.0005>
		<2.8269, 1.7730, -0.4548> <2.8775, 2.0138, -0.4548> <2.9038, 2.3420, -0.4655> <2.9267, 2.5870, -0.4655>
		<2.8286, 1.7229, -1.0744> <2.8800, 1.9608, -1.0882> <2.9136, 2.2933, -1.0826> <2.9377, 2.5353, -1.0990>
		<2.6929, 1.6857, -1.5064> <2.7443, 1.9236, -1.5202> <2.7829, 2.2473, -1.5265> <2.8069, 2.4893, -1.5429>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8269, 1.7730, -0.0005> <2.8269, 1.7730, -0.4548> <2.8286, 1.7229, -1.0744> <2.6929, 1.6857, -1.5064>
		<2.7681, 1.4934, -0.0005> <2.7681, 1.4934, -0.4548> <2.7683, 1.4438, -1.0583> <2.6326, 1.4066, -1.4902>
		<2.7325, 1.0879, -0.0005> <2.7325, 1.0879, -0.4358> <2.6864, 1.0566, -1.0692> <2.5701, 1.0185, -1.4870>
		<2.5630, 0.8579, -0.0005> <2.5630, 0.8579, -0.4358> <2.5518, 0.8081, -1.0255> <2.4355, 0.7700, -1.4433>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9104, 2.2570, 1.2042> <-2.0781, 2.3745, 0.9032> <-2.0393, 2.3242, 0.3635> <-2.0393, 2.3242, -0.0005>
		<-1.8933, 2.4315, 1.2119> <-2.0610, 2.5491, 0.9109> <-1.9954, 2.5167, 0.3635> <-1.9954, 2.5167, -0.0005>
		<-1.4412, 2.2847, 1.2176> <-1.4962, 2.2677, 0.8484> <-1.4966, 2.1049, 0.3732> <-1.4966, 2.1049, -0.0005>
		<-1.3541, 2.4364, 1.2334> <-1.4091, 2.4193, 0.8641> <-1.3835, 2.2669, 0.3732> <-1.3835, 2.2669, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9104, 2.2570, 1.2042> <-1.9594, 1.7576, 1.1822> <-1.7278, 1.0890, 1.1347> <-1.5318, 0.6270, 1.1537>
		<-2.0781, 2.3745, 0.9032> <-2.1272, 1.8752, 0.8812> <-1.8685, 1.1851, 0.8042> <-1.6724, 0.7232, 0.8232>
		<-2.0393, 2.3242, 0.3635> <-2.1275, 1.9380, 0.3635> <-1.8788, 1.3894, 0.3712> <-1.6591, 1.0598, 0.3712>
		<-2.0393, 2.3242, -0.0005> <-2.1275, 1.9380, -0.0005> <-1.8788, 1.3894, -0.0005> <-1.6591, 1.0598, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0393, 2.3242, -0.0005> <-2.1275, 1.9380, -0.0005> <-1.8788, 1.3894, -0.0005> <-1.6591, 1.0598, -0.0005>
		<-2.0393, 2.3242, -0.3646> <-2.1275, 1.9380, -0.3646> <-1.8788, 1.3894, -0.3723> <-1.6591, 1.0598, -0.3723>
		<-2.0781, 2.3745, -0.9043> <-2.1272, 1.8752, -0.8823> <-1.8685, 1.1851, -0.8053> <-1.6724, 0.7232, -0.8243>
		<-1.9104, 2.2570, -1.2052> <-1.9594, 1.7576, -1.1832> <-1.7278, 1.0890, -1.1357> <-1.5318, 0.6270, -1.1547>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.0393, 2.3242, -0.0005> <-2.0393, 2.3242, -0.3646> <-2.0781, 2.3745, -0.9043> <-1.9104, 2.2570, -1.2052>
		<-1.9954, 2.5167, -0.0005> <-1.9954, 2.5167, -0.3646> <-2.0610, 2.5491, -0.9120> <-1.8933, 2.4315, -1.2129>
		<-1.4966, 2.1049, -0.0005> <-1.4966, 2.1049, -0.3743> <-1.4962, 2.2677, -0.8494> <-1.4412, 2.2847, -1.2187>
		<-1.3835, 2.2669, -0.0005> <-1.3835, 2.2669, -0.3743> <-1.4091, 2.4193, -0.8651> <-1.3541, 2.4364, -1.2344>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3541, 2.4364, -1.2344> <-1.4412, 2.2847, -1.2187> <-1.8933, 2.4315, -1.2129> <-1.9104, 2.2570, -1.2052>
		<-1.3310, 2.4436, -1.3891> <-1.4181, 2.2919, -1.3734> <-1.7437, 2.3267, -1.4813> <-1.7608, 2.1521, -1.4736>
		<-1.2729, 2.3613, -1.6337> <-1.2568, 2.1620, -1.6148> <-1.4291, 1.9674, -1.5721> <-1.4123, 1.7676, -1.5596>
		<-1.1307, 2.3454, -1.6971> <-1.1145, 2.1461, -1.6782> <-1.1329, 1.8769, -1.6695> <-1.1161, 1.6771, -1.6570>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.9104, 2.2570, -1.2052> <-1.9594, 1.7576, -1.1832> <-1.7278, 1.0890, -1.1357> <-1.5318, 0.6270, -1.1547>
		<-1.7608, 2.1521, -1.4736> <-1.8099, 1.6528, -1.4516> <-1.6485, 1.0348, -1.3221> <-1.4525, 0.5728, -1.3411>
		<-1.4123, 1.7676, -1.5596> <-1.3850, 1.4426, -1.5392> <-1.1760, 0.9108, -1.6015> <-1.1782, 0.5974, -1.5089>
		<-1.1161, 1.6771, -1.6570> <-1.0888, 1.3521, -1.6366> <-0.9817, 0.9115, -1.6802> <-0.9838, 0.5981, -1.5875>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1161, 1.6771, -1.6570> <-0.6976, 1.5493, -1.7947> <-0.0785, 1.5678, -1.9168> <0.3783, 1.5579, -1.9582>
		<-1.1329, 1.8769, -1.6695> <-0.7144, 1.7491, -1.8072> <-0.0624, 1.7724, -1.9333> <0.3944, 1.7624, -1.9746>
		<-1.1145, 2.1461, -1.6782> <-0.6939, 2.0989, -1.8655> <-0.0811, 2.0331, -1.9441> <0.3799, 2.0376, -1.9851>
		<-1.1307, 2.3454, -1.6971> <-0.7101, 2.2983, -1.8844> <-0.0835, 2.2379, -1.9646> <0.3775, 2.2424, -2.0056>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1161, 1.6771, -1.6570> <-1.0888, 1.3521, -1.6366> <-0.9817, 0.9115, -1.6802> <-0.9838, 0.5981, -1.5875>
		<-0.6976, 1.5493, -1.7947> <-0.6703, 1.2243, -1.7743> <-0.6288, 0.9126, -1.8229> <-0.6310, 0.5992, -1.7303>
		<-0.0785, 1.5678, -1.9168> <-0.1004, 1.2884, -1.8944> <-0.0509, 0.8550, -1.9770> <-0.1275, 0.6217, -1.8399>
		<0.3783, 1.5579, -1.9582> <0.3564, 1.2784, -1.9357> <0.3279, 0.8661, -2.0132> <0.2512, 0.6329, -1.8761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3783, 1.5579, -1.9582> <0.9262, 1.5459, -2.0078> <1.6727, 1.5745, -2.0634> <2.2120, 1.6043, -1.9582>
		<0.3944, 1.7624, -1.9746> <0.9423, 1.7504, -2.0242> <1.7131, 1.8062, -2.0812> <2.2524, 1.8360, -1.9759>
		<0.3799, 2.0376, -1.9851> <0.9665, 2.0433, -2.0373> <1.7283, 2.0879, -2.0943> <2.3040, 2.1464, -1.9847>
		<0.3775, 2.2424, -2.0056> <0.9641, 2.2481, -2.0578> <1.7603, 2.3206, -2.1152> <2.3360, 2.3792, -2.0056>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3783, 1.5579, -1.9582> <0.3564, 1.2784, -1.9357> <0.3279, 0.8661, -2.0132> <0.2512, 0.6329, -1.8761>
		<0.9262, 1.5459, -2.0078> <0.9043, 1.2664, -1.9853> <0.8624, 0.8818, -2.0641> <0.7857, 0.6486, -1.9271>
		<1.6727, 1.5745, -2.0634> <1.6246, 1.2984, -2.0423> <1.6611, 0.8630, -2.0984> <1.5150, 0.6539, -1.9803>
		<2.2120, 1.6043, -1.9582> <2.1639, 1.3282, -1.9370> <2.1870, 0.8960, -1.9942> <2.0409, 0.6870, -1.8761>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2120, 1.6043, -1.9582> <2.4075, 1.6151, -1.9200> <2.6334, 1.6693, -1.6960> <2.6929, 1.6857, -1.5064>
		<2.2524, 1.8360, -1.9759> <2.4479, 1.8468, -1.9377> <2.6847, 1.9072, -1.7098> <2.7443, 1.9236, -1.5202>
		<2.3040, 2.1464, -1.9847> <2.5003, 2.1664, -1.9473> <2.7264, 2.2275, -1.7182> <2.7829, 2.2473, -1.5265>
		<2.3360, 2.3792, -2.0056> <2.5323, 2.3991, -1.9682> <2.7504, 2.4695, -1.7345> <2.8069, 2.4893, -1.5429>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2120, 1.6043, -1.9582> <2.1639, 1.3282, -1.9370> <2.1870, 0.8960, -1.9942> <2.0409, 0.6870, -1.8761>
		<2.4075, 1.6151, -1.9200> <2.3594, 1.3390, -1.8989> <2.3607, 0.9069, -1.9598> <2.2147, 0.6979, -1.8416>
		<2.6334, 1.6693, -1.6960> <2.5731, 1.3902, -1.6799> <2.5227, 1.0030, -1.6573> <2.3881, 0.7545, -1.6136>
		<2.6929, 1.6857, -1.5064> <2.6326, 1.4066, -1.4902> <2.5701, 1.0185, -1.4870> <2.4355, 0.7700, -1.4433>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4355, 0.7700, 1.4422> <2.5518, 0.8081, 1.0245> <2.5630, 0.8579, 0.4348> <2.5630, 0.8579, -0.0005>
		<2.3522, 0.6161, 1.4151> <2.4685, 0.6542, 0.9974> <2.4563, 0.7129, 0.4348> <2.4563, 0.7129, -0.0005>
		<2.1657, 0.4630, 1.3055> <2.1657, 0.5363, 0.9213> <2.1785, 0.6733, 0.3906> <2.1785, 0.6733, -0.0005>
		<2.0000, 0.4062, 1.2802> <2.0000, 0.4794, 0.8960> <2.0000, 0.6503, 0.3906> <2.0000, 0.6503, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4355, 0.7700, 1.4422> <2.3522, 0.6161, 1.4151> <2.1657, 0.4630, 1.3055> <2.0000, 0.4062, 1.2802>
		<2.3881, 0.7545, 1.6125> <2.3048, 0.6006, 1.5854> <1.9902, 0.4028, 1.2787> <1.8245, 0.3460, 1.2534>
		<2.2147, 0.6979, 1.8406> <2.0687, 0.4890, 1.7226> <1.6564, 0.4037, 1.5448> <1.5625, 0.4062, 1.2802>
		<2.0409, 0.6870, 1.8750> <1.8950, 0.4781, 1.7570> <1.4689, 0.4037, 1.5448> <1.3750, 0.4062, 1.2802>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0409, 0.6870, 1.8750> <1.8950, 0.4781, 1.7570> <1.4689, 0.4037, 1.5448> <1.3750, 0.4062, 1.2802>
		<1.5150, 0.6539, 1.9792> <1.3691, 0.4451, 1.8612> <1.0564, 0.4037, 1.5448> <0.9625, 0.4062, 1.2802>
		<0.7857, 0.6486, 1.9260> <0.7298, 0.4783, 1.8259> <0.4394, 0.3721, 1.4809> <0.4125, 0.4062, 1.2802>
		<0.2512, 0.6329, 1.8750> <0.1953, 0.4626, 1.7749> <0.0269, 0.3721, 1.4809> <0.0000, 0.4062, 1.2802>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2512, 0.6329, 1.8750> <0.1953, 0.4626, 1.7749> <0.0269, 0.3721, 1.4809> <0.0000, 0.4062, 1.2802>
		<-0.1275, 0.6217, 1.8389> <-0.1835, 0.4514, 1.7388> <-0.3106, 0.3721, 1.4809> <-0.3375, 0.4062, 1.2802>
		<-0.6310, 0.5992, 1.7292> <-0.6318, 0.4876, 1.6962> <-0.7820, 0.3329, 1.4209> <-0.7921, 0.3582, 1.3077>
		<-0.9838, 0.5981, 1.5865> <-0.9846, 0.4864, 1.5535> <-1.1149, 0.3809, 1.3934> <-1.1250, 0.4062, 1.2802>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.5630, 0.8579, -0.0005> <2.5630, 0.8579, -0.4358> <2.5518, 0.8081, -1.0255> <2.4355, 0.7700, -1.4433>
		<2.4563, 0.7129, -0.0005> <2.4563, 0.7129, -0.4358> <2.4685, 0.6542, -0.9984> <2.3522, 0.6161, -1.4162>
		<2.1785, 0.6733, -0.0005> <2.1785, 0.6733, -0.3917> <2.1657, 0.5363, -0.9224> <2.1657, 0.4630, -1.3066>
		<2.0000, 0.6503, -0.0005> <2.0000, 0.6503, -0.3917> <2.0000, 0.4794, -0.8970> <2.0000, 0.4062, -1.2813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4355, 0.7700, -1.4433> <2.3881, 0.7545, -1.6136> <2.2147, 0.6979, -1.8416> <2.0409, 0.6870, -1.8761>
		<2.3522, 0.6161, -1.4162> <2.3048, 0.6006, -1.5865> <2.0687, 0.4890, -1.7236> <1.8950, 0.4781, -1.7581>
		<2.1657, 0.4630, -1.3066> <1.9902, 0.4028, -1.2798> <1.6564, 0.4037, -1.5459> <1.4689, 0.4037, -1.5459>
		<2.0000, 0.4062, -1.2813> <1.8245, 0.3460, -1.2544> <1.5625, 0.4062, -1.2813> <1.3750, 0.4062, -1.2813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0409, 0.6870, -1.8761> <1.5150, 0.6539, -1.9803> <0.7857, 0.6486, -1.9271> <0.2512, 0.6329, -1.8761>
		<1.8950, 0.4781, -1.7581> <1.3691, 0.4451, -1.8623> <0.7298, 0.4783, -1.8270> <0.1953, 0.4626, -1.7760>
		<1.4689, 0.4037, -1.5459> <1.0564, 0.4037, -1.5459> <0.4394, 0.3721, -1.4819> <0.0269, 0.3721, -1.4819>
		<1.3750, 0.4062, -1.2813> <0.9625, 0.4062, -1.2813> <0.4125, 0.4062, -1.2813> <0.0000, 0.4062, -1.2813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.2512, 0.6329, -1.8761> <-0.1275, 0.6217, -1.8399> <-0.6310, 0.5992, -1.7303> <-0.9838, 0.5981, -1.5875>
		<0.1953, 0.4626, -1.7760> <-0.1835, 0.4514, -1.7398> <-0.6318, 0.4876, -1.6973> <-0.9846, 0.4864, -1.5545>
		<0.0269, 0.3721, -1.4819> <-0.3106, 0.3721, -1.4819> <-0.7820, 0.3329, -1.4219> <-1.1149, 0.3809, -1.3944>
		<0.0000, 0.4062, -1.2813> <-0.3375, 0.4062, -1.2813> <-0.7921, 0.3582, -1.3088> <-1.1250, 0.4062, -1.2813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0000, 0.4062, 1.2802> <2.0000, 0.4794, 0.8960> <2.0000, 0.6503, 0.3906> <2.0000, 0.6503, -0.0005>
		<1.8245, 0.3460, 1.2534> <1.8245, 0.4192, 0.8692> <1.8133, 0.6262, 0.3906> <1.8133, 0.6262, -0.0005>
		<1.5625, 0.4062, 1.2802> <1.4305, 0.4097, 0.9085> <1.5611, 0.6765, 0.3940> <1.5611, 0.6765, -0.0005>
		<1.3750, 0.4062, 1.2802> <1.2430, 0.4097, 0.9085> <1.3750, 0.7045, 0.3940> <1.3750, 0.7045, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0000, 0.4062, -1.2813> <1.8245, 0.3460, -1.2544> <1.5625, 0.4062, -1.2813> <1.3750, 0.4062, -1.2813>
		<2.0000, 0.4794, -0.8970> <1.8245, 0.4192, -0.8702> <1.4305, 0.4097, -0.9095> <1.2430, 0.4097, -0.9095>
		<2.0000, 0.6503, -0.3917> <1.8133, 0.6262, -0.3917> <1.5611, 0.6765, -0.3950> <1.3750, 0.7045, -0.3950>
		<2.0000, 0.6503, -0.0005> <1.8133, 0.6262, -0.0005> <1.5611, 0.6765, -0.0005> <1.3750, 0.7045, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3750, 0.4062, -1.2813> <0.9625, 0.4062, -1.2813> <0.4125, 0.4062, -1.2813> <0.0000, 0.4062, -1.2813>
		<1.2430, 0.4097, -0.9095> <0.8305, 0.4097, -0.9095> <0.3578, 0.4755, -0.8731> <-0.0547, 0.4755, -0.8731>
		<1.3750, 0.7045, -0.3950> <0.9606, 0.7669, -0.3950> <0.4171, 0.9101, -0.4181> <0.0000, 0.9514, -0.4181>
		<1.3750, 0.7045, -0.0005> <0.9606, 0.7669, -0.0005> <0.4171, 0.9101, -0.0005> <0.0000, 0.9514, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.3750, 0.4062, 1.2802> <1.2430, 0.4097, 0.9085> <1.3750, 0.7045, 0.3940> <1.3750, 0.7045, -0.0005>
		<0.9625, 0.4062, 1.2802> <0.8305, 0.4097, 0.9085> <0.9606, 0.7669, 0.3940> <0.9606, 0.7669, -0.0005>
		<0.4125, 0.4062, 1.2802> <0.3578, 0.4755, 0.8721> <0.4171, 0.9101, 0.4171> <0.4171, 0.9101, -0.0005>
		<0.0000, 0.4062, 1.2802> <-0.0547, 0.4755, 0.8721> <0.0000, 0.9514, 0.4171> <0.0000, 0.9514, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.4062, -1.2813> <-0.3375, 0.4062, -1.2813> <-0.7921, 0.3582, -1.3088> <-1.1250, 0.4062, -1.2813>
		<-0.0547, 0.4755, -0.8731> <-0.3922, 0.4755, -0.8731> <-0.8282, 0.4488, -0.9026> <-1.1611, 0.4968, -0.8751>
		<0.0000, 0.9514, -0.4181> <-0.3359, 0.9847, -0.4181> <-0.7882, 0.9301, -0.4182> <-1.1250, 0.9521, -0.4182>
		<0.0000, 0.9514, -0.0005> <-0.3359, 0.9847, -0.0005> <-0.7882, 0.9301, -0.0005> <-1.1250, 0.9521, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.4062, 1.2802> <-0.0547, 0.4755, 0.8721> <0.0000, 0.9514, 0.4171> <0.0000, 0.9514, -0.0005>
		<-0.3375, 0.4062, 1.2802> <-0.3922, 0.4755, 0.8721> <-0.3359, 0.9847, 0.4171> <-0.3359, 0.9847, -0.0005>
		<-0.7921, 0.3582, 1.3077> <-0.8282, 0.4488, 0.9016> <-0.7882, 0.9301, 0.4171> <-0.7882, 0.9301, -0.0005>
		<-1.1250, 0.4062, 1.2802> <-1.1611, 0.4968, 0.8741> <-1.1250, 0.9521, 0.4171> <-1.1250, 0.9521, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6591, 1.0598, -0.0005> <-1.6591, 1.0598, 0.3712> <-1.6724, 0.7232, 0.8232> <-1.5318, 0.6270, 1.1537>
		<-1.5685, 0.9237, -0.0005> <-1.5685, 0.9237, 0.3712> <-1.6162, 0.5907, 0.8287> <-1.4756, 0.4946, 1.1591>
		<-1.2881, 0.9628, -0.0005> <-1.2881, 0.9628, 0.4171> <-1.3031, 0.5173, 0.8623> <-1.2670, 0.4267, 1.2685>
		<-1.1250, 0.9521, -0.0005> <-1.1250, 0.9521, 0.4171> <-1.1611, 0.4968, 0.8741> <-1.1250, 0.4062, 1.2802>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.6591, 1.0598, -0.0005> <-1.5685, 0.9237, -0.0005> <-1.2881, 0.9628, -0.0005> <-1.1250, 0.9521, -0.0005>
		<-1.6591, 1.0598, -0.3723> <-1.5685, 0.9237, -0.3723> <-1.2881, 0.9628, -0.4182> <-1.1250, 0.9521, -0.4182>
		<-1.6724, 0.7232, -0.8243> <-1.6162, 0.5907, -0.8297> <-1.3031, 0.5173, -0.8634> <-1.1611, 0.4968, -0.8751>
		<-1.5318, 0.6270, -1.1547> <-1.4756, 0.4946, -1.1601> <-1.2670, 0.4267, -1.2695> <-1.1250, 0.4062, -1.2813>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5318, 0.6270, -1.1547> <-1.4756, 0.4946, -1.1601> <-1.2670, 0.4267, -1.2695> <-1.1250, 0.4062, -1.2813>
		<-1.5318, 0.6270, -1.1547> <-1.3963, 0.4404, -1.3465> <-1.2569, 0.4014, -1.3827> <-1.1149, 0.3809, -1.3944>
		<-1.5318, 0.6270, -1.1547> <-1.3963, 0.4404, -1.3465> <-1.1790, 0.4858, -1.4759> <-0.9846, 0.4864, -1.5545>
		<-1.5318, 0.6270, -1.1547> <-1.4525, 0.5728, -1.3411> <-1.1782, 0.5974, -1.5089> <-0.9838, 0.5981, -1.5875>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.5318, 0.6270, 1.1537> <-1.4525, 0.5728, 1.3400> <-1.1782, 0.5974, 1.5078> <-0.9838, 0.5981, 1.5865>
		<-1.5318, 0.6270, 1.1537> <-1.3963, 0.4404, 1.3455> <-1.1790, 0.4858, 1.4748> <-0.9846, 0.4864, 1.5535>
		<-1.5318, 0.6270, 1.1537> <-1.3963, 0.4404, 1.3455> <-1.2569, 0.4014, 1.3817> <-1.1149, 0.3809, 1.3934>
		<-1.5318, 0.6270, 1.1537> <-1.4756, 0.4946, 1.1591> <-1.2670, 0.4267, 1.2685> <-1.1250, 0.4062, 1.2802>
	}
}

// chrome_plated shield
#declare BODY02=
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4210, 2.6330, -1.5769> <-2.4207, 2.4883, -1.6893> <-2.4283, 2.2213, -1.7026> <-2.4298, 2.0386, -1.7161>
		<-2.4213, 2.7484, -1.4873> <-2.4210, 2.6037, -1.5996> <-2.4286, 2.2206, -1.5241> <-2.4301, 2.0379, -1.5376>
		<-2.4308, 2.7825, -1.2656> <-2.4305, 2.5520, -1.2656> <-2.4309, 2.2671, -1.2996> <-2.4308, 2.0366, -1.2996>
		<-2.4317, 2.8047, -1.1212> <-2.4315, 2.5742, -1.1212> <-2.4310, 2.2668, -1.1212> <-2.4309, 2.0363, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4210, 2.6330, 1.5884> <-2.4213, 2.7502, 1.4953> <-2.4307, 2.7821, 1.2681> <-2.4317, 2.8047, 1.1201>
		<-2.4207, 2.4895, 1.7022> <-2.4210, 2.6067, 1.6092> <-2.4305, 2.5516, 1.2681> <-2.4315, 2.5742, 1.1201>
		<-2.4283, 2.2213, 1.7142> <-2.4286, 2.2206, 1.5319> <-2.4309, 2.2671, 1.3024> <-2.4310, 2.2668, 1.1201>
		<-2.4298, 2.0386, 1.7278> <-2.4301, 2.0379, 1.5455> <-2.4308, 2.0366, 1.3024> <-2.4309, 2.0363, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 2.8752, -0.0005> <-2.4317, 2.8752, -0.3374> <-2.4340, 2.8558, -0.7882> <-2.4317, 2.8047, -1.1212>
		<-2.4315, 2.6235, -0.0005> <-2.4315, 2.6235, -0.3374> <-2.4338, 2.6253, -0.7882> <-2.4315, 2.5742, -1.1212>
		<-2.4310, 2.2880, -0.0005> <-2.4310, 2.2880, -0.3367> <-2.4313, 2.2664, -0.7850> <-2.4310, 2.2668, -1.1212>
		<-2.4309, 2.0363, -0.0005> <-2.4309, 2.0363, -0.3367> <-2.4311, 2.0359, -0.7850> <-2.4309, 2.0363, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 2.8752, -0.0005> <-2.4315, 2.6235, -0.0005> <-2.4310, 2.2880, -0.0005> <-2.4309, 2.0363, -0.0005>
		<-2.4317, 2.8752, 0.3363> <-2.4315, 2.6235, 0.3363> <-2.4310, 2.2880, 0.3357> <-2.4309, 2.0363, 0.3357>
		<-2.4340, 2.8554, 0.7871> <-2.4337, 2.6249, 0.7871> <-2.4313, 2.2664, 0.7839> <-2.4311, 2.0359, 0.7839>
		<-2.4317, 2.8047, 1.1201> <-2.4315, 2.5742, 1.1201> <-2.4310, 2.2668, 1.1201> <-2.4309, 2.0363, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4298, 2.0386, -1.7161> <-2.4314, 1.8431, -1.7305> <-2.4312, 1.5818, -1.6887> <-2.4314, 1.3867, -1.6689>
		<-2.4301, 2.0379, -1.5376> <-2.4318, 1.8424, -1.5521> <-2.4310, 1.5816, -1.5244> <-2.4313, 1.3866, -1.5046>
		<-2.4308, 2.0366, -1.2996> <-2.4307, 1.8415, -1.2996> <-2.4310, 1.5812, -1.2855> <-2.4310, 1.3862, -1.2855>
		<-2.4309, 2.0363, -1.1212> <-2.4308, 1.8413, -1.1212> <-2.4309, 1.5812, -1.1212> <-2.4309, 1.3861, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4314, 1.3867, -1.6689> <-2.4317, 1.1598, -1.6459> <-2.4317, 0.8574, -1.6102> <-2.4317, 0.6322, -1.5736>
		<-2.4313, 1.3866, -1.5046> <-2.4316, 1.1596, -1.4816> <-2.4314, 0.8574, -1.4745> <-2.4315, 0.6322, -1.4379>
		<-2.4310, 1.3862, -1.2855> <-2.4310, 1.1600, -1.2855> <-2.4307, 0.8584, -1.2569> <-2.4307, 0.6322, -1.2569>
		<-2.4309, 1.3861, -1.1212> <-2.4309, 1.1599, -1.1212> <-2.4309, 0.8584, -1.1212> <-2.4309, 0.6322, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 0.6322, -1.5736> <-2.4318, 0.4951, -1.5513> <-2.4317, 0.3158, -1.5030> <-2.4317, 0.1801, -1.4728>
		<-2.4315, 0.6322, -1.4379> <-2.4315, 0.4951, -1.4156> <-2.4315, 0.3158, -1.3975> <-2.4315, 0.1801, -1.3673>
		<-2.4307, 0.6322, -1.2569> <-2.4307, 0.4966, -1.2569> <-2.4312, 0.3158, -1.2266> <-2.4312, 0.1801, -1.2266>
		<-2.4309, 0.6322, -1.1212> <-2.4309, 0.4966, -1.1212> <-2.4309, 0.3158, -1.1212> <-2.4309, 0.1801, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4298, 2.0386, 1.7278> <-2.4301, 2.0379, 1.5455> <-2.4308, 2.0366, 1.3024> <-2.4309, 2.0363, 1.1201>
		<-2.4314, 1.8431, 1.7422> <-2.4318, 1.8424, 1.5599> <-2.4307, 1.8415, 1.3024> <-2.4308, 1.8413, 1.1201>
		<-2.4312, 1.5818, 1.7004> <-2.4310, 1.5816, 1.5322> <-2.4310, 1.5812, 1.2883> <-2.4309, 1.5812, 1.1201>
		<-2.4314, 1.3867, 1.6806> <-2.4313, 1.3866, 1.5125> <-2.4310, 1.3862, 1.2883> <-2.4309, 1.3861, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4314, 1.3867, 1.6806> <-2.4313, 1.3866, 1.5125> <-2.4310, 1.3862, 1.2883> <-2.4309, 1.3861, 1.1201>
		<-2.4317, 1.1598, 1.6576> <-2.4316, 1.1596, 1.4895> <-2.4310, 1.1600, 1.2883> <-2.4309, 1.1599, 1.1201>
		<-2.4317, 0.8574, 1.6220> <-2.4314, 0.8574, 1.4824> <-2.4307, 0.8584, 1.2597> <-2.4309, 0.8584, 1.1201>
		<-2.4317, 0.6322, 1.5854> <-2.4315, 0.6322, 1.4458> <-2.4307, 0.6322, 1.2597> <-2.4309, 0.6322, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 0.6322, 1.5854> <-2.4315, 0.6322, 1.4458> <-2.4307, 0.6322, 1.2597> <-2.4309, 0.6322, 1.1201>
		<-2.4318, 0.4951, 1.5631> <-2.4315, 0.4951, 1.4235> <-2.4307, 0.4966, 1.2597> <-2.4309, 0.4966, 1.1201>
		<-2.4317, 0.3158, 1.5148> <-2.4315, 0.3158, 1.4055> <-2.4312, 0.3158, 1.2295> <-2.4309, 0.3158, 1.1201>
		<-2.4317, 0.1801, 1.4846> <-2.4315, 0.1801, 1.3752> <-2.4312, 0.1801, 1.2295> <-2.4309, 0.1801, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 2.0363, 1.1201> <-2.4311, 2.0359, 0.7839> <-2.4309, 2.0363, 0.3357> <-2.4309, 2.0363, -0.0005>
		<-2.4308, 1.8413, 1.1201> <-2.4310, 1.8408, 0.7839> <-2.4308, 1.8413, 0.3357> <-2.4308, 1.8413, -0.0005>
		<-2.4309, 1.5812, 1.1201> <-2.4308, 1.5811, 0.7839> <-2.4304, 1.5812, 0.3357> <-2.4304, 1.5812, -0.0005>
		<-2.4309, 1.3861, 1.1201> <-2.4308, 1.3860, 0.7839> <-2.4309, 1.3861, 0.3357> <-2.4309, 1.3861, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 2.0363, -1.1212> <-2.4308, 1.8413, -1.1212> <-2.4309, 1.5812, -1.1212> <-2.4309, 1.3861, -1.1212>
		<-2.4311, 2.0359, -0.7850> <-2.4310, 1.8408, -0.7850> <-2.4308, 1.5811, -0.7850> <-2.4308, 1.3860, -0.7850>
		<-2.4309, 2.0363, -0.3367> <-2.4308, 1.8413, -0.3367> <-2.4304, 1.5812, -0.3367> <-2.4309, 1.3861, -0.3367>
		<-2.4309, 2.0363, -0.0005> <-2.4308, 1.8413, -0.0005> <-2.4304, 1.5812, -0.0005> <-2.4309, 1.3861, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 0.1801, -1.1212> <-2.4315, 0.1801, -1.0731> <-2.4322, 0.1801, -1.0091> <-2.4328, 0.1801, -0.9611>
		<-2.4309, 0.3158, -1.1212> <-2.4315, 0.3158, -1.0731> <-2.4322, 0.3158, -1.0091> <-2.4328, 0.3158, -0.9611>
		<-2.4309, 0.4966, -1.1212> <-2.4310, 0.4966, -1.0731> <-2.4322, 0.4982, -1.0302> <-2.4328, 0.4982, -0.9822>
		<-2.4309, 0.6322, -1.1212> <-2.4310, 0.6322, -1.0731> <-2.4322, 0.6322, -1.0091> <-2.4328, 0.6322, -0.9611>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4328, 0.1801, 0.9600> <-2.4322, 0.1801, 1.0080> <-2.4315, 0.1801, 1.0721> <-2.4309, 0.1801, 1.1201>
		<-2.4328, 0.3158, 0.9600> <-2.4322, 0.3158, 1.0080> <-2.4315, 0.3158, 1.0721> <-2.4309, 0.3158, 1.1201>
		<-2.4328, 0.4982, 0.9811> <-2.4322, 0.4982, 1.0291> <-2.4310, 0.4966, 1.0721> <-2.4309, 0.4966, 1.1201>
		<-2.4328, 0.6322, 0.9600> <-2.4322, 0.6322, 1.0080> <-2.4310, 0.6322, 1.0721> <-2.4309, 0.6322, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4328, 0.6322, -0.9611> <-2.4328, 0.8063, -0.9337> <-2.4328, 1.0957, -0.9449> <-2.4328, 1.1973, -0.8010>
		<-2.4322, 0.6322, -1.0091> <-2.4322, 0.8063, -0.9817> <-2.4322, 1.1523, -1.0410> <-2.4322, 1.2540, -0.8970>
		<-2.4310, 0.6322, -1.0731> <-2.4310, 0.8584, -1.0731> <-2.4315, 1.1033, -1.0251> <-2.4315, 1.3295, -1.0251>
		<-2.4309, 0.6322, -1.1212> <-2.4309, 0.8584, -1.1212> <-2.4309, 1.1599, -1.1212> <-2.4309, 1.3861, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4328, 0.6322, 0.9600> <-2.4322, 0.6322, 1.0080> <-2.4310, 0.6322, 1.0721> <-2.4309, 0.6322, 1.1201>
		<-2.4328, 0.8063, 0.9326> <-2.4322, 0.8063, 0.9807> <-2.4310, 0.8584, 1.0721> <-2.4309, 0.8584, 1.1201>
		<-2.4328, 1.0957, 0.9439> <-2.4322, 1.1523, 1.0399> <-2.4315, 1.1033, 1.0241> <-2.4309, 1.1599, 1.1201>
		<-2.4328, 1.1973, 0.7999> <-2.4322, 1.2540, 0.8960> <-2.4315, 1.3295, 1.0241> <-2.4309, 1.3861, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 1.3861, -1.1212> <-2.4315, 1.3295, -1.0251> <-2.4322, 1.2540, -0.8970> <-2.4328, 1.1973, -0.8010>
		<-2.4308, 1.3860, -0.7850> <-2.4314, 1.3294, -0.6889> <-2.4322, 1.3938, -0.6989> <-2.4328, 1.3372, -0.6029>
		<-2.4309, 1.3861, -0.3367> <-2.4310, 1.3634, -0.3367> <-2.4322, 1.3331, -0.2430> <-2.4328, 1.3104, -0.2430>
		<-2.4309, 1.3861, -0.0005> <-2.4310, 1.3634, -0.0005> <-2.4322, 1.3331, -0.0005> <-2.4328, 1.3104, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 1.3861, -0.0005> <-2.4310, 1.3634, -0.0005> <-2.4322, 1.3331, -0.0005> <-2.4328, 1.3104, -0.0005>
		<-2.4309, 1.3861, 0.3357> <-2.4310, 1.3634, 0.3357> <-2.4322, 1.3331, 0.2420> <-2.4328, 1.3104, 0.2420>
		<-2.4308, 1.3860, 0.7839> <-2.4314, 1.3294, 0.6879> <-2.4322, 1.3938, 0.6979> <-2.4328, 1.3372, 0.6018>
		<-2.4309, 1.3861, 1.1201> <-2.4315, 1.3295, 1.0241> <-2.4322, 1.2540, 0.8960> <-2.4328, 1.1973, 0.7999>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4210, 2.6330, -1.5769> <-2.4207, 2.4883, -1.6893> <-2.4283, 2.2213, -1.7026> <-2.4298, 2.0386, -1.7161>
		<-2.4213, 2.7484, -1.4873> <-2.4210, 2.6037, -1.5996> <-2.4286, 2.2206, -1.5241> <-2.4301, 2.0379, -1.5376>
		<-2.4308, 2.7825, -1.2656> <-2.4305, 2.5520, -1.2656> <-2.4309, 2.2671, -1.2996> <-2.4308, 2.0366, -1.2996>
		<-2.4317, 2.8047, -1.1212> <-2.4315, 2.5742, -1.1212> <-2.4310, 2.2668, -1.1212> <-2.4309, 2.0363, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4210, 2.6330, 1.5884> <-2.4213, 2.7502, 1.4953> <-2.4307, 2.7821, 1.2681> <-2.4317, 2.8047, 1.1201>
		<-2.4207, 2.4895, 1.7022> <-2.4210, 2.6067, 1.6092> <-2.4305, 2.5516, 1.2681> <-2.4315, 2.5742, 1.1201>
		<-2.4283, 2.2213, 1.7142> <-2.4286, 2.2206, 1.5319> <-2.4309, 2.2671, 1.3024> <-2.4310, 2.2668, 1.1201>
		<-2.4298, 2.0386, 1.7278> <-2.4301, 2.0379, 1.5455> <-2.4308, 2.0366, 1.3024> <-2.4309, 2.0363, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 2.8752, -0.0005> <-2.4317, 2.8752, -0.3374> <-2.4340, 2.8558, -0.7882> <-2.4317, 2.8047, -1.1212>
		<-2.4315, 2.6235, -0.0005> <-2.4315, 2.6235, -0.3374> <-2.4338, 2.6253, -0.7882> <-2.4315, 2.5742, -1.1212>
		<-2.4310, 2.2880, -0.0005> <-2.4310, 2.2880, -0.3367> <-2.4313, 2.2664, -0.7850> <-2.4310, 2.2668, -1.1212>
		<-2.4309, 2.0363, -0.0005> <-2.4309, 2.0363, -0.3367> <-2.4311, 2.0359, -0.7850> <-2.4309, 2.0363, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 2.8752, -0.0005> <-2.4315, 2.6235, -0.0005> <-2.4310, 2.2880, -0.0005> <-2.4309, 2.0363, -0.0005>
		<-2.4317, 2.8752, 0.3363> <-2.4315, 2.6235, 0.3363> <-2.4310, 2.2880, 0.3357> <-2.4309, 2.0363, 0.3357>
		<-2.4340, 2.8554, 0.7871> <-2.4337, 2.6249, 0.7871> <-2.4313, 2.2664, 0.7839> <-2.4311, 2.0359, 0.7839>
		<-2.4317, 2.8047, 1.1201> <-2.4315, 2.5742, 1.1201> <-2.4310, 2.2668, 1.1201> <-2.4309, 2.0363, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4298, 2.0386, -1.7161> <-2.4314, 1.8431, -1.7305> <-2.4312, 1.5818, -1.6887> <-2.4314, 1.3867, -1.6689>
		<-2.4301, 2.0379, -1.5376> <-2.4318, 1.8424, -1.5521> <-2.4310, 1.5816, -1.5244> <-2.4313, 1.3866, -1.5046>
		<-2.4308, 2.0366, -1.2996> <-2.4307, 1.8415, -1.2996> <-2.4310, 1.5812, -1.2855> <-2.4310, 1.3862, -1.2855>
		<-2.4309, 2.0363, -1.1212> <-2.4308, 1.8413, -1.1212> <-2.4309, 1.5812, -1.1212> <-2.4309, 1.3861, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4314, 1.3867, -1.6689> <-2.4317, 1.1598, -1.6459> <-2.4317, 0.8574, -1.6102> <-2.4317, 0.6322, -1.5736>
		<-2.4313, 1.3866, -1.5046> <-2.4316, 1.1596, -1.4816> <-2.4314, 0.8574, -1.4745> <-2.4315, 0.6322, -1.4379>
		<-2.4310, 1.3862, -1.2855> <-2.4310, 1.1600, -1.2855> <-2.4307, 0.8584, -1.2569> <-2.4307, 0.6322, -1.2569>
		<-2.4309, 1.3861, -1.1212> <-2.4309, 1.1599, -1.1212> <-2.4309, 0.8584, -1.1212> <-2.4309, 0.6322, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 0.6322, -1.5736> <-2.4318, 0.4951, -1.5513> <-2.4317, 0.3158, -1.5030> <-2.4317, 0.1801, -1.4728>
		<-2.4315, 0.6322, -1.4379> <-2.4315, 0.4951, -1.4156> <-2.4315, 0.3158, -1.3975> <-2.4315, 0.1801, -1.3673>
		<-2.4307, 0.6322, -1.2569> <-2.4307, 0.4966, -1.2569> <-2.4312, 0.3158, -1.2266> <-2.4312, 0.1801, -1.2266>
		<-2.4309, 0.6322, -1.1212> <-2.4309, 0.4966, -1.1212> <-2.4309, 0.3158, -1.1212> <-2.4309, 0.1801, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4298, 2.0386, 1.7278> <-2.4301, 2.0379, 1.5455> <-2.4308, 2.0366, 1.3024> <-2.4309, 2.0363, 1.1201>
		<-2.4314, 1.8431, 1.7422> <-2.4318, 1.8424, 1.5599> <-2.4307, 1.8415, 1.3024> <-2.4308, 1.8413, 1.1201>
		<-2.4312, 1.5818, 1.7004> <-2.4310, 1.5816, 1.5322> <-2.4310, 1.5812, 1.2883> <-2.4309, 1.5812, 1.1201>
		<-2.4314, 1.3867, 1.6806> <-2.4313, 1.3866, 1.5125> <-2.4310, 1.3862, 1.2883> <-2.4309, 1.3861, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4314, 1.3867, 1.6806> <-2.4313, 1.3866, 1.5125> <-2.4310, 1.3862, 1.2883> <-2.4309, 1.3861, 1.1201>
		<-2.4317, 1.1598, 1.6576> <-2.4316, 1.1596, 1.4895> <-2.4310, 1.1600, 1.2883> <-2.4309, 1.1599, 1.1201>
		<-2.4317, 0.8574, 1.6220> <-2.4314, 0.8574, 1.4824> <-2.4307, 0.8584, 1.2597> <-2.4309, 0.8584, 1.1201>
		<-2.4317, 0.6322, 1.5854> <-2.4315, 0.6322, 1.4458> <-2.4307, 0.6322, 1.2597> <-2.4309, 0.6322, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4317, 0.6322, 1.5854> <-2.4315, 0.6322, 1.4458> <-2.4307, 0.6322, 1.2597> <-2.4309, 0.6322, 1.1201>
		<-2.4318, 0.4951, 1.5631> <-2.4315, 0.4951, 1.4235> <-2.4307, 0.4966, 1.2597> <-2.4309, 0.4966, 1.1201>
		<-2.4317, 0.3158, 1.5148> <-2.4315, 0.3158, 1.4055> <-2.4312, 0.3158, 1.2295> <-2.4309, 0.3158, 1.1201>
		<-2.4317, 0.1801, 1.4846> <-2.4315, 0.1801, 1.3752> <-2.4312, 0.1801, 1.2295> <-2.4309, 0.1801, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 2.0363, 1.1201> <-2.4311, 2.0359, 0.7839> <-2.4309, 2.0363, 0.3357> <-2.4309, 2.0363, -0.0005>
		<-2.4308, 1.8413, 1.1201> <-2.4310, 1.8408, 0.7839> <-2.4308, 1.8413, 0.3357> <-2.4308, 1.8413, -0.0005>
		<-2.4309, 1.5812, 1.1201> <-2.4308, 1.5811, 0.7839> <-2.4304, 1.5812, 0.3357> <-2.4304, 1.5812, -0.0005>
		<-2.4309, 1.3861, 1.1201> <-2.4308, 1.3860, 0.7839> <-2.4309, 1.3861, 0.3357> <-2.4309, 1.3861, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 2.0363, -1.1212> <-2.4308, 1.8413, -1.1212> <-2.4309, 1.5812, -1.1212> <-2.4309, 1.3861, -1.1212>
		<-2.4311, 2.0359, -0.7850> <-2.4310, 1.8408, -0.7850> <-2.4308, 1.5811, -0.7850> <-2.4308, 1.3860, -0.7850>
		<-2.4309, 2.0363, -0.3367> <-2.4308, 1.8413, -0.3367> <-2.4304, 1.5812, -0.3367> <-2.4309, 1.3861, -0.3367>
		<-2.4309, 2.0363, -0.0005> <-2.4308, 1.8413, -0.0005> <-2.4304, 1.5812, -0.0005> <-2.4309, 1.3861, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 0.1801, -1.1212> <-2.4315, 0.1801, -1.0731> <-2.4322, 0.1801, -1.0091> <-2.4328, 0.1801, -0.9611>
		<-2.4309, 0.3158, -1.1212> <-2.4315, 0.3158, -1.0731> <-2.4322, 0.3158, -1.0091> <-2.4328, 0.3158, -0.9611>
		<-2.4309, 0.4966, -1.1212> <-2.4310, 0.4966, -1.0731> <-2.4322, 0.4982, -1.0302> <-2.4328, 0.4982, -0.9822>
		<-2.4309, 0.6322, -1.1212> <-2.4310, 0.6322, -1.0731> <-2.4322, 0.6322, -1.0091> <-2.4328, 0.6322, -0.9611>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4328, 0.1801, 0.9600> <-2.4322, 0.1801, 1.0080> <-2.4315, 0.1801, 1.0721> <-2.4309, 0.1801, 1.1201>
		<-2.4328, 0.3158, 0.9600> <-2.4322, 0.3158, 1.0080> <-2.4315, 0.3158, 1.0721> <-2.4309, 0.3158, 1.1201>
		<-2.4328, 0.4982, 0.9811> <-2.4322, 0.4982, 1.0291> <-2.4310, 0.4966, 1.0721> <-2.4309, 0.4966, 1.1201>
		<-2.4328, 0.6322, 0.9600> <-2.4322, 0.6322, 1.0080> <-2.4310, 0.6322, 1.0721> <-2.4309, 0.6322, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4328, 0.6322, -0.9611> <-2.4328, 0.8063, -0.9337> <-2.4328, 1.0957, -0.9449> <-2.4328, 1.1973, -0.8010>
		<-2.4322, 0.6322, -1.0091> <-2.4322, 0.8063, -0.9817> <-2.4322, 1.1523, -1.0410> <-2.4322, 1.2540, -0.8970>
		<-2.4310, 0.6322, -1.0731> <-2.4310, 0.8584, -1.0731> <-2.4315, 1.1033, -1.0251> <-2.4315, 1.3295, -1.0251>
		<-2.4309, 0.6322, -1.1212> <-2.4309, 0.8584, -1.1212> <-2.4309, 1.1599, -1.1212> <-2.4309, 1.3861, -1.1212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4328, 0.6322, 0.9600> <-2.4322, 0.6322, 1.0080> <-2.4310, 0.6322, 1.0721> <-2.4309, 0.6322, 1.1201>
		<-2.4328, 0.8063, 0.9326> <-2.4322, 0.8063, 0.9807> <-2.4310, 0.8584, 1.0721> <-2.4309, 0.8584, 1.1201>
		<-2.4328, 1.0957, 0.9439> <-2.4322, 1.1523, 1.0399> <-2.4315, 1.1033, 1.0241> <-2.4309, 1.1599, 1.1201>
		<-2.4328, 1.1973, 0.7999> <-2.4322, 1.2540, 0.8960> <-2.4315, 1.3295, 1.0241> <-2.4309, 1.3861, 1.1201>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 1.3861, -1.1212> <-2.4315, 1.3295, -1.0251> <-2.4322, 1.2540, -0.8970> <-2.4328, 1.1973, -0.8010>
		<-2.4308, 1.3860, -0.7850> <-2.4314, 1.3294, -0.6889> <-2.4322, 1.3938, -0.6989> <-2.4328, 1.3372, -0.6029>
		<-2.4309, 1.3861, -0.3367> <-2.4310, 1.3634, -0.3367> <-2.4322, 1.3331, -0.2430> <-2.4328, 1.3104, -0.2430>
		<-2.4309, 1.3861, -0.0005> <-2.4310, 1.3634, -0.0005> <-2.4322, 1.3331, -0.0005> <-2.4328, 1.3104, -0.0005>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.4309, 1.3861, -0.0005> <-2.4310, 1.3634, -0.0005> <-2.4322, 1.3331, -0.0005> <-2.4328, 1.3104, -0.0005>
		<-2.4309, 1.3861, 0.3357> <-2.4310, 1.3634, 0.3357> <-2.4322, 1.3331, 0.2420> <-2.4328, 1.3104, 0.2420>
		<-2.4308, 1.3860, 0.7839> <-2.4314, 1.3294, 0.6879> <-2.4322, 1.3938, 0.6979> <-2.4328, 1.3372, 0.6018>
		<-2.4309, 1.3861, 1.1201> <-2.4315, 1.3295, 1.0241> <-2.4322, 1.2540, 0.8960> <-2.4328, 1.1973, 0.7999>
	}
}

// seat
#declare BODY03=
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0045, 3.3446, -0.0005> <3.0357, 3.4198, -0.0005> <3.1353, 3.5184, -0.0005> <3.1083, 3.5952, -0.0005>
		<3.0045, 3.3446, 0.5297> <3.0357, 3.4198, 0.5297> <3.1353, 3.5184, 0.5297> <3.1083, 3.5952, 0.5297>
		<3.0302, 3.3071, 1.2524> <3.0613, 3.3823, 1.2524> <3.1686, 3.4920, 1.2559> <3.1416, 3.5688, 1.2559>
		<2.8900, 3.2497, 1.7605> <2.9212, 3.3249, 1.7605> <3.0208, 3.4236, 1.7605> <2.9938, 3.5004, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0045, 3.3446, -0.0005> <3.0045, 3.3446, -0.5307> <3.0302, 3.3071, -1.2534> <2.8900, 3.2497, -1.7615>
		<3.0357, 3.4198, -0.0005> <3.0357, 3.4198, -0.5307> <3.0613, 3.3823, -1.2534> <2.9212, 3.3249, -1.7615>
		<3.1353, 3.5184, -0.0005> <3.1353, 3.5184, -0.5307> <3.1686, 3.4920, -1.2570> <3.0208, 3.4236, -1.7615>
		<3.1083, 3.5952, -0.0005> <3.1083, 3.5952, -0.5307> <3.1416, 3.5688, -1.2570> <2.9938, 3.5004, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1083, 3.5952, -0.0005> <3.0757, 3.6881, -0.0005> <2.9452, 3.7917, -0.0005> <2.8468, 3.7933, -0.0005>
		<3.1083, 3.5952, 0.5297> <3.0757, 3.6881, 0.5297> <2.9452, 3.7917, 0.5297> <2.8468, 3.7933, 0.5297>
		<3.1416, 3.5688, 1.2559> <3.1089, 3.6616, 1.2559> <2.9707, 3.7770, 1.2555> <2.8723, 3.7786, 1.2555>
		<2.9938, 3.5004, 1.7605> <2.9612, 3.5932, 1.7605> <2.8307, 3.6968, 1.7605> <2.7323, 3.6984, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1083, 3.5952, -0.0005> <3.1083, 3.5952, -0.5307> <3.1416, 3.5688, -1.2570> <2.9938, 3.5004, -1.7615>
		<3.0757, 3.6881, -0.0005> <3.0757, 3.6881, -0.5307> <3.1089, 3.6616, -1.2570> <2.9612, 3.5932, -1.7615>
		<2.9452, 3.7917, -0.0005> <2.9452, 3.7917, -0.5307> <2.9707, 3.7770, -1.2565> <2.8307, 3.6968, -1.7615>
		<2.8468, 3.7933, -0.0005> <2.8468, 3.7933, -0.5307> <2.8723, 3.7786, -1.2565> <2.7323, 3.6984, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8468, 3.7933, -0.0005> <2.6580, 3.7965, -0.0005> <2.3139, 3.7853, -0.0005> <2.2450, 3.6096, -0.0005>
		<2.8468, 3.7933, 0.5297> <2.6580, 3.7965, 0.5297> <2.3139, 3.7853, 0.5297> <2.2450, 3.6096, 0.5297>
		<2.8723, 3.7786, 1.2555> <2.6836, 3.7818, 1.2555> <2.2750, 3.7569, 1.2399> <2.2062, 3.5811, 1.2399>
		<2.7323, 3.6984, 1.7605> <2.5435, 3.7016, 1.7605> <2.1994, 3.6905, 1.7605> <2.1305, 3.5147, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8468, 3.7933, -0.0005> <2.8468, 3.7933, -0.5307> <2.8723, 3.7786, -1.2565> <2.7323, 3.6984, -1.7615>
		<2.6580, 3.7965, -0.0005> <2.6580, 3.7965, -0.5307> <2.6836, 3.7818, -1.2565> <2.5435, 3.7016, -1.7615>
		<2.3139, 3.7853, -0.0005> <2.3139, 3.7853, -0.5307> <2.2751, 3.7569, -1.2410> <2.1994, 3.6905, -1.7615>
		<2.2450, 3.6096, -0.0005> <2.2450, 3.6096, -0.5307> <2.2062, 3.5811, -1.2410> <2.1305, 3.5147, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2450, 3.6096, -0.0005> <2.1403, 3.3424, -0.0005> <2.4307, 2.9524, -0.0005> <2.4053, 2.6666, -0.0005>
		<2.2450, 3.6096, 0.5297> <2.1403, 3.3424, 0.5297> <2.4307, 2.9524, 0.5297> <2.4053, 2.6666, 0.5297>
		<2.2062, 3.5811, 1.2399> <2.1015, 3.3140, 1.2399> <2.4264, 2.9096, 1.2482> <2.3947, 2.6245, 1.2433>
		<2.1305, 3.5147, 1.7605> <2.0258, 3.2476, 1.7605> <2.3225, 2.8569, 1.7654> <2.2908, 2.5717, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2450, 3.6096, -0.0005> <2.2450, 3.6096, -0.5307> <2.2062, 3.5811, -1.2410> <2.1305, 3.5147, -1.7615>
		<2.1403, 3.3424, -0.0005> <2.1403, 3.3424, -0.5307> <2.1015, 3.3140, -1.2410> <2.0258, 3.2476, -1.7615>
		<2.4307, 2.9524, -0.0005> <2.4307, 2.9524, -0.5307> <2.4264, 2.9096, -1.2492> <2.3225, 2.8569, -1.7664>
		<2.4053, 2.6666, -0.0005> <2.4053, 2.6666, -0.5307> <2.3947, 2.6245, -1.2443> <2.2908, 2.5717, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4053, 2.6666, -0.0005> <2.3650, 2.2135, -0.0005> <2.4117, 1.4453, -0.0005> <2.0303, 1.1973, -0.0005>
		<2.4053, 2.6666, 0.5297> <2.3650, 2.2135, 0.5297> <2.4117, 1.4453, 0.5180> <2.0303, 1.1973, 0.5180>
		<2.3947, 2.6245, 1.2433> <2.3471, 2.1960, 1.2359> <2.2937, 1.4219, 1.2165> <1.9307, 1.1896, 1.2055>
		<2.2908, 2.5717, 1.7605> <2.2432, 2.1433, 1.7531> <2.2359, 1.4296, 1.7317> <1.8729, 1.1973, 1.7207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4053, 2.6666, -0.0005> <2.4053, 2.6666, -0.5307> <2.3947, 2.6245, -1.2443> <2.2908, 2.5717, -1.7615>
		<2.3650, 2.2135, -0.0005> <2.3650, 2.2135, -0.5307> <2.3471, 2.1960, -1.2370> <2.2432, 2.1433, -1.7542>
		<2.4117, 1.4453, -0.0005> <2.4117, 1.4453, -0.5191> <2.2937, 1.4219, -1.2175> <2.2359, 1.4296, -1.7328>
		<2.0303, 1.1973, -0.0005> <2.0303, 1.1973, -0.5191> <1.9307, 1.1896, -1.2065> <1.8729, 1.1973, -1.7218>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0303, 1.1973, -0.0005> <1.5991, 0.9169, -0.0005> <0.7831, 1.5330, -0.0005> <0.3195, 1.3104, -0.0005>
		<2.0303, 1.1973, 0.5180> <1.5991, 0.9169, 0.5180> <0.7831, 1.5330, 0.5099> <0.3195, 1.3104, 0.5099>
		<1.9307, 1.1896, 1.2055> <1.5372, 0.9378, 1.1936> <0.6493, 1.6286, 1.2125> <0.2362, 1.4101, 1.2072>
		<1.8729, 1.1973, 1.7207> <1.4794, 0.9455, 1.7088> <0.7325, 1.5288, 1.7061> <0.3195, 1.3104, 1.7007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0303, 1.1973, -0.0005> <2.0303, 1.1973, -0.5191> <1.9307, 1.1896, -1.2065> <1.8729, 1.1973, -1.7218>
		<1.5991, 0.9169, -0.0005> <1.5991, 0.9169, -0.5191> <1.5372, 0.9378, -1.1946> <1.4794, 0.9455, -1.7099>
		<0.7831, 1.5330, -0.0005> <0.7831, 1.5330, -0.5109> <0.6493, 1.6286, -1.2136> <0.7325, 1.5288, -1.7071>
		<0.3195, 1.3104, -0.0005> <0.3195, 1.3104, -0.5109> <0.2362, 1.4101, -1.2082> <0.3195, 1.3104, -1.7018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, -0.0005> <0.0667, 1.1890, -0.0005> <0.3195, 0.6562, -0.0005> <0.3195, 0.3758, -0.0005>
		<0.3195, 1.3104, 0.5099> <0.0667, 1.1890, 0.5099> <0.3195, 0.6562, 0.5099> <0.3195, 0.3758, 0.5099>
		<0.2362, 1.4101, 1.2072> <-0.0116, 1.2791, 1.2040> <0.2272, 0.6169, 1.2003> <0.2272, 0.3365, 1.2003>
		<0.3195, 1.3104, 1.7007> <0.0716, 1.1793, 1.6976> <0.3195, 0.6562, 1.7007> <0.3195, 0.3758, 1.7007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, -0.0005> <0.3195, 1.3104, -0.5109> <0.2362, 1.4101, -1.2082> <0.3195, 1.3104, -1.7018>
		<0.0667, 1.1890, -0.0005> <0.0667, 1.1890, -0.5109> <-0.0116, 1.2791, -1.2051> <0.0716, 1.1793, -1.6986>
		<0.3195, 0.6562, -0.0005> <0.3195, 0.6562, -0.5109> <0.2272, 0.6169, -1.2014> <0.3195, 0.6562, -1.7018>
		<0.3195, 0.3758, -0.0005> <0.3195, 0.3758, -0.5109> <0.2272, 0.3365, -1.2014> <0.3195, 0.3758, -1.7018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8900, 3.2497, 1.7605> <2.9212, 3.3249, 1.7605> <3.0208, 3.4236, 1.7605> <2.9938, 3.5004, 1.7605>
		<2.8395, 3.2290, 1.9437> <2.8706, 3.3042, 1.9437> <2.9572, 3.3941, 1.9777> <2.9302, 3.4709, 1.9777>
		<2.5972, 3.1279, 2.1220> <2.6090, 3.1846, 2.1507> <2.6965, 3.2749, 2.2078> <2.6698, 3.3338, 2.2068>
		<2.4104, 3.1013, 2.1531> <2.4222, 3.1580, 2.1819> <2.4764, 3.2314, 2.2500> <2.4497, 3.2903, 2.2490>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9938, 3.5004, 1.7605> <2.9612, 3.5932, 1.7605> <2.8307, 3.6968, 1.7605> <2.7323, 3.6984, 1.7605>
		<2.9302, 3.4709, 1.9777> <2.8976, 3.5638, 1.9777> <2.7780, 3.6666, 1.9504> <2.6796, 3.6683, 1.9504>
		<2.6698, 3.3338, 2.2068> <2.6356, 3.4091, 2.2056> <2.5128, 3.4926, 2.1536> <2.4411, 3.5024, 2.1135>
		<2.4497, 3.2903, 2.2490> <2.4155, 3.3656, 2.2478> <2.3228, 3.4424, 2.1874> <2.2511, 3.4522, 2.1473>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.7323, 3.6984, 1.7605> <2.5435, 3.7016, 1.7605> <2.1994, 3.6905, 1.7605> <2.1305, 3.5147, 1.7605>
		<2.6796, 3.6683, 1.9504> <2.4909, 3.6714, 1.9504> <2.1859, 3.6786, 1.8536> <2.1170, 3.5029, 1.8536>
		<2.4411, 3.5024, 2.1135> <2.3493, 3.5150, 2.0621> <2.0730, 3.4852, 1.9811> <2.0484, 3.3839, 1.9617>
		<2.2511, 3.4522, 2.1473> <2.1593, 3.4648, 2.0959> <1.9827, 3.4590, 1.9933> <1.9581, 3.3577, 1.9739>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1305, 3.5147, 1.7605> <2.0258, 3.2476, 1.7605> <2.3225, 2.8569, 1.7654> <2.2908, 2.5717, 1.7605>
		<2.1170, 3.5029, 1.8536> <2.0123, 3.2357, 1.8536> <2.3015, 2.8462, 1.8700> <2.2698, 2.5611, 1.8651>
		<2.0484, 3.3839, 1.9617> <1.9862, 3.1282, 1.9125> <2.1356, 2.7412, 1.9619> <2.1183, 2.4743, 1.9491>
		<1.9581, 3.3577, 1.9739> <1.8959, 3.1020, 1.9247> <2.0289, 2.7339, 1.9708> <2.0117, 2.4670, 1.9580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2908, 2.5717, 1.7605> <2.2432, 2.1433, 1.7531> <2.2359, 1.4296, 1.7317> <1.8729, 1.1973, 1.7207>
		<2.2698, 2.5611, 1.8651> <2.2221, 2.1327, 1.8578> <2.2305, 1.4303, 1.7801> <1.8675, 1.1981, 1.7691>
		<2.1183, 2.4743, 1.9491> <2.0940, 2.0978, 1.9310> <2.1222, 1.5045, 1.8917> <1.8689, 1.2254, 1.8668>
		<2.0117, 2.4670, 1.9580> <1.9874, 2.0905, 1.9399> <2.0738, 1.5045, 1.8967> <1.8204, 1.2254, 1.8717>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8729, 1.1973, 1.7207> <1.4794, 0.9455, 1.7088> <0.7325, 1.5288, 1.7061> <0.3195, 1.3104, 1.7007>
		<1.8675, 1.1981, 1.7691> <1.4740, 0.9463, 1.7572> <0.7568, 1.4998, 1.8496> <0.3437, 1.2813, 1.8443>
		<1.8689, 1.2254, 1.8668> <1.6218, 0.9533, 1.8425> <0.9202, 1.2642, 1.7523> <0.6055, 1.0729, 1.7550>
		<1.8204, 1.2254, 1.8717> <1.5734, 0.9533, 1.8474> <0.9416, 1.1334, 1.8191> <0.6269, 0.9420, 1.8217>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, 1.7007> <0.0716, 1.1793, 1.6976> <0.3195, 0.6562, 1.7007> <0.3195, 0.3758, 1.7007>
		<0.3437, 1.2813, 1.8443> <0.0959, 1.1503, 1.8411> <0.3422, 0.6658, 1.8238> <0.3422, 0.3855, 1.8238>
		<0.6055, 1.0729, 1.7550> <0.4967, 1.0067, 1.7559> <0.6168, 0.6284, 1.7457> <0.6287, 0.5029, 1.7637>
		<0.6269, 0.9420, 1.8217> <0.5181, 0.8758, 1.8227> <0.6547, 0.6491, 1.8636> <0.6666, 0.5236, 1.8815>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8900, 3.2497, -1.7615> <2.8395, 3.2290, -1.9447> <2.5971, 3.1279, -2.1229> <2.4104, 3.1013, -2.1541>
		<2.9212, 3.3249, -1.7615> <2.8706, 3.3042, -1.9447> <2.6089, 3.1846, -2.1517> <2.4222, 3.1580, -2.1828>
		<3.0208, 3.4236, -1.7615> <2.9572, 3.3941, -1.9787> <2.6965, 3.2749, -2.2087> <2.4764, 3.2314, -2.2509>
		<2.9938, 3.5004, -1.7615> <2.9302, 3.4709, -1.9787> <2.6697, 3.3338, -2.2077> <2.4497, 3.2903, -2.2500>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9938, 3.5004, -1.7615> <2.9302, 3.4709, -1.9787> <2.6697, 3.3338, -2.2077> <2.4497, 3.2903, -2.2500>
		<2.9612, 3.5932, -1.7615> <2.8976, 3.5638, -1.9787> <2.6356, 3.4091, -2.2065> <2.4155, 3.3656, -2.2487>
		<2.8307, 3.6968, -1.7615> <2.7780, 3.6666, -1.9514> <2.5128, 3.4925, -2.1545> <2.3228, 3.4424, -2.1884>
		<2.7323, 3.6984, -1.7615> <2.6796, 3.6683, -1.9514> <2.4411, 3.5024, -2.1144> <2.2511, 3.4522, -2.1483>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.7323, 3.6984, -1.7615> <2.6796, 3.6683, -1.9514> <2.4411, 3.5024, -2.1144> <2.2511, 3.4522, -2.1483>
		<2.5435, 3.7016, -1.7615> <2.4909, 3.6714, -1.9514> <2.3492, 3.5150, -2.0630> <2.1593, 3.4648, -2.0968>
		<2.1994, 3.6905, -1.7615> <2.1859, 3.6786, -1.8546> <2.0730, 3.4852, -1.9821> <1.9827, 3.4590, -1.9943>
		<2.1305, 3.5147, -1.7615> <2.1170, 3.5029, -1.8546> <2.0484, 3.3839, -1.9626> <1.9581, 3.3577, -1.9748>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1305, 3.5147, -1.7615> <2.1170, 3.5029, -1.8546> <2.0484, 3.3839, -1.9626> <1.9581, 3.3577, -1.9748>
		<2.0258, 3.2476, -1.7615> <2.0123, 3.2357, -1.8546> <1.9862, 3.1282, -1.9135> <1.8959, 3.1020, -1.9257>
		<2.3225, 2.8569, -1.7664> <2.3015, 2.8462, -1.8711> <2.1355, 2.7412, -1.9628> <2.0289, 2.7339, -1.9717>
		<2.2908, 2.5717, -1.7615> <2.2698, 2.5611, -1.8662> <2.1183, 2.4743, -1.9500> <2.0117, 2.4670, -1.9589>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2908, 2.5717, -1.7615> <2.2698, 2.5611, -1.8662> <2.1183, 2.4743, -1.9500> <2.0117, 2.4670, -1.9589>
		<2.2432, 2.1433, -1.7542> <2.2221, 2.1327, -1.8588> <2.0940, 2.0978, -1.9320> <1.9874, 2.0905, -1.9409>
		<2.2359, 1.4296, -1.7328> <2.2305, 1.4303, -1.7811> <2.1222, 1.5045, -1.8927> <2.0738, 1.5045, -1.8976>
		<1.8729, 1.1973, -1.7218> <1.8675, 1.1981, -1.7701> <1.8688, 1.2254, -1.8677> <1.8204, 1.2254, -1.8727>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8729, 1.1973, -1.7218> <1.8675, 1.1981, -1.7701> <1.8688, 1.2254, -1.8677> <1.8204, 1.2254, -1.8727>
		<1.4794, 0.9455, -1.7099> <1.4740, 0.9463, -1.7582> <1.6218, 0.9533, -1.8434> <1.5734, 0.9533, -1.8484>
		<0.7325, 1.5288, -1.7071> <0.7568, 1.4998, -1.8507> <0.9202, 1.2642, -1.7532> <0.9416, 1.1334, -1.8200>
		<0.3195, 1.3104, -1.7018> <0.3437, 1.2813, -1.8453> <0.6055, 1.0728, -1.7559> <0.6269, 0.9420, -1.8227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, -1.7018> <0.3437, 1.2813, -1.8453> <0.6055, 1.0728, -1.7559> <0.6269, 0.9420, -1.8227>
		<0.0716, 1.1793, -1.6986> <0.0959, 1.1503, -1.8422> <0.4967, 1.0066, -1.7568> <0.5181, 0.8758, -1.8236>
		<0.3195, 0.6562, -1.7018> <0.3422, 0.6658, -1.8248> <0.6169, 0.6285, -1.7467> <0.6547, 0.6491, -1.8645>
		<0.3195, 0.3758, -1.7018> <0.3422, 0.3855, -1.8248> <0.6288, 0.5030, -1.7646> <0.6666, 0.5236, -1.8825>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4104, 3.1013, 2.1531> <2.4222, 3.1580, 2.1819> <2.4764, 3.2314, 2.2500> <2.4497, 3.2903, 2.2490>
		<1.8107, 3.0159, 2.2531> <1.8225, 3.0726, 2.2819> <1.8698, 3.1114, 2.3663> <1.8431, 3.1703, 2.3653>
		<0.9855, 2.9330, 2.2289> <0.9855, 2.9602, 2.2537> <0.9991, 3.0036, 2.3181> <0.9991, 3.0405, 2.3181>
		<0.3750, 2.8915, 2.1798> <0.3750, 2.9188, 2.2046> <0.3750, 2.9455, 2.2626> <0.3750, 2.9824, 2.2626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4497, 3.2903, 2.2490> <2.4155, 3.3656, 2.2478> <2.3228, 3.4424, 2.1874> <2.2511, 3.4522, 2.1473>
		<1.8431, 3.1703, 2.3653> <1.8089, 3.2456, 2.3641> <1.7757, 3.2979, 2.2847> <1.7040, 3.3077, 2.2446>
		<0.9991, 3.0405, 2.3181> <0.9991, 3.0779, 2.3181> <0.9431, 3.1407, 2.2640> <0.9431, 3.1440, 2.2267>
		<0.3750, 2.9824, 2.2626> <0.3750, 3.0198, 2.2626> <0.3750, 3.0726, 2.2171> <0.3750, 3.0759, 2.1798>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2511, 3.4522, 2.1473> <2.1593, 3.4648, 2.0959> <1.9827, 3.4590, 1.9933> <1.9581, 3.3577, 1.9739>
		<1.7040, 3.3077, 2.2446> <1.6122, 3.3203, 2.1932> <1.5192, 3.3246, 2.0559> <1.4946, 3.2234, 2.0364>
		<0.9431, 3.1440, 2.2267> <0.9431, 3.1491, 2.1683> <0.8562, 3.1213, 2.0573> <0.8562, 3.0671, 2.0351>
		<0.3750, 3.0759, 2.1798> <0.3750, 3.0810, 2.1214> <0.3750, 3.0600, 2.0197> <0.3750, 3.0057, 1.9976>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.9581, 3.3577, 1.9739> <1.8959, 3.1020, 1.9247> <2.0289, 2.7339, 1.9708> <2.0117, 2.4670, 1.9580>
		<1.4946, 3.2234, 2.0364> <1.4325, 2.9676, 1.9873> <1.5405, 2.7005, 2.0115> <1.5233, 2.4336, 1.9987>
		<0.8562, 3.0671, 2.0351> <0.8562, 2.9087, 1.9704> <0.8638, 2.6156, 1.9802> <0.8638, 2.4448, 1.9685>
		<0.3750, 3.0057, 1.9976> <0.3750, 2.8473, 1.9329> <0.3750, 2.6113, 1.9320> <0.3750, 2.4406, 1.9203>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0117, 2.4670, 1.9580> <1.9874, 2.0905, 1.9399> <2.0738, 1.5045, 1.8967> <1.8204, 1.2254, 1.8717>
		<1.5233, 2.4336, 1.9987> <1.4990, 2.0570, 1.9807> <1.6423, 1.5045, 1.9407> <1.3890, 1.2254, 1.9158>
		<0.8638, 2.4448, 1.9685> <0.8638, 2.0725, 1.9430> <0.8075, 1.5747, 1.9178> <0.8075, 1.2016, 1.9060>
		<0.3750, 2.4406, 1.9203> <0.3750, 2.0682, 1.8948> <0.3750, 1.5704, 1.8855> <0.3750, 1.1973, 1.8737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8204, 1.2254, 1.8717> <1.5734, 0.9533, 1.8474> <0.9416, 1.1334, 1.8191> <0.6269, 0.9420, 1.8217>
		<1.3890, 1.2254, 1.9158> <1.1419, 0.9533, 1.8915> <0.9528, 1.0649, 1.8540> <0.6381, 0.8735, 1.8566>
		<0.8075, 1.2016, 1.9060> <0.8075, 1.1338, 1.9039> <0.4521, 1.0377, 1.8827> <0.4521, 0.9699, 1.8827>
		<0.3750, 1.1973, 1.8737> <0.3750, 1.1296, 1.8715> <0.3750, 1.0391, 1.8737> <0.3750, 0.9713, 1.8737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6269, 0.9420, 1.8217> <0.5181, 0.8758, 1.8227> <0.6547, 0.6491, 1.8636> <0.6666, 0.5236, 1.8815>
		<0.6381, 0.8735, 1.8566> <0.5294, 0.8074, 1.8576> <0.6831, 0.6647, 1.9522> <0.6950, 0.5392, 1.9701>
		<0.4521, 0.9699, 1.8827> <0.4521, 0.8004, 1.8827> <0.4672, 0.5821, 1.8925> <0.4672, 0.4126, 1.8925>
		<0.3750, 0.9713, 1.8737> <0.3750, 0.8018, 1.8737> <0.3750, 0.5757, 1.8737> <0.3750, 0.4062, 1.8737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4104, 3.1013, -2.1541> <1.8107, 3.0159, -2.2541> <0.9854, 2.9330, -2.2324> <0.3750, 2.8915, -2.1811>
		<2.4222, 3.1580, -2.1828> <1.8225, 3.0726, -2.2829> <0.9854, 2.9602, -2.2572> <0.3750, 2.9188, -2.2059>
		<2.4764, 3.2314, -2.2509> <1.8698, 3.1114, -2.3673> <0.9989, 3.0036, -2.3216> <0.3750, 2.9455, -2.2639>
		<2.4497, 3.2903, -2.2500> <1.8431, 3.1703, -2.3663> <0.9989, 3.0404, -2.3216> <0.3750, 2.9824, -2.2639>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4497, 3.2903, -2.2500> <1.8431, 3.1703, -2.3663> <0.9989, 3.0404, -2.3216> <0.3750, 2.9824, -2.2639>
		<2.4155, 3.3656, -2.2487> <1.8089, 3.2456, -2.3651> <0.9989, 3.0779, -2.3216> <0.3750, 3.0198, -2.2639>
		<2.3228, 3.4424, -2.1884> <1.7757, 3.2979, -2.2857> <0.9430, 3.1407, -2.2674> <0.3750, 3.0726, -2.2184>
		<2.2511, 3.4522, -2.1483> <1.7041, 3.3077, -2.2456> <0.9430, 3.1439, -2.2301> <0.3750, 3.0759, -2.1811>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2511, 3.4522, -2.1483> <1.7041, 3.3077, -2.2456> <0.9430, 3.1439, -2.2301> <0.3750, 3.0759, -2.1811>
		<2.1593, 3.4648, -2.0968> <1.6122, 3.3203, -2.1942> <0.9430, 3.1491, -2.1717> <0.3750, 3.0810, -2.1228>
		<1.9827, 3.4590, -1.9943> <1.5193, 3.3246, -2.0569> <0.8561, 3.1213, -2.0606> <0.3750, 3.0600, -2.0211>
		<1.9581, 3.3577, -1.9748> <1.4946, 3.2234, -2.0375> <0.8561, 3.0671, -2.0385> <0.3750, 3.0057, -1.9989>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.9581, 3.3577, -1.9748> <1.4946, 3.2234, -2.0375> <0.8561, 3.0671, -2.0385> <0.3750, 3.0057, -1.9989>
		<1.8959, 3.1020, -1.9257> <1.4325, 2.9676, -1.9883> <0.8561, 2.9086, -1.9737> <0.3750, 2.8473, -1.9342>
		<2.0289, 2.7339, -1.9717> <1.5405, 2.7005, -2.0125> <0.8636, 2.6156, -1.9835> <0.3750, 2.6113, -1.9333>
		<2.0117, 2.4670, -1.9589> <1.5233, 2.4336, -1.9997> <0.8636, 2.4448, -1.9718> <0.3750, 2.4406, -1.9216>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0117, 2.4670, -1.9589> <1.5233, 2.4336, -1.9997> <0.8636, 2.4448, -1.9718> <0.3750, 2.4406, -1.9216>
		<1.9874, 2.0905, -1.9409> <1.4990, 2.0570, -1.9817> <0.8636, 2.0725, -1.9463> <0.3750, 2.0682, -1.8961>
		<2.0738, 1.5045, -1.8976> <1.6424, 1.5045, -1.9417> <0.8073, 1.5747, -1.9211> <0.3750, 1.5704, -1.8868>
		<1.8204, 1.2254, -1.8727> <1.3890, 1.2254, -1.9168> <0.8073, 1.2016, -1.9092> <0.3750, 1.1973, -1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8204, 1.2254, -1.8727> <1.3890, 1.2254, -1.9168> <0.8073, 1.2016, -1.9092> <0.3750, 1.1973, -1.8750>
		<1.5734, 0.9533, -1.8484> <1.1419, 0.9533, -1.8925> <0.8073, 1.1338, -1.9071> <0.3750, 1.1296, -1.8728>
		<0.9416, 1.1334, -1.8200> <0.9528, 1.0649, -1.8550> <0.4521, 1.0377, -1.8846> <0.3750, 1.0391, -1.8750>
		<0.6269, 0.9420, -1.8227> <0.6381, 0.8735, -1.8577> <0.4521, 0.9699, -1.8846> <0.3750, 0.9713, -1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6269, 0.9420, -1.8227> <0.6381, 0.8735, -1.8577> <0.4521, 0.9699, -1.8846> <0.3750, 0.9713, -1.8750>
		<0.5181, 0.8758, -1.8236> <0.5293, 0.8074, -1.8586> <0.4521, 0.8004, -1.8846> <0.3750, 0.8018, -1.8750>
		<0.6547, 0.6491, -1.8645> <0.6831, 0.6647, -1.9531> <0.4671, 0.5821, -1.8944> <0.3750, 0.5757, -1.8750>
		<0.6666, 0.5236, -1.8825> <0.6950, 0.5392, -1.9711> <0.4671, 0.4126, -1.8944> <0.3750, 0.4062, -1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.8915, -2.1811> <-0.0945, 2.8596, -2.1417> <-0.7045, 2.8616, -1.9608> <-1.1644, 2.8586, -1.8539>
		<0.3750, 2.9188, -2.2059> <-0.0945, 2.8869, -2.1665> <-0.7186, 2.8889, -1.9782> <-1.1785, 2.8859, -1.8712>
		<0.3750, 2.9455, -2.2639> <-0.1085, 2.9005, -2.2192> <-0.7372, 2.9447, -2.0210> <-1.2114, 2.9142, -1.9117>
		<0.3750, 2.9824, -2.2639> <-0.1085, 2.9374, -2.2192> <-0.7372, 2.9800, -2.0210> <-1.2114, 2.9495, -1.9117>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.9824, -2.2639> <-0.1085, 2.9374, -2.2192> <-0.7372, 2.9800, -2.0210> <-1.2114, 2.9495, -1.9117>
		<0.3750, 3.0198, -2.2639> <-0.1085, 2.9748, -2.2192> <-0.7372, 3.0158, -2.0210> <-1.2114, 2.9853, -1.9117>
		<0.3750, 3.0726, -2.2184> <-0.0922, 3.0166, -2.1782> <-0.7271, 3.0888, -1.9773> <-1.1869, 3.0395, -1.8816>
		<0.3750, 3.0759, -2.1811> <-0.0922, 3.0199, -2.1408> <-0.7046, 3.0923, -1.9496> <-1.1644, 3.0430, -1.8539>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0759, -2.1811> <-0.0922, 3.0199, -2.1408> <-0.7046, 3.0923, -1.9496> <-1.1644, 3.0430, -1.8539>
		<0.3750, 3.0810, -2.1228> <-0.0922, 3.0251, -2.0825> <-0.6711, 3.0975, -1.9083> <-1.1309, 3.0482, -1.8126>
		<0.3750, 3.0600, -2.0211> <-0.0587, 3.0047, -1.9854> <-0.6425, 3.0411, -1.8242> <-1.0732, 3.0221, -1.7436>
		<0.3750, 3.0057, -1.9989> <-0.0587, 2.9505, -1.9633> <-0.6304, 2.9918, -1.8074> <-1.0612, 2.9728, -1.7267>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0057, -1.9989> <-0.0587, 2.9505, -1.9633> <-0.6304, 2.9918, -1.8074> <-1.0612, 2.9728, -1.7267>
		<0.3750, 2.8473, -1.9342> <-0.0587, 2.7920, -1.8986> <-0.5940, 2.8425, -1.7563> <-1.0247, 2.8235, -1.6756>
		<0.3750, 2.6113, -1.9333> <-0.0485, 2.6076, -1.8898> <-0.6035, 2.6023, -1.7366> <-1.0213, 2.6023, -1.6550>
		<0.3750, 2.4406, -1.9216> <-0.0485, 2.4369, -1.8781> <-0.5995, 2.4406, -1.7295> <-1.0173, 2.4406, -1.6478>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.4406, -1.9216> <-0.0485, 2.4369, -1.8781> <-0.5995, 2.4406, -1.7295> <-1.0173, 2.4406, -1.6478>
		<0.3750, 2.0682, -1.8961> <-0.0485, 2.0645, -1.8526> <-0.5903, 2.0681, -1.7129> <-1.0081, 2.0681, -1.6312>
		<0.3750, 1.5704, -1.8868> <-0.0469, 1.5662, -1.8534> <-0.6034, 1.5702, -1.7440> <-1.0173, 1.5702, -1.6557>
		<0.3750, 1.1973, -1.8750> <-0.0469, 1.1932, -1.8415> <-0.6034, 1.1973, -1.7360> <-1.0173, 1.1973, -1.6478>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 1.1973, -1.8750> <-0.0469, 1.1932, -1.8415> <-0.6034, 1.1973, -1.7360> <-1.0173, 1.1973, -1.6478>
		<0.3750, 1.1296, -1.8728> <-0.0469, 1.1254, -1.8394> <-0.6034, 1.1289, -1.7346> <-1.0173, 1.1289, -1.6463>
		<0.3750, 1.0391, -1.8750> <-0.0465, 1.0466, -1.8221> <-0.6018, 1.0390, -1.7153> <-1.0173, 1.0390, -1.6268>
		<0.3750, 0.9713, -1.8750> <-0.0465, 0.9788, -1.8221> <-0.6018, 0.9713, -1.7050> <-1.0173, 0.9713, -1.6164>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 0.9713, -1.8750> <-0.0465, 0.9788, -1.8221> <-0.6018, 0.9713, -1.7050> <-1.0173, 0.9713, -1.6164>
		<0.3750, 0.8018, -1.8750> <-0.0465, 0.8093, -1.8221> <-0.6018, 0.8016, -1.6789> <-1.0173, 0.8016, -1.5903>
		<0.3750, 0.5757, -1.8750> <-0.0453, 0.5464, -1.7861> <-0.5979, 0.5757, -1.6510> <-1.0173, 0.5757, -1.5534>
		<0.3750, 0.4062, -1.8750> <-0.0453, 0.3769, -1.7861> <-0.5979, 0.4062, -1.6240> <-1.0173, 0.4062, -1.5264>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.8915, 2.1798> <0.3750, 2.9188, 2.2046> <0.3750, 2.9455, 2.2626> <0.3750, 2.9824, 2.2626>
		<-0.0939, 2.8597, 2.1421> <-0.0939, 2.8869, 2.1669> <-0.1078, 2.9005, 2.2196> <-0.1078, 2.9374, 2.2196>
		<-0.7044, 2.8616, 1.9686> <-0.7185, 2.8889, 1.9860> <-0.7381, 2.9447, 2.0328> <-0.7381, 2.9799, 2.0328>
		<-1.1644, 2.8586, 1.8655> <-1.1785, 2.8859, 1.8829> <-1.2114, 2.9142, 1.9233> <-1.2114, 2.9495, 1.9233>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.9824, 2.2626> <0.3750, 3.0198, 2.2626> <0.3750, 3.0726, 2.2171> <0.3750, 3.0759, 2.1798>
		<-0.1078, 2.9374, 2.2196> <-0.1078, 2.9749, 2.2196> <-0.0916, 3.0167, 2.1786> <-0.0916, 3.0200, 2.1413>
		<-0.7381, 2.9799, 2.0328> <-0.7381, 3.0158, 2.0328> <-0.7280, 3.0887, 1.9891> <-0.7055, 3.0922, 1.9614>
		<-1.2114, 2.9495, 1.9233> <-1.2114, 2.9853, 1.9233> <-1.1869, 3.0395, 1.8932> <-1.1644, 3.0430, 1.8655>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0759, 2.1798> <0.3750, 3.0810, 2.1214> <0.3750, 3.0600, 2.0197> <0.3750, 3.0057, 1.9976>
		<-0.0916, 3.0200, 2.1413> <-0.0916, 3.0252, 2.0830> <-0.0581, 3.0048, 1.9860> <-0.0581, 2.9505, 1.9638>
		<-0.7055, 3.0922, 1.9614> <-0.6719, 3.0974, 1.9201> <-0.6432, 3.0411, 1.8361> <-0.6312, 2.9918, 1.8192>
		<-1.1644, 3.0430, 1.8655> <-1.1309, 3.0482, 1.8242> <-1.0732, 3.0221, 1.7552> <-1.0612, 2.9728, 1.7384>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0057, 1.9976> <0.3750, 2.8473, 1.9329> <0.3750, 2.6113, 1.9320> <0.3750, 2.4406, 1.9203>
		<-0.0581, 2.9505, 1.9638> <-0.0581, 2.7921, 1.8991> <-0.0479, 2.6076, 1.8903> <-0.0479, 2.4369, 1.8786>
		<-0.6312, 2.9918, 1.8192> <-0.5947, 2.8425, 1.7682> <-0.6036, 2.6023, 1.7446> <-0.5996, 2.4406, 1.7374>
		<-1.0612, 2.9728, 1.7384> <-1.0247, 2.8235, 1.6873> <-1.0213, 2.6023, 1.6666> <-1.0173, 2.4406, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.4406, 1.9203> <0.3750, 2.0682, 1.8948> <0.3750, 1.5704, 1.8855> <0.3750, 1.1973, 1.8737>
		<-0.0479, 2.4369, 1.8786> <-0.0479, 2.0645, 1.8531> <-0.0464, 1.5662, 1.8540> <-0.0464, 1.1932, 1.8421>
		<-0.5996, 2.4406, 1.7374> <-0.5904, 2.0681, 1.7209> <-0.6033, 1.5702, 1.7520> <-0.6033, 1.1973, 1.7441>
		<-1.0173, 2.4406, 1.6594> <-1.0081, 2.0681, 1.6429> <-1.0173, 1.5702, 1.6674> <-1.0173, 1.1973, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 1.1973, 1.8737> <0.3750, 1.1296, 1.8715> <0.3750, 1.0391, 1.8737> <0.3750, 0.9713, 1.8737>
		<-0.0464, 1.1932, 1.8421> <-0.0464, 1.1254, 1.8400> <-0.0462, 1.0466, 1.8240> <-0.0462, 0.9788, 1.8240>
		<-0.6033, 1.1973, 1.7441> <-0.6033, 1.1289, 1.7426> <-0.6018, 1.0390, 1.7234> <-0.6018, 0.9713, 1.7130>
		<-1.0173, 1.1973, 1.6594> <-1.0173, 1.1289, 1.6580> <-1.0173, 1.0390, 1.6384> <-1.0173, 0.9713, 1.6280>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 0.9713, 1.8737> <0.3750, 0.8018, 1.8737> <0.3750, 0.5757, 1.8737> <0.3750, 0.4062, 1.8737>
		<-0.0462, 0.9788, 1.8240> <-0.0462, 0.8093, 1.8240> <-0.0450, 0.5464, 1.7880> <-0.0450, 0.3769, 1.7880>
		<-0.6018, 0.9713, 1.7130> <-0.6018, 0.8016, 1.6870> <-0.5981, 0.5757, 1.6589> <-0.5981, 0.4062, 1.6319>
		<-1.0173, 0.9713, 1.6280> <-1.0173, 0.8016, 1.6020> <-1.0173, 0.5757, 1.5651> <-1.0173, 0.4062, 1.5381>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1644, 2.8586, -1.8539> <-1.1839, 2.8585, -1.8493> <-1.1972, 2.8744, -1.8247> <-1.2113, 2.8812, -1.8122>
		<-1.1785, 2.8859, -1.8712> <-1.1980, 2.8857, -1.8667> <-1.2206, 2.8726, -1.8451> <-1.2347, 2.8794, -1.8327>
		<-1.2114, 2.9142, -1.9117> <-1.2441, 2.9121, -1.9041> <-1.2349, 2.8958, -1.8882> <-1.2582, 2.8735, -1.8788>
		<-1.2114, 2.9495, -1.9117> <-1.2441, 2.9474, -1.9041> <-1.2659, 2.8975, -1.8897> <-1.2892, 2.8753, -1.8803>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2114, 2.9495, -1.9117> <-1.2441, 2.9474, -1.9041> <-1.2659, 2.8975, -1.8897> <-1.2892, 2.8753, -1.8803>
		<-1.2114, 2.9853, -1.9117> <-1.2441, 2.9832, -1.9041> <-1.2945, 2.8991, -1.8912> <-1.3179, 2.8769, -1.8818>
		<-1.1869, 3.0395, -1.8816> <-1.2606, 3.0316, -1.8662> <-1.3016, 2.9276, -1.8574> <-1.3608, 2.8817, -1.8472>
		<-1.1644, 3.0430, -1.8539> <-1.2381, 3.0351, -1.8385> <-1.3026, 2.9357, -1.8299> <-1.3618, 2.8897, -1.8196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1644, 3.0430, -1.8539> <-1.2381, 3.0351, -1.8385> <-1.3026, 2.9357, -1.8299> <-1.3618, 2.8897, -1.8196>
		<-1.1309, 3.0482, -1.8126> <-1.2046, 3.0403, -1.7972> <-1.3042, 2.9488, -1.7853> <-1.3634, 2.9028, -1.7751>
		<-1.0732, 3.0221, -1.7436> <-1.1445, 3.0190, -1.7302> <-1.2434, 2.9837, -1.7155> <-1.3139, 2.9715, -1.7033>
		<-1.0612, 2.9728, -1.7267> <-1.1324, 2.9697, -1.7134> <-1.2256, 2.9444, -1.6982> <-1.2961, 2.9322, -1.6860>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0612, 2.9728, -1.7267> <-1.1324, 2.9697, -1.7134> <-1.2256, 2.9444, -1.6982> <-1.2961, 2.9322, -1.6860>
		<-1.0247, 2.8235, -1.6756> <-1.0960, 2.8204, -1.6623> <-1.1664, 2.8139, -1.6408> <-1.2369, 2.8017, -1.6285>
		<-1.0213, 2.6023, -1.6550> <-1.0635, 2.6023, -1.6467> <-1.1281, 2.5940, -1.6419> <-1.1703, 2.5940, -1.6341>
		<-1.0173, 2.4406, -1.6478> <-1.0595, 2.4406, -1.6395> <-1.1158, 2.4406, -1.6297> <-1.1581, 2.4406, -1.6219>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0173, 2.4406, -1.6478> <-1.0595, 2.4406, -1.6395> <-1.1158, 2.4406, -1.6297> <-1.1581, 2.4406, -1.6219>
		<-1.0081, 2.0681, -1.6312> <-1.0503, 2.0681, -1.6230> <-1.0863, 2.0693, -1.6002> <-1.1285, 2.0693, -1.5924>
		<-1.0173, 1.5702, -1.6557> <-1.0679, 1.5702, -1.6450> <-1.1158, 1.5705, -1.5968> <-1.1581, 1.5705, -1.5669>
		<-1.0173, 1.1973, -1.6478> <-1.0679, 1.1973, -1.6370> <-1.1158, 1.1973, -1.5780> <-1.1581, 1.1973, -1.5481>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0173, 1.1973, -1.6478> <-1.0679, 1.1973, -1.6370> <-1.1158, 1.1973, -1.5780> <-1.1581, 1.1973, -1.5481>
		<-1.0173, 1.1289, -1.6463> <-1.0679, 1.1289, -1.6355> <-1.1158, 1.1296, -1.5746> <-1.1581, 1.1296, -1.5447>
		<-1.0173, 1.0390, -1.6268> <-1.0632, 1.0390, -1.6170> <-1.1158, 1.0391, -1.5711> <-1.1581, 1.0391, -1.5507>
		<-1.0173, 0.9713, -1.6164> <-1.0632, 0.9713, -1.6066> <-1.1158, 0.9713, -1.5686> <-1.1581, 0.9713, -1.5481>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0173, 0.9713, -1.6164> <-1.0632, 0.9713, -1.6066> <-1.1158, 0.9713, -1.5686> <-1.1581, 0.9713, -1.5481>
		<-1.0173, 0.8016, -1.5903> <-1.0632, 0.8016, -1.5806> <-1.1158, 0.8016, -1.5622> <-1.1581, 0.8016, -1.5417>
		<-1.0173, 0.5757, -1.5534> <-1.0585, 0.5757, -1.5438> <-1.1158, 0.5757, -1.5297> <-1.1581, 0.5757, -1.5272>
		<-1.0173, 0.4062, -1.5264> <-1.0585, 0.4062, -1.5168> <-1.1158, 0.4062, -1.5207> <-1.1581, 0.4062, -1.5183>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2113, 2.8812, 1.8243> <-1.1972, 2.8744, 1.8367> <-1.1839, 2.8585, 1.8612> <-1.1644, 2.8586, 1.8655>
		<-1.2347, 2.8794, 1.8403> <-1.2206, 2.8726, 1.8527> <-1.1979, 2.8857, 1.8785> <-1.1785, 2.8859, 1.8829>
		<-1.2609, 2.8737, 1.8791> <-1.2376, 2.8959, 1.8928> <-1.2455, 2.9120, 1.9155> <-1.2114, 2.9142, 1.9233>
		<-1.2892, 2.8753, 1.8777> <-1.2659, 2.8975, 1.8914> <-1.2455, 2.9473, 1.9155> <-1.2114, 2.9495, 1.9233>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2892, 2.8753, 1.8777> <-1.2659, 2.8975, 1.8914> <-1.2455, 2.9473, 1.9155> <-1.2114, 2.9495, 1.9233>
		<-1.3179, 2.8769, 1.8763> <-1.2945, 2.8991, 1.8900> <-1.2455, 2.9831, 1.9155> <-1.2114, 2.9853, 1.9233>
		<-1.3608, 2.8817, 1.8445> <-1.3016, 2.9276, 1.8590> <-1.2613, 3.0315, 1.8777> <-1.1869, 3.0395, 1.8932>
		<-1.3618, 2.8897, 1.8169> <-1.3026, 2.9357, 1.8315> <-1.2388, 3.0350, 1.8500> <-1.1644, 3.0430, 1.8655>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3618, 2.8897, 1.8169> <-1.3026, 2.9357, 1.8315> <-1.2388, 3.0350, 1.8500> <-1.1644, 3.0430, 1.8655>
		<-1.3634, 2.9028, 1.7724> <-1.3042, 2.9488, 1.7870> <-1.2052, 3.0403, 1.8087> <-1.1309, 3.0482, 1.8242>
		<-1.3141, 2.9719, 1.6995> <-1.2436, 2.9841, 1.7160> <-1.1453, 3.0190, 1.7417> <-1.0732, 3.0221, 1.7552>
		<-1.2961, 2.9322, 1.6833> <-1.2256, 2.9444, 1.6998> <-1.1332, 2.9697, 1.7248> <-1.0612, 2.9728, 1.7384>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2961, 2.9322, 1.6833> <-1.2256, 2.9444, 1.6998> <-1.1332, 2.9697, 1.7248> <-1.0612, 2.9728, 1.7384>
		<-1.2365, 2.8008, 1.6298> <-1.1660, 2.8130, 1.6463> <-1.0968, 2.8204, 1.6737> <-1.0247, 2.8235, 1.6873>
		<-1.1702, 2.5936, 1.6449> <-1.1280, 2.5936, 1.6525> <-1.0635, 2.6023, 1.6588> <-1.0213, 2.6023, 1.6666>
		<-1.1581, 2.4406, 1.6340> <-1.1158, 2.4406, 1.6416> <-1.0595, 2.4406, 1.6516> <-1.0173, 2.4406, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1581, 2.4406, 1.6340> <-1.1158, 2.4406, 1.6416> <-1.0595, 2.4406, 1.6516> <-1.0173, 2.4406, 1.6594>
		<-1.1285, 2.0691, 1.6077> <-1.0863, 2.0691, 1.6153> <-1.0503, 2.0681, 1.6350> <-1.0081, 2.0681, 1.6429>
		<-1.1581, 1.5705, 1.5790> <-1.1158, 1.5705, 1.6087> <-1.0679, 1.5702, 1.6571> <-1.0173, 1.5702, 1.6674>
		<-1.1581, 1.1973, 1.5602> <-1.1158, 1.1973, 1.5900> <-1.0679, 1.1973, 1.6491> <-1.0173, 1.1973, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1581, 1.1973, 1.5602> <-1.1158, 1.1973, 1.5900> <-1.0679, 1.1973, 1.6491> <-1.0173, 1.1973, 1.6594>
		<-1.1581, 1.1296, 1.5568> <-1.1158, 1.1296, 1.5866> <-1.0679, 1.1289, 1.6476> <-1.0173, 1.1289, 1.6580>
		<-1.1581, 1.0391, 1.5628> <-1.1158, 1.0391, 1.5831> <-1.0632, 1.0390, 1.6290> <-1.0173, 1.0390, 1.6384>
		<-1.1581, 0.9713, 1.5602> <-1.1158, 0.9713, 1.5806> <-1.0632, 0.9713, 1.6187> <-1.0173, 0.9713, 1.6280>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1581, 0.9713, 1.5602> <-1.1158, 0.9713, 1.5806> <-1.0632, 0.9713, 1.6187> <-1.0173, 0.9713, 1.6280>
		<-1.1581, 0.8016, 1.5539> <-1.1158, 0.8016, 1.5742> <-1.0632, 0.8016, 1.5926> <-1.0173, 0.8016, 1.6020>
		<-1.1581, 0.5757, 1.5394> <-1.1158, 0.5757, 1.5417> <-1.0586, 0.5757, 1.5558> <-1.0173, 0.5757, 1.5651>
		<-1.1581, 0.4062, 1.5304> <-1.1158, 0.4062, 1.5327> <-1.0586, 0.4062, 1.5288> <-1.0173, 0.4062, 1.5381>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0045, 3.3446, -0.0005> <3.0357, 3.4198, -0.0005> <3.1353, 3.5184, -0.0005> <3.1083, 3.5952, -0.0005>
		<3.0045, 3.3446, 0.5297> <3.0357, 3.4198, 0.5297> <3.1353, 3.5184, 0.5297> <3.1083, 3.5952, 0.5297>
		<3.0302, 3.3071, 1.2524> <3.0613, 3.3823, 1.2524> <3.1686, 3.4920, 1.2559> <3.1416, 3.5688, 1.2559>
		<2.8900, 3.2497, 1.7605> <2.9212, 3.3249, 1.7605> <3.0208, 3.4236, 1.7605> <2.9938, 3.5004, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0045, 3.3446, -0.0005> <3.0045, 3.3446, -0.5307> <3.0302, 3.3071, -1.2534> <2.8900, 3.2497, -1.7615>
		<3.0357, 3.4198, -0.0005> <3.0357, 3.4198, -0.5307> <3.0613, 3.3823, -1.2534> <2.9212, 3.3249, -1.7615>
		<3.1353, 3.5184, -0.0005> <3.1353, 3.5184, -0.5307> <3.1686, 3.4920, -1.2570> <3.0208, 3.4236, -1.7615>
		<3.1083, 3.5952, -0.0005> <3.1083, 3.5952, -0.5307> <3.1416, 3.5688, -1.2570> <2.9938, 3.5004, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1083, 3.5952, -0.0005> <3.0757, 3.6881, -0.0005> <2.9452, 3.7917, -0.0005> <2.8468, 3.7933, -0.0005>
		<3.1083, 3.5952, 0.5297> <3.0757, 3.6881, 0.5297> <2.9452, 3.7917, 0.5297> <2.8468, 3.7933, 0.5297>
		<3.1416, 3.5688, 1.2559> <3.1089, 3.6616, 1.2559> <2.9707, 3.7770, 1.2555> <2.8723, 3.7786, 1.2555>
		<2.9938, 3.5004, 1.7605> <2.9612, 3.5932, 1.7605> <2.8307, 3.6968, 1.7605> <2.7323, 3.6984, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1083, 3.5952, -0.0005> <3.1083, 3.5952, -0.5307> <3.1416, 3.5688, -1.2570> <2.9938, 3.5004, -1.7615>
		<3.0757, 3.6881, -0.0005> <3.0757, 3.6881, -0.5307> <3.1089, 3.6616, -1.2570> <2.9612, 3.5932, -1.7615>
		<2.9452, 3.7917, -0.0005> <2.9452, 3.7917, -0.5307> <2.9707, 3.7770, -1.2565> <2.8307, 3.6968, -1.7615>
		<2.8468, 3.7933, -0.0005> <2.8468, 3.7933, -0.5307> <2.8723, 3.7786, -1.2565> <2.7323, 3.6984, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8468, 3.7933, -0.0005> <2.6580, 3.7965, -0.0005> <2.3139, 3.7853, -0.0005> <2.2450, 3.6096, -0.0005>
		<2.8468, 3.7933, 0.5297> <2.6580, 3.7965, 0.5297> <2.3139, 3.7853, 0.5297> <2.2450, 3.6096, 0.5297>
		<2.8723, 3.7786, 1.2555> <2.6836, 3.7818, 1.2555> <2.2750, 3.7569, 1.2399> <2.2062, 3.5811, 1.2399>
		<2.7323, 3.6984, 1.7605> <2.5435, 3.7016, 1.7605> <2.1994, 3.6905, 1.7605> <2.1305, 3.5147, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8468, 3.7933, -0.0005> <2.8468, 3.7933, -0.5307> <2.8723, 3.7786, -1.2565> <2.7323, 3.6984, -1.7615>
		<2.6580, 3.7965, -0.0005> <2.6580, 3.7965, -0.5307> <2.6836, 3.7818, -1.2565> <2.5435, 3.7016, -1.7615>
		<2.3139, 3.7853, -0.0005> <2.3139, 3.7853, -0.5307> <2.2751, 3.7569, -1.2410> <2.1994, 3.6905, -1.7615>
		<2.2450, 3.6096, -0.0005> <2.2450, 3.6096, -0.5307> <2.2062, 3.5811, -1.2410> <2.1305, 3.5147, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2450, 3.6096, -0.0005> <2.1403, 3.3424, -0.0005> <2.4307, 2.9524, -0.0005> <2.4053, 2.6666, -0.0005>
		<2.2450, 3.6096, 0.5297> <2.1403, 3.3424, 0.5297> <2.4307, 2.9524, 0.5297> <2.4053, 2.6666, 0.5297>
		<2.2062, 3.5811, 1.2399> <2.1015, 3.3140, 1.2399> <2.4264, 2.9096, 1.2482> <2.3947, 2.6245, 1.2433>
		<2.1305, 3.5147, 1.7605> <2.0258, 3.2476, 1.7605> <2.3225, 2.8569, 1.7654> <2.2908, 2.5717, 1.7605>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2450, 3.6096, -0.0005> <2.2450, 3.6096, -0.5307> <2.2062, 3.5811, -1.2410> <2.1305, 3.5147, -1.7615>
		<2.1403, 3.3424, -0.0005> <2.1403, 3.3424, -0.5307> <2.1015, 3.3140, -1.2410> <2.0258, 3.2476, -1.7615>
		<2.4307, 2.9524, -0.0005> <2.4307, 2.9524, -0.5307> <2.4264, 2.9096, -1.2492> <2.3225, 2.8569, -1.7664>
		<2.4053, 2.6666, -0.0005> <2.4053, 2.6666, -0.5307> <2.3947, 2.6245, -1.2443> <2.2908, 2.5717, -1.7615>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4053, 2.6666, -0.0005> <2.3650, 2.2135, -0.0005> <2.4117, 1.4453, -0.0005> <2.0303, 1.1973, -0.0005>
		<2.4053, 2.6666, 0.5297> <2.3650, 2.2135, 0.5297> <2.4117, 1.4453, 0.5180> <2.0303, 1.1973, 0.5180>
		<2.3947, 2.6245, 1.2433> <2.3471, 2.1960, 1.2359> <2.2937, 1.4219, 1.2165> <1.9307, 1.1896, 1.2055>
		<2.2908, 2.5717, 1.7605> <2.2432, 2.1433, 1.7531> <2.2359, 1.4296, 1.7317> <1.8729, 1.1973, 1.7207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4053, 2.6666, -0.0005> <2.4053, 2.6666, -0.5307> <2.3947, 2.6245, -1.2443> <2.2908, 2.5717, -1.7615>
		<2.3650, 2.2135, -0.0005> <2.3650, 2.2135, -0.5307> <2.3471, 2.1960, -1.2370> <2.2432, 2.1433, -1.7542>
		<2.4117, 1.4453, -0.0005> <2.4117, 1.4453, -0.5191> <2.2937, 1.4219, -1.2175> <2.2359, 1.4296, -1.7328>
		<2.0303, 1.1973, -0.0005> <2.0303, 1.1973, -0.5191> <1.9307, 1.1896, -1.2065> <1.8729, 1.1973, -1.7218>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0303, 1.1973, -0.0005> <1.5991, 0.9169, -0.0005> <0.7831, 1.5330, -0.0005> <0.3195, 1.3104, -0.0005>
		<2.0303, 1.1973, 0.5180> <1.5991, 0.9169, 0.5180> <0.7831, 1.5330, 0.5099> <0.3195, 1.3104, 0.5099>
		<1.9307, 1.1896, 1.2055> <1.5372, 0.9378, 1.1936> <0.6493, 1.6286, 1.2125> <0.2362, 1.4101, 1.2072>
		<1.8729, 1.1973, 1.7207> <1.4794, 0.9455, 1.7088> <0.7325, 1.5288, 1.7061> <0.3195, 1.3104, 1.7007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0303, 1.1973, -0.0005> <2.0303, 1.1973, -0.5191> <1.9307, 1.1896, -1.2065> <1.8729, 1.1973, -1.7218>
		<1.5991, 0.9169, -0.0005> <1.5991, 0.9169, -0.5191> <1.5372, 0.9378, -1.1946> <1.4794, 0.9455, -1.7099>
		<0.7831, 1.5330, -0.0005> <0.7831, 1.5330, -0.5109> <0.6493, 1.6286, -1.2136> <0.7325, 1.5288, -1.7071>
		<0.3195, 1.3104, -0.0005> <0.3195, 1.3104, -0.5109> <0.2362, 1.4101, -1.2082> <0.3195, 1.3104, -1.7018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, -0.0005> <0.0667, 1.1890, -0.0005> <0.3195, 0.6562, -0.0005> <0.3195, 0.3758, -0.0005>
		<0.3195, 1.3104, 0.5099> <0.0667, 1.1890, 0.5099> <0.3195, 0.6562, 0.5099> <0.3195, 0.3758, 0.5099>
		<0.2362, 1.4101, 1.2072> <-0.0116, 1.2791, 1.2040> <0.2272, 0.6169, 1.2003> <0.2272, 0.3365, 1.2003>
		<0.3195, 1.3104, 1.7007> <0.0716, 1.1793, 1.6976> <0.3195, 0.6562, 1.7007> <0.3195, 0.3758, 1.7007>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, -0.0005> <0.3195, 1.3104, -0.5109> <0.2362, 1.4101, -1.2082> <0.3195, 1.3104, -1.7018>
		<0.0667, 1.1890, -0.0005> <0.0667, 1.1890, -0.5109> <-0.0116, 1.2791, -1.2051> <0.0716, 1.1793, -1.6986>
		<0.3195, 0.6562, -0.0005> <0.3195, 0.6562, -0.5109> <0.2272, 0.6169, -1.2014> <0.3195, 0.6562, -1.7018>
		<0.3195, 0.3758, -0.0005> <0.3195, 0.3758, -0.5109> <0.2272, 0.3365, -1.2014> <0.3195, 0.3758, -1.7018>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8900, 3.2497, 1.7605> <2.9212, 3.3249, 1.7605> <3.0208, 3.4236, 1.7605> <2.9938, 3.5004, 1.7605>
		<2.8395, 3.2290, 1.9437> <2.8706, 3.3042, 1.9437> <2.9572, 3.3941, 1.9777> <2.9302, 3.4709, 1.9777>
		<2.5972, 3.1279, 2.1220> <2.6090, 3.1846, 2.1507> <2.6965, 3.2749, 2.2078> <2.6698, 3.3338, 2.2068>
		<2.4104, 3.1013, 2.1531> <2.4222, 3.1580, 2.1819> <2.4764, 3.2314, 2.2500> <2.4497, 3.2903, 2.2490>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9938, 3.5004, 1.7605> <2.9612, 3.5932, 1.7605> <2.8307, 3.6968, 1.7605> <2.7323, 3.6984, 1.7605>
		<2.9302, 3.4709, 1.9777> <2.8976, 3.5638, 1.9777> <2.7780, 3.6666, 1.9504> <2.6796, 3.6683, 1.9504>
		<2.6698, 3.3338, 2.2068> <2.6356, 3.4091, 2.2056> <2.5128, 3.4926, 2.1536> <2.4411, 3.5024, 2.1135>
		<2.4497, 3.2903, 2.2490> <2.4155, 3.3656, 2.2478> <2.3228, 3.4424, 2.1874> <2.2511, 3.4522, 2.1473>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.7323, 3.6984, 1.7605> <2.5435, 3.7016, 1.7605> <2.1994, 3.6905, 1.7605> <2.1305, 3.5147, 1.7605>
		<2.6796, 3.6683, 1.9504> <2.4909, 3.6714, 1.9504> <2.1859, 3.6786, 1.8536> <2.1170, 3.5029, 1.8536>
		<2.4411, 3.5024, 2.1135> <2.3493, 3.5150, 2.0621> <2.0730, 3.4852, 1.9811> <2.0484, 3.3839, 1.9617>
		<2.2511, 3.4522, 2.1473> <2.1593, 3.4648, 2.0959> <1.9827, 3.4590, 1.9933> <1.9581, 3.3577, 1.9739>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1305, 3.5147, 1.7605> <2.0258, 3.2476, 1.7605> <2.3225, 2.8569, 1.7654> <2.2908, 2.5717, 1.7605>
		<2.1170, 3.5029, 1.8536> <2.0123, 3.2357, 1.8536> <2.3015, 2.8462, 1.8700> <2.2698, 2.5611, 1.8651>
		<2.0484, 3.3839, 1.9617> <1.9862, 3.1282, 1.9125> <2.1356, 2.7412, 1.9619> <2.1183, 2.4743, 1.9491>
		<1.9581, 3.3577, 1.9739> <1.8959, 3.1020, 1.9247> <2.0289, 2.7339, 1.9708> <2.0117, 2.4670, 1.9580>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2908, 2.5717, 1.7605> <2.2432, 2.1433, 1.7531> <2.2359, 1.4296, 1.7317> <1.8729, 1.1973, 1.7207>
		<2.2698, 2.5611, 1.8651> <2.2221, 2.1327, 1.8578> <2.2305, 1.4303, 1.7801> <1.8675, 1.1981, 1.7691>
		<2.1183, 2.4743, 1.9491> <2.0940, 2.0978, 1.9310> <2.1222, 1.5045, 1.8917> <1.8689, 1.2254, 1.8668>
		<2.0117, 2.4670, 1.9580> <1.9874, 2.0905, 1.9399> <2.0738, 1.5045, 1.8967> <1.8204, 1.2254, 1.8717>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8729, 1.1973, 1.7207> <1.4794, 0.9455, 1.7088> <0.7325, 1.5288, 1.7061> <0.3195, 1.3104, 1.7007>
		<1.8675, 1.1981, 1.7691> <1.4740, 0.9463, 1.7572> <0.7568, 1.4998, 1.8496> <0.3437, 1.2813, 1.8443>
		<1.8689, 1.2254, 1.8668> <1.6218, 0.9533, 1.8425> <0.9202, 1.2642, 1.7523> <0.6055, 1.0729, 1.7550>
		<1.8204, 1.2254, 1.8717> <1.5734, 0.9533, 1.8474> <0.9416, 1.1334, 1.8191> <0.6269, 0.9420, 1.8217>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, 1.7007> <0.0716, 1.1793, 1.6976> <0.3195, 0.6562, 1.7007> <0.3195, 0.3758, 1.7007>
		<0.3437, 1.2813, 1.8443> <0.0959, 1.1503, 1.8411> <0.3422, 0.6658, 1.8238> <0.3422, 0.3855, 1.8238>
		<0.6055, 1.0729, 1.7550> <0.4967, 1.0067, 1.7559> <0.6168, 0.6284, 1.7457> <0.6287, 0.5029, 1.7637>
		<0.6269, 0.9420, 1.8217> <0.5181, 0.8758, 1.8227> <0.6547, 0.6491, 1.8636> <0.6666, 0.5236, 1.8815>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.8900, 3.2497, -1.7615> <2.8395, 3.2290, -1.9447> <2.5971, 3.1279, -2.1229> <2.4104, 3.1013, -2.1541>
		<2.9212, 3.3249, -1.7615> <2.8706, 3.3042, -1.9447> <2.6089, 3.1846, -2.1517> <2.4222, 3.1580, -2.1828>
		<3.0208, 3.4236, -1.7615> <2.9572, 3.3941, -1.9787> <2.6965, 3.2749, -2.2087> <2.4764, 3.2314, -2.2509>
		<2.9938, 3.5004, -1.7615> <2.9302, 3.4709, -1.9787> <2.6697, 3.3338, -2.2077> <2.4497, 3.2903, -2.2500>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.9938, 3.5004, -1.7615> <2.9302, 3.4709, -1.9787> <2.6697, 3.3338, -2.2077> <2.4497, 3.2903, -2.2500>
		<2.9612, 3.5932, -1.7615> <2.8976, 3.5638, -1.9787> <2.6356, 3.4091, -2.2065> <2.4155, 3.3656, -2.2487>
		<2.8307, 3.6968, -1.7615> <2.7780, 3.6666, -1.9514> <2.5128, 3.4925, -2.1545> <2.3228, 3.4424, -2.1884>
		<2.7323, 3.6984, -1.7615> <2.6796, 3.6683, -1.9514> <2.4411, 3.5024, -2.1144> <2.2511, 3.4522, -2.1483>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.7323, 3.6984, -1.7615> <2.6796, 3.6683, -1.9514> <2.4411, 3.5024, -2.1144> <2.2511, 3.4522, -2.1483>
		<2.5435, 3.7016, -1.7615> <2.4909, 3.6714, -1.9514> <2.3492, 3.5150, -2.0630> <2.1593, 3.4648, -2.0968>
		<2.1994, 3.6905, -1.7615> <2.1859, 3.6786, -1.8546> <2.0730, 3.4852, -1.9821> <1.9827, 3.4590, -1.9943>
		<2.1305, 3.5147, -1.7615> <2.1170, 3.5029, -1.8546> <2.0484, 3.3839, -1.9626> <1.9581, 3.3577, -1.9748>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.1305, 3.5147, -1.7615> <2.1170, 3.5029, -1.8546> <2.0484, 3.3839, -1.9626> <1.9581, 3.3577, -1.9748>
		<2.0258, 3.2476, -1.7615> <2.0123, 3.2357, -1.8546> <1.9862, 3.1282, -1.9135> <1.8959, 3.1020, -1.9257>
		<2.3225, 2.8569, -1.7664> <2.3015, 2.8462, -1.8711> <2.1355, 2.7412, -1.9628> <2.0289, 2.7339, -1.9717>
		<2.2908, 2.5717, -1.7615> <2.2698, 2.5611, -1.8662> <2.1183, 2.4743, -1.9500> <2.0117, 2.4670, -1.9589>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2908, 2.5717, -1.7615> <2.2698, 2.5611, -1.8662> <2.1183, 2.4743, -1.9500> <2.0117, 2.4670, -1.9589>
		<2.2432, 2.1433, -1.7542> <2.2221, 2.1327, -1.8588> <2.0940, 2.0978, -1.9320> <1.9874, 2.0905, -1.9409>
		<2.2359, 1.4296, -1.7328> <2.2305, 1.4303, -1.7811> <2.1222, 1.5045, -1.8927> <2.0738, 1.5045, -1.8976>
		<1.8729, 1.1973, -1.7218> <1.8675, 1.1981, -1.7701> <1.8688, 1.2254, -1.8677> <1.8204, 1.2254, -1.8727>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8729, 1.1973, -1.7218> <1.8675, 1.1981, -1.7701> <1.8688, 1.2254, -1.8677> <1.8204, 1.2254, -1.8727>
		<1.4794, 0.9455, -1.7099> <1.4740, 0.9463, -1.7582> <1.6218, 0.9533, -1.8434> <1.5734, 0.9533, -1.8484>
		<0.7325, 1.5288, -1.7071> <0.7568, 1.4998, -1.8507> <0.9202, 1.2642, -1.7532> <0.9416, 1.1334, -1.8200>
		<0.3195, 1.3104, -1.7018> <0.3437, 1.2813, -1.8453> <0.6055, 1.0728, -1.7559> <0.6269, 0.9420, -1.8227>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3195, 1.3104, -1.7018> <0.3437, 1.2813, -1.8453> <0.6055, 1.0728, -1.7559> <0.6269, 0.9420, -1.8227>
		<0.0716, 1.1793, -1.6986> <0.0959, 1.1503, -1.8422> <0.4967, 1.0066, -1.7568> <0.5181, 0.8758, -1.8236>
		<0.3195, 0.6562, -1.7018> <0.3422, 0.6658, -1.8248> <0.6169, 0.6285, -1.7467> <0.6547, 0.6491, -1.8645>
		<0.3195, 0.3758, -1.7018> <0.3422, 0.3855, -1.8248> <0.6288, 0.5030, -1.7646> <0.6666, 0.5236, -1.8825>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4104, 3.1013, 2.1531> <2.4222, 3.1580, 2.1819> <2.4764, 3.2314, 2.2500> <2.4497, 3.2903, 2.2490>
		<1.8107, 3.0159, 2.2531> <1.8225, 3.0726, 2.2819> <1.8698, 3.1114, 2.3663> <1.8431, 3.1703, 2.3653>
		<0.9855, 2.9330, 2.2289> <0.9855, 2.9602, 2.2537> <0.9991, 3.0036, 2.3181> <0.9991, 3.0405, 2.3181>
		<0.3750, 2.8915, 2.1798> <0.3750, 2.9188, 2.2046> <0.3750, 2.9455, 2.2626> <0.3750, 2.9824, 2.2626>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4497, 3.2903, 2.2490> <2.4155, 3.3656, 2.2478> <2.3228, 3.4424, 2.1874> <2.2511, 3.4522, 2.1473>
		<1.8431, 3.1703, 2.3653> <1.8089, 3.2456, 2.3641> <1.7757, 3.2979, 2.2847> <1.7040, 3.3077, 2.2446>
		<0.9991, 3.0405, 2.3181> <0.9991, 3.0779, 2.3181> <0.9431, 3.1407, 2.2640> <0.9431, 3.1440, 2.2267>
		<0.3750, 2.9824, 2.2626> <0.3750, 3.0198, 2.2626> <0.3750, 3.0726, 2.2171> <0.3750, 3.0759, 2.1798>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2511, 3.4522, 2.1473> <2.1593, 3.4648, 2.0959> <1.9827, 3.4590, 1.9933> <1.9581, 3.3577, 1.9739>
		<1.7040, 3.3077, 2.2446> <1.6122, 3.3203, 2.1932> <1.5192, 3.3246, 2.0559> <1.4946, 3.2234, 2.0364>
		<0.9431, 3.1440, 2.2267> <0.9431, 3.1491, 2.1683> <0.8562, 3.1213, 2.0573> <0.8562, 3.0671, 2.0351>
		<0.3750, 3.0759, 2.1798> <0.3750, 3.0810, 2.1214> <0.3750, 3.0600, 2.0197> <0.3750, 3.0057, 1.9976>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.9581, 3.3577, 1.9739> <1.8959, 3.1020, 1.9247> <2.0289, 2.7339, 1.9708> <2.0117, 2.4670, 1.9580>
		<1.4946, 3.2234, 2.0364> <1.4325, 2.9676, 1.9873> <1.5405, 2.7005, 2.0115> <1.5233, 2.4336, 1.9987>
		<0.8562, 3.0671, 2.0351> <0.8562, 2.9087, 1.9704> <0.8638, 2.6156, 1.9802> <0.8638, 2.4448, 1.9685>
		<0.3750, 3.0057, 1.9976> <0.3750, 2.8473, 1.9329> <0.3750, 2.6113, 1.9320> <0.3750, 2.4406, 1.9203>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0117, 2.4670, 1.9580> <1.9874, 2.0905, 1.9399> <2.0738, 1.5045, 1.8967> <1.8204, 1.2254, 1.8717>
		<1.5233, 2.4336, 1.9987> <1.4990, 2.0570, 1.9807> <1.6423, 1.5045, 1.9407> <1.3890, 1.2254, 1.9158>
		<0.8638, 2.4448, 1.9685> <0.8638, 2.0725, 1.9430> <0.8075, 1.5747, 1.9178> <0.8075, 1.2016, 1.9060>
		<0.3750, 2.4406, 1.9203> <0.3750, 2.0682, 1.8948> <0.3750, 1.5704, 1.8855> <0.3750, 1.1973, 1.8737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8204, 1.2254, 1.8717> <1.5734, 0.9533, 1.8474> <0.9416, 1.1334, 1.8191> <0.6269, 0.9420, 1.8217>
		<1.3890, 1.2254, 1.9158> <1.1419, 0.9533, 1.8915> <0.9528, 1.0649, 1.8540> <0.6381, 0.8735, 1.8566>
		<0.8075, 1.2016, 1.9060> <0.8075, 1.1338, 1.9039> <0.4521, 1.0377, 1.8827> <0.4521, 0.9699, 1.8827>
		<0.3750, 1.1973, 1.8737> <0.3750, 1.1296, 1.8715> <0.3750, 1.0391, 1.8737> <0.3750, 0.9713, 1.8737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6269, 0.9420, 1.8217> <0.5181, 0.8758, 1.8227> <0.6547, 0.6491, 1.8636> <0.6666, 0.5236, 1.8815>
		<0.6381, 0.8735, 1.8566> <0.5294, 0.8074, 1.8576> <0.6831, 0.6647, 1.9522> <0.6950, 0.5392, 1.9701>
		<0.4521, 0.9699, 1.8827> <0.4521, 0.8004, 1.8827> <0.4672, 0.5821, 1.8925> <0.4672, 0.4126, 1.8925>
		<0.3750, 0.9713, 1.8737> <0.3750, 0.8018, 1.8737> <0.3750, 0.5757, 1.8737> <0.3750, 0.4062, 1.8737>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4104, 3.1013, -2.1541> <1.8107, 3.0159, -2.2541> <0.9854, 2.9330, -2.2324> <0.3750, 2.8915, -2.1811>
		<2.4222, 3.1580, -2.1828> <1.8225, 3.0726, -2.2829> <0.9854, 2.9602, -2.2572> <0.3750, 2.9188, -2.2059>
		<2.4764, 3.2314, -2.2509> <1.8698, 3.1114, -2.3673> <0.9989, 3.0036, -2.3216> <0.3750, 2.9455, -2.2639>
		<2.4497, 3.2903, -2.2500> <1.8431, 3.1703, -2.3663> <0.9989, 3.0404, -2.3216> <0.3750, 2.9824, -2.2639>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.4497, 3.2903, -2.2500> <1.8431, 3.1703, -2.3663> <0.9989, 3.0404, -2.3216> <0.3750, 2.9824, -2.2639>
		<2.4155, 3.3656, -2.2487> <1.8089, 3.2456, -2.3651> <0.9989, 3.0779, -2.3216> <0.3750, 3.0198, -2.2639>
		<2.3228, 3.4424, -2.1884> <1.7757, 3.2979, -2.2857> <0.9430, 3.1407, -2.2674> <0.3750, 3.0726, -2.2184>
		<2.2511, 3.4522, -2.1483> <1.7041, 3.3077, -2.2456> <0.9430, 3.1439, -2.2301> <0.3750, 3.0759, -2.1811>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.2511, 3.4522, -2.1483> <1.7041, 3.3077, -2.2456> <0.9430, 3.1439, -2.2301> <0.3750, 3.0759, -2.1811>
		<2.1593, 3.4648, -2.0968> <1.6122, 3.3203, -2.1942> <0.9430, 3.1491, -2.1717> <0.3750, 3.0810, -2.1228>
		<1.9827, 3.4590, -1.9943> <1.5193, 3.3246, -2.0569> <0.8561, 3.1213, -2.0606> <0.3750, 3.0600, -2.0211>
		<1.9581, 3.3577, -1.9748> <1.4946, 3.2234, -2.0375> <0.8561, 3.0671, -2.0385> <0.3750, 3.0057, -1.9989>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.9581, 3.3577, -1.9748> <1.4946, 3.2234, -2.0375> <0.8561, 3.0671, -2.0385> <0.3750, 3.0057, -1.9989>
		<1.8959, 3.1020, -1.9257> <1.4325, 2.9676, -1.9883> <0.8561, 2.9086, -1.9737> <0.3750, 2.8473, -1.9342>
		<2.0289, 2.7339, -1.9717> <1.5405, 2.7005, -2.0125> <0.8636, 2.6156, -1.9835> <0.3750, 2.6113, -1.9333>
		<2.0117, 2.4670, -1.9589> <1.5233, 2.4336, -1.9997> <0.8636, 2.4448, -1.9718> <0.3750, 2.4406, -1.9216>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.0117, 2.4670, -1.9589> <1.5233, 2.4336, -1.9997> <0.8636, 2.4448, -1.9718> <0.3750, 2.4406, -1.9216>
		<1.9874, 2.0905, -1.9409> <1.4990, 2.0570, -1.9817> <0.8636, 2.0725, -1.9463> <0.3750, 2.0682, -1.8961>
		<2.0738, 1.5045, -1.8976> <1.6424, 1.5045, -1.9417> <0.8073, 1.5747, -1.9211> <0.3750, 1.5704, -1.8868>
		<1.8204, 1.2254, -1.8727> <1.3890, 1.2254, -1.9168> <0.8073, 1.2016, -1.9092> <0.3750, 1.1973, -1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.8204, 1.2254, -1.8727> <1.3890, 1.2254, -1.9168> <0.8073, 1.2016, -1.9092> <0.3750, 1.1973, -1.8750>
		<1.5734, 0.9533, -1.8484> <1.1419, 0.9533, -1.8925> <0.8073, 1.1338, -1.9071> <0.3750, 1.1296, -1.8728>
		<0.9416, 1.1334, -1.8200> <0.9528, 1.0649, -1.8550> <0.4521, 1.0377, -1.8846> <0.3750, 1.0391, -1.8750>
		<0.6269, 0.9420, -1.8227> <0.6381, 0.8735, -1.8577> <0.4521, 0.9699, -1.8846> <0.3750, 0.9713, -1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.6269, 0.9420, -1.8227> <0.6381, 0.8735, -1.8577> <0.4521, 0.9699, -1.8846> <0.3750, 0.9713, -1.8750>
		<0.5181, 0.8758, -1.8236> <0.5293, 0.8074, -1.8586> <0.4521, 0.8004, -1.8846> <0.3750, 0.8018, -1.8750>
		<0.6547, 0.6491, -1.8645> <0.6831, 0.6647, -1.9531> <0.4671, 0.5821, -1.8944> <0.3750, 0.5757, -1.8750>
		<0.6666, 0.5236, -1.8825> <0.6950, 0.5392, -1.9711> <0.4671, 0.4126, -1.8944> <0.3750, 0.4062, -1.8750>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.8915, -2.1811> <-0.0945, 2.8596, -2.1417> <-0.7045, 2.8616, -1.9608> <-1.1644, 2.8586, -1.8539>
		<0.3750, 2.9188, -2.2059> <-0.0945, 2.8869, -2.1665> <-0.7186, 2.8889, -1.9782> <-1.1785, 2.8859, -1.8712>
		<0.3750, 2.9455, -2.2639> <-0.1085, 2.9005, -2.2192> <-0.7372, 2.9447, -2.0210> <-1.2114, 2.9142, -1.9117>
		<0.3750, 2.9824, -2.2639> <-0.1085, 2.9374, -2.2192> <-0.7372, 2.9800, -2.0210> <-1.2114, 2.9495, -1.9117>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.9824, -2.2639> <-0.1085, 2.9374, -2.2192> <-0.7372, 2.9800, -2.0210> <-1.2114, 2.9495, -1.9117>
		<0.3750, 3.0198, -2.2639> <-0.1085, 2.9748, -2.2192> <-0.7372, 3.0158, -2.0210> <-1.2114, 2.9853, -1.9117>
		<0.3750, 3.0726, -2.2184> <-0.0922, 3.0166, -2.1782> <-0.7271, 3.0888, -1.9773> <-1.1869, 3.0395, -1.8816>
		<0.3750, 3.0759, -2.1811> <-0.0922, 3.0199, -2.1408> <-0.7046, 3.0923, -1.9496> <-1.1644, 3.0430, -1.8539>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0759, -2.1811> <-0.0922, 3.0199, -2.1408> <-0.7046, 3.0923, -1.9496> <-1.1644, 3.0430, -1.8539>
		<0.3750, 3.0810, -2.1228> <-0.0922, 3.0251, -2.0825> <-0.6711, 3.0975, -1.9083> <-1.1309, 3.0482, -1.8126>
		<0.3750, 3.0600, -2.0211> <-0.0587, 3.0047, -1.9854> <-0.6425, 3.0411, -1.8242> <-1.0732, 3.0221, -1.7436>
		<0.3750, 3.0057, -1.9989> <-0.0587, 2.9505, -1.9633> <-0.6304, 2.9918, -1.8074> <-1.0612, 2.9728, -1.7267>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0057, -1.9989> <-0.0587, 2.9505, -1.9633> <-0.6304, 2.9918, -1.8074> <-1.0612, 2.9728, -1.7267>
		<0.3750, 2.8473, -1.9342> <-0.0587, 2.7920, -1.8986> <-0.5940, 2.8425, -1.7563> <-1.0247, 2.8235, -1.6756>
		<0.3750, 2.6113, -1.9333> <-0.0485, 2.6076, -1.8898> <-0.6035, 2.6023, -1.7366> <-1.0213, 2.6023, -1.6550>
		<0.3750, 2.4406, -1.9216> <-0.0485, 2.4369, -1.8781> <-0.5995, 2.4406, -1.7295> <-1.0173, 2.4406, -1.6478>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.4406, -1.9216> <-0.0485, 2.4369, -1.8781> <-0.5995, 2.4406, -1.7295> <-1.0173, 2.4406, -1.6478>
		<0.3750, 2.0682, -1.8961> <-0.0485, 2.0645, -1.8526> <-0.5903, 2.0681, -1.7129> <-1.0081, 2.0681, -1.6312>
		<0.3750, 1.5704, -1.8868> <-0.0469, 1.5662, -1.8534> <-0.6034, 1.5702, -1.7440> <-1.0173, 1.5702, -1.6557>
		<0.3750, 1.1973, -1.8750> <-0.0469, 1.1932, -1.8415> <-0.6034, 1.1973, -1.7360> <-1.0173, 1.1973, -1.6478>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 1.1973, -1.8750> <-0.0469, 1.1932, -1.8415> <-0.6034, 1.1973, -1.7360> <-1.0173, 1.1973, -1.6478>
		<0.3750, 1.1296, -1.8728> <-0.0469, 1.1254, -1.8394> <-0.6034, 1.1289, -1.7346> <-1.0173, 1.1289, -1.6463>
		<0.3750, 1.0391, -1.8750> <-0.0465, 1.0466, -1.8221> <-0.6018, 1.0390, -1.7153> <-1.0173, 1.0390, -1.6268>
		<0.3750, 0.9713, -1.8750> <-0.0465, 0.9788, -1.8221> <-0.6018, 0.9713, -1.7050> <-1.0173, 0.9713, -1.6164>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 0.9713, -1.8750> <-0.0465, 0.9788, -1.8221> <-0.6018, 0.9713, -1.7050> <-1.0173, 0.9713, -1.6164>
		<0.3750, 0.8018, -1.8750> <-0.0465, 0.8093, -1.8221> <-0.6018, 0.8016, -1.6789> <-1.0173, 0.8016, -1.5903>
		<0.3750, 0.5757, -1.8750> <-0.0453, 0.5464, -1.7861> <-0.5979, 0.5757, -1.6510> <-1.0173, 0.5757, -1.5534>
		<0.3750, 0.4062, -1.8750> <-0.0453, 0.3769, -1.7861> <-0.5979, 0.4062, -1.6240> <-1.0173, 0.4062, -1.5264>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.8915, 2.1798> <0.3750, 2.9188, 2.2046> <0.3750, 2.9455, 2.2626> <0.3750, 2.9824, 2.2626>
		<-0.0939, 2.8597, 2.1421> <-0.0939, 2.8869, 2.1669> <-0.1078, 2.9005, 2.2196> <-0.1078, 2.9374, 2.2196>
		<-0.7044, 2.8616, 1.9686> <-0.7185, 2.8889, 1.9860> <-0.7381, 2.9447, 2.0328> <-0.7381, 2.9799, 2.0328>
		<-1.1644, 2.8586, 1.8655> <-1.1785, 2.8859, 1.8829> <-1.2114, 2.9142, 1.9233> <-1.2114, 2.9495, 1.9233>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.9824, 2.2626> <0.3750, 3.0198, 2.2626> <0.3750, 3.0726, 2.2171> <0.3750, 3.0759, 2.1798>
		<-0.1078, 2.9374, 2.2196> <-0.1078, 2.9749, 2.2196> <-0.0916, 3.0167, 2.1786> <-0.0916, 3.0200, 2.1413>
		<-0.7381, 2.9799, 2.0328> <-0.7381, 3.0158, 2.0328> <-0.7280, 3.0887, 1.9891> <-0.7055, 3.0922, 1.9614>
		<-1.2114, 2.9495, 1.9233> <-1.2114, 2.9853, 1.9233> <-1.1869, 3.0395, 1.8932> <-1.1644, 3.0430, 1.8655>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0759, 2.1798> <0.3750, 3.0810, 2.1214> <0.3750, 3.0600, 2.0197> <0.3750, 3.0057, 1.9976>
		<-0.0916, 3.0200, 2.1413> <-0.0916, 3.0252, 2.0830> <-0.0581, 3.0048, 1.9860> <-0.0581, 2.9505, 1.9638>
		<-0.7055, 3.0922, 1.9614> <-0.6719, 3.0974, 1.9201> <-0.6432, 3.0411, 1.8361> <-0.6312, 2.9918, 1.8192>
		<-1.1644, 3.0430, 1.8655> <-1.1309, 3.0482, 1.8242> <-1.0732, 3.0221, 1.7552> <-1.0612, 2.9728, 1.7384>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 3.0057, 1.9976> <0.3750, 2.8473, 1.9329> <0.3750, 2.6113, 1.9320> <0.3750, 2.4406, 1.9203>
		<-0.0581, 2.9505, 1.9638> <-0.0581, 2.7921, 1.8991> <-0.0479, 2.6076, 1.8903> <-0.0479, 2.4369, 1.8786>
		<-0.6312, 2.9918, 1.8192> <-0.5947, 2.8425, 1.7682> <-0.6036, 2.6023, 1.7446> <-0.5996, 2.4406, 1.7374>
		<-1.0612, 2.9728, 1.7384> <-1.0247, 2.8235, 1.6873> <-1.0213, 2.6023, 1.6666> <-1.0173, 2.4406, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 2.4406, 1.9203> <0.3750, 2.0682, 1.8948> <0.3750, 1.5704, 1.8855> <0.3750, 1.1973, 1.8737>
		<-0.0479, 2.4369, 1.8786> <-0.0479, 2.0645, 1.8531> <-0.0464, 1.5662, 1.8540> <-0.0464, 1.1932, 1.8421>
		<-0.5996, 2.4406, 1.7374> <-0.5904, 2.0681, 1.7209> <-0.6033, 1.5702, 1.7520> <-0.6033, 1.1973, 1.7441>
		<-1.0173, 2.4406, 1.6594> <-1.0081, 2.0681, 1.6429> <-1.0173, 1.5702, 1.6674> <-1.0173, 1.1973, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 1.1973, 1.8737> <0.3750, 1.1296, 1.8715> <0.3750, 1.0391, 1.8737> <0.3750, 0.9713, 1.8737>
		<-0.0464, 1.1932, 1.8421> <-0.0464, 1.1254, 1.8400> <-0.0462, 1.0466, 1.8240> <-0.0462, 0.9788, 1.8240>
		<-0.6033, 1.1973, 1.7441> <-0.6033, 1.1289, 1.7426> <-0.6018, 1.0390, 1.7234> <-0.6018, 0.9713, 1.7130>
		<-1.0173, 1.1973, 1.6594> <-1.0173, 1.1289, 1.6580> <-1.0173, 1.0390, 1.6384> <-1.0173, 0.9713, 1.6280>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.3750, 0.9713, 1.8737> <0.3750, 0.8018, 1.8737> <0.3750, 0.5757, 1.8737> <0.3750, 0.4062, 1.8737>
		<-0.0462, 0.9788, 1.8240> <-0.0462, 0.8093, 1.8240> <-0.0450, 0.5464, 1.7880> <-0.0450, 0.3769, 1.7880>
		<-0.6018, 0.9713, 1.7130> <-0.6018, 0.8016, 1.6870> <-0.5981, 0.5757, 1.6589> <-0.5981, 0.4062, 1.6319>
		<-1.0173, 0.9713, 1.6280> <-1.0173, 0.8016, 1.6020> <-1.0173, 0.5757, 1.5651> <-1.0173, 0.4062, 1.5381>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1644, 2.8586, -1.8539> <-1.1839, 2.8585, -1.8493> <-1.1972, 2.8744, -1.8247> <-1.2113, 2.8812, -1.8122>
		<-1.1785, 2.8859, -1.8712> <-1.1980, 2.8857, -1.8667> <-1.2206, 2.8726, -1.8451> <-1.2347, 2.8794, -1.8327>
		<-1.2114, 2.9142, -1.9117> <-1.2441, 2.9121, -1.9041> <-1.2349, 2.8958, -1.8882> <-1.2582, 2.8735, -1.8788>
		<-1.2114, 2.9495, -1.9117> <-1.2441, 2.9474, -1.9041> <-1.2659, 2.8975, -1.8897> <-1.2892, 2.8753, -1.8803>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2114, 2.9495, -1.9117> <-1.2441, 2.9474, -1.9041> <-1.2659, 2.8975, -1.8897> <-1.2892, 2.8753, -1.8803>
		<-1.2114, 2.9853, -1.9117> <-1.2441, 2.9832, -1.9041> <-1.2945, 2.8991, -1.8912> <-1.3179, 2.8769, -1.8818>
		<-1.1869, 3.0395, -1.8816> <-1.2606, 3.0316, -1.8662> <-1.3016, 2.9276, -1.8574> <-1.3608, 2.8817, -1.8472>
		<-1.1644, 3.0430, -1.8539> <-1.2381, 3.0351, -1.8385> <-1.3026, 2.9357, -1.8299> <-1.3618, 2.8897, -1.8196>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1644, 3.0430, -1.8539> <-1.2381, 3.0351, -1.8385> <-1.3026, 2.9357, -1.8299> <-1.3618, 2.8897, -1.8196>
		<-1.1309, 3.0482, -1.8126> <-1.2046, 3.0403, -1.7972> <-1.3042, 2.9488, -1.7853> <-1.3634, 2.9028, -1.7751>
		<-1.0732, 3.0221, -1.7436> <-1.1445, 3.0190, -1.7302> <-1.2434, 2.9837, -1.7155> <-1.3139, 2.9715, -1.7033>
		<-1.0612, 2.9728, -1.7267> <-1.1324, 2.9697, -1.7134> <-1.2256, 2.9444, -1.6982> <-1.2961, 2.9322, -1.6860>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0612, 2.9728, -1.7267> <-1.1324, 2.9697, -1.7134> <-1.2256, 2.9444, -1.6982> <-1.2961, 2.9322, -1.6860>
		<-1.0247, 2.8235, -1.6756> <-1.0960, 2.8204, -1.6623> <-1.1664, 2.8139, -1.6408> <-1.2369, 2.8017, -1.6285>
		<-1.0213, 2.6023, -1.6550> <-1.0635, 2.6023, -1.6467> <-1.1281, 2.5940, -1.6419> <-1.1703, 2.5940, -1.6341>
		<-1.0173, 2.4406, -1.6478> <-1.0595, 2.4406, -1.6395> <-1.1158, 2.4406, -1.6297> <-1.1581, 2.4406, -1.6219>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0173, 2.4406, -1.6478> <-1.0595, 2.4406, -1.6395> <-1.1158, 2.4406, -1.6297> <-1.1581, 2.4406, -1.6219>
		<-1.0081, 2.0681, -1.6312> <-1.0503, 2.0681, -1.6230> <-1.0863, 2.0693, -1.6002> <-1.1285, 2.0693, -1.5924>
		<-1.0173, 1.5702, -1.6557> <-1.0679, 1.5702, -1.6450> <-1.1158, 1.5705, -1.5968> <-1.1581, 1.5705, -1.5669>
		<-1.0173, 1.1973, -1.6478> <-1.0679, 1.1973, -1.6370> <-1.1158, 1.1973, -1.5780> <-1.1581, 1.1973, -1.5481>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0173, 1.1973, -1.6478> <-1.0679, 1.1973, -1.6370> <-1.1158, 1.1973, -1.5780> <-1.1581, 1.1973, -1.5481>
		<-1.0173, 1.1289, -1.6463> <-1.0679, 1.1289, -1.6355> <-1.1158, 1.1296, -1.5746> <-1.1581, 1.1296, -1.5447>
		<-1.0173, 1.0390, -1.6268> <-1.0632, 1.0390, -1.6170> <-1.1158, 1.0391, -1.5711> <-1.1581, 1.0391, -1.5507>
		<-1.0173, 0.9713, -1.6164> <-1.0632, 0.9713, -1.6066> <-1.1158, 0.9713, -1.5686> <-1.1581, 0.9713, -1.5481>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.0173, 0.9713, -1.6164> <-1.0632, 0.9713, -1.6066> <-1.1158, 0.9713, -1.5686> <-1.1581, 0.9713, -1.5481>
		<-1.0173, 0.8016, -1.5903> <-1.0632, 0.8016, -1.5806> <-1.1158, 0.8016, -1.5622> <-1.1581, 0.8016, -1.5417>
		<-1.0173, 0.5757, -1.5534> <-1.0585, 0.5757, -1.5438> <-1.1158, 0.5757, -1.5297> <-1.1581, 0.5757, -1.5272>
		<-1.0173, 0.4062, -1.5264> <-1.0585, 0.4062, -1.5168> <-1.1158, 0.4062, -1.5207> <-1.1581, 0.4062, -1.5183>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2113, 2.8812, 1.8243> <-1.1972, 2.8744, 1.8367> <-1.1839, 2.8585, 1.8612> <-1.1644, 2.8586, 1.8655>
		<-1.2347, 2.8794, 1.8403> <-1.2206, 2.8726, 1.8527> <-1.1979, 2.8857, 1.8785> <-1.1785, 2.8859, 1.8829>
		<-1.2609, 2.8737, 1.8791> <-1.2376, 2.8959, 1.8928> <-1.2455, 2.9120, 1.9155> <-1.2114, 2.9142, 1.9233>
		<-1.2892, 2.8753, 1.8777> <-1.2659, 2.8975, 1.8914> <-1.2455, 2.9473, 1.9155> <-1.2114, 2.9495, 1.9233>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2892, 2.8753, 1.8777> <-1.2659, 2.8975, 1.8914> <-1.2455, 2.9473, 1.9155> <-1.2114, 2.9495, 1.9233>
		<-1.3179, 2.8769, 1.8763> <-1.2945, 2.8991, 1.8900> <-1.2455, 2.9831, 1.9155> <-1.2114, 2.9853, 1.9233>
		<-1.3608, 2.8817, 1.8445> <-1.3016, 2.9276, 1.8590> <-1.2613, 3.0315, 1.8777> <-1.1869, 3.0395, 1.8932>
		<-1.3618, 2.8897, 1.8169> <-1.3026, 2.9357, 1.8315> <-1.2388, 3.0350, 1.8500> <-1.1644, 3.0430, 1.8655>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.3618, 2.8897, 1.8169> <-1.3026, 2.9357, 1.8315> <-1.2388, 3.0350, 1.8500> <-1.1644, 3.0430, 1.8655>
		<-1.3634, 2.9028, 1.7724> <-1.3042, 2.9488, 1.7870> <-1.2052, 3.0403, 1.8087> <-1.1309, 3.0482, 1.8242>
		<-1.3141, 2.9719, 1.6995> <-1.2436, 2.9841, 1.7160> <-1.1453, 3.0190, 1.7417> <-1.0732, 3.0221, 1.7552>
		<-1.2961, 2.9322, 1.6833> <-1.2256, 2.9444, 1.6998> <-1.1332, 2.9697, 1.7248> <-1.0612, 2.9728, 1.7384>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.2961, 2.9322, 1.6833> <-1.2256, 2.9444, 1.6998> <-1.1332, 2.9697, 1.7248> <-1.0612, 2.9728, 1.7384>
		<-1.2365, 2.8008, 1.6298> <-1.1660, 2.8130, 1.6463> <-1.0968, 2.8204, 1.6737> <-1.0247, 2.8235, 1.6873>
		<-1.1702, 2.5936, 1.6449> <-1.1280, 2.5936, 1.6525> <-1.0635, 2.6023, 1.6588> <-1.0213, 2.6023, 1.6666>
		<-1.1581, 2.4406, 1.6340> <-1.1158, 2.4406, 1.6416> <-1.0595, 2.4406, 1.6516> <-1.0173, 2.4406, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1581, 2.4406, 1.6340> <-1.1158, 2.4406, 1.6416> <-1.0595, 2.4406, 1.6516> <-1.0173, 2.4406, 1.6594>
		<-1.1285, 2.0691, 1.6077> <-1.0863, 2.0691, 1.6153> <-1.0503, 2.0681, 1.6350> <-1.0081, 2.0681, 1.6429>
		<-1.1581, 1.5705, 1.5790> <-1.1158, 1.5705, 1.6087> <-1.0679, 1.5702, 1.6571> <-1.0173, 1.5702, 1.6674>
		<-1.1581, 1.1973, 1.5602> <-1.1158, 1.1973, 1.5900> <-1.0679, 1.1973, 1.6491> <-1.0173, 1.1973, 1.6594>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1581, 1.1973, 1.5602> <-1.1158, 1.1973, 1.5900> <-1.0679, 1.1973, 1.6491> <-1.0173, 1.1973, 1.6594>
		<-1.1581, 1.1296, 1.5568> <-1.1158, 1.1296, 1.5866> <-1.0679, 1.1289, 1.6476> <-1.0173, 1.1289, 1.6580>
		<-1.1581, 1.0391, 1.5628> <-1.1158, 1.0391, 1.5831> <-1.0632, 1.0390, 1.6290> <-1.0173, 1.0390, 1.6384>
		<-1.1581, 0.9713, 1.5602> <-1.1158, 0.9713, 1.5806> <-1.0632, 0.9713, 1.6187> <-1.0173, 0.9713, 1.6280>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.1581, 0.9713, 1.5602> <-1.1158, 0.9713, 1.5806> <-1.0632, 0.9713, 1.6187> <-1.0173, 0.9713, 1.6280>
		<-1.1581, 0.8016, 1.5539> <-1.1158, 0.8016, 1.5742> <-1.0632, 0.8016, 1.5926> <-1.0173, 0.8016, 1.6020>
		<-1.1581, 0.5757, 1.5394> <-1.1158, 0.5757, 1.5417> <-1.0586, 0.5757, 1.5558> <-1.0173, 0.5757, 1.5651>
		<-1.1581, 0.4062, 1.5304> <-1.1158, 0.4062, 1.5327> <-1.0586, 0.4062, 1.5288> <-1.0173, 0.4062, 1.5381>
	}
}

// trunk
#declare BODY04=
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.9175, 2.3123, -0.0014> <4.9175, 2.3123, 0.4582> <4.9473, 2.3123, 1.0767> <4.8701, 2.3123, 1.5297>
		<4.9588, 2.3123, -0.0014> <4.9588, 2.3123, 0.4581> <4.9864, 2.3123, 1.1035> <4.9092, 2.3123, 1.5565>
		<5.0323, 2.2779, -0.0015> <5.0323, 2.2779, 0.4849> <5.0658, 2.2756, 1.1216> <4.9773, 2.2756, 1.5999>
		<5.0550, 2.3123, -0.0015> <5.0550, 2.3123, 0.4849> <5.0889, 2.3123, 1.1406> <5.0005, 2.3123, 1.6189>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.9175, 2.3123, -0.0014> <4.9588, 2.3123, -0.0014> <5.0323, 2.2779, -0.0015> <5.0550, 2.3123, -0.0015>
		<4.9175, 2.3123, -0.4599> <4.9588, 2.3123, -0.4599> <5.0323, 2.2779, -0.4867> <5.0550, 2.3123, -0.4868>
		<4.9472, 2.3123, -1.0770> <4.9864, 2.3123, -1.1038> <5.0658, 2.2756, -1.1220> <5.0889, 2.3123, -1.1410>
		<4.8701, 2.3123, -1.5290> <4.9092, 2.3123, -1.5557> <4.9774, 2.2756, -1.5991> <5.0005, 2.3123, -1.6182>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0550, 2.3123, -0.0015> <5.0550, 2.3123, 0.4849> <5.0889, 2.3123, 1.1406> <5.0005, 2.3123, 1.6189>
		<5.1082, 2.3929, -0.0015> <5.1082, 2.3929, 0.4849> <5.1372, 2.3890, 1.1805> <5.0487, 2.3890, 1.6587>
		<5.1326, 2.5303, -0.0016> <5.1326, 2.5303, 0.5071> <5.1681, 2.5282, 1.1996> <5.0756, 2.5282, 1.6997>
		<5.1250, 2.6266, -0.0016> <5.1250, 2.6266, 0.5071> <5.1605, 2.6266, 1.1928> <5.0680, 2.6266, 1.6929>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0550, 2.3123, -0.0015> <5.1082, 2.3929, -0.0015> <5.1326, 2.5303, -0.0016> <5.1250, 2.6266, -0.0016>
		<5.0550, 2.3123, -0.4868> <5.1082, 2.3929, -0.4868> <5.1326, 2.5303, -0.5090> <5.1250, 2.6266, -0.5090>
		<5.0889, 2.3123, -1.1410> <5.1372, 2.3890, -1.1808> <5.1680, 2.5282, -1.1999> <5.1605, 2.6266, -1.1931>
		<5.0005, 2.3123, -1.6182> <5.0488, 2.3890, -1.6580> <5.0756, 2.5282, -1.6989> <5.0680, 2.6266, -1.6921>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.1250, 2.6266, -0.0016> <5.1250, 2.6266, 0.5071> <5.1605, 2.6266, 1.1928> <5.0680, 2.6266, 1.6929>
		<5.1160, 2.7405, -0.0015> <5.1160, 2.7405, 0.5071> <5.1514, 2.7448, 1.1846> <5.0589, 2.7448, 1.6847>
		<5.1089, 2.9475, -0.0015> <5.1089, 2.9475, 0.4709> <5.1264, 2.9537, 1.1749> <5.0405, 2.9499, 1.6394>
		<5.0017, 2.9870, -0.0014> <5.0017, 2.9870, 0.4710> <5.0346, 2.9885, 1.1079> <4.9487, 2.9847, 1.5724>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.1250, 2.6266, -0.0016> <5.1160, 2.7405, -0.0015> <5.1089, 2.9475, -0.0015> <5.0017, 2.9870, -0.0014>
		<5.1250, 2.6266, -0.5090> <5.1160, 2.7405, -0.5090> <5.1089, 2.9475, -0.4728> <5.0017, 2.9870, -0.4728>
		<5.1605, 2.6266, -1.1931> <5.1514, 2.7448, -1.1850> <5.1264, 2.9537, -1.1752> <5.0346, 2.9885, -1.1082>
		<5.0680, 2.6266, -1.6921> <5.0589, 2.7448, -1.6839> <5.0405, 2.9499, -1.6386> <4.9487, 2.9847, -1.5717>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0017, 2.9870, -0.0014> <5.0017, 2.9870, 0.4710> <5.0346, 2.9885, 1.1079> <4.9487, 2.9847, 1.5724>
		<4.8639, 3.0378, -0.0014> <4.8639, 3.0378, 0.4711> <4.9046, 3.0378, 1.0130> <4.8187, 3.0339, 1.4775>
		<4.6782, 2.8693, -0.0056> <4.6782, 2.8693, 0.3773> <4.7168, 2.8739, 0.9449> <4.6534, 2.8723, 1.3225>
		<4.5335, 2.8448, -0.0012> <4.5335, 2.8448, 0.3817> <4.5580, 2.8454, 0.8969> <4.4945, 2.8438, 1.2744>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0017, 2.9870, -0.0014> <4.8639, 3.0378, -0.0014> <4.6782, 2.8693, -0.0056> <4.5335, 2.8448, -0.0012>
		<5.0017, 2.9870, -0.4728> <4.8639, 3.0378, -0.4727> <4.6782, 2.8693, -0.3876> <4.5335, 2.8448, -0.3831>
		<5.0346, 2.9885, -1.1082> <4.9045, 3.0378, -1.0134> <4.7171, 2.8740, -0.9438> <4.5579, 2.8454, -0.8971>
		<4.9487, 2.9847, -1.5717> <4.8187, 3.0339, -1.4768> <4.6538, 2.8724, -1.3204> <4.4945, 2.8438, -1.2738>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5335, 2.8448, -0.0012> <4.5335, 2.8448, 0.3817> <4.5580, 2.8454, 0.8969> <4.4945, 2.8438, 1.2744>
		<4.3886, 2.8203, 0.0033> <4.3886, 2.8203, 0.3861> <4.4404, 2.8244, 0.8613> <4.3770, 2.8227, 1.2389>
		<4.1913, 2.8292, 0.0177> <4.1913, 2.8292, 0.4026> <4.1463, 2.8293, 0.9209> <4.2053, 2.8326, 1.3012>
		<4.0447, 2.8251, 0.0278> <4.0447, 2.8251, 0.4126> <4.0221, 2.8257, 0.9298> <4.0812, 2.8289, 1.3100>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.5335, 2.8448, -0.0012> <4.3886, 2.8203, 0.0033> <4.1913, 2.8292, 0.0177> <4.0447, 2.8251, 0.0278>
		<4.5335, 2.8448, -0.3831> <4.3886, 2.8203, -0.3787> <4.1913, 2.8292, -0.3860> <4.0447, 2.8251, -0.3760>
		<4.5579, 2.8454, -0.8971> <4.4399, 2.8243, -0.8626> <4.1457, 2.8293, -0.9080> <4.0213, 2.8256, -0.9183>
		<4.4945, 2.8438, -1.2738> <4.3765, 2.8226, -1.2393> <4.2055, 2.8326, -1.3074> <4.0812, 2.8289, -1.3176>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2259, 2.8093, -0.0009> <3.2259, 2.8093, -0.4141> <3.1889, 2.8087, -0.9644> <3.1869, 2.8082, -1.3775>
		<3.2920, 2.8100, 0.0045> <3.2920, 2.8100, -0.4086> <3.2447, 2.8098, -0.9547> <3.2427, 2.8093, -1.3679>
		<3.3798, 2.8123, 0.0154> <3.3798, 2.8123, -0.4005> <3.3794, 2.8143, -0.9552> <3.3186, 2.8126, -1.3665>
		<3.4458, 2.8140, 0.0221> <3.4458, 2.8140, -0.3938> <3.4358, 2.8156, -0.9509> <3.3750, 2.8139, -1.3623>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2259, 2.8093, -0.0009> <3.2078, 2.8091, -0.0024> <3.1729, 2.8277, -0.0010> <3.1655, 2.8111, -0.0010>
		<3.2259, 2.8093, -0.4141> <3.2078, 2.8091, -0.4155> <3.1729, 2.8277, -0.4232> <3.1655, 2.8111, -0.4232>
		<3.1889, 2.8087, -0.9644> <3.1652, 2.8082, -0.9684> <3.1421, 2.8061, -0.9729> <3.1324, 2.7885, -0.9862>
		<3.1869, 2.8082, -1.3775> <3.1632, 2.8078, -1.3816> <3.1222, 2.8263, -1.3942> <3.1125, 2.8088, -1.4075>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2259, 2.8093, -0.0009> <3.2920, 2.8100, 0.0045> <3.3798, 2.8123, 0.0154> <3.4458, 2.8140, 0.0221>
		<3.2259, 2.8093, 0.4129> <3.2920, 2.8100, 0.4183> <3.3798, 2.8123, 0.4157> <3.4458, 2.8140, 0.4224>
		<3.1889, 2.8087, 0.9641> <3.2447, 2.8098, 0.9528> <3.3786, 2.8143, 0.9640> <3.4352, 2.8156, 0.9589>
		<3.1869, 2.8082, 1.3780> <3.2427, 2.8093, 1.3667> <3.3184, 2.8126, 1.3598> <3.3750, 2.8139, 1.3547>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2259, 2.8093, -0.0009> <3.2259, 2.8093, 0.4129> <3.1889, 2.8087, 0.9641> <3.1869, 2.8082, 1.3780>
		<3.2078, 2.8091, -0.0024> <3.2078, 2.8091, 0.4114> <3.1654, 2.8082, 0.9689> <3.1634, 2.8078, 1.3828>
		<3.1729, 2.8277, -0.0010> <3.1729, 2.8277, 0.4220> <3.1421, 2.8061, 0.9726> <3.1222, 2.8263, 1.3946>
		<3.1655, 2.8111, -0.0010> <3.1655, 2.8111, 0.4220> <3.1324, 2.7885, 0.9859> <3.1125, 2.8088, 1.4079>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1655, 2.8111, -0.0010> <3.1426, 2.7603, -0.0010> <3.1446, 2.6823, -0.0011> <3.1440, 2.6266, -0.0011>
		<3.1655, 2.8111, -0.4232> <3.1426, 2.7603, -0.4233> <3.1446, 2.6823, -0.4557> <3.1440, 2.6266, -0.4557>
		<3.1324, 2.7885, -0.9862> <3.1067, 2.7418, -1.0216> <3.1086, 2.6903, -1.0558> <3.1078, 2.6266, -1.0612>
		<3.1125, 2.8088, -1.4075> <3.0869, 2.7621, -1.4429> <3.0878, 2.6903, -1.5100> <3.0870, 2.6266, -1.5153>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1655, 2.8111, -0.0010> <3.1655, 2.8111, 0.4220> <3.1324, 2.7885, 0.9859> <3.1125, 2.8088, 1.4079>
		<3.1426, 2.7603, -0.0010> <3.1426, 2.7603, 0.4220> <3.1067, 2.7418, 1.0213> <3.0869, 2.7621, 1.4434>
		<3.1446, 2.6823, -0.0011> <3.1446, 2.6823, 0.4543> <3.1086, 2.6903, 1.0556> <3.0878, 2.6903, 1.5105>
		<3.1440, 2.6266, -0.0011> <3.1440, 2.6266, 0.4543> <3.1078, 2.6266, 1.0609> <3.0870, 2.6266, 1.5158>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1440, 2.6266, -0.0011> <3.1431, 2.5322, -0.0011> <3.1258, 2.4001, -0.0010> <3.1605, 2.3123, -0.0010>
		<3.1440, 2.6266, -0.4557> <3.1431, 2.5322, -0.4557> <3.1258, 2.4001, -0.4358> <3.1605, 2.3123, -0.4357>
		<3.1078, 2.6266, -1.0612> <3.1065, 2.5304, -1.0693> <3.0911, 2.3939, -1.0528> <3.1259, 2.3123, -1.0148>
		<3.0870, 2.6266, -1.5153> <3.0857, 2.5304, -1.5234> <3.0712, 2.3939, -1.4871> <3.1060, 2.3123, -1.4491>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1440, 2.6266, -0.0011> <3.1440, 2.6266, 0.4543> <3.1078, 2.6266, 1.0609> <3.0870, 2.6266, 1.5158>
		<3.1431, 2.5322, -0.0011> <3.1431, 2.5322, 0.4543> <3.1065, 2.5304, 1.0690> <3.0857, 2.5304, 1.5239>
		<3.1258, 2.4001, -0.0010> <3.1258, 2.4001, 0.4344> <3.0911, 2.3939, 1.0525> <3.0712, 2.3939, 1.4875>
		<3.1605, 2.3123, -0.0010> <3.1605, 2.3123, 0.4345> <3.1259, 2.3123, 1.0146> <3.1060, 2.3123, 1.4496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2684, 2.3123, -0.0010> <3.2684, 2.3123, -0.4117> <3.2383, 2.3123, -0.9589> <3.2210, 2.3123, -1.3692>
		<3.2361, 2.3123, -0.0010> <3.2361, 2.3123, -0.4117> <3.2038, 2.3123, -0.9828> <3.1865, 2.3123, -1.3932>
		<3.1725, 2.2822, -0.0010> <3.1725, 2.2822, -0.4357> <3.1410, 2.2768, -0.9983> <3.1212, 2.2768, -1.4326>
		<3.1605, 2.3123, -0.0010> <3.1605, 2.3123, -0.4357> <3.1259, 2.3123, -1.0148> <3.1060, 2.3123, -1.4491>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.2684, 2.3123, -0.0010> <3.2361, 2.3123, -0.0010> <3.1725, 2.2822, -0.0010> <3.1605, 2.3123, -0.0010>
		<3.2684, 2.3123, 0.4105> <3.2361, 2.3123, 0.4105> <3.1725, 2.2822, 0.4345> <3.1605, 2.3123, 0.4345>
		<3.2383, 2.3123, 0.9586> <3.2038, 2.3123, 0.9826> <3.1411, 2.2768, 0.9980> <3.1259, 2.3123, 1.0146>
		<3.2210, 2.3123, 1.3697> <3.1865, 2.3123, 1.3937> <3.1212, 2.2768, 1.4331> <3.1060, 2.3123, 1.4496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.8701, 2.3123, -1.5290> <4.9092, 2.3123, -1.5557> <4.9774, 2.2756, -1.5991> <5.0005, 2.3123, -1.6182>
		<4.8498, 2.3123, -1.6475> <4.8890, 2.3123, -1.6742> <4.9533, 2.2756, -1.7290> <4.9764, 2.3123, -1.7481>
		<4.7157, 2.3123, -1.7821> <4.7430, 2.3123, -1.8141> <4.8038, 2.2790, -1.8670> <4.8191, 2.3123, -1.8877>
		<4.6054, 2.3123, -1.8299> <4.6327, 2.3123, -1.8619> <4.6811, 2.2790, -1.9159> <4.6964, 2.3123, -1.9366>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0005, 2.3123, -1.6182> <5.0488, 2.3890, -1.6580> <5.0756, 2.5282, -1.6989> <5.0680, 2.6266, -1.6921>
		<4.9764, 2.3123, -1.7481> <5.0247, 2.3890, -1.7878> <5.0504, 2.5282, -1.8347> <5.0428, 2.6266, -1.8279>
		<4.8191, 2.3123, -1.8877> <4.8552, 2.3908, -1.9365> <4.8847, 2.5279, -1.9823> <4.8783, 2.6266, -1.9739>
		<4.6964, 2.3123, -1.9366> <4.7325, 2.3908, -1.9854> <4.7564, 2.5279, -2.0334> <4.7500, 2.6266, -2.0251>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0680, 2.6266, -1.6921> <5.0589, 2.7448, -1.6839> <5.0405, 2.9499, -1.6386> <4.9487, 2.9847, -1.5717>
		<5.0428, 2.6266, -1.8279> <5.0337, 2.7448, -1.8197> <5.0172, 2.9488, -1.7648> <4.9254, 2.9836, -1.6978>
		<4.8783, 2.6266, -1.9739> <4.8708, 2.7417, -1.9642> <4.8486, 2.9428, -1.9139> <4.7726, 2.9768, -1.8335>
		<4.7500, 2.6266, -2.0251> <4.7425, 2.7417, -2.0154> <4.7296, 2.9374, -1.9614> <4.6536, 2.9714, -1.8810>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.9487, 2.9847, -1.5717> <4.8187, 3.0339, -1.4768> <4.6538, 2.8724, -1.3204> <4.4945, 2.8438, -1.2738>
		<4.9254, 2.9836, -1.6978> <4.7953, 3.0329, -1.6030> <4.6372, 2.8719, -1.4186> <4.4780, 2.8433, -1.3720>
		<4.7726, 2.9768, -1.8335> <4.6672, 3.0239, -1.7219> <4.4810, 2.8685, -1.5954> <4.3683, 2.8405, -1.4845>
		<4.6536, 2.9714, -1.8810> <4.5482, 3.0186, -1.7694> <4.3899, 2.8661, -1.6354> <4.2772, 2.8381, -1.5245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.8701, 2.3123, 1.5297> <4.8499, 2.3123, 1.6482> <4.7157, 2.3123, 1.7829> <4.6054, 2.3123, 1.8306>
		<4.9092, 2.3123, 1.5565> <4.8890, 2.3123, 1.6750> <4.7430, 2.3123, 1.8149> <4.6327, 2.3123, 1.8626>
		<4.9773, 2.2756, 1.5999> <4.9533, 2.2756, 1.7298> <4.8038, 2.2790, 1.8678> <4.6810, 2.2790, 1.9166>
		<5.0005, 2.3123, 1.6189> <4.9764, 2.3123, 1.7488> <4.8191, 2.3123, 1.8885> <4.6964, 2.3123, 1.9373>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0005, 2.3123, 1.6189> <4.9764, 2.3123, 1.7488> <4.8191, 2.3123, 1.8885> <4.6964, 2.3123, 1.9373>
		<5.0487, 2.3890, 1.6587> <5.0247, 2.3890, 1.7886> <4.8552, 2.3908, 1.9373> <4.7325, 2.3908, 1.9861>
		<5.0756, 2.5282, 1.6997> <5.0504, 2.5282, 1.8355> <4.8847, 2.5279, 1.9831> <4.7564, 2.5279, 2.0342>
		<5.0680, 2.6266, 1.6929> <5.0429, 2.6266, 1.8287> <4.8783, 2.6266, 1.9748> <4.7500, 2.6266, 2.0258>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.0680, 2.6266, 1.6929> <5.0429, 2.6266, 1.8287> <4.8783, 2.6266, 1.9748> <4.7500, 2.6266, 2.0258>
		<5.0589, 2.7448, 1.6847> <5.0338, 2.7448, 1.8205> <4.8709, 2.7417, 1.9650> <4.7425, 2.7417, 2.0161>
		<5.0405, 2.9499, 1.6394> <5.0172, 2.9488, 1.7656> <4.8487, 2.9428, 1.9147> <4.7296, 2.9374, 1.9622>
		<4.9487, 2.9847, 1.5724> <4.9254, 2.9836, 1.6986> <4.7727, 2.9768, 1.8342> <4.6536, 2.9714, 1.8817>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.9487, 2.9847, 1.5724> <4.9254, 2.9836, 1.6986> <4.7727, 2.9768, 1.8342> <4.6536, 2.9714, 1.8817>
		<4.8187, 3.0339, 1.4775> <4.7954, 3.0329, 1.6037> <4.6673, 3.0239, 1.7226> <4.5482, 3.0186, 1.7700>
		<4.6534, 2.8723, 1.3225> <4.6369, 2.8719, 1.4206> <4.4803, 2.8683, 1.5969> <4.3891, 2.8659, 1.6368>
		<4.4945, 2.8438, 1.2744> <4.4781, 2.8433, 1.3726> <4.3683, 2.8405, 1.4851> <4.2772, 2.8381, 1.5251>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6054, 2.3123, -1.8299> <4.6327, 2.3123, -1.8619> <4.6811, 2.2790, -1.9159> <4.6964, 2.3123, -1.9366>
		<4.4319, 2.3123, -1.9050> <4.4592, 2.3123, -1.9370> <4.4797, 2.2790, -1.9963> <4.4950, 2.3123, -2.0169>
		<4.1700, 2.3123, -1.9155> <4.1694, 2.3123, -1.9490> <4.1943, 2.2842, -2.0090> <4.1959, 2.3123, -2.0272>
		<3.9810, 2.3123, -1.9138> <3.9805, 2.3123, -1.9473> <3.9774, 2.2842, -2.0072> <3.9791, 2.3123, -2.0255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6964, 2.3123, -1.9366> <4.7325, 2.3908, -1.9854> <4.7564, 2.5279, -2.0334> <4.7500, 2.6266, -2.0251>
		<4.4950, 2.3123, -2.0169> <4.5311, 2.3908, -2.0657> <4.5458, 2.5279, -2.1174> <4.5394, 2.6266, -2.1091>
		<4.1959, 2.3123, -2.0272> <4.2009, 2.3948, -2.0808> <4.2301, 2.5286, -2.1289> <4.2267, 2.6266, -2.1198>
		<3.9791, 2.3123, -2.0255> <3.9841, 2.3948, -2.0791> <4.0034, 2.5286, -2.1271> <4.0000, 2.6266, -2.1180>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7500, 2.6266, -2.0251> <4.7425, 2.7417, -2.0154> <4.7296, 2.9374, -1.9614> <4.6536, 2.9714, -1.8810>
		<4.5394, 2.6266, -2.1091> <4.5319, 2.7417, -2.0994> <4.5341, 2.9287, -2.0395> <4.4581, 2.9627, -1.9590>
		<4.2267, 2.6266, -2.1198> <4.2231, 2.7313, -2.1101> <4.2086, 2.9154, -2.0596> <4.1678, 2.9497, -1.9690>
		<4.0000, 2.6266, -2.1180> <3.9964, 2.7313, -2.1083> <3.9981, 2.9060, -2.0580> <3.9574, 2.9403, -1.9673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6536, 2.9714, -1.8810> <4.5482, 3.0186, -1.7694> <4.3899, 2.8661, -1.6354> <4.2772, 2.8381, -1.5245>
		<4.4581, 2.9627, -1.9590> <4.3527, 3.0098, -1.8474> <4.2478, 2.8624, -1.6978> <4.1351, 2.8343, -1.5869>
		<4.1678, 2.9497, -1.9690> <4.1172, 2.9923, -1.8563> <3.9599, 2.8520, -1.7181> <3.9198, 2.8291, -1.5959>
		<3.9574, 2.9403, -1.9673> <3.9067, 2.9829, -1.8547> <3.8047, 2.8475, -1.7166> <3.7646, 2.8246, -1.5945>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6054, 2.3123, 1.8306> <4.4319, 2.3123, 1.9055> <4.1700, 2.3123, 1.9155> <3.9810, 2.3123, 1.9138>
		<4.6327, 2.3123, 1.8626> <4.4592, 2.3123, 1.9375> <4.1694, 2.3123, 1.9490> <3.9805, 2.3123, 1.9473>
		<4.6810, 2.2790, 1.9166> <4.4796, 2.2790, 1.9968> <4.1942, 2.2842, 2.0090> <3.9774, 2.2842, 2.0072>
		<4.6964, 2.3123, 1.9373> <4.4950, 2.3123, 2.0175> <4.1959, 2.3123, 2.0272> <3.9791, 2.3123, 2.0255>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6964, 2.3123, 1.9373> <4.4950, 2.3123, 2.0175> <4.1959, 2.3123, 2.0272> <3.9791, 2.3123, 2.0255>
		<4.7325, 2.3908, 1.9861> <4.5311, 2.3908, 2.0663> <4.2009, 2.3948, 2.0808> <3.9841, 2.3948, 2.0791>
		<4.7564, 2.5279, 2.0342> <4.5458, 2.5279, 2.1180> <4.2301, 2.5286, 2.1289> <4.0034, 2.5286, 2.1271>
		<4.7500, 2.6266, 2.0258> <4.5394, 2.6266, 2.1097> <4.2267, 2.6266, 2.1198> <4.0000, 2.6266, 2.1180>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.7500, 2.6266, 2.0258> <4.5394, 2.6266, 2.1097> <4.2267, 2.6266, 2.1198> <4.0000, 2.6266, 2.1180>
		<4.7425, 2.7417, 2.0161> <4.5319, 2.7417, 2.1000> <4.2231, 2.7313, 2.1101> <3.9964, 2.7313, 2.1083>
		<4.7296, 2.9374, 1.9622> <4.5340, 2.9287, 2.0400> <4.2086, 2.9154, 2.0597> <3.9981, 2.9060, 2.0580>
		<4.6536, 2.9714, 1.8817> <4.4580, 2.9627, 1.9595> <4.1678, 2.9497, 1.9690> <3.9574, 2.9403, 1.9673>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.6536, 2.9714, 1.8817> <4.4580, 2.9627, 1.9595> <4.1678, 2.9497, 1.9690> <3.9574, 2.9403, 1.9673>
		<4.5482, 3.0186, 1.7700> <4.3526, 3.0098, 1.8479> <4.1172, 2.9923, 1.8564> <3.9067, 2.9829, 1.8547>
		<4.3891, 2.8659, 1.6368> <4.2470, 2.8622, 1.6992> <3.9594, 2.8517, 1.7183> <3.8043, 2.8473, 1.7168>
		<4.2772, 2.8381, 1.5251> <4.1351, 2.8343, 1.5874> <3.9198, 2.8291, 1.5960> <3.7646, 2.8246, 1.5945>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.9810, 2.3123, 1.9138> <3.7425, 2.3123, 1.9117> <3.3857, 2.3123, 1.9570> <3.1918, 2.3123, 1.8182>
		<3.9805, 2.3123, 1.9473> <3.7420, 2.3123, 1.9452> <3.3500, 2.3123, 1.9888> <3.1560, 2.3123, 1.8500>
		<3.9774, 2.2842, 2.0072> <3.7038, 2.2842, 2.0050> <3.3179, 2.2742, 2.0514> <3.0895, 2.2742, 1.9007>
		<3.9791, 2.3123, 2.0255> <3.7055, 2.3123, 2.0233> <3.3010, 2.3123, 2.0749> <3.0725, 2.3123, 1.9242>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.9791, 2.3123, 2.0255> <3.7055, 2.3123, 2.0233> <3.3010, 2.3123, 2.0749> <3.0725, 2.3123, 1.9242>
		<3.9841, 2.3948, 2.0791> <3.7104, 2.3948, 2.0769> <3.2662, 2.3904, 2.1231> <3.0378, 2.3904, 1.9724>
		<4.0034, 2.5286, 2.1271> <3.7172, 2.5286, 2.1248> <3.2900, 2.5289, 2.1789> <3.0512, 2.5289, 2.0213>
		<4.0000, 2.6266, 2.1180> <3.7138, 2.6266, 2.1157> <3.2909, 2.6266, 2.1697> <3.0520, 2.6266, 2.0121>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.0000, 2.6266, 2.1180> <3.7138, 2.6266, 2.1157> <3.2909, 2.6266, 2.1697> <3.0520, 2.6266, 2.0121>
		<3.9964, 2.7313, 2.1083> <3.7102, 2.7313, 2.1060> <3.2916, 2.7193, 2.1610> <3.0527, 2.7193, 2.0034>
		<3.9981, 2.9060, 2.0580> <3.7325, 2.8941, 2.0558> <3.2693, 2.9047, 2.0980> <3.0494, 2.8705, 1.9524>
		<3.9574, 2.9403, 1.9673> <3.6917, 2.9284, 1.9651> <3.2972, 2.9351, 2.0145> <3.0774, 2.9009, 1.8690>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.9574, 2.9403, 1.9673> <3.6917, 2.9284, 1.9651> <3.2972, 2.9351, 2.0145> <3.0774, 2.9009, 1.8690>
		<3.9067, 2.9829, 1.8547> <3.6411, 2.9710, 1.8525> <3.3326, 2.9735, 1.9090> <3.1127, 2.9393, 1.7634>
		<3.8043, 2.8473, 1.7168> <3.6387, 2.8425, 1.7152> <3.3153, 2.8291, 1.6737> <3.1602, 2.8247, 1.6156>
		<3.7646, 2.8246, 1.5945> <3.5991, 2.8199, 1.5928> <3.3736, 2.8120, 1.5729> <3.2186, 2.8076, 1.5148>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.9810, 2.3123, -1.9138> <3.9805, 2.3123, -1.9473> <3.9774, 2.2842, -2.0072> <3.9791, 2.3123, -2.0255>
		<3.7425, 2.3123, -1.9118> <3.7420, 2.3123, -1.9453> <3.7038, 2.2842, -2.0051> <3.7055, 2.3123, -2.0233>
		<3.3857, 2.3123, -1.9566> <3.3499, 2.3123, -1.9884> <3.3179, 2.2742, -2.0510> <3.3009, 2.3123, -2.0745>
		<3.1918, 2.3123, -1.8177> <3.1560, 2.3123, -1.8495> <3.0895, 2.2742, -1.9002> <3.0725, 2.3123, -1.9237>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.9791, 2.3123, -2.0255> <3.9841, 2.3948, -2.0791> <4.0034, 2.5286, -2.1271> <4.0000, 2.6266, -2.1180>
		<3.7055, 2.3123, -2.0233> <3.7104, 2.3948, -2.0769> <3.7172, 2.5286, -2.1248> <3.7138, 2.6266, -2.1157>
		<3.3009, 2.3123, -2.0745> <3.2662, 2.3904, -2.1227> <3.2900, 2.5289, -2.1784> <3.2908, 2.6266, -2.1693>
		<3.0725, 2.3123, -1.9237> <3.0378, 2.3904, -1.9719> <3.0512, 2.5289, -2.0208> <3.0520, 2.6266, -2.0116>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.0000, 2.6266, -2.1180> <3.9964, 2.7313, -2.1083> <3.9981, 2.9060, -2.0580> <3.9574, 2.9403, -1.9673>
		<3.7138, 2.6266, -2.1157> <3.7102, 2.7313, -2.1060> <3.7325, 2.8941, -2.0559> <3.6917, 2.9284, -1.9652>
		<3.2908, 2.6266, -2.1693> <3.2916, 2.7193, -2.1606> <3.2692, 2.9047, -2.0976> <3.2972, 2.9351, -2.0141>
		<3.0520, 2.6266, -2.0116> <3.0527, 2.7193, -2.0029> <3.0494, 2.8705, -1.9519> <3.0774, 2.9009, -1.8684>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.9574, 2.9403, -1.9673> <3.9067, 2.9829, -1.8547> <3.8047, 2.8475, -1.7166> <3.7646, 2.8246, -1.5945>
		<3.6917, 2.9284, -1.9652> <3.6411, 2.9710, -1.8526> <3.6391, 2.8427, -1.7150> <3.5991, 2.8199, -1.5929>
		<3.2972, 2.9351, -2.0141> <3.3326, 2.9735, -1.9086> <3.3146, 2.8293, -1.6730> <3.3736, 2.8120, -1.5726>
		<3.0774, 2.9009, -1.8684> <3.1127, 2.9393, -1.7629> <3.1596, 2.8249, -1.6147> <3.2186, 2.8076, -1.5143>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1918, 2.3123, -1.8177> <3.1560, 2.3123, -1.8495> <3.0895, 2.2742, -1.9002> <3.0725, 2.3123, -1.9237>
		<3.0822, 2.3123, -1.7392> <3.0465, 2.3123, -1.7710> <2.9704, 2.2742, -1.8216> <2.9534, 2.3123, -1.8451>
		<3.2153, 2.3123, -1.5039> <3.1808, 2.3123, -1.5279> <3.1146, 2.2768, -1.5752> <3.0995, 2.3123, -1.5917>
		<3.2210, 2.3123, -1.3692> <3.1865, 2.3123, -1.3932> <3.1212, 2.2768, -1.4326> <3.1060, 2.3123, -1.4491>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0725, 2.3123, -1.9237> <3.0378, 2.3904, -1.9719> <3.0512, 2.5289, -2.0208> <3.0520, 2.6266, -2.0116>
		<2.9534, 2.3123, -1.8451> <2.9187, 2.3904, -1.8932> <2.9266, 2.5289, -1.9385> <2.9274, 2.6266, -1.9294>
		<3.0995, 2.3123, -1.5917> <3.0647, 2.3939, -1.6296> <3.0789, 2.5304, -1.6725> <3.0802, 2.6266, -1.6644>
		<3.1060, 2.3123, -1.4491> <3.0712, 2.3939, -1.4871> <3.0857, 2.5304, -1.5234> <3.0870, 2.6266, -1.5153>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0520, 2.6266, -2.0116> <3.0527, 2.7193, -2.0029> <3.0494, 2.8705, -1.9519> <3.0774, 2.9009, -1.8684>
		<2.9274, 2.6266, -1.9294> <2.9282, 2.7193, -1.9207> <2.9325, 2.8523, -1.8744> <2.9605, 2.8827, -1.7910>
		<3.0802, 2.6266, -1.6644> <3.0810, 2.6903, -1.6591> <3.0802, 2.7689, -1.5840> <3.1059, 2.8155, -1.5486>
		<3.0870, 2.6266, -1.5153> <3.0878, 2.6903, -1.5100> <3.0869, 2.7621, -1.4429> <3.1125, 2.8088, -1.4075>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0774, 2.9009, -1.8684> <3.1127, 2.9393, -1.7629> <3.1596, 2.8249, -1.6147> <3.2186, 2.8076, -1.5143>
		<2.9605, 2.8827, -1.7910> <2.9958, 2.9211, -1.6854> <3.1201, 2.8237, -1.5999> <3.1792, 2.8065, -1.4995>
		<3.1059, 2.8155, -1.5486> <3.1155, 2.8331, -1.5352> <3.1630, 2.8077, -1.4237> <3.1867, 2.8082, -1.4196>
		<3.1125, 2.8088, -1.4075> <3.1222, 2.8263, -1.3942> <3.1632, 2.8078, -1.3816> <3.1869, 2.8082, -1.3775>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1918, 2.3123, 1.8182> <3.0822, 2.3123, 1.7397> <3.2153, 2.3123, 1.5044> <3.2210, 2.3123, 1.3697>
		<3.1560, 2.3123, 1.8500> <3.0464, 2.3123, 1.7715> <3.1808, 2.3123, 1.5284> <3.1865, 2.3123, 1.3937>
		<3.0895, 2.2742, 1.9007> <2.9703, 2.2742, 1.8221> <3.1146, 2.2768, 1.5757> <3.1212, 2.2768, 1.4331>
		<3.0725, 2.3123, 1.9242> <2.9534, 2.3123, 1.8456> <3.0995, 2.3123, 1.5922> <3.1060, 2.3123, 1.4496>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0725, 2.3123, 1.9242> <2.9534, 2.3123, 1.8456> <3.0995, 2.3123, 1.5922> <3.1060, 2.3123, 1.4496>
		<3.0378, 2.3904, 1.9724> <2.9186, 2.3904, 1.8938> <3.0647, 2.3939, 1.6301> <3.0712, 2.3939, 1.4875>
		<3.0512, 2.5289, 2.0213> <2.9265, 2.5289, 1.9391> <3.0789, 2.5304, 1.6730> <3.0857, 2.5304, 1.5239>
		<3.0520, 2.6266, 2.0121> <2.9274, 2.6266, 1.9300> <3.0802, 2.6266, 1.6649> <3.0870, 2.6266, 1.5158>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0520, 2.6266, 2.0121> <2.9274, 2.6266, 1.9300> <3.0802, 2.6266, 1.6649> <3.0870, 2.6266, 1.5158>
		<3.0527, 2.7193, 2.0034> <2.9281, 2.7193, 1.9213> <3.0810, 2.6903, 1.6596> <3.0878, 2.6903, 1.5105>
		<3.0494, 2.8705, 1.9524> <2.9324, 2.8523, 1.8750> <3.0802, 2.7689, 1.5845> <3.0869, 2.7621, 1.4434>
		<3.0774, 2.9009, 1.8690> <2.9604, 2.8827, 1.7915> <3.1059, 2.8155, 1.5490> <3.1125, 2.8088, 1.4079>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.0774, 2.9009, 1.8690> <2.9604, 2.8827, 1.7915> <3.1059, 2.8155, 1.5490> <3.1125, 2.8088, 1.4079>
		<3.1127, 2.9393, 1.7634> <2.9958, 2.9211, 1.6860> <3.1155, 2.8331, 1.5357> <3.1222, 2.8263, 1.3946>
		<3.1602, 2.8247, 1.6156> <3.1208, 2.8236, 1.6008> <3.1632, 2.8077, 1.4249> <3.1634, 2.8078, 1.3828>
		<3.2186, 2.8076, 1.5148> <3.1792, 2.8065, 1.5000> <3.1867, 2.8082, 1.4201> <3.1869, 2.8082, 1.3780>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7646, 2.8246, -1.5945> <3.9198, 2.8291, -1.5959> <4.1351, 2.8343, -1.5869> <4.2772, 2.8381, -1.5245>
		<3.7407, 2.8110, -1.5216> <3.8959, 2.8154, -1.5231> <4.0751, 2.8194, -1.5278> <4.2172, 2.8231, -1.4654>
		<3.7506, 2.8220, -1.4131> <3.8499, 2.8241, -1.4068> <3.9947, 2.8267, -1.4104> <4.0938, 2.8296, -1.4022>
		<3.7500, 2.8219, -1.3351> <3.8493, 2.8240, -1.3289> <3.9820, 2.8260, -1.3258> <4.0812, 2.8289, -1.3176>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7646, 2.8246, -1.5945> <3.7407, 2.8110, -1.5216> <3.7506, 2.8220, -1.4131> <3.7500, 2.8219, -1.3351>
		<3.5991, 2.8199, -1.5929> <3.5751, 2.8062, -1.5200> <3.6380, 2.8196, -1.4202> <3.6374, 2.8195, -1.3423>
		<3.3736, 2.8120, -1.5726> <3.4064, 2.8024, -1.5167> <3.4779, 2.8164, -1.4186> <3.4875, 2.8167, -1.3538>
		<3.2186, 2.8076, -1.5143> <3.2514, 2.7980, -1.4585> <3.3654, 2.8137, -1.4271> <3.3750, 2.8139, -1.3623>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7646, 2.8246, 1.5945> <3.5991, 2.8199, 1.5928> <3.3736, 2.8120, 1.5729> <3.2186, 2.8076, 1.5148>
		<3.7403, 2.8107, 1.5193> <3.5747, 2.8060, 1.5177> <3.4069, 2.8023, 1.5153> <3.2519, 2.7979, 1.4573>
		<3.7506, 2.8220, 1.4078> <3.6381, 2.8196, 1.4149> <3.4772, 2.8164, 1.4111> <3.3649, 2.8136, 1.4211>
		<3.7500, 2.8219, 1.3276> <3.6374, 2.8195, 1.3347> <3.4873, 2.8167, 1.3447> <3.3750, 2.8139, 1.3547>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7646, 2.8246, 1.5945> <3.7403, 2.8107, 1.5193> <3.7506, 2.8220, 1.4078> <3.7500, 2.8219, 1.3276>
		<3.9198, 2.8291, 1.5960> <3.8954, 2.8152, 1.5208> <3.8499, 2.8241, 1.4015> <3.8493, 2.8240, 1.3213>
		<4.1351, 2.8343, 1.5874> <4.0742, 2.8192, 1.5266> <3.9953, 2.8268, 1.4034> <3.9819, 2.8260, 1.3171>
		<4.2772, 2.8381, 1.5251> <4.2163, 2.8229, 1.4643> <4.0946, 2.8297, 1.3963> <4.0812, 2.8289, 1.3100>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7500, 2.8219, -1.3351> <3.7469, 2.8215, -0.9189> <3.7523, 2.8230, -0.3638> <3.7523, 2.8230, 0.0525>
		<3.6374, 2.8195, -1.3423> <3.6343, 2.8191, -0.9260> <3.6599, 2.8213, -0.3647> <3.6599, 2.8213, 0.0516>
		<3.4875, 2.8167, -1.3538> <3.5483, 2.8184, -0.9425> <3.5377, 2.8164, -0.3844> <3.5377, 2.8164, 0.0314>
		<3.3750, 2.8139, -1.3623> <3.4358, 2.8156, -0.9509> <3.4458, 2.8140, -0.3938> <3.4458, 2.8140, 0.0221>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7500, 2.8219, -1.3351> <3.8493, 2.8240, -1.3289> <3.9820, 2.8260, -1.3258> <4.0812, 2.8289, -1.3176>
		<3.7469, 2.8215, -0.9189> <3.8462, 2.8236, -0.9126> <3.9222, 2.8227, -0.9265> <4.0213, 2.8256, -0.9183>
		<3.7523, 2.8230, -0.3638> <3.8403, 2.8246, -0.3629> <3.9569, 2.8227, -0.3699> <4.0447, 2.8251, -0.3760>
		<3.7523, 2.8230, 0.0525> <3.8403, 2.8246, 0.0534> <3.9569, 2.8227, 0.0339> <4.0447, 2.8251, 0.0278>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7500, 2.8219, 1.3276> <3.6374, 2.8195, 1.3347> <3.4873, 2.8167, 1.3447> <3.3750, 2.8139, 1.3547>
		<3.7469, 2.8215, 0.9451> <3.6344, 2.8191, 0.9522> <3.5476, 2.8184, 0.9489> <3.4352, 2.8156, 0.9589>
		<3.7523, 2.8230, 0.4350> <3.6599, 2.8213, 0.4341> <3.5377, 2.8164, 0.4318> <3.4458, 2.8140, 0.4224>
		<3.7523, 2.8230, 0.0525> <3.6599, 2.8213, 0.0516> <3.5377, 2.8164, 0.0314> <3.4458, 2.8140, 0.0221>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.7500, 2.8219, 1.3276> <3.7469, 2.8215, 0.9451> <3.7523, 2.8230, 0.4350> <3.7523, 2.8230, 0.0525>
		<3.8493, 2.8240, 1.3213> <3.8462, 2.8236, 0.9388> <3.8403, 2.8246, 0.4359> <3.8403, 2.8246, 0.0534>
		<3.9819, 2.8260, 1.3171> <3.9229, 2.8227, 0.9369> <3.9569, 2.8227, 0.4187> <3.9569, 2.8227, 0.0339>
		<4.0812, 2.8289, 1.3100> <4.0221, 2.8257, 0.9298> <4.0447, 2.8251, 0.4126> <4.0447, 2.8251, 0.0278>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4945, 2.8438, -1.2738> <4.3765, 2.8226, -1.2393> <4.2055, 2.8326, -1.3074> <4.0812, 2.8289, -1.3176>
		<4.4945, 2.8438, -1.2738> <4.3600, 2.8222, -1.3374> <4.2181, 2.8333, -1.3920> <4.0938, 2.8296, -1.4022>
		<4.4945, 2.8438, -1.2738> <4.3600, 2.8222, -1.3374> <4.3083, 2.8255, -1.4254> <4.2172, 2.8231, -1.4654>
		<4.4945, 2.8438, -1.2738> <4.4780, 2.8433, -1.3720> <4.3683, 2.8405, -1.4845> <4.2772, 2.8381, -1.5245>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1869, 2.8082, -1.3775> <3.1867, 2.8082, -1.4196> <3.1792, 2.8065, -1.4995> <3.2186, 2.8076, -1.5143>
		<3.1869, 2.8082, -1.3775> <3.2425, 2.8093, -1.4100> <3.2120, 2.7969, -1.4437> <3.2514, 2.7980, -1.4585>
		<3.1869, 2.8082, -1.3775> <3.2425, 2.8093, -1.4100> <3.3090, 2.8123, -1.4313> <3.3654, 2.8137, -1.4271>
		<3.1869, 2.8082, -1.3775> <3.2427, 2.8093, -1.3679> <3.3186, 2.8126, -1.3665> <3.3750, 2.8139, -1.3623>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.4945, 2.8438, 1.2744> <4.4781, 2.8433, 1.3726> <4.3683, 2.8405, 1.4851> <4.2772, 2.8381, 1.5251>
		<4.4945, 2.8438, 1.2744> <4.3606, 2.8223, 1.3371> <4.3075, 2.8253, 1.4243> <4.2163, 2.8229, 1.4643>
		<4.4945, 2.8438, 1.2744> <4.3606, 2.8223, 1.3371> <4.2187, 2.8333, 1.3875> <4.0946, 2.8297, 1.3963>
		<4.4945, 2.8438, 1.2744> <4.3770, 2.8227, 1.2389> <4.2053, 2.8326, 1.3012> <4.0812, 2.8289, 1.3100>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.1869, 2.8082, 1.3780> <3.2427, 2.8093, 1.3667> <3.3184, 2.8126, 1.3598> <3.3750, 2.8139, 1.3547>
		<3.1869, 2.8082, 1.3780> <3.2425, 2.8093, 1.4088> <3.3083, 2.8123, 1.4262> <3.3649, 2.8136, 1.4211>
		<3.1869, 2.8082, 1.3780> <3.2425, 2.8093, 1.4088> <3.2125, 2.7968, 1.4425> <3.2519, 2.7979, 1.4573>
		<3.1869, 2.8082, 1.3780> <3.1867, 2.8082, 1.4201> <3.1792, 2.8065, 1.5000> <3.2186, 2.8076, 1.5148>
	}

}

// wind shield part 1
#declare W_SH_PRT01=
union{
   cylinder { <0, 0, 0> <0, 0, 4-24> .5 }
   cylinder { <0, 4, -24> <0, 15, -24> .5 }

   intersection{
       torus { 4, .5 rotate z*90 }
       box{ <1, 0, -6> <-1, -6, 0> }
       translate < 0, 4, 4-24>
   }
}

// wind shield object
#declare Wind_Shield01=
union{
   object { W_SH_PRT01 }
   object { W_SH_PRT01 scale <1, -1, 1> translate y*30}
   cone { <0, 0, 0>.5 <0, -5, 0>1 rotate x*10 scale <1, 1, 1.5> translate z*(4-24)}
   box{ <-.5, 0, 0> <.5, -5, 4-24> }
   union{
      torus { 1, .2 rotate x*90}
      cylinder { <0, 0, -.2> <0, 0, .2> 1 }
      cylinder { <0, 0, -1> <0, 0, 1> .2 }
      sphere { <0, 0, -1> .5 }
      cylinder { <0, 0, -.5> < -49, -45, 9 > 0.3 texture { METAL01 } }
      sphere { <0, 0, -.5> 0.3 texture { METAL01 } }
      sphere { <-49, -45, 9> 0.3 texture { METAL01 } }
      texture {T_Gold_3D}
      translate <.5, 17, -24.5>
   }
   union{
      torus { .2, .2 rotate x*90 translate y*5 }
      cylinder { <0, 0, -.2> <0, 0, .2> .2 translate y*5 }
      torus { .2, .2 rotate x*90 translate y*-5 }
      cylinder { <0, 0, -.2> <0, 0, .2> .2 translate y*-5 }
      cylinder { <-.2, -5, 0> <-.2, 5, 0> .2 }
      cylinder { <.2, -5, 0> <.2, 5, 0> .2 }
      box{ <-.2, 5, .2> <.2, -5, -.2> }

      union{
         object{ BLT01 scale .5 rotate x*-90 translate <0, 2.5, -.2> }
         object{ BLT01 scale .5 rotate x*-90 translate <0, 4.5, -.2> }
         object{ BLT01 scale .5 rotate x*-90 translate <0, -2.5, -.2> }
         object{ BLT01 scale .5 rotate x*-90 translate <0, -4.5, -.2> }
         texture { METAL01 }
      }
      texture {T_Gold_3D}
      translate <0, 17, -24.5>
  }

  union{
      union{
         torus { 2, .2 rotate z*90}
         cylinder { <0, 0, 0> <.2, 0, 0> 2 texture { METAL01 }}
         cylinder { <0, 0, 0> <-.2, 0, 0> 2}
         torus { 1.5, .2 rotate z*90 translate x*-.2}
         cylinder { <-.4, 0, 0> <-.2, 0, 0> 1.5}
         sphere { <-.8, 0, 0> .4 }
         translate x*.8
         rotate y*-5
      }
      cylinder { <0, 0, 0> <0, 0, 4> .2}
      cylinder { <0, .5, 4> <0, -.5, 4> .7}
      torus { .5, .2 translate <0, .5, 4>}
      torus { .5, .2 translate <0, -.5, 4>}
      translate <0, 10, -28>
      texture {T_Gold_3D}
   }

   cylinder { <0, 16.7, -24> <0, 16.7, 0>.3 }
   cylinder { <0, 17.3, -24> <0, 17.3, 0>.3 }

   #declare LAMP_F_R = 0
   #include "lamps.inc"
   // side lamp
   object { LAMP01 scale <1, 1, -1>*.3 translate <0, -4, -20>}
   texture { METAL01 }
}

// body
#declare T_BODY01=
union{
   union{
      union{
         // bucket
         object { BODY01}
          union{
            #include "door01.inc"
            // doors
            object {DOOR02}
            object {DOOR02 scale <1, 1, -1> }
          }
          texture { BODY_TEX01 }
      }
      // chrome-plated shield
      object { BODY02 texture { METAL01 } }
      // seats
      object { BODY03 texture { Upholsery_TEX01 } }
      // trunk cover
      object { BODY04 texture { Upholsery_TEX02 } }
   translate x*2.4317
   scale <11, 11, 12>
   }

   union{
      // windshield left
      object { Wind_Shield01 }
      #declare WS_LNG01 = 20
      #declare WS_HGT01 = 30 - 4 - 17.3
      #declare WS_RAD01 = 4
      #declare WS_NUM01 = 5
      #declare WS_NUM00 = WS_NUM01
      #declare WS_ANG01 = 90/(WS_NUM01+1)
      #declare WS_THK01 = 0.2
      #include "ws_glass01.inc"
      // windshied glass 1
      object { WS_GLASS01
         rotate x*-90
         rotate y*90
         translate y*17.3
         texture {T_Glass01}
      }
      // windshield right
      object { Wind_Shield01 scale <1, 1, -1>}
      #declare WS_LNG01 = 20
      #declare WS_HGT01 = 30  - 16.7
      #declare WS_RAD01 = 4
      #declare WS_NUM01 = 5
      #declare WS_NUM00 = WS_NUM01
      #declare WS_ANG01 = 90/(WS_NUM01+1)
      #declare WS_THK01 = .2
      #include "ws_glass01.inc"
      // windshied glass 2
      object { WS_GLASS01
         rotate x*-90
         rotate y*90
         scale <1, -1, 1>
         translate y*16.7
         texture {T_Glass01}
      }
      translate < 10, 35, 0>
   }

   #include "box01.inc"
   // trunk + rear lamps
   object {BOX00
      rotate y*180
      translate <79, 26, 0>
      texture { BTEX pigment{color rgb <1,.5,.0>}}
   }
}
