
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod trunk + rear lamps
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

// trunk part1
#declare BOX01=
union{
   box{ < 0, 0, -20> < 21, -10, 0 > }
   box{ < 0, 0, -17> < 21, -13, 0 > }
   cylinder { < 0, -10, -17 > < 21, -10, -17 > 3 }

   cylinder { < 4, -4, -20 > < 17, -4, -20 > .5 }
   cylinder { < 4, -9.5, -20 > < 17, -9.5, -20 > .5 }
   cylinder { < 4, -9.5, -20 > < 4, -4, -20 > .5 }
   cylinder { < 17, -9.5, -20 > < 17, -4, -20 > .5 }
   sphere { < 4, -9.5, -20 > .5 }
   sphere { < 4, -4, -20 > .5 }
   sphere { < 17, -9.5, -20 > .5 }
   sphere { < 17, -4, -20 > .5 }

   cylinder { <0, 0, -22> <0, -10, -22> .2 }
   torus { 5, .2 rotate z*90 translate< 0, -10, -17> }
   cylinder { <0, -15, 0> <0, -15, -17> .2 }

   cylinder { <-2, 0, -22> <-2, -10, -22> .2 }
   torus { 5, .2 rotate z*90 translate< -2, -10, -17> }
   cylinder { <-2, -15, 0> <-2, -15, -17> .2 }

   box{ < .2, 0, 0 > < -2.2, -15, -17> }
   box{ < .2, 0, -17 > < -2.2, -10, -22> }
   cylinder { < .2, -10, -17> < -2.2, -10, -17> 5 }

   box{ < 0, 0, 0 > < -2, -15.2, -17> }
   box{ < 0, 0, -17 > < -2, -10, -22.2> }
   cylinder { < 0, -10, -17> < -2, -10, -17> 5.2 }

   box{ < -2, -12, 0 > < -2.8, -13.5, -17> }
   box{ < -2, 0, -19 > < -2.8, -10, -20.5> }
   difference{
      intersection{
         cylinder { < -2, -10, -17> < -2.8, -10, -17> 3.5 }
         box{ < -1, -10, -17> < -5, -17, -25> }
      }
      cylinder { < -1, -10, -17> < -5, -10, -17> 2 }
   }
   cylinder { < -2.8, -13.3, 0 > < -2.8, -13.3, -17> .2 }
   cylinder { < -2.8, -12.2, 0 > < -2.8, -12.2, -17> .2 }
   cylinder { < -2.8, 0, -20.3 > < -2.8, -10, -20.3> .2 }
   cylinder { < -2.8, 0, -19.2 > < -2.8, -10, -19.2> .2 }
   intersection{
      torus { 3.3, .2 rotate z*90 translate< -2.8, -10, -17> }
      box{ < -1, -10, -17> < -5, -17, -25> }
   }
   intersection{
      torus { 2.2, .2 rotate z*90 translate< -2.8, -10, -17> }
      box{ < -1, -10, -17> < -5, -17, -25> }
   }
   box{ < -3, -12.2, 0 > < -2.8, -13.3, -17> }
   box{ < -3, 0, -19.2 > < -2.8, -10, -20.3> }
   difference{
      intersection{
         cylinder { < -3, -10, -17> < -2.8, -10, -17> 3.3 }
         box{ < -1, -10, -17> < -5, -17, -25> }
      }
      cylinder { < -1, -10, -17> < -5, -10, -17> 2.2 }
   }
   box{ < -2, 0, 0 > < -2.8, -1.5, -20> }
   cylinder { < -2.8, -1.3, 0 > < -2.8, -1.3, -20> .2 }
   box{ < -3, 0, 0 > < -2.8, -1.3, -20> }

   cylinder { < -2, -4, 0 > < -2, -4, -11 > .5 }
   cylinder { < -2, -9.5, 0 > < -2, -9.5, -11 > .5 }
   cylinder { < -2, -9.5, -11 > < -2, -4, -11 > .5 }
   sphere { < -2, -9.5, -11 > .5 }
   sphere { < -2, -4, -11 > .5 }

   cylinder { < -2, -12.5, -15.5 > < -2, -4, -15.5 > .5 }
   cylinder { < -2, -12.5, -14.5 > < -2, -4, -14.5 > .5 }
   cylinder { < -2, -4, -15.5 > < -2, -4, -14.5 > .5 }
   sphere { < -2, -4, -14.5 > .5 }
   sphere { < -2, -4, -15.5 > .5 }
   box { < -2.5, -4, -14.5 > < -2, -12.5, -15.5 > }

   object { BLT01 scale .7 rotate z*90 translate < -2.5, -5.5, -15 > texture {METAL01}}
   object { BLT01 scale .7 rotate z*90 translate < -2.5, -8, -15 > texture {METAL01}}
   object { BLT01 scale .7 rotate z*90 translate < -2.5, -10.5, -15 > texture {METAL01}}

   #declare LAMP_F_R = 1
   #include "lamps.inc"
   // rear lamp
   object {LAMP01 scale .3 translate < -1, -3, 22 > }
}

// trunk
#declare BOX00=
union{
   object { BOX01 }
   object { BOX01 scale <1, 1, -1> }
   #declare LG_TH01 = 1.5
   #include "logo.inc"
   // logo
   object { F_logo01 scale .05 rotate x*-90 rotate y*90 translate < -2.3, -7.5, 0 > }
}
