
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod brake wires
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi


// #declare Ang = F_AXL_ROT01
#declare End01 = vrotate ( <8.5,0,0> <0, Ang, 0> ) + <0,0,-F_AXL_LNG01>
#declare End02 = <45,0,0>
#declare Z_Coefficient = 18
#declare Y_Coefficient = 1
#declare Y_Coefficient0 = Y_Coefficient

#declare Total_Length = sqrt ( pow ( vlength ( End02 - End01 ), 2 ) - pow ( Y_Coefficient, 2 ) )

#declare Amplitude_Decline_Coefficient_Z = .96
#declare Amplitude_Decline_Coefficient_Y = .9
#declare Sphere_Radius = .4
#declare Number_of_Waves = 1.5
#declare Count_per_Wave = 72
#declare Starting_Angle = 45
#declare Angle = 360 / Count_per_Wave
#declare Count = Number_of_Waves * Count_per_Wave - 1
#declare X_Distance = Total_Length / Count
#declare X_Origin = 0

#declare Brake01 =
union{
   sphere {
      < X_Origin,
        cos ( radians ( Starting_Angle ) ) * Y_Coefficient,
        sin ( radians ( Starting_Angle ) ) * Z_Coefficient >
        Sphere_Radius*1.5

        texture { METAL01 }
    }
   #while ( Count >= 0 )
      sphere { < X_Origin, cos ( radians ( Starting_Angle ) ) * Y_Coefficient, sin ( radians ( Starting_Angle ) ) * Z_Coefficient > Sphere_Radius }

      cylinder {
         < X_Origin, cos ( radians ( Starting_Angle ) ) * Y_Coefficient, sin ( radians ( Starting_Angle ) ) * Z_Coefficient >
         < X_Origin + X_Distance, cos ( radians ( Starting_Angle + Angle ) ) * Y_Coefficient* Amplitude_Decline_Coefficient_Y,
         sin ( radians ( Starting_Angle + Angle ) ) * Z_Coefficient* Amplitude_Decline_Coefficient_Z >
         Sphere_Radius
      }

      #declare Starting_Angle = Starting_Angle + Angle
      #declare X_Origin = X_Origin + X_Distance
      #declare Z_Coefficient = Z_Coefficient * Amplitude_Decline_Coefficient_Z
      #declare Y_Coefficient = Y_Coefficient * Amplitude_Decline_Coefficient_Y
      #declare Count = Count - 1

   #end
   translate < 0,-Y_Coefficient0,0 >
}
