
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod for IRTC / Great Engineering Achievements January-February 1998
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi


// -------------------------------------------------------------------------------
// THIS FILE IS INCLUDED HERE ONLY BECAUSE I WANTED TO SHARE MY MODEL WITH OTHERS.
// I WOULD GREATLY APPRECIATE IF THE JUDGES DO NOT USE IT FOR THE PURPOSE OF
// EVALUATION OF MY IMAGE. THANKS YOU.
// -------------------------------------------------------------------------------


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metals.inc"
#include "golds.inc"


// car paint01
#declare BTEX_01 =
   texture{
      finish {
         ambient .2
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.1
      }
      normal {bumps 0.05 scale .5}
      pigment{color rgb <1,0.2,0>}
}

// car paint02
#declare BTEX_02 =
   texture{
      finish {
         ambient <1,.9,.05>*.3
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.3
      }
      normal {bumps 0.05 scale 20}
      pigment{color rgb <1,.5,.0>}
}

// metal textures
#declare METAL01 =  texture { T_Chrome_4D }
#declare METAL02 =  texture { Aluminum }

// frame part1
#declare FRAME_01 =
union{
   superellipsoid { <0.01, 0.1>
      translate < 1, 1, 0 >
      scale < 67/2, 1.5, 1 >
   }
   superellipsoid { <0.01, 0.1>
      translate < 1, 1, 0 >
      scale < 5, 1.5, 1 >
      rotate z*65
      translate x*67
   }
   superellipsoid { <0.01, 0.1>
      translate < 1, -1, 0 >
      scale < 3, 1.5, 1 >
      rotate z*-65
      translate < 10, 3, 0>
      rotate z*65
      translate x*67
   }
}

// frame object
#declare FRAME=
union{
   object { FRAME_01 translate z*-10 }
   object { FRAME_01 translate z*10 }
   superellipsoid { <1, 0.1> scale < 1.5, 1.5, 10.95 > translate y*1.5 }
   superellipsoid { <.1, 0.1>
      translate < -1, -1, 0 >
      scale < 1, 1.5, 10.95 >
      translate x*6
      rotate z*-65
      translate < 10, 3, 0>
      rotate z*65
      translate x*67
   }
   rotate z * 3
   scale 40 / 25
   texture {BTEX_02}
}

// exchaust pipes part 1
#declare TUBE_RAD01 = 1
#declare TUBE_NUM = 3
#declare TUBE_LNG00 = 14

#declare EXC_01 =
union{
   #while ( TUBE_NUM >= 0 )

      #switch ( TUBE_NUM )
         #case ( 0 )
            // TUBE_1
            #declare TUBE_LNG01 = TUBE_LNG00
            #declare TUBE_INT01 = 9.5 + TUBE_RAD01
            #declare TUBE_INT21 = TUBE_RAD01
            #declare TUBE_LNG21 = 11 -TUBE_INT21
            #declare TUBE_HGT21 = 15
            #declare TUBE_RAD21 = 4
            #declare TUBE_RAD11 = 3
         #break
         #case ( 1 )
            // TUBE_2
            #declare TUBE_LNG01 = TUBE_LNG00 + TUBE_RAD01 *2
            #declare TUBE_INT01 = TUBE_RAD01
            #declare TUBE_INT21 = 0
            #declare TUBE_LNG21 = 11 -TUBE_INT21
            #declare TUBE_HGT21 = 15
            #declare TUBE_RAD21 = 4
            #declare TUBE_RAD11 = 3
         #break
         #case ( 2 )
            // TUBE_3
            #declare TUBE_LNG01 = TUBE_LNG00
            #declare TUBE_INT01 = -TUBE_RAD01
            #declare TUBE_INT21 = TUBE_RAD01
            #declare TUBE_LNG21 = 11 -TUBE_INT21
            #declare TUBE_HGT21 = 15 + TUBE_RAD01 *2
            #declare TUBE_RAD21 = 4 + TUBE_RAD01*2
            #declare TUBE_RAD11 = 3
         #break
         #case ( 3 )
            // TUBE_4
            #declare TUBE_LNG01 = TUBE_LNG00 + TUBE_RAD01 *2
            #declare TUBE_INT01 = -9.5 - TUBE_RAD01
            #declare TUBE_INT21 = 0
            #declare TUBE_LNG21 = 11 -TUBE_INT21
            #declare TUBE_HGT21 = 15 + TUBE_RAD01 *2
            #declare TUBE_RAD21 = 4 + TUBE_RAD01*2
            #declare TUBE_RAD11 = 3
         #break
      #end

#declare TUBE_LNG11 =
   sqrt ( pow ( sqrt ( pow ( ( TUBE_HGT21 -TUBE_RAD21 ), 2 )
   + pow ( ( TUBE_INT01 -TUBE_INT21 ), 2 ) ), 2 ) - pow ( TUBE_RAD21, 2 ) )
   - TUBE_RAD11

#declare TUBE_ANG11 =
   pi - ( atan2 ( ( TUBE_HGT21 -TUBE_RAD21 ), ( TUBE_INT01 -TUBE_INT21 ) ) +
   acos ( TUBE_RAD21 / sqrt ( pow ( ( TUBE_HGT21 -TUBE_RAD21 ), 2 ) + pow ( ( TUBE_INT01 -TUBE_INT21 ), 2 ) ) ) )

union{
   cylinder { < -TUBE_INT01, 0, 0 > < -TUBE_INT01, 0, -TUBE_LNG01 > TUBE_RAD01 }

   cylinder { < -TUBE_LNG21 -TUBE_INT21, -TUBE_HGT21, -TUBE_LNG01 -TUBE_RAD11 >
              < -TUBE_INT21, -TUBE_HGT21, -TUBE_LNG01 -TUBE_RAD11 > TUBE_RAD01
   }

   difference{
      torus { TUBE_RAD21, TUBE_RAD01 }

      prism {
         linear_sweep linear_spline
         -TUBE_RAD01* 1.5, TUBE_RAD01* 1.5, 7,
         < 0, 0 >,
         < 0, ( TUBE_RAD21 +TUBE_RAD01 ) * 1.5 >,
         < ( TUBE_RAD21 +TUBE_RAD01 ) * -1.5, ( TUBE_RAD21 +TUBE_RAD01 ) * 1.5 >,
         < ( TUBE_RAD21 +TUBE_RAD01 ) * -1.5, ( TUBE_RAD21 +TUBE_RAD01 ) * -1.5 * sin ( TUBE_ANG11 ) - 15>,
         < ( TUBE_RAD21 +TUBE_RAD01 ) * 1.5 * cos ( TUBE_ANG11 ), ( TUBE_RAD21 +TUBE_RAD01 ) * -1.5 * sin ( TUBE_ANG11 ) - 15>,
         < ( TUBE_RAD21 +TUBE_RAD01 ) * 1.5 * cos ( TUBE_ANG11 ), ( TUBE_RAD21 +TUBE_RAD01 ) * -1.5 * sin ( TUBE_ANG11 )>,
         < 0, 0 >
      }

      rotate x*90
      translate < -TUBE_INT21, -TUBE_HGT21 + TUBE_RAD21, -TUBE_LNG01 -TUBE_RAD11 >
   }

   union{
      cylinder { < TUBE_RAD21, 0, 0 > < TUBE_RAD21, TUBE_LNG11, 0 > TUBE_RAD01}

      intersection{
         torus { TUBE_RAD11, TUBE_RAD01 }

         box {
            < ( TUBE_RAD11 +TUBE_RAD01 ) * 1.1, TUBE_RAD01 * -1.1, ( TUBE_RAD11 +TUBE_RAD01 ) * -1.1 >
            < 0, TUBE_RAD01 * 1.1, 0 >
         }

         rotate z*90
         translate < TUBE_RAD21, TUBE_LNG11, TUBE_RAD11 >
      }

      rotate z * degrees ( TUBE_ANG11 )
      translate < -TUBE_INT21 , -TUBE_HGT21 + TUBE_RAD21, -TUBE_LNG01 -TUBE_RAD11 >
   }
}
      #declare TUBE_NUM = TUBE_NUM - 1
   #end
}

#declare BLOB_DENS01 = .5
#declare BLOB_STRN01 = 2
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

#declare TUBE_LNG02 = 3
#declare TUBE_LNG12 = 10
#declare TUBE_RAD02 = 2.5

// exchaust pipes part 2
#declare EXC_02 =
blob{ threshold BLOB_DENS01
   cylinder{< 0, 0, 0 >, < -TUBE_LNG02, 0, 0 > TUBE_RAD01 * 1.05 / BLOB_A_R01, BLOB_STRN01
      translate < 0, TUBE_RAD01, TUBE_RAD01 >
   }
   cylinder{< 0, 0, 0 >, < -TUBE_LNG02, 0, 0 > TUBE_RAD01 * 1.05 / BLOB_A_R01, BLOB_STRN01
      translate < 0, TUBE_RAD01, -TUBE_RAD01 >
   }
   cylinder{< 0, 0, 0 >, < -TUBE_LNG02, 0, 0 > TUBE_RAD01 * 1.05 / BLOB_A_R01, BLOB_STRN01
      translate < 0, -TUBE_RAD01, TUBE_RAD01 >
   }
   cylinder{< 0, 0, 0 >, < -TUBE_LNG02, 0, 0 > TUBE_RAD01 * 1.05 / BLOB_A_R01, BLOB_STRN01
      translate < 0, -TUBE_RAD01, -TUBE_RAD01 >
   }

   #declare BLOB_STRN01 = 3
   #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   cylinder{< -TUBE_LNG12, 0, 0 >, < -TUBE_LNG02 * 1.3, 0, 0 > TUBE_RAD02 / BLOB_A_R01, BLOB_STRN01 }
}

#declare TUBE_LNG03 = 30
#declare TUBE_LNG13 = 5
#declare TUBE_RAD03 = 10
#declare TUBE_THK03 = .1

// exchaust pipes part 3
#declare EXC_03 =
union{
    difference {
       cylinder { < 0, 0, 0 > < -TUBE_LNG03, 0, 0 > TUBE_RAD02 }
       cylinder { < 1, 0, 0 > < -TUBE_LNG03 -1, 0, 0 > ( TUBE_RAD02 - TUBE_THK03 ) }
    }
    intersection{
       difference {
          torus { TUBE_RAD03, TUBE_RAD02 }
          torus { TUBE_RAD03, ( TUBE_RAD02 - TUBE_THK03 ) }
          translate < 0, 0, -TUBE_RAD03 >
       }
       box { < 0, TUBE_RAD02 * 1.5,  TUBE_RAD02 * 1.5 > < TUBE_RAD03 * -1.5, TUBE_RAD02 * -1.5, -TUBE_LNG13 > }
       translate < -TUBE_LNG03, 0, 0 >
    }
    rotate x*-30
}

// exchaust pipes object
#declare PIPE_01 =
union {
   object { EXC_01}
   object { EXC_02 translate < -11, -16, -(TUBE_LNG00 + 4)>}
   object { EXC_03 translate < -11 -TUBE_LNG12, -16, -(TUBE_LNG00 + 4)>}

   texture {
      finish { F_MetalC }
      pigment{  gradient z
         color_map{
            [ 0 color rgb <1,.45,0>*.7 ]
            [ 0.15 color rgb <1,.45,0>*.7 ]
            [ 0.6 color rgb .6 ]
            [ 1 color rgb .6 ]
         }
         scale TUBE_LNG01*2.5
      }
   }
}


#declare R_AXL_LNG01 = 27
#declare R_AXL_RAD01 = 1.9
#declare R_AXL_RAD02 = 6.5

#declare R_AXL_RAD12 = 5.8
#declare R_AXL_LNG12 = R_AXL_RAD01 + 1
#declare R_AXL_RAD22 = 5.3
#declare R_AXL_RAD32 = 4.8

#declare R_AXL_LNG42 = .5
#declare R_AXL_RAD42 = .25
#declare R_AXL_NUM42 = 11
#declare R_AXL_ANG42 = 360 / ( R_AXL_NUM42 +1 )

#declare R_AXL_RAD03 = 5
#declare R_AXL_RAD13 = 3
#declare R_AXL_LNG13 = 10
#declare R_AXL_RAD23 = 1.7
#declare R_AXL_HGT13 = 2
#declare R_AXL_THK03 = .5

#declare R_SHA_DST01 = 21
#declare R_SHA_RAD01 = 1
#declare R_SHA_INT01 = 7
#declare R_SHA_XXX01 = 4
#declare R_SHA_THK01 = .2

#declare R_SHA_RAD02 = .5

#declare R_SHA_ANG01 =
   90 - degrees ( atan2 ( ( R_AXL_RAD01 + R_SHA_XXX01 ), R_AXL_RAD01 *1.2 ) +
   asin ( R_SHA_RAD01 / vlength ( < R_AXL_RAD01, R_AXL_RAD01 *1.2, 0 > - <-R_SHA_XXX01, 0, 0 > ) ) )

#declare R_SHA_ANG02 =
   90 - degrees ( atan2 ( ( R_AXL_RAD01 + R_SHA_XXX01 ), ( R_SHA_INT01 - R_AXL_RAD01 *1.5 ) ) +
   acos ( R_SHA_RAD01 / vlength ( < R_AXL_RAD01, -R_AXL_RAD01 *1.5, 0 > - <-R_SHA_XXX01, -R_SHA_INT01, 0 > ) ) )

// rear shock absorber part1
#declare R_SHA_PRT01 =
union {
   cylinder { < R_AXL_RAD01, 0, R_AXL_RAD01 * 1.2 > < R_AXL_RAD01, 0, -R_AXL_RAD01 * 1.5 > R_SHA_THK01 }
   sphere { < R_AXL_RAD01, 0, R_AXL_RAD01 * 1.2 > R_SHA_THK01 }
   sphere { < R_AXL_RAD01, 0, -R_AXL_RAD01 * 1.5 > R_SHA_THK01 }

   torus { R_SHA_RAD01, R_SHA_THK01
      translate < -R_SHA_XXX01, 0, 0 >
   }
   cylinder { < 0, R_SHA_THK01, 0 > < 0, -R_SHA_THK01, 0 > R_SHA_RAD01
      translate < -R_SHA_XXX01, 0, 0 >
   }
   torus { R_SHA_RAD01, R_SHA_THK01
      translate < -R_SHA_XXX01, 0, -R_SHA_INT01 >
   }
   cylinder { < 0, R_SHA_THK01, 0 > < 0, -R_SHA_THK01, 0 > R_SHA_RAD01
      translate < -R_SHA_XXX01, 0, -R_SHA_INT01 >
   }
   cylinder { < -R_SHA_RAD01, 0, 0 > < -R_SHA_RAD01, 0, -R_SHA_INT01 > R_SHA_THK01
      translate < -R_SHA_XXX01, 0, 0 >
   }

   cylinder {
      vrotate (< 0, 0, R_SHA_RAD01 > <0, -R_SHA_ANG01, 0 > )
      < R_AXL_RAD01 + R_SHA_XXX01, 0, R_AXL_RAD01 * 1.2 >
      R_SHA_THK01
      translate < -R_SHA_XXX01, 0, 0 >
   }

   cylinder {
      ( vrotate ( < 0, 0, -R_SHA_RAD01 > < 0, R_SHA_ANG02, 0 > ) + < 0, 0, -R_SHA_INT01 > )
      < R_AXL_RAD01 + R_SHA_XXX01, 0, -R_AXL_RAD01 * 1.5>
      R_SHA_THK01
      translate < -R_SHA_XXX01, 0, 0 >
   }

   prism{ linear_sweep linear_spline -R_SHA_THK01, R_SHA_THK01, 7
      < R_AXL_RAD01, -R_AXL_RAD01 * 1.5 >,
      vrotate ( < 0, -R_SHA_RAD01 > < 0, 0, -R_SHA_ANG02 > ) + < -R_SHA_XXX01, -R_SHA_INT01 >,
      < -R_SHA_RAD01, -R_SHA_INT01 > + < -R_SHA_XXX01, 0 >,
      < -R_SHA_RAD01, 0 > + < -R_SHA_XXX01, 0 >,
      vrotate (< 0, R_SHA_RAD01 > <0, 0, R_SHA_ANG01 > ) + < -R_SHA_XXX01, 0 >,
      < R_AXL_RAD01, R_AXL_RAD01 * 1.2 >,
      < R_AXL_RAD01, -R_AXL_RAD01 * 1.5 >
   }
   rotate x*-90
}

#declare BLT_Thk01 = .25
#declare BLT_Rad01 = .6
#declare BLT_Rad02 = .6
#declare BLT_Rad03 = .2

// bolt
#declare BLT01=
union{
   intersection{
      union{
         cylinder { < 0, 0 ,0 > < 0, BLT_Thk01, 0 > BLT_Rad01 }
         sphere { < 0, BLT_Thk01, 0 > BLT_Rad01 }
      }
      #declare COUNT=6

      prism { linear_sweep linear_spline
         -1, ( BLT_Thk01 + BLT_Rad01 ) * 1.5 , COUNT+1,

         #while( COUNT >= 0)
            #declare Ang01 = pi/3 * COUNT

            < BLT_Rad01 * cos ( Ang01),BLT_Rad01 * sin ( Ang01) >
            #if (COUNT > 0 )
               ,
            #end
            #declare COUNT = COUNT - 1
         #end
      }
   }
   torus { BLT_Rad02, BLT_Rad03 translate y * - BLT_Rad03 }
   translate y * BLT_Rad03
}

#declare Total_Length = 7
#declare Sphere_Radius = .2
#declare Number_of_Waves = 8
#declare Count_per_Wave = 72
#declare Z_Radius = 1.5
#declare Y_Radius = Z_Radius
#declare Starting_Angle = 0
#declare Angle = 2 * pi / Count_per_Wave
#declare Count = Number_of_Waves * Count_per_Wave - 1
#declare X_Distance = Total_Length / Count
#declare X_Origin = 0

// rear shock absorber spring
#declare Coil02 =
union{
   #while ( Count >= 0 )

      sphere { < X_Origin, cos ( Starting_Angle ) * Y_Radius, sin ( Starting_Angle ) * Z_Radius > Sphere_Radius }

      cylinder {
         < X_Origin, cos ( Starting_Angle ) * Y_Radius, sin ( Starting_Angle ) * Z_Radius >
         < X_Origin + X_Distance, cos ( Starting_Angle + Angle ) * Y_Radius, sin ( Starting_Angle + Angle ) * Z_Radius >
         Sphere_Radius
      }

      #declare Starting_Angle = Starting_Angle + Angle
      #declare X_Origin = X_Origin + X_Distance
      #declare Count = Count - 1

   #end
}

#declare R_SHA_RAD13 = 1
#declare R_SHA_LNG13 = Total_Length / 2

#declare R_SHA_RAD23 = 0.5
#declare R_SHA_LNG23 = Total_Length

#declare R_SHA_RAD33 = 1.5
#declare R_SHA_RAD43 = .4

#declare R_SHA_LNG53 = 4

#declare R_SHA_RAD63 = 1.4
#declare R_SHA_RAD73 = 1.1

// rear shock absorber object
#declare R_SHA_01 =
union{
   object { Coil02 }
   cylinder { < 0, 0, 0 > < R_SHA_LNG13, 0, 0 > R_SHA_RAD13 }
   cylinder { < R_SHA_LNG13, 0, 0 > < R_SHA_LNG23, 0, 0 > R_SHA_RAD23 }
   torus { R_SHA_RAD33 R_SHA_RAD43
      rotate z* 90
    }
   torus { R_SHA_RAD33 R_SHA_RAD43
      rotate z* 90
      translate x*R_SHA_LNG23
   }
   cylinder { < 0, 0, 0 > < -R_SHA_LNG53, 0, 0 > R_SHA_RAD33 }
   superellipsoid { <1, .2 >
      scale R_SHA_RAD63
      rotate y* 90
      translate x*-R_SHA_LNG53
   }
   superellipsoid { <1, .2 >
      scale R_SHA_RAD63
      rotate y* 90
      translate x*R_SHA_LNG23
   }
   cylinder { < 0, 0, ( R_SHA_RAD33 + R_SHA_RAD43 ) *1.5 > < 0, 0, 0 > R_SHA_RAD73
      translate x* -( R_SHA_RAD63 + R_SHA_RAD73 + R_SHA_LNG53 )
   }
   superellipsoid { <1, .2 >
      scale R_SHA_RAD73
      translate x* -( R_SHA_RAD63 + R_SHA_RAD73 + R_SHA_LNG53 )
   }
   object { BLT01
      rotate x* -90
      translate < -( R_SHA_RAD63 + R_SHA_RAD73 + R_SHA_LNG53 ), 0, -R_SHA_RAD73 >
   }
   cylinder { < 0, 0, ( R_SHA_RAD33 + R_SHA_RAD43 ) *1.5 > < 0, 0, 0 > R_SHA_RAD73
      translate x* ( Total_Length + R_SHA_RAD43 + R_SHA_RAD73 )
   }
   superellipsoid { <1, .2 >
      scale R_SHA_RAD73
      translate x* ( Total_Length + R_SHA_RAD43 + R_SHA_RAD73 )
   }
   object { BLT01
      rotate x* -90
      translate < ( Total_Length + R_SHA_RAD43 + R_SHA_RAD73 ), 0, -R_SHA_RAD73 >
   }

   translate < ( R_SHA_RAD63 + R_SHA_RAD73 + R_SHA_LNG53 ), 0, -( R_SHA_RAD33 + R_SHA_RAD43 ) >
   rotate z* 75
   rotate y*-90
}

#declare ROD_LNG01 = 29
#declare ROD_RAD01 = .5
#declare ROD_LNG11 = 3
#declare ROD_DST01 = 1.75

// rear axle mount part 1
#declare ROD01 =
union{
   cylinder { <0, 0, 0> <-ROD_LNG01, 0, ROD_DST01> ROD_RAD01 }
   sphere { 0, (ROD_RAD01+R_SHA_RAD02) }
   sphere { 0, (ROD_RAD01+R_SHA_RAD02) translate <-ROD_LNG01, 0, ROD_DST01> }
   object { BLT01 rotate x*90 translate <-ROD_LNG01, 0, -(ROD_RAD01+R_SHA_RAD02)*.7+ROD_DST01> }
   cylinder { <-ROD_LNG01, 0, ROD_DST01> <-ROD_LNG01, 0, ROD_LNG11+ROD_DST01> R_SHA_RAD02 }
}

#declare MNT_RAD01 = 1.2
#declare MNT_THK01 = 1.5
#declare MNT_THK11 = .2
#declare MNT_LNG12 = 7

// rear axle mount part 2
#declare ROD_MNT01 =
union{
   cylinder { <0, 0, 0> <0, 0, -MNT_THK01> MNT_RAD01 }
   torus { MNT_RAD01 MNT_THK11 rotate x*90 translate z*-(MNT_THK01-MNT_THK11) }
   cylinder { <0, 0,-(MNT_THK01-MNT_THK11)> <0, 0, 0> (MNT_RAD01+MNT_THK11) }
   cylinder { <MNT_RAD01, 0, 0> <MNT_RAD01, MNT_LNG12, 0> MNT_THK11
      rotate z*-15
      translate z*-(MNT_THK01-MNT_THK11)
   }
   cylinder { <-MNT_RAD01, 0, 0> <-MNT_RAD01, MNT_LNG12, 0> MNT_THK11
      rotate z*15
      translate z*-(MNT_THK01-MNT_THK11)
   }
   prism {
     linear_sweep linear_spline
     -MNT_THK11, 0, 5
        vrotate ( <-MNT_RAD01, 0 > <0, 0, 15 > ),
        vrotate ( <-MNT_RAD01, MNT_LNG12 > <0, 0, 15 > ),
        vrotate ( <MNT_RAD01, MNT_LNG12 > <0, 0, -15 > ),
        vrotate ( <MNT_RAD01, 0 > <0, 0, -15 > ),
        vrotate ( <-MNT_RAD01, 0 > <0, 0, 15 > )
     rotate x*-90
     translate z*-MNT_THK01
   }
   prism {
     linear_sweep linear_spline
     0, MNT_THK01, 5
        vrotate ( <-MNT_RAD01-MNT_THK11, 0 > <0, 0, 15 > ),
        vrotate ( <-MNT_RAD01-MNT_THK11, MNT_LNG12 > <0, 0, 15 > ),
        vrotate ( <MNT_RAD01+MNT_THK11, MNT_LNG12 > <0, 0, -15 > ),
        vrotate ( <MNT_RAD01+MNT_THK11, 0 > <0, 0, -15 > ),
        vrotate ( <-MNT_RAD01-MNT_THK11, 0 > <0, 0, 15 > )
     rotate x*-90
   }
translate < -ROD_LNG01, 0, 0>
texture {BTEX_02}
rotate z*1
}

// rear axle mount object
#declare R_AXL_MNT01 =
union{
   object { R_SHA_PRT01 translate z* ( R_AXL_RAD01 - R_SHA_THK01 ) }
   object { R_SHA_PRT01 translate z* -( R_AXL_RAD01 - R_SHA_THK01 ) }

   object { BLT01
      rotate x* -90
      translate < -R_SHA_XXX01, -R_SHA_INT01, -R_AXL_RAD01 >
      texture { METAL01 }
   }

   object { BLT01
      rotate x* -90
      translate < -R_SHA_XXX01, 0, -R_AXL_RAD01 >
      texture { METAL01 }
   }
   object { BLT01
      rotate x* 90
      translate < -R_SHA_XXX01, -R_SHA_INT01, R_AXL_RAD01 >
      texture { METAL01 }
   }
   object { BLT01
      rotate x* 90
      translate < -R_SHA_XXX01, 0, R_AXL_RAD01 >
      texture { METAL01 }
   }

   object { ROD01
      rotate z*-4
      translate < -R_SHA_XXX01, -R_SHA_INT01, 0 >
      texture { METAL01 }
   }

   object { ROD01
      rotate z*-4
      translate < -R_SHA_XXX01, 0, 0 >
      texture { METAL01 }
   }
   union{
      object { ROD_MNT01 }
      object { ROD_MNT01 scale <1, 1, -1>}
      rotate z*-4
      translate < -R_SHA_XXX01, -R_SHA_INT01, 3.2+ROD_DST01 >
   }


   box { < R_AXL_RAD01 -R_SHA_THK01, R_AXL_RAD01 * 1.2, ( R_AXL_RAD01 - R_SHA_THK01 ) >
         < R_AXL_RAD01 +R_SHA_THK01, -R_AXL_RAD01 * 1.5, -( R_AXL_RAD01 - R_SHA_THK01 ) >
   }
   cylinder { < R_AXL_RAD01, R_AXL_RAD01 * 1.2, ( R_AXL_RAD01 - R_SHA_THK01 ) >
              < R_AXL_RAD01, R_AXL_RAD01 * 1.2, -( R_AXL_RAD01 - R_SHA_THK01 ) >
              R_SHA_THK01
   }
   cylinder { < R_AXL_RAD01, -R_AXL_RAD01 * 1.5, ( R_AXL_RAD01 - R_SHA_THK01 ) >
              < R_AXL_RAD01, -R_AXL_RAD01 * 1.5, -( R_AXL_RAD01 - R_SHA_THK01 ) >
              R_SHA_THK01
   }
   cylinder { < 0, 0, ( R_AXL_RAD01 - R_SHA_THK01 ) > < 0, 0, -( R_AXL_RAD01 - R_SHA_THK01 )> R_SHA_RAD02
      translate < -R_SHA_XXX01, 0, 0 >
      texture { METAL01 }
   }
   cylinder { < 0, 0, ( R_AXL_RAD01 - R_SHA_THK01 ) > < 0, 0, -( R_AXL_RAD01 - R_SHA_THK01 )> R_SHA_RAD02
      translate < -R_SHA_XXX01, -R_SHA_INT01, 0 >
      texture { METAL01 }
   }
   object { R_SHA_01
      translate < R_AXL_RAD01 +R_SHA_THK01, -1, 0 >
      texture { METAL01 }
   }
}

#declare BLOB_DENS01 = .5
#declare BLOB_STRN01 = 1
#declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )

// rear axle object
#declare REAR_END =
union{
   blob{ threshold BLOB_DENS01
      cylinder{< 0, 0, -R_AXL_LNG01 >, < 0, 0, R_AXL_LNG01 > R_AXL_RAD01 / BLOB_A_R01, BLOB_STRN01 }
      cylinder{< R_AXL_RAD01 * -10, 0, 0 >, < R_AXL_RAD01 * 10, 0, 0 > R_AXL_RAD02 / BLOB_A_R01, BLOB_STRN01 scale < .1, 1, 1 > }
   }

   cylinder{ < 0, 0, 0 >, < R_AXL_LNG12, 0, 0 > R_AXL_RAD12 texture { METAL01 } }
   sphere { 0, R_AXL_RAD32 scale < .7, 1, 1 > translate < R_AXL_LNG12, 0, 0 > texture { METAL01 } }
   #while ( R_AXL_NUM42 >= 0 )
       cylinder{ < R_AXL_LNG12, 0, 0 >, < R_AXL_LNG12 + R_AXL_LNG42, 0, 0 > R_AXL_RAD42
          translate z * R_AXL_RAD22
          rotate x * R_AXL_ANG42 * R_AXL_NUM42
          texture { METAL01 }
       }
       #declare R_AXL_NUM42 = R_AXL_NUM42 - 1
   #end

   superellipsoid { <.8, .8 >
      scale R_AXL_RAD03
      translate x * -R_AXL_RAD01
   }
   cone { < -R_AXL_RAD01, -R_AXL_HGT13, 0 > R_AXL_RAD13
          < -R_AXL_RAD01 -R_AXL_LNG13, -R_AXL_HGT13, 0 > R_AXL_RAD23
   }
   union{
      prism{ linear_sweep linear_spline -R_AXL_THK03, R_AXL_THK03, 5
         < -R_AXL_RAD01, R_AXL_RAD12 >,
         < -R_AXL_RAD01, -R_AXL_RAD12 >,
         < -R_AXL_RAD01 -R_AXL_LNG13, -R_AXL_HGT13>,
         < -R_AXL_RAD01 -R_AXL_LNG13, R_AXL_HGT13>,
         < -R_AXL_RAD01, R_AXL_RAD12 >
      }
      cylinder { < -R_AXL_RAD01, 0, R_AXL_RAD12 > < -R_AXL_RAD01 -R_AXL_LNG13, 0, R_AXL_HGT13> R_AXL_THK03 }
      sphere { < -R_AXL_RAD01, 0, R_AXL_RAD12 > R_AXL_THK03 }
      sphere { < -R_AXL_RAD01 -R_AXL_LNG13, 0, R_AXL_HGT13> R_AXL_THK03 }
      cylinder { < -R_AXL_RAD01, 0, -R_AXL_RAD12 > < -R_AXL_RAD01 -R_AXL_LNG13, 0, -R_AXL_HGT13> R_AXL_THK03 }
      sphere { < -R_AXL_RAD01, 0, -R_AXL_RAD12 > R_AXL_THK03 }
      sphere { < -R_AXL_RAD01 -R_AXL_LNG13, 0, -R_AXL_HGT13> R_AXL_THK03 }

      translate y * -R_AXL_HGT13
   }

   union{
      prism{ linear_sweep linear_spline -R_AXL_THK03, R_AXL_THK03, 5
         < -R_AXL_RAD01, R_AXL_RAD12 >,
         < -R_AXL_RAD01, -R_AXL_RAD12 >,
         < -R_AXL_RAD01 -R_AXL_LNG13, -R_AXL_HGT13 + R_AXL_HGT13>,
         < -R_AXL_RAD01 -R_AXL_LNG13, R_AXL_HGT13 + R_AXL_HGT13>,
         < -R_AXL_RAD01, R_AXL_RAD12 >
      }
      cylinder { < -R_AXL_RAD01, 0, R_AXL_RAD12 > < -R_AXL_RAD01 -R_AXL_LNG13, 0, R_AXL_HGT13 + R_AXL_HGT13> R_AXL_THK03 }
      sphere { < -R_AXL_RAD01, 0, R_AXL_RAD12 > R_AXL_THK03 }
      sphere { < -R_AXL_RAD01 -R_AXL_LNG13, 0, R_AXL_HGT13 + R_AXL_HGT13> R_AXL_THK03 }
      cylinder { < -R_AXL_RAD01, 0, -R_AXL_RAD12 > < -R_AXL_RAD01 -R_AXL_LNG13, 0, -R_AXL_HGT13 + R_AXL_HGT13> R_AXL_THK03 }
      sphere { < -R_AXL_RAD01, 0, -R_AXL_RAD12 > R_AXL_THK03 }
      sphere { < -R_AXL_RAD01 -R_AXL_LNG13, 0, -R_AXL_HGT13 + R_AXL_HGT13> R_AXL_THK03 }
      rotate  x*90
   }

   object { R_AXL_MNT01
      rotate z * 3
      translate z * -R_SHA_DST01
   }
   object { R_AXL_MNT01
      rotate z * 3
      scale < 1, 1, -1 >
      translate z * R_SHA_DST01
   }

   union{
      cylinder { < -R_AXL_RAD01 -R_AXL_LNG13, -R_AXL_HGT13, 0 > < 48-117.5+28.5, 6-6.5, 0 > 1.3 }
      sphere { < -R_AXL_RAD01 -R_AXL_LNG13, -R_AXL_HGT13, 0 > 1.5 }
      sphere { < 48-117.5+28.5, 6-6.5, 0 > 1.5 }
  }
// + rear wheels
#include "tyre01.inc"
   object {TY011 translate < 0, 0, -R_AXL_LNG01 >}
   object {TY02 translate < 0, 0, -R_AXL_LNG01 > texture { METAL01 }}

   object {TY011 rotate y*180 translate <0, 0, R_AXL_LNG01 >}
   object {TY02 rotate y*180 translate < 0, 0, R_AXL_LNG01 > texture { METAL01 }}

   texture {BTEX_01}
   translate < 117.5, 6.5, 0 >
}

background {color rgb <.2,.25,.5>}
camera{
   location<-500,300,-500>*1.2
   angle 10
   right 4/3*x
   look_at <0,17,0>
}

light_source {<-700,300,-1000>*3
color rgb 1.5 * <1, 1, .8>
}

// the car object
//#declare T_ROD01 =
union {

   union{
      #include "motor01.inc"
      // engine
      object { V8_Motor01 rotate z*90 }
      // exchaust pipes
      object { PIPE_01 scale < -1, 1, 1 >*.84 translate < 37.25 -48, 6, -10 > }
      object { PIPE_01 scale < -1, 1, -1 >*.84 translate < 37.25 -48, 6, 10 > }
      translate < 48, 6, 0 >
   }
   
   //frame
   object { FRAME }
   #include "parts02.inc"
   // front end
   object { FRONT_END translate < -11, -2, 0 > texture { METAL01 }}
   // rear end
   object { REAR_END }
   union{
      #declare RAD_ADD_LNG = 5
      #include "parts01.inc"
      // radiator
      object { RADIATOR }
      object { BLT01 translate < 0, 0, -12 > texture { METAL01 } }
      object { BLT01 translate < 0, 0, 12 > texture { METAL01 } }
      translate < 11, 5, 0 >
   }
   // front lamps
   #declare LAMP_F_R = 1
   #include "lamps.inc"
   object { LAMP02 texture { METAL01 } translate < 11,15,-18>}
   cone { <0, -11, 0>1.1 < 0, .5 - Lamp_RAD01, 0 >.6
      texture { METAL01 }
      rotate x*-10
      translate < 11,15,-18>
   }
   object { LAMP02 texture { METAL01 } translate < 11,15,18>}
   cone { <0, -11, 0>1.1 < 0, .5 - Lamp_RAD01, 0 >.6
      texture { METAL01 }
      rotate x*10
      translate < 11,15,18>
   }

   #include "body01.pov"
   // body
   object { T_BODY01 translate < 52, -2, 0> rotate z * 3}

   translate x*-57
}

#include "fence01.inc"
// fence object
object {FENCE01 scale .33 translate < 0,-10, 100 > }

#include "can01.inc"
// smashed aluminum cans
object {CAN01 texture {Aluminum} scale 1.5 rotate y*12 translate <-11, -10, -83> }
object {CAN02 texture {Aluminum} scale 1.5 rotate y*63 translate <35, -10, -54> }

// ground, reflective (water?)
plane { y, -10
   texture {
      T_Chrome_2B
      finish {
         irid {.5
            thickness .3
            turbulence .2
         }
       }
      normal {bumps .1 scale 20 }
   }
}
// ground, solid, texture
#declare Stone_TEX=
texture{
   finish{
      diffuse 0.9
      ambient 0.2
      reflection .2
      crand .1
      phong 0.7
      phong_size 100
      irid {.5
            thickness .3
            turbulence .2
         }
   }
   normal { dents 0.2 scale 3 }
   pigment {color rgb <1, .85, .7>*.7
   }
}

// ground, solid
height_field{
  gif
  "stone01.gif"
  translate <-0.5, 0, -0.5>
  smooth
  scale <500, 1.4, 500>
  translate y*-10.85
  texture {Stone_TEX}
}


