
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: fence
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

#declare FNC_TEX=
texture{
   finish{
      diffuse 0.9
      ambient 0.2
      phong 0.2
      phong_size 1
   }
   normal {dents scale 5}
   pigment{ bozo
      color_map {
         [ 0.0 color rgb <.5,.5,.5> ]
         [ 0.4 color rgb <.85,.82,.8>*.6 ]
         [ 0.5 color rgb <1,.5,0>*.5 ]
         [ 0.6 color rgb <.85,.82,.8>*.6 ]
         [ 1.0 color rgb <.5,.5,.5> ]
      }
      scale 3
   }
}

#declare FNC_HGT01 = 180*2/ sqrt (2)
#declare FNC_THK01 = .5
#declare FNC_THK02 = 15
#declare FNC_NUM00 = 34
#declare FNC_NUM01 = FNC_NUM00

#declare FNC_PRT01=
union{
  #while ( FNC_NUM01 >= 0 )
     cylinder { <0, 0, 0> <0, FNC_HGT01, 0> FNC_THK01
        rotate z*-45
        translate x*FNC_THK02*FNC_NUM01
     }
     #declare FNC_NUM01 = FNC_NUM01 -1
  #end
  translate x*-FNC_THK02*(FNC_NUM00+12)/2
}

#declare FNC_PRT02=
union{
   intersection{
      union{
         object{ FNC_PRT01 }
         object{ FNC_PRT01 scale < -1, 1, 1 >}
      }
      box { <-160, 0, -2> <160, 180, 2> }
   }
   box { <-160.5, -.5, -2> <160.5, .5, 2> }
   box { <-160.5, 179.5, -2> <160.5, 180.5, 2> }
   box { <-160.5, -.5, -2> <-160, 180.5, 2> }
   box { <160.5, -.5, -2> <160, 180.5, 2> }

   cylinder { <175, -10, 0> <175, 180, 0 > 5 }
   cone { <175, 180, 0> 5 <175, 185, 0 > 0 }
   cylinder { <160, 20, 0> <190, 20, 0 > 1 }
   cylinder { <160, 170, 0> <190, 170, 0 > 1 }
   translate y*6.5
}

#declare FNC_LNG10 = 175*2
#declare FNC_NUM10 = 6
#declare FNC_NUM02 = FNC_NUM10

#declare FENCE01=
union{
  #while ( FNC_NUM02 >= 0 )
     object { FNC_PRT02
        translate x*FNC_LNG10*FNC_NUM02
     }
     #declare FNC_NUM02 = FNC_NUM02 -1
  #end
  translate x*-FNC_LNG10*(FNC_NUM10+1)/2
  texture {FNC_TEX}
}
