
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod lamps
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

// lamp glass/plastic texture
#declare LAMP_PLASTIC =
texture{
   finish {
      ambient .2
      diffuse 0.7
      specular 0.80
      roughness 1/100
      reflection 0.2
   }
}

// #declare METAL01 =  texture { T_Chrome_4D }

// this controls red=1, and white=0 glass
// #declare LAMP_F_R = 1

// rear/side lamp
#declare LAMP01=
union{
   cylinder { < -7, 0, 0> <6, 0, 0> 6.5}
   sphere { 0, 6.5 scale <.7, 1, 1> translate x*6}
   torus { 6 1.5 rotate z*90 scale <1.2, 1, 1> translate x*-7 }

   difference{
      superellipsoid { <1, 1.4>
         rotate y*90
         scale <.5, 1, 1>*6.5
      }
      superellipsoid { <1, 1.7>
         rotate y*90
         scale <.5, 1, 1>*2
         translate x*-6.5*.5
      }
      translate x*-7.5

      texture {LAMP_PLASTIC
         normal { wood 1  scale .5 rotate z*90 rotate y*90 }
         #switch (LAMP_F_R)
            #case (0)
               pigment { color rgbf <.8, .8, .75, .2> }
            #break
            #case (1)
               pigment { color rgbf <.8, 0, 0, .2> }
            #break
         #end
      }
   }

   cylinder{ <0, 6, 0> <0, -8, 0> 3.8 }

   intersection{
      sphere { 0 6.3 scale <1, .75, 1> translate y*.2}
      cylinder { <0, -4, 0><0, 4, 0> 7 }
      translate y*-11
   }

   cone { <0, 6, 0> 3.8 <0, 10.5, 0> 5 }
   sphere { 0, 6 scale <1, .3, 1> translate y*10 }
   sphere { 0, 6 scale <1, .3, 1> translate y*11.5 }

   intersection{
      sphere { 0, 4.5 scale <1, .3, 1> }
      cylinder { <0, -.5, 0><0, 4, 0> 7 }
      translate y*15
   }

   difference {
      cylinder { <0, 0, 0> <0, -3, 0> 3.2 }
      cylinder { <0, 1, 0> <0, -4, 0> 2.7 }
      box{ <1, 1, 4> <-1, -4, -4> }
      box{ <1, 1, 4> <-1, -4, -4> rotate y*90 }
      translate y*15
   }

   cylinder { <0, 0, 0> <0, 0, -18> 1 }
   cylinder { <0, 0, 0> <0, 0, -8> 1.5 }
   torus { 1 .5 rotate x*90 translate z*-8 }
   cylinder { <0, 0, -15> <0, 0, -18> 1.5 }
   torus { 1 .5 rotate x*90 translate z*-15 }
   cylinder { <0, 0, -17> <0, 0, -18> 3 }
   torus { 3 .5 rotate x*90 translate z*-17.5 }

   translate z*18
   texture {METAL01}
}

// front lamp glass texture
#declare Lamp_GLS01 =
texture{
   finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      refraction 1
      ior 1.1
      reflection 0.2
   }
   normal { gradient x .2
               slope_map {
                  [0    <0, 1>]
                  [0.2  <1, 0>]
                  [0.5  <1,0>]
                  [0.7  <1, 0>]
                  [1    <0, 1>]
               }
               scale .7
               rotate x*90
            }
   pigment { color rgbt <1.2, 1.2, 1.2, .8> }
}


#declare Lamp_RAD00 = 1
#declare Lamp_RAD01 = 4.5
#declare Lamp_THK01 = 1
#declare Lamp_DST01 = .2

// front lamp
#declare LAMP02=
union{
   sphere { 0, Lamp_RAD00 translate z* ( Lamp_RAD01 - Lamp_THK01 - Lamp_RAD00 ) }
   difference{
      superellipsoid { < 1, 1.1 > scale <1, 1, 1.2>*Lamp_RAD01 }
      superellipsoid { < 1, 1.1 > scale <1, 1, 1.2>*( Lamp_RAD01 - Lamp_THK01 ) }
      box{ < Lamp_RAD01, Lamp_RAD01, 0 > < -Lamp_RAD01, -Lamp_RAD01, -Lamp_RAD01 > scale 1.5 }
   }
   torus { Lamp_RAD01 - Lamp_THK01/2, Lamp_THK01/2
      rotate x*90
      scale <1, 1, 2>
      translate z*-Lamp_DST01
   }
   sphere { 0, Lamp_RAD01 - Lamp_THK01/2
      scale < 1, 1, .3>
      texture {Lamp_GLS01}
      translate z*-Lamp_DST01
   }

   texture {METAL01}
   rotate y*90
}
