
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod V8 engine
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi


// paint:
#declare MTEX01 =
   texture{
      finish {
         ambient .2
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.1
      }
      normal {bumps 0.05 scale .5}
}
#declare MTEX02 =
   texture{
      finish {
         ambient .2
         diffuse 0.9
         phong 0.2
         phong_size 5
      }
}

#declare MTEX_G_BLUE = texture { MTEX01 pigment{color rgb <1,0.2,0>}}
#declare MTEX_G_BLACK = texture { MTEX01 finish{ambient .1} pigment{color rgb 0.15}}
#declare MTEX_M_BLACK = texture { MTEX02 finish{ambient .1} pigment{color rgb 0.2}}

#declare BLOB_DENS01 = .6

#declare Air_Filt01=
union{
   intersection{
      blob{ threshold BLOB_DENS01
         #declare BLOB_STRN01 = 1
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         cylinder{<3, 0, 0> <-3, 0, 0> 3 / BLOB_A_R01 BLOB_STRN01 scale <0.5, 1, 1> }

         #declare BLOB_STRN01 = -.7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0 1 / BLOB_A_R01 BLOB_STRN01 scale <1.5, 1, 1>*.75 translate <-4, 0, 0> }

         #declare BLOB_STRN01 = .8
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0 1 / BLOB_A_R01 BLOB_STRN01 scale <.5, 1, 1>*.83 translate <-2.5, 0, 0> }

         #declare BLOB_STRN01 = -.7
         #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
         sphere{0 1 / BLOB_A_R01 BLOB_STRN01 scale <.5, 2, 2>*.2 translate <-3, 0, 0> }
         sturm
      }
      box { <-5, -5, -5> <.5, 5, 5> }
      translate x*-.5
   }
   torus { 3, .25 rotate z*90 }
   sphere{ 0 .2 scale < 1, 1.5, 1.5 > translate x*-3.3 }
}


#declare WIRE_NUM01 = 3
#declare WIRE_01=
union{
   #while ( WIRE_NUM01 >= 0 )
      union{
         intersection {
            torus { 1.4 .2 }
            box { <-2, -.5, 0> <2, .5, -2> }
         }
         cylinder { <1.4, 0, 0> <1.4, 0, 7>.2}
         translate x*1.4
         rotate z*(90-45*WIRE_NUM01)
         translate x*1.5
         rotate z*45*WIRE_NUM01
      }
      #declare WIRE_NUM01 = WIRE_NUM01 - 1
   #end
   texture { MTEX_G_BLACK pigment {color rgb <1, .5, 0> }}
}

#declare WIRE_NUM01 = 7

#declare WIRE_00 =
union{
   object { WIRE_01 }
   object { WIRE_01 scale <-1, -1, 1> }
   sphere { 0, 1.7 scale < 1, 1, .5> translate z*1}
   cylinder { <0, 0, 1> < 0, 0, 3> 1.7 }
   sphere { 0, 2 scale < 1, 1, .5> translate z*3}
   cylinder { <0, 0, 3> < 0, 0, 3.5> 2 }
   cylinder { <0, 0, 7> < 0, 0, 3.5> 1.5 texture { METAL01 } }
   #while ( WIRE_NUM01 >= 0 )
      union{
         cylinder { <1.5, 0, 3> <1.5, 0, .7>.4 }
         sphere { <1.5, 0, .7>.4 }
         cone{ <1.5, 0, .5>.4 <1.5, 0, 0>.3 texture { MTEX_M_BLACK } }
         rotate z*45*WIRE_NUM01
       }
      #declare WIRE_NUM01 = WIRE_NUM01 - 1
   #end
   translate z*-3.5
   rotate z*90
   texture { MTEX_G_BLACK }
}

// engine part01 (trans.):
#declare MTR_PRT01=
union{
   cylinder{ <0,0,0> <0,2,0> 2.5 }
   cone{ <0,2,0> 2.5 <0,7,0> 5 }
   cone{ <0,7,0> 5 <0,9,0> 4.5 }
   cylinder{ <0,9,0> <0,10,0> 3.5 }
   cylinder{ <0,10,0> <0,20.5,0> 4 }
   superellipsoid { <1,.3>
      scale <4.5,4.5,2>
      rotate x*90
      translate y*13.5
   }
   torus { 4, 0.5 translate y*18.5}
   cone{ <0,20.5,0> 4 <0,26,0> 7.5 }
   cylinder{ <0,26,0> <0,27.5,0> 7.5 }
   intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-2.5> <10,31,2.5> }
   }
  intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-3.5> <-10,31,3.5> }
   }
   intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-.5> <-10,28,.5> }
      rotate y*-90
   }
   intersection{
      union{
         cone{ <0,20.5,0> 4.5 <0,26,0> 8 }
         cylinder{ <0,26,0> <0,27.5,0> 8 }
      }
      box{ <0,20,-.5> <-10,28,.5> }
      rotate y*90
   }
   cylinder{ <0,27.5,0> <0,28.5,0> 8.5 }
   torus { 5, 0.5 translate y*21.5}
   intersection{
      superellipsoid { <.2,.2>}
      box{<0,-1.5,-1.5><-1.5,1.5,1.5>}
      scale <2,5.3,6.3> translate <-4.5,15,0>
   }
   superellipsoid { <.1,.2> scale <.5,6,7> translate <-4.5,15,0> }
   difference{
      intersection{
         superellipsoid { <1.8,.1> }
         box{<0,-1.5,-1.5><.5,1.5,1.5>}
         rotate x*90
         scale <10,5.3,6.3>
      }
      cylinder{ <0,0,4><0,0,10>1 scale <4,1.5,1> translate x*5}
      translate <-4.5,15,0>
   }
   superellipsoid { <.2,.2>
      translate z*-1
      scale < 1.5,3.5,3 >
      translate <-3,15,0>
      }
   superellipsoid { <1,.3>
      translate y*-1
      scale <2,2,1.5>
      rotate x*90
      translate <0,6,6>
   }
   superellipsoid { <1,.3>
      translate y*-1
      scale <3.5,3.5,.75>
      rotate x*90
      translate <0,7.5,6>
   }
   intersection{
      sphere{ 0, 2.5 }
      box{<-3,-3,-3><3,0,3>}
      translate <-2.5,27,7>
   }
   cylinder{<0,0,0><0,1,0> 2.5 translate <-2.5,27,7>}
   cylinder{<0,1,0><0,1.5,0> 3 translate <-2.5,27,7>}
   prism {
     linear_sweep
     .5,-.5,
     4,
     <0,0>, <1,0>, <0,-1>, <0,0>
     scale <3,1,5>
     rotate x*-90
     rotate y*-90
     translate <0,5.5,3>
   }
}


// engine part02 (cyl.):
#declare MTR_PRT02=
union{
   difference{
      cylinder{ <0,0,0> <0,22.5,0> 4 scale<1.5,1,1>translate x*-3}
      box{ <2,0,-5><10,22,5>}
   }

// cylinder block, valve cover
   #declare CYL01=
   union{
     union{
      box{<0,0,3> <-12,22,-3>}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*4}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*5}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*9}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*10}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*14}
      box{<0,-.2,3.3> <-9,.2,-3.3> translate y*15}
      box{<0,-.5,3.3> <-9,.5,-3.3> translate y*21.5}
      texture { MTEX_G_BLUE }
     }
      superellipsoid{ <.1, .05 > scale <.3,11.3,3.3 > translate <-12,11,0>}
      difference{
         union{
            superellipsoid{ <.2, .2 > scale <3,10.5,3 >}
            superellipsoid{ <.2, .2 > scale <3.3,10.8,.2 > translate z*-1 }
            superellipsoid{ <.2, .2 > scale <3.3,10.8,.2 > translate z*1 }
            box{<-.15,-.75,-.5><.2,.75,.5> translate <-3,9.2,0>}
            box{<-.15,-.75,-.5><.2,.75,.5> translate <-3,-9.2,0>}

         }
         cylinder{<-4,0,0><4,0,0>.6 translate <0,-4,3>}
         cylinder{<-4,0,0><4,0,0>.6 translate <0,4,3>}
         cylinder{<-4,0,0><4,0,0>.6 translate <0,-4,-3>}
         cylinder{<-4,0,0><4,0,0>.6 translate <0,4,-3>}
         translate <-12,11,0>
      }
   }
   object{CYL01 rotate y*-45 translate z*-.5 texture{METAL01}}
   object{CYL01 rotate y*45 translate z*.5 texture{METAL01}}

   box{<-9,0,5> <2,22,-5>}
   box{<-1,-.7,5.3> <1,.7,-5.3> translate y*4.5}
   box{<-1,-.7,5.3> <1,.7,-5.3> translate y*9.5}
   box{<-1,-.7,5.3> <1,.7,-5.3> translate y*14.5}
   box{<-1,-.5,5.3> <1,.5,-5.3> translate y*21.5}
   superellipsoid{ <.1, .05 > scale <.3,11.2,5.3 > translate <2,11,0>}
   intersection{
      superellipsoid{ <.2, .2 >}
      box{<0,-1.5,-1.5> <1.5,1.5,1.5> }
      scale <6,5,4.5 > translate <2,5,0>
   }
   intersection{
      superellipsoid{ < .23, .23 >}
      box{<0,-1.5,-1.5> <1.5,0,1.5> }
      translate <-1,1,0>
      scale <5,5,4.5 >
      rotate z*45
      translate <8.45,9,0>
   }
   intersection{
      superellipsoid{ < 1.8, .2 > translate x*.1}
      box{<0,-1.5,-1.5> <1.5,1.5,1.5> }
      scale <3.5,11,4.5 >
      translate <2,11,0>
   }

// water pump:
   union{
      intersection{
         torus{3,.75 rotate z*90}
         box{<-5,0,0><5,5,5>}
         translate <0,0,4.5>
      }
      intersection{
         torus{3,.75 rotate z*90}
         box{<-5,0,0><5,5,-5>}
         translate <0,0,-4.5>
      }
      cylinder{<0,3,-4.5><0,3,4.5>.75}
      superellipsoid{<0.2,0.2> scale <2,1.5,1.5> translate y*3}
      superellipsoid{<1,.2> rotate y*90 translate <-2,3,0>}
      cylinder{<0,0,0><0,4,0>3 translate x*3}
      translate <-8.5,22,0>

      texture{METAL01}
   }

//pipe01:
  union{
     cylinder {<-14, 23, 0> <-14, 38, 0>1 }
     intersection{
        torus{ 3, 1 rotate x*90}
        box { <-7, -7, 2> <0, 0, -2 > }
        translate <-11, 23, 0>
     }
     cylinder {<-11.5, 20, 0> <-8, 20, 0>1.2 }
     superellipsoid { <0.5, 0.2> translate x*1 scale < 1.5, 3, 3 > translate <-11, 19, 0> texture{METAL02}}
     superellipsoid { <0.5, 0.2> translate x*1 scale < 1.5, 3, 3 > translate <-11, 4, 0> texture{METAL02}}
     texture{METAL01}
  }

//pipe02:
  union{
     cylinder {<-5, 29, 0> <-5, 38, 0>1 }
     cylinder {<0, 24, 0> <3, 24, 0>1.2 }
     intersection{
        torus{ 5, 1 rotate x*90}
        box { <-9, -9, 2> <0, 0, -2 > }
        translate <0, 29, 0>
     }
     rotate y*-120
     translate <-5, 0, -4>
     texture{METAL01}
  }

#declare CARB01=
   union{
      superellipsoid{ <.5, .5 >
         scale <1.3,2,.4 >
         translate <-11,11,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,.4 >
         translate <-11,7,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,.4 >
         translate <-11,15,0>
      }
      texture{METAL02}
   }

   // carb. manifold:
   object{CARB01 translate z*-3 rotate y*45 }
   object{CARB01 translate z*3 rotate y*-45 }
   intersection{
      union{
         torus {11.5,.5 scale <1,2,1>}
         torus {11.5,.5 scale <1,2,1> translate y*3}
         torus {11.5,.5 scale <1,2,1> translate y*5}
         torus {11.5,.5 scale <1,2,1> translate y*-3}
         torus {11.5,.5 scale <1,2,1> translate y*-5}
         box{<-11,-5,-3><-12,5,3>}
      }
      box{<-20,-10,-10><0,10,10>}

      texture{METAL02}
      translate y*11
   }

   // carb.
   union{
      union{
         superellipsoid{ <.2,.1> translate x*-1 scale <.3,.7,1.2>*2.6 translate y*17}
         superellipsoid{ <1,.1> translate x*-1 rotate y*90 scale 1 translate <0,19.5,-4.5>}
         cylinder{<0,0,0><-3,0,0>2 translate y*16}
         superellipsoid{ <.2,.1> translate x*-1 scale <.3,.7,1.2>*2.6 translate y*12}
         superellipsoid{ <1,.1> translate x*-1 rotate y*90 scale 1 translate <0,9,3>}
         cylinder{<0,0,0><-3,0,0>2 translate y*11}
         superellipsoid{ <.2,.1> translate x*-1 scale <.3,.7,1.2>*2.6 translate y*7}
         superellipsoid{ <1,.1> translate x*-1 scale 1 translate <0,11,-3>}
         cylinder{<0,0,0><-3,0,0>2 translate y*6}

         cylinder {<0, 18, 0> <0, 6, 0> .5 translate <-1.5, 0, -4.2> }
         cylinder {<0, 18, 0> <0, 6, 0> .5 translate <-1.5, 0, 4.2> }
         texture{METAL02}
      }

      object { Air_Filt01 scale .75 translate <-3, 16, 0> }
      object { Air_Filt01 scale .75 translate <-3, 11, 0> }
      object { Air_Filt01 scale .75 translate <-3, 6, 0> }
   translate x*-12
   texture{METAL01}
   }

   object { WIRE_00 rotate y*90 translate <-11, 1, 0> }

//"cylinder head":
   #declare CYL02=
   union{
      superellipsoid{ <.5, .5 >
         scale <1.3,2,2 >
         translate <-11,11,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,2 >
         translate <-11,2,0>
      }
      superellipsoid{ <.5, .5 >
         scale <1.3,2,2 >
         translate <-11,20,0>
      }
      cylinder{ <0,-10,0> <0,10,0>1
         translate <-11,11,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,14.5,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,16.5,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,7.5,0>
      }
      cylinder{ <0,0,1.5> <0,0,-1.5>.5
         translate <-11,5.5,0>
      }
   }
   object{CYL02 translate z*-3 rotate y*-45 }
   object{CYL02 translate z*3 rotate y*45 }
}

//engine part03 (starter):
#declare MTR_PRT03=
union{
   cylinder{<0,0,0><0,8,0>2}
   cylinder{<0,1.5,0><0,6.5,0>2.5}
   cylinder{<0,8,0><0,9,0>.5}
   cylinder{<3.5,.5,0><3.5,6.5,0>1}
   cylinder{<3.5,.5,0><3.5,1.5,0>1.5}
   cylinder{<3.5,5.5,0><3.5,6.5,0>1.5}
   translate <-2.5,0,7>
}

// engine part04 (belts, etc.):
#declare MTR_PRT04=
union{
   difference{
      union{
         cylinder{<0,0,0><0,4,0>2}
         cylinder{<0,4,0><0,6.5,0>2.8}
         cylinder{<0,5,0><0,6,0>3 texture { MTEX_M_BLACK }}
      }
      cylinder{<0,5.5,0><0,8,0>2}
      cylinder{<0,-1,0><0,8,0>1}
      translate x*-2
   }
   cylinder{<-9, 8 ,0> <-9, 7, 0> 1.5}
   cylinder{<-9, 4.5 ,0> <-9, 6.5, 0> 2.8}
   cylinder{<-9, 5 , 0> <-9, 6, 0> 3 texture { MTEX_M_BLACK }}
   box{<-9 ,5, -3> <-2, 6, -2.5> texture { MTEX_M_BLACK }}
   box{<-11, 5, 1.5> <0 ,6, 1>
      rotate y*-31.5
      translate <-.5, 0, 7>
      texture { MTEX_M_BLACK}
   }
   box{<.5, 5, 0> <1 ,6, 7> texture { MTEX_M_BLACK }}
   cylinder{<-.5, 5 , 7> <-.5, 6, 7> 1.5 texture { MTEX_M_BLACK }}
   cylinder{<-.5, 4.5 , 7> <-.5, 6.5, 7> 1.3}
   cone{<-.5, 7.2 , 7>.5 <-.5, 6.5, 7> 1.3}
   #declare Count = 7
      #while ( Count >= 0 )
         box { <0, 0, 0> <-.5, .5, -2.6>
            rotate y*15
            rotate y*45*Count
            translate <-.5, 4, 7>
         }
         #declare Count = Count -1
      #end
   cylinder{<-.5, 4 , 7> <-.5, 3.5, 7> 2.7}
   cylinder{<-.5, 1.8 , 7> <-.5, 1.4, 7> 2.4}
   difference {
      superellipsoid { <1.3, .5> rotate x*90 scale < 2.6, 2.5, 2.6 > }
      cylinder{<0, .2 , 0> <0, -.2, 0> 3}
      translate <-.5, 1.5 , 7>
   }

    texture {METAL01}
}

// fan:
#declare FAN=
union{
   cylinder{<0,-.3,0><0,.3,0> 2.5 }
   cylinder{<0,-3,0><0,0,0> 1.5 }
   sphere { <1.25,.3,0> .3}
   sphere { <-1.25,.3,0> .3}
   sphere { <0,.3,1.25> .3}
   sphere { <0,.3,-1.25> .3}
   #declare FAN_NUM=6
   #declare FAN_ANG=360/(FAN_NUM+1)
   #while (FAN_NUM >=0)
      union{
         difference{
            superellipsoid {<0.2,0.5> scale<3,.2,1.6> }
            superellipsoid {<0.2,0.5> translate <0,0,1.6> scale<3.2,2,1.6>}
            translate x*3
         }

         sphere { <.7,.2,.6> .3}
         sphere { <.7,.2,-.6> .3}
         sphere { <1.8,.2,0> .3}
         sphere { <3,.2,0> .3}
         box{<-2,-.15,-.7><2,.15,.7>}

         rotate x*2
         rotate z*-1
         translate x*3
         rotate y*(FAN_NUM*FAN_ANG)
      }
      #declare FAN_NUM=FAN_NUM-1
   #end
   scale .9
}

#declare V8_Motor01=
union{
   object{MTR_PRT01 translate y*-28.5 texture { MTEX_G_BLUE }}
   object{MTR_PRT02 translate x*-2 rotate y*180 texture { MTEX_G_BLUE }}
   object{MTR_PRT03 texture { MTEX_G_BLACK }}
   object{MTR_PRT04 translate <1, 22.5, 0> rotate y*180 }
   object{FAN scale .9 translate <-8,(22.5+9),0> rotate y*180 texture { MTEX_G_BLACK }}
}
