
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod radiator
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi


// paint:
#declare MTEX01 =
   texture{
      finish {
         ambient .2
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.1
      }
      normal {bumps 0.05 scale .5}
}
#declare MTEX_G_BLACK = texture { MTEX01 finish{ambient .1} pigment{color rgb 0.15}}

// #declare METAL01 =  texture { T_Chrome_4D }

#declare RAD_TEX = texture {T_Gold_3D normal { bumps .08 scale 10} }

#declare RAD_THK01 = 6

// radiator part 1
#declare RAD_PRT01 =
union{
   cylinder { <0, 0, 51> <14, 0, 51> .5 }
   torus { 10, .5 translate <14, 0, 41> }
   cylinder { <14, .5, 41> <14, -.5, 41> 10 }

   cylinder{
      vrotate ( <0, 0, 10> <0, degrees( acos( 10/ ( sqrt( pow( 4, 2 ) + pow( 15, 2 ) ) ) ) ), 0 > ) + <14, 0, 41>
      <29, 0, 37> .5
      }
   sphere{ <29, 0, 37> .5 }
   cylinder { <29, 0, 37> <29, 0, 0> .5 }
   sphere{ <29, 0, 0> .5 }
   cylinder { <29, 0, 0> <34+RAD_ADD_LNG, 0, 0> .5 }
   torus { 5, .5 translate <25, 0, -5> }
   cylinder { <25, .5, -5> <25, -.5, -5> 5 }

   cylinder { <0, 0, -10> <25, 0, -10> .5 }
   prism{ linear_sweep linear_spline -.5, .5, 11
      <0, 51>, <14, 51>,
      vrotate ( <0, 10> <0, 0, -degrees( acos( 10/ ( sqrt( pow( 4, 2 ) + pow( 15, 2 ) ) ) ) ) > ) + <14, 41>,
      <29, 37>, <29, 0>, <34+RAD_ADD_LNG, 0>, <34+RAD_ADD_LNG, -5>, <29, -5>, <25,-10>, <0, -10>,
      <0, 51>
   }

   cylinder { <14, 0, 41> <14, -RAD_THK01, 41> 10.5 }
   prism{ linear_sweep linear_spline 0, -RAD_THK01, 8
      <0, 51.5>, <14, 51.5>,
      vrotate ( <0, 10.5> <0, 0, -degrees( acos( 10/ ( sqrt( pow( 4, 2 ) + pow( 15, 2 ) ) ) ) ) > ) + <14, 41>,
      vrotate ( <0, .5> <0, 0, -degrees( acos( 10/ ( sqrt( pow( 4, 2 ) + pow( 15, 2 ) ) ) ) ) > ) + <29, 37>,
      <29, 37>, <14, 37>, <0, 37>,
      <0, 51.5>
   }
   prism{ linear_sweep linear_spline 0, -RAD_THK01, 9
      <0, 37>, <29.5, 37>,
      <29.5, .5>, <34+RAD_ADD_LNG, .5>, <34+RAD_ADD_LNG, -5>, <29.5, -5>, <25,-10.5>, <0, -10.5>,
      <0, 37>
   }
   cylinder { <29, 0, 37> <29, -RAD_THK01, 37> .5 }
   cylinder { <25, 0, -5> <25, -RAD_THK01, -5> 5.5 }
   translate y*RAD_THK01

}

// radiator part 2
#declare RAD_PRT02 =
union{
   torus{ 3.8 .3 }
   cylinder { <0, -.3, 0> <0, .3, 0>3.8 }
   cone{ <0, 0, 0>2.5 <0, 6, 0>2 }
   torus{ (5.5-.4)/2 .2 translate y*6.2 }
   cylinder { <0, -.2, 0> <0, .2, 0>(5.5-.4)/2 translate y*6.2 }
   torus{ (5.5-.4)/2 .2 translate y*7.3 }
   cylinder { <0, -.2, 0> <0, .2, 0>(5.5-.4)/2 translate y*7.3 }
   cylinder { <0, 0, 0> <0, 1.1, 0>5.5/2 translate y*6.2 }

   #declare BLOB_DENS01 = .5
   #declare BLOB_STRN01 = .7
   #declare BLOB_A_R01 = sqrt ( 1 - sqrt ( abs ( BLOB_DENS01 / BLOB_STRN01 ) ) )
   #declare RAD_NUM02 = 3

    blob { threshold BLOB_DENS01
       cylinder{ <0, 0, 0> <0, 1.2, 0> 2.4/BLOB_A_R01 BLOB_STRN01 scale <1,.5,1>}
       #while ( RAD_NUM02 >= 0 )
          sphere { 0, 3/BLOB_A_R01 BLOB_STRN01
             scale <1, .5, .35>*.3
             rotate z*37
             translate <1.2, 1, 0>
             rotate y* 90*RAD_NUM02
          }
          #declare RAD_NUM02 = RAD_NUM02 -1
       #end
       hierarchy off
       translate y*7.5
    }
}

// radiator
#declare RADIATOR=
union{
   difference{
      union{
         object {RAD_PRT01}
         object {RAD_PRT01 scale <-1,1,1>}
         object {RAD_PRT01 scale <1,-1,1>}
         object {RAD_PRT01 scale <-1,-1,1>}
         object {RAD_PRT02 rotate x*90 translate z*51.5 }
      }
      union{
         box{ <-24, -RAD_THK01*1.5, 36> <24, RAD_THK01*1.5, -5> }
         box{ <-26, -RAD_THK01*1.5, 34> <26, RAD_THK01*1.5, -3> }
         cylinder{ <-24, -RAD_THK01*1.5, 34> <-24, RAD_THK01*1.5, 34> 2 }
         cylinder{ <24, -RAD_THK01*1.5, 34> <24, RAD_THK01*1.5, 34> 2 }
         cylinder{ <-24, -RAD_THK01*1.5, -3> <-24, RAD_THK01*1.5, -3> 2 }
         cylinder{ <24, -RAD_THK01*1.5, -3> <24, RAD_THK01*1.5, -3> 2 }
      }
   }
   #declare RAD_NUM01 = 29
   #declare RAD_WDT01 = 52
   #declare RAD_DST01 = RAD_WDT01/(RAD_NUM01+1)
   union{
      #while( RAD_NUM01 >= 0 )
         box{ < -.45, -(RAD_THK01-.5), 36> < .45, RAD_THK01-.5, -5>
            translate x*RAD_DST01*RAD_NUM01
         }
         cylinder{ < 0, RAD_THK01-.5, 36> < 0, RAD_THK01-.5, -5>.45
            translate x*RAD_DST01*RAD_NUM01
         }
         #declare RAD_NUM01 = RAD_NUM01 - 1
      #end
      translate x* -RAD_WDT01/2
      texture {MTEX_G_BLACK}
   }

   #declare LG_TH01 = 1.5
   #include "logo.inc"
   // logo
   object {F_logo01 scale .1 translate < 0, RAD_THK01+.5, 42 >}

   rotate x*-90
   rotate y*90
   scale .37
   //translate y*-35
   texture {RAD_TEX}
}
