
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod front end
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

// paint
#declare BTEX_02=
texture{
   finish{
      diffuse 0.9
      ambient 0.1
      phong 0.9
      phong_size 100
   }
   pigment{ color rgb <1,.5,0>
   }
}

#declare F_AXL_LNG01 = 27
#declare F_AXL_DST01 = 18
#declare F_AXL_RAD01 = 1
#declare F_AXL_HGT01 = 8
#declare F_AXL_RAD02 = 4.5
#declare F_AXL_RAD03 = 4

#declare F_AXL_RAD10 = 0.5
#declare F_AXL_LNG10 = 5

#declare F_AXL_A01 = F_AXL_LNG01 - F_AXL_DST01
#declare F_AXL_B01 = F_AXL_HGT01 - F_AXL_RAD02 - F_AXL_RAD03
#declare F_AXL_C01 = sqrt ( pow ( F_AXL_A01, 2 ) + pow ( F_AXL_B01, 2 ) )
#declare F_AXL_C02 = F_AXL_RAD02 / F_AXL_RAD03 * F_AXL_C01 / ( F_AXL_RAD02 / F_AXL_RAD03 + 1 )
#declare F_AXL_a01 = atan2 ( F_AXL_B01, F_AXL_A01 )
#declare F_AXL_a02 = acos ( F_AXL_RAD02/ F_AXL_C02 )
#declare F_AXL_a00 = F_AXL_a02 - F_AXL_a01
#declare F_AXL_b00 = degrees ( pi/2 - F_AXL_a00 )

// front axle part 1
#declare F_AXL_PRT01=
union{
   superellipsoid { < 1, .2 >
      rotate x*90
      translate y*-.3
      scale F_AXL_RAD01 * <1, 1.1, 1>
      translate < 0, F_AXL_HGT01, -F_AXL_LNG01 >
   }
   superellipsoid { < 1, .2 >
      rotate x*90
      translate y*-.3
      scale F_AXL_RAD01 * <1, 1.1, 1>
      translate < 0, F_AXL_HGT01 + F_AXL_RAD01 * 1.1 *2, -F_AXL_LNG01 >
   }
   superellipsoid { < 1, .2 >
      rotate x*90
      translate y*-.3
      scale F_AXL_RAD01 * <1, 1.1, 1>
      translate < 0, F_AXL_HGT01 - F_AXL_RAD01 * 1.1 *2, -F_AXL_LNG01 >
   }

   cylinder {<0,0,0> <0,0,-F_AXL_DST01> F_AXL_RAD01}
   difference{
      torus { F_AXL_RAD02 F_AXL_RAD01
         rotate z*90
         translate <0,F_AXL_RAD02,-F_AXL_DST01>
      }
      box { <F_AXL_RAD02, F_AXL_RAD02, F_AXL_RAD02>*2 <-F_AXL_RAD02, -F_AXL_RAD02, 0>*2
         translate <0,F_AXL_RAD02,-F_AXL_DST01>
      }
      box { <F_AXL_RAD02, F_AXL_RAD02, F_AXL_RAD02>*2 <-F_AXL_RAD02, 0, -F_AXL_RAD02>*2
         translate <0,F_AXL_RAD02,-F_AXL_DST01>
      }
      cylinder { ( vrotate ( <0,-F_AXL_RAD02,0> <F_AXL_b00, 0, 0> ) + <0,F_AXL_RAD02,-F_AXL_DST01> )
              ( vrotate ( <0,F_AXL_RAD03,0> <F_AXL_b00, 0, 0> ) + <0,F_AXL_HGT01-F_AXL_RAD02,-F_AXL_LNG01> )
              ( F_AXL_RAD02 + F_AXL_RAD01 )*2
      }
   }
   difference{
      torus{ F_AXL_RAD03 F_AXL_RAD01
         rotate z*90
         translate <0,F_AXL_HGT01-F_AXL_RAD02,-F_AXL_LNG01>
      }
      box { <F_AXL_RAD03, F_AXL_RAD03, -F_AXL_RAD03>*2 <-F_AXL_RAD03, -F_AXL_RAD03, 0>*2
         translate <0,F_AXL_HGT01-F_AXL_RAD02,-F_AXL_LNG01>
      }
      box { <F_AXL_RAD03, -F_AXL_RAD03, -F_AXL_RAD03>*2 <-F_AXL_RAD03, 0, F_AXL_RAD03>*2
         translate <0,F_AXL_HGT01-F_AXL_RAD02,-F_AXL_LNG01>
      }
      cylinder { ( vrotate ( <0,-F_AXL_RAD02,0> <F_AXL_b00, 0, 0> ) + <0,F_AXL_RAD02,-F_AXL_DST01> )
              ( vrotate ( <0,F_AXL_RAD03,0> <F_AXL_b00, 0, 0> ) + <0,F_AXL_HGT01-F_AXL_RAD02,-F_AXL_LNG01> )
              ( F_AXL_RAD02 + F_AXL_RAD01 )*2
      }
   }

   cylinder { ( vrotate ( <0,-F_AXL_RAD02,0> <F_AXL_b00, 0, 0> ) + <0,F_AXL_RAD02,-F_AXL_DST01> )
              ( vrotate ( <0,F_AXL_RAD03,0> <F_AXL_b00, 0, 0> ) + <0,F_AXL_HGT01-F_AXL_RAD02,-F_AXL_LNG01> )
              F_AXL_RAD01
      }
}

// fraont axle part 2
#declare F_AXL_PRT02 =
union{
   cone { < 0, 0, 0 >F_AXL_RAD10*1.2 < -F_AXL_LNG10, 0, 0 > F_AXL_RAD10 }
   sphere { < -F_AXL_LNG10-F_AXL_RAD10, F_AXL_RAD10*2, 0 > F_AXL_RAD10*2 }
   torus { F_AXL_RAD10 F_AXL_RAD10 translate < -F_AXL_LNG10-F_AXL_RAD10, 0, 0 > }
   object { BLT01 rotate x*180 translate < -F_AXL_LNG10-F_AXL_RAD10, -F_AXL_RAD10, 0 > }
}

#declare Total_Length = 10
#declare Sphere_Radius = .2
#declare Number_of_Waves = 14
#declare Count_per_Wave = 72
#declare Z_Radius = 1.2
#declare Y_Radius = Z_Radius
#declare Starting_Angle = 0
#declare Angle = 2 * pi / Count_per_Wave
#declare Count = Number_of_Waves * Count_per_Wave - 1
#declare X_Distance = Total_Length / Count
#declare X_Origin = 0

// spring
#declare Coil03 =
union{
   #while ( Count >= 0 )

      sphere { < X_Origin, cos ( Starting_Angle ) * Y_Radius, sin ( Starting_Angle ) * Z_Radius > Sphere_Radius }

      cylinder {
         < X_Origin, cos ( Starting_Angle ) * Y_Radius, sin ( Starting_Angle ) * Z_Radius >
         < X_Origin + X_Distance, cos ( Starting_Angle + Angle ) * Y_Radius, sin ( Starting_Angle + Angle ) * Z_Radius >
         Sphere_Radius
      }

      #declare Starting_Angle = Starting_Angle + Angle
      #declare X_Origin = X_Origin + X_Distance
      #declare Count = Count - 1

   #end
}

#declare F_SHA_LNG01 = 10
#declare F_SHA_RAD01 = .7
#declare F_SHA_RAD11 = 1
#declare F_SHA_RAD12 = 1.2
#declare F_SHA_RAD22 = .3

#declare F_SHA_LNG02 = 3
#declare F_SHA_RAD02 = .5

#declare F_SHA_ANGx1 = 15
#declare F_SHA_ANGz1 = -20
#declare F_SHA_ANGz2 = 5

// front shock absorber
#declare F_SHA_01 =
union{
   object { Coil03 rotate z*90 }
   cylinder{ <0, -F_SHA_RAD11, 0> < 0, F_SHA_LNG01 + F_SHA_RAD11, 0 > F_SHA_RAD01 }
   torus{ F_SHA_RAD12 F_SHA_RAD22 }
   torus{ F_SHA_RAD12 F_SHA_RAD22 translate < 0, F_SHA_LNG01, 0 > }
   sphere{ <0, -F_SHA_RAD11, 0> F_SHA_RAD11 }
   sphere{ < 0, F_SHA_LNG01 + F_SHA_RAD11, 0 > F_SHA_RAD11 }
   union{
      object { BLT01 rotate x*-90 }
      cylinder { <0, 0, 0> < 0, 0, F_SHA_LNG02 > F_SHA_RAD02 }
      rotate x*F_SHA_ANGx1
      rotate z*F_SHA_ANGz1
      rotate y*180
      translate <0, -F_SHA_RAD11, F_SHA_RAD11>
   }
   union{
      object { BLT01 rotate x*-90 }
      object { BLT01 rotate x*90 translate z*F_SHA_RAD11*2}
      // cylinder { <0, 0, 0> < 0, 0, F_SHA_LNG02 > F_SHA_RAD02 }
      rotate x*-F_SHA_ANGx1
      rotate z*-F_SHA_ANGz1
      translate <0, F_SHA_LNG01 + F_SHA_RAD11, -F_SHA_RAD11>
   }

   cone{ < 0, 0 ,0 >F_SHA_RAD11*.7 < 0, -F_SHA_LNG01*.7, 0>F_SHA_RAD11*2
      rotate x*-F_SHA_ANGx1
      rotate z*-F_SHA_ANGz1
      rotate z*F_SHA_ANGz2
      translate <0, F_SHA_LNG01 + F_SHA_RAD11, -F_SHA_RAD11>
      texture {BTEX_02}
   }

   translate <0, F_SHA_RAD11,0>
   rotate x*F_SHA_ANGx1
   rotate z*F_SHA_ANGz1
}


#declare F_SHA_HGT01 = 2
#declare F_SHA_DST01 = 21
#declare F_SHA_RAD01 = 1
#declare F_SHA_INT01 = 7
#declare F_SHA_XXX01 = 4
#declare F_SHA_THK01 = .2
#declare F_SHA_RAD02 = .5

#declare F_SHA_ANG01 =
   90 - degrees ( atan2 ( ( F_SHA_HGT01 + F_SHA_XXX01 ), F_SHA_HGT01 *.5 ) +
   asin ( F_SHA_RAD01 / vlength ( < F_SHA_HGT01, F_SHA_HGT01 *.5, 0 > - <-F_SHA_XXX01, 0, 0 > ) ) )

#declare F_SHA_ANG02 =
   90 - degrees ( atan2 ( ( F_SHA_HGT01 + F_SHA_XXX01 ), ( F_SHA_INT01 - F_SHA_HGT01 *.5 ) ) +
   acos ( F_SHA_RAD01 / vlength ( < F_SHA_HGT01, -F_SHA_HGT01 *.5, 0 > - <-F_SHA_XXX01, -F_SHA_INT01, 0 > ) ) )

// front shock absorber part 1
#declare F_SHA_PRT01 =
union {
   cylinder { < F_SHA_HGT01, 0, F_SHA_HGT01 *.5 > < F_SHA_HGT01, 0, -F_SHA_HGT01 * .5 > F_SHA_THK01 }
   sphere { < F_SHA_HGT01, 0, F_SHA_HGT01 *.5 > F_SHA_THK01 }
   sphere { < F_SHA_HGT01, 0, -F_SHA_HGT01 *.5 > F_SHA_THK01 }

   torus { F_SHA_RAD01, F_SHA_THK01
      translate < -F_SHA_XXX01, 0, 0 >
   }
   cylinder { < 0, F_SHA_THK01, 0 > < 0, -F_SHA_THK01, 0 > F_SHA_RAD01
      translate < -F_SHA_XXX01, 0, 0 >
   }
   torus { F_SHA_RAD01, F_SHA_THK01
      translate < -F_SHA_XXX01, 0, -F_SHA_INT01 >
   }
   cylinder { < 0, F_SHA_THK01, 0 > < 0, -F_SHA_THK01, 0 > F_SHA_RAD01
      translate < -F_SHA_XXX01, 0, -F_SHA_INT01 >
   }
   cylinder { < -F_SHA_RAD01, 0, 0 > < -F_SHA_RAD01, 0, -F_SHA_INT01 > F_SHA_THK01
      translate < -F_SHA_XXX01, 0, 0 >
   }

   cylinder {
      vrotate (< 0, 0, F_SHA_RAD01 > <0, -F_SHA_ANG01, 0 > )
      < F_SHA_HGT01 + F_SHA_XXX01, 0, F_SHA_HGT01 *.5 >
      F_SHA_THK01
      translate < -F_SHA_XXX01, 0, 0 >
   }

   cylinder {
      ( vrotate ( < 0, 0, -F_SHA_RAD01 > < 0, F_SHA_ANG02, 0 > ) + < 0, 0, -F_SHA_INT01 > )
      < F_SHA_HGT01 + F_SHA_XXX01, 0, -F_SHA_HGT01 *.5>
      F_SHA_THK01
      translate < -F_SHA_XXX01, 0, 0 >
   }

   prism{ linear_sweep linear_spline -F_SHA_THK01, F_SHA_THK01, 7
      < F_SHA_HGT01, -F_SHA_HGT01 *.5 >,
      vrotate ( < 0, -F_SHA_RAD01 > < 0, 0, -F_SHA_ANG02 > ) + < -F_SHA_XXX01, -F_SHA_INT01 >,
      < -F_SHA_RAD01, -F_SHA_INT01 > + < -F_SHA_XXX01, 0 >,
      < -F_SHA_RAD01, 0 > + < -F_SHA_XXX01, 0 >,
      vrotate (< 0, F_SHA_RAD01 > <0, 0, F_SHA_ANG01 > ) + < -F_SHA_XXX01, 0 >,
      < F_SHA_HGT01, F_SHA_HGT01 *.5 >,
      < F_SHA_HGT01, -F_SHA_HGT01 *.5 >
   }

   translate < -F_SHA_HGT01, 0, 0 >
   rotate x*-90
}
#declare F_AXL_DST02 = 21
#declare F_SHA_DST02 = 2

#declare ROD_LNG02 = 48
#declare ROD_RAD02 = .5
#declare ROD_LNG12 = 3
#declare ROD_DST02 = 1
#declare ROD_ANG02 = 25

// front rods 1
#declare F_ROD01=
union{
   cylinder{ < 0, 0, 0 > < -ROD_LNG02, 0, ROD_DST02> ROD_RAD02 }
   sphere { < 0, 0, 0 >ROD_RAD02*1.5 }
   sphere { < -ROD_LNG02, 0, ROD_DST02> ROD_RAD02*1.5 }
   cylinder { < -ROD_LNG02, 0, ROD_DST02> < -ROD_LNG02, 0, ROD_DST02+ROD_LNG12> ROD_RAD02 }
   object { BLT01
      rotate x*-90
      translate < -ROD_LNG02, 0, ROD_DST02 - ROD_RAD02 >
   }
   rotate z*ROD_ANG02
}

#declare ROD_LNG20 = 57
#declare ROD_LNG21 = 57
#declare ROD_HGT21 = 7
#declare ROD_LNG22 = 5
#declare ROD_LNG32 = 3
#declare ROD_LNG42 = 7
#declare ROD_LNG52 = 10

// FRONT WHEELS STEERING ANGLE !!!!
#declare F_AXL_ROT01 = -15

// front rods 2
#declare F_ROD02=
union {
   union{
      cone { <0, 0, 0>ROD_RAD02*2 <0, 0, ROD_LNG22>ROD_RAD02 }
      torus { ROD_RAD02 ROD_RAD02 translate <0, 0, ROD_LNG22>}
      object { BLT01  translate <0, ROD_RAD02, ROD_LNG22> }
      sphere { <0, ROD_RAD02*-2, ROD_LNG22> ROD_RAD02*2 }
      translate x*ROD_LNG32
      rotate y*F_AXL_ROT01
   }
   cylinder { vrotate ( <ROD_LNG32, ROD_RAD02*-2, ROD_LNG22> <0, F_AXL_ROT01, 0 > )
        ( < ROD_LNG20, ROD_RAD02*-2-ROD_HGT21, ROD_LNG42> + vrotate ( <0, ROD_HGT21, 0> <0, 0, -F_AXL_ROT01 > ) ) ROD_RAD02
   }
   object { BLT01
      rotate x*-90
      translate ( < ROD_LNG20, ROD_RAD02*-3-ROD_HGT21, -ROD_RAD02*2+ROD_LNG42> + vrotate ( <0, ROD_HGT21, 0> <0, 0, -F_AXL_ROT01 > ) ) }
   sphere { ( < ROD_LNG20, ROD_RAD02*-3-ROD_HGT21, ROD_LNG42> + vrotate ( <0, ROD_HGT21, 0> <0, 0, -F_AXL_ROT01 > ) )ROD_RAD02*2 }

   sphere { < ROD_LNG21, ROD_RAD02*-3-ROD_HGT21, ROD_LNG42>ROD_RAD02*2 }
   object { BLT01
      rotate x*-90
      translate < ROD_LNG21, ROD_RAD02*-3-ROD_HGT21, -ROD_RAD02*2+ROD_LNG42>
   }
   cylinder {
      ( < ROD_LNG20, ROD_RAD02*-3-ROD_HGT21, ROD_LNG42> + vrotate ( <0, ROD_HGT21, 0> <0, 0, -F_AXL_ROT01 > ) )
        < ROD_LNG21, ROD_RAD02*-3-ROD_HGT21, ROD_LNG42>ROD_RAD02
      }
   cylinder { <0, 0, 0> <0, 0, ROD_LNG52>ROD_RAD02
      translate < ROD_LNG21, ROD_RAD02*-3-ROD_HGT21, ROD_LNG42>
   }
}

// front axle mount
#declare F_AXL_MNT01 =
union{
   object { F_SHA_PRT01 }
   object { F_SHA_PRT01 translate z*F_SHA_DST02 }
   cylinder { <-F_SHA_XXX01-F_SHA_HGT01, 0, 0> <-F_SHA_XXX01-F_SHA_HGT01, 0, F_SHA_DST02>F_SHA_RAD02}
   cylinder { <-F_SHA_XXX01-F_SHA_HGT01, -F_SHA_INT01, 0> <-F_SHA_XXX01-F_SHA_HGT01, -F_SHA_INT01, F_SHA_DST02>F_SHA_RAD02}

   object{F_ROD01
       translate <-F_SHA_XXX01-F_SHA_HGT01, 0, F_SHA_DST02/2>
   }

   object{F_ROD01
      translate <-F_SHA_XXX01-F_SHA_HGT01, -F_SHA_INT01, F_SHA_DST02/2>
   }
   object { BLT01
      rotate x*-90
      translate <-F_SHA_XXX01-F_SHA_HGT01, 0, -F_SHA_THK01>
   }
   object { BLT01
      rotate x*-90
      translate <-F_SHA_XXX01-F_SHA_HGT01, -F_SHA_INT01, -F_SHA_THK01>
   }
   object { BLT01
      rotate x*90
      translate <-F_SHA_XXX01-F_SHA_HGT01, 0, F_SHA_DST02+F_SHA_THK01>
   }
   object { BLT01
      rotate x*90
      translate <-F_SHA_XXX01-F_SHA_HGT01, -F_SHA_INT01, F_SHA_DST02+F_SHA_THK01>
   }

   superellipsoid { < .4, .1 >
      translate z*1
      rotate z*45
      scale < 3, 4.5, 1.6 >
      rotate z*-25
      translate < -7, -0.5, .4 >
      translate < -ROD_LNG02, 0, ROD_DST02 + ROD_RAD02*4 >
      rotate z*ROD_ANG02
      texture {BTEX_02}
   }

   scale < -1, -1, 1 >
   rotate z*-20
}


#declare LEAF_RAD01 = 100
#declare LEAF_LNG01 = 1
#declare LEAF_THK01 = .25
#declare LEAF_THK02 = .3
#declare LEAF_NUM01 = 6
#declare LEAF_DST01 = 2.2
#declare LEAF_LNG00 = 18

// leaf spring
#declare LEAF01 =
union{
   superellipsoid { <1, .2>
      scale LEAF_LNG01
      rotate y*90
      translate <0,(LEAF_RAD01 - LEAF_THK02 * LEAF_NUM01*2), -LEAF_LNG00>
   }
   superellipsoid { <1, .2>
      scale LEAF_LNG01
      rotate y*90
      translate <0,(LEAF_RAD01 - LEAF_THK02 * LEAF_NUM01*2), LEAF_LNG00>
   }
   superellipsoid { <.5, .2>
      scale LEAF_LNG01*<1.2,1,.7>
      translate <0,(LEAF_RAD01 - LEAF_THK02 * LEAF_NUM01), -LEAF_LNG00*.5>
   }
   superellipsoid { <.5, .2>
      scale LEAF_LNG01*<1.2,1,.7>
      translate <0,(LEAF_RAD01 - LEAF_THK02 * LEAF_NUM01), LEAF_LNG00*.5>
   }
   #while ( LEAF_NUM01 >=0 )
   intersection{
      union{
         box { <-LEAF_LNG01, LEAF_RAD01+LEAF_LNG01, -LEAF_LNG00+LEAF_LNG01>
               <LEAF_LNG01, 0, LEAF_LNG00-LEAF_LNG01>
         }
         cylinder { <0, LEAF_RAD01+LEAF_LNG01, -LEAF_LNG00+LEAF_LNG01>
                    <0, 0, -LEAF_LNG00+LEAF_LNG01>
                    LEAF_LNG01
         }
         cylinder { <0, LEAF_RAD01+LEAF_LNG01, LEAF_LNG00-LEAF_LNG01>
                    <0, 0, LEAF_LNG00-LEAF_LNG01>
                    LEAF_LNG01
         }
      }
      difference {
         cylinder { <LEAF_LNG01*1.2, 0, 0> <-LEAF_LNG01*1.2, 0, 0>
            (LEAF_RAD01 - LEAF_THK02 * LEAF_NUM01)
         }
         cylinder { <LEAF_LNG01*1.5, 0, 0> <-LEAF_LNG01*1.5, 0, 0>
            (LEAF_RAD01 - LEAF_THK02 * LEAF_NUM01 - LEAF_THK01 )
         }
      }
   }

      #declare LEAF_LNG00 = LEAF_LNG00 - LEAF_DST01
      #declare LEAF_NUM01 = LEAF_NUM01 - 1
   #end
   translate y*-LEAF_RAD01
}

#declare LEAF_MNT_RAD01 = 2.5
#declare LEAF_MNT_LNG01 = 10
#declare LEAF_MNT_THK01 = .2
#declare LEAF_MNT_THK02 = 3

// leaf spring mount
#declare LEAF_MNT01=
union{
   torus { LEAF_MNT_RAD01 LEAF_MNT_THK01 }
   cylinder { < 0, 0, -LEAF_MNT_RAD01> < -LEAF_MNT_LNG01, 0, -LEAF_MNT_RAD01> LEAF_MNT_THK01 }
   sphere { < -LEAF_MNT_LNG01, 0, -LEAF_MNT_RAD01> LEAF_MNT_THK01 }
   cylinder {
      vrotate ( <0, 0, LEAF_MNT_RAD01>
                <0, -2*degrees( asin ( LEAF_MNT_RAD01 /
                sqrt ( pow ( LEAF_MNT_RAD01, 2 ) + pow ( LEAF_MNT_LNG01, 2 ) ) ) ), 0> )
      < -LEAF_MNT_LNG01, 0,-LEAF_MNT_RAD01> LEAF_MNT_THK01
   }
   prism { linear_sweep linear_spline -LEAF_MNT_THK01, LEAF_MNT_THK01, 4
       < 0, -LEAF_MNT_RAD01>
       < -LEAF_MNT_LNG01, -LEAF_MNT_RAD01>
       vrotate ( <0, LEAF_MNT_RAD01>
                <0, 0, 2*degrees( asin ( LEAF_MNT_RAD01 /
                sqrt ( pow ( LEAF_MNT_RAD01, 2 ) + pow ( LEAF_MNT_LNG01, 2 ) ) ) )> )
       < 0, -LEAF_MNT_RAD01>
   }
   cylinder { < 0, LEAF_MNT_THK01, 0> < 0, -LEAF_MNT_THK01, 0> LEAF_MNT_RAD01 }
   cylinder { < 0, 0, -LEAF_MNT_RAD01> < 0, -LEAF_MNT_THK02, -LEAF_MNT_RAD01> LEAF_MNT_THK01 }
   cylinder { < -LEAF_MNT_LNG01, 0, -LEAF_MNT_RAD01> < -LEAF_MNT_LNG01, -LEAF_MNT_THK02, -LEAF_MNT_RAD01> LEAF_MNT_THK01 }
   box { < -LEAF_MNT_LNG01, 0, -LEAF_MNT_RAD01-LEAF_MNT_THK01> < 0, -LEAF_MNT_THK02, -LEAF_MNT_RAD01+LEAF_MNT_THK01> }
   translate y*LEAF_MNT_THK02
   rotate x*-90
   translate y*( LEAF_MNT_RAD01 + LEAF_MNT_THK01 )
   texture {BTEX_02}
}

// steering wheel
#declare STWH01=
union{
   union{
      torus{ (17-1.5)/2 1.5/2 }
      #declare STW_Num01 = 47
      #while (STW_Num01 >= 0)
        sphere {<(17-1.5)/2, -.7, 0> .35
           rotate y*360/48*STW_Num01
        }
        #declare STW_Num01 = STW_Num01 - 1
      #end
      texture {BTEX_02}
   }
   sphere {0,1 scale <2,.8,2> translate y*-.5}
   cone{<0,0,0>1.1,<0,0,(17-1.5)/2>0.5 scale <1,.7,1> rotate x*-10 translate y*-1.5 }
   cone{<0,0,0>1.1,<0,0,(17-1.5)/2>0.5 scale <1,.7,1> rotate x*-10 rotate y*120 translate y*-1.5 }
   cone{<0,0,0>1.1,<0,0,(17-1.5)/2>0.5 scale <1,.7,1> rotate x*-10 rotate y*-120 translate y*-1.5 }
   cylinder { <0,-.5,0> <0,-5,0> 2 }
   cone { <0,-7,0> 1.2 <0,-5,0> 2 }
   cylinder {<0,-7,0> <0,-28,0> 1.2 }
}

// front end
#declare FRONT_END=
union{
   object { F_AXL_PRT01 rotate z*-5 }
   object { F_AXL_PRT01 scale < 1, 1, -1 > rotate z*-5 }
   object { F_AXL_PRT02
      rotate y*F_AXL_ROT01
      translate < 0, F_AXL_HGT01 -.3 - F_AXL_RAD01 * 1.1 *2, -F_AXL_LNG01 >
   }
   object { F_AXL_PRT02
      rotate y*F_AXL_ROT01
      translate < 0, F_AXL_HGT01 -.3 - F_AXL_RAD01 * 1.1 *2, F_AXL_LNG01 >
   }
   cylinder { ( vrotate ( < -F_AXL_LNG10, 0, 0 > < 0, F_AXL_ROT01, 0 > )
                  + < 0, F_AXL_HGT01 -.3 - F_AXL_RAD01 * 1.1 *2 +F_AXL_RAD10*2, -F_AXL_LNG01 > )
              ( vrotate ( < -F_AXL_LNG10, 0, 0 > < 0, F_AXL_ROT01, 0 > )
                  + < 0, F_AXL_HGT01 -.3 - F_AXL_RAD01 * 1.1 *2 +F_AXL_RAD10*2, F_AXL_LNG01 > )
      F_AXL_RAD10
   }

// front shock absorber
   object { F_SHA_01 translate <6, 0, -F_AXL_DST02 + F_SHA_DST02 + 1.5>}
   object { F_SHA_01 translate <6, 0, -F_AXL_DST02 + F_SHA_DST02 + 1.5> scale <1,1,-1>}

// front axle mount
   object { F_AXL_MNT01 translate z*-F_AXL_DST02}
   object { F_AXL_MNT01 translate z*-F_AXL_DST02 scale <1,1,-1>}

// leaf sprig + mount
   object { LEAF01 translate < 3, 2, 0 >}

   union{
      object { LEAF_MNT01 }
      object { LEAF_MNT01 scale <1, 1, -1>}
      union{
         object { BLT01 }
         cylinder { <0, 0, 0> <0, -4, 0> .4 }
         translate < -LEAF_MNT_LNG01+1, LEAF_MNT_THK01*2, -1.5 >
      }
      union{
         object { BLT01 }
         cylinder { <0, 0, 0> <0, -4, 0> .4 }
         translate < -LEAF_MNT_LNG01+1, LEAF_MNT_THK01*2, 1.5 >
      }
      union{
         object { BLT01 }
         cylinder { <0, 0, 0> <0, -4, 0> .4 }
         translate < -LEAF_MNT_LNG01+4, LEAF_MNT_THK01*2, -1.5 >
      }
      union{
         object { BLT01 }
         cylinder { <0, 0, 0> <0, -4, 0> .4 }
         translate < -LEAF_MNT_LNG01+4, LEAF_MNT_THK01*2, 1.5 >
      }
      translate < 11, 2, 0 >
   }
// rods 2
   object {F_ROD02 translate < 0, 9, -(F_AXL_LNG01+1)> }

// wheels
   object { TY00
      rotate x*3
      scale .85*<1, 1, -1>
      rotate y*F_AXL_ROT01
      translate < 0, F_AXL_HGT01, (F_AXL_LNG01+1) >
   }
   object { TY00
      rotate x*3
      scale .85
      rotate y*F_AXL_ROT01
      translate < 0, F_AXL_HGT01, -(F_AXL_LNG01+1) >

   }
   #declare Ang = F_AXL_ROT01
   #include "brake01.inc"
// brake wire
   object { Brake01
      rotate x*90
      scale <1,-1,1>
      rotate y*( -15 - Ang/4 )
      rotate z*-.5
      translate End01
      texture {BTEX_02 pigment{color rgb <1,0.2,0>}}
   }

   #declare Ang = -F_AXL_ROT01
   #include "brake01.inc"
   object { Brake01
      rotate x*90
      scale <1,-1,1>
      rotate y*( -15 - Ang/4 )
      rotate z*-.5
      translate End01
      scale <1, 1, -1>
      texture {BTEX_02 pigment{color rgb <1,0.2,0>}}
   }
// steering wheel
   object { STWH01
      rotate z*-30
      translate < 93, 35, -10 >
   }

   texture { METAL01 }
}
