
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod wheels
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

//TEXTURES:
// Tyres:
#declare TTEX =
   texture{
      finish{
         ambient <0.9,0.85,.8>*.2
         diffuse .95
         phong .05
         phong_size 3
      }
      pigment{color rgb <0.9,0.85,.8>*.2}
   }

// Chrome parts:
#declare WTEX =
texture{
   finish{
      diffuse 0.9
      ambient 0.1
      phong 0.9
      phong_size 100
   }
   pigment{ color rgb <1,.5,0>
   }
}

// Default yellow paint:
#declare BTEX =
   texture{
      finish {
         ambient <1,.9,.05>*.3
         diffuse 0.7
         specular 0.80
         roughness 1/100
         reflection 0.3
      }
      normal {bumps 0.05 scale 20}
      pigment{color rgb <1,.9,.05>}
   }


#declare BLT_Thk11 = .9
#declare BLT_Rad11 = .6
#declare BLT_Rad12 = .6
#declare BLT_Rad13 = .1

// bolt
#declare BLT11=
union{
   intersection{
      union{
         cylinder { < 0, 0 ,0 > < 0, BLT_Thk11, 0 > BLT_Rad11 }
         sphere { < 0, BLT_Thk11, 0 > BLT_Rad11}
      }
      #declare COUNT=6

      prism { linear_sweep linear_spline
         -1, ( BLT_Thk11 + BLT_Rad11 ) * 1.5 , COUNT+1,

         #while( COUNT >= 0)
            #declare BLT_Ang11 = pi/3 * COUNT

            < BLT_Rad11 * cos ( BLT_Ang11), BLT_Rad11 * sin ( BLT_Ang11) >
            #if (COUNT > 0 )
               ,
            #end
            #declare COUNT = COUNT - 1
         #end
      }
   }
   torus { BLT_Rad12, BLT_Rad13 translate y * - BLT_Rad13 }
   translate y * BLT_Rad13
   rotate x * -90
}

#declare INNR01=10
#declare OUTR01=18
#declare WHITE= 15
#declare SMOO01=(OUTR01-INNR01)/2
#declare SMOO02=.5
#declare SM0s01=.5
#declare WIDT01=17

#declare DEPTH01 = .7

// rear tyre
#declare TY011=
difference{
   union{
      cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01))><0,0,(WIDT01/2-(SMOO01*SM0s01))*-1>OUTR01}
      torus {INNR01+SMOO01,SMOO01 scale <1,SM0s01,1>
         rotate x*90
         translate z*(WIDT01/2-(SMOO01*SM0s01))*-1
      }
      intersection{
         cylinder {<0,0,0 ><0,0,WIDT01/2*-1>WHITE}
         torus {INNR01+SMOO01,SMOO01+.1 scale <1,SM0s01,1>
            rotate x*90
         }
         translate z*(WIDT01/2-(SMOO01*SM0s01) +.1 )*-1
         texture { TTEX pigment{ color rgb <0.9,0.85,.8>} }
      }
      torus {INNR01+SMOO01,SMOO01 scale <1,SM0s01,1>
         rotate x*90
         translate z*(WIDT01/2-(SMOO01*SM0s01))
      }
      torus {OUTR01*.99,SMOO02
         scale <1,(WIDT01/2-(SMOO01*SM0s01))/(SMOO02*.96),1>
         texture { TTEX
            normal { gradient y 1
               slope_map {
                  [0    <0, 1>]
                  [0.2  <1, 0>]
                  [0.5  <1,0>]
                  [0.7  <1, 0>]
                  [1    <0, -1>]
               }
               turbulence .1
               scale 1.5
            }
            pigment{
               gradient y
               color_map{
                  [ 0 color rgb 0 ]
                  [ .2 color rgb <0.9,0.85,.8>*.3 ]
                  [ .5 color rgb <0.9,0.85,.8>*.5 ]
                  [ .8 color rgb <0.9,0.85,.8>*.3 ]
                  [ 1 color rgb 0 ]
               }
               turbulence .1
               scale 1.5
            }
         }
         rotate x*90
      }
   }
   cylinder {<0,0,(WIDT01/2)*1.5><0,0,(WIDT01/2)*-1.5>INNR01}
texture{TTEX}
translate z * - WIDT01/2
}

#declare STEP01=1

// rear wheel
#declare TY02=
union{
   difference{
       union{
          torus {INNR01-.3,STEP01 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-STEP01)*-1}
          torus {INNR01-.3,STEP01 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-STEP01)*1}
          cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01)-STEP01)*1><0,0,(WIDT01/2-(SMOO01*SM0s01)-STEP01)*-1>INNR01-.3+STEP01}
          }
       cylinder {<0,0,(WIDT01/2-STEP01*2)*1.5><0,0,(WIDT01/2-STEP01*2)*-1.5>INNR01-.3-STEP01}
   }
    difference{
       union{
          torus {INNR01-(STEP01+.3),1 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-2)*-1}
          torus {INNR01-(STEP01+.3),1 rotate x*90 translate z*(WIDT01/2-(SMOO01*SM0s01)-2)*1}
          cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01)-2)*1><0,0,(WIDT01/2-(SMOO01*SM0s01)-2)*-1>INNR01-(STEP01*2+.3)}
          }
       cylinder {<0,0,(WIDT01/2-2)*1.5><0,0,(WIDT01/2-2)*-1.5>INNR01-.3-STEP01*2}
   }
   union{
      #declare SECT01 = 5
      #declare ANGL01 = 360/SECT01
      #declare ANGL00 = 0
      #while (SECT01>=0)
         cone{ < INNR01 -.3 -STEP01*2, 0, 0 > 2 < 0, 0, 0 > 0
            scale < 1, 1, 1.5 >
            rotate z*ANGL00
         }
         object { BLT11
            translate < 3, 0, .5 >
            rotate z*(ANGL00 + ANGL01/2)
         }
         #declare SECT01 = SECT01-1
         #declare ANGL00 = ANGL00 + ANGL01
      #end
      cylinder{<0,0,4><0,0,-1>,2}
      cylinder{<0,0,.5><0,0,2.5>,4.5}
      cylinder{<0,0,4><0,0, WIDT01/2 - DEPTH01 >, 7.2 }
      torus { 7.2, .5 rotate x* 90 translate z* ( WIDT01/2 - DEPTH01 - .5 ) }
      superellipsoid { < 1, 1.5 > scale < 1.8, 1.8, 3 > translate z* -1 }

      translate z * DEPTH01
   }

   difference{
      cylinder {<0,0,(WIDT01/2-(SMOO01*SM0s01))*1.1><0,0,(WIDT01/2-(SMOO01*SM0s01))*-1.1>INNR01}
      cylinder {<0,0,(WIDT01/2)*1.5><0,0,(WIDT01/2)*-1.5>INNR01-.3}
   }
translate z * - WIDT01/2
}



// #declare METAL01 = texture{T_Chrome_3D}

#declare WHEEL_RAD00 = 18
#declare WHEEL_RAD10 = 1

#declare WHEEL_RAD01 = 15
#declare WHEEL_RAD02 = 2

#declare WHEEL_RAD12 = WHEEL_RAD02/2
#declare WHEEL_RAD11 = WHEEL_RAD01-WHEEL_RAD02+WHEEL_RAD12
#declare WHEEL_RAD13 = 15
#declare WHEEL_RAD14 = .2

#declare CYL_RAD01 = 1.7
#declare CYL_LNG01 = 3.5

#declare SP_WH_NUM01 = 8
#declare SP_WH_ANG00 = 360/(SP_WH_NUM01+1)
#declare SP_WH_LNG01 = 2.5
#declare SP_WH_LNG11 = .4
#declare SP_WH_RAD01 = 2.1
#declare SP_WH_RAD11 = 2.3
#declare SP_WH_RAD02 = .15

#declare BR_DSK_RAD00 = 6
#declare BR_DSK_THK00 = 1.5

#declare BR_DSK_RAD01 = 10
#declare BR_DSK_THK01 = .4
#declare BR_DSK_RAD11 = 1
#declare BR_DSK_RAD02 = .4
#declare BR_DSK_NUM01 = 23
#declare BR_DSK_ANG01 = 360/(BR_DSK_NUM01+1)

#declare BR_DSK_RAD13 = 5.5
#declare BR_DSK_RAD23 = 3.5
#declare BR_DSK_THK03 = 2.5
#declare BR_DSK_RAD04 = 2
#declare BR_DSK_THK04 = 3

// front wheels
#declare TY00 =
union{
   union{
      torus{ WHEEL_RAD00, WHEEL_RAD10 rotate x*90 scale <1, 1, 2*.7>
      texture { TTEX
            normal { gradient y 1
               slope_map {
                  [0    <0, 1>]
                  [0.2  <1, 0>]
                  [0.5  <1,0>]
                  [0.7  <1, 0>]
                  [1    <0, -1>]
               }
               turbulence .1
               scale .7
               rotate x*90
            }
            pigment{
               gradient y
               color_map{
                  [ 0 color rgb 0 ]
                  [ .2 color rgb <0.9,0.85,.8>*.3 ]
                  [ .5 color rgb <0.9,0.85,.8>*.5 ]
                  [ .8 color rgb <0.9,0.85,.8>*.3 ]
                  [ 1 color rgb 0 ]
               }
               turbulence .1
               scale .7
               rotate x*90
            }
         }
      }
      torus{ WHEEL_RAD00-(WHEEL_RAD00 - WHEEL_RAD01)/2, (WHEEL_RAD00 - WHEEL_RAD01)/2*1.05
         rotate x*90 scale <1, 1, .3>
         translate z*-WHEEL_RAD02*.7
      }
      torus{ WHEEL_RAD00-(WHEEL_RAD00 - WHEEL_RAD01)/2, (WHEEL_RAD00 - WHEEL_RAD01)/2*1.05
         rotate x*90 scale <1, 1, .3>
         translate z*WHEEL_RAD02*.7
      }
      scale <1, 1, 1.05>

       texture { TTEX }
   }

   torus{ WHEEL_RAD11, WHEEL_RAD12  rotate x*90 scale <1,1,2>}
   difference{
      cylinder { <0,0,-WHEEL_RAD12*2> <0,0,WHEEL_RAD12*2> WHEEL_RAD13 }
      cylinder { <0,0,-WHEEL_RAD12*2.2> <0,0,WHEEL_RAD12*2.2> WHEEL_RAD11 }
   }
   torus{ WHEEL_RAD13, WHEEL_RAD14  rotate x*90 translate z*-WHEEL_RAD12*2}
   torus{ WHEEL_RAD13, WHEEL_RAD14  rotate x*90 translate z*WHEEL_RAD12*2}

   cylinder { <0,0,-CYL_LNG01> <0,0,CYL_LNG01> CYL_RAD01 }
   sphere { 0, CYL_RAD01 scale <1,1,.5> translate <0,0,-CYL_LNG01> }

   cylinder { <0,0,-SP_WH_LNG11/1.5> <0,0,SP_WH_LNG11/1.5> SP_WH_RAD11 translate z*-SP_WH_LNG01}
   cylinder { <0,0,SP_WH_LNG11/1.5> <0,0,-SP_WH_LNG11/1.5> SP_WH_RAD11 translate z*SP_WH_LNG01}

   #declare SP_01=
   union{
   #while ( SP_WH_NUM01 >= 0)
       cylinder{
          vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
          vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01-SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01-SP_WH_ANG00*2)>)
          SP_WH_RAD02
       }
       sphere{
          vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
          SP_WH_RAD02
       }
       sphere{
          vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01-SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01-SP_WH_ANG00*2)>)
          SP_WH_RAD02
       }

       cylinder{
          vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
          vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01+SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01+SP_WH_ANG00*2)>)
          SP_WH_RAD02
          rotate z*SP_WH_ANG00/2
       }
       sphere{
          vrotate (<0,WHEEL_RAD01-WHEEL_RAD02,0><0,0,SP_WH_ANG00*SP_WH_NUM01>)
          SP_WH_RAD02
          rotate z*SP_WH_ANG00/2
       }
       sphere{
          vrotate (<0,SP_WH_RAD01,-SP_WH_LNG01+SP_WH_LNG11><0,0,(SP_WH_ANG00*SP_WH_NUM01+SP_WH_ANG00*2)>)
          SP_WH_RAD02
          rotate z*SP_WH_ANG00/2
       }
       #declare SP_WH_NUM01 = SP_WH_NUM01-1
   #end
   }

   object { SP_01  }
   object { SP_01 rotate y*180 rotate z*SP_WH_ANG00/4}

   union{
      cylinder { <0, 0, BR_DSK_THK00> <0, 0, -BR_DSK_THK00>BR_DSK_RAD00 }
      union{
         superellipsoid { < 1.2, .3>
            scale < BR_DSK_RAD23, BR_DSK_RAD13, BR_DSK_THK03 >
         }
         superellipsoid { < 1, .2>
            scale < BR_DSK_RAD04, BR_DSK_RAD04, BR_DSK_THK04 >
            translate x*- BR_DSK_RAD11
         }
         translate x*(BR_DSK_RAD01 - BR_DSK_RAD11 )
         rotate z*15
      }
      difference{
         cylinder { <0, 0, BR_DSK_THK01> <0, 0, -BR_DSK_THK01>BR_DSK_RAD01 }
         #while ( BR_DSK_NUM01 >= 0)
            cylinder { <0, 0, BR_DSK_THK01*1.2> <0, 0, -BR_DSK_THK01*1.2>BR_DSK_RAD02
               translate x * (BR_DSK_RAD01 - BR_DSK_RAD11)
               rotate z * BR_DSK_ANG01 * BR_DSK_NUM01
            }
            cylinder { <0, 0, BR_DSK_THK01*1.2> <0, 0, -BR_DSK_THK01*1.2>BR_DSK_RAD02
               translate x * (BR_DSK_RAD01 - BR_DSK_RAD11*2)
               rotate z * BR_DSK_ANG01 * BR_DSK_NUM01
               rotate z * BR_DSK_ANG01/4
            }
            cylinder { <0, 0, BR_DSK_THK01*1.2> <0, 0, -BR_DSK_THK01*1.2>BR_DSK_RAD02
               translate x * (BR_DSK_RAD01 - BR_DSK_RAD11*3)
               rotate z * BR_DSK_ANG01 * BR_DSK_NUM01
               rotate z * BR_DSK_ANG01/2
            }
            #declare BR_DSK_NUM01 = BR_DSK_NUM01 -1
         #end
      }
      translate z*( CYL_LNG01 + BR_DSK_THK00 )
   }
   translate z*-( CYL_LNG01 + BR_DSK_THK00*2 )
}
