
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: T-Model hot-rod windshield glass
// Date: 27.02.1998
// Auth: N.B. beliaev@utu.fi

/*
#declare WS_LNG01 = 20
#declare WS_HGT01 = 10
#declare WS_RAD01 = 5
#declare WS_NUM01 = 5
#declare WS_NUM00 = WS_NUM01
#declare WS_ANG01 = 90/(WS_NUM01+1)
#declare WS_THK01 = 0.5
*/

#declare T_Glass01 =
texture{
   finish {
      specular 1
      roughness 0.001
      ambient 0
      diffuse 0
      refraction 1
      ior 1.5
      reflection 0.2
      caustics 0.6
   }
   normal {bumps 0.05 scale 20}
   pigment { color rgbf<1.0, 1.0, 1.0, 0.7> }
}

#declare WS_GLASS01 =
prism {
  linear_sweep
  linear_spline
  -WS_THK01,
   WS_THK01,
  (6 + (WS_NUM01 + 1)*2),

  < 0, 0 >, < (WS_LNG01 + WS_RAD01), 0>,
  #while ( WS_NUM01 >= 0)
     vrotate (< WS_RAD01, 0>, < 0, 0, 90-WS_ANG01*WS_NUM01>) + < WS_LNG01, WS_HGT01>
     #if (WS_NUM01 > 0 )
     ,
     #end
     #declare WS_NUM01 = WS_NUM01 - 1
  #end

  < WS_LNG01, WS_HGT01 + WS_RAD01>, < -WS_LNG01, WS_HGT01 + WS_RAD01>,

  #declare WS_NUM01 = WS_NUM00
  #while ( WS_NUM01 >= 0)
     vrotate (< WS_RAD01, 0>, < 0, 0, 180-WS_ANG01*WS_NUM01>) + < -WS_LNG01, WS_HGT01>
     #if (WS_NUM01 > 0 )
     ,
     #end
     #declare WS_NUM01 = WS_NUM01 - 1
  #end

  < -(WS_LNG01 + WS_RAD01), 0>, < 0, 0 >
  // texture {DEF_TEX}
}
