
// Persistence of Vision Ray Tracer Scene Description File
// File: ChipPins.inc
// Vers: 3
// Desc: pins for an IC chip 
// Date: Febuary 8th 1998
// Auth: Morgan Fraser

// number of pins on each side of chip
#ifndef (Pins_Count)
    #declare Pins_Count=10
#end

// connection height to chip
#ifndef (Pins_Height)
    #declare Pins_Height=1.5
#end

#ifndef (Pins_ChipWidth)
    #declare Pins_ChipWidth=3
#end

#ifndef(Pins_Length)
    #declare Pins_Length=22
#end

// set to 1 to include a sodering point
// any other value means no sodering points
#ifndef (Pins_IncludeSoderPoint)
    #declare Pins_IncludeSoderPoint=1
#end

#ifndef (T_ChipLeg)
    #declare T_ChipLeg=texture{
        #if (QuickColour=1)
            pigment{
                color rgb<.9,.9,.92>
            }
        #else
            pigment{
                color rgb<.85,.86,.92>
            }
            finish{
                specular .7
                roughness .003
                metallic
                reflection .65
            }
        #end
    }
#end

#ifndef(SoderPoint)
    #declare SoderPoint=object{
        sphere{<0,0,0>,.7 scale <1,0.6,1>}
        texture{T_ChipLeg}
    }
#end

#ifndef(ChipLeg)
    // 0,0,0 is middle top of pin at connection point to
    // the chip
    // height is 2 mm
    // width is 1mm
    // depth is 1mm
    #if (SimpleShapes=1)
        #declare ChipLeg=object{
                union{
                    box{<-0.5,0,0>,<0.5,-0.2,-1>}
                    box{<0.5,-0.2,-1>,<-0.5,-3,-0.8>}
                }
            texture{T_ChipLeg}
        }
    #else
        #declare ChipLeg=object{
            union{
                box{<-0.5,0,0>,<0.5,-0.2,-0.8>}
                cylinder{<-0.5,-0.2,-0.8>,<0.5,-0.2,-0.8>,0.2}
                box{<0.4,-0.2,-1>,<-0.4,-3,-0.8>}
                cylinder{<0.4,-0.2,-0.9>,<0.4,-3,-0.9>,0.1}
                cylinder{<-0.4,-0.2,-0.9>,<-0.4,-3,-0.9>,0.1}
            }
        texture{T_ChipLeg}
        }
    #end
#end

#declare Counter=0
#while (Counter<Pins_Count)
    object{ChipLeg translate<-Pins_Length/2+Pins_Length/(Pins_Count-1)*Counter,Pins_Height,-Pins_ChipWidth/2>}
    object{ChipLeg rotate<0,180,0> translate<-Pins_Length/2+Pins_Length/(Pins_Count-1)*Counter,Pins_Height,Pins_ChipWidth/2>}
    #if(Pins_IncludeSoderPoint=1)
        object{SoderPoint translate<-Pins_Length/2+Pins_Length/(Pins_Count-1)*Counter,0,-Pins_ChipWidth/2-1>}
        object{SoderPoint translate<-Pins_Length/2+Pins_Length/(Pins_Count-1)*Counter,0,Pins_ChipWidth/2+1>}
    #end
    #declare Counter=Counter+1
#end

