#include "metals.inc"

#declare TroughRadius = 50
#declare FenceRadius = 70
#declare FenceRadius2 = 74.5
#declare TubeSetRadius = 50
#declare ColumnRadius = 30
#declare OutsideRadius = 95
//#declare TubeWallRadius = 88
#declare TubeWallRadius = 95
#declare PlateRadius = 80
#declare HPlateRadius = 81.5
#declare LPlateRadius = 79
#declare RingRadius = 26.5
#declare InnerRingRadius = 25
#declare PanelRadius = 25.5
#declare BandRadius = 26.5
#declare HiPanelRadius = 28.75
#declare SupportRadius = RingRadius+2.1*0.5
#declare BoltRadius1 = RingRadius - 0.25*0.75
#declare BoltRadius2 = BoltRadius1 + 2
#declare HighConeEnd = 40
#declare MiniPlateMinorRadius = 15
#declare MiniPlateMajorRadius = 27
#declare BottomRadius = 32
#declare BottomPlateRowRadius = 5.5
#declare NotchPlateRadius = 80
#declare OuterRRadius = 83

#declare S1 = seed(6)

#declare Metal1 =	
texture {
	pigment { color Silver }
	finish
		{
		//ambient.1
		ambient 0
		diffuse.4
		specular 1
		roughness 0.001
		reflection.5
		metallic
		}
	}

#declare Metal2 =
texture {
	pigment { color Silver*0.8 }
	finish
		{
		//ambient.1
		ambient 0
		diffuse.4
		specular 1
		roughness 0.001
		reflection.5
		metallic
		}
	}

#declare BrickTexture =
texture
	{
	pigment { color LightSteelBlue }
	finish {
		//ambient 0.1
		ambient 0
		diffuse 0.4
		specular 1
		roughness 0.001
		reflection 0.3
		metallic
		}
	}

#declare ShinyMetal =
texture
	{
	pigment { color rgb <0.92, 0.93, 1>*0.9 }
	finish {
		//ambient 0.35
		ambient 0
		diffuse 0.4
		specular 1
		roughness 0.001
		reflection 0.4
		metallic
		}
	}

#declare BackMetal =
texture
	{
	pigment {
		granite
		color_map
			{
			[0 color rgb <0.92, 0.93, 1>]
			[1 color Silver*0.8 ]
			}
		scale 15
		}
	finish {
		//ambient 0.1
		//diffuse 0.4
		ambient 0.25
		diffuse 0
		specular 1
		roughness 0.001
		reflection 0.1
		metallic
		}
	normal { granite scale 5}
	}

#declare BackMetal2 = texture
        {
        pigment {
                crackle
                color_map
                        {
                        [0 color rgb <0.92, 0.93, 1>]
			[0.33 color LightSteelBlue ]
			[0.66 color Silver ]
                        [1 color Silver*0.8 ]
                        }
                scale 5
                }
        finish {
                //ambient 0.1
                //diffuse 0.4
		ambient 0.375
		diffuse 0
                specular 1
                roughness 0.001
                reflection 0.15
                metallic
                }
	normal {
		radial
		frequency 60
		normal_map
			{
			[0 granite scale 5]
			[0.48 granite scale 5]
			[0.52 crackle scale 5]
			[1 crackle scale 5]
			}
		}
        }


#declare LowBrick =   // Thick blocks at bottom of outside ring, 2 rows
box { <-6, -4, -1.5>, <6, 4, 1.5>
	texture { BrickTexture }
}

#declare Ramp =  // Part of the trough at the bottom of the torus
difference {
	box { <-9, -4.5, -6>, <10, 4.5, 6> }
	plane	{
		y*-1, 0
		rotate z*30
		translate x*-2
		hollow
		}
	texture { BrickTexture }
}

#declare WallSegment = union
{
	object { Ramp
		translate x*-9.5
		}
	object { Ramp
		rotate y*180
		translate x*9.5
		}
}

#declare Wall =
difference
{
   union {
	#declare Loop = 0
	#while (Loop < 36 )
	object { WallSegment
		rotate y*10*Loop
		translate <-TroughRadius*cos(radians(10*Loop)), 0, TroughRadius*sin(radians(10*Loop))>
		}
	#declare Loop = Loop + 1
	#end
	}
   difference {
	cylinder { -10*y, 10*y, TroughRadius + 0.5 }
	cylinder { -10*y, 10*y, TroughRadius - 0.5 }
	}
   #declare Loop = 0
   #while  (Loop < 18)
	object { box { <-TroughRadius - 20, -10, -0.125>,
		       <TroughRadius + 20, 10, 0.125>
			rotate 10*y*Loop + 5
			}
		}
   #declare Loop = Loop + 1
   #end
   texture { Metal1 }
}

#declare Fence =
union {
	#declare Loop = 0
	#while (Loop < 36)
	object { LowBrick
		rotate x*30
		rotate y*-90 + y*10*Loop
		translate <-FenceRadius*cos(radians(Loop*10)), 10,
			FenceRadius*sin(radians(Loop*10))>
		}
	#declare Loop = Loop + 1
	#end

	#declare Loop = 0
	#while (Loop < 36)
	object { LowBrick
		rotate x*39
		rotate y*-90 + y*10*Loop
		translate <-FenceRadius2*cos(radians(Loop*10)), 17,
			FenceRadius2*sin(radians(Loop*10))>
		}
	#declare Loop = Loop + 1
	#end
}

#declare BoltPlate1 =  //(big) flat plates paired vertically above and below columns
difference
	{
	box { <-5, -7.5, -1.5>, <5, 7.5, 1.5> }
	sphere { <-3, 5.5, -1.75>, .75 }
	sphere { <3, -5.5, -1.75>, .75 }
	texture { Metal1 }
	}

#declare BoltPlate2 = //(small) flat plates interspersed with BoltPlate1 types
difference
	{
	box { <-4, -7.5, -1.5>, <4, 7.5, 1.5> }
	sphere { <-2.5, 5.5, -1.75>, .75 }
	sphere { <2.5, -5.5, -1.75>, .75 }
	texture { Metal1 }
	}

#declare FillPlate1 =
	box {  <-5, -2, -1.5>, <5, 2, 1.5> texture { ShinyMetal } }

#declare FillPlate2 =
	box {  <-4, -2, -1.5>, <4, 2, 1.5> texture { ShinyMetal } }

#declare ThinTube = //one of mesh of tiny tubes found in 3 sets regularly
union
	{
	cylinder { <-6, 0, 0>, <6, 0, 0>, 0.25
		texture { Metal2 }
		}
	difference {
		torus { 0.5, 0.0625
			rotate x*-90
			}
		plane { x*-1, 0 hollow }
		plane { y*1, 0 hollow }
		translate <-6, -0.5, 0>
		texture { ShinyMetal }
		}
        difference {
                torus { 0.5, 0.125
                        rotate x*-90
                        }
                plane { x*1, 0 hollow }
                plane { y*1, 0 hollow }
                translate <6, -0.5, 0>
		texture { ShinyMetal }
                }
	}

#declare TubeSet =
union {
	#declare Loop = 0
	#while (Loop < 46)
	object { ThinTube
		rotate y*-90
		rotate z*(-90 + 15 - Loop*30/45)
		translate <-TubeSetRadius*cos(radians(Loop*30/45 - 15)) + TubeSetRadius,
			TubeSetRadius*sin(radians(Loop*30/45 - 15)), 0>
		}
	#declare Loop = Loop + 1
	#end
}

#declare TubeWall =
union {
	//#declare Theta = 7.9696
	//#declare Theta = 9.962
	#declare Theta = 8.8
	#declare Loop = -1.5
	#while (Loop < 2)
	object { TubeSet
		no_shadow
		rotate x*-10
		rotate y*Loop*Theta
		translate <-TubeWallRadius*cos(radians(Loop*Theta)) + TubeWallRadius, 0,
			TubeWallRadius*sin(radians(Loop*Theta))>
		}
	#declare Loop = Loop + 1
	#end
	scale 1.25
}

#declare ColumnPlate =
	superellipsoid { <0.2, 0.2> texture { Metal1 } }

#declare ColumnSet =
difference {
	union {
	object { ColumnPlate rotate x*90
		scale <1, 0.5, 0.15> rotate y*-7
		translate x*1 }
	object { ColumnPlate rotate x*90
		scale <1, 0.5, 0.15> rotate y*7
		translate x*-1 }
	}
	sphere { <-0.5, 0, -0.28>, 0.125 texture { Metal1 }}
	sphere { <0.5, 0, -0.28>, 0.125 texture { Metal1 }}
}

#declare Column =  union {
	#declare Loop = -9
	#while (Loop < 10)
	object { ColumnSet rotate x*-Loop
		translate <0, Loop, cos(radians(Loop*9))> }
	#declare Loop = Loop + 1
	#end
	scale <3, 4, 3>
}

#declare Columns = union {
	object { Column translate z*-ColumnRadius }
	object { Column rotate y*180 translate z*ColumnRadius }
	object { Column rotate y*90 translate x*-ColumnRadius }
	object { Column rotate y*-90 translate x*ColumnRadius }
	object { Column rotate y*45 translate <-ColumnRadius*sqrt(2)/2, 0, -ColumnRadius*sqrt(2)/2> }
	object { Column rotate y*-45 translate <ColumnRadius*sqrt(2)/2, 0, -ColumnRadius*sqrt(2)/2> }
	object { Column rotate y*135 translate <-ColumnRadius*sqrt(2)/2, 0, ColumnRadius*sqrt(2)/2> }
	object { Column rotate y*-135 translate <ColumnRadius*sqrt(2)/2, 0, ColumnRadius*sqrt(2)/2> }
}

#declare WidePlates = union {
        object { BoltPlate1 translate y*9.6 }
        object { FillPlate1 }
        object { BoltPlate1 translate y*-9.6 }
}

#declare ThinPlates = union {
        object { BoltPlate2 translate y*9.6 }
        object { FillPlate2 }
        object { BoltPlate2 translate y*-9.6 }
}

#declare HPlateSet1 = union {
        object { WidePlates
		rotate x*-20
                rotate y*-degrees(atan2(16/HPlateRadius, 1))
                translate <HPlateRadius*sin(atan2(16/HPlateRadius, 1)), 0,
                        -HPlateRadius*cos(atan2(16/HPlateRadius, 1)) + HPlateRadius>  }
        object { WidePlates
		rotate x*-20
                rotate y*degrees(atan2(16/HPlateRadius, 1))
                translate <-HPlateRadius*sin(atan2(16/HPlateRadius, 1)), 0,
                        -HPlateRadius*cos(atan2(16/HPlateRadius, 1)) + HPlateRadius>  }
        }

#declare LPlateSet1 = union {
        object { WidePlates
		rotate x*10
                rotate y*-degrees(atan2(16/LPlateRadius, 1))
                translate <LPlateRadius*sin(atan2(16/LPlateRadius, 1)), 0,
                        -LPlateRadius*cos(atan2(16/LPlateRadius, 1)) + LPlateRadius>  }
        object { WidePlates
		rotate x*10
                rotate y*degrees(atan2(16/LPlateRadius, 1))
                translate <-LPlateRadius*sin(atan2(16/LPlateRadius, 1)), 0,
                        -LPlateRadius*cos(atan2(16/LPlateRadius, 1)) + LPlateRadius>  }
        }

#declare HPlateSet2 = union {
        object { WidePlates
		rotate x*-20
                rotate y*degrees(atan2(16/HPlateRadius, 1))
                translate <-HPlateRadius*sin(atan2(16/HPlateRadius, 1)), 0,
                        -HPlateRadius*cos(atan2(16/HPlateRadius, 1)) + HPlateRadius>  }
        object { ThinPlates
		rotate x*-20
                rotate y*-degrees(atan2(10/HPlateRadius, 1))
                translate <HPlateRadius*sin(atan2(10/HPlateRadius, 1)), 0,
                        -HPlateRadius*cos(atan2(10/HPlateRadius, 1)) + HPlateRadius>  }
        object { ThinPlates
		rotate x*-20
                rotate y*-degrees(atan2(25/HPlateRadius, 1))
                translate <HPlateRadius*sin(atan2(25/HPlateRadius, 1)), 0,
                        -HPlateRadius*cos(atan2(25/HPlateRadius, 1)) + HPlateRadius>  }
        }

#declare LPlateSet2 = union {
        object { WidePlates
		rotate x*10
                rotate y*degrees(atan2(16/LPlateRadius, 1))
                translate <-LPlateRadius*sin(atan2(16/LPlateRadius, 1)), 0,
                        -LPlateRadius*cos(atan2(16/LPlateRadius, 1)) + LPlateRadius>  }
        object { ThinPlates
		rotate x*10
                rotate y*-degrees(atan2(10/LPlateRadius, 1))
                translate <LPlateRadius*sin(atan2(10/LPlateRadius, 1)), 0,
                        -LPlateRadius*cos(atan2(10/LPlateRadius, 1)) + LPlateRadius>  }
        object { ThinPlates
		rotate x*10
                rotate y*-degrees(atan2(25/LPlateRadius, 1))
                translate <LPlateRadius*sin(atan2(25/LPlateRadius, 1)), 0,
                        -LPlateRadius*cos(atan2(25/LPlateRadius, 1)) + LPlateRadius>  }
        }

#declare PlatesHigh = union { // was x*-3
	object { HPlateSet2 translate <0, 0, -HPlateRadius> }
	object { HPlateSet1 rotate y*45 translate <-HPlateRadius/sqrt(2), 0,
		-HPlateRadius/sqrt(2)> }
	object { HPlateSet1 rotate y*90 translate <-HPlateRadius, 0, 0> }
	object { HPlateSet1 rotate y*-90 translate <HPlateRadius, 0, 0> }
	object { HPlateSet1 rotate y*-45 translate <HPlateRadius/sqrt(2), 0,
		-HPlateRadius/sqrt(2)> }
	object { HPlateSet2 rotate y*180 translate <0, 0, HPlateRadius> }
	object { HPlateSet1 rotate y*135 translate <-HPlateRadius/sqrt(2), 0,
		HPlateRadius/sqrt(2)> }
	object { HPlateSet1 rotate y*-135 translate <HPlateRadius/sqrt(2), 0,
		HPlateRadius/sqrt(2)> }
	scale <0.4, 0.4, 0.4>
	translate y*118
}

#declare PlatesLow = union { 
	object { LPlateSet2 translate <0, 0, -LPlateRadius> }
	object { LPlateSet1 rotate y*45 translate <-LPlateRadius/sqrt(2), 0,
		-LPlateRadius/sqrt(2)> }
	object { LPlateSet1 rotate y*90 translate <-LPlateRadius, 0, 0> }
	object { LPlateSet1 rotate y*-90 translate <LPlateRadius, 0, 0> }
	object { LPlateSet1 rotate y*-45 translate <LPlateRadius/sqrt(2), 0,
		-LPlateRadius/sqrt(2)> }
	object { LPlateSet2 rotate y*180 translate <0, 0, LPlateRadius> }
	object { LPlateSet1 rotate y*135 translate <-LPlateRadius/sqrt(2), 0,
		LPlateRadius/sqrt(2)> }
	object { LPlateSet1 rotate y*-135 translate <LPlateRadius/sqrt(2), 0,
		LPlateRadius/sqrt(2)> }
	scale <0.4, 0.4, 0.4>
	translate y*18
}

// was 0, -1, 0
#declare BottomRing = cylinder { <0, -6, 0>, <0, 6, 0>, BottomRadius
		texture { Metal2 } }

#declare MidRing =
	//cylinder { <0, -5, 0>, <0, 5, 0>, RingRadius
	cylinder { <0, -5, 0>, <0, 18, 0>, RingRadius
		texture { ShinyMetal } translate y*85 }

#declare MidTrunk =
	cylinder { <0, -30, 0>, <0, 30, 0>, InnerRingRadius
		texture { Metal1 } translate y*55 }

#declare HighBand =
        torus { BandRadius, 2 scale <1, 3, 1>
		texture { Metal1 } translate y*96 }

#declare LowBand =
        torus { BandRadius, 2 scale <1, 2, 1>
		texture { Metal1 } translate y*26 }

#declare LowerFill = cylinder { <0, 25, 0>, <0, 0, 0>, BandRadius
	texture { Metal2 } }

#declare BumpPlate = difference
{
        union
                {
                box { <-4, -7.45, -1>, <4, 7.45, 1> }
                //cylinder { <0, 3.5, 0>, <0, 3.5, -2>, 2 }
                superellipsoid { <1, 0.85> scale <3, 3, 1>
                        translate <0, 3.5, -2> }
                }
        sphere { <0, -4, -1.25>, 0.5 }
        sphere { <0, 3.5, -5>, 4 }
        texture { pigment { color White*0.65 } finish { ambient 0.5 }}
}
#declare DishPlate = difference
{
        union
                {
                box { <-4, 0.05, -1>, <4, 7.45, 1> }
                //cylinder { <0, 3.5, 0>, <0, 3.5, -2>, 2 }
                superellipsoid { <1, 0.85> scale <3, 3, 1>
                        translate <0, 3.5, -2> }
                }
        sphere { <0, 3.5, -5>, 4 }
        texture { pigment { color White*0.65 } finish { ambient 0.5 }}
        translate y*-3.75
}

#declare DipPlate = difference
{
        box { <-4, -7.45, -1>, <4, 0.05, 1> }
        sphere { <0, -4, -1.25>, 0.5 }
        texture { pigment { color White*0.65 } finish { ambient 0.5 }}
        translate y*3.75
}
#declare Pillar1 = union                //right
{
        object { BumpPlate translate y*45 }
        object { BumpPlate translate y*30 }
        object { BumpPlate translate y*15 }
        object { DipPlate translate y*3.75 }

        object { BumpPlate translate y*-7.5 }
        object { DishPlate translate y*-18.75 }
        object { BumpPlate translate y*-30 }
        object { BumpPlate translate y*-45 }
}
#declare Pillar2 = union                //left (right)
{
        object { BumpPlate translate y*45 }
        object { BumpPlate translate y*30 }
        object { BumpPlate rotate z*180 translate y*15 }
        object { DipPlate translate y*3.75 }

        object { BumpPlate rotate z*180 translate y*-7.5 }
        object { DishPlate translate y*-18.75 }
        object { BumpPlate translate y*-30 }
        object { BumpPlate translate y*-45 }
}
#declare Pillar3 = union                //left (right)
{
        object { DipPlate translate y*48.75 }
        object { BumpPlate rotate z*180 translate y*37.5 }
        object { BumpPlate rotate z*180 translate y*22.5 }
        object { DipPlate translate y*11.25 }

        object { BumpPlate }
        object { BumpPlate rotate z*180 translate y*-15 }
        object { BumpPlate translate y*-30 }
        object { BumpPlate translate y*-45 }
}

#declare Conduit1 = union {
        cylinder { <-6, 0, 0>, <6, 0, 0>, 0.5 }
        difference
                {
                torus { 1, 0.5
                        rotate x*-90 }
                plane { x*-1, 0 hollow }
                plane { y*1, 0 hollow }
                translate <-6, -1, 0>
                }
        difference
                {
                torus { 1, 0.5
                        rotate x*-90 }
                plane { x*1, 0 hollow }
                plane { y*1, 0 hollow }
                translate <6, -1, 0>
                }
        texture { Metal2 }
}

#declare Conduit2 = union {
        cylinder { <-15, 0, 0>, <15, 0, 0>, 1 }
        difference
                {
                torus { 1, 1 rotate x*-90 }
                plane { x*-1, 0 hollow }
                plane { y*1, 0 hollow }
                translate <-15, -1, 0>
                }
        difference
                {
                torus { 1, 1 rotate x*-90 }
                plane { x*1, 0 hollow }
                plane { y*1, 0 hollow }
                translate <15, -1, 0>
                }
        texture { Metal2 }
}

#declare Pipes = union {
        #declare Loop = -3
        #while (Loop < 4)
        object { Conduit1 rotate z*-90 translate <-2.5, Loop*14, 0> }
        #declare Loop = Loop + 1
        #end

        object { Conduit2 rotate x*-90 rotate z*-90
                translate <2.5, -30, 0> }
        object { Conduit2 rotate x*-90 rotate z*-90
                translate <2.5, 30, 0> }
}

#declare PanelSet1 = union {
        object { Pipes
                rotate y*-degrees(atan2(8/PanelRadius, 1))
                translate <PanelRadius*sin(atan2(8/PanelRadius, 1)), 0,
                        -PanelRadius*cos(atan2(8/PanelRadius, 1)) + PanelRadius>  }
        object { Pillar2
                rotate y*degrees(atan2(8/PanelRadius, 1))
                translate <-PanelRadius*sin(atan2(8/PanelRadius, 1)), 0,
                        -PanelRadius*cos(atan2(8/PanelRadius, 1)) + PanelRadius>  }
	object { Pillar1 }
}

#declare PanelSet2 = union {
        object { Pillar2
                rotate y*-degrees(atan2(8/PanelRadius, 1))
                translate <PanelRadius*sin(atan2(8/PanelRadius, 1)), 0,
                        -PanelRadius*cos(atan2(8/PanelRadius, 1)) + PanelRadius>  }
        object { Pipes rotate z*180
                rotate y*degrees(atan2(8/PanelRadius, 1))
                translate <-PanelRadius*sin(atan2(8/PanelRadius, 1)), 0,
                        -PanelRadius*cos(atan2(8/PanelRadius, 1)) + PanelRadius>  }
	object { Pillar3 }
}

#declare PanelSet3 = union {
        object { Pillar1
                rotate y*-degrees(atan2(8/PanelRadius, 1))
                translate <PanelRadius*sin(atan2(8/PanelRadius, 1)), 0,
                        -PanelRadius*cos(atan2(8/PanelRadius, 1)) + PanelRadius>  }
        object { Pipes rotate z*180
                rotate y*degrees(atan2(8/PanelRadius, 1))
                translate <-PanelRadius*sin(atan2(8/PanelRadius, 1)), 0,
                        -PanelRadius*cos(atan2(8/PanelRadius, 1)) + PanelRadius>  }
	object { Pillar3 }
}

#declare Block = union {
object { PanelSet1 scale <0.4, 0.4, 0.4> translate <0, 0, -PanelRadius>
                rotate y*-22.5 }
object { PanelSet3 scale <0.4, 0.4, 0.4> translate <0, 0, -PanelRadius>
                rotate y*22.5 }
object { PanelSet2 scale <0.4, 0.4, 0.4> translate <0, 0, -PanelRadius> }
}

#declare Jacket = union { 
	object { Block }
	object { Block rotate y*72 }
	object { Block rotate y*-72 }

	object { Block rotate y*144 }
	object { Block rotate y*-144 }
}

#declare HighPanel1 =
        box { <-4, -2.5, -0.5>, <4, 2.5, 0.5> }

#declare HighPanel2 = union
{
        box { <-4, -2.5, -0.5>, <4, 2.5, 0.5>
                rotate x*45
                translate <-4.1, 5, 2> }
        box { <-4, -2.5, -0.5>, <4, 2.5, 0.5>
                rotate x*45
                translate <4.1, 5, 2> }
}

#declare HighPanels = union {
        object { HighPanel1
                translate z*-HiPanelRadius
                rotate y*degrees(atan2(4.1/HiPanelRadius, 1))
                }
        object { HighPanel2 translate z*-HiPanelRadius }
        object { HighPanel1
                translate z*-HiPanelRadius
                rotate y*-degrees(atan2(4.1/HiPanelRadius, 1))
                }
        translate z*HiPanelRadius
}

#declare HighPanelsSet = union
{
        #declare Loop = 0
        #while (Loop < 8)
        object { HighPanels
                scale <0.5, 0.6, 0.5>
                translate z*-HiPanelRadius
                rotate y*(Loop*45 + 22.5)
                texture { Metal1 } }
        #declare Loop = Loop + 1
        #end
	translate y*97.6
}

#declare LowRing = 	// Higher part of bottom ring set on core
        cylinder { <0, 5, 0>, <0, -5, 0>, RingRadius
		translate y*35
                texture { Metal1 } }

#declare Support = difference {
        union {
                cylinder { <-8, 0, 0>, <8, 0, 0>, 2 }
                box { <-6, -4, -2.25>, <6, 4, 2.25> }
        }
        difference {
                cylinder { <7.8, 0, 0>, <8.2, 0, 0>, 1.85 }
                cylinder { <7.75, 0, 0>, <8.25, 0, 0>, 1.4 }
                }
        cylinder { <7.8, 0, 0>, <8.2, 0, 0>, 0.1 }
        difference {
                cylinder { <-7.8, 0, 0>, <-8.2, 0, 0>, 1.85 }
                cylinder { <-7.75, 0, 0>, <-8.25, 0, 0>, 1.4 }
                }
        cylinder { <-7.8, 0, 0>, <-8.2, 0, 0>, 0.1 }
        texture { ShinyMetal }
}

#declare SupportSet = union
{
	#declare Loop = 0
	#while (Loop < 8)
	object { Support
			scale <0.85, 0.5, 0.5>
			translate <0, 34, -SupportRadius>
			rotate y*(Loop*45)
		}
	#declare Loop = Loop + 1
	#end
}

#declare Bolt =
union {
        difference {
                cylinder { <0, 0, 0>, <0, 0, -1>, 2 }
                #declare Loop2 = 0
                #while (Loop2 < 8)
                plane { y*1, -1 rotate z*(Loop2*45) hollow }
                #declare Loop2 = Loop2 + 1
                #end
                }
        sphere { <0, 0, -1>, 0.75 }
        texture { ShinyMetal }
}

#declare BoltRing =
union {
        #declare Loop = 0
        #while (Loop < 8)
        object { Bolt rotate z*(90*rand(S1))
		scale 0.75
                translate z*-BoltRadius1
                rotate y*(Loop*45 + 22.5)
                }
        #declare Loop = Loop + 1
        #end
}

#declare BoltRing2 =
union {
        #declare Loop = 0
        #while (Loop < 8)
        object { Bolt rotate z*(90*rand(S1))
                scale 0.75
                translate z*-BoltRadius2
                rotate y*(Loop*45 + 22.5)
                }
        #declare Loop = Loop + 1
        #end
}

#declare UpperCone = cone { <0, 103, 0>, RingRadius,
				<0, 140, 0>, HighConeEnd
			texture { Metal2 } }

#declare MiniPlate =
        box { <-1.5, -0.5, -1.5>, <1.5, 0.5, 1.5> }

#declare PlateMesh =
difference
        {
        union
                {
                #declare Loop2 = 0
                #while (Loop2 < 8)
                object { MiniPlate
                        translate y*MiniPlateMinorRadius
                        rotate z*-degrees(atan2(3.3/MiniPlateMinorRadius, 1)*(Loop2-3))
                        translate y*-MiniPlateMinorRadius }
                #declare Loop2 = Loop2 + 1
                #end
                translate x*MiniPlateMajorRadius
                }
        plane { z*1, 0 rotate y*2.5 hollow }
        plane { z*-1, 0 rotate y*-2.5 hollow }
        //translate x*-MiniPlateMajorRadius
        texture { Metal2 }
        }

#declare TopCurve = union {
        #declare Loop = 0
        #while (Loop < 72)
        object { PlateMesh translate x*MiniPlateMajorRadius/10
                        rotate y*(Loop*5) }
        #declare Loop = Loop + 1
        #end
}

#declare TPlateRadius = 4.75/tan(radians(30))

#declare TexturePlate1 = difference
{
	union {
		box { <-0.5, -3.5, -0.1>, <0.5, 3.5, 0.1> }
		superellipsoid { <1, 0.4> scale <1/5, 1/5, 1/9>
			translate <0.1, 1.5, 0> }
		superellipsoid { <1, 0.4> scale <1/5, 1/5, 1/9>
			translate <0.25, -0.75, 0> }
		superellipsoid { <1, 0.4> scale <1/5, 1/5, 1/9>
			translate <0, -3, 0> }
		superellipsoid { <1, 0.4> scale <1/5, 1/5, 1/9>
			translate <-0.2, 2.5, 0> }
		superellipsoid { <1, 0.4> scale <1/4, 1/4, 1/9>
			translate <0.25, -2, 0> }
		}

	cylinder { <0.1, 1.2, -0.05>, <0.1, 1.2, -1>, 0.05 }
	cylinder { <0.25, -1.25, -0.05>, <0.25, -1.25, -1>, 0.05 }
	cylinder { <0, -2.25, -0.05>, <0, -2.25, -1>, 0.05 }
	texture {
		pigment {
			gradient y
			color_map {
				[0 color LightSteelBlue ]
				[0.38 color LightSteelBlue ]
				[0.4 color P_Silver2 ]
				[0.48 color P_Silver2 ]
				[0.5 color White*0.1 ]
				[0.52 color P_Silver2 ]
				[0.6 color P_Silver2 ]
				[0.62 color LightSteelBlue ]
				[1 color LightSteelBlue ]
				}
			}
		finish {
			ambient.1
			diffuse.4
			specular 1
			roughness 0.001
			reflection.5
			metallic
			}
		translate y*-0.5
		scale 7
		}
}

#declare Conduit3 =
        union {
                cylinder { <-0.25, -1.2, 0>, <-0.25, -2, 0>, 0.0625 }
                difference {
                        torus { 0.1, 0.0625 rotate z*90 }
                        plane { y*1, 0 hollow }
                        plane { z*-1, 0 hollow }
                        translate <-0.25, -1.2, 0.1>
                        }
                difference {
                        torus { 0.1, 0.0625 rotate z*90 }
                        plane { y*-1, 0 hollow }
                        plane { z*-1, 0 hollow }
                        translate <-0.25, -1.99, 0.1>
                        }
                texture { Metal2 }
                }

#declare Conduit4 =
        union {
                cylinder { <-0.25, -1.2, 0>, <-0.25, -2, 0>, 0.0625 }
                difference {
                        torus { 0.1, 0.0625 rotate z*90 }
                        plane { y*1, 0 hollow }
                        plane { z*-1, 0 hollow }
                        translate <-0.25, -1.2, 0.1>
                        }
                difference {
                        torus { 0.1, 0.0625 rotate x*90 }
                        plane { y*-1, 0 hollow }
                        plane { x*-1, 0 hollow }
			translate <-0.15, -1.99, 0>
                        }
		cylinder { <-0.15, -1.99-0.1, 0>, <-0.05, -1.99-0.1, 0>, 0.0625 }
                difference {
                        torus { 0.1, 0.0625 }
                        plane { x*1, 0 hollow }
                        plane { z*-1, 0 hollow }
                        translate <-0.05, -1.99-0.1, 0.1>
                        }
                texture { Metal2 }
                }



#declare TexturePlate2 = union
{
	difference
		{
		object { TexturePlate1 }
		plane { y*1, -1 texture { Metal2 } hollow }
		}
	object { Conduit3 }
	object { Conduit4 translate y*-1.2 }
	box { <-0.075, -2.9, -0.065>, <0.25, -3.2, 0.065>
		texture { Metal2 }
		}
	difference {
		torus { 0.1, 0.0625 rotate z*90 }
		plane { y*-1, 0 hollow }
		plane { z*-1, 0 hollow }
		translate <0.19, -3.2, 0.1>
		texture { Metal2 }
		}
	box { <-0.14, -1.2, 0.0625>, <0.4, -1.4, -0.0625> texture { Metal2 } }
	box { <0.2, -1.2, 0.0625>, <0.4, -2, -0.0625> texture { Metal2 } }
	cylinder { <0.05, -2.25, -0.0625>, <0.05, -2.25, 0.0625>, 0.1
		texture { Metal2 } }
	difference {
		torus { 0.15, 0.05 translate y*-1.6 }
		plane { z*-1, 0 hollow }
		texture { Metal2 }
		}
}

#declare TexturePlate3 = union
{
        difference
                {
                object { TexturePlate1 rotate z*180 }
                plane { y*1, -1 texture { Metal2 } hollow }
                }
        object { Conduit3 }
        object { Conduit4 translate y*-1.2 }
        box { <-0.075, -2.9, -0.065>, <0.25, -3.2, 0.065>
                texture { Metal2 }
                }
        difference {
                torus { 0.1, 0.0625 rotate z*90 }
                plane { y*-1, 0 hollow }
                plane { z*-1, 0 hollow }
                translate <0.19, -3.2, 0.1>
                texture { Metal2 }
                }
        box { <-0.14, -1.2, 0.0625>, <0.4, -1.4, -0.0625> texture { Metal2 } }
        box { <0.2, -1.2, 0.0625>, <0.4, -2, -0.0625> texture { Metal2 } }
        cylinder { <0.05, -2.25, -0.0625>, <0.05, -2.25, 0.0625>, 0.1
                texture { Metal2 } }
	difference {
		torus { 0.15, 0.05 translate y*-1.6 }
		plane { z*-1, 0 hollow }
		texture { Metal2 }
		}
}

#declare UpperTexture = union
{
   object { TexturePlate2 rotate x*-20
		translate z*-TPlateRadius
		rotate y*degrees(atan2(0.55/TPlateRadius, 1))
		}
   object { TexturePlate1 rotate x*-20
		translate z*-TPlateRadius
		rotate y*degrees(atan2(1.65/TPlateRadius, 1))
		}
   object { TexturePlate1 rotate z*180 rotate x*-20
		translate z*-TPlateRadius
		rotate y*-degrees(atan2(0.55/TPlateRadius, 1))
		}
   object { TexturePlate3 rotate x*-20
		translate z*-TPlateRadius
		rotate y*-degrees(atan2(1.65/TPlateRadius, 1))
		}
}

#declare UpperTextureSet = union
{
	#declare Loop = 0
	#while (Loop < 12)
	object { UpperTexture
		rotate y*30*Loop
		}
	#declare Loop = Loop + 1
	#end
	//scale 3.6
	scale <3.9, 4.2, 3.9>
	translate <0, 118, 0>
}

#declare ShieldRadius = 13

#declare Belt = difference
{
	cylinder { <0, -0.5, 0>, <0, 0.5, 0>, 1 scale <5, 1, 1> }
	cylinder { <0, -1, 0>, <0, 1, 0>, 0.85 scale <5.5, 1, 1> }
	plane { z*-1, 0 hollow }
}

#declare Belt2 = difference
{ 
	cylinder { <0, -1.5, 0>, <0, 0.5, 0>, 1 scale <5, 1, 1> }
	cylinder { <0, -2, 0>, <0, 2, 0>, 0.85 scale <5.5, 1, 1> }
	plane { z*-1, 0 hollow }
	box { <-4.25, -2, -3>, <6, -0.5, 3> }
	sphere { <-4.7, -0.7, -0.45>, 0.125 }
	sphere { <-4.7, -1.15, -0.45>, 0.125 }
}

#declare Belt3 = difference
{

        cylinder { <0, -1.5, 0>, <0, 0.5, 0>, 1 scale <5, 1, 1> }
        cylinder { <0, -2, 0>, <0, 2, 0>, 0.85 scale <5.5, 1, 1> }
        plane { z*-1, 0 hollow }
	plane { x*1, -4.15 hollow }
        box { <-3.4, -2, -3>, <6, -0.5, 3> }
	sphere { <-3.85, -0.7, -0.75>, 0.125 }
	sphere { <-3.85, -1.15, -0.75>, 0.125 }
}

#declare Bracket = union
{
	object { Bolt scale 0.1 translate y*0.35 }
	object { Bolt scale 0.1 translate y*-0.35 }
}

#declare Belt4 = difference
{
        cylinder { <0, -1.5, 0>, <0, 0.5, 0>, 1 scale <5, 1, 1> }
        cylinder { <0, -2, 0>, <0, 2, 0>, 0.85 scale <5.5, 1, 1> }
        plane { z*-1, 0 hollow }
        box { <-6, -2, -3>, <4.25, -0.5, 3> }
	sphere { <4.7, -0.7, -0.45>, 0.125 }
	sphere { <4.7, -1.15, -0.45>, 0.125 }
}

#declare Belt5 = difference
{

        cylinder { <0, -1.5, 0>, <0, 0.5, 0>, 1 scale <5, 1, 1> }
        cylinder { <0, -2, 0>, <0, 2, 0>, 0.85 scale <5.5, 1, 1> }
        plane { z*-1, 0 hollow }
        plane { x*-1, -4.15 hollow }
        box { <-6, -2, -3>, <3.4, -0.5, 3> }
	sphere { <3.85, -0.7, -0.75>, 0.125 }
	sphere { <3.85, -1.15, -0.75>, 0.125 }
}


#declare Shield1 = union
{
	object { Belt }
	object { Belt translate y*1.2 }
	object { Belt translate y*-1.2 }

	object { Bracket rotate y*-20 translate <4.75, 1.2, -0.2> }
	object { Bracket rotate y*-20 translate x*4.75 }
	object { Bracket rotate y*-20 translate <4.75, -1.2, -0.2> }

	texture { ShinyMetal }
}

#declare Shield2 = union
{
	object { Belt2 translate y*1.2 }
	object { Belt3 }
	difference {
		object { Belt translate y*-1.2 }
		plane { x*1, -3.3 hollow }
		}
	object { Bracket rotate y*-45 translate <4.75, 1.2, -0.2> }
	object { Bracket rotate y*-45 translate <4.75, 0, -0.2> }
	object { Bracket rotate y*-45 translate <4.75, -1.2, -0.2> }

	texture { ShinyMetal }
}

#declare Shield3 = union
{
        object { Belt4 translate y*1.2 }
        object { Belt5 }
        difference {
                object { Belt translate y*-1.2 }
                plane { x*-1, -3.3 hollow }
                }
        object { Bracket rotate y*-45 translate <-4.75, 1.2, -0.2> }
        object { Bracket rotate y*-45 translate <-4.75, 0, -0.2> }
        object { Bracket rotate y*-45 translate <-4.75, -1.2, -0.2> }

        texture { ShinyMetal }
}

#declare LowerShields =
union {
	object { Shield2 translate z*-ShieldRadius }
	object { Shield3 translate z*-ShieldRadius rotate y*45 }
	object { Shield1 translate z*-ShieldRadius rotate y*-45 }
	object { Shield2 rotate y*180 translate z*ShieldRadius }
	object { Shield3 rotate y*180 translate z*ShieldRadius rotate y*45 }
	object { Shield1 rotate y*180 translate z*ShieldRadius rotate y*-45 }
	object { Shield1 translate z*-ShieldRadius rotate y*-90 }
	object { Shield1 translate z*-ShieldRadius rotate y*90 }
}

#declare InnerShieldBands = union {
difference {
	cylinder { <0, -0.85, 0>, <0, -1.6, 0>, ShieldRadius texture { ShinyMetal } }
	cylinder { <0, -0.84, 0>, <0, -1.7, 0>, ShieldRadius-0.25 texture { ShinyMetal } }
	}

difference {
	cylinder { <0, -0.3, 0>, <0, 0.45, 0>, ShieldRadius texture { ShinyMetal } }
	cylinder { <0, -0.4, 0>, <0, 0.5, 0>, ShieldRadius-0.25 texture { ShinyMetal } }
	}

difference {
	cylinder { <0, 0.75, 0>, <0, 1.5, 0>, ShieldRadius texture { ShinyMetal } }
	cylinder { <0, 0.7, 0>, <0, 1.6, 0>, ShieldRadius-0.25 texture { ShinyMetal } } 
	}
}

#declare BottomPlate = box { <-0.5, -0.25, -0.1>, <0.5, 0.25, 0.1>
	texture { BrickTexture } }

#declare BottomPlateRow =
union {
	object { BottomPlate scale <1.05, 1, 1> }
	object { BottomPlate rotate x*45 translate <0, 0.49, 0.225> }
	object { BottomPlate scale <0.9, 1, 1>
		rotate x*90 translate <0, 0.7, 0.7> }
}

#declare BottomPlates =
	union {
		#declare Loop = 0
		#while (Loop < 32)
		object { BottomPlateRow translate z*-BottomPlateRowRadius
			rotate y*(Loop*11.25)
			}
		#declare Loop = Loop + 1
		#end
		}

#declare NotchBrick = difference
{
	box { <-6, -4, -0.25>, <6, 4, 0.25>
		texture { ShinyMetal }	 }
	box { <-1, 1, -0.5>, <1, -4.5, 0.5> texture { ShinyMetal } }
}

#declare NotchPlate =
union {
	object { NotchBrick
		rotate x*-90 translate z*4 }

	object { NotchBrick
		rotate x*60 translate <0, -2, -3.35>
		}
	scale <1, 0.5, 0.5>
	}

#declare NotchPlateSet =
union {
	#declare Loop = 0
	#while (Loop < 36)
	object { NotchPlate
		translate z*NotchPlateRadius
		rotate y*Loop*10 }
	#declare Loop = Loop + 1
	#end
}

#declare Thingie = box { <-1, -3, -0.1>, <1, 3, 0.1> texture { BrickTexture } }

#declare Thingies = union {
	#declare Loop = 0
	#while (Loop < 36)
	object { Thingie scale <2.5, 1.25, 2.5> translate z*-BottomRadius rotate y*10*Loop }
	#declare Loop = Loop + 1
	#end
}

#declare OuterRings = 
union {
        difference {
                cone { <0, -0.5, 0>, OuterRRadius
                        <0, 0.5, 0>, OuterRRadius + 1}
                cone { <0, -0.51, 0>, OuterRRadius - 0.5
                        <0, 0.51, 0>, OuterRRadius + 0.5 }
        }
        difference {
                cone { <0, 0.75, 0>, OuterRRadius + 1.25
                        <0, 1.75, 0>, OuterRRadius + 2.25 }
                cone { <0, 0.74, 0>, OuterRRadius + 0.75
                        <0, 1.76, 0>, OuterRRadius + 1.75 }
        }
        difference {
                cone { <0, 2, 0>, OuterRRadius + 2.5
                        <0, 3, 0>, OuterRRadius + 3.5 }
                cone { <0, 1.99, 0>, OuterRRadius + 2
                        <0, 3.01, 0>, OuterRRadius + 3 }
        }
	texture { ShinyMetal }
}

#declare ORingPlates = union {
	#declare Loop = 0
	#while (Loop < 32)
	object { WidePlates scale <1, 0.5, 1>
			rotate x*45 scale <0.25, 0.5, 0.25>
			translate z*OuterRRadius + 0.75
			rotate y*(Loop*11.25) }
	#declare Loop = Loop + 1
	#end
}

#declare OuterPlateRings = union
{
object { OuterRings scale <1, 2, 1> }
object { ORingPlates translate y*1 }
}

#declare LongPipe = union
{
	cylinder { <-6, 0, 0>, <6, 0, 0>, 1 }
	cylinder { <4, 0, 0>, <6, 0, 0>, 1.2 }
	box { <-6.1, -1.25, -1.25>, <-6, 1.25, 1.25> }
	box { <6.1, -1.25, -1.25>, <6, 1.25, 1.25> }
	texture { ShinyMetal }
}

#declare PipeStrip = union {
#declare Loop = 0
#declare Offset = 0
#while (Loop < 45)
object { LongPipe translate z*(OutsideRadius+Offset) rotate x*(Loop-22)*1.25 }
#declare Loop = Loop + 1
	#if (Offset = 0)
		#declare Offset = 1
	#else
		#declare Offset = 0
	#end
#end
translate z*-OutsideRadius
}

#declare PipeStrips = union
{
   object { PipeStrip translate z*OutsideRadius rotate y*-5 }
   object { PipeStrip translate z*OutsideRadius rotate y*5 }
}

#declare PipeStripSet = union
{
  object { PipeStrips rotate y*30 }
  object { PipeStrips rotate y*90 }
  object { PipeStrips rotate y*150 }
  object { PipeStrips rotate y*-30 }
  object { PipeStrips rotate y*-90 }
  object { PipeStrips rotate y*-150 }
}

#declare BackRing =
difference {
        cone {
                <0, 10, 0>, 80
                <0, 0, 0>, 90
		texture { BackMetal2 }
		}
        cone { <0, 10.01, 0>, 79
                <0, -0.01, 0>, 89
		texture { BackMetal2 }
		}
}

#declare BackRing2 =
difference {
        cone {
                <0, 10, 0>, 85
                <0, 0, 0>, 95 
         texture { BackMetal2 }
         }
        cone { <0, 10.01, 0>, 84
                <0, -0.01, 0>, 94
         texture { BackMetal2 }
         }
}

#declare BackRing3 =
difference {
        cone {
                <0, 10, 0>, 92
                <0, 0, 0>, 102 
         texture { BackMetal2 }
         }
        cone { <0, 10.01, 0>, 91
                <0, -0.01, 0>, 101 
         texture { BackMetal2 }
         }
}

#declare BackRing4 =
difference {
	cylinder { <0, 37, 0>, <0, 95, 0>, 101
         texture { BackMetal2 } }
	cylinder { <0, 36, 0>, <0, 96, 0>, 100
         texture { BackMetal2 } }
}
