#include "colors.inc"
//#include "metals.inc"
//#include "woods.inc"

camera {
    location <0,5,5>
    look_at <-15,10,15>
}


#declare rad2 = sqrt(2)

#default {
      finish  {ambient Black}
}
//light_source {<100,300,-200> rgb<1,1,1>}

light_source {<-15,11,20> rgb<1,1,0>
    fade_distance 5
    fade_power 2
}
light_source {<-15,12,19> rgb<1,0,0>
    fade_distance 5
    fade_power 2
}
light_source {<-15,10,21> rgb<1,.1,0>
    fade_distance 5
    fade_power 2
}
light_source {<-15,17,8> rgb<.3,.3,.3>
    fade_distance 5
    fade_power 2
}
light_source {<-15,2,15> rgb<.4,.1,.1>
    fade_distance 3
    fade_power 2
}
/*light_source {<-29,13.9,15>
    rgb<1,1,.8>
    spotlight
    point_at <-30,5,15>
    radius 30
    falloff 40
    tightness 10
}
light_source {<-29,13.9,10>
    rgb<1,1,.8>
    spotlight
    point_at <-30,5,10>
    radius 30
    falloff 40
    tightness 10
}
light_source {<-29,13.9,5>
    rgb<1,1,.8>
    spotlight
    point_at <-30,5,5>
    radius 30
    falloff 40
    tightness 10
}*/
light_source {<-99,49,25>
    rgb<1,1,.8>
    spotlight
    point_at <-100,40,25>
    radius 30
    falloff 40
    tightness 10
}
light_source {<-99,49,15>
    rgb<1,1,.8>
    spotlight
    point_at <-100,40,15>
    radius 30
    falloff 40
    tightness 10
}
light_source {<-99,49,5>
    rgb<1,1,.8>
    spotlight
    point_at <-100,40,5>
    radius 30
    falloff 40
    tightness 10
}

// molten iron
intersection {
    torus {3,1}
    box {<0,2,0>,<6,-2,6>}

    rotate z*90
    scale y*2
    translate <-15,8,18>
    pigment {color Yellow}
    finish {ambient 1}
    no_shadow
}



// floor
box {<-100,0,-100>,<100,-1,100>
    pigment {color White}
    normal { bumps .5 scale .05 }
}

// ceiling
box {<-100,50,-100>,<100,51,100>
    pigment {color White}
    normal { bumps .5 scale .05 }
    no_shadow
}

// boxes that hold the furnace
box {<-30,0,30>,<-20,10,21> pigment {color White}}
box {<-10,0,30>,<0,10,21> pigment {color White}}

// Wall 1
box {<-100,0,30>,<100,50,31>
    texture {
        pigment { brick Gray75, rgb<.8,.2,.2> scale .25 }
        normal { bumps .5 scale .05 }
    }
//    pigment {color White}
}
box {<-100,0,30>,<-101,50,-100>
    texture {
        pigment { brick Gray75, rgb<.8,.2,.2> scale .25 }
        normal { bumps .5 scale .05 }
    }
//    pigment {color White}
}
box {<-100,0,29.95>,<100,50,29.99>
    pigment {
        bumps
        pigment_map {
            [0 rgbt<0,0,0,1>]
            [.5 rgbt<0,0,0,1>]
            [1 rgbt<0,0,0,.8>]
        }
    }
}

// first set of pipes
union {
    cylinder {<-15,13,29.5>,<10,13,29.5>,.5}
    intersection {torus {1,.5} box {<0,1,0>,<-2,-1,-2>} rotate -x*90 translate <-15,14,29.5>}
    cylinder {<-16,14,29.5>,<-16,50,29.5>,.5}

    cylinder {<-14,14,29.5>,<10,14,29.5>,.5}
    intersection {torus {1,.5} box {<0,1,0>,<-2,-1,-2>} rotate -x*90 translate <-14,15,29.5>}
    cylinder {<-15,15,29.5>,<-15,50,29.5>,.5}

    cylinder {<-13,15,29.5>,<10,15,29.5>,.5}
    intersection {torus {1,.5} box {<0,1,0>,<-2,-1,-2>} rotate -x*90 translate <-13,16,29.5>}
    cylinder {<-14,16,29.5>,<-14,50,29.5>,.5}

    cylinder {<-12,16,29.5>,<10,16,29.5>,.5}
    intersection {torus {1,.5} box {<0,1,0>,<-2,-1,-2>} rotate -x*90 translate <-12,17,29.5>}
    cylinder {<-13,17,29.5>,<-13,50,29.5>,.5}

    cylinder {<-11,17,29.5>,<10,17,29.5>,.5}
    intersection {torus {1,.5} box {<0,1,0>,<-2,-1,-2>} rotate -x*90 translate <-11,18,29.5>}
    cylinder {<-12,18,29.5>,<-12,50,29.5>,.5}

    pigment {color White}
}

// Second set of pipes
union {
    cylinder {<-27,-10,29.8>,<-27,25,29.8>,.2}
    intersection {torus {.4,.2} box {<0,1,0>,<2,-1,2>} rotate -x*90 translate <-27.4,25,29.8>}
    cylinder {<-100,25.4,29.8>,<-27.4,25.4,29.8>,.2}

    cylinder {<-27.4,-10,29.8>,<-27.4,24.6,29.8>,.2}
    intersection {torus {.4,.2} box {<0,1,0>,<2,-1,2>} rotate -x*90 translate <-27.8,24.6,29.8>}
    cylinder {<-100,25,29.8>,<-27.8,25,29.8>,.2}

    cylinder {<-27.8,-10,29.8>,<-27.8,24.2,29.8>,.2}
    intersection {torus {.4,.2} box {<0,1,0>,<2,-1,2>} rotate -x*90 translate <-28.2,24.2,29.8>}
    cylinder {<-100,24.6,29.8>,<-28.2,24.6,29.8>,.2}

    translate y*20
    pigment {color White}
}

// Safety sign
box {<-22,21,29.9>,<-18,15,29.94>
    pigment {
        image_map {
            gif "bessemer_burn1.gif"
            transmit 226,1
        }
        scale <4.05,6.05,1>
        translate <-22,15,0>
    }
}

// Wall 2
difference {
    box {<-30,0,-100>,<-100,15,30>}
    box {<-34,0,20>,<-29,16,16>}
    texture {
        pigment { brick Gray75, rgb<.8,.2,.2> scale .25 }
        normal { bumps .5 scale .05 }
    }
//    pigment {color White}
}
box {<-29.95,0,-100>,<-29.99,15,16>
    pigment {
        bumps
        pigment_map {
            [0 rgbt<0,0,0,1>]
            [.5 rgbt<0,0,0,1>]
            [1 rgbt<0,0,0,.8>]
        }
    }
}
box {<-29.95,0,20>,<-29.99,15,30>
    pigment {
        bumps
        pigment_map {
            [0 rgbt<0,0,0,1>]
            [.5 rgbt<0,0,0,1>]
            [1 rgbt<0,0,0,.8>]
        }
    }
}

box {<-29.94,9.5,7>,<-29.9,13.5,9>
    pigment {
        image_map {
            gif "bessemer_calendar.gif"
        }
        rotate -y*90
        scale <1,4.05,2.05>
        translate <0,9.5,7>
    }
}

// Big Pipe
union {
    torus {2,2 translate <-30,2,14>}
    cylinder {<-28,2,14>,<-28,2,-10>,2}
    cylinder {<-28,2,14>,<-28,2,13.5>,2.7}
    pigment {rgb <.7,.4,.1>}
}

// I Beam
union {
    box {<-30,15,16>,<-29,14.8,-10>}
    box {<-29.4,15,16>,<-29.6,14,-10>}
    box {<-30,14,16>,<-29,14.2,-10>}

    box {<-30,15,20>,<-29,14.8,30>}
    box {<-29.4,15,20>,<-29.6,14,30>}
    box {<-30,14,20>,<-29,14.2,30>}

    pigment {color Brown}
}

// Elevator
union {
    cylinder {<-30.5,0,19.5>,<-30.5,15,19.5>,.5}
    cylinder {<-30.5,0,16.5>,<-30.5,15,16.5>,.5}
    cylinder {<-33.5,0,19.5>,<-33.5,15,19.5>,.5}
    cylinder {<-33.5,0,16.5>,<-33.5,15,16.5>,.5}

    pigment {color White}
}

// Hand rail
union {
    cylinder {<-30,19,-30>,<-30,19,16>,.3}
    cylinder {<-30,17,-30>,<-30,17,16>,.3}
    cylinder {<-30,19,10>,<-30,15,10>,.3}
    cylinder {<-30,19,5>,<-30,15,5>,.3}
    pigment {color White}
}

// Fuse Box
union {
    box {<-30,6,12>,<-29,8,13>}
    box {<-29,6.3,12.3>,<-28.8,7.7,12.7>}
    cylinder {<-29,6.3,12.3>,<-29,7.7,12.3>,.2}
    cylinder {<-29,6.3,12.3>,<-29,6.3,12.7>,.2}
    cylinder {<-29,7.7,12.7>,<-29,7.7,12.3>,.2}
    cylinder {<-29,7.7,12.7>,<-29,6.3,12.7>,.2}
    sphere {<-29,6.3,12.7>,.2}
    sphere {<-29,6.3,12.3>,.2}
    sphere {<-29,7.7,12.7>,.2}
    sphere {<-29,7.7,12.3>,.2}
    cylinder {<-29.5,7,12>,<-29.5,7,11.5>,.1}
    cylinder {<-29.5,8,11.5>,<-29.5,7,11.5>,.1}
    sphere {<-29.5,7,11.5>,.1}
    sphere {<-29.5,8,11.5>,.2}
    pigment {color White}
}
cylinder {<-29.9,6,12.1>,<-29.9,15,12.1>,.1 pigment {color Red}}
cylinder {<-29.9,6,12.3>,<-29.9,15,12.3>,.1 pigment {color Blue}}
cylinder {<-29.9,6,12.5>,<-29.9,15,12.5>,.1 pigment {color Green}}
cylinder {<-29.9,6,12.7>,<-29.9,15,12.7>,.1 pigment {color Violet}}
cylinder {<-29.9,6,12.9>,<-29.9,15,12.9>,.1 pigment {color Orange}}

// vent
union {
    difference {
        box {<-30,7,10>,<-29.8,9,5.8>}
        box {<-30,7.2,9.8>,<-29,8.8,9.6>}
        box {<-30,7.2,9.4>,<-29,8.8,9.2>}
        box {<-30,7.2,9.0>,<-29,8.8,8.8>}
        box {<-30,7.2,8.6>,<-29,8.8,8.4>}
        box {<-30,7.2,8.2>,<-29,8.8,8.0>}
        box {<-30,7.2,7.8>,<-29,8.8,7.6>}
        box {<-30,7.2,7.4>,<-29,8.8,7.2>}
        box {<-30,7.2,7.0>,<-29,8.8,6.8>}
        box {<-30,7.2,6.6>,<-29,8.8,6.4>}
        box {<-30,7.2,6.2>,<-29,8.8,6.0>}
    }
    cylinder {<-30,7,10>,<-30,9,10>,.2}
    cylinder {<-30,7,5.8>,<-30,9,5.8>,.2}
    cylinder {<-30,7,10>,<-30,7,5.8>,.2}
    cylinder {<-30,9,10>,<-30,9,5.8>,.2}
    sphere {<-30,9,10>,.2}
    sphere {<-30,7,10>,.2}
    sphere {<-30,9,5.8>,.2}
    sphere {<-30,7,5.8>,.2}

    pigment {color White}
}


// Oxygen Furnace
difference {
    union {
        sphere {<0,0,0>,5}
        cone {<0,5/rad2,0>,5/rad2,<0,6,0>,3}
        cylinder {<0,5/rad2-.3,0>,<0,5/rad2+.3,0>,5/rad2+.7}
        cylinder {<0,6,0>,<0,5.5,0>,3.3}

        intersection {
            sphere {<0,0,-4>,2}
            union {
                box {<-3,.1,-5.5>,<3,-.1,0>}
                box {<-3,.6,-5.5>,<3,.8,0>}
                box {<-3,-.6,-5.5>,<3,-.8,0>}
                box {<.1,-3,-5.5>,<-.1,3,0>}
                box {<.6,-3,-5.5>,<.8,3,0>}
                box {<-.6,-3,-5.5>,<-.8,3,0>}
                box {<3,3,0>,<-3,-3,-5>}
            }
        }
    }
    cylinder {<0,7,0>,<0,0,0>,2.5}

    rotate -x*30
    translate <-15,5,25>
    pigment {color White}
}

// sparks
union {
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate x*10} box {<-1,0,7>,<1,-10,-7> rotate x*65} translate <0,.5,-3>  rotate y*35}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*45} box {<-1,0,7>,<1,-10,-7> rotate x*30} translate <0,.5,-3> rotate y*30}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*0} box {<-1,0,7>,<1,-10,-7> rotate x*65} translate <0,.5,-3>  rotate y*25}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*52} box {<-1,0,7>,<1,-10,-7> rotate x*30} translate <0,.5,-3> rotate y*20}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate x*5} box {<-1,0,7>,<1,-10,-7> rotate x*65} translate <0,.5,-3>  rotate y*15}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*45} box {<-1,0,7>,<1,-10,-7> rotate x*30} translate <0,.5,-3> rotate y*10}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*15} box {<-1,0,7>,<1,-10,-7> rotate x*45} translate <0,.5,-3> rotate y*0}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*5} box {<-1,0,7>,<1,-10,-7> rotate x*60} translate <0,.5,-3>  rotate -y*10}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*50} box {<-1,0,7>,<1,-10,-7> rotate x*30} translate <0,.5,-3> rotate -y*15}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*10} box {<-1,0,7>,<1,-10,-7> rotate x*60} translate <0,.5,-3>  rotate -y*20}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*50} box {<-1,0,7>,<1,-10,-7> rotate x*30} translate <0,.5,-3> rotate -y*25}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate x*15} box {<-1,0,7>,<1,-10,-7> rotate x*60} translate <0,.5,-3>  rotate -y*30}
    difference {torus {6,.01 rotate z*90} box {<-1,7,0>,<1,-7,10> rotate -x*50} box {<-1,0,7>,<1,-10,-7> rotate x*30} translate <0,.5,-3> rotate -y*35}

    rotate -x*30
    translate <-15,5,25>
    pigment {color Red}
    finish {ambient 1}
    no_shadow
}

// Ladle
union {
    cylinder {<0,3,0>,<0,-5,0>,3}
    sphere {<0,-10,0>,3 scale y*.5}
    cylinder {<0,-2,0>,<0,-2.5,0>,3.5}
    cylinder {<0,3,0>,<0,2.5,0>,3.5}
    cylinder {<0,-4.5,0>,<0,-4.4,0>,3.5}
    cylinder {<0,-4,0>,<0,-4.1,0>,3.5}
    box {<-.1,-4.5,-3.5>,<.1,-4,3.5>}
    box {<-.1,-4.5,-3.5>,<.1,-4,3.5> rotate-y*30}
    box {<-.1,-4.5,-3.5>,<.1,-4,3.5> rotate-y*60}
    box {<-.1,-4.5,-3.5>,<.1,-4,3.5> rotate-y*90}
    box {<-.1,-4.5,-3.5>,<.1,-4,3.5> rotate-y*120}
    box {<-.1,-4.5,-3.5>,<.1,-4,3.5> rotate-y*150}

    rotate x*60
    translate <-15,13,15>
    pigment {color White}
}

union {
    box {<-12,12,14>,<-11,50,16>}
    cylinder {<-12,12,15>,<-11,12,15>,1.5}
    cylinder {<-10.5,12,15>,<-11,12,15>,.8}

    pigment {color White}
}

union {
    box {<-18,12,14>,<-19,50,16>}
    cylinder {<-18,12,15>,<-19,12,15>,1.5}
    cylinder {<-19.5,12,15>,<-19,12,15>,.8}

    pigment {color White}
}
