
// Persistence of Vision Ray Tracer Scene Description File
// File: aislarc.inc
// Vers: 3
// Date: 02/28/98
// Auth: Bob Franke
//

#version 3


#include "colors.inc"

/*
global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0, 40, -80>
  direction 1*z
  right     4/3*x
  look_at   <0,40,  0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <5, 10, -30>
}
*/


#include "finish.inc"
#include "colors.inc"
#include "stones.inc"

#declare cly_111=
difference{
  cylinder{<0,00,4>,<0,00,-4>,20}
  cylinder{<0,00,-10>,<0,00,10>,19.0}
  texture{T_Grnt11 scale .1}
}
#declare cly_211=
difference{
  cylinder{<0,00,3.75>,<0,00,-3.75>,19}
  cylinder{<0,00,-10>,<0,00,10>,18.0}
   texture{T_Grnt11 scale .1}
}
#declare cly_311=
difference{
  cylinder{<0,00,3.5>,<0,00,-3.5>,18}
  cylinder{<0,00,-10>,<0,00,10>,17.0}
   texture{T_Grnt11 scale .1}
}


#declare aisleArch=
union{
  object{
    cly_111  translate<6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 } }
  }
  object{
    cly_111  translate<-6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 inverse} }
  }
  object{
    cly_211  translate<6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 } }
  }
  object{
    cly_211  translate<-6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 inverse} }
  }
  object{
    cly_311  translate<6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 } }
  }
  object{
    cly_311 translate<-6.462,36,0>
    clipped_by{plane{y,36 inverse }}
    clipped_by{plane{x,0 inverse} }
  }

  box{<-13.538,0,-4.00>, <-12.538,36,4.00> texture{T_Grnt11 scale .1}}
  box{<-12.538,0,-3.75>, <-11.538,36,3.75> texture{T_Grnt11 scale .1}}
  box{<-11.538,0,-3.50>, <-10.538,36,3.50> texture{T_Grnt11 scale .1}}
  box{< 13.538,0,-4.00>, <12.538,36,4.00> texture{T_Grnt11 scale .1}}
  box{< 12.538,0,-3.75>, <11.538,36,3.75> texture{T_Grnt11 scale .1}}
  box{< 11.538,0,-3.50>, <10.538,36,3.50> texture{T_Grnt11 scale .1}}

  merge{
    difference{
      box{<-13.538,36,3>,<0,63,-3>}
      cylinder{<6.836,36,4>,<6.836,36,-4>,20}
    }
    difference{
      box{<0,36,3>,<13.538,63,-3> }
      cylinder{<-6.836,36,4>,<-6.836,36,-4>,20}
    }
    texture{T_Grnt11 scale .1}
  }
}

//aisleArch
