
// Persistence of Vision Ray Tracer Scene Description File
// File: lamp2.inc
// Vers: 3
// Date: 02/28/98
// Auth: Bob Franke
//

#version 3

#include "colors.inc"
#include "finish.inc"
#include "golds.inc"
#include "metals.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 2.2
}
/*
// ----------------------------------------
camera
{
  location  <0, -2,-8>
  direction 1*z
  right     4/3*x
  look_at   <-1.5, .5  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb .5] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color red 1.5  green 1.5  blue 1.5 // light's color
  translate <0, 0, -30>
}

*/


#declare lightBulb=
  union {
    sphere { <0,0,0>,4/12 }
    cylinder{ <0,0,0>, <0,.5,0>, 1/12}
    texture {
      pigment {color rgb <1, 1, .8>*.9}
      finish{Luminous }
    }
    translate<12.75/12,0,0>
    no_shadow
  }


#declare lightBulbs=
union{
  object{lightBulb rotate<0,-30,0>}
  object{lightBulb rotate<0,90,0>}
  object{lightBulb rotate<0,210,0>}
}


// ----------------------------------------
//plane { y, -1 pigment {color rgb <0.7,0.5,0.3>}}

#declare oneLink=
union{
  object{
    torus { .75/12, .1875/12}
    clipped_by{plane{x,0}}
    texture{T_Gold_1C }
  }
  cylinder{<0,0,.75/12>,<1.5/12,0,.75/12>,.1875/12}
  cylinder{<0,0,-.75/12>,<1.5/12,0,-.75/12>,.1875/12}
  object{
    torus { .75/12, .1875/12}
    clipped_by{plane{x,0 inverse}}
    translate<1.5/12,0,0>
    texture{T_Gold_5E}
  }
   texture{T_Gold_5E}
}

#declare oneChain=
#declare xx=0
union{
#while (xx < 36)
  object {oneLink rotate<20,0,0> translate<xx/12,0,0>}
  object {oneLink rotate<110,0,0> translate<xx/12 + 2.6875/12,0,0>}
  #declare xx = xx + 2.6875*2
#end
}


#declare lightHolder=
union{
  object{
    torus{4.5/12, 1/12 }
    clipped_by{plane{y,0 inverse}}
    clipped_by{cylinder{<0,-2,0>,<0,2,0>,4.5/12 inverse}}
  }
  disc { <0,0,0>, <0,1,0> 4.5/12  translate<0,1/12,0>}
  cylinder{<0,1/12,0>,<0,-.5/12,0>, 1.125/12 }
  texture{T_Gold_5E}
}

#declare Fixture=
union{
  object{oneChain rotate<0,0,-69.5> rotate<0,30,0> translate<0,1,0>}
  object{oneChain rotate<0,0,-69.5> rotate<0,150,0> translate<0,1,0>}
  object{oneChain rotate<0,0,-69.5> rotate<0,270,0> translate<0,1,0>}
  difference{
    cylinder{<0,-22.5/12,0>,<0,-24.5/12,0>,13/12}
    cylinder{<0,-19.75/12,0>,<0,-30.75/12,0>,12.5/12}
    texture{T_Silver_1C }
    no_shadow
  }

  object{lightHolder translate<12.75/12,-25.5/12,0>  rotate<0,-30,0>}
  object{lightHolder translate<12.75/12,-25.5/12,0>  rotate<0,90,0>}
  object{lightHolder translate<12.75/12,-25.5/12,0>  rotate<0,210,0>}

  light_source {<8,-30.5/12,0> color rgb <1.000, 1.000, 0.95>.04
    looks_like{object{lightBulbs translate<-8,0,0>}}
  }
}


#declare lightFixture=
union{
  object{Fixture scale 1.5 translate<0,-.6,0>}
union{
  difference{
    cylinder{<0,0,-.08>,<0,0,.08>, 3}
    cylinder{<0,0,-1>,<0,0,1>, 35.25/12}
    clipped_by{plane{y,0 inverse}}
    clipped_by{plane{x,0}}
  }

  difference{
    cylinder{<0,2,-.08>,<0,2,.08>, 1}
    cylinder{<0,2,-1>,<0,2,1>, 11.25/12}
    clipped_by{plane{x,0 inverse}}
  }

  difference{
    cylinder{<0,0,-.08>,<0,0,.08>, 1}
    cylinder{<0,0,-1>,<0,0,1>, 11.25/12}
    clipped_by{plane{y,0 }}
    clipped_by{plane{x,2 }}
    translate<0,2,0>
  }

  difference{
    cylinder{<0,0,-.08>,<0,0,.08>, 3}
    cylinder{<0,0,-1>,<0,0,1>, 35.25/12}
    translate<-3.88,1,0>
    clipped_by{plane{x,-3 inverse}}
  }

  difference{
    cylinder{<0,0,-.08>,<0,0,.08>, 7.5/12}
    cylinder{<0,0,-1>,<0,0,1>, 6.75/12}
    box{<0,-.15,-10>,<10,.35,10>}
    translate<-2.37,2.75,0>
  }
  box{<-36.75/12,-2.5,-.08>,<-36/12,5,.08>}

  difference{
    cylinder{<0,0,-.08>,<0,0,.08>, 10.75/12}
    cylinder{<0,0,-1>,<0,0,1>, 10/12}
    box{<-10,10,-10>,<0,0,1>}
    translate<-2.10,-0,0>
  }
  box{<-36.75/12,-2.5,-.08>,<-36/12,5,.08>}


 texture{T_Gold_5E}

}





}

//object{lightFixture}

