
// Glenn's POV-Ray Scene File -  Great Wall of China
// created 16-Jan-98
// last update 25-Feb-98
// copyright 1998 Glenn McCarter

// NOTE this scene uses the Right Hand coordinate reference system


#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 5
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//===============================================
//             Variables
//===============================================

//===============================================
//             Cameras
//===============================================

#declare CameraLoc = <-80*Feet, 0, 90*Feet>
#declare CameraAngle = <0, 18, 0> // this sets the angle of the mirror assembly

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  /* // Focal Blur section: uncomment to enable focal blur
  blur_samples 6
  aperture .5    //lower value = wider range in focus
  focal_point <0,0,0>
  */ // end focal blur
	location CameraLoc
  look_at <200*Feet 0, 0>
}

#declare Special_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
//  location <-15, -16, 41>
//	location CameraLoc // render view
//  look_at <400*Feet 0, 0>
//	location <-75*Feet, 0, 85*Feet> // near render view
//  look_at <400*Feet 0, 0>
//	location <-8*Feet,80*Feet,40*Feet> // side view, near wall
//	look_at <40*Feet,0,0>
//	location <-8*Feet,50*Feet,40*Feet> // near wall sunside base
//	look_at <40*Feet,0,-10*Feet>
//	location <-8*Feet,50*Feet,40*Feet> // near tower sunside
//	look_at <40*Feet,0,20*Feet>
//	location <30*Feet,20*Feet,50*Feet> // near tower roof closeup
//	look_at <50*Feet,0,40*Feet>
//	location <60*Feet,-100*Feet,40*Feet> // 3/4 view, medium wall
//	look_at <200*Feet,0,0>
//	location <60*Feet,100*Feet,40*Feet> // 3/4 view, medium wall, sunside
//	look_at <200*Feet,0,0>
//	location <300*Feet,80*Feet,10*Feet> // 3/4 view, medium tower closeup
//	look_at <380*Feet,0,0>
//	location <200*Feet,-160*Feet,70*Feet> // side view, medium wall
//	look_at <200*Feet,0,0>
//	location <800*Feet,150*Feet,40*Feet> // 3/4 view, far wall, sunside
//	look_at <1000*Feet,0,0>
//	location <550*Feet,-200*Feet,50*Feet> // side view, far wall
//	look_at <600*Feet,0,0>
  }

#declare Third_Cam =
  camera {
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//    angle 40
//    direction z*50
//  location <-15, -16, 41>
	location CameraLoc // south view
  look_at <-400*Feet, 0*Feet, 0>
  }

camera {
//	Special_Cam
//	Third_Cam
	Render_Cam
  }


//===============================================
//             Textures
//===============================================

#declare BlueTex = texture { pigment { color rgb<.2,.2,.99> } } // test

#declare WallTex =
	texture {
		pigment {
			crackle
			color_map {
				[  0.00  color rgb<.00,.00,.00> ]
				[  0.03  color rgb<.30,.36,.15> ]
				[  0.10  color rgb<.80,.76,.20> ]
				[  0.80  color rgb<.93,.82,.50> ]
				[  0.90  color rgb<.95,.80,.70> ]
				[  1.00  color rgb<.96,.92,.89> ]
			} // color_map
		turbulence .2
		scale <30,30,14>
		}
		normal { bumps .6 scale .15 }
		finish { ambient .1 diffuse .7 specular .3 roughness .3 }
	}
#declare WallBricks =
	texture {
		pigment {
			brick color rgb<1.16,1.14,1.08>, color rgb<.97,.90,.58> //mortar,brick
				brick_size <34,12,34>   // size of brick
				mortar 1.5       // width of mortar
				rotate x*90
		}
		normal { bumps .3 scale .05 }
		finish { ambient .16 diffuse .7 specular .1 roughness .3 }
	}

#declare MountainBaseTex =
	texture {
//pigment { color rgb<.20,.46,.10> } // test
	pigment {
	bozo
	color_map
		{
		[  0.00  color rgb<.20,.46,.10> ] // greenish
		[  0.70  color rgb<.20,.46,.10> ]
		[  0.75  color rgb<.75,.76,.20> ] // rocky tan
		[  0.90  color rgb<.95,.76,.35> ]
		[  1.00  color rgb<.95,.96,.50> ]
		} // color_map
		turbulence 1.0
	}
		normal { dents .7 scale 1.5 }
		finish { ambient .1 diffuse .7 specular .1 roughness .3 }
	}
#declare MountainCoverTex =
	texture {
//pigment { color rgb<.20,.46,.10> } // test
	pigment {
	bozo
	color_map
		{
		[  0.00  color rgbt<.20,.46,.10,1.0> ]
		[  0.60  color rgbt<.20,.46,.10,1.0> ] // clear
		[  0.80  color rgb<.05,.26,.02> ]
		[  0.90  color rgb<.25,.66,.17> ] // greenish
		[  1.00  color rgb<.55,.82,.20> ]
		} // color_map
		turbulence 0.4
	}
		normal { bumps .7 scale 1.8 }
		finish { ambient .1 diffuse .7 specular .1 roughness .3 }
	}
#declare Mountain1Tex =
	texture { MountainBaseTex }
	texture { MountainCoverTex scale .3 }

#declare Mountain2Tex =
	texture {
//pigment { color rgb<.20,.46,.10> } // test

	pigment {
	bozo
	color_map
		{
		[  0.00  color rgb<.20,.46,.10> ]
		[  0.70  color rgb<.20,.46,.10> ]
		[  0.85  color rgb<.40,.56,.20> ]
		[  1.00  color rgb<.40,.56,.20> ]
		} // color_map
		turbulence .5
	}

		normal { bumps .5 scale 1 }
		finish { ambient .1 diffuse .7 specular .1 roughness .3 }
	}
#declare Mountain3Tex =
	texture {
//pigment { color rgb<.20,.46,.10> } // test

	pigment {
	bozo
	color_map
		{
		[  0.00  color rgb<.20,.46,.10> ]
		[  0.30  color rgb<.30,.46,.20> ]
		[  0.46  color rgb<.40,.46,.40> ]
		[  0.50  color rgb<.40,.46,.40> ]
		[  0.54  color rgb<.20,.46,.10> ]
		[  1.00  color rgb<.20,.46,.10> ]
		} // color_map
	}

		normal { bumps .8 scale 10 }
		finish { ambient .1 diffuse .7 specular .1 roughness .3 }
	}

#declare BushTex =
	texture {
//pigment { color rgb<.20,.46,.10> } // test
	pigment {
	bozo
	color_map
		{
		[  0.00  color rgbt<.20,.46,.10,1.0> ]
		[  0.70  color rgbt<.20,.46,.10,1.0> ]
		[  0.70  color rgb<.28,.96,.17> ]
		[  1.00  color rgb<.28,.96,.17> ]
		} // color_map
		turbulence 0.7
		scale 5
	}

		normal { bumps .9 scale 5 }
		finish { ambient .1 diffuse .7 specular .1 roughness .05 }
	}

#declare TanPaint =
	texture {
		pigment { color rgb<.87,.70,.50> }
		normal { bumps .4 scale 3 }
		finish { ambient .1 diffuse .7 specular .4 roughness .1 }
	}

//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }
#declare Sun =
  light_source {
    <0,0,0>
    colour rgb <1, 1, 1>
		fade_distance 2*Miles
		fade_power 1
    looks_like {
      sphere {
        <0,0,0>, 1
        texture {
          pigment { color rgb<1,1,1> }
          finish { ambient .99 diffuse .2 }
        }
      }
    }
  }
object { Sun translate <-2*Miles,4*Miles,1.7*Miles> }
#declare Skylight = // slight bluish tinge on top of everything
  light_source {
    <0,0,0>
    colour rgb <.7, .7, 1> *0.3
		fade_distance 2*Miles
		fade_power 1
  }
object { Skylight translate <-400*Feet,0,2*Miles> }

//===============================================
//             Environment
//===============================================

background { color rgb <0.62, 0.75, 0.95> } // light blue

fog {
	fog_type 1 // general fog adds distance
		distance 1400*Feet
		color rgbt<.800,.800,.998,.366> // transmittance (lower trans dulls out sky)
		turbulence .001
	}


//===============================================
//             Objects
//===============================================

#declare Horizon =
	box {
		<-60*Miles,-60*Miles,-200*Feet>,<60*Miles,60*Miles,-201*Feet>
		texture { Mountain1Tex }
	}

#declare TestWall =
	box {
		<0,-11*Feet,0>,<100*Feet,11*Feet,25*Feet>
		texture { PaperWhite }
	}


//-------- Mirror Assembly -------------------

#declare TuningAngle = 4
#declare MainMirror =
	box {
		<-1,-1,-20>,<1,1,20>
//		texture { PaperWhite }
		texture { MirrorTex }
		rotate z*45
	}
#declare SideMirrorRH =
	box {
		<-.01,-15,-25>,<.01,2,25>
//		texture { PaperWhite }
		texture { MirrorTex }
	}
#declare SideMirrorLH =
	box {
		<-.01,-2,-25>,<.01,15,25>
//		texture { PaperWhite }
		texture { MirrorTex }
	}
#declare BlackShield =
	box {
		<-.01,-3.7,-25>,<.01,3.7,25>
//		<-.01,-3.0,-25>,<.01,3.0,25>
//		texture { PaperWhite }
		texture { FlatBlack }
	}
#declare Reflect_O_Shield = // reflects backwards, dimly
	difference {
	box {
		<-.01,-.7,-25>,<.01,1.2,25>
//		texture { PaperWhite }
		texture {
			pigment { color rgb<.2,.2,.12> }
			finish { ambient 0 reflection .3 }
		}
		rotate <0,-18,0> // counteract camera downward angle
	}
	box {
		<-6,-0.15,-25>,<6,0.05,25>
		texture { FlatBlack }
		rotate x*-5 // lean in to make parallel cut
	}
	box {
		<-6,-0.05,-25>,<6,0.15,25>
		texture { FlatBlack }
		rotate x*5 // lean in to make parallel cut
	}
	} // end difference
#declare FrameBox =
	box {
		<-.05,-1.05*1.414,-25>,<.05,1.05*1.414,25>
		texture { FlatBlack }
	}
#declare DistanceFromCamera = 5
#declare MirrorAssy =
	union {
		object { MainMirror translate <DistanceFromCamera,0,-3> }
		object { FrameBox translate <DistanceFromCamera,0,-3> }
		object { FrameBox rotate z*90 translate <DistanceFromCamera,0,-3> }
		object { SideMirrorRH rotate z*(45+TuningAngle)  translate <DistanceFromCamera,-20,-3> }
		object { SideMirrorLH rotate z*(-45-TuningAngle) translate <DistanceFromCamera,20,-3> }
		object { BlackShield translate <DistanceFromCamera+0.5,0,0> }
//		object { Reflect_O_Shield translate <DistanceFromCamera-4.5,0,0> }
//		translate CameraLoc
		no_shadow
	}

//-------- Guard Tower -------------------

#declare GuardTowerTest =
		box {
			<0,0,0>,<20*Feet,20*Feet,60*Feet>
			texture { WallBricks }
		}
#declare GSlot = // upper slits
	box {
		<-6,-20*Feet,0>,<6,20*Feet,36>
	}
#declare GWindow =
	union {
		box { <-20*Feet,-16,0>,<20*Feet,16,4*Feet> }
		cylinder { <-20*Feet,0,4*Feet>,<20*Feet,0,4*Feet>,16 }
	}
#declare GDoorway =
	union {
		box { <-20*Feet,-28,0>,<20*Feet,28,8*Feet> }
		cylinder { <-20*Feet,0,8*Feet>,<20*Feet,0,8*Feet>,28 }
	}
#declare FlagPoleBase =
	union {
		box { // base x
			<-22,-3,0>,<22,3,3>
		}
		box { // base y
			<-3,-22,0>,<3,22,3>
		}
		box { // support front
			<-3,-3,0>,<-1,3,30>
		}
		box { // support rear
			<1,-3,0>,<3,3,30>
		}
		texture { TanPaint }
	} // end union
#include "FlagBanner1.pov"
#include "FlagStrip1.pov"
#include "FlagStrip2.pov"
#declare FlagWithPole =
	union {
		cylinder { // simple pole
			<0,0,0>,<0,0,21*Feet>,1
			texture { pigment { color rgb<.74,.52,.23> } }
		}
		object { FlagBanner1 scale 20 rotate <180,0,30> translate <0,0,20*Feet-8> }
		object { FlagStrip1 scale 20 rotate <180,0,12> translate <0,0,18*Feet> }
		object { FlagStrip2 scale 20 rotate <180,0,-3> translate <0,0,18*Feet-9> }
	} // end union
#declare FlagPoleAssy =
	union {
		object { FlagPoleBase }
		object { FlagWithPole rotate z*90 }
	}
#declare SmallGuardTower =
	union {
		difference {
			box { // outer shell
				<0,0,0>,<24*Feet,24*Feet,60*Feet>
			}
			box { // inner hollow
				<2*Feet,2*Feet,-1>,<22*Feet,22*Feet,54*Feet>
			}
			box { // upper roof
				<1*Feet,1*Feet,55*Feet>,<23*Feet,23*Feet,61*Feet>
			}
			object { GDoorway translate <0,12*Feet,40*Feet> }
			object { GWindow rotate z*0 translate <10*Feet,6*Feet,45*Feet> }
//			object { GWindow rotate z*0 translate <10*Feet,18*Feet,45*Feet> }
			object { GWindow rotate z*90 translate <6*Feet,10*Feet,45*Feet> }
			object { GWindow rotate z*90 translate <12*Feet,10*Feet,45*Feet> }
			object { GWindow rotate z*90 translate <18*Feet,10*Feet,45*Feet> }
			object { GSlot rotate z*0  translate < 5*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <10*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <15*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <20*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <25*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet, 5*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,15*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,20*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,25*Feet,58*Feet> }
		} // end difference
		box { // upper coping row
			<-4,-4,0>,<24*Feet+4,24*Feet+4,4>
			translate <0,0,54*Feet>
		}
		texture { WallBricks scale 1 }
	}
#declare SmallGuardTowerWithStuff =
	union {
		object { SmallGuardTower }
		object { FlagPoleAssy translate <12*Feet,8*Feet,55*Feet> }
		box { // pillbox?
			<0,0,0>,<36,30,20>
			texture { pigment { color rgb<.68,.30,.21>} normal { bumps .5 scale 2 } }
			translate <18*Feet,16*Feet,55*Feet>
		}
		box { // roof box
			<0,0,0>,<7*Feet,4*Feet,28>
			translate <8*Feet,2*Feet,55*Feet>
			texture { pigment { color rgb<.66,.73,.48>} normal { bumps .5 scale 2 } }
		}
	}
#declare BigGuardTower =
	union {
		difference {
			box { // outer shell
				<0,0,0>,<30*Feet,30*Feet,60*Feet>
			}
			box { // inner hollow
				<2*Feet,2*Feet,-1>,<28*Feet,28*Feet,54*Feet>
			}
			box { // upper roof
				<1*Feet,1*Feet,55*Feet>,<29*Feet,29*Feet,61*Feet>
			}
			object { GDoorway translate <0,15*Feet,38*Feet> }
			object { GWindow rotate z*0 translate <0,7*Feet,42*Feet> }
			object { GWindow rotate z*0 translate <0,25*Feet,42*Feet> }
			object { GWindow rotate z*90 translate <7*Feet,0,42*Feet> }
			object { GWindow rotate z*90 translate <15*Feet,0,42*Feet> }
			object { GWindow rotate z*90 translate <23*Feet,0,42*Feet> }
			object { GSlot rotate z*0  translate < 5*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <10*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <15*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <20*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*0  translate <25*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet, 5*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,10*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,15*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,20*Feet,58*Feet> }
			object { GSlot rotate z*90 translate <10*Feet,25*Feet,58*Feet> }
		} // end difference
		box { // upper coping row
			<-4,-4,0>,<30*Feet+4,30*Feet+4,4>
			translate <0,0,54*Feet>
		}
		box { // roof box
			<0,0,0>,<4*Feet,7*Feet,14>
			translate <2*Feet,3*Feet,55*Feet>
		}
		texture { WallBricks scale 1 }
	}

//-------- Wall and Mountains -------------------

#include "wbase.pov"
#include "wrail.pov"
#include "wblock.pov"
#declare GreatWall =
union {
	object { WallBase translate <0,-.05,0> texture { WallTex rotate <-90,0,0> scale 1/100 } }
	object { WallRail texture { WallBricks scale 1/200 } }
	object { WallBlocks texture { WallBricks scale 1/200 } }
		rotate <90,0,0>
		scale <1,1,1>
	}
//#declare GreatWall = box {<0,0,0>,<1,1,1> texture {WallTex} } // dummy

#declare Mountain1 =
	height_field {
		png "zed1.png"
		smooth
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,0> //center on origin
		scale 1 // scale it up
		translate <0,0,0>
	}

#declare Mountain2 =
	height_field {
		png "zed2.png"
		smooth
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,0> //center on origin
		scale 1 // scale it up
		translate <0,0,0>
	}

#declare Mountain3 =
	height_field {
		png "zed3.png"
		smooth
		rotate x*90 // set up for RH coordinate system
		translate <-.5,.5,0> //center on origin
		scale 1 // scale it up
		translate <0,0,0>
	}

//-------- Other Stuff -------------------
#include "Bush1.pov"
#include "Guard.pov"

//===============================================
//             Object Placement
//===============================================

object { MirrorAssy rotate CameraAngle translate CameraLoc }

object { GreatWall // close
	rotate z*12 scale 100 translate <-90*Feet,-10*Feet,-60*Feet> }
object { SmallGuardTowerWithStuff rotate z*20 translate <65*Feet,-19*Feet,-32*Feet> } // near
object { GuardWithAxe scale 1.2 rotate <0,0,-160> translate <81*Feet,-1*Feet,23.5*Feet> }
object { GuardWithAxe scale 1.2 rotate <0,0,-30> translate <62*Feet,2*Feet,23.5*Feet> }

object { Mountain1 // close
	scale <700*Feet,2000*Feet,160*Feet> translate <-60*Feet,-300*Feet,-140*Feet>
	texture { Mountain1Tex scale 30 } }
object { Bush1 scale <100,100,100> texture { BushTex } translate <50*Feet,20*Feet,0*Feet> }
object { Bush1 scale <70,60,100> texture { BushTex } translate <30*Feet,12*Feet,-4*Feet> }
object { Bush1 scale <70,60,100> rotate z*120 texture { BushTex } translate <40*Feet,4*Feet,-4*Feet> }
object { Bush1 scale <100,100,100> rotate z*-40 texture { BushTex } translate <22*Feet,10*Feet,-4*Feet> }

object { GreatWall // medium
	scale <1,-1,1>
	rotate z*210 scale 100 translate <480*Feet,120*Feet,-86*Feet> }
object { GreatWall // medium further
	rotate z*-12 scale 100 translate <600*Feet,140*Feet,-90*Feet> }
object { BigGuardTower scale <1,1,1> rotate z*12 translate <300*Feet,-12*Feet,-75*Feet> } // middle first
object { SmallGuardTowerWithStuff rotate z*23 translate <380*Feet,16*Feet,-56*Feet> } // middle second
object { GuardWithAxe scale 1.2 rotate <0,0,-30> translate <350*Feet,13*Feet,-22*Feet> }
object { Mountain2 // medium LH
	scale <900*Feet,2000*Feet,60*Feet> translate <540*Feet,240*Feet,-80*Feet>
	texture { Mountain2Tex scale 50  rotate <0,0,0> } }

object { GreatWall // far on top
	rotate z*0 scale 100 translate <1000*Feet,-30*Feet,-55*Feet> }
object { GreatWall // far below
	rotate z*-25 scale 100 translate <900*Feet,40*Feet,-100*Feet> }
object { BigGuardTower rotate z*-12 translate <680*Feet,75*Feet,-66*Feet> } // middle far
object { SmallGuardTowerWithStuff rotate z*-18 translate <1000*Feet,-54*Feet,-70*Feet> } // farthest

object { Mountain3 // far center
	scale <900*Feet,2000*Feet,200*Feet> translate <1000*Feet,0*Feet,-200*Feet>
	texture { Mountain3Tex scale 50  rotate <0,0,0> } }
object { Mountain2 // far RH
	scale <600*Feet,2000*Feet,200*Feet> translate <1000*Feet,-330*Feet,-170*Feet>
	texture { Mountain3Tex scale 50  rotate <0,0,0> } }
object { Mountain3 // med far horizon LH
	scale <.3*Miles,4*Miles,1200*Feet> translate <1.5*Miles,1*Miles,-1200*Feet>
	texture { Mountain3Tex scale 300  rotate <0,0,0> } }
object { Mountain3 // med far horizon RH
	scale <.3*Miles,4*Miles,1200*Feet> translate <1.5*Miles,-1*Miles,-1200*Feet>
	texture { Mountain3Tex scale 300  rotate <0,0,0> } }

object { Mountain1 // very far horizon
	scale <1*Miles,7*Miles,2400*Feet> translate <3*Miles,1*Miles,-2000*Feet>
	texture { Mountain3Tex scale 300  rotate <0,0,0> } }

