
// Glenn's POV-Ray Scene File - Chinese Border Guard
// created 22-Feb-98
// last update 25-Feb-98
// copyright 1998 Glenn McCarter
//
// NOTE this scene uses the Right Hand coordinate reference system
//
// a medieval Chinese guard

#include "gcloak.pov"
#include "gpants.pov"
#include "gboots.pov"
#include "gskin.pov"
#include "ghelm.pov"
#include "AxeHead.pov"

//===============================================
//             Textures
//===============================================


#declare CloakTex =
	texture {
//		pigment { color rgb<.84,.55,.15> }
		pigment { color rgb<.97,.40,.15> }
		normal { wrinkles .8 scale 1 }
		finish { ambient .1 specular .2 roughness .2 }
	}
#declare PantsTex =
	texture {
		pigment { color rgb<.64,.65,.45> }
		normal { wrinkles .8 scale 1 }
		finish { ambient .1 specular .2 roughness .2 }
	}
#declare BootsTex =
	texture {
		pigment { color rgb<.11,.16,.24> }
		normal { wrinkles .8 scale 1 }
		finish { ambient .1 specular .9 roughness .04 }
	}
#declare HelmTex =
	texture {
		pigment { color rgb<.74,.68,.11> }
		normal { bumps .3 scale .5 }
		finish { ambient .1 specular .96 roughness .02 reflection .4 }
	}
#declare SkinTex =
	texture {
		pigment { color rgb<.90,.80,.50> } // more whitish
//		pigment { color rgb<.93,.62,.35> } // more reddish
		normal { bumps .8 scale .4 }
		finish { ambient .19 specular .1 roughness .1 }
	}
#declare AxeHeadTex =
	texture {
		pigment { color rgb<1,1,1> }
		normal { bumps .1 scale 2 }
		finish { ambient .4 specular 1 roughness .02 reflection .55 }
	}

//===============================================
//             Objects
//===============================================

#declare Axe =
	union {
		cylinder {
			<0,0,0>,<0,0,56>,.7
			texture {
				pigment { color rgb<.86,.61,.13> }
				finish { ambient .1 specular .4 roughness .15 }
			}
		}
		object { AxeHead
			texture { AxeHeadTex }
			scale 3
			rotate <90,0,90> // facing -X direction
			translate <0,0,56>
		}
/*
		sphere { // distant glint
			<0,0,0>,1
			texture {
				pigment { color rgb<2,2,2> }
				finish { ambient 2 }
			}
			translate <-6,0,80>
		}
*/
	}

#declare Guard =
	union {
		object { GCloak	texture { CloakTex } }
		object { GPants	texture { PantsTex } }
		object { GBoots	texture { BootsTex } }
		object { GSkin	texture { SkinTex } }
		object { GHelm	texture { HelmTex } }
		scale 10
		rotate <90,0,90> // facing -X direction
		translate <0,0,46>
	}

#declare GuardWithAxe =
	union {
		object { Guard scale <1,-1,1> }
		object { Axe rotate <-3,-10,0> translate <-8,5,0> }
	}


//================================================================
//      Remove this entire section -- only used for test renders!
//================================================================
/*
//#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location  <-120, -42, 56> // 3/4 view
  look_at   <0, 0, 55>
	angle 40
}
camera { Render_Cam }
object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb100Watt translate <-100,-60,80> }
//object { GroundPlaneWhite }
object { GuardWithAxe }
*/
