/*
Glenn's Stereoscopic POV-Ray Include File, Version 0.9

NOTE: This version is not fully complete.  Use at your own risk!
See my website for updates: http://www.geocities.com/SoHo/Gallery/2006/

This file does not render.  #include "Stereo.inc" in another .pov file
Instructions for use below
created 22-Feb-98  last update 26-Feb-98
copyright 1998 Glenn McCarter   gmccarter@hotmail.com


---------------- Description -------------------

This file creates a system for viewing POV-Ray scene files
in stereo.  It works by setting up a group of mirrors in front
of the camera in the following way (top view):

               ____
               |  |
               Scene
              Objects
               |  |
               ----




        ____________________
          Black Background

  \           \      /           /
   \           \    /           /
    \            \/            /
  Mirror       Mirrors       Mirror


                 o
               Camera



The resulting image is stereoscopic -- view it properly, and you will see
a striking three dimensional image.  Here's how: sit a longer-than-usual
distance from your computer monitor.  Don't look at the monitor; rather, look
THROUGH it with your eyes focused in the far distance.  Each eye will
see two images of the scene.  Try to adjust your focus until your right eye
sees the right image, and your left eye sees the left image.  As you do this,
these images will merge into one.  The center image will be in stereo.


------------ Instructions For Use -------------------

1. Cut and paste the following into your POV-Ray
   scene description file:

  #declare CameraLocation = <0,30,0>    // position of camera
  #declare LookatLocation = <100,0,0>  // camera points to this
  #declare Hand = 2                  // 1 for LHS or 2 for RHS coordinate system
  #declare Separation = 20             // 5 to 40, bigger = more "stereo effect"
  #declare TuningAngle = 4             // 0 to 10, mirror angle adjustment
  #include "Stereo.inc"

2. Adjust the parameters as described below

3. DO NOT include a camera in your scene, Stereo.inc does this for you.
   Or, if you already have a camera, comment it out temporarily.

4. Render your image.


------------ Adjustments -------------------

The following parameters are adjustable:

Hand
  use 1 for LHS or 2 for RHS for Left Hand or Right Hand coordinate
  reference systems, respectively.  POV-Ray default is the LHS, where
  Y-axis = up.  But if you use Moray, the default is RHS, with
  Z-axis = up.

Separation
  This is the distance between the outermost mirrors.  Small values make
  a not-to-strong stereo efffect: the two views are almost identical.
  Large values produce strong stereo effects: each eye sees a very different
  image.  Beware, TOO large values will produce images too bizarre
  to view properly!

TuningAngle
  The mirrors, as shown in the diagram above, are set at 45-degree
  angles.  But by adjusting this value, you can change the angle
  of the outermost mirrors slightly.  This can cause the resulting
  image to either "pop out" of your computer monitor, or "fall in" to it.


------------ Raw Code -------------------
*/
//===============================================
//          Type A - Left Hand System
//===============================================




//===============================================
//          Type B - Right Hand System
//===============================================

#if ( Hand = 2 )

// Gmc note: following section needs work
#declare CameraAngle = <0, 10, 0> // this sets the angle of the mirror assembly

#declare MirrorTex =
	texture {
		pigment { color rgb<0,0,0> }
		finish { ambient 0 reflection 1.0 }
	}
#declare FlatBlack =
	texture {
		pigment { color rgb<0,0,0> }
		finish { ambient 0 specular 0 roughness .005 }
	}
#declare Stereo_Cam =
  camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location CameraLocation
  look_at LookatLocation
}

#declare MainMirror =
	box {
		<-1,-1,-20>,<1,1,20>
//		texture { PaperWhite }
		texture { MirrorTex }
		rotate z*45
	}
#declare SideMirrorRH =
	box {
		<-.01,-15,-25>,<.01,2,25>
//		texture { PaperWhite }
		texture { MirrorTex }
	}
#declare SideMirrorLH =
	box {
		<-.01,-2,-25>,<.01,15,25>
//		texture { PaperWhite }
		texture { MirrorTex }
	}
#declare BlackShield =
	box {
		<-.01,-3.7,-25>,<.01,3.7,25>
//		<-.01,-3.0,-25>,<.01,3.0,25>
//		texture { PaperWhite }
		texture { FlatBlack }
	}
#declare FrameBox =
	box {
		<-.05,-1.05*1.414,-25>,<.05,1.05*1.414,25>
		texture { FlatBlack }
	}
#declare DistanceFromCamera = 5
#declare MirrorAssy =
	union {
		object { MainMirror translate <DistanceFromCamera,0,-3> }
		object { FrameBox translate <DistanceFromCamera,0,-3> }
		object { FrameBox rotate z*90 translate <DistanceFromCamera,0,-3> }
		object { SideMirrorRH
			rotate z*(45+TuningAngle)
			translate <DistanceFromCamera,-Separation,-3> }
		object { SideMirrorLH
			rotate z*(-45-TuningAngle)
			translate <DistanceFromCamera,Separation,-3> }
		object { BlackShield translate <DistanceFromCamera+0.5,0,0> }
		no_shadow
	}


camera { Stereo_Cam }
object { MirrorAssy rotate CameraAngle translate CameraLocation }

#warning concat("\n","Stereoscopic imager by Glenn McCarter, copyright 1998","\n")
#end



//            (ignore the following GMc 26-Feb-98)
//================================================================
//      Uncomment this entire section for a test render!
//================================================================
/*
//#include "GRuler.inc"
#include "Colors.inc"
#include "Textures.inc"
#include "GIncludeRH.inc"
#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location  <-120, -42, 56> // 3/4 view
  look_at   <0, 0, 55>
	angle 40
}
camera { Render_Cam }
object {StdBulb60Watt translate <-40,80,70> }
object {StdBulb100Watt translate <-100,-60,80> }
//object { GroundPlaneWhite }
object { GuardWithAxe }
*/
