
// Glenn's POV-Ray Scene File - Stereo.inc include file test
// created 24-Feb-98
// last update 26-Feb-98
// copyright 1998 Glenn McCarter

#include "GIncludeRH.inc"
//#include "GRuler.inc"

#version 3.0
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.0
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

//===============================================
//             Variables
//===============================================

  #declare CameraLocation = <15,-16,80>    // position of camera
  #declare LookatLocation = <400,0,0>  // camera points to this
  #declare Hand = 2                  // for LHS or 2 for RHS coordinate system
  #declare Separation = 8             // 5 to 40, bigger = more "stereo effect"
  #declare TuningAngle = 4             // -5 to 5, mirror angle adjustment
  #include "Stereo.inc"

//===============================================
//             Cameras
//===============================================

/*
#declare Stereo_Cam =
  camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  location CameraLocation
  look_at LookatLocation
}
camera { Stereo_Cam }
*/

//===============================================
//             Textures
//===============================================

#declare WhiteTex = texture { pigment { color rgb<1,1,1> } normal { bumps .4} }
#declare BlackTex = texture { pigment { color rgb<0,0,0> } normal { bumps .4} }
#declare RedTex = texture { pigment { color rgb<1,0,0> } normal { bumps .4} }
#declare GreenTex = texture { pigment { color rgb<0,1,0> } normal { bumps .4} }
#declare BlueTex = texture { pigment { color rgb<0,0,1> } normal { bumps .4} }
#declare YellowTex = texture { pigment { color rgb<1,1,0> } normal { bumps .4} }
#declare LightGreyTex = texture { pigment { color rgb<.66,.66,.66> } normal { bumps .4} }

//--------- Light Grays
#declare T_Grnt24 =
texture {
pigment
 {marble
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                    color rgbf <0.745, 0.745, 0.753, 0.000>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                    color rgbf <0.902, 0.902, 0.859, 0.000>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                    color rgbf <0.729, 0.706, 0.694, 0.000>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                    color rgbf <0.588, 0.592, 0.635, 0.000>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                    color rgbf <0.608, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                    color rgbf <0.894, 0.886, 0.886, 0.000>]
   }
 }
 }


//-----Aqua Tints
#declare T_Grnt8a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                    color rgbf <0.322, 0.369, 0.416, 0.847>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                    color rgbf <0.424, 0.369, 0.420, 0.549>]
    [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                    color rgbf <0.373, 0.424, 0.518, 0.965>]
    [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                    color rgbf <0.482, 0.573, 0.533, 0.741>]
    [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                    color rgbf <0.310, 0.384, 0.420, 0.631>]
   }
 }
 }

//------------- Medium Gray Blue Marble
#declare T_Stone13 =
texture{T_Grnt24 scale <2, 5, 2> rotate <0, 0, 50>
        finish{ambient 0.2 crand 0.03}
}
texture{T_Grnt8a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}


//===============================================
//             Lighting
//===============================================

//object {StdBulb60Watt translate <4*Feet,8*Feet,7*Feet> }
//object {StdBulb60Watt translate <-10*Feet,2*Feet,8*Feet> }

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, 200>
}


//===============================================
//             Environment
//===============================================

background { color rgb <0.2, 0.4, 0.8> } // light blue
//background { color rgb <0.0, 0.0, 0.0> } // black
object {GroundPlaneWhite translate z*-0}

//===============================================
//             Objects
//===============================================

#declare BigBlock =
	box {
		<0,0,0>,<1,1,1>
		texture { T_Stone13 }
		scale <6,6,6>
	}
#declare BigDome =
	sphere {
		<0,0,0>,6
		texture { T_Stone13 }
	}
//===============================================
//             Object Placement
//===============================================


//object { TestSphere scale 4 translate <0,-6,3> }

#declare RS = seed(59203)
#declare X = 1
#while ( X < 20 )
	object { BigBlock
		scale <1,1,rand(RS)*4>
		translate <X*10+rand(RS)*20-5,rand(RS)*8-2,0> }
	#declare X = X + 1
#end
#declare X = 1
#while ( X < 200 )
	object { BigDome
		scale <1,1,rand(RS)*4>
		translate <rand(RS)*800,rand(RS)*200-100,0> }
	#declare X = X + 1
#end

box {
	<0,0,0>,<20,20,20>
	texture { RedTex }
	translate <200,-40,0>
}
box {
	<0,0,0>,<10,20,30>
	texture { BlueTex }
	translate <300,0,0>
}
box {
	<0,0,0>,<40,10,15>
	texture { GreenTex }
	translate <400,-40,0>
}

