//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 35 textures and 675 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/09/1998    (09.02.1998)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,1.000> }

camera {  //  Camera Camera01
  location  <-14.354, 1.163, 0.100>
  direction <0.0,     0.0,  2.3700>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.682, 0.499, 4.501>
}

// *******  L I G H T S *******
light_source { // AreaL001
  <2.644, 1.196, 15.859>
  color  rgb<1.000, 1.000, 1.000>
  area_light <4.000, 0.000, 0.000>, <0.000, 4.000, 0.000>, 3, 3
  adaptive 1
  jitter
}

light_source { // AreaL001
  <-12, 1.196, 15.859>
  color  rgb<1.000, 1.000, 1.000>
  area_light <4.000, 0.000, 0.000>, <0.000, 4.000, 0.000>, 3, 3
  adaptive 1
  jitter
}



// ********  TEXTURES  *******
//

#include "biplane.inc"
#include "scene.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

#declare BzPtch002 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.537094, -0.171564, 0.000000>, <-1.000000, -0.321696, 0.000000>, <0.000000, -0.321696, 0.000000>, <0.487050, -0.171564, 0.000000>, 
      <-2.000000, -0.012511, 0.000000>, <-0.549605, -0.012511, 1.838375>, <2.611931, -0.002242, 1.838375>, <0.877629, 0.010269, 0.159859>, 
      <-2.000000, -0.012511, 0.000000>, <-0.549605, -0.012511, 1.838375>, <2.611931, -0.002242, 1.838375>, <0.877629, 0.010269, 0.159859>, 
      <-1.562116, 0.134811, 0.000000>, <-1.000000, 0.297454, 0.000000>, <0.000000, 0.297454, 0.000000>, <0.574627, 0.159833, 0.000000>
    }
  }
  texture {
    Blue_Metal
  }
  scale <0.5, 0.5, 0.7>
  rotate -90.0*z
  translate  <0.0, -5.7, 0.7>
}
#declare BzPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.104888, -2.602105, 0.000000>, <0.936357, -2.595930, 0.056169>, <2.986761, -2.530813, 0.056169>, <0.858101, -2.596512, 0.056169>, 
      <-1.490442, -2.079067, 0.000000>, <0.137308, -2.072266, 1.853582>, <1.794538, -2.010069, 1.853582>, <-0.025200, -2.073473, 0.056169>, 
      <-3.031945, -1.287058, 0.000000>, <-1.623281, -1.225485, 1.853582>, <0.088720, -1.218059, 1.853582>, <-1.785789, -1.226692, 0.056169>, 
      <-3.040812, -0.093150, 0.000000>, <-1.632148, -0.031578, 1.853582>, <0.079854, -0.024151, 1.853582>, <-1.794656, -0.032785, 0.056169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.040812, -0.093150, 0.000000>, <-1.632148, -0.031578, 1.853582>, <0.079854, -0.024151, 1.853582>, <-1.794656, -0.032785, 0.056169>, 
      <-3.049679, 1.100758, 0.000000>, <-1.641014, 1.162330, 1.853582>, <0.070987, 1.169756, 1.853582>, <-1.803522, 1.161123, 0.056169>, 
      <-1.324840, 1.936709, 0.000000>, <0.302910, 1.943509, 1.853582>, <1.960140, 2.005707, 1.853582>, <0.140403, 1.942303, 0.056169>, 
      <0.295812, 2.389778, 0.000000>, <1.728372, 2.450307, 0.112338>, <3.177685, 2.461070, 0.056169>, <1.706283, 2.450143, 0.056169>
    }
  }
  texture {
    Glass
  }
  scale <0.1, 0.3, 0.4>
  rotate -90.0*z
  translate  <0.05, -0.45, 0.65>
}
#declare TraSwp001 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <-0.509954, 1.0>,
  <-0.673303, 0.261783>,
  <-0.348952, -3.621483>,
  <-0.004869, -3.647794>,
  <0.357872, -3.641902>,
  <0.703271, 0.234558>,
  <0.5, 1.0>,
  <0.293194, 1.334031>,
  <-0.004977, 1.496852>,
  <-0.28469, 1.323294>,
  <-0.509954, 1.0>,
  <-0.673303, 0.261783>,
  <-0.348952, -3.621483>
  rotate -x*90
  texture {
    Black_Metal1
  }
  scale <0.25, 0.25, 0.025>
  rotate <90.0, -90.0, 0.0>
  translate  <-1.0, 0.85, 0.0>
}
#declare TraSwp2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  13  // control points
  <-0.509954, 1.0>,
  <-0.673303, 0.261783>,
  <-0.348952, -3.621483>,
  <-0.004869, -3.647794>,
  <0.357872, -3.641902>,
  <0.703271, 0.234558>,
  <0.5, 1.0>,
  <0.293194, 1.334031>,
  <-0.004977, 1.496852>,
  <-0.28469, 1.323294>,
  <-0.509954, 1.0>,
  <-0.673303, 0.261783>,
  <-0.348952, -3.621483>
  rotate -x*90
  texture {
    Black_Metal1
  }
  scale <0.25, 0.25, 0.025>
  rotate <-90.0, -90.0, 0.0>
  translate  <1.0, 0.82, 0.0>
}
#declare Wheel = union {
  torus { // Torus002
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 0.1
    rotate <-90.0, 0.0, -100.0>
    translate  <0.5, -0.7, -1.35>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Metal
    }
    scale <0.05, 0.11, 0.11>
    translate  <0.5, -0.7, -1.35>
  }
}
#declare Wheel1 = union {
  torus { // Torus3
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 0.1
    rotate <-90.0, 0.0, -100.0>
    translate  <0.5, -0.7, -1.35>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Metal
    }
    scale <0.05, 0.11, 0.11>
    translate  <0.5, -0.7, -1.35>
  }
  translate  -1.0*x
}
#declare Wheel2 = union {
  torus { // Torus4
    1.5, 0.5  rotate -x*90
    texture {
      Rubber
    }
    scale 0.1
    rotate <-90.0, 0.0, -100.0>
    translate  <0.5, -0.7, -1.35>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Silver_Metal
    }
    scale <0.05, 0.11, 0.11>
    translate  <0.5, -0.7, -1.35>
  }
  scale 0.7
  translate  <-0.35, -2.6, 0.4>
}
#declare Landing_Gear = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.0>
    rotate -30.0*y
    translate  <0.5, -0.7, -1.3>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.0>
    rotate 30.0*y
    translate  <-0.5, -0.7, -1.3>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.0>
    rotate -90.0*y
    translate  <0.5, -0.7, -1.3>
  }
  object { Wheel }
  object { Wheel1 }
  object { Wheel2 }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <3.7, -0.7, -0.55>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <1.2, -1.2, -0.55>
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <1.2, -0.15, -0.55>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <2.5, -0.3, -0.55>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <2.5, -1.1, -0.55>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <-3.65, -0.65, -0.55>
  }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <-1.2, -0.15, -0.55>
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <-1.2, -1.2, -0.55>
  }
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <-2.55, -1.1, -0.55>
  }
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    translate  <-2.55, -0.3, -0.55>
  }
  scale <1.75, 1.6, 1.6>
  translate  <0.0, -0.35, 0.75>
}
#declare Fuselage = union {
  cone { // Cone2
    <0,0,0>, 0.4, <0,0,1>, 0.5
    open
    texture {
      Blue_Metal
    }
    scale <-2.0, -1.05, -0.5>
    rotate <-70.0, 0.0, -180.0>
    translate  <0.0, -3.4, -0.09>
  }
  cone { // Cone003
    <0,0,0>, 0.5, <0,0,1>, 0.2
    open
    texture {
      Blue_Metal
    }
    scale <1.0, 0.75, 1.0>
    rotate <80.0, 0.0, 0.0>
    translate  <0.0, -5.15, 0.4>
  }
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      Blue_Metal
    }
    scale <0.2, 0.15, 0.17>
    rotate 80.0*x
    translate  <0.0, -6.1, 0.57>
  }
  object { BzPtch002 }
  object { BzPtch001 }
  cone { // Cone002
    <0,0,0>, 1.0, <0,0,1>, 1.0
    open
    texture {
      Blue_Metal
    }
    scale <-1.0, -0.75, -3.35>
    rotate <90.0, 0.0, -180.0>
    translate  0.25*y
  }
  cone { // Cone001
    <0,0,0>, 0.5, <0,0,1>, 1.0
    open
    texture {
      Blue_Metal
    }
    scale <-1.0, -0.75, -2.15>
    rotate <-80.0, 0.0, -180.0>
    translate  <0.0, -5.15, 0.4>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Silver
    }
    scale <1.0, 0.8, 0.5>
    rotate -90.0*x
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Silver
    }
    scale <0.75, 0.75, 0.5>
    rotate -90.0*x
  }
  torus { // Torus001
    1.5, 0.1  rotate -x*90
    texture {
      Silver
    }
    scale 0.5
    rotate -90.0*x
  }
  torus { // Torus2
    1.5, 0.1  rotate -x*90
    texture {
      Silver
    }
    scale 0.5
    rotate -90.0*x
    translate  0.5*y
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale 0.73
    rotate -90.0*x
    translate  -0.4*y
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1 open
    texture {
      Silver
    }
    scale <0.9, 0.72, 0.45>
    rotate -90.0*x
  }
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      White_Metal
    }
    scale 0.1
    translate  1.2*y
  }
  object { TraSwp001 }
  object { TraSwp2 }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal1
    }
    scale <0.05, 0.05, 1.2>
    rotate -90.0*x
  }
  object { Landing_Gear }
}
#declare Cockpit = difference {
  object { Fuselage }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      Black_Metal1
    }
    scale <0.8, 0.65, 0.6>
    translate  <0.0, -1.25, 0.55>
  }
}
#declare Wings = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <-4.152524, -2.187495>,
  <7.404969, -2.240256>,
  <7.179561, 0.030113>,
  <-4.020364, 0.006459>,
  <-4.152524, -2.187495>,
  <7.404969, -2.240256>,
  <7.179561, 0.030113>
  rotate -x*90
  texture {
    Blue_Metal
  }
  scale <1.0, 0.8, 0.1>
  translate  <-1.55, -0.55, -0.2>
}
#declare Wings1 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <-4.152524, -2.187495>,
  <7.404969, -2.240256>,
  <7.179561, 0.030113>,
  <-4.020364, 0.006459>,
  <-4.152524, -2.187495>,
  <7.404969, -2.240256>,
  <7.179561, 0.030113>
  rotate -x*90
  texture {
    Blue_Metal
  }
  scale <1.0, 0.8, 0.1>
  translate  <-1.55, -0.55, 1.7>
}
#declare Wings2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  7  // control points
  <-4.152524, -2.187495>,
  <7.404969, -2.240256>,
  <7.179561, 0.030113>,
  <-4.020364, 0.006459>,
  <-4.152524, -2.187495>,
  <7.404969, -2.240256>,
  <7.179561, 0.030113>
  rotate -x*90
  texture {
    Blue_Metal
  }
  scale <0.15, 0.25, 0.05>
  rotate 180.0*x
  translate  <-0.25, -6.05, 1.15>
}
union { // BiPlane
  object { Cockpit }
  object { Wings }
  object { Wings1 }
  object { Wings2 }
  sphere { // Sphere005
    <0,0,0>,1
    texture {
      Glass
    }
    hollow
    scale <0.5, 0.5, 30.0>
    rotate -90.0*x
    translate  <0.0, -36.4, 0.0>
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1, 1> ]
      [ 1 color rgbt <1, 1, 1, 0> ]
      [ 2 color rgbt <.7, .7, .7, 1> ]
      [ 3 color rgbt <.7, .7, .7, 0> ]
    }
    samples 10
    scale <0.4, 0.4, 10>
  }
  }
  scale 0.15
  rotate <-10.0, 0.0, 45.0>
  translate  <26.393795, 0.825322, 19.611638>
}


#declare Block = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Glass
    }
    scale <2.0, 2.0, 5.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  5.0*z
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  4.0*z
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  3.0*z
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  2.0*z
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  1.0*z
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -1.0*z
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -2.0*z
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -3.0*z
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -4.0*z
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  0.025*z
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <1.9, 0.0, 0.025>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <1.0, 0.0, 0.025>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <-1.0, 0.0, 0.025>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <-1.9, 0.0, 0.025>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  1.0*y
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  -1.0*y
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  -1.9*y
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  1.9*y
  }
  scale <1.0, 1.0, 1.5>
}
#declare Block1 = union {
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Glass
    }
    scale <2.0, 2.0, 5.0>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  5.0*z
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  4.0*z
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  3.0*z
  }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  2.0*z
  }
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  1.0*z
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
  }
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -1.0*z
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -2.0*z
  }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -3.0*z
  }
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -4.0*z
  }
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  0.025*z
  }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <1.9, 0.0, 0.025>
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <1.0, 0.0, 0.025>
  }
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <-1.0, 0.0, 0.025>
  }
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <-1.9, 0.0, 0.025>
  }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
  }
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  1.0*y
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  -1.0*y
  }
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  -1.9*y
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  1.9*y
  }
  scale <1.0, 1.0, 1.2>
  translate  <1.0, 1.0, -1.5>
}
#declare Block2 = union {
  box { // Cube43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Glass
    }
    scale <2.0, 2.0, 5.0>
  }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  5.0*z
  }
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  4.0*z
  }
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  3.0*z
  }
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  2.0*z
  }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  1.0*z
  }
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
  }
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -1.0*z
  }
  box { // Cube51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -2.0*z
  }
  box { // Cube52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -3.0*z
  }
  box { // Cube53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.05, 2.05, 0.05>
    translate  -4.0*z
  }
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  0.025*z
  }
  box { // Cube55
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <1.9, 0.0, 0.025>
  }
  box { // Cube56
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <1.0, 0.0, 0.025>
  }
  box { // Cube57
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <-1.0, 0.0, 0.025>
  }
  box { // Cube58
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <0.05, 2.05, 5.025>
    translate  <-1.9, 0.0, 0.025>
  }
  box { // Cube59
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
  }
  box { // Cube60
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  1.0*y
  }
  box { // Cube61
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  -1.0*y
  }
  box { // Cube62
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  -1.9*y
  }
  box { // Cube63
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Shiny_Metal
    }
    scale <2.06, 0.05, 5.0>
    translate  1.9*y
  }
  scale <1.0, 1.0, 1.35>
  translate  <0.0, -1.0, -0.75>
}
union { // Black_Building
  object { Block }
  object { Block1 }
  object { Block2 }
  rotate 60.0*z
  translate  <15.186207, -4.48954, 7.5>
}


#declare Ripple = difference {
  box { // Cube64
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 1.0, 3.0>
  }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.85, 1.0, -3.0>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.95, 1.0, -3.0>
  }
}
#declare RippleBlock = union {
  object { Ripple }
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.95, 1.0, -3.0>
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.85, 1.0, -3.0>
  }
}
#declare Ripple1 = difference {
  box { // Cube65
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 1.0, 3.0>
  }
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.85, 1.0, -3.0>
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.95, 1.0, -3.0>
  }
}
#declare RippleBlock1 = union {
  object { Ripple1 }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.95, 1.0, -3.0>
  }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr50
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr51
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr52
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr53
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr54
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr55
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.85, 1.0, -3.0>
  }
  rotate -90.0*z
}
#declare Block3 = union {
  object { RippleBlock }
  object { RippleBlock1 }
}
#declare Windows = union {
  box { // Cube66
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube67
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube68
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube69
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube70
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube71
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube72
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube73
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube74
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube75
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube76
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube77
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube78
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube79
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
}
#declare Windows1 = union {
  box { // Cube80
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube81
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube82
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube83
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube84
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube85
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube86
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube87
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube88
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube89
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube90
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube91
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube92
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube93
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  0.3*x
}
#declare Windows2 = union {
  box { // Cube94
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube95
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube96
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube97
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube98
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube99
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube106
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube107
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  0.6*x
}
#declare Windows3 = union {
  box { // Cube108
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube109
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube110
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube111
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube112
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube113
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube114
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube115
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube116
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube117
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube118
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube119
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube120
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube121
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  0.9*x
}
#declare Windows4 = union {
  box { // Cube122
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube123
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube124
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube125
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube126
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube127
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube128
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube129
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube130
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube131
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube132
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube133
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube134
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube135
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  1.2*x
}
#declare Windows5 = union {
  box { // Cube136
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube137
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube138
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube139
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube140
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube141
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube142
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube143
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube144
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube145
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube146
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube147
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube148
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube149
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  1.5*x
}
#declare WindowCol = union {
  object { Windows }
  object { Windows1 }
  object { Windows2 }
  object { Windows3 }
  object { Windows4 }
  object { Windows5 }
  translate  0.1*x
}
#declare Windows6 = union {
  box { // Cube150
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube151
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube152
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube153
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube154
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube155
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube156
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube157
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube158
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube159
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube160
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube161
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube162
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube163
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
}
#declare Windows7 = union {
  box { // Cube164
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube165
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube166
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube167
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube168
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube169
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube170
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube171
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube172
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube173
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube174
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube175
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube176
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube177
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  0.3*x
}
#declare Windows8 = union {
  box { // Cube178
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube179
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube180
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube181
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube182
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube183
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube184
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube185
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube186
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube187
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube188
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube189
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube190
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube191
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  0.6*x
}
#declare Windows9 = union {
  box { // Cube192
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube193
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube194
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube195
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube196
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube197
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube198
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube199
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube200
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube201
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube202
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube203
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube204
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube205
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  0.9*x
}
#declare Windows10 = union {
  box { // Cube206
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube207
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube208
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube209
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube210
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube211
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube212
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube213
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube214
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube215
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube216
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube217
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube218
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube219
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  1.2*x
}
#declare Windows11 = union {
  box { // Cube220
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.8>
  }
  box { // Cube221
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.4>
  }
  box { // Cube222
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 2.0>
  }
  box { // Cube223
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.6>
  }
  box { // Cube224
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 1.2>
  }
  box { // Cube225
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.8>
  }
  box { // Cube226
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.4>
  }
  box { // Cube227
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, 0.0>
  }
  box { // Cube228
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.4>
  }
  box { // Cube229
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -0.8>
  }
  box { // Cube230
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.2>
  }
  box { // Cube231
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -1.6>
  }
  box { // Cube232
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.0>
  }
  box { // Cube233
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.84, 1.0, -2.4>
  }
  translate  1.5*x
}
#declare WindowCol1 = union {
  object { Windows6 }
  object { Windows7 }
  object { Windows8 }
  object { Windows9 }
  object { Windows10 }
  object { Windows11 }
  rotate -90.0*z
  translate  -0.1*y
}
#declare WindowedBank = difference {
  object { Block3 }
  object { WindowCol }
  object { WindowCol1 }
}
#declare Ripple2 = difference {
  box { // Cube234
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 1.0, 3.0>
  }
  cylinder { // Cylndr56
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.85, 1.0, -3.0>
  }
  cylinder { // Cylndr57
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr58
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr59
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr60
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr61
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr62
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr63
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr64
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr65
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.95, 1.0, -3.0>
  }
}
#declare RippleBlock2 = union {
  object { Ripple2 }
  cylinder { // Cylndr66
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.95, 1.0, -3.0>
  }
  cylinder { // Cylndr67
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr68
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr69
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr70
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr71
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr72
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr73
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr74
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr75
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.85, 1.0, -3.0>
  }
}
#declare Ripple3 = difference {
  box { // Cube235
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 1.0, 3.0>
  }
  cylinder { // Cylndr76
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.85, 1.0, -3.0>
  }
  cylinder { // Cylndr77
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr78
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr79
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr80
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr81
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr82
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr83
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr84
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr85
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.95, 1.0, -3.0>
  }
}
#declare RippleBlock3 = union {
  object { Ripple3 }
  cylinder { // Cylndr86
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.95, 1.0, -3.0>
  }
  cylinder { // Cylndr87
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr88
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr89
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr90
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr91
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr92
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr93
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr94
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr95
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.85, 1.0, -3.0>
  }
  rotate -90.0*z
}
#declare Block4 = union {
  object { RippleBlock2 }
  object { RippleBlock3 }
  scale <0.7, 0.7, 0.5>
  translate  4.5*z
}
#declare Windows20 = union {
  box { // Cube236
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube237
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube238
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube239
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube240
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube241
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube242
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
}
#declare Windows21 = union {
  box { // Cube243
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube244
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube245
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube246
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube247
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube248
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube249
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
  translate  0.85*x
}
#declare Windows22 = union {
  box { // Cube250
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube251
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube252
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube253
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube254
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube255
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube256
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
  translate  0.566*x
}
#declare Windows23 = union {
  box { // Cube257
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube258
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube259
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube260
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube261
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube262
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube263
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
  translate  0.283*x
}
#declare WindowedBank3 = union {
  object { Windows20 }
  object { Windows21 }
  object { Windows22 }
  object { Windows23 }
}
#declare Windows24 = union {
  box { // Cube264
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube265
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube266
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube267
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube268
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube269
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube270
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
}
#declare Windows25 = union {
  box { // Cube271
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube272
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube273
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube274
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube275
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube276
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube277
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
  translate  0.85*x
}
#declare Windows26 = union {
  box { // Cube278
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube279
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube280
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube281
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube282
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube283
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube284
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
  translate  0.566*x
}
#declare Windows27 = union {
  box { // Cube285
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.3>
  }
  box { // Cube286
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 3.7>
  }
  box { // Cube287
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.2>
  }
  box { // Cube288
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 4.6>
  }
  box { // Cube289
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.0>
  }
  box { // Cube290
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.4>
  }
  box { // Cube291
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.4, 0.7, 5.8>
  }
  translate  0.283*x
}
#declare WindowedBank4 = union {
  object { Windows24 }
  object { Windows25 }
  object { Windows26 }
  object { Windows27 }
  rotate -90.0*z
  translate  0.04*y
}
#declare WindowedBank1 = difference {
  object { Block4 }
  object { WindowedBank3 }
  object { WindowedBank4 }
}
#declare Ripple4 = difference {
  box { // Cube292
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 1.0, 3.0>
  }
  cylinder { // Cylndr96
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.85, 1.0, -3.0>
  }
  cylinder { // Cylndr97
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr98
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr99
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.95, 1.0, -3.0>
  }
}
#declare RippleBlock4 = union {
  object { Ripple4 }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.95, 1.0, -3.0>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.85, 1.0, -3.0>
  }
}
#declare Ripple5 = difference {
  box { // Cube293
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 1.0, 3.0>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.85, 1.0, -3.0>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.95, 1.0, -3.0>
  }
}
#declare RippleBlock5 = union {
  object { Ripple5 }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.95, 1.0, -3.0>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.75, 1.0, -3.0>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.55, 1.0, -3.0>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.35, 1.0, -3.0>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <-0.15, 1.0, -3.0>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.05, 1.0, -3.0>
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.25, 1.0, -3.0>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.45, 1.0, -3.0>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.65, 1.0, -3.0>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    texture {
      Cement2
    }
    scale <0.05, 0.05, 6.0>
    translate  <0.85, 1.0, -3.0>
  }
  rotate -90.0*z
}
#declare Block5 = union {
  object { RippleBlock4 }
  object { RippleBlock5 }
  scale <0.5, 0.5, 0.1>
  translate  6.3*z
}
#declare WindowedBank2 = difference {
  object { Block5 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <-0.116957, 0.503948, 6.302246>
  }
  box { // Cube294
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    translate  <0.166002, 0.50643, 6.302246>
  }
  box { // Cube295
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    rotate -90.0*z
    translate  <0.503383, 0.157409, 6.302246>
  }
  box { // Cube296
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement4
    }
    scale <0.075, 0.1, 0.1>
    rotate -90.0*z
    translate  <0.502571, -0.126528, 6.302246>
  }
}
//
// Include file contains 'RotSwp001'
//
#include "biplane.in1"
#declare RotSwp001 = object {
  RotSwp001_Raw
  texture {
    Cement4
  }
  scale <0.25, 0.25, 0.7>
  translate  7.3*z
}
#declare ConeTop = difference {
  object { RotSwp001 }
  box { // Cube297
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate -5.0*x
    translate  <0.0, 0.1, 8.1>
  }
  box { // Cube298
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate <10.0, 0.0, -90.0>
    translate  <-0.3, 0.0, 8.1>
  }
  box { // Cube299
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate <5.0, 0.0, -90.0>
    translate  <-0.1, 0.0, 8.1>
  }
  box { // Cube300
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate <-10.0, 0.0, -90.0>
    translate  <0.3, 0.0, 8.1>
  }
  box { // Cube301
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate <-5.0, 0.0, -90.0>
    translate  <0.1, 0.0, 8.1>
  }
  box { // Cube302
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate 10.0*x
    translate  <0.0, -0.3, 8.1>
  }
  box { // Cube303
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate 5.0*x
    translate  <0.0, -0.1, 8.1>
  }
  box { // Cube304
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate -10.0*x
    translate  <0.0, 0.3, 8.1>
  }
  box { // Cube305
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate <-30.0, 0.0, -90.0>
    translate  <0.75248, 0.0, 7.90831>
  }
  box { // Cube306
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate <30.0, 0.0, -90.0>
    translate  <-0.772678, 0.0, 7.907087>
  }
  box { // Cube307
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate 30.0*x
    translate  <0.0, -0.74884, 7.910719>
  }
  box { // Cube308
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement2
    }
    scale <1.0, 0.02, 1.5>
    rotate -30.0*x
    translate  <0.0, 0.74619, 7.906947>
  }
}
//
// Include file contains 'RotSwp2'
//
#include "biplane.in2"
#declare RotSwp2 = object {
  RotSwp2_Raw
  texture {
    Cement3
  }
  scale <0.225, 0.225, 0.675>
  translate  7.275*z
}
union { // SkyScraper
  object { WindowedBank }
  object { WindowedBank1 }
  object { WindowedBank2 }
  object { ConeTop }
  object { RotSwp2 }
  box { // Cube309
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PurpleGlass
    }
    scale <0.949, 0.949, 3.0>
  }
  box { // Cube310
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PurpleGlass
    }
    scale <0.66, 0.66, 1.5>
    translate  4.5*z
  }
  box { // Cube311
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PurpleGlass
    }
    scale <0.474, 0.474, 0.3>
    translate  6.3*z
  }
  scale 1.5
  rotate -190.0*z
  translate  <9.0, 3.6, 3.0>
}


#include "C:\GRAPHICS\MORAY\POVSCN\caness.inc"

#declare ttf_00000_Ref = object {
  ttf_00000
  translate  <0.310368, 0.361768, 0.5>
}
#declare ttf_00001_Ref = object {
  ttf_00001
  translate  <0.956787, 0.247341, 0.5>
}
#declare ttf_00002_Ref = object {
  ttf_00002
  translate  <1.534498, 0.358674, 0.5>
}
#declare ttf_00003_Ref = object {
  ttf_00003
  translate  <2.087646, 0.256462, 0.5>
}
#declare ttf_00004_Ref = object {
  ttf_00004
  translate  <2.581583, 0.281868, 0.5>
}
#declare ttf_00005_Ref = object {
  ttf_00005
  translate  <3.081583, 0.281868, 0.5>
}
#declare ttf_00007_Ref = object {
  ttf_00007
  translate  <3.976807, 0.357959, 0.5>
}
#declare ttf_00008_Ref = object {
  ttf_00008
  translate  <4.625244, 0.247341, 0.5>
}
#declare ttf_00009_Ref = object {
  ttf_00009
  translate  <5.058024, 0.25411, 0.5>
}
#declare ttf_00010_Ref = object {
  ttf_00010
  translate  <5.285156, 0.46228, 0.5>
}
#declare ttf_00011_Ref = object {
  ttf_00011
  translate  <5.672758, 0.261794, 0.5>
}
#declare ttf_00012_Ref = object {
  ttf_00012
  translate  <6.259108, 0.358674, 0.5>
}
#declare ttf_00013_Ref = object {
  ttf_00013
  translate  <6.793701, 0.247341, 0.5>
}
#declare ttf_00014_Ref = object {
  ttf_00014
  translate  <7.17334, 0.35791, 0.5>
}
union { // Caness
  object { ttf_00000_Ref }
  object { ttf_00001_Ref }
  object { ttf_00002_Ref }
  object { ttf_00003_Ref }
  object { ttf_00004_Ref }
  object { ttf_00005_Ref }
  object { ttf_00007_Ref }
  object { ttf_00008_Ref }
  object { ttf_00009_Ref }
  object { ttf_00010_Ref }
  object { ttf_00011_Ref }
  object { ttf_00012_Ref }
  object { ttf_00013_Ref }
  object { ttf_00014_Ref }
  texture {
    Green_Marble
  }
  scale <0.4, 0.4, 0.2>
  rotate <90.0, 0.0, -110.0>
  translate  <3.13132, -0.887176, 9.613133>
}




sphere { // Sphere2
  <0,0,0>,1
  texture {
    Blue_Sky4
  }
  scale 1000.0
}


#declare WingsPGlass = union {
  box { // Building
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Mirror_Window
    }
    scale <1.51, 1.51, 6.0>
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    translate  <1.5, 0.0, -34.0>
  }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    translate  <-1.5, 0.0, -34.0>
  }
  cone { // Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    translate  <-0.5, 0.0, -34.0>
  }
  cone { // Cone7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    translate  <0.5, 0.0, -34.0>
  }
  cone { // Cone9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    rotate -90.0*z
    translate  <0.0, 1.5, -34.0>
  }
  cone { // Cone10
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    rotate -90.0*z
    translate  <0.0, -1.5, -34.0>
  }
  cone { // Cone12
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    rotate -90.0*z
    translate  <0.0, -0.5, -34.0>
  }
  cone { // Cone13
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Cement1
    }
    scale <0.005, 2.3, 40.0>
    rotate -90.0*z
    translate  <0.0, 0.5, -34.0>
  }
  box { // Cube312
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Cement1
    }
    scale <1.3, 1.3, 1.0>
    translate  5.7*z
  }
}
#declare Trim = union {
  box { // Spacer1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -5.5*z
  }
  box { // Spacer2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -5.0*z
  }
  box { // Spacer3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -4.5*z
  }
  box { // Spacer4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -4.0*z
  }
  box { // Spacer5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -3.5*z
  }
  box { // Spacer6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -3.0*z
  }
  box { // Spacer7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -2.5*z
  }
  box { // Spacer8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -2.0*z
  }
  box { // Spacer9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -1.5*z
  }
  box { // Spacer10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -1.0*z
  }
  box { // Spacer11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  -0.5*z
  }
  box { // Spacer12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
  }
  box { // Spacer13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  0.5*z
  }
  box { // Spacer14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  1.0*z
  }
  box { // Spacer15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  1.5*z
  }
  box { // Spacer16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  2.0*z
  }
  box { // Spacer17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  2.5*z
  }
  box { // Spacer18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  3.0*z
  }
  box { // Spacer19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  3.5*z
  }
  box { // Spacer20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  4.0*z
  }
  box { // Spacer21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  4.5*z
  }
  box { // Spacer22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  5.0*z
  }
  box { // Spacer23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Panelling
    }
    scale <1.511, 1.511, 0.02>
    translate  5.5*z
  }
}
union { // Winged_Building
  object { WingsPGlass }
  object { Trim }
  rotate 10.0*z
  translate  <19.389824, 3.472632, 6.0>
}


#declare Outer_Cement = union {
  box { // Cube313
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <-0.901256, 0.899444, 0.0>
  }
  box { // Cube314
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <0.89725, 0.901168, 0.0>
  }
  box { // Cube315
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <0.898875, -0.902982, 0.0>
  }
  box { // Cube316
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <-0.901204, -0.899661, 0.0>
  }
  box { // Cube317
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <1.05, 1.05, 0.3>
    translate  <-0.00238, 0.0, 4.205404>
  }
  box { // Cube318
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <0.896885, 0.001712, 0.0>
  }
  box { // Cube319
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <-0.000607, -0.901859, 0.0>
  }
  box { // Cube320
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <-0.000607, 0.901133, 0.0>
  }
  box { // Cube321
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.15, 0.15, 4.5>
    translate  <-0.903381, 0.001263, 0.0>
  }
  box { // Cube322
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <-0.000607, 0.901133, 0.0>
  }
  box { // Cube323
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <0.89725, 0.901168, 0.0>
  }
  box { // Cube324
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <0.896885, 0.001712, 0.0>
  }
  box { // Cube325
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <0.898875, -0.902982, 0.0>
  }
  box { // Cube326
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <-0.000607, -0.901859, 0.0>
  }
  box { // Cube327
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <-0.901204, -0.899661, 0.0>
  }
  box { // Cube328
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <-0.903381, 0.001263, 0.0>
  }
  box { // Cube329
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <0.145, 0.145, 4.5>
    translate  <-0.901256, 0.899444, 0.0>
  }
}
#declare CementWGaps = difference {
  object { Outer_Cement }
  box { // Divide
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  3.1*z
  }
  box { // Divide1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  2.1*z
  }
  box { // Divide2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  1.1*z
  }
  box { // Divide3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  0.1*z
  }
  box { // Divide4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  -0.9*z
  }
  box { // Divide5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  -1.9*z
  }
  box { // Divide6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.4, 1.4, 0.01>
    translate  -2.9*z
  }
}
#declare TraSwp3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -1.0>,
  <0.0, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.5>,
  <1.0, 0.0>,
  <1.0, 0.5>,
  <0.5, 1.0>,
  <0.0, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.5>,
  <-1.0, 0.0>,
  <-1.0, -0.5>,
  <-0.5, -1.0>
  rotate -x*90
  texture {
    White_Rock
  }
  scale <1.6, 1.6, 0.6>
  translate  -3.3*z
}
#declare TraSwp4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -1.0>,
  <0.0, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.5>,
  <1.0, 0.0>,
  <1.0, 0.5>,
  <0.5, 1.0>,
  <0.0, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.5>,
  <-1.0, 0.0>,
  <-1.0, -0.5>,
  <-0.5, -1.0>
  rotate -x*90
  texture {
    White_Rock
  }
  scale <1.5, 1.5, 0.6>
  translate  -3.0*z
}
#declare TraSwp5 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-0.5, -1.0>,
  <0.0, -1.0>,
  <0.5, -1.0>,
  <1.0, -0.5>,
  <1.0, 0.0>,
  <1.0, 0.5>,
  <0.5, 1.0>,
  <0.0, 1.0>,
  <-0.5, 1.0>,
  <-1.0, 0.5>,
  <-1.0, 0.0>,
  <-1.0, -0.5>,
  <-0.5, -1.0>
  rotate -x*90
  texture {
    White_Rock
  }
  scale <1.4, 1.4, 0.4>
  translate  -2.7*z
}
#declare Rail = difference {
  object { TraSwp4 }
  object { TraSwp5 }
}
#declare MirrorLamp1 = union {
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <-0.725243, 1.444029, -2.407345>
}
#declare MirrorLamp2 = union {
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <0.727798, 1.444029, -2.407345>
}
#declare MirrorLamp3 = union {
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <-0.00296, 1.445921, -2.407345>
}
#declare MirrorLamp4 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <1.449542, 0.725643, -2.407345>
}
#declare MirrorLamp5 = union {
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <1.101404, 1.076472, -2.407345>
}
#declare MirrorLamp6 = union {
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere8
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <1.446426, -0.726666, -2.407345>
}
#declare MirrorLamp7 = union {
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.01, 0.01, 0.2>
  }
  sphere { // Sphere9
    <0,0,0>,1
    texture {
      Frosted_Glass
    }
    scale 0.04
    translate  0.22*z
  }
  translate  <1.450715, 0.004265, -2.407345>
}
#declare Lobby_Door_Win = difference {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.641925, -4.094663>
  }
  box { // Cube351
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.15626, -4.094917>
  }
  box { // Cube352
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <0.1, 0.5, 0.4>
    translate  <1.019598, 0.394154, -4.088891>
  }
  scale <1.0, 0.7, 0.7>
  translate  <-0.010158, 0.218925, -1.355572>
}
#declare Lobby_Door_Wi1 = difference {
  box { // Cube353
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.641925, -4.094663>
  }
  box { // Cube354
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.15626, -4.094917>
  }
  box { // Cube355
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <0.1, 0.5, 0.4>
    rotate <0.0, 0.0, 0.0>
    translate  <1.019598, 0.394154, -4.088891>
  }
  scale <1.0, 0.7, 0.7>
  rotate -90.0*z
  translate  <0.256872, 2.029408, -1.355342>
}
#declare Lobby_Door_Wi3 = difference {
  box { // Cube356
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.641925, -4.094663>
  }
  box { // Cube357
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.15626, -4.094917>
  }
  box { // Cube358
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <0.1, 0.5, 0.4>
    translate  <1.019598, 0.394154, -4.088891>
  }
  scale <1.0, 0.7, 0.7>
  translate  <-0.009976, -0.667007, -1.355572>
}
#declare Lobby_Door_Wi2 = difference {
  box { // Cube359
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.641925, -4.094663>
  }
  box { // Cube360
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.2, 0.2, 0.36>
    translate  <1.003474, 0.15626, -4.094917>
  }
  box { // Cube361
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <0.1, 0.5, 0.4>
    rotate <0.0, 0.0, 0.0>
    translate  <1.019598, 0.394154, -4.088891>
  }
  scale <1.0, 0.7, 0.7>
  rotate -90.0*z
  translate  <-0.623267, 2.029408, -1.355931>
}
union { // Mirror_Window_1
  object { CementWGaps }
  box { // Cube330
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  2.9*z
  }
  box { // Cube331
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  2.4*z
  }
  box { // Cube332
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  1.9*z
  }
  box { // Cube333
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  1.4*z
  }
  box { // Cube334
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  0.9*z
  }
  box { // Cube335
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  0.4*z
  }
  box { // Cube336
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -0.1*z
  }
  box { // Cube337
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -0.6*z
  }
  box { // Cube338
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -1.1*z
  }
  box { // Cube339
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -1.6*z
  }
  box { // Cube340
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -2.6*z
  }
  box { // Cube341
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -3.1*z
  }
  box { // Cube342
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -3.6*z
  }
  box { // Cube343
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -2.1*z
  }
  box { // Cube344
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  -4.1*z
  }
  box { // Cube345
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 0.01, 4.5>
    translate  0.45*y
  }
  box { // Cube346
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 0.01, 4.5>
    translate  -0.45*y
  }
  box { // Cube347
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <0.01, 1.01, 4.5>
    translate  0.45*x
  }
  box { // Cube348
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <0.01, 1.01, 4.5>
    translate  -0.45*x
  }
  box { // Cube349
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Smooth_White_Metal_1
    }
    scale <1.01, 1.01, 0.01>
    translate  3.4*z
  }
  box { // Mirror_Windows
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <1.0, 1.0, 4.5>
  }
  object { TraSwp3 }
  object { Rail }
  object { MirrorLamp1 }
  object { MirrorLamp2 }
  object { MirrorLamp3 }
  object { MirrorLamp4 }
  object { MirrorLamp5 }
  object { MirrorLamp6 }
  object { MirrorLamp7 }
  box { // Awning
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Grey_Dull_Metal
    }
    scale <1.7, 0.7, 0.1>
    rotate -45.0*z
    translate  <0.897627, 0.892337, -3.4>
  }
  box { // Cube350
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Rock
    }
    scale <1.1, 1.1, 0.7>
    translate  -3.8*z
  }
  object { Lobby_Door_Win }
  object { Lobby_Door_Wi1 }
  object { Lobby_Door_Wi3 }
  object { Lobby_Door_Wi2 }
  plane { // Plane001
    z,0
    texture {
      Bumpy_Wall
    }
    translate  <0.0, -1.163319, -4.498165>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.1, 0.35, 0.28>
    translate  <1.005302, 0.49544, -4.21694>
  }
  box { // Cube362
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.1, 0.35, 0.28>
    translate  <1.008092, -0.395587, -4.218945>
  }
  box { // Cube363
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.1, 0.35, 0.28>
    rotate -90.0*z
    translate  <0.533348, 1.004394, -4.224824>
  }
  box { // Cube364
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Glass
    }
    scale <0.1, 0.35, 0.28>
    rotate -90.0*z
    translate  <-0.349296, 1.007247, -4.218945>
  }
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.05, 0.05, 1.0>
    translate  <0.212884, 2.357091, -4.500627>
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.05, 0.05, 1.0>
    translate  <2.384378, 0.185597, -4.500627>
  }
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.05, 0.05, 1.0>
    translate  <0.767263, 1.80672, -4.500627>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Dull_Metal
    }
    scale <0.05, 0.05, 1.0>
    translate  <1.844158, 0.757438, -4.500627>
  }
  rotate -135.0*z
  translate  <-1.149558, 4.445602, 4.5>
}


#declare Window = union {
  box { // Cube367
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube368
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
}
#declare Window1 = union {
  box { // Cube369
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube370
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  translate  0.3*x
}
#declare Window2 = union {
  box { // Cube372
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube373
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 1.5, 0.0>
}
#declare Window3 = union {
  box { // Cube374
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube375
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 1.2, 0.0>
}
#declare Window4 = union {
  box { // Cube376
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube377
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 0.9, 0.0>
}
#declare Window5 = union {
  box { // Cube378
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube379
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 0.6, 0.0>
}
#declare Window6 = union {
  box { // Cube380
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube381
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 0.3, 0.0>
}
#declare Window7 = union {
  box { // Cube382
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube383
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  0.54*x
}
#declare Window8 = union {
  box { // Cube384
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube385
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -0.3, 0.0>
}
#declare Window9 = union {
  box { // Cube386
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube387
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -0.6, 0.0>
}
#declare Window10 = union {
  box { // Cube388
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube389
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -0.9, 0.0>
}
#declare Window11 = union {
  box { // Cube390
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube391
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -1.2, 0.0>
}
#declare Window12 = union {
  box { // Cube392
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube393
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -1.5, 0.0>
}
#declare Window13 = union {
  box { // Cube394
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube395
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -1.8, 0.0>
}
#declare Wing1 = union {
  box { // Cube371
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Cement
    }
    scale <0.5, 2.0, 5.0>
    translate  2.0*x
  }
  object { Window2 }
  object { Window3 }
  object { Window4 }
  object { Window5 }
  object { Window6 }
  object { Window7 }
  object { Window8 }
  object { Window9 }
  object { Window10 }
  object { Window11 }
  object { Window12 }
  object { Window13 }
  rotate 45.0*z
  translate  <0.6, -1.4, 0.0>
}
#declare Window14 = union {
  box { // Cube397
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube398
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 1.5, 0.0>
}
#declare Window15 = union {
  box { // Cube399
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube400
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 1.2, 0.0>
}
#declare Window16 = union {
  box { // Cube401
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube402
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 0.9, 0.0>
}
#declare Window17 = union {
  box { // Cube403
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube404
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 0.6, 0.0>
}
#declare Window18 = union {
  box { // Cube405
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube406
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, 0.3, 0.0>
}
#declare Window19 = union {
  box { // Cube407
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube408
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  0.54*x
}
#declare Window20 = union {
  box { // Cube409
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube410
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -0.3, 0.0>
}
#declare Window21 = union {
  box { // Cube411
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube412
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -0.6, 0.0>
}
#declare Window22 = union {
  box { // Cube413
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube414
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -0.9, 0.0>
}
#declare Window23 = union {
  box { // Cube415
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube416
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -1.2, 0.0>
}
#declare Window24 = union {
  box { // Cube417
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube418
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -1.5, 0.0>
}
#declare Window25 = union {
  box { // Cube419
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Mirrored_Window
    }
    scale <0.1, 0.1, 4.5>
    translate  <-0.15, 1.059, 0.0>
  }
  box { // Cube420
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Metal
    }
    scale <0.11, 0.1, 4.51>
    translate  <-0.15, 1.0595, 0.0>
  }
  rotate -90.0*z
  translate  <0.54, -1.8, 0.0>
}
#declare Wing2 = union {
  box { // Cube396
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Cement
    }
    scale <0.5, 2.0, 5.0>
    translate  2.0*x
  }
  object { Window14 }
  object { Window15 }
  object { Window16 }
  object { Window17 }
  object { Window18 }
  object { Window19 }
  object { Window20 }
  object { Window21 }
  object { Window22 }
  object { Window23 }
  object { Window24 }
  object { Window25 }
  rotate 135.0*z
  translate  <-0.6, -1.4, 0.0>
}
#declare BzPtch2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054276, -0.042207, 0.000000>, <0.424275, 0.141929, 0.000000>, <0.729647, -0.042207, -0.044272>, <1.113320, -0.073327, -0.044272>, 
      <-0.008260, 0.465328, 0.000000>, <0.424275, 0.649463, 0.000000>, <0.729647, 0.465328, 0.044272>, <1.070816, 0.502214, 0.044272>, 
      <-0.008260, 0.486431, 0.000000>, <0.424275, 0.670567, 0.000000>, <0.729647, 0.486431, 0.044272>, <1.070816, 0.523317, 0.044272>, 
      <-0.054276, 1.000000, 0.000000>, <0.424275, 1.184136, 0.000000>, <0.729647, 1.000000, -0.044272>, <1.070816, 1.036886, -0.044272>
    }
  }
  texture {
    US_Flag
  }
  scale 0.4
  rotate <90.0, 0.0, -80.0>
  translate  <0.002138, 0.016581, -2.912684>
}
#declare Flagpole = union {
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal
    }
    scale <0.02, 0.02, 1.4>
    translate  <0.0, 0.056072, -3.902835>
  }
  object { BzPtch2 }
}
#declare BzPtch3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054276, -0.042207, 0.000000>, <0.433537, -0.209375, -0.063717>, <0.729647, -0.042207, -0.044272>, <1.036812, 0.124961, -0.044272>, 
      <-0.008260, 0.465328, 0.000000>, <0.433537, 0.298160, 0.000000>, <0.729647, 0.465328, 0.170747>, <1.036812, 0.632496, 0.170747>, 
      <-0.008260, 0.486431, 0.000000>, <0.433537, 0.319263, 0.000000>, <0.729647, 0.486431, 0.170747>, <1.036812, 0.653599, 0.170747>, 
      <-0.054276, 1.000000, 0.000000>, <0.433537, 0.832832, 0.000000>, <0.729647, 1.000000, -0.044272>, <1.036812, 1.167168, 0.061922>
    }
  }
  texture {
    Cand_Flag
  }
  scale 0.4
  rotate <90.0, 0.0, -80.0>
  translate  <0.002138, 0.016581, -2.912684>
}
#declare Flagpole1 = union {
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal
    }
    scale <0.02, 0.02, 1.4>
    translate  <0.0, 0.056072, -3.902835>
  }
  object { BzPtch3 }
  translate  <-0.363532, -0.007419, 0.0>
}
#declare BzPtch4 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054276, -0.042207, 0.088813>, <0.408264, 0.271592, 0.088813>, <0.713635, -0.226340, 0.044541>, <1.060830, 0.004255, 0.044541>, 
      <0.071095, 0.442655, -0.048443>, <0.487619, 0.748380, 0.040370>, <0.792990, 0.250448, 0.084642>, <1.140185, 0.489117, -0.004171>, 
      <0.071095, 0.463758, -0.048443>, <0.487619, 0.769483, 0.040370>, <0.792990, 0.271551, 0.084642>, <1.140185, 0.510220, -0.004171>, 
      <-0.054276, 1.000000, 0.056517>, <0.408264, 1.313799, 0.056517>, <0.713635, 0.815867, 0.012245>, <1.060830, 1.046462, 0.012245>
    }
  }
  texture {
    Mex_Flag
  }
  scale 0.4
  rotate <90.0, 0.0, -90.0>
  translate  <0.023619, 0.025174, -2.912684>
}
#declare Flagpole2 = union {
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal
    }
    scale <0.02, 0.02, 1.4>
    translate  <0.0, 0.056072, -3.902835>
  }
  object { BzPtch4 }
  translate  <0.360047, -0.007296, 0.0>
}
#declare BzPtch5 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054276, -0.042207, 0.000000>, <0.433537, -0.209375, -0.063717>, <0.715807, 0.289955, -0.044272>, <1.036812, 0.124961, -0.044272>, 
      <-0.008260, 0.465328, 0.000000>, <0.433537, 0.298160, 0.000000>, <0.715807, 0.797490, 0.044272>, <1.036812, 0.632496, 0.044272>, 
      <-0.008260, 0.486431, 0.000000>, <0.433537, 0.319263, 0.000000>, <0.715807, 0.818593, 0.044272>, <1.036812, 0.653599, 0.044272>, 
      <-0.054276, 1.000000, 0.000000>, <0.433537, 0.832832, 0.000000>, <0.715807, 1.332162, -0.044272>, <1.036812, 1.167168, 0.061922>
    }
  }
  texture {
    Cuba_Flag
  }
  scale 0.4
  rotate <90.0, 0.0, -80.0>
  translate  <0.002138, 0.016581, -2.912684>
}
#declare Flagpole3 = union {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal
    }
    scale <0.02, 0.02, 1.4>
    translate  <0.0, 0.056072, -3.902835>
  }
  object { BzPtch5 }
  translate  <0.713114, -0.008159, 0.0>
}
#declare BzPtch6 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.054276, -0.042207, 0.088813>, <0.424275, 0.031418, 0.088813>, <0.721531, -0.318133, 0.086699>, <1.036812, -0.115832, 0.044541>, 
      <0.071095, 0.442655, -0.048443>, <0.503630, 0.508206, 0.040370>, <0.800886, 0.158655, 0.126800>, <1.116167, 0.369030, -0.004171>, 
      <0.071095, 0.463758, -0.048443>, <0.503630, 0.529309, 0.040370>, <0.800886, 0.179759, 0.126800>, <1.116167, 0.390133, -0.004171>, 
      <-0.054276, 1.000000, 0.056517>, <0.424275, 1.073625, 0.056517>, <0.721531, 0.724074, 0.054403>, <1.036812, 0.926375, 0.012245>
    }
  }
  texture {
    Jam_Flag
  }
  scale 0.4
  rotate <90.0, 0.0, -75.0>
  translate  <0.023619, 0.025174, -2.912684>
}
#declare Flagpole4 = union {
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Metal
    }
    scale <0.02, 0.02, 1.4>
    translate  <0.0, 0.056072, -3.902835>
  }
  object { BzPtch6 }
  translate  <-0.689951, -0.029324, 0.0>
}
union { // V_Building
  box { // Cube365
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Cement
    }
    scale <1.5, 0.5, 0.1>
    translate  <0.0, 0.5, -4.0>
  }
  box { // Cube366
    <-1, -1, -1>, <1, 1, 1>
    texture {
      White_Cement
    }
    scale <0.94, 0.4, 5.0>
    translate  <-0.000648, 1.360661, 0.0>
  }
  object { Window }
  object { Window1 }
  object { Wing1 }
  object { Wing2 }
  object { Flagpole }
  object { Flagpole1 }
  object { Flagpole2 }
  object { Flagpole3 }
  object { Flagpole4 }
  rotate -155.0*z
  translate  <1.0, -3.5, 5.0>
}



// ********  OBJECTS  *******

#declare Bend4 = difference {
  torus { // Torus60
    1.5, 0.14  rotate -x*90
    texture {
      Black_Cast_Iron
    }
    scale <3.0, 3.0, 3.5>
    rotate -90.0*x
    translate  <-5.002083, 0.0, -1.194055>
  }
  box { // Chop4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Cast_Iron
    }
    scale 9.0
    translate  <-7.58343, 0.0, -10.192638>
  }
}
#declare BzPtch33 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf448 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf449 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf450 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf451 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf452 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf453 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf454 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf455 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf456 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf457 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf458 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf459 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf460 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf461 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine32 = union {
  object { BzPtch33 }
  object { Leaf448 }
  object { Leaf449 }
  object { Leaf450 }
  object { Leaf451 }
  object { Leaf452 }
  object { Leaf453 }
  object { Leaf454 }
  object { Leaf455 }
  object { Leaf456 }
  object { Leaf457 }
  object { Leaf458 }
  object { Leaf459 }
  object { Leaf460 }
  object { Leaf461 }
}
#declare BzPtch34 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf462 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf463 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf464 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf465 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf466 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf467 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf468 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf469 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf470 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf471 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf472 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf473 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf474 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf475 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine33 = union {
  object { BzPtch34 }
  object { Leaf462 }
  object { Leaf463 }
  object { Leaf464 }
  object { Leaf465 }
  object { Leaf466 }
  object { Leaf467 }
  object { Leaf468 }
  object { Leaf469 }
  object { Leaf470 }
  object { Leaf471 }
  object { Leaf472 }
  object { Leaf473 }
  object { Leaf474 }
  object { Leaf475 }
  rotate -180.0*z
  translate  <-1.0801, 0.061138, 0.0>
}
#declare BzPtch35 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf476 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf477 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf478 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf479 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf480 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf481 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf482 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf483 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf484 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf485 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf486 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf487 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf488 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf489 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine34 = union {
  object { BzPtch35 }
  object { Leaf476 }
  object { Leaf477 }
  object { Leaf478 }
  object { Leaf479 }
  object { Leaf480 }
  object { Leaf481 }
  object { Leaf482 }
  object { Leaf483 }
  object { Leaf484 }
  object { Leaf485 }
  object { Leaf486 }
  object { Leaf487 }
  object { Leaf488 }
  object { Leaf489 }
  rotate -90.0*z
  translate  <-0.676403, -0.4138, 0.0>
}
#declare BzPtch36 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf490 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf491 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf492 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf493 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf494 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf495 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf496 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf497 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf498 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf499 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf500 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf501 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf502 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf503 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine35 = union {
  object { BzPtch36 }
  object { Leaf490 }
  object { Leaf491 }
  object { Leaf492 }
  object { Leaf493 }
  object { Leaf494 }
  object { Leaf495 }
  object { Leaf496 }
  object { Leaf497 }
  object { Leaf498 }
  object { Leaf499 }
  object { Leaf500 }
  object { Leaf501 }
  object { Leaf502 }
  object { Leaf503 }
  rotate 90.0*z
  translate  <-0.486428, 0.512328, 0.0>
}
#declare BzPtch37 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf504 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf505 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf506 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf507 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf508 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf509 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf510 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf511 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf512 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf513 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf514 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf515 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf516 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf517 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine36 = union {
  object { BzPtch37 }
  object { Leaf504 }
  object { Leaf505 }
  object { Leaf506 }
  object { Leaf507 }
  object { Leaf508 }
  object { Leaf509 }
  object { Leaf510 }
  object { Leaf511 }
  object { Leaf512 }
  object { Leaf513 }
  object { Leaf514 }
  object { Leaf515 }
  object { Leaf516 }
  object { Leaf517 }
  rotate 45.0*z
  translate  <-0.3202, 0.512328, 0.0>
}
#declare BzPtch38 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf518 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf519 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf520 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf521 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf522 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf523 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf524 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf525 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf526 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf527 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf528 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf529 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf530 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf531 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine37 = union {
  object { BzPtch38 }
  object { Leaf518 }
  object { Leaf519 }
  object { Leaf520 }
  object { Leaf521 }
  object { Leaf522 }
  object { Leaf523 }
  object { Leaf524 }
  object { Leaf525 }
  object { Leaf526 }
  object { Leaf527 }
  object { Leaf528 }
  object { Leaf529 }
  object { Leaf530 }
  object { Leaf531 }
  rotate 135.0*z
  translate  <-0.890125, 0.441088, 0.0>
}
#declare BzPtch39 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf532 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf533 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf534 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf535 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf536 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf537 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf538 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf539 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf540 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf541 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf542 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf543 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf544 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf545 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine38 = union {
  object { BzPtch39 }
  object { Leaf532 }
  object { Leaf533 }
  object { Leaf534 }
  object { Leaf535 }
  object { Leaf536 }
  object { Leaf537 }
  object { Leaf538 }
  object { Leaf539 }
  object { Leaf540 }
  object { Leaf541 }
  object { Leaf542 }
  object { Leaf543 }
  object { Leaf544 }
  object { Leaf545 }
  rotate -135.0*z
  translate  <-0.890125, -0.152584, 0.0>
}
#declare BzPtch40 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf546 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf547 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf548 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf549 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf550 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf551 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf552 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf553 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf554 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf555 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf556 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf557 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf558 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf559 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine39 = union {
  object { BzPtch40 }
  object { Leaf546 }
  object { Leaf547 }
  object { Leaf548 }
  object { Leaf549 }
  object { Leaf550 }
  object { Leaf551 }
  object { Leaf552 }
  object { Leaf553 }
  object { Leaf554 }
  object { Leaf555 }
  object { Leaf556 }
  object { Leaf557 }
  object { Leaf558 }
  object { Leaf559 }
  rotate -45.0*z
  translate  <-0.296453, -0.437547, 0.0>
}
#declare Plant4 = union {
  object { Vine32 }
  object { Vine33 }
  object { Vine34 }
  object { Vine35 }
  object { Vine36 }
  object { Vine37 }
  object { Vine38 }
  object { Vine39 }
}
union { // LampPost4
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Cast_Iron
    }
    scale <0.45, 0.49, 25.0>
    translate  <-0.499505, 0.0002, -21.16>
  }
  object { Bend4 }
  torus { // Torus61
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.66, 0.66, 0.7>
    translate  <-0.50123, 0.0, 3.8>
  }
  torus { // Torus62
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale 0.7
    translate  <-0.50123, 0.0, 3.95>
  }
  torus { // Torus63
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.72, 0.72, 0.7>
    translate  <-0.50123, 0.0, 4.1>
  }
  torus { // Torus64
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.73, 0.73, 0.7>
    translate  <-0.50123, 0.0, 4.25>
  }
  torus { // Torus65
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.73, 0.73, 0.7>
    translate  <-0.50123, 0.0, 4.4>
  }
  torus { // Torus66
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.74, 0.74, 0.7>
    translate  <-0.50123, 0.0, 4.55>
  }
  torus { // Torus67
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.75, 0.75, 0.7>
    translate  <-0.50123, 0.0, 4.7>
  }
  torus { // Torus68
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.76, 0.76, 0.7>
    translate  <-0.50123, 0.0, 4.85>
  }
  torus { // Torus69
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.77, 0.77, 0.7>
    translate  <-0.50123, 0.0, 5.0>
  }
  torus { // Torus70
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.78, 0.78, 0.7>
    translate  <-0.50123, 0.0, 5.15>
  }
  torus { // Torus71
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.79, 0.79, 0.7>
    translate  <-0.50123, 0.0, 5.3>
  }
  torus { // Torus72
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.8, 0.8, 0.7>
    translate  <-0.50123, 0.0, 5.45>
  }
  torus { // Torus73
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.82, 0.82, 0.7>
    translate  <-0.50123, 0.0, 5.6>
  }
  torus { // Torus74
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.62, 0.62, 0.7>
    translate  <-0.50123, 0.0, 3.65>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wicker
    }
    scale <0.9, 0.9, 0.05>
    translate  <-0.459413, 0.012187, 3.619668>
  }
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.5
    texture {
      Flat_Black_Metal
    }
    scale <1.0, 1.0, 1.5>
    rotate <180.0, 0.0, 180.0>
    translate  <-9.5, 0.0, -0.760139>
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      Glass3
    }
    scale 1.5
    translate  <-9.5, 0.0, -3.0>
  }
  object { Plant4 }
  scale 0.08
  rotate -90.0*z
  translate  <-4.0, -0.4, 1.7>
}


#declare Bend3 = difference {
  torus { // Torus45
    1.5, 0.14  rotate -x*90
    texture {
      Black_Cast_Iron
    }
    scale <3.0, 3.0, 3.5>
    rotate -90.0*x
    translate  <-5.002083, 0.0, -1.194055>
  }
  box { // Chop3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Cast_Iron
    }
    scale 9.0
    translate  <-7.58343, 0.0, -10.192638>
  }
}
#declare BzPtch25 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf336 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf337 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf338 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf339 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf340 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf341 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf342 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf343 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf344 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf345 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf346 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf347 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf348 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf349 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine24 = union {
  object { BzPtch25 }
  object { Leaf336 }
  object { Leaf337 }
  object { Leaf338 }
  object { Leaf339 }
  object { Leaf340 }
  object { Leaf341 }
  object { Leaf342 }
  object { Leaf343 }
  object { Leaf344 }
  object { Leaf345 }
  object { Leaf346 }
  object { Leaf347 }
  object { Leaf348 }
  object { Leaf349 }
}
#declare BzPtch26 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf350 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf351 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf352 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf353 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf354 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf355 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf356 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf357 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf358 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf359 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf360 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf361 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf362 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf363 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine25 = union {
  object { BzPtch26 }
  object { Leaf350 }
  object { Leaf351 }
  object { Leaf352 }
  object { Leaf353 }
  object { Leaf354 }
  object { Leaf355 }
  object { Leaf356 }
  object { Leaf357 }
  object { Leaf358 }
  object { Leaf359 }
  object { Leaf360 }
  object { Leaf361 }
  object { Leaf362 }
  object { Leaf363 }
  rotate -180.0*z
  translate  <-1.0801, 0.061138, 0.0>
}
#declare BzPtch27 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf364 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf365 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf366 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf367 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf368 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf369 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf370 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf371 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf372 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf373 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf374 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf375 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf376 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf377 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine26 = union {
  object { BzPtch27 }
  object { Leaf364 }
  object { Leaf365 }
  object { Leaf366 }
  object { Leaf367 }
  object { Leaf368 }
  object { Leaf369 }
  object { Leaf370 }
  object { Leaf371 }
  object { Leaf372 }
  object { Leaf373 }
  object { Leaf374 }
  object { Leaf375 }
  object { Leaf376 }
  object { Leaf377 }
  rotate -90.0*z
  translate  <-0.676403, -0.4138, 0.0>
}
#declare BzPtch28 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf378 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf379 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf380 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf381 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf382 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf383 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf384 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf385 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf386 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf387 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf388 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf389 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf390 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf391 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine27 = union {
  object { BzPtch28 }
  object { Leaf378 }
  object { Leaf379 }
  object { Leaf380 }
  object { Leaf381 }
  object { Leaf382 }
  object { Leaf383 }
  object { Leaf384 }
  object { Leaf385 }
  object { Leaf386 }
  object { Leaf387 }
  object { Leaf388 }
  object { Leaf389 }
  object { Leaf390 }
  object { Leaf391 }
  rotate 90.0*z
  translate  <-0.486428, 0.512328, 0.0>
}
#declare BzPtch29 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf392 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf393 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf394 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf395 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf396 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf397 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf398 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf399 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf400 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf401 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf402 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf403 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf404 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf405 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine28 = union {
  object { BzPtch29 }
  object { Leaf392 }
  object { Leaf393 }
  object { Leaf394 }
  object { Leaf395 }
  object { Leaf396 }
  object { Leaf397 }
  object { Leaf398 }
  object { Leaf399 }
  object { Leaf400 }
  object { Leaf401 }
  object { Leaf402 }
  object { Leaf403 }
  object { Leaf404 }
  object { Leaf405 }
  rotate 45.0*z
  translate  <-0.3202, 0.512328, 0.0>
}
#declare BzPtch30 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf406 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf407 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf408 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf409 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf410 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf411 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf412 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf413 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf414 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf415 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf416 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf417 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf418 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf419 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine29 = union {
  object { BzPtch30 }
  object { Leaf406 }
  object { Leaf407 }
  object { Leaf408 }
  object { Leaf409 }
  object { Leaf410 }
  object { Leaf411 }
  object { Leaf412 }
  object { Leaf413 }
  object { Leaf414 }
  object { Leaf415 }
  object { Leaf416 }
  object { Leaf417 }
  object { Leaf418 }
  object { Leaf419 }
  rotate 135.0*z
  translate  <-0.890125, 0.441088, 0.0>
}
#declare BzPtch31 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf420 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf421 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf422 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf423 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf424 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf425 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf426 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf427 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf428 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf429 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf430 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf431 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf432 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf433 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine30 = union {
  object { BzPtch31 }
  object { Leaf420 }
  object { Leaf421 }
  object { Leaf422 }
  object { Leaf423 }
  object { Leaf424 }
  object { Leaf425 }
  object { Leaf426 }
  object { Leaf427 }
  object { Leaf428 }
  object { Leaf429 }
  object { Leaf430 }
  object { Leaf431 }
  object { Leaf432 }
  object { Leaf433 }
  rotate -135.0*z
  translate  <-0.890125, -0.152584, 0.0>
}
#declare BzPtch32 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf434 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf435 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf436 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf437 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf438 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf439 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf440 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf441 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf442 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf443 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf444 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf445 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf446 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf447 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine31 = union {
  object { BzPtch32 }
  object { Leaf434 }
  object { Leaf435 }
  object { Leaf436 }
  object { Leaf437 }
  object { Leaf438 }
  object { Leaf439 }
  object { Leaf440 }
  object { Leaf441 }
  object { Leaf442 }
  object { Leaf443 }
  object { Leaf444 }
  object { Leaf445 }
  object { Leaf446 }
  object { Leaf447 }
  rotate -45.0*z
  translate  <-0.296453, -0.437547, 0.0>
}
#declare Plant3 = union {
  object { Vine24 }
  object { Vine25 }
  object { Vine26 }
  object { Vine27 }
  object { Vine28 }
  object { Vine29 }
  object { Vine30 }
  object { Vine31 }
}
union { // LampPost3
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Cast_Iron
    }
    scale <0.45, 0.49, 25.0>
    translate  <-0.499505, 0.0002, -21.16>
  }
  object { Bend3 }
  torus { // Torus46
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.66, 0.66, 0.7>
    translate  <-0.50123, 0.0, 3.8>
  }
  torus { // Torus47
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale 0.7
    translate  <-0.50123, 0.0, 3.95>
  }
  torus { // Torus48
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.72, 0.72, 0.7>
    translate  <-0.50123, 0.0, 4.1>
  }
  torus { // Torus49
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.73, 0.73, 0.7>
    translate  <-0.50123, 0.0, 4.25>
  }
  torus { // Torus50
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.73, 0.73, 0.7>
    translate  <-0.50123, 0.0, 4.4>
  }
  torus { // Torus51
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.74, 0.74, 0.7>
    translate  <-0.50123, 0.0, 4.55>
  }
  torus { // Torus52
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.75, 0.75, 0.7>
    translate  <-0.50123, 0.0, 4.7>
  }
  torus { // Torus53
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.76, 0.76, 0.7>
    translate  <-0.50123, 0.0, 4.85>
  }
  torus { // Torus54
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.77, 0.77, 0.7>
    translate  <-0.50123, 0.0, 5.0>
  }
  torus { // Torus55
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.78, 0.78, 0.7>
    translate  <-0.50123, 0.0, 5.15>
  }
  torus { // Torus56
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.79, 0.79, 0.7>
    translate  <-0.50123, 0.0, 5.3>
  }
  torus { // Torus57
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.8, 0.8, 0.7>
    translate  <-0.50123, 0.0, 5.45>
  }
  torus { // Torus58
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.82, 0.82, 0.7>
    translate  <-0.50123, 0.0, 5.6>
  }
  torus { // Torus59
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.62, 0.62, 0.7>
    translate  <-0.50123, 0.0, 3.65>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wicker
    }
    scale <0.9, 0.9, 0.05>
    translate  <-0.459413, 0.012187, 3.619668>
  }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.5
    texture {
      Flat_Black_Metal
    }
    scale <1.0, 1.0, 1.5>
    rotate <180.0, 0.0, 180.0>
    translate  <-9.5, 0.0, -0.760139>
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      Glass3
    }
    scale 1.5
    translate  <-9.5, 0.0, -3.0>
  }
  object { Plant3 }
  scale 0.08
  rotate -90.0*z
  translate  <-10.5, -0.2, 1.7>
}


#declare Bend2 = difference {
  torus { // Torus30
    1.5, 0.14  rotate -x*90
    texture {
      Black_Cast_Iron
    }
    scale <3.0, 3.0, 3.5>
    rotate -90.0*x
    translate  <-5.002083, 0.0, -1.194055>
  }
  box { // Chop2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Cast_Iron
    }
    scale 9.0
    translate  <-7.58343, 0.0, -10.192638>
  }
}
#declare BzPtch17 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf224 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf225 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf226 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf227 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf228 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf229 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf230 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf231 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf232 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf233 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf234 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf235 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf236 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf237 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine16 = union {
  object { BzPtch17 }
  object { Leaf224 }
  object { Leaf225 }
  object { Leaf226 }
  object { Leaf227 }
  object { Leaf228 }
  object { Leaf229 }
  object { Leaf230 }
  object { Leaf231 }
  object { Leaf232 }
  object { Leaf233 }
  object { Leaf234 }
  object { Leaf235 }
  object { Leaf236 }
  object { Leaf237 }
}
#declare BzPtch18 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf238 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf239 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf240 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf241 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf242 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf243 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf244 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf245 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf246 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf247 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf248 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf249 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf250 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf251 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine17 = union {
  object { BzPtch18 }
  object { Leaf238 }
  object { Leaf239 }
  object { Leaf240 }
  object { Leaf241 }
  object { Leaf242 }
  object { Leaf243 }
  object { Leaf244 }
  object { Leaf245 }
  object { Leaf246 }
  object { Leaf247 }
  object { Leaf248 }
  object { Leaf249 }
  object { Leaf250 }
  object { Leaf251 }
  rotate -180.0*z
  translate  <-1.0801, 0.061138, 0.0>
}
#declare BzPtch19 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf252 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf253 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf254 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf255 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf256 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf257 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf258 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf259 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf260 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf261 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf262 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf263 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf264 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf265 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine18 = union {
  object { BzPtch19 }
  object { Leaf252 }
  object { Leaf253 }
  object { Leaf254 }
  object { Leaf255 }
  object { Leaf256 }
  object { Leaf257 }
  object { Leaf258 }
  object { Leaf259 }
  object { Leaf260 }
  object { Leaf261 }
  object { Leaf262 }
  object { Leaf263 }
  object { Leaf264 }
  object { Leaf265 }
  rotate -90.0*z
  translate  <-0.676403, -0.4138, 0.0>
}
#declare BzPtch20 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf266 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf267 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf268 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf269 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf270 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf271 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf272 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf273 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf274 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf275 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf276 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf277 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf278 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf279 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine19 = union {
  object { BzPtch20 }
  object { Leaf266 }
  object { Leaf267 }
  object { Leaf268 }
  object { Leaf269 }
  object { Leaf270 }
  object { Leaf271 }
  object { Leaf272 }
  object { Leaf273 }
  object { Leaf274 }
  object { Leaf275 }
  object { Leaf276 }
  object { Leaf277 }
  object { Leaf278 }
  object { Leaf279 }
  rotate 90.0*z
  translate  <-0.486428, 0.512328, 0.0>
}
#declare BzPtch21 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf280 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf281 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf282 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf283 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf284 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf285 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf286 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf287 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf288 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf289 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf290 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf291 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf292 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf293 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine20 = union {
  object { BzPtch21 }
  object { Leaf280 }
  object { Leaf281 }
  object { Leaf282 }
  object { Leaf283 }
  object { Leaf284 }
  object { Leaf285 }
  object { Leaf286 }
  object { Leaf287 }
  object { Leaf288 }
  object { Leaf289 }
  object { Leaf290 }
  object { Leaf291 }
  object { Leaf292 }
  object { Leaf293 }
  rotate 45.0*z
  translate  <-0.3202, 0.512328, 0.0>
}
#declare BzPtch22 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf294 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf295 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf296 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf297 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf298 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf299 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf300 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf301 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf302 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf303 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf304 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf305 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf306 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf307 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine21 = union {
  object { BzPtch22 }
  object { Leaf294 }
  object { Leaf295 }
  object { Leaf296 }
  object { Leaf297 }
  object { Leaf298 }
  object { Leaf299 }
  object { Leaf300 }
  object { Leaf301 }
  object { Leaf302 }
  object { Leaf303 }
  object { Leaf304 }
  object { Leaf305 }
  object { Leaf306 }
  object { Leaf307 }
  rotate 135.0*z
  translate  <-0.890125, 0.441088, 0.0>
}
#declare BzPtch23 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf308 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf309 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf310 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf311 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf312 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf313 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf314 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf315 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf316 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf317 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf318 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf319 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf320 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf321 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine22 = union {
  object { BzPtch23 }
  object { Leaf308 }
  object { Leaf309 }
  object { Leaf310 }
  object { Leaf311 }
  object { Leaf312 }
  object { Leaf313 }
  object { Leaf314 }
  object { Leaf315 }
  object { Leaf316 }
  object { Leaf317 }
  object { Leaf318 }
  object { Leaf319 }
  object { Leaf320 }
  object { Leaf321 }
  rotate -135.0*z
  translate  <-0.890125, -0.152584, 0.0>
}
#declare BzPtch24 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf322 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf323 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf324 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf325 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf326 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf327 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf328 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf329 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf330 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf331 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf332 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf333 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf334 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf335 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine23 = union {
  object { BzPtch24 }
  object { Leaf322 }
  object { Leaf323 }
  object { Leaf324 }
  object { Leaf325 }
  object { Leaf326 }
  object { Leaf327 }
  object { Leaf328 }
  object { Leaf329 }
  object { Leaf330 }
  object { Leaf331 }
  object { Leaf332 }
  object { Leaf333 }
  object { Leaf334 }
  object { Leaf335 }
  rotate -45.0*z
  translate  <-0.296453, -0.437547, 0.0>
}
#declare Plant2 = union {
  object { Vine16 }
  object { Vine17 }
  object { Vine18 }
  object { Vine19 }
  object { Vine20 }
  object { Vine21 }
  object { Vine22 }
  object { Vine23 }
}
union { // LampPost2
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Black_Cast_Iron
    }
    scale <0.45, 0.49, 25.0>
    translate  <-0.499505, 0.0002, -21.16>
  }
  object { Bend2 }
  torus { // Torus31
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.66, 0.66, 0.7>
    translate  <-0.50123, 0.0, 3.8>
  }
  torus { // Torus32
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale 0.7
    translate  <-0.50123, 0.0, 3.95>
  }
  torus { // Torus33
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.72, 0.72, 0.7>
    translate  <-0.50123, 0.0, 4.1>
  }
  torus { // Torus34
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.73, 0.73, 0.7>
    translate  <-0.50123, 0.0, 4.25>
  }
  torus { // Torus35
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.73, 0.73, 0.7>
    translate  <-0.50123, 0.0, 4.4>
  }
  torus { // Torus36
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.74, 0.74, 0.7>
    translate  <-0.50123, 0.0, 4.55>
  }
  torus { // Torus37
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.75, 0.75, 0.7>
    translate  <-0.50123, 0.0, 4.7>
  }
  torus { // Torus38
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.76, 0.76, 0.7>
    translate  <-0.50123, 0.0, 4.85>
  }
  torus { // Torus39
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.77, 0.77, 0.7>
    translate  <-0.50123, 0.0, 5.0>
  }
  torus { // Torus40
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.78, 0.78, 0.7>
    translate  <-0.50123, 0.0, 5.15>
  }
  torus { // Torus41
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.79, 0.79, 0.7>
    translate  <-0.50123, 0.0, 5.3>
  }
  torus { // Torus42
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.8, 0.8, 0.7>
    translate  <-0.50123, 0.0, 5.45>
  }
  torus { // Torus43
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.82, 0.82, 0.7>
    translate  <-0.50123, 0.0, 5.6>
  }
  torus { // Torus44
    1.5, 0.1  rotate -x*90
    texture {
      Wicker
    }
    scale <0.62, 0.62, 0.7>
    translate  <-0.50123, 0.0, 3.65>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Wicker
    }
    scale <0.9, 0.9, 0.05>
    translate  <-0.459413, 0.012187, 3.619668>
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.5
    texture {
      Flat_Black_Metal
    }
    scale <1.0, 1.0, 1.5>
    rotate <180.0, 0.0, 180.0>
    translate  <-9.5, 0.0, -0.760139>
  }
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      Glass3
    }
    scale 1.5
    translate  <-9.5, 0.0, -3.0>
  }
  object { Plant2 }
  scale 0.08
  rotate 90.0*z
  translate  <1.0, 1.5, 1.7>
}


#declare Bend1 = difference {
  torus { // Torus2
    1.5, 0.14  rotate -x*90
    texture {
      Black_Cast_Iron
    }
    scale <3.0, 3.0, 3.5>
    rotate -90.0*x
    translate  <-5.002083, 0.0, -1.194055>
  }
  box { // Chop1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Black_Cast_Iron
    }
    scale 9.0
    translate  <-7.58343, 0.0, -10.192638>
  }
}
#declare BzPtch9 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf112 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf113 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf114 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf115 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf116 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf117 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf118 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf119 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf120 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf121 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf122 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf123 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf124 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf125 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine8 = union {
  object { BzPtch9 }
  object { Leaf112 }
  object { Leaf113 }
  object { Leaf114 }
  object { Leaf115 }
  object { Leaf116 }
  object { Leaf117 }
  object { Leaf118 }
  object { Leaf119 }
  object { Leaf120 }
  object { Leaf121 }
  object { Leaf122 }
  object { Leaf123 }
  object { Leaf124 }
  object { Leaf125 }
}
#declare BzPtch10 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf126 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf127 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf128 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf129 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf130 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf131 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf132 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf133 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf134 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf135 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf136 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf137 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf138 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf139 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine9 = union {
  object { BzPtch10 }
  object { Leaf126 }
  object { Leaf127 }
  object { Leaf128 }
  object { Leaf129 }
  object { Leaf130 }
  object { Leaf131 }
  object { Leaf132 }
  object { Leaf133 }
  object { Leaf134 }
  object { Leaf135 }
  object { Leaf136 }
  object { Leaf137 }
  object { Leaf138 }
  object { Leaf139 }
  rotate -180.0*z
  translate  <-1.0801, 0.061138, 0.0>
}
#declare BzPtch11 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf140 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf141 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf142 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf143 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf144 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf145 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf146 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf147 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf148 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf149 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf150 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf151 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf152 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf153 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine10 = union {
  object { BzPtch11 }
  object { Leaf140 }
  object { Leaf141 }
  object { Leaf142 }
  object { Leaf143 }
  object { Leaf144 }
  object { Leaf145 }
  object { Leaf146 }
  object { Leaf147 }
  object { Leaf148 }
  object { Leaf149 }
  object { Leaf150 }
  object { Leaf151 }
  object { Leaf152 }
  object { Leaf153 }
  rotate -90.0*z
  translate  <-0.676403, -0.4138, 0.0>
}
#declare BzPtch12 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf154 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf155 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf156 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf157 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf158 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf159 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf160 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf161 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf162 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf163 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf164 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf165 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf166 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf167 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine11 = union {
  object { BzPtch12 }
  object { Leaf154 }
  object { Leaf155 }
  object { Leaf156 }
  object { Leaf157 }
  object { Leaf158 }
  object { Leaf159 }
  object { Leaf160 }
  object { Leaf161 }
  object { Leaf162 }
  object { Leaf163 }
  object { Leaf164 }
  object { Leaf165 }
  object { Leaf166 }
  object { Leaf167 }
  rotate 90.0*z
  translate  <-0.486428, 0.512328, 0.0>
}
#declare BzPtch13 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf168 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf169 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf170 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf171 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf172 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf173 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf174 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf175 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf176 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf177 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf178 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf179 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf180 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf181 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine12 = union {
  object { BzPtch13 }
  object { Leaf168 }
  object { Leaf169 }
  object { Leaf170 }
  object { Leaf171 }
  object { Leaf172 }
  object { Leaf173 }
  object { Leaf174 }
  object { Leaf175 }
  object { Leaf176 }
  object { Leaf177 }
  object { Leaf178 }
  object { Leaf179 }
  object { Leaf180 }
  object { Leaf181 }
  rotate 45.0*z
  translate  <-0.3202, 0.512328, 0.0>
}
#declare BzPtch14 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf182 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf183 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf184 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf185 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf186 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf187 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf188 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf189 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf190 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf191 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf192 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf193 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf194 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf195 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine13 = union {
  object { BzPtch14 }
  object { Leaf182 }
  object { Leaf183 }
  object { Leaf184 }
  object { Leaf185 }
  object { Leaf186 }
  object { Leaf187 }
  object { Leaf188 }
  object { Leaf189 }
  object { Leaf190 }
  object { Leaf191 }
  object { Leaf192 }
  object { Leaf193 }
  object { Leaf194 }
  object { Leaf195 }
  rotate 135.0*z
  translate  <-0.890125, 0.441088, 0.0>
}
#declare BzPtch15 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf196 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf197 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf198 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf199 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf200 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf201 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf202 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf203 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf204 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf205 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf206 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf207 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf208 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf209 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine14 = union {
  object { BzPtch15 }
  object { Leaf196 }
  object { Leaf197 }
  object { Leaf198 }
  object { Leaf199 }
  object { Leaf200 }
  object { Leaf201 }
  object { Leaf202 }
  object { Leaf203 }
  object { Leaf204 }
  object { Leaf205 }
  object { Leaf206 }
  object { Leaf207 }
  object { Leaf208 }
  object { Leaf209 }
  rotate -135.0*z
  translate  <-0.890125, -0.152584, 0.0>
}
#declare BzPtch16 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.416043, 0.282939, -0.439343>, <-2.040107, -0.139139, 0.138579>, <-0.040107, -0.139139, 0.138579>, <0.583957, 0.282939, -0.439343>, 
      <-2.040107, 2.234351, 2.275928>, <-2.040107, 1.234351, 2.275928>, <-0.040107, 1.234351, 2.275928>, <-0.040107, 2.234351, 2.275928>, 
      <-2.664171, 3.159026, 4.969435>, <-2.664171, 2.159026, 4.969435>, <-0.664171, 2.159026, 4.969435>, <-0.664171, 3.159026, 4.969435>, 
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.583957, 0.282939, -0.439343>, <1.208021, 0.705017, -1.017265>, <-0.791979, 0.705017, -1.017265>, <-1.416043, 0.282939, -0.439343>, 
      <-0.040107, 2.234351, 2.275928>, <-0.040107, 3.234351, 2.275928>, <-2.040107, 3.234351, 2.275928>, <-2.040107, 2.234351, 2.275928>, 
      <-0.664171, 3.159026, 4.969435>, <-0.664171, 4.159026, 4.969435>, <-2.664171, 4.159026, 4.969435>, <-2.664171, 3.159026, 4.969435>, 
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.832086, 3.159026, 6.553392>, <-1.832086, 2.159026, 6.553392>, <0.167914, 2.159026, 6.553392>, <0.167914, 3.159026, 6.553392>, 
      <-1.000000, 3.159026, 8.137349>, <-1.000000, 2.159026, 8.137349>, <1.000000, 2.159026, 8.137349>, <1.000000, 3.159026, 8.137349>, 
      <-1.000000, 3.159026, 10.137349>, <-1.000000, 2.159026, 10.137349>, <1.000000, 2.159026, 10.137349>, <1.000000, 3.159026, 10.137349>, 
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.167914, 3.159026, 6.553392>, <0.167914, 4.159026, 6.553392>, <-1.832086, 4.159026, 6.553392>, <-1.832086, 3.159026, 6.553392>, 
      <1.000000, 3.159026, 8.137349>, <1.000000, 4.159026, 8.137349>, <-1.000000, 4.159026, 8.137349>, <-1.000000, 3.159026, 8.137349>, 
      <1.000000, 3.159026, 10.137349>, <1.000000, 4.159026, 10.137349>, <-1.000000, 4.159026, 10.137349>, <-1.000000, 3.159026, 10.137349>, 
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.687968, 2.678305, 11.964664>, <-0.687968, 1.678305, 11.964664>, <1.312032, 1.678305, 11.964664>, <1.312032, 2.678305, 11.964664>, 
      <-0.375936, 2.197583, 13.791979>, <-0.375936, 1.197583, 13.791979>, <1.624064, 1.197583, 13.791979>, <1.624064, 2.197583, 13.791979>, 
      <0.248129, 0.860861, 15.329641>, <0.248129, -0.139139, 15.329641>, <2.248129, -0.139139, 15.329641>, <2.248129, 0.860861, 15.329641>, 
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.312032, 2.678305, 11.964664>, <1.312032, 3.678305, 11.964664>, <-0.687968, 3.678305, 11.964664>, <-0.687968, 2.678305, 11.964664>, 
      <1.624064, 2.197583, 13.791979>, <1.624064, 3.197583, 13.791979>, <-0.375936, 3.197583, 13.791979>, <-0.375936, 2.197583, 13.791979>, 
      <2.248129, 0.860861, 15.329641>, <2.248129, 1.860861, 15.329641>, <0.248129, 1.860861, 15.329641>, <0.248129, 0.860861, 15.329641>, 
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.063904, 0.430431, 17.560810>, <-0.063904, -0.569569, 17.560810>, <1.936096, -0.569569, 17.560810>, <1.936096, 0.430431, 17.560810>, 
      <-0.375936, 0.000000, 19.791979>, <-0.375936, -1.000000, 19.791979>, <1.624064, -1.000000, 19.791979>, <1.624064, 0.000000, 19.791979>, 
      <-1.000000, 0.000000, 22.000000>, <-1.000000, -1.000000, 22.000000>, <1.000000, -1.000000, 22.000000>, <1.000000, 0.000000, 22.000000>, 
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.936096, 0.430431, 17.560810>, <1.936096, 1.430431, 17.560810>, <-0.063904, 1.430431, 17.560810>, <-0.063904, 0.430431, 17.560810>, 
      <1.624064, 0.000000, 19.791979>, <1.624064, 1.000000, 19.791979>, <-0.375936, 1.000000, 19.791979>, <-0.375936, 0.000000, 19.791979>, 
      <1.000000, 0.000000, 22.000000>, <1.000000, 1.000000, 22.000000>, <-1.000000, 1.000000, 22.000000>, <-1.000000, 0.000000, 22.000000>, 
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, -0.823032, 24.000000>, <-1.000000, -1.823032, 24.000000>, <1.000000, -1.823032, 24.000000>, <1.000000, -0.823032, 24.000000>, 
      <-1.000000, -1.646064, 26.000000>, <-1.000000, -2.646064, 26.000000>, <1.000000, -2.646064, 26.000000>, <1.000000, -1.646064, 26.000000>, 
      <-1.000000, -9.700914, 27.603404>, <-1.000000, -7.895922, 27.759237>, <1.000000, -7.895922, 27.759237>, <1.000000, -9.389248, 28.070903>, 
      <-1.000000, -11.740769, 11.419417>, <-1.000000, -12.740769, 11.419417>, <1.000000, -12.740769, 11.419417>, <1.000000, -11.740769, 11.419417>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, -0.823032, 24.000000>, <1.000000, 0.176968, 24.000000>, <-1.000000, 0.176968, 24.000000>, <-1.000000, -0.823032, 24.000000>, 
      <1.000000, -1.646064, 26.000000>, <1.000000, -0.646064, 26.000000>, <-1.000000, -0.646064, 26.000000>, <-1.000000, -1.646064, 26.000000>, 
      <1.000000, -9.389248, 28.070903>, <1.000000, -10.882575, 28.382569>, <-1.000000, -11.505906, 27.447571>, <-1.000000, -9.700914, 27.603404>, 
      <1.000000, -11.740769, 11.419417>, <1.000000, -10.740769, 11.419417>, <-1.000000, -10.740769, 11.419417>, <-1.000000, -11.740769, 11.419417>
    }
  }
  texture {
    Greenery
  }
  scale <0.03, 0.03, 0.15>
  rotate -90.0*z
  translate  <0.788179, 0.0, 2.214407>
}
#declare Leaf210 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 12.0, -180.0>
  translate  <1.142751, -0.020587, 4.578943>
}
#declare Leaf211 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.143491, 4.942714>
}
#declare Leaf212 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, -30.0, -210.0>
  translate  <1.049694, -0.199794, 3.992214>
}
#declare Leaf213 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -20.0, -180.0>
  translate  <1.041945, -0.032302, 5.594787>
}
#declare Leaf214 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.917971, -0.310944, 5.799003>
}
#declare Leaf215 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 50.0>
  translate  <1.055886, 0.408102, 5.331613>
}
#declare Leaf216 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 10.0, -120.0>
  translate  <1.100046, 0.201401, 3.560928>
}
#declare Leaf217 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-30.0, 10.0, -240.0>
  translate  <1.052509, -0.199142, 3.176939>
}
#declare Leaf218 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -30.0, 0.0>
  translate  <0.593159, 0.042149, 2.578632>
}
#declare Leaf219 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <10.0, -20.0, 110.0>
  translate  <0.988011, -0.271529, 2.877276>
}
#declare Leaf220 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-10.0, -10.0, 80.0>
  translate  <0.904973, -0.306119, 4.314353>
}
#declare Leaf221 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <0.0, 10.0, 70.0>
  translate  <1.001435, -0.252878, 3.992214>
}
#declare Leaf222 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <-20.0, 0.0, -150.0>
  translate  <1.093184, 0.168149, 4.215305>
}
#declare Leaf223 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.860586, -1.814115, 0.000000>, <-1.954422, -2.046471, -0.142093>, <-0.954422, -2.046471, -0.142093>, <0.045578, -2.046471, -0.142093>, 
      <-5.973264, -0.674702, 0.521007>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.790010, -0.046471, 0.000000>, <-1.999107, -0.371770, -0.189457>, <-0.999107, -0.371770, -0.189457>, <0.000893, -0.371770, -0.189457>, 
      <-2.814115, 0.907058, 0.000000>, <-1.860586, 1.371770, 0.000000>, <-0.767644, 1.790010, -0.189457>, <0.232356, 1.790010, -0.189457>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.045578, -2.046471, -0.142093>, <1.045578, -2.046471, -0.142093>, <2.045578, -2.046471, -0.142093>, <2.814115, -1.721173, 0.094729>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.446007, -1.000000, 0.094729>, 
      <0.000893, -0.371770, -0.189457>, <1.000893, -0.371770, -0.189457>, <2.000893, -0.371770, -0.189457>, <3.446007, 0.000000, 0.094729>, 
      <0.232356, 1.790010, -0.189457>, <1.232356, 1.790010, -0.189457>, <2.232356, 1.790010, -0.189457>, <3.000000, 1.000000, 0.094729>
    }
  }
  texture {
    Greenery
  }
  scale 0.1
  rotate <15.0, -15.0, 30.0>
  translate  <0.95789, 0.277805, 5.983959>
}
#declare Vine15 = union {
  objec